/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.process;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;

public class ParserAutomaton
implements Serializable {
    private String[] tsymbols;
    private String[] ntsymbols;
    private byte[] productionsymbols;
    private byte[] productionlengths;
    private String[] errors;
    private short[][] actions;
    private short[] eofactions;
    private static final byte ERROR = 0;
    private static final byte SHIFT = 1;
    private static final byte REDUCE = 2;
    private static final byte ACCEPT = 3;
    private short[][] transitions;
    private static final long serialVersionUID = 8045275977315821215L;

    public ParserAutomaton(int tsymbolcount, int ntsymbolcount, int productioncount, int errorcount, int statecount) {
        this.tsymbols = new String[tsymbolcount];
        Arrays.fill(this.tsymbols, "noname");
        this.ntsymbols = new String[ntsymbolcount];
        Arrays.fill(this.ntsymbols, "noname");
        this.productionsymbols = new byte[productioncount];
        Arrays.fill(this.productionsymbols, (byte)0);
        this.productionlengths = new byte[productioncount];
        Arrays.fill(this.productionlengths, (byte)0);
        this.errors = new String[errorcount];
        Arrays.fill(this.errors, "Unexpected token.");
        this.actions = new short[statecount][tsymbolcount];
        int i = 0;
        while (i < statecount) {
            Arrays.fill(this.actions[i], (short)0);
            ++i;
        }
        this.eofactions = new short[statecount];
        Arrays.fill(this.eofactions, (short)0);
        this.transitions = new short[statecount][ntsymbolcount];
        i = 0;
        while (i < statecount) {
            Arrays.fill(this.transitions[i], (short)0);
            ++i;
        }
    }

    public int getError(int state) {
        if ((this.eofactions[state] & 3) != 0) {
            throw new IllegalArgumentException("Action is not a 'error' action");
        }
        return this.eofactions[state] >> 2;
    }

    public int getError(int state, int tsymbol) {
        if ((this.actions[state][tsymbol] & 3) != 0) {
            throw new IllegalArgumentException("Action is not a 'error' action");
        }
        return this.actions[state][tsymbol] >> 2;
    }

    public int getErrorCount() {
        return this.errors.length;
    }

    public String getErrorMessage(int index) {
        if (index == 0) {
            return "Unexpected token.";
        }
        return this.errors[index - 1];
    }

    public String getNonterminal(int index) {
        if (index < 0 || index >= this.ntsymbols.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.ntsymbols[index];
    }

    public int getNonterminalCount() {
        return this.ntsymbols.length;
    }

    public int getProductionCount() {
        return this.productionsymbols.length;
    }

    public int getProductionLength(int index) {
        return this.productionlengths[index];
    }

    public int getProductionSymbol(int index) {
        return this.productionsymbols[index];
    }

    public int getReduceProduction(int state) {
        if ((this.eofactions[state] & 3) != 2 && (this.eofactions[state] & 3) != 3) {
            throw new IllegalArgumentException("Action is not a 'reduce' action");
        }
        return this.eofactions[state] >> 2;
    }

    public int getReduceProduction(int state, int tsymbol) {
        if ((this.actions[state][tsymbol] & 3) != 2) {
            throw new IllegalArgumentException("Action is not a 'reduce' action");
        }
        return this.actions[state][tsymbol] >> 2;
    }

    public int getShiftTransition(int state, int tsymbol) {
        if ((this.actions[state][tsymbol] & 3) != 1) {
            throw new IllegalArgumentException("Action is not a 'shift' action");
        }
        return this.actions[state][tsymbol] >> 2;
    }

    public int getStateCount() {
        return this.actions.length;
    }

    public String getTerminal(int index) {
        if (index < 0 || index >= this.tsymbols.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.tsymbols[index];
    }

    public int getTerminalCount() {
        return this.tsymbols.length;
    }

    public int getTransition(int state, int ntsymbol) {
        return this.transitions[state][ntsymbol];
    }

    public boolean isAcceptAction(int state) {
        return (this.eofactions[state] & 3) == 3;
    }

    public boolean isErrorAction(int state) {
        return (this.eofactions[state] & 3) == 0;
    }

    public boolean isErrorAction(int state, int tsymbol) {
        return (this.actions[state][tsymbol] & 3) == 0;
    }

    public boolean isReduceAction(int state) {
        return (this.eofactions[state] & 3) == 2;
    }

    public boolean isReduceAction(int state, int tsymbol) {
        return (this.actions[state][tsymbol] & 3) == 2;
    }

    public boolean isShiftAction(int state, int tsymbol) {
        return (this.actions[state][tsymbol] & 3) == 1;
    }

    public void setAcceptAction(int state, int production) {
        if (production < 0 && production >= this.productionsymbols.length) {
            throw new IndexOutOfBoundsException();
        }
        this.eofactions[state] = (short)(3 | production << 2);
    }

    public void setErrorAction(int state, int tsymbol, int error) {
        if (error < 0 && error >= this.errors.length) {
            throw new IndexOutOfBoundsException();
        }
        this.actions[state][tsymbol] = (short)(error << 2);
    }

    public void setErrorMessage(int index, String message) {
        if (index > 0) {
            this.errors[index - 1] = message;
        }
    }

    public void setNonterminal(int index, String symbol) {
        if (index < 0 || index >= this.ntsymbols.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ntsymbols[index] = symbol;
    }

    public void setProductionLength(int index, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.productionlengths[index] = (byte)length;
    }

    public void setProductionSymbol(int index, int symbol) {
        if (symbol < 0 || symbol >= this.ntsymbols.length) {
            throw new IndexOutOfBoundsException();
        }
        this.productionsymbols[index] = (byte)symbol;
    }

    public void setReduceAction(int state, int production) {
        if (production < 0 && production >= this.productionsymbols.length) {
            throw new IndexOutOfBoundsException();
        }
        this.eofactions[state] = (short)(2 | production << 2);
    }

    public void setReduceAction(int state, int tsymbol, int production) {
        if (production < 0 && production >= this.productionsymbols.length) {
            throw new IndexOutOfBoundsException();
        }
        this.actions[state][tsymbol] = (short)(2 | production << 2);
    }

    public void setShiftAction(int state, int tsymbol, int nextstate) {
        if (nextstate < 0 && nextstate >= this.actions.length) {
            throw new IndexOutOfBoundsException();
        }
        this.actions[state][tsymbol] = (short)(1 | nextstate << 2);
    }

    public void setTerminal(int index, String symbol) {
        if (index < 0 || index >= this.tsymbols.length) {
            throw new IndexOutOfBoundsException();
        }
        this.tsymbols[index] = symbol;
    }

    public void setTransition(int state, int ntsymbol, int nextstate) {
        this.transitions[state][ntsymbol] = (short)nextstate;
    }

    public String toString() {
        int j;
        DecimalFormat format = new DecimalFormat("00");
        StringBuffer buffer = new StringBuffer();
        buffer.append("Terminal symbols:");
        int i = 0;
        while (i < this.tsymbols.length) {
            buffer.append(this.tsymbols[i]);
            buffer.append("(");
            buffer.append(String.valueOf(i));
            buffer.append(") ");
            ++i;
        }
        buffer.append("\n");
        buffer.append("Non terminal symbols:");
        i = 0;
        while (i < this.ntsymbols.length) {
            buffer.append(this.ntsymbols[i]);
            buffer.append("(");
            buffer.append(String.valueOf(i));
            buffer.append(") ");
            ++i;
        }
        buffer.append("\n");
        int max = 0;
        i = 0;
        while (i < this.tsymbols.length) {
            max = Math.max(max, this.tsymbols[i].length());
            ++i;
        }
        i = 0;
        while (i < this.ntsymbols.length) {
            max = Math.max(max, this.ntsymbols[i].length());
            ++i;
        }
        max = Math.max(max, 3);
        i = 0;
        while (i < max) {
            buffer.append("    ");
            j = 0;
            while (j < this.tsymbols.length) {
                if (max - i - 1 < this.tsymbols[j].length()) {
                    buffer.append(this.tsymbols[j].charAt(max - i - 1));
                    buffer.append("   ");
                } else {
                    buffer.append("    ");
                }
                ++j;
            }
            if (max - i - 1 < "EOF".length()) {
                buffer.append("EOF".charAt(max - i - 1));
                buffer.append("   ");
            } else {
                buffer.append("    ");
            }
            buffer.append("  ");
            j = 0;
            while (j < this.ntsymbols.length) {
                if (max - i - 1 < this.ntsymbols[j].length()) {
                    buffer.append(this.ntsymbols[j].charAt(max - i - 1));
                    buffer.append("  ");
                } else {
                    buffer.append("   ");
                }
                ++j;
            }
            buffer.append("\n");
            ++i;
        }
        i = 0;
        while (i < this.actions.length) {
            buffer.append(String.valueOf(format.format(i)) + "  ");
            j = 0;
            while (j < this.actions[i].length) {
                if ((this.actions[i][j] & 3) == 1) {
                    buffer.append("s");
                    buffer.append(format.format(this.actions[i][j] >> 2));
                    buffer.append(" ");
                } else if ((this.actions[i][j] & 3) == 2) {
                    buffer.append("r");
                    buffer.append(format.format(this.actions[i][j] >> 2));
                    buffer.append(" ");
                } else if ((this.actions[i][j] & 3) == 0) {
                    buffer.append("--- ");
                } else if ((this.actions[i][j] & 3) == 3) {
                    buffer.append("a");
                    buffer.append(format.format(this.actions[i][j] >> 2));
                    buffer.append(" ");
                }
                ++j;
            }
            if ((this.eofactions[i] & 3) == 1) {
                buffer.append("s");
                buffer.append(format.format(this.eofactions[i] >> 2));
                buffer.append(" ");
            } else if ((this.eofactions[i] & 3) == 2) {
                buffer.append("r");
                buffer.append(format.format(this.eofactions[i] >> 2));
                buffer.append(" ");
            } else if ((this.eofactions[i] & 3) == 0) {
                buffer.append("--- ");
            } else if ((this.eofactions[i] & 3) == 3) {
                buffer.append("a");
                buffer.append(format.format(this.eofactions[i] >> 2));
                buffer.append(" ");
            }
            buffer.append("| ");
            j = 0;
            while (j < this.transitions[i].length) {
                if (this.transitions[i][j] > 0) {
                    buffer.append(format.format(this.transitions[i][j]));
                    buffer.append(" ");
                } else {
                    buffer.append("-- ");
                }
                ++j;
            }
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }
}

