/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.process;

import net.sourceforge.chaperon.common.IntegerList;
import net.sourceforge.chaperon.process.PatternAutomaton;

public class PatternProcessor {
    private PatternAutomaton automaton;
    private IntegerList states = new IntegerList();
    private IntegerList statekeys = new IntegerList();
    private IntegerList newstates = new IntegerList();
    private IntegerList newstatekeys = new IntegerList();
    private IntegerList historystates = new IntegerList();
    private IntegerList dependencies = new IntegerList();
    private String[] groups = new String[10];
    private int[] groupstarts = new int[10];
    private int[] groupends = new int[10];
    private int groupcount = 0;
    private boolean verbose = false;

    public PatternProcessor() {
    }

    public PatternProcessor(PatternAutomaton automaton) {
        this.setPatternAutomaton(automaton);
    }

    public String getGroup() {
        return this.groups[0];
    }

    public String getGroup(int group) {
        return this.groups[group];
    }

    public int getGroupCount() {
        return this.groupcount;
    }

    public int getGroupEnd() {
        return this.groupends[0];
    }

    public int getGroupEnd(int group) {
        return this.groupends[group];
    }

    public int getGroupStart() {
        return this.groupstarts[0];
    }

    public int getGroupStart(int group) {
        return this.groupstarts[group];
    }

    public boolean match(char[] text) {
        return this.match(text, 0);
    }

    public boolean match(char[] text, int start) {
        int key;
        int state;
        if (this.automaton == null) {
            throw new NullPointerException("PatternAutomaton is null");
        }
        if (this.automaton.getStateCount() <= 0) {
            return false;
        }
        int i = 0;
        while (i <= this.automaton.getGroupCount()) {
            this.groupstarts[i] = start;
            this.groupends[i] = start;
            this.groups[i] = null;
            ++i;
        }
        int position = start;
        boolean found = false;
        int foundkey = 0;
        int foundPosition = start;
        this.states.clear();
        this.states.push(this.automaton.getFirstState());
        this.newstates.clear();
        this.statekeys.clear();
        this.statekeys.push(0);
        this.historystates.clear();
        this.historystates.push(this.automaton.getFirstState());
        this.dependencies.clear();
        this.dependencies.push(0);
        while (!this.states.isEmpty() && position <= text.length) {
            state = this.states.pop();
            key = this.statekeys.pop();
            if (this.automaton.isFinalState(state)) {
                found = true;
                foundkey = key;
                foundPosition = position;
            } else {
                switch (this.automaton.getType(state)) {
                    case 0: {
                        this.pushState(this.states, this.statekeys, state, key);
                        break;
                    }
                    case 1: {
                        if (position >= text.length || this.automaton.getIntervalBegin(state) > text[position] || this.automaton.getIntervalEnd(state) < text[position]) break;
                        this.pushState(this.newstates, this.newstatekeys, state, key);
                        break;
                    }
                    case 2: {
                        if (position >= text.length || this.automaton.getIntervalBegin(state) <= text[position] && this.automaton.getIntervalEnd(state) >= text[position]) break;
                        this.pushState(this.states, this.statekeys, state, key);
                        break;
                    }
                    case 3: {
                        this.pushState(this.newstates, this.newstatekeys, state, key);
                        break;
                    }
                    case 4: {
                        if (position == 0) {
                            this.pushState(this.states, this.statekeys, state, key);
                            break;
                        }
                        if (position == 1 && (text[position - 1] == '\n' && text[position] != '\r' || text[position - 1] == '\r')) {
                            this.pushState(this.states, this.statekeys, state, key);
                            break;
                        }
                        if (text[position - 1] != '\r' && (text[position - 1] != '\n' || text[position] == '\r')) break;
                        this.pushState(this.states, this.statekeys, state, key);
                        break;
                    }
                    case 5: {
                        if (position >= text.length) {
                            this.pushState(this.states, this.statekeys, state, key);
                            break;
                        }
                        if (position + 1 == text.length && (text[position] == '\r' || text[position] == '\n')) {
                            this.pushState(this.states, this.statekeys, state, key);
                            break;
                        }
                        if (text[position] != '\r' && text[position] != '\n') break;
                        this.pushState(this.states, this.statekeys, state, key);
                        break;
                    }
                    case 6: {
                        this.pushState(this.states, this.statekeys, state, key);
                        break;
                    }
                    case 7: {
                        this.pushState(this.states, this.statekeys, state, key);
                        break;
                    }
                }
            }
            if (!this.states.isEmpty()) continue;
            IntegerList temp = this.newstates;
            this.newstates = this.states;
            this.states = temp;
            temp = this.newstatekeys;
            this.newstatekeys = this.statekeys;
            this.statekeys = temp;
            ++position;
        }
        position = foundPosition;
        key = foundkey;
        while (key != 0) {
            key = this.dependencies.get(key);
            state = this.historystates.get(key);
            switch (this.automaton.getType(state)) {
                case 1: {
                    --position;
                    break;
                }
                case 3: {
                    --position;
                    break;
                }
                case 6: {
                    if (this.groups[this.automaton.getGroupIndex(state)] != null) break;
                    this.groupstarts[this.automaton.getGroupIndex((int)state)] = position;
                    this.groups[this.automaton.getGroupIndex((int)state)] = new String(text, position, this.groupends[this.automaton.getGroupIndex(state)] - position);
                    break;
                }
                case 7: {
                    if (this.groups[this.automaton.getGroupIndex(state)] != null) break;
                    this.groupends[this.automaton.getGroupIndex((int)state)] = position;
                    break;
                }
            }
        }
        this.groupcount = this.automaton.getGroupCount();
        int i2 = this.groupcount - 1;
        while (i2 >= 0 && this.groups[i2] == null) {
            --this.groupcount;
            --i2;
        }
        return found;
    }

    private void pushState(IntegerList states, IntegerList keys, int state, int key) {
        states.push(this.automaton.getTransitions(state));
        this.historystates.push(this.automaton.getTransitions(state));
        int i = this.automaton.getTransitions(state).length;
        while (i > 0) {
            keys.push(this.dependencies.getCount());
            this.dependencies.push(key);
            --i;
        }
    }

    public boolean search(char[] text) {
        return this.search(text, 0);
    }

    public boolean search(char[] text, int start) {
        int position = start;
        while (position <= text.length) {
            if (this.match(text, position)) {
                return true;
            }
            ++position;
        }
        return false;
    }

    public void setPatternAutomaton(PatternAutomaton automaton) {
        if (automaton == null) {
            throw new NullPointerException();
        }
        this.automaton = automaton;
        if (this.groupstarts.length <= automaton.getGroupCount()) {
            this.groups = new String[automaton.getGroupCount() + 1];
            this.groupstarts = new int[automaton.getGroupCount() + 1];
            this.groupends = new int[automaton.getGroupCount() + 1];
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

