/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import net.sourceforge.chaperon.adapter.avalon.LexiconFactory;
import net.sourceforge.chaperon.build.LexicalAutomatonBuilder;
import net.sourceforge.chaperon.common.Decoder;
import net.sourceforge.chaperon.model.lexicon.Lexicon;
import net.sourceforge.chaperon.process.LexicalAutomaton;
import net.sourceforge.chaperon.process.PatternProcessor;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.store.Store;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PatternTransformer
extends AbstractTransformer
implements LogEnabled,
Composable,
Recyclable,
Disposable,
Parameterizable,
CacheableProcessingComponent {
    public static final String NS = "http://chaperon.sourceforge.net/schema/lexemes/1.0";
    private String lexicon = null;
    private Source lexiconSource = null;
    private Logger logger = null;
    private ComponentManager manager = null;
    private SourceResolver resolver = null;
    private LexicalAutomaton automaton = null;
    private PatternProcessor processor = new PatternProcessor();
    private boolean groups = false;
    private StringBuffer buffer = new StringBuffer();
    private StringBuffer output = new StringBuffer();

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.groups = parameters.getParameterAsBoolean("groups", false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setup(SourceResolver resolver, Map objectmodel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
        Store store = null;
        try {
            try {
                this.lexicon = src;
                this.lexiconSource = resolver.resolveURI(this.lexicon);
                store = (Store)this.manager.lookup(Store.TRANSIENT_STORE);
                LexicalAutomatonEntry entry = (LexicalAutomatonEntry)store.get((Object)this.lexiconSource.getURI());
                if (entry == null || entry.getValidity() == null || entry.getValidity().isValid(this.lexiconSource.getValidity()) <= 0) {
                    this.logger.info("(Re)building the automaton from '" + this.lexiconSource.getURI() + "'");
                    SAXConfigurationHandler confighandler = new SAXConfigurationHandler();
                    if (this.lexiconSource.getInputStream() == null) {
                        throw new ProcessingException("Source '" + this.lexiconSource.getURI() + "' not found");
                    }
                    SourceUtil.toSAX((ComponentManager)this.manager, (Source)this.lexiconSource, null, (ContentHandler)confighandler);
                    Configuration config = confighandler.getConfiguration();
                    Lexicon lexicon = LexiconFactory.createLexicon((Configuration)config);
                    LexicalAutomatonBuilder builder = new LexicalAutomatonBuilder(lexicon, this.logger);
                    this.automaton = builder.getLexicalAutomaton();
                    this.logger.info("Store automaton into store for '" + this.lexiconSource.getURI() + "'");
                    store.store((Object)this.lexiconSource.getURI(), (Object)new LexicalAutomatonEntry(this.automaton, this.lexiconSource.getValidity()));
                }
                this.logger.info("Getting automaton from store for '" + this.lexiconSource.getURI() + "'");
                this.automaton = entry.getLexicalAutomaton();
            }
            catch (ConfigurationException confige) {
                throw new ProcessingException("Error during retrieving the lexicon", (Throwable)confige);
            }
            catch (SourceException se) {
                throw new ProcessingException("Error during resolving of '" + src + "'.", (Throwable)se);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Could not lookup for component", (Throwable)ce);
            }
            Object var12_14 = null;
            if (store == null) return;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (store == null) throw throwable;
            this.manager.release(store);
            throw throwable;
        }
        this.manager.release((Component)store);
    }

    public Serializable getKey() {
        return this.lexiconSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.lexiconSource.getValidity();
    }

    public void recycle() {
        if (this.resolver != null && this.lexiconSource != null) {
            this.resolver.release(this.lexiconSource);
            this.lexiconSource = null;
        }
        this.automaton = null;
        super.recycle();
    }

    public void dispose() {
        if (this.resolver != null && this.lexiconSource != null) {
            this.resolver.release(this.lexiconSource);
            this.lexiconSource = null;
        }
        this.manager = null;
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.search();
        if (this.contentHandler != null) {
            this.contentHandler.startElement(uri, loc, raw, a);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.search();
        if (this.contentHandler != null) {
            this.contentHandler.endElement(uri, loc, raw);
        }
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        this.buffer.append(c, start, len);
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        this.buffer.append(c, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.search();
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        this.search();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, len);
        }
    }

    private void search() throws SAXException {
        if (this.buffer.length() <= 0) {
            return;
        }
        char[] text = this.buffer.toString().toCharArray();
        String[] groups = null;
        int lexemeindex = 0;
        int position = 0;
        this.output.setLength(0);
        do {
            String lexemesymbol = null;
            String lexemetext = null;
            lexemeindex = this.automaton.getLexemeCount() - 1;
            while (lexemeindex >= 0) {
                this.processor.setPatternAutomaton(this.automaton.getLexemeDefinition(lexemeindex));
                if (this.processor.match(text, position) && (lexemetext == null || this.processor.getGroup().length() >= lexemetext.length())) {
                    lexemesymbol = this.automaton.getLexemeSymbol(lexemeindex);
                    lexemetext = this.processor.getGroup();
                    if (this.groups) {
                        groups = new String[this.processor.getGroupCount()];
                        int group = 0;
                        while (group < this.processor.getGroupCount()) {
                            groups[group] = this.processor.getGroup(group);
                            ++group;
                        }
                    }
                }
                --lexemeindex;
            }
            if (lexemetext != null && lexemetext.length() > 0) {
                if (lexemesymbol != null) {
                    if (this.logger != null) {
                        this.logger.debug("Recognize token " + lexemesymbol + " with '" + Decoder.decode((String)lexemetext) + "'");
                    }
                    if (this.output.length() > 0) {
                        this.contentHandler.characters(this.output.toString().toCharArray(), 0, this.output.length());
                    }
                    this.output.setLength(0);
                    this.contentHandler.startPrefixMapping("", NS);
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute("", "symbol", "symbol", "CDATA", lexemesymbol);
                    atts.addAttribute("", "text", "text", "CDATA", lexemetext);
                    this.contentHandler.startElement(NS, "lexeme", "lexeme", atts);
                    if (this.groups) {
                        int group = 0;
                        while (group < groups.length) {
                            this.contentHandler.startElement(NS, "group", "group", new AttributesImpl());
                            this.contentHandler.characters(groups[group].toCharArray(), 0, groups[group].length());
                            this.contentHandler.endElement(NS, "group", "group");
                            ++group;
                        }
                    }
                    this.contentHandler.endElement(NS, "lexeme", "lexeme");
                    this.contentHandler.endPrefixMapping("");
                } else if (this.logger != null) {
                    this.logger.debug("Ignore lexeme with '" + Decoder.decode((String)lexemetext) + "'");
                }
                position += lexemetext.length();
                continue;
            }
            this.output.append(text[position]);
            ++position;
        } while (position < text.length);
        if (this.output.length() > 0) {
            this.contentHandler.characters(this.output.toString().toCharArray(), 0, this.output.length());
        }
        this.buffer.setLength(0);
    }

    public class LexicalAutomatonEntry
    implements Serializable {
        private SourceValidity validity = null;
        private LexicalAutomaton automaton = null;

        public LexicalAutomatonEntry(LexicalAutomaton automaton, SourceValidity validity) {
            this.automaton = automaton;
            this.validity = validity;
        }

        public SourceValidity getValidity() {
            return this.validity;
        }

        public LexicalAutomaton getLexicalAutomaton() {
            return this.automaton;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.validity);
            out.writeObject(this.automaton);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.validity = (SourceValidity)in.readObject();
            this.automaton = (LexicalAutomaton)in.readObject();
        }
    }
}

