/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.renderer.ExtendableRendererFactory;
import org.apache.cocoon.components.renderer.RendererFactory;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.apache.cocoon.util.ClassUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Options;
import org.apache.fop.configuration.ConfigurationParser;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.Renderer;
import org.xml.sax.ContentHandler;

public class FOPSerializer
extends AbstractSerializer
implements Composable,
Configurable,
CacheableProcessingComponent {
    protected static RendererFactory factory = ExtendableRendererFactory.getRendererFactoryImplementation();
    protected Driver driver;
    protected Renderer renderer;
    protected String mimetype;
    protected String rendererName;
    protected boolean setContentLength = true;
    protected Logger logger;
    private static boolean configured = false;
    protected ComponentManager manager;
    static /* synthetic */ Class class$org$apache$cocoon$serialization$FOPSerializer;

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.manager = componentManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(Configuration conf) throws ConfigurationException {
        block23: {
            this.logger = this.getLogger().getChildLogger("fop");
            MessageHandler.setScreenLogger((Logger)this.logger);
            Class clazz = class$org$apache$cocoon$serialization$FOPSerializer == null ? (class$org$apache$cocoon$serialization$FOPSerializer = FOPSerializer.class$("org.apache.cocoon.serialization.FOPSerializer")) : class$org$apache$cocoon$serialization$FOPSerializer;
            synchronized (clazz) {
                if (!configured) {
                    try {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Loading default configuration");
                        }
                        new Options();
                    }
                    catch (Exception e) {
                        this.getLogger().error("Cannot load default configuration. Proceeding.", (Throwable)e);
                    }
                    configured = true;
                }
            }
            this.setContentLength = conf.getChild("set-content-length").getValueAsBoolean(true);
            String configUrl = conf.getChild("user-config").getAttribute("src", null);
            if (configUrl != null) {
                this.getLogger().warn("Attribute src of user-config element is deprecated. Provide Cocoon URI as value of the element instead");
                try {
                    configUrl = new File(configUrl).toURL().toExternalForm();
                }
                catch (MalformedURLException e) {
                    this.getLogger().warn("Can not load config file " + configUrl, (Throwable)e);
                    configUrl = null;
                }
            } else {
                configUrl = conf.getChild("user-config").getValue(null);
            }
            if (configUrl != null) {
                Source configSource = null;
                SourceResolver resolver = null;
                try {
                    try {
                        resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                        configSource = resolver.resolveURI(configUrl);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Loading configuration from " + configSource.getURI());
                        }
                        SourceUtil.toSAX((Source)configSource, (ContentHandler)new ConfigurationParser());
                    }
                    catch (Exception e) {
                        this.getLogger().warn("Cannot load configuration from " + configUrl);
                        throw new ConfigurationException("Cannot load configuration from " + configUrl, (Throwable)e);
                    }
                    Object var8_9 = null;
                    if (null == resolver) break block23;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (null != resolver) {
                        resolver.release(configSource);
                        this.manager.release((Component)resolver);
                    }
                    throw throwable;
                }
                resolver.release(configSource);
                this.manager.release((Component)resolver);
            }
        }
        this.mimetype = conf.getAttribute("mime-type");
        Configuration[] parameters = conf.getChildren("parameter");
        int i = 0;
        while (true) {
            if (i >= parameters.length) {
                if (this.renderer == null) {
                    this.renderer = factory.createRenderer(this.mimetype);
                }
                if (this.renderer != null) break;
                throw new ConfigurationException("Could not autodetect renderer for FOPSerializer and no renderer was specified in the sitemap configuration.");
            }
            String name = parameters[i].getAttribute("name");
            if ("renderer".equals(name)) {
                this.rendererName = parameters[i].getAttribute("value");
                try {
                    this.renderer = (Renderer)ClassUtils.newInstance((String)this.rendererName);
                }
                catch (Exception ex) {
                    this.getLogger().error("Cannot load  class " + this.rendererName, (Throwable)ex);
                    throw new ConfigurationException("Cannot load class " + this.rendererName, (Throwable)ex);
                }
            }
            ++i;
        }
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public void setOutputStream(OutputStream out) {
        this.driver = new Driver();
        this.driver.setLogger(this.logger);
        if (this.rendererName == null) {
            this.renderer = factory.createRenderer(this.mimetype);
        } else {
            try {
                this.renderer = (Renderer)ClassUtils.newInstance((String)this.rendererName);
            }
            catch (Exception e) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Cannot load  class " + this.rendererName, (Throwable)e);
                }
                throw new CascadingRuntimeException("Cannot load class " + this.rendererName, (Throwable)e);
            }
        }
        this.driver.setRenderer(this.renderer);
        this.driver.setOutputStream(out);
        this.setContentHandler(this.driver.getContentHandler());
    }

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void recycle() {
        super.recycle();
        this.driver = null;
        this.renderer = null;
    }

    public boolean shouldSetContentLength() {
        return this.setContentLength;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

