/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.bean.BeanListener;
import org.apache.cocoon.bean.CocoonWrapper;
import org.apache.cocoon.bean.Target;
import org.apache.cocoon.bean.helpers.DelayedOutputStream;
import org.apache.cocoon.components.notification.DefaultNotifyingBuilder;
import org.apache.cocoon.components.notification.Notifier;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.components.notification.SimpleNotifyingBean;
import org.apache.cocoon.matching.helpers.WildcardHelper;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class CocoonBean
extends CocoonWrapper {
    private boolean followLinks = true;
    private boolean precompileOnly = false;
    private boolean confirmExtension = true;
    private String defaultFilename = "index";
    private List targets = new ArrayList();
    private boolean brokenLinkGenerate = false;
    private String brokenLinkExtension = "";
    private List excludePatterns = new ArrayList();
    private List includePatterns = new ArrayList();
    private List includeLinkExtensions = null;
    private Map allProcessedLinks;
    private Map allTranslatedLinks;
    private boolean initialized;
    private List listeners = new ArrayList();
    private boolean verbose;
    SourceResolver sourceResolver;

    public void initialize() throws Exception {
        if (!this.initialized) {
            super.initialize();
            if (this.targets.size() == 0 && !this.precompileOnly) {
                String error = "Please, specify at least one starting URI.";
                CocoonWrapper.log.fatalError(error);
                throw new ProcessingException(error);
            }
            this.sourceResolver = (SourceResolver)this.getComponentManager().lookup(SourceResolver.ROLE);
            this.initialized = true;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void setFollowLinks(boolean follow) {
        this.followLinks = follow;
    }

    public void setConfirmExtensions(boolean confirmExtension) {
        this.confirmExtension = confirmExtension;
    }

    public void setPrecompileOnly(boolean precompileOnly) {
        this.precompileOnly = precompileOnly;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDefaultFilename(String filename) {
        this.defaultFilename = filename;
    }

    public void setBrokenLinkGenerate(boolean brokenLinkGenerate) {
        this.brokenLinkGenerate = brokenLinkGenerate;
    }

    public void setBrokenLinkExtension(String brokenLinkExtension) {
        this.brokenLinkExtension = brokenLinkExtension;
    }

    public boolean followLinks() {
        return this.followLinks;
    }

    public boolean confirmExtensions() {
        return this.confirmExtension;
    }

    public void addTarget(String type, String root, String sourceURI, String destURI) throws IllegalArgumentException {
        Target target = new Target(type, root, sourceURI, destURI);
        target.setDefaultFilename(this.defaultFilename);
        target.setFollowLinks(this.followLinks);
        target.setConfirmExtension(this.confirmExtension);
        target.setLogger(this.logger);
        this.targets.add(target);
    }

    public void addTarget(String type, String sourceURI, String destURI) throws IllegalArgumentException {
        Target target = new Target(type, sourceURI, destURI);
        target.setDefaultFilename(this.defaultFilename);
        target.setFollowLinks(this.followLinks);
        target.setConfirmExtension(this.confirmExtension);
        target.setLogger(this.logger);
        this.targets.add(target);
    }

    public void addTarget(String sourceURI, String destURI) throws IllegalArgumentException {
        Target target = new Target(sourceURI, destURI);
        target.setDefaultFilename(this.defaultFilename);
        target.setFollowLinks(this.followLinks);
        target.setConfirmExtension(this.confirmExtension);
        target.setLogger(this.logger);
        this.targets.add(target);
    }

    public void addTargets(List uris, String destURI) throws IllegalArgumentException {
        Iterator i = uris.iterator();
        while (i.hasNext()) {
            Target target = new Target((String)i.next(), destURI);
            target.setDefaultFilename(this.defaultFilename);
            target.setFollowLinks(this.followLinks);
            target.setConfirmExtension(this.confirmExtension);
            target.setLogger(this.logger);
            this.targets.add(target);
        }
    }

    public void addTarget(String type, String root, String sourceURI, String destURI, boolean followLinks, boolean confirmExtension, String logger) throws IllegalArgumentException {
        Target target = root == null && type == null ? new Target(sourceURI, destURI) : (root == null ? new Target(type, sourceURI, destURI) : new Target(type, root, sourceURI, destURI));
        target.setDefaultFilename(this.defaultFilename);
        target.setFollowLinks(followLinks);
        target.setConfirmExtension(confirmExtension);
        target.setLogger(logger);
        this.targets.add(target);
    }

    public void addExcludePattern(String pattern) {
        int[] preparedPattern = WildcardHelper.compilePattern(pattern);
        this.excludePatterns.add(preparedPattern);
    }

    public void addIncludePattern(String pattern) {
        int[] preparedPattern = WildcardHelper.compilePattern(pattern);
        this.includePatterns.add(preparedPattern);
    }

    public void addIncludeLinkExtension(String extension) {
        if (this.includeLinkExtensions == null) {
            this.includeLinkExtensions = new ArrayList();
        }
        this.includeLinkExtensions.add(extension);
    }

    public void addListener(BeanListener listener) {
        this.listeners.add(listener);
    }

    public void pageGenerated(String sourceURI, String destURI, int pageSize, int linksInPage, int newLinksInPage, int pagesRemaining, int pagesComplete, long timeTaken) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            BeanListener l = (BeanListener)i.next();
            l.pageGenerated(sourceURI, destURI, pageSize, linksInPage, newLinksInPage, pagesRemaining, pagesComplete, timeTaken);
        }
    }

    public void sendMessage(String msg) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            BeanListener l = (BeanListener)i.next();
            l.messageGenerated(msg);
        }
    }

    public void sendWarning(String uri, String warning) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            BeanListener l = (BeanListener)i.next();
            l.warningGenerated(uri, warning);
        }
    }

    public void sendBrokenLinkWarning(String uri, String warning) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            BeanListener l = (BeanListener)i.next();
            l.brokenLinkFound(uri, "", warning, null);
        }
    }

    public void pageSkipped(String uri, String message) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            BeanListener l = (BeanListener)i.next();
            l.pageSkipped(uri, message);
        }
    }

    public void dispose() {
        if (this.initialized && this.sourceResolver != null) {
            this.getComponentManager().release((Component)this.sourceResolver);
            this.sourceResolver = null;
        }
    }

    public void process() throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        this.allProcessedLinks = new HashMap();
        this.allTranslatedLinks = new HashMap();
        HashMap<Target, Target> targetMap = new HashMap<Target, Target>();
        Iterator i = this.targets.iterator();
        while (i.hasNext()) {
            Target target = (Target)i.next();
            targetMap.put(target, target);
        }
        int nCount = 0;
        while (targetMap.size() > 0) {
            Target target = (Target)targetMap.keySet().iterator().next();
            try {
                if (!this.allProcessedLinks.containsKey(target)) {
                    if (this.precompileOnly) {
                        this.processXSP(target.getSourceURI());
                    } else if (this.followLinks) {
                        i = this.processTarget(target).iterator();
                        while (i.hasNext()) {
                            Target link = (Target)i.next();
                            targetMap.put(link, link);
                        }
                    } else {
                        this.processTarget(target);
                    }
                }
            }
            catch (ResourceNotFoundException rnfe) {
                this.sendBrokenLinkWarning(target.getSourceURI(), rnfe.getMessage());
            }
            targetMap.remove(target);
            ++nCount;
            if (!CocoonWrapper.log.isInfoEnabled()) continue;
            CocoonWrapper.log.info("  Memory used: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
            CocoonWrapper.log.info("  Processed, Translated & Left: " + this.allProcessedLinks.size() + ", " + this.allTranslatedLinks.size() + ", " + targetMap.size());
        }
        if (nCount == 0) {
            super.precompile();
        }
    }

    /*
     * Loose catch block
     */
    private Collection processTarget(Target target) throws Exception {
        ArrayList<Target> targets;
        block29: {
            int status = 0;
            int linkCount = 0;
            int newLinkCount = 0;
            int pageSize = 0;
            long startTimeMillis = System.currentTimeMillis();
            if (target.confirmExtensions() && null == this.allTranslatedLinks.get(target.getSourceURI())) {
                String mimeType = this.getType(target.getDeparameterizedSourceURI(), target.getParameters());
                target.setMimeType(mimeType);
                this.allTranslatedLinks.put(target.getSourceURI(), target.getDestinationURI());
            }
            this.allProcessedLinks.put(target, target);
            HashMap<String, String> translatedLinks = new HashMap<String, String>();
            targets = new ArrayList<Target>();
            if (target.followLinks() && target.confirmExtensions() && this.isCrawlablePage(target)) {
                Iterator i = this.getLinks(target.getDeparameterizedSourceURI(), target.getParameters()).iterator();
                while (i.hasNext()) {
                    Target linkTarget;
                    block27: {
                        String linkURI = (String)i.next();
                        linkTarget = target.getDerivedTarget(linkURI);
                        if (linkTarget == null) {
                            this.pageSkipped(linkURI, "link does not share same root as parent");
                            continue;
                        }
                        if (!this.isIncluded(linkTarget.getSourceURI())) {
                            this.pageSkipped(linkTarget.getSourceURI(), "matched include/exclude rules");
                            continue;
                        }
                        if (null == this.allTranslatedLinks.get(linkTarget.getSourceURI())) {
                            try {
                                String mimeType = this.getType(target.getDeparameterizedSourceURI(), target.getParameters());
                                target.setMimeType(mimeType);
                                this.allTranslatedLinks.put(target.getSourceURI(), target.getDestinationURI());
                                CocoonWrapper.log.info("  Link translated: " + linkTarget.getSourceURI());
                                targets.add(linkTarget);
                            }
                            catch (ProcessingException pe) {
                                this.sendBrokenLinkWarning(linkTarget.getSourceURI(), pe.getMessage());
                                if (!this.brokenLinkGenerate) break block27;
                                targets.add(linkTarget);
                            }
                        }
                    }
                    translatedLinks.put(linkTarget.getOriginalSourceURI(), linkTarget.getTranslatedURI(target.getPath()));
                }
                linkCount = translatedLinks.size();
            }
            try {
                DelayedOutputStream output;
                block28: {
                    output = new DelayedOutputStream();
                    ArrayList gatheredLinks = !target.confirmExtensions() && target.followLinks() && this.isCrawlablePage(target) ? new ArrayList() : null;
                    status = this.getPage(target.getDeparameterizedSourceURI(), this.getLastModified(target), target.getParameters(), target.confirmExtensions() ? translatedLinks : null, gatheredLinks, output);
                    if (status >= 400) {
                        throw new ProcessingException("Resource not found: " + status);
                    }
                    if (gatheredLinks == null) break block28;
                    Iterator it = gatheredLinks.iterator();
                    while (it.hasNext()) {
                        String linkURI = (String)it.next();
                        Target linkTarget = target.getDerivedTarget(linkURI);
                        if (linkTarget == null) {
                            this.pageSkipped(linkURI, "link does not share same root as parent");
                            continue;
                        }
                        if (!this.isIncluded(linkTarget.getSourceURI())) {
                            this.pageSkipped(linkTarget.getSourceURI(), "matched include/exclude rules");
                            continue;
                        }
                        targets.add(linkTarget);
                    }
                    linkCount = gatheredLinks.size();
                }
                Object var16_17 = null;
                if (output == null || status == -1) break block29;
                ModifiableSource source = this.getSource(target);
                try {
                    try {
                        pageSize = output.size();
                        OutputStream stream = source.getOutputStream();
                        output.setFileOutputStream(stream);
                        output.flush();
                        output.close();
                        this.pageGenerated(target.getSourceURI(), target.getAuthlessDestURI(), pageSize, linkCount, newLinkCount, 0, 0, System.currentTimeMillis() - startTimeMillis);
                    }
                    catch (IOException ioex) {
                        CocoonWrapper.log.warn(ioex.toString());
                        Object var20_30 = null;
                        this.releaseSource((Source)source);
                        break block29;
                    }
                    Object var20_29 = null;
                    this.releaseSource((Source)source);
                    break block29;
                }
                catch (Throwable throwable) {
                    Object var20_31 = null;
                    this.releaseSource((Source)source);
                    throw throwable;
                }
                {
                    catch (ProcessingException pe) {
                        output.close();
                        output = null;
                        this.resourceUnavailable(target);
                        this.sendBrokenLinkWarning(target.getSourceURI(), DefaultNotifyingBuilder.getRootCause((Throwable)((Object)pe)).getMessage());
                        Object var16_18 = null;
                        if (output == null || status == -1) break block29;
                        source = this.getSource(target);
                        try {
                            try {
                                pageSize = output.size();
                                OutputStream stream = source.getOutputStream();
                                output.setFileOutputStream(stream);
                                output.flush();
                                output.close();
                                this.pageGenerated(target.getSourceURI(), target.getAuthlessDestURI(), pageSize, linkCount, newLinkCount, 0, 0, System.currentTimeMillis() - startTimeMillis);
                            }
                            catch (IOException ioex) {
                                CocoonWrapper.log.warn(ioex.toString());
                                Object var20_33 = null;
                                this.releaseSource((Source)source);
                                break block29;
                            }
                            Object var20_32 = null;
                            this.releaseSource((Source)source);
                            break block29;
                        }
                        catch (Throwable throwable) {
                            Object var20_34 = null;
                            this.releaseSource((Source)source);
                            throw throwable;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var16_19 = null;
                    if (output != null && status != -1) {
                        source = this.getSource(target);
                        try {
                            try {
                                pageSize = output.size();
                                OutputStream stream = source.getOutputStream();
                                output.setFileOutputStream(stream);
                                output.flush();
                                output.close();
                                this.pageGenerated(target.getSourceURI(), target.getAuthlessDestURI(), pageSize, linkCount, newLinkCount, 0, 0, System.currentTimeMillis() - startTimeMillis);
                            }
                            catch (IOException ioex) {
                                CocoonWrapper.log.warn(ioex.toString());
                                Object var20_36 = null;
                                this.releaseSource((Source)source);
                            }
                            Object var20_35 = null;
                            this.releaseSource((Source)source);
                        }
                        catch (Throwable throwable2) {
                            Object var20_37 = null;
                            this.releaseSource((Source)source);
                            throw throwable2;
                        }
                    }
                    throw throwable;
                }
            }
            catch (Exception rnfe) {
                CocoonWrapper.log.warn("Could not process URI: " + target.getSourceURI());
                this.sendBrokenLinkWarning(target.getSourceURI(), "URI not found");
            }
        }
        return targets;
    }

    private void resourceUnavailable(Target target) throws IOException, ProcessingException {
        if (this.brokenLinkGenerate) {
            if (this.brokenLinkExtension != null) {
                target.setExtraExtension(this.brokenLinkExtension);
            }
            SimpleNotifyingBean n = new SimpleNotifyingBean(this);
            n.setType("resource-not-found");
            n.setTitle("Resource not Found");
            n.setSource("Cocoon commandline (Main.java)");
            n.setMessage("Page Not Available.");
            n.setDescription("The requested resource couldn't be found.");
            n.addExtraDescription("request-uri", target.getSourceURI());
            n.addExtraDescription("missing-file", target.getSourceURI());
            ModifiableSource source = this.getSource(target);
            try {
                OutputStream stream = source.getOutputStream();
                PrintStream out = new PrintStream(stream);
                Notifier.notify((Notifying)n, out, "text/html");
                out.flush();
                out.close();
                Object var7_6 = null;
                this.releaseSource((Source)source);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.releaseSource((Source)source);
                throw throwable;
            }
        }
    }

    public ModifiableSource getSource(Target target) throws IOException, ProcessingException {
        String finalDestinationURI = target.getDestinationURI();
        Source src = this.sourceResolver.resolveURI(finalDestinationURI);
        if (!(src instanceof ModifiableSource)) {
            this.sourceResolver.release(src);
            throw new ProcessingException("Source is not Modifiable: " + finalDestinationURI);
        }
        return (ModifiableSource)src;
    }

    public long getLastModified(Target target) throws IOException, ProcessingException {
        ModifiableSource src = this.getSource(target);
        long lastModified = src.getLastModified();
        this.releaseSource((Source)src);
        return lastModified;
    }

    public void releaseSource(Source source) {
        this.sourceResolver.release(source);
    }

    private boolean isIncluded(String uri) {
        int[] pattern;
        Iterator i;
        boolean included;
        HashMap map = new HashMap();
        if (this.includePatterns.size() == 0) {
            included = true;
        } else {
            included = false;
            i = this.includePatterns.iterator();
            while (i.hasNext()) {
                pattern = (int[])i.next();
                if (!WildcardHelper.match(map, uri, pattern)) continue;
                included = true;
                break;
            }
        }
        if (this.excludePatterns.size() != 0) {
            i = this.excludePatterns.iterator();
            while (i.hasNext()) {
                pattern = (int[])i.next();
                if (!WildcardHelper.match(map, uri, pattern)) continue;
                included = false;
                break;
            }
        }
        return included;
    }

    private boolean isCrawlablePage(Target target) {
        if (this.includeLinkExtensions == null) {
            return true;
        }
        return this.includeLinkExtensions.contains(target.getExtension());
    }
}

