/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.caching.ComponentCacheKey;

public final class PipelineCacheKey
implements Serializable {
    private List keys;
    private int hashCode = 0;
    private String toString;

    public PipelineCacheKey() {
        this.keys = new ArrayList(6);
    }

    public PipelineCacheKey(int size) {
        this.keys = new ArrayList(size);
    }

    public void addKey(ComponentCacheKey key) {
        this.keys.add(key);
        this.hashCode = 0;
        this.toString = null;
    }

    public void removeLastKey() {
        this.keys.remove(this.keys.size() - 1);
        this.hashCode = 0;
        this.toString = null;
    }

    public void removeUntilCachePoint() {
        this.hashCode = 0;
        this.toString = null;
        int keyCount = this.keys.size();
        while (keyCount > 0) {
            if (((ComponentCacheKey)this.keys.get(keyCount - 1)).isCachePoint()) {
                this.keys.remove(keyCount - 1);
                return;
            }
            this.keys.remove(keyCount - 1);
            --keyCount;
        }
    }

    public int size() {
        return this.keys.size();
    }

    public boolean equals(Object object) {
        if (object instanceof PipelineCacheKey) {
            PipelineCacheKey pck = (PipelineCacheKey)object;
            int len = this.keys.size();
            if (pck.keys.size() == len) {
                boolean cont = true;
                int i = 0;
                while (i < len && cont) {
                    cont = this.keys.get(i).equals(pck.keys.get(i));
                    ++i;
                }
                return cont;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int len = this.keys.size();
            int i = 0;
            while (i < len) {
                this.hashCode += this.keys.get(i).hashCode();
                ++i;
            }
            if (len % 2 == 0) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public PipelineCacheKey copy() {
        int len = this.keys.size();
        PipelineCacheKey pck = new PipelineCacheKey(len);
        int i = 0;
        while (i < len) {
            pck.keys.add(this.keys.get(i));
            ++i;
        }
        return pck;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("PK");
            int len = this.keys.size();
            int i = 0;
            while (i < len) {
                buffer.append('_').append(this.keys.get(i).toString());
                ++i;
            }
            this.toString = buffer.toString();
        }
        return this.toString;
    }
}

