/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.language.programming.LanguageCompiler;

public abstract class AbstractJavaCompiler
extends AbstractLogEnabled
implements LanguageCompiler,
Recyclable {
    protected String file;
    protected String srcDir;
    protected String destDir;
    protected String classpath;
    protected String encoding = null;
    protected InputStream errors;

    public void setFile(String file) {
        this.file = file;
    }

    public void setSource(String srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestination(String destDir) {
        this.destDir = destDir;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public List getErrors() throws IOException {
        return this.parseStream(new BufferedReader(new InputStreamReader(this.errors)));
    }

    protected abstract List parseStream(BufferedReader var1) throws IOException;

    protected List fillArguments(List arguments) {
        arguments.add("-d");
        arguments.add(this.destDir);
        arguments.add("-classpath");
        arguments.add(this.classpath);
        arguments.add("-sourcepath");
        arguments.add(this.srcDir);
        arguments.add("-O");
        if (this.encoding != null) {
            arguments.add("-encoding");
            arguments.add(this.encoding);
        }
        return arguments;
    }

    protected String[] toStringArray(List arguments) {
        String[] args = new String[arguments.size() + 1];
        int i = 0;
        while (i < arguments.size()) {
            args[i] = (String)arguments.get(i);
            ++i;
        }
        args[i] = this.file;
        return args;
    }

    public void recycle() {
        this.file = null;
        this.srcDir = null;
        this.destDir = null;
        this.classpath = null;
        this.encoding = null;
        this.errors = null;
    }

    public abstract boolean compile() throws IOException;
}

