/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.Context;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.URIAbsolutizer;

public class ContextSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Composable,
Disposable,
Contextualizable,
ThreadSafe,
URIAbsolutizer {
    protected Context envContext;
    protected ComponentManager manager;
    protected SourceResolver resolver;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void dispose() {
        if (this.resolver != null) {
            this.manager.release((Component)this.resolver);
            this.resolver = null;
        }
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this.envContext = (Context)context.get((Object)"environment-context");
    }

    public Source getSource(String location, Map parameters) throws SourceException, MalformedURLException, IOException {
        int pos;
        String path;
        String actualPath;
        URL u;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating source object for " + location);
        }
        if (this.resolver == null) {
            try {
                this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
            }
            catch (ComponentException ce) {
                throw new SourceException("Unable to lookup source resolver.", (Throwable)ce);
            }
        }
        if ((u = (actualPath = this.envContext.getRealPath(path = location.substring((pos = location.indexOf(":/")) + 1))) != null ? new File(actualPath).toURL() : this.envContext.getResource(path)) != null) {
            return this.resolver.resolveURI(u.toExternalForm());
        }
        String message = location + " could not be found. (possible context problem)";
        this.getLogger().info(message);
        throw new MalformedURLException(message);
    }

    public void release(Source source) {
        if (null != source) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Releasing source " + source.getURI());
            }
            this.resolver.release(source);
        }
    }

    public String absolutize(String baseURI, String location) {
        return SourceUtil.absolutize((String)baseURI, (String)location, (boolean)true);
    }
}

