/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.ChainedConfiguration;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.ExtendedComponentSelector;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.DelayedRefreshSourceWrapper;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.cocoon.environment.wrapper.MutableEnvironmentFacade;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.ContentHandler;

public class TreeProcessor
extends AbstractLogEnabled
implements ThreadSafe,
Processor,
Composable,
Configurable,
RoleManageable,
Contextualizable,
Disposable {
    public static final String COCOON_REDIRECT_ATTR = "cocoon: redirect url";
    private static final String XCONF_URL = "resource://org/apache/cocoon/components/treeprocessor/treeprocessor-builtins.xml";
    protected TreeProcessor parent;
    protected Context context;
    protected ComponentManager manager;
    protected RoleManager roleManager;
    protected String language;
    protected ExtendedComponentSelector builderSelector;
    protected ProcessingNode rootNode;
    protected List disposableNodes;
    protected long lastModified = 0L;
    protected Source source;
    protected long lastModifiedDelay;
    protected Configuration currentLanguage;
    protected String fileName;
    protected boolean checkReload;
    protected Configuration componentConfigurations;
    protected Map sitemapComponentConfigurations;
    protected ComponentManager sitemapComponentManager;

    public TreeProcessor() {
        this.language = "sitemap";
        this.checkReload = true;
        this.lastModifiedDelay = 1000L;
    }

    protected TreeProcessor(TreeProcessor parent, ComponentManager manager, String language) {
        this.parent = parent;
        this.language = language == null ? parent.language : language;
        this.enableLogging(parent.getLogger());
        this.context = parent.context;
        this.roleManager = parent.roleManager;
        this.builderSelector = parent.builderSelector;
        this.checkReload = parent.checkReload;
        this.lastModifiedDelay = parent.lastModifiedDelay;
        this.manager = manager;
    }

    public TreeProcessor createChildProcessor(ComponentManager manager, String language, Source source) throws Exception {
        TreeProcessor child = new TreeProcessor(this, manager, language);
        child.source = new DelayedRefreshSourceWrapper(source, this.lastModifiedDelay);
        return child;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void setRoleManager(RoleManager rm) {
        this.roleManager = rm;
    }

    public void configure(Configuration config) throws ConfigurationException {
        Configuration builtin;
        this.fileName = config.getAttribute("file", null);
        this.checkReload = config.getAttributeAsBoolean("check-reload", true);
        Configuration rootLangConfig = config.getChild("root-language", false);
        if (rootLangConfig != null) {
            this.language = rootLangConfig.getAttribute("name");
        }
        String xconfURL = config.getAttribute("config", XCONF_URL);
        this.lastModifiedDelay = config.getChild("reload").getAttributeAsLong("delay", 1000L);
        SourceResolver resolver = null;
        try {
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                Source source = resolver.resolveURI(xconfURL);
                try {
                    SAXConfigurationHandler handler = new SAXConfigurationHandler();
                    SourceUtil.toSAX(this.manager, source, null, (ContentHandler)handler);
                    builtin = handler.getConfiguration();
                    Object var9_12 = null;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    resolver.release(source);
                    throw throwable;
                }
                resolver.release(source);
                Object var11_15 = null;
            }
            catch (Exception e) {
                String msg = "Error while reading " + xconfURL + ": " + e.getMessage();
                throw new ConfigurationException(msg, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.manager.release((Component)resolver);
            throw throwable;
        }
        this.manager.release((Component)resolver);
        this.builderSelector = new ExtendedComponentSelector(Thread.currentThread().getContextClassLoader());
        try {
            LifecycleHelper.setupComponent((Object)this.builderSelector, this.getLogger(), this.context, this.manager, this.roleManager, builtin);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not setup builder selector", (Throwable)e);
        }
    }

    public boolean process(Environment environment) throws Exception {
        InvokeContext context = new InvokeContext();
        context.enableLogging(this.getLogger());
        try {
            boolean bl = this.process(environment, context);
            Object var5_4 = null;
            context.dispose();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.dispose();
            throw throwable;
        }
    }

    public ProcessingPipeline buildPipeline(Environment environment) throws Exception {
        ProcessingPipeline processingPipeline;
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        try {
            if (this.process(environment, context)) {
                ProcessingPipeline processingPipeline2 = context.getProcessingPipeline();
                Object var5_5 = null;
                context.dispose();
                return processingPipeline2;
            }
            processingPipeline = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            context.dispose();
            throw throwable;
        }
        Object var5_6 = null;
        context.dispose();
        return processingPipeline;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean process(Environment environment, InvokeContext context) throws Exception {
        boolean bl;
        block7: {
            boolean bl2;
            block6: {
                boolean bl3;
                block5: {
                    if (this.rootNode == null || this.checkReload && this.source.getLastModified() > this.lastModified) {
                        this.setupRootNode(environment);
                    }
                    CocoonComponentManager.enterEnvironment(environment, this.sitemapComponentManager, this);
                    try {
                        boolean success = this.rootNode.invoke(environment, context);
                        if (success) {
                            String cocoonRedirect = (String)environment.getAttribute(COCOON_REDIRECT_ATTR);
                            if (cocoonRedirect != null) {
                                environment.removeAttribute(COCOON_REDIRECT_ATTR);
                                bl3 = this.handleCocoonRedirect(cocoonRedirect, environment, context);
                                Object var7_8 = null;
                                break block5;
                            }
                            bl2 = true;
                            break block6;
                        }
                        bl = false;
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        CocoonComponentManager.leaveEnvironment();
                        throw throwable;
                    }
                }
                CocoonComponentManager.leaveEnvironment();
                return bl3;
            }
            Object var7_9 = null;
            CocoonComponentManager.leaveEnvironment();
            return bl2;
        }
        Object var7_10 = null;
        CocoonComponentManager.leaveEnvironment();
        return bl;
    }

    private boolean handleCocoonRedirect(String uri, Environment environment, InvokeContext context) throws Exception {
        MutableEnvironmentFacade facade;
        MutableEnvironmentFacade mutableEnvironmentFacade = facade = environment instanceof MutableEnvironmentFacade ? (MutableEnvironmentFacade)environment : null;
        if (facade != null) {
            environment = facade.getDelegate();
        }
        Environment newEnv = new ForwardEnvironmentWrapper(environment, this.manager, uri, this.getLogger());
        if (facade != null) {
            facade.setDelegate((EnvironmentWrapper)newEnv);
            newEnv = facade;
        }
        TreeProcessor processor = newEnv.getRootContext() == newEnv.getContext() ? (TreeProcessor)this.getRootProcessor() : this;
        context.reset();
        return processor.process(newEnv, context);
    }

    public Processor getRootProcessor() {
        TreeProcessor result = this;
        while (result.parent != null) {
            result = result.parent;
        }
        return result;
    }

    public void setComponentConfigurations(Configuration componentConfigurations) {
        this.componentConfigurations = componentConfigurations;
        this.sitemapComponentConfigurations = null;
    }

    public Map getComponentConfigurations() {
        if (null == this.sitemapComponentConfigurations) {
            TreeProcessor treeProcessor = this;
            synchronized (treeProcessor) {
                if (this.sitemapComponentConfigurations == null) {
                    Configuration[] childs;
                    Configuration[] configurationArray = childs = this.componentConfigurations == null ? null : this.componentConfigurations.getChildren();
                    if (null != childs) {
                        this.sitemapComponentConfigurations = null == this.parent ? new HashMap(12) : new HashMap(this.parent.getComponentConfigurations());
                        int m = 0;
                        while (m < childs.length) {
                            String r = this.roleManager.getRoleForName(childs[m].getName());
                            this.sitemapComponentConfigurations.put(r, new ChainedConfiguration(childs[m], (ChainedConfiguration)this.sitemapComponentConfigurations.get(r)));
                            ++m;
                        }
                    } else {
                        this.sitemapComponentConfigurations = null == this.parent ? Collections.EMPTY_MAP : this.parent.getComponentConfigurations();
                    }
                }
            }
        }
        return this.sitemapComponentConfigurations;
    }

    protected synchronized void setupRootNode(Environment env) throws Exception {
        ProcessingNode root;
        if (this.rootNode != null && this.source.getLastModified() <= this.lastModified) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.disposeTree();
        TreeBuilder builder = (TreeBuilder)this.builderSelector.select(this.language);
        try {
            if (builder instanceof Recomposable) {
                ((Recomposable)builder).recompose(this.manager);
            }
            builder.setProcessor(this);
            if (this.fileName == null) {
                this.fileName = builder.getFileName();
            }
            if (this.source == null) {
                this.source = new DelayedRefreshSourceWrapper(env.resolveURI(this.fileName), this.lastModifiedDelay);
            }
            root = builder.build(this.source);
            this.sitemapComponentManager = builder.getSitemapComponentManager();
            this.disposableNodes = builder.getDisposableNodes();
            Object var7_5 = null;
            this.builderSelector.release(builder);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.builderSelector.release(builder);
            throw throwable;
        }
        this.lastModified = System.currentTimeMillis();
        if (this.getLogger().isDebugEnabled()) {
            double time = (double)(this.lastModified - startTime) / 1000.0;
            this.getLogger().debug("TreeProcessor built in " + time + " secs from " + this.source.getURI());
        }
        this.rootNode = root;
    }

    public void dispose() {
        this.disposeTree();
        if (this.parent == null) {
            this.builderSelector.dispose();
        }
    }

    protected void disposeTree() {
        if (this.disposableNodes != null) {
            int i = this.disposableNodes.size() - 1;
            while (i > -1) {
                ((Disposable)this.disposableNodes.get(i)).dispose();
                --i;
            }
            this.disposableNodes = null;
        }
    }

    private static final class ForwardEnvironmentWrapper
    extends EnvironmentWrapper {
        public ForwardEnvironmentWrapper(Environment env, ComponentManager manager, String uri, Logger logger) throws MalformedURLException {
            super(env, manager, uri, logger);
        }

        public void setStatus(int statusCode) {
            this.environment.setStatus(statusCode);
        }

        public void setContentLength(int length) {
            this.environment.setContentLength(length);
        }

        public void setContentType(String contentType) {
            this.environment.setContentType(contentType);
        }

        public String getContentType() {
            return this.environment.getContentType();
        }
    }
}

