/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.logger.LogKitLoggerManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.Cocoon;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.Constants;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.notification.DefaultNotifyingBuilder;
import org.apache.cocoon.components.notification.Notifier;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.http.HttpContext;
import org.apache.cocoon.environment.http.HttpEnvironment;
import org.apache.cocoon.servlet.multipart.MultipartHttpServletRequest;
import org.apache.cocoon.servlet.multipart.RequestFactory;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.IOUtils;
import org.apache.cocoon.util.StringUtils;
import org.apache.cocoon.util.log.CocoonLogFormatter;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.log.ContextMap;
import org.apache.log.ErrorHandler;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.output.ServletOutputLogTarget;
import org.apache.log.util.DefaultErrorHandler;

public class CocoonServlet
extends HttpServlet {
    protected static final String PROCESSED_BY = "Processed by " + Constants.COMPLETE_NAME + " in ";
    static final float SECOND = 1000.0f;
    static final float MINUTE = 60000.0f;
    static final float HOUR = 3600000.0f;
    private Logger log;
    private LoggerManager loggerManager;
    protected long creationTime = 0L;
    protected Cocoon cocoon;
    protected Exception exception;
    protected DefaultContext appContext = new DefaultContext();
    protected static final boolean ALLOW_RELOAD = false;
    protected boolean allowReload;
    protected boolean showTime;
    protected boolean hiddenShowTime;
    private static final boolean ENABLE_UPLOADS = false;
    private static final boolean SAVE_UPLOADS_TO_DISK = true;
    private static final int MAX_UPLOAD_SIZE = 10000000;
    private boolean enableUploads;
    private boolean autoSaveUploads;
    private boolean allowOverwrite;
    private boolean silentlyRename;
    private int maxUploadSize;
    private File uploadDir;
    private File workDir;
    private File cacheDir;
    private String containerEncoding;
    private String defaultFormEncoding;
    protected ServletContext servletContext;
    protected ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
    protected boolean initClassLoader = false;
    private String parentComponentManagerClass;
    private String parentComponentManagerInitParam;
    private ComponentManager parentComponentManager;
    protected String forceLoadParameter;
    protected String forceSystemProperty;
    private boolean manageExceptions;
    private boolean enableInstrumentation;
    private DefaultInstrumentManager instrumentManager;
    protected String servletContextPath;
    protected String servletContextURL;
    protected RequestFactory requestFactory;
    static /* synthetic */ Class class$java$lang$String;

    public void init(ServletConfig conf) throws ServletException {
        int dividerPos;
        String value;
        super.init(conf);
        if (!this.initClassLoader) {
            this.initClassLoader = this.getInitParameterAsBoolean("init-classloader", false);
        }
        if (this.initClassLoader) {
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((value = System.getProperty("javax.xml.parsers.SAXParserFactory")) != null && value.startsWith("weblogic")) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        }
        this.servletContext = conf.getServletContext();
        this.appContext.put((Object)"environment-context", (Object)new HttpContext(this.servletContext));
        this.servletContextPath = this.servletContext.getRealPath("/");
        String workDirParam = this.getInitParameter("work-directory");
        if (workDirParam != null) {
            File workDirParamFile;
            this.workDir = this.servletContextPath == null ? new File(workDirParam) : ((workDirParamFile = new File(workDirParam)).isAbsolute() ? workDirParamFile : new File(this.servletContextPath, workDirParam));
        } else {
            this.workDir = (File)this.servletContext.getAttribute("javax.servlet.context.tempdir");
            this.workDir = new File(this.workDir, "cocoon-files");
        }
        this.workDir.mkdirs();
        this.initLogger();
        String path = this.servletContextPath;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getRealPath for /: " + path);
        }
        if (path == null) {
            try {
                path = this.servletContext.getResource("/WEB-INF").toString();
            }
            catch (MalformedURLException me) {
                throw new ServletException("Unable to get resource 'WEB-INF'.", (Throwable)me);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("getResource for /WEB-INF: " + path);
            }
            path = path.substring(0, path.length() - "WEB-INF".length());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Path for Root: " + path);
            }
        }
        try {
            this.servletContextURL = path.indexOf(58) > 1 ? path : new File(path).toURL().toExternalForm();
        }
        catch (MalformedURLException me) {
            try {
                this.servletContextURL = new File(path).toURL().toExternalForm();
            }
            catch (MalformedURLException ignored) {
                throw new ServletException("Unable to determine servlet context URL.", (Throwable)me);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("URL for Root: " + this.servletContextURL);
        }
        this.forceLoadParameter = this.getInitParameter("load-class", null);
        this.forceSystemProperty = this.getInitParameter("force-property", null);
        if (workDirParam != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Using work-directory " + this.workDir);
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("work-directory was not set - defaulting to " + this.workDir);
        }
        this.appContext.put((Object)"work-directory", (Object)this.workDir);
        String uploadDirParam = conf.getInitParameter("upload-directory");
        if (uploadDirParam != null) {
            File uploadDirParamFile;
            this.uploadDir = this.servletContextPath == null ? new File(uploadDirParam) : ((uploadDirParamFile = new File(uploadDirParam)).isAbsolute() ? uploadDirParamFile : new File(this.servletContextPath, uploadDirParam));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Using upload-directory " + this.uploadDir);
            }
        } else {
            this.uploadDir = new File(this.workDir, "upload-dir" + File.separator);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("upload-directory was not set - defaulting to " + this.uploadDir);
            }
        }
        this.uploadDir.mkdirs();
        this.appContext.put((Object)"upload-directory", (Object)this.uploadDir);
        this.enableUploads = this.getInitParameterAsBoolean("enable-uploads", false);
        this.autoSaveUploads = this.getInitParameterAsBoolean("autosave-uploads", true);
        String overwriteParam = this.getInitParameter("overwrite-uploads", "rename");
        if ("deny".equalsIgnoreCase(overwriteParam)) {
            this.allowOverwrite = false;
            this.silentlyRename = false;
        } else if ("allow".equalsIgnoreCase(overwriteParam)) {
            this.allowOverwrite = true;
            this.silentlyRename = false;
        } else {
            this.allowOverwrite = false;
            this.silentlyRename = true;
        }
        this.maxUploadSize = this.getInitParameterAsInteger("upload-max-size", 10000000);
        String cacheDirParam = conf.getInitParameter("cache-directory");
        if (cacheDirParam != null) {
            File cacheDirParamFile;
            this.cacheDir = this.servletContextPath == null ? new File(cacheDirParam) : ((cacheDirParamFile = new File(cacheDirParam)).isAbsolute() ? cacheDirParamFile : new File(this.servletContextPath, cacheDirParam));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Using cache-directory " + this.cacheDir);
            }
        } else {
            this.cacheDir = IOUtils.createFile(this.workDir, "cache-dir" + File.separator);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("cache-directory was not set - defaulting to " + this.cacheDir);
            }
        }
        this.cacheDir.mkdirs();
        this.appContext.put((Object)"cache-directory", (Object)this.cacheDir);
        this.appContext.put((Object)"config-url", (Object)this.getConfigFile(conf.getInitParameter("configurations")));
        if (conf.getInitParameter("configurations") == null && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("configurations was not set - defaulting to... ?");
        }
        this.allowReload = this.getInitParameterAsBoolean("allow-reload", false);
        value = conf.getInitParameter("show-time");
        boolean bl = this.showTime = "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || (this.hiddenShowTime = "hide".equals(value));
        if (value == null && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("show-time was not set - defaulting to false");
        }
        this.parentComponentManagerClass = this.getInitParameter("parent-component-manager", null);
        if (this.parentComponentManagerClass != null && (dividerPos = this.parentComponentManagerClass.indexOf(47)) != -1) {
            this.parentComponentManagerInitParam = this.parentComponentManagerClass.substring(dividerPos + 1);
            this.parentComponentManagerClass = this.parentComponentManagerClass.substring(0, dividerPos);
        }
        this.containerEncoding = this.getInitParameter("container-encoding", "ISO-8859-1");
        this.defaultFormEncoding = this.getInitParameter("form-encoding", "ISO-8859-1");
        this.manageExceptions = this.getInitParameterAsBoolean("manage-exceptions", true);
        this.enableInstrumentation = this.getInitParameterAsBoolean("enable-instrumentation", false);
        this.requestFactory = new RequestFactory(this.autoSaveUploads, this.uploadDir, this.allowOverwrite, this.silentlyRename, this.maxUploadSize, this.defaultFormEncoding);
        this.createCocoon();
    }

    public void destroy() {
        if (this.initClassLoader) {
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.cocoon != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Servlet destroyed - disposing Cocoon");
            }
            this.disposeCocoon();
        }
        if (this.enableInstrumentation) {
            this.instrumentManager.dispose();
        }
        if (this.parentComponentManager != null && this.parentComponentManager instanceof Disposable) {
            ((Disposable)this.parentComponentManager).dispose();
        }
    }

    protected void addClassLoaderURL(URL URL2) {
    }

    protected void addClassLoaderDirectory(String dir) {
    }

    protected String getClassPath() throws ServletException {
        StringBuffer buildClassPath = new StringBuffer();
        File root = null;
        if (this.servletContextPath != null) {
            String classDir = this.servletContext.getRealPath("/WEB-INF/classes");
            String libDir = this.servletContext.getRealPath("/WEB-INF/lib");
            if (libDir != null) {
                root = new File(libDir);
            }
            if (classDir != null) {
                buildClassPath.append(classDir);
                this.addClassLoaderDirectory(classDir);
            }
        } else {
            URL libDirURL;
            URL classDirURL;
            block14: {
                block13: {
                    classDirURL = null;
                    libDirURL = null;
                    try {
                        classDirURL = this.servletContext.getResource("/WEB-INF/classes");
                    }
                    catch (MalformedURLException me) {
                        if (!this.getLogger().isWarnEnabled()) break block13;
                        this.getLogger().warn("Unable to add WEB-INF/classes to the classpath", (Throwable)me);
                    }
                }
                try {
                    libDirURL = this.servletContext.getResource("/WEB-INF/lib");
                }
                catch (MalformedURLException me) {
                    if (!this.getLogger().isWarnEnabled()) break block14;
                    this.getLogger().warn("Unable to add WEB-INF/lib to the classpath", (Throwable)me);
                }
            }
            if (libDirURL != null && libDirURL.toExternalForm().startsWith("file:")) {
                root = new File(libDirURL.toExternalForm().substring("file:".length()));
            }
            if (classDirURL != null) {
                buildClassPath.append(classDirURL.toExternalForm());
                this.addClassLoaderURL(classDirURL);
            }
        }
        if (root == null) {
            root = this.extractLibraries();
        }
        if (root != null && root.isDirectory()) {
            Object[] libraries = root.listFiles();
            Arrays.sort(libraries);
            int i = 0;
            while (i < libraries.length) {
                String fullName = IOUtils.getFullFilename((File)libraries[i]);
                buildClassPath.append(File.pathSeparatorChar).append(fullName);
                this.addClassLoaderDirectory(fullName);
                ++i;
            }
        }
        buildClassPath.append(File.pathSeparatorChar).append(System.getProperty("java.class.path"));
        buildClassPath.append(File.pathSeparatorChar).append(this.getExtraClassPath());
        return buildClassPath.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File extractLibraries() {
        try {
            URL manifestURL = this.servletContext.getResource("/META-INF/MANIFEST.MF");
            if (manifestURL == null) {
                this.getLogger().fatalError("Unable to get Manifest");
                return null;
            }
            Manifest mf = new Manifest(manifestURL.openStream());
            Attributes attr = mf.getMainAttributes();
            String libValue = attr.getValue("Cocoon-Libs");
            if (libValue == null) {
                this.getLogger().fatalError("Unable to get 'Cocoon-Libs' attribute from the Manifest");
                return null;
            }
            ArrayList<String> libList = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(libValue, " ");
            while (true) {
                if (!st.hasMoreTokens()) break;
                libList.add(st.nextToken());
            }
            File root = new File(this.workDir, "lib");
            root.mkdirs();
            File[] oldLibs = root.listFiles();
            int i = 0;
            while (true) {
                if (i >= oldLibs.length) break;
                String oldLib = oldLibs[i].getName();
                if (!libList.contains(oldLib)) {
                    this.getLogger().debug("Removing old library " + oldLibs[i]);
                    oldLibs[i].delete();
                }
                ++i;
            }
            this.getLogger().warn("Extracting libraries into " + root);
            byte[] buffer = new byte[65536];
            Iterator i2 = libList.iterator();
            while (true) {
                InputStream is;
                if (!i2.hasNext()) {
                    return root;
                }
                String libName = (String)i2.next();
                long lastModified = -1L;
                try {
                    lastModified = Long.parseLong(attr.getValue("Cocoon-Lib-" + libName.replace('.', '_')));
                }
                catch (Exception e) {
                    this.getLogger().debug("Failed to parse lastModified: " + attr.getValue("Cocoon-Lib-" + libName.replace('.', '_')));
                }
                File lib = new File(root, libName);
                if (lib.exists() && lib.lastModified() != lastModified) {
                    this.getLogger().debug("Removing modified library " + lib);
                    lib.delete();
                }
                if ((is = this.servletContext.getResourceAsStream("/WEB-INF/lib/" + libName)) == null) {
                    this.getLogger().warn("Skipping " + libName);
                } else {
                    FileOutputStream os;
                    block21: {
                        Object var20_20;
                        this.getLogger().debug("Extracting " + libName);
                        os = null;
                        try {
                            os = new FileOutputStream(lib);
                            while (true) {
                                void var18_19;
                                int count;
                                if ((count = is.read(buffer)) <= 0) {
                                    var20_20 = null;
                                    if (is == null) break block21;
                                    break;
                                }
                                ((OutputStream)os).write(buffer, 0, (int)var18_19);
                            }
                        }
                        catch (Throwable throwable) {
                            var20_20 = null;
                            if (is != null) {
                                is.close();
                            }
                            if (os != null) {
                                ((OutputStream)os).close();
                            }
                            throw throwable;
                        }
                        is.close();
                    }
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                }
                if (lastModified == -1L) continue;
                lib.setLastModified(lastModified);
            }
        }
        catch (IOException e) {
            this.getLogger().fatalError("Exception while processing Manifest file", (Throwable)e);
            return null;
        }
    }

    protected String getExtraClassPath() throws ServletException {
        String extraClassPath = this.getInitParameter("extra-classpath");
        if (extraClassPath != null) {
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(extraClassPath, System.getProperty("path.separator"), false);
            int i = 0;
            while (st.hasMoreTokens()) {
                String path;
                String s = st.nextToken();
                if (i++ > 0) {
                    sb.append(File.pathSeparatorChar);
                }
                if (s.charAt(0) == File.separatorChar || s.charAt(1) == ':') {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("extraClassPath is absolute: " + s);
                    }
                    sb.append(s);
                    this.addClassLoaderDirectory(s);
                    continue;
                }
                if (s.indexOf("${") != -1) {
                    path = StringUtils.replaceToken(s);
                    sb.append(path);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("extraClassPath is not absolute replacing using token: [" + s + "] : " + path);
                    }
                    this.addClassLoaderDirectory(path);
                    continue;
                }
                path = null;
                if (this.servletContextPath != null) {
                    path = this.servletContextPath + s;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("extraClassPath is not absolute pre-pending context path: " + path);
                    }
                } else {
                    path = this.workDir.toString() + s;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("extraClassPath is not absolute pre-pending work-directory: " + path);
                    }
                }
                sb.append(path);
                this.addClassLoaderDirectory(path);
            }
            return sb.toString();
        }
        return "";
    }

    protected void initLogger() {
        String logLevel = this.getInitParameter("log-level", "INFO");
        String accesslogger = this.getInitParameter("servlet-logger");
        Priority logPriority = Priority.getPriorityForName((String)logLevel);
        CocoonLogFormatter formatter = new CocoonLogFormatter();
        formatter.setFormat("%7.7{priority} %{time}   [%8.8{category}] (%{uri}) %{thread}/%{class:short}: %{message}\\n%{throwable}");
        ServletOutputLogTarget servTarget = new ServletOutputLogTarget(this.servletContext);
        servTarget.setFormatter((Formatter)formatter);
        Hierarchy defaultHierarchy = Hierarchy.getDefaultHierarchy();
        DefaultErrorHandler errorHandler = new DefaultErrorHandler();
        defaultHierarchy.setErrorHandler((ErrorHandler)errorHandler);
        defaultHierarchy.setDefaultLogTarget((LogTarget)servTarget);
        defaultHierarchy.setDefaultPriority(logPriority);
        LogKitLogger logger = new LogKitLogger(Hierarchy.getDefaultHierarchy().getLoggerFor(""));
        LogKitLoggerManager logKitLoggerManager = new LogKitLoggerManager(defaultHierarchy);
        logKitLoggerManager.enableLogging((Logger)logger);
        DefaultContext subcontext = new DefaultContext((Context)this.appContext);
        subcontext.put((Object)"servlet-context", (Object)this.servletContext);
        if (this.servletContextPath == null) {
            File logSCDir = new File(this.workDir, "log");
            logSCDir.mkdirs();
            if (logger.isWarnEnabled()) {
                logger.warn("Setting servlet-context for LogKit to " + logSCDir);
            }
            subcontext.put((Object)"context-root", (Object)logSCDir.toString());
        } else {
            subcontext.put((Object)"context-root", (Object)this.servletContextPath);
        }
        try {
            logKitLoggerManager.contextualize((Context)subcontext);
            this.loggerManager = logKitLoggerManager;
            String logkitConfig = this.getInitParameter("logkit-config", "/WEB-INF/logkit.xconf");
            InputStream is = null;
            if (logkitConfig.indexOf(58) == -1) {
                is = this.servletContext.getResourceAsStream(logkitConfig);
                if (is == null) {
                    is = new FileInputStream(logkitConfig);
                }
            } else {
                URL logkitURL = new URL(logkitConfig);
                is = logkitURL.openStream();
            }
            DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
            Configuration conf = builder.build(is);
            logKitLoggerManager.configure(conf);
        }
        catch (Exception e) {
            errorHandler.error("Could not set up Cocoon Logger, will use screen instead", (Throwable)e, null);
        }
        this.log = accesslogger != null ? logKitLoggerManager.getLoggerForCategory(accesslogger) : logKitLoggerManager.getLoggerForCategory("cocoon");
    }

    private URL getConfigFile(String configFileName) throws ServletException {
        File resultFile;
        URL result;
        String usedFileName;
        if (configFileName == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Servlet initialization argument 'configurations' not specified, attempting to use '/WEB-INF/cocoon.xconf'");
            }
            usedFileName = "/WEB-INF/cocoon.xconf";
        } else {
            usedFileName = configFileName;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Using configuration file: " + usedFileName);
        }
        try {
            result = usedFileName.indexOf(58) == -1 ? this.servletContext.getResource(usedFileName) : new URL(usedFileName);
        }
        catch (Exception mue) {
            String msg = "Init parameter 'configurations' is invalid : " + usedFileName;
            this.getLogger().error(msg, (Throwable)mue);
            throw new ServletException(msg, (Throwable)mue);
        }
        if (result == null && (resultFile = new File(usedFileName)).isFile()) {
            try {
                result = resultFile.getCanonicalFile().toURL();
            }
            catch (Exception e) {
                String msg = "Init parameter 'configurations' is invalid : " + usedFileName;
                this.getLogger().error(msg, (Throwable)e);
                throw new ServletException(msg, (Throwable)e);
            }
        }
        if (result == null) {
            String msg = "Init parameter 'configuration' doesn't name an existing resource : " + usedFileName;
            this.getLogger().error(msg);
            throw new ServletException(msg);
        }
        return result;
    }

    private void forceLoad() {
        if (this.forceLoadParameter != null) {
            StringTokenizer fqcnTokenizer = new StringTokenizer(this.forceLoadParameter, " \t\r\n\f;,", false);
            while (fqcnTokenizer.hasMoreTokens()) {
                String fqcn = fqcnTokenizer.nextToken().trim();
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Trying to load class: " + fqcn);
                    }
                    ClassUtils.loadClass(fqcn).newInstance();
                }
                catch (Exception e) {
                    if (!this.getLogger().isWarnEnabled()) continue;
                    this.getLogger().warn("Could not force-load class: " + fqcn, (Throwable)e);
                }
            }
        }
    }

    private void forceProperty() {
        if (this.forceSystemProperty != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.forceSystemProperty, " \t\r\n\f;,", false);
            Properties systemProps = System.getProperties();
            while (tokenizer.hasMoreTokens()) {
                String property = tokenizer.nextToken().trim();
                if (property.indexOf(61) == -1) continue;
                try {
                    String key = property.substring(0, property.indexOf(61));
                    String value = property.substring(property.indexOf(61) + 1);
                    if (value.indexOf("${") != -1) {
                        value = StringUtils.replaceToken(value);
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("setting " + key + "=" + value);
                    }
                    systemProps.setProperty(key, value);
                }
                catch (Exception e) {
                    if (!this.getLogger().isWarnEnabled()) continue;
                    this.getLogger().warn("Could not set property: " + property, (Throwable)e);
                }
            }
            System.setProperties(systemProps);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block78: {
            block74: {
                block77: {
                    block71: {
                        block72: {
                            if (this.initClassLoader) {
                                try {
                                    Thread.currentThread().setContextClassLoader(this.classLoader);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            start = System.currentTimeMillis();
                            res.addHeader("X-Cocoon-Version", Constants.VERSION);
                            try {
                                request = this.enableUploads ? this.requestFactory.getServletRequest(req) : req;
                            }
                            catch (Exception e) {
                                if (this.getLogger().isErrorEnabled()) {
                                    this.getLogger().error("Problem with Cocoon servlet", (Throwable)e);
                                }
                                this.manageException(req, res, null, null, 500, "Problem in creating the Request", null, null, e);
                                return;
                            }
                            this.getCocoon(request.getPathInfo(), request.getParameter("cocoon-reload"));
                            if (this.cocoon == null) {
                                this.manageException(request, res, null, null, 500, "Initialization Problem", null, null, this.exception);
                                return;
                            }
                            uri = request.getServletPath();
                            if (uri == null) {
                                uri = "";
                            }
                            if ((pathInfo = request.getPathInfo()) != null) {
                                if (uri.length() > 0 && uri.charAt(0) == '/') {
                                    uri = uri.substring(1);
                                }
                                uri = uri + pathInfo;
                            }
                            if (uri.length() == 0) {
                                prefix = request.getRequestURI();
                                if (prefix == null) {
                                    prefix = "";
                                }
                                res.sendRedirect(res.encodeRedirectURL(prefix + "/"));
                                return;
                            }
                            contentType = null;
                            ctxMap = null;
                            try {
                                if (uri.charAt(0) == '/') {
                                    uri = uri.substring(1);
                                }
                                env = this.getEnvironment(URLDecoder.decode(uri), request, res);
                            }
                            catch (Exception e) {
                                if (this.getLogger().isErrorEnabled()) {
                                    this.getLogger().error("Problem with Cocoon servlet", (Throwable)e);
                                }
                                this.manageException(request, res, null, uri, 500, "Problem in creating the Environment", null, null, e);
                                return;
                            }
                            try {
                                block70: {
                                    try {
                                        ctxMap = ContextMap.getCurrentContext();
                                        threadName = Thread.currentThread().getName();
                                        ctxMap.set("threadName", (Object)threadName);
                                        ctxMap.set("objectModel", (Object)env.getObjectModel());
                                        ctxMap.set("request-id", (Object)(threadName + System.currentTimeMillis()));
                                        if (this.cocoon.process(env)) {
                                            contentType = env.getContentType();
                                            break block70;
                                        }
                                        this.getLogger().fatalError("The Cocoon engine failed to process the request.");
                                        this.manageException(request, res, env, uri, 500, "Request Processing Failed", "Cocoon engine failed in process the request", "The processing engine failed to process the request. This could be due to lack of matching or bugs in the pipeline engine.", null);
                                        var19_17 = null;
                                        if (ctxMap == null) break block71;
                                        break block72;
                                    }
                                    catch (ResourceNotFoundException rse) {
                                        if (this.getLogger().isWarnEnabled()) {
                                            this.getLogger().warn("The resource was not found", (Throwable)rse);
                                        }
                                        this.manageException(request, res, env, uri, 404, "Resource Not Found", "Resource Not Found", "The requested resource \"" + request.getRequestURI() + "\" could not be found", (Exception)rse);
                                        var19_18 = null;
                                        if (ctxMap != null) {
                                            ctxMap.clear();
                                        }
                                        try {
                                            if (request instanceof MultipartHttpServletRequest) {
                                                if (this.getLogger().isDebugEnabled()) {
                                                    this.getLogger().debug("Deleting uploaded file(s).");
                                                }
                                                ((MultipartHttpServletRequest)request).cleanup();
                                            }
                                        }
                                        catch (IOException e) {
                                            this.getLogger().error("Cocoon got an Exception while trying to cleanup the uploaded files.", (Throwable)e);
                                        }
                                        try {
                                            out = res.getOutputStream();
                                            out.flush();
                                            out.close();
                                            return;
                                        }
                                        catch (SocketException se) {
                                            if (this.getLogger().isDebugEnabled()) {
                                                this.getLogger().debug("SocketException while trying to close stream.", (Throwable)se);
                                                return;
                                            }
                                            if (this.getLogger().isWarnEnabled() == false) return;
                                            this.getLogger().warn("SocketException while trying to close stream.");
                                            return;
                                        }
                                        catch (Exception e) {
                                            this.getLogger().error("Cocoon got an Exception while trying to close stream.", (Throwable)e);
                                        }
                                        return;
                                    }
                                    catch (ConnectionResetException cre) {
                                        if (this.getLogger().isDebugEnabled()) {
                                            this.getLogger().debug(cre.getMessage(), (Throwable)cre);
                                        }
                                        if (this.getLogger().isWarnEnabled()) {
                                            this.getLogger().warn(cre.getMessage());
                                        }
                                    }
                                    catch (SocketException se) {
                                        if (this.getLogger().isDebugEnabled()) {
                                            this.getLogger().debug(se.getMessage(), (Throwable)se);
                                        }
                                        if (this.getLogger().isWarnEnabled()) {
                                            this.getLogger().warn(se.getMessage());
                                        }
                                    }
                                    catch (Exception e) {
                                        block75: {
                                            if (this.getLogger().isErrorEnabled()) {
                                                this.getLogger().error("Internal Cocoon Problem", (Throwable)e);
                                            }
                                            this.manageException(request, res, env, uri, 500, "Internal Server Error", null, null, e);
                                            var19_19 = null;
                                            if (ctxMap != null) {
                                                ctxMap.clear();
                                            }
                                            ** try [egrp 5[TRYBLOCK] [8 : 1017->1060)] { 
lbl117:
                                            // 1 sources

                                            if (request instanceof MultipartHttpServletRequest) {
                                                if (this.getLogger().isDebugEnabled()) {
                                                    this.getLogger().debug("Deleting uploaded file(s).");
                                                }
                                                ((MultipartHttpServletRequest)request).cleanup();
                                            }
                                            break block75;
lbl122:
                                            // 1 sources

                                            catch (IOException e) {
                                                this.getLogger().error("Cocoon got an Exception while trying to cleanup the uploaded files.", (Throwable)e);
                                            }
                                        }
                                        ** try [egrp 6[TRYBLOCK] [9, 10 : 1076->1097)] { 
lbl126:
                                        // 1 sources

                                        out = res.getOutputStream();
                                        out.flush();
                                        out.close();
                                        return;
lbl130:
                                        // 1 sources

                                        catch (SocketException se) {
                                            if (this.getLogger().isDebugEnabled()) {
                                                this.getLogger().debug("SocketException while trying to close stream.", (Throwable)se);
                                                return;
                                            }
                                            if (this.getLogger().isWarnEnabled() == false) return;
                                            this.getLogger().warn("SocketException while trying to close stream.");
                                            return;
                                        }
lbl137:
                                        // 1 sources

                                        catch (Exception e) {
                                            this.getLogger().error("Cocoon got an Exception while trying to close stream.", (Throwable)e);
                                        }
                                        return;
                                    }
                                }
                                end = System.currentTimeMillis();
                                timeString = this.processTime(end - start);
                                if (this.getLogger().isInfoEnabled()) {
                                    this.getLogger().info("'" + uri + "' " + timeString);
                                }
                                if (contentType == null || !contentType.equals("text/html")) break block74;
                                showTime = request.getParameter("cocoon-showtime");
                                show = this.showTime;
                                if (showTime != null) {
                                    v0 = show = showTime.equalsIgnoreCase("no") == false;
                                }
                                if (show) {
                                    hide = this.hiddenShowTime;
                                    if (showTime != null) {
                                        hide = showTime.equalsIgnoreCase("hide");
                                    }
                                    out = res.getOutputStream();
                                    out.print(hide != false ? "<!-- " : "<p>");
                                    out.print(timeString);
                                    out.println(hide != false ? " -->" : "</p>");
                                }
                                break block74;
                            }
                            catch (Throwable var18_40) {
                                block76: {
                                    var19_21 = null;
                                    if (ctxMap != null) {
                                        ctxMap.clear();
                                    }
                                    ** try [egrp 5[TRYBLOCK] [8 : 1017->1060)] { 
lbl166:
                                    // 1 sources

                                    if (request instanceof MultipartHttpServletRequest) {
                                        if (this.getLogger().isDebugEnabled()) {
                                            this.getLogger().debug("Deleting uploaded file(s).");
                                        }
                                        ((MultipartHttpServletRequest)request).cleanup();
                                    }
                                    break block76;
lbl171:
                                    // 1 sources

                                    catch (IOException e) {
                                        this.getLogger().error("Cocoon got an Exception while trying to cleanup the uploaded files.", (Throwable)e);
                                    }
                                }
                                ** try [egrp 6[TRYBLOCK] [9, 10 : 1076->1097)] { 
lbl175:
                                // 1 sources

                                out = res.getOutputStream();
                                out.flush();
                                out.close();
                                throw var18_40;
lbl179:
                                // 1 sources

                                catch (SocketException se) {
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug("SocketException while trying to close stream.", (Throwable)se);
                                        throw var18_40;
                                    }
                                    if (this.getLogger().isWarnEnabled() == false) throw var18_40;
                                    this.getLogger().warn("SocketException while trying to close stream.");
                                    throw var18_40;
                                }
lbl186:
                                // 1 sources

                                catch (Exception e) {
                                    this.getLogger().error("Cocoon got an Exception while trying to close stream.", (Throwable)e);
                                }
                                throw var18_40;
                            }
                        }
                        ctxMap.clear();
                    }
                    ** try [egrp 5[TRYBLOCK] [8 : 1017->1060)] { 
lbl193:
                    // 1 sources

                    if (request instanceof MultipartHttpServletRequest) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Deleting uploaded file(s).");
                        }
                        ((MultipartHttpServletRequest)request).cleanup();
                    }
                    break block77;
lbl198:
                    // 1 sources

                    catch (IOException e) {
                        this.getLogger().error("Cocoon got an Exception while trying to cleanup the uploaded files.", (Throwable)e);
                    }
                }
                ** try [egrp 6[TRYBLOCK] [9, 10 : 1076->1097)] { 
lbl202:
                // 1 sources

                out = res.getOutputStream();
                out.flush();
                out.close();
                return;
lbl206:
                // 1 sources

                catch (SocketException se) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("SocketException while trying to close stream.", (Throwable)se);
                        return;
                    }
                    if (this.getLogger().isWarnEnabled() == false) return;
                    this.getLogger().warn("SocketException while trying to close stream.");
                    return;
                }
lbl213:
                // 1 sources

                catch (Exception e) {
                    this.getLogger().error("Cocoon got an Exception while trying to close stream.", (Throwable)e);
                }
                return;
            }
            var19_20 = null;
            if (ctxMap != null) {
                ctxMap.clear();
            }
            ** try [egrp 5[TRYBLOCK] [8 : 1017->1060)] { 
lbl221:
            // 1 sources

            if (request instanceof MultipartHttpServletRequest) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Deleting uploaded file(s).");
                }
                ((MultipartHttpServletRequest)request).cleanup();
            }
            break block78;
lbl226:
            // 1 sources

            catch (IOException e) {
                this.getLogger().error("Cocoon got an Exception while trying to cleanup the uploaded files.", (Throwable)e);
            }
        }
        ** try [egrp 6[TRYBLOCK] [9, 10 : 1076->1097)] { 
lbl230:
        // 1 sources

        out = res.getOutputStream();
        out.flush();
        out.close();
        return;
lbl234:
        // 1 sources

        catch (SocketException se) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("SocketException while trying to close stream.", (Throwable)se);
                return;
            }
            if (this.getLogger().isWarnEnabled() == false) return;
            this.getLogger().warn("SocketException while trying to close stream.");
            return;
        }
lbl241:
        // 1 sources

        catch (Exception e) {
            this.getLogger().error("Cocoon got an Exception while trying to close stream.", (Throwable)e);
            return;
        }
    }

    protected void manageException(HttpServletRequest req, HttpServletResponse res, Environment env, String uri, int errorStatus, String title, String message, String description, Exception e) throws IOException {
        if (this.manageExceptions) {
            if (env != null) {
                env.tryResetResponse();
            } else {
                res.reset();
            }
            String type = "fatal";
            HashMap<String, String> extraDescriptions = null;
            if (errorStatus == 404) {
                type = "resource-not-found";
                e = null;
            } else {
                extraDescriptions = new HashMap<String, String>(2);
                extraDescriptions.put("request-uri", req.getRequestURI());
                if (uri != null) {
                    extraDescriptions.put("Request URI", uri);
                }
                if (!this.getLogger().isInfoEnabled()) {
                    Throwable t = DefaultNotifyingBuilder.getRootCause(e);
                    if (t != null) {
                        extraDescriptions.put("cause", t.getMessage());
                    }
                    e = null;
                }
            }
            Notifying n = new DefaultNotifyingBuilder().build((Object)this, e, type, title, "Cocoon Servlet", message, description, extraDescriptions);
            res.setContentType("text/html");
            res.setStatus(errorStatus);
            Notifier.notify(n, (OutputStream)res.getOutputStream(), "text/html");
        } else {
            res.sendError(errorStatus, title);
            res.flushBuffer();
        }
    }

    protected Environment getEnvironment(String uri, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String formEncoding = req.getParameter("cocoon-form-encoding");
        if (formEncoding == null) {
            formEncoding = this.defaultFormEncoding;
        }
        HttpEnvironment env = new HttpEnvironment(uri, this.servletContextURL, req, res, this.servletContext, (HttpContext)this.appContext.get((Object)"environment-context"), this.containerEncoding, formEncoding);
        env.enableLogging(this.getLogger());
        return env;
    }

    protected synchronized ComponentManager getParentComponentManager() {
        block7: {
            if (this.parentComponentManager != null && this.parentComponentManager instanceof Disposable) {
                ((Disposable)this.parentComponentManager).dispose();
            }
            this.parentComponentManager = null;
            if (this.parentComponentManagerClass != null) {
                try {
                    Class pcm = ClassUtils.loadClass(this.parentComponentManagerClass);
                    Constructor pcmc = pcm.getConstructor(class$java$lang$String == null ? (class$java$lang$String = CocoonServlet.class$("java.lang.String")) : class$java$lang$String);
                    this.parentComponentManager = (ComponentManager)pcmc.newInstance(this.parentComponentManagerInitParam);
                    if (this.parentComponentManager instanceof LogEnabled) {
                        ((LogEnabled)this.parentComponentManager).enableLogging(this.getLogger());
                    }
                    if (this.parentComponentManager instanceof Contextualizable) {
                        ((Contextualizable)this.parentComponentManager).contextualize((Context)this.appContext);
                    }
                    if (this.parentComponentManager instanceof Initializable) {
                        ((Initializable)this.parentComponentManager).initialize();
                    }
                }
                catch (Exception e) {
                    if (!this.getLogger().isErrorEnabled()) break block7;
                    this.getLogger().error("Could not initialize parent component manager.", (Throwable)e);
                }
            }
        }
        return this.parentComponentManager;
    }

    private synchronized void createCocoon() throws ServletException {
        if (this.initClassLoader) {
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.updateEnvironment();
        this.forceLoad();
        this.forceProperty();
        try {
            URL configFile = (URL)this.appContext.get((Object)"config-url");
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Reloading from: " + configFile.toExternalForm());
            }
            Cocoon c = (Cocoon)ClassUtils.newInstance("org.apache.cocoon.Cocoon");
            c.enableLogging(this.getCocoonLogger());
            c.setLoggerManager(this.getLoggerManager());
            c.contextualize((Context)this.appContext);
            c.compose(this.getParentComponentManager());
            if (this.enableInstrumentation) {
                c.setInstrumentManager(this.getInstrumentManager());
            }
            c.initialize();
            this.creationTime = System.currentTimeMillis();
            this.disposeCocoon();
            this.cocoon = c;
        }
        catch (Exception e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Exception reloading", (Throwable)e);
            }
            this.exception = e;
            this.disposeCocoon();
        }
    }

    private Logger getCocoonLogger() {
        String rootlogger = this.getInitParameter("cocoon-logger");
        if (rootlogger != null) {
            return this.getLoggerManager().getLoggerForCategory(rootlogger);
        }
        return this.getLogger();
    }

    protected void updateEnvironment() throws ServletException {
        this.appContext.put((Object)"class-loader", (Object)this.classLoader);
        this.appContext.put((Object)"classpath", (Object)this.getClassPath());
    }

    private InstrumentManager getInstrumentManager() throws Exception {
        String imConfig = this.getInitParameter("instrumentation-config");
        if (imConfig == null) {
            throw new ServletException("Please define the init-param 'instrumentation-config' in your web.xml");
        }
        InputStream is = this.servletContext.getResourceAsStream(imConfig);
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration conf = builder.build(is);
        String imLoggerCategory = conf.getAttribute("logger", "core.instrument");
        Logger imLogger = this.loggerManager.getLoggerForCategory(imLoggerCategory);
        DefaultInstrumentManager instrumentManager = new DefaultInstrumentManager();
        instrumentManager.enableLogging(imLogger);
        instrumentManager.configure(conf);
        instrumentManager.initialize();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Instrument manager created " + instrumentManager);
        }
        this.instrumentManager = instrumentManager;
        return instrumentManager;
    }

    private String processTime(long time) {
        StringBuffer out = new StringBuffer(PROCESSED_BY);
        if ((float)time <= 1000.0f) {
            out.append(time);
            out.append(" milliseconds.");
        } else if ((float)time <= 60000.0f) {
            out.append((float)time / 1000.0f);
            out.append(" seconds.");
        } else if ((float)time <= 3600000.0f) {
            out.append((float)time / 60000.0f);
            out.append(" minutes.");
        } else {
            out.append((float)time / 3600000.0f);
            out.append(" hours.");
        }
        return out.toString();
    }

    private void getCocoon(String pathInfo, String reloadParam) throws ServletException {
        if (this.allowReload) {
            boolean reload = false;
            if (this.cocoon != null) {
                if (this.cocoon.modifiedSince(this.creationTime)) {
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("Configuration changed reload attempt");
                    }
                    reload = true;
                } else if (pathInfo == null && reloadParam != null) {
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("Forced reload attempt");
                    }
                    reload = true;
                }
            } else if (pathInfo == null && reloadParam != null) {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Invalid configurations reload");
                }
                reload = true;
            }
            if (reload) {
                this.initLogger();
                this.createCocoon();
            }
        }
    }

    private final void disposeCocoon() {
        if (this.cocoon != null) {
            this.cocoon.dispose();
            this.cocoon = null;
        }
    }

    public String getInitParameter(String name) {
        String result = super.getInitParameter(name);
        if (result != null && (result = result.trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    protected String getInitParameter(String name, String defaultValue) {
        String result = this.getInitParameter(name);
        if (result == null) {
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(name + " was not set - defaulting to '" + defaultValue + "'");
            }
            return defaultValue;
        }
        return result;
    }

    protected boolean getInitParameterAsBoolean(String name, boolean defaultValue) {
        String value = this.getInitParameter(name);
        if (value == null) {
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(name + " was not set - defaulting to '" + defaultValue + "'");
            }
            return defaultValue;
        }
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    protected int getInitParameterAsInteger(String name, int defaultValue) {
        String value = this.getInitParameter(name);
        if (value == null) {
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(name + " was not set - defaulting to '" + defaultValue + "'");
            }
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    protected Logger getLogger() {
        return this.log;
    }

    protected LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

