/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ContentAggregator
extends ContentHandlerWrapper
implements Generator,
CacheableProcessingComponent,
Serviceable {
    protected Element rootElement;
    protected ArrayList parts = new ArrayList();
    private AttributesImpl emptyAttrs = new AttributesImpl();
    private int rootElementIndex;
    protected Element currentElement;
    protected SourceResolver resolver;
    protected ServiceManager manager;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ContentAggregator: generating aggregated content");
        }
        this.contentHandler.startDocument();
        this.startElem(this.rootElement);
        try {
            int i = 0;
            while (true) {
                block11: {
                    Object var4_3;
                    if (i >= this.parts.size()) {
                        Object var6_5 = null;
                        break;
                    }
                    Part part = (Part)this.parts.get(i);
                    int n = this.rootElementIndex = part.stripRootElement ? -1 : 0;
                    if (part.element != null) {
                        this.currentElement = part.element;
                        this.startElem(part.element);
                    } else {
                        this.currentElement = this.rootElement;
                    }
                    try {
                        SourceUtil.parse(this.manager, part.source, (ContentHandler)this);
                        var4_3 = null;
                        if (part.element == null) break block11;
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        if (part.element != null) {
                            this.endElem(part.element);
                        }
                        throw throwable;
                    }
                    this.endElem(part.element);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endElem(this.rootElement);
            this.contentHandler.endDocument();
            throw throwable;
        }
        this.endElem(this.rootElement);
        this.contentHandler.endDocument();
        this.getLogger().debug("ContentAggregator: finished aggregating content");
    }

    public Serializable getKey() {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("CA(").append(this.rootElement.prefix).append(':').append(this.rootElement.name).append('<').append(this.rootElement.namespace).append(">)");
            int i = 0;
            while (i < this.parts.size()) {
                Part part = (Part)this.parts.get(i);
                Source current = part.source;
                if (part.element == null) {
                    buffer.append("P=").append(part.stripRootElement).append(':').append(current.getURI()).append(';');
                } else {
                    buffer.append("P=").append(part.element.prefix).append(':').append(part.element.name).append('<').append(part.element.namespace).append(">:").append(part.stripRootElement).append(':').append(current.getURI()).append(';');
                }
                ++i;
            }
            return buffer.toString();
        }
        catch (Exception e) {
            this.getLogger().error("ContentAggregator: could not generateKey", (Throwable)e);
            return null;
        }
    }

    public SourceValidity getValidity() {
        try {
            AggregatedValidity v = new AggregatedValidity();
            int i = 0;
            while (i < this.parts.size()) {
                Source current = ((Part)this.parts.get((int)i)).source;
                SourceValidity sv = current.getValidity();
                if (sv == null) {
                    return null;
                }
                v.add(sv);
                ++i;
            }
            return v;
        }
        catch (Exception e) {
            this.getLogger().error("ContentAggregator: could not generateKey", (Throwable)e);
            return null;
        }
    }

    public void setRootElement(String element, String namespace, String prefix) {
        this.rootElement = new Element(element, namespace, prefix);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ContentAggregator: root element='" + element + "' ns='" + namespace + "' prefix='" + prefix + "'");
        }
    }

    public void addPart(String uri, String element, String namespace, String stripRootElement, String prefix) {
        Element elem = null;
        if (!element.equals("")) {
            elem = namespace.equals("") ? new Element(element, this.rootElement.namespace, this.rootElement.prefix) : new Element(element, namespace, prefix);
        }
        this.parts.add(new Part(uri, elem, stripRootElement));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ContentAggregator: part uri='" + uri + "' element='" + element + "' ns='" + namespace + "' stripRootElement='" + stripRootElement + "' prefix='" + prefix + "'");
        }
    }

    public void setConsumer(XMLConsumer consumer) {
        this.setContentHandler(consumer);
        this.setLexicalHandler(consumer);
    }

    public void recycle() {
        super.recycle();
        this.rootElement = null;
        int i = 0;
        while (i < this.parts.size()) {
            Part current = (Part)this.parts.get(i);
            if (current.source != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("releasing " + String.valueOf(current.source));
                }
                this.resolver.release(current.source);
            }
            ++i;
        }
        this.parts.clear();
        this.currentElement = null;
        this.resolver = null;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
        try {
            int i = 0;
            while (i < this.parts.size()) {
                Part current = (Part)this.parts.get(i);
                current.source = resolver.resolveURI(current.uri);
                ++i;
            }
        }
        catch (SourceException se) {
            throw SourceUtil.handle("Unable to resolve source.", se);
        }
    }

    private void startElem(Element element) throws SAXException {
        String qname;
        String string = qname = element.prefix.equals("") ? element.name : element.prefix + ':' + element.name;
        if (!element.namespace.equals("")) {
            this.contentHandler.startPrefixMapping(element.prefix, element.namespace);
        }
        this.contentHandler.startElement(element.namespace, element.name, qname, this.emptyAttrs);
    }

    private void endElem(Element element) throws SAXException {
        String qname = element.prefix.equals("") ? element.name : element.prefix + ':' + element.name;
        this.contentHandler.endElement(element.namespace, element.name, qname);
        if (!element.namespace.equals("")) {
            this.contentHandler.endPrefixMapping(element.prefix);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String raw, Attributes atts) throws SAXException {
        ++this.rootElementIndex;
        if (this.rootElementIndex == 0) {
            this.getLogger().debug("ContentAggregator: skipping root element start event.");
            return;
        }
        if (namespaceURI == null || namespaceURI.equals("")) {
            String qname = this.currentElement.prefix.equals("") ? localName : this.currentElement.prefix + ':' + localName;
            this.contentHandler.startElement(this.currentElement.namespace, localName, qname, atts);
        } else {
            this.contentHandler.startElement(namespaceURI, localName, raw, atts);
        }
    }

    public void endElement(String namespaceURI, String localName, String raw) throws SAXException {
        --this.rootElementIndex;
        if (this.rootElementIndex == -1) {
            this.getLogger().debug("ContentAggregator: skipping root element end event.");
            return;
        }
        if (namespaceURI == null || namespaceURI.equals("")) {
            String qname = this.currentElement.prefix.equals("") ? localName : this.currentElement.prefix + ':' + localName;
            this.contentHandler.endElement(this.currentElement.namespace, localName, qname);
        } else {
            this.contentHandler.endElement(namespaceURI, localName, raw);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    protected final class Element {
        public String namespace;
        public String prefix;
        public String name;

        public Element(String name, String namespace, String prefix) {
            this.namespace = namespace;
            this.prefix = prefix;
            this.name = name;
        }
    }

    protected final class Part {
        public String uri;
        public Element element;
        public Source source;
        boolean stripRootElement;

        public Part(String uri, Element element, String stripRoot) {
            this.uri = uri;
            this.element = element;
            this.stripRootElement = stripRoot.equals("yes") || stripRoot.equals("true");
        }
    }
}

