/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.pagination;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.transformation.pagination.PageRules;
import org.apache.cocoon.transformation.pagination.Pagesheet;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Paginator
extends AbstractTransformer
implements Composable,
Disposable,
CacheableProcessingComponent {
    public static final String PAGINATE_URI = "http://apache.org/cocoon/paginate/1.0";
    public static final String PAGINATE_PREFIX = "page";
    public static final String PAGINATE_PREFIX_TOKEN = "page:";
    private ComponentManager manager;
    private SAXParser parser;
    private Store store;
    private SourceResolver resolver;
    private Source inputSource;
    private int page;
    private int item;
    private String itemGroup;
    private String requestURI;
    private Request request;
    private Pagesheet pagesheet;
    private int level;
    private boolean prefixMapping;

    public void compose(ComponentManager manager) {
        try {
            this.manager = manager;
            this.getLogger().debug("Looking up " + SAXParser.ROLE);
            this.parser = (SAXParser)manager.lookup(SAXParser.ROLE);
            this.getLogger().debug("Looking up " + Store.ROLE + "/TransientStore");
            this.store = (Store)manager.lookup(Store.ROLE + "/TransientStore");
        }
        catch (Exception e) {
            this.getLogger().error("Could not find component", (Throwable)e);
        }
    }

    public void dispose() {
        if (this.parser != null) {
            this.manager.release((Component)this.parser);
        } else {
            this.parser = null;
        }
        if (this.store != null) {
            this.manager.release((Component)this.store);
        } else {
            this.store = null;
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        if (src == null) {
            throw new ProcessingException("I need the paginate instructions (pagesheet) to continue. Set the 'src' attribute.");
        }
        try {
            this.level = 0;
            this.prefixMapping = false;
            this.resolver = resolver;
            this.inputSource = resolver.resolveURI(src);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Using pagesheet: '" + this.inputSource.getURI() + "' in " + this + ", last modified: " + this.inputSource.getLastModified());
            }
            this.page = par.getParameterAsInteger(PAGINATE_PREFIX, 1);
            this.item = par.getParameterAsInteger("item", 0);
            this.itemGroup = par.getParameter("item-group", "");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Paginating with [page = " + this.page + ", item = " + this.item + ", item-group = " + this.itemGroup + "]");
            }
            this.request = ObjectModelHelper.getRequest(objectModel);
            this.requestURI = this.request.getRequestURI();
            if (this.store != null) {
                this.pagesheet = (Pagesheet)this.store.get((Object)src);
            }
            if (this.pagesheet == null || this.pagesheet.modifiedSince(this.inputSource.getLastModified())) {
                this.pagesheet = new Pagesheet();
                this.pagesheet.setLastModified(this.inputSource.getLastModified());
                this.parser.parse(new InputSource(this.inputSource.getInputStream()), (ContentHandler)this.pagesheet);
                if (this.store != null) {
                    this.store.store((Object)src, (Object)this.pagesheet);
                }
            }
            this.pagesheet = (Pagesheet)this.pagesheet.clone();
        }
        catch (SourceException se) {
            throw new ProcessingException("Could not retrieve source '" + src + "'", se);
        }
    }

    public void recycle() {
        if (null != this.inputSource) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        this.resolver = null;
        super.recycle();
    }

    public Serializable getKey() {
        if (this.inputSource.getLastModified() != 0L) {
            return this.inputSource.getURI() + this.page;
        }
        return null;
    }

    public SourceValidity getValidity() {
        if (this.inputSource.getLastModified() != 0L) {
            AggregatedValidity validity = new AggregatedValidity();
            validity.add((SourceValidity)new TimeStampValidity((long)this.page));
            validity.add(this.inputSource.getValidity());
            return validity;
        }
        return null;
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (!this.prefixMapping) {
            super.startPrefixMapping(PAGINATE_PREFIX, PAGINATE_URI);
            this.prefixMapping = true;
        }
        ++this.level;
        this.pagesheet.processStartElement(uri, loc);
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            int itemCount = this.pagesheet.itemCount(uri, loc);
            if (itemCount > 0) {
                String itemGroup = this.pagesheet.getItemGroupName(uri, loc);
                AttributesImpl atts = new AttributesImpl(a);
                atts.addAttribute(PAGINATE_URI, "item", "page:item", "CDATA", String.valueOf(itemCount));
                atts.addAttribute(PAGINATE_URI, "item-group", "page:item-group", "CDATA", itemGroup);
                super.startElement(uri, loc, raw, atts);
            } else {
                super.startElement(uri, loc, raw, a);
            }
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        --this.level;
        if (PAGINATE_URI.equals(uri)) {
            super.endElement(uri, loc, raw);
            return;
        }
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            if (this.level == 0) {
                if (this.item == 0) {
                    int totalPages = this.pagesheet.getTotalPages();
                    PageRules rules = this.pagesheet.getPageRules(this.page);
                    Integer[] rangeLinks = rules.getRangeLinks();
                    int unitLinks = rules.unitLinks;
                    int currentPage = this.page;
                    Paginator.addPaginateTags(rangeLinks, unitLinks, currentPage, totalPages, this.requestURI, this);
                } else {
                    int totalItems = this.pagesheet.getTotalItems(this.itemGroup);
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute(null, "current", "current", "CDATA", String.valueOf(this.item));
                    atts.addAttribute(null, "total", "total", "CDATA", String.valueOf(totalItems));
                    atts.addAttribute(null, "current-uri", "current-uri", "CDATA", this.requestURI);
                    atts.addAttribute(null, "clean-uri", "clean-uri", "CDATA", Paginator.cleanURI(this.requestURI, this.item));
                    atts.addAttribute(null, PAGINATE_PREFIX, PAGINATE_PREFIX, "CDATA", String.valueOf(this.pagesheet.getPageForItem(this.item, this.itemGroup)));
                    super.startElement(PAGINATE_URI, "item", "page:item", atts);
                    if (this.item > 1) {
                        atts.clear();
                        atts.addAttribute(null, "type", "type", "CDATA", "prev");
                        atts.addAttribute(null, "uri", "uri", "CDATA", Paginator.encodeURI(this.requestURI, this.item, this.item - 1));
                        super.startElement(PAGINATE_URI, "link", "page:link", atts);
                        super.endElement(PAGINATE_URI, "link", "page:link");
                    }
                    if (this.item <= totalItems) {
                        atts.clear();
                        atts.addAttribute(null, "type", "type", "CDATA", "next");
                        atts.addAttribute(null, "uri", "uri", "CDATA", Paginator.encodeURI(this.requestURI, this.item, this.item + 1));
                        super.startElement(PAGINATE_URI, "link", "page:link", atts);
                        super.endElement(PAGINATE_URI, "link", "page:link");
                    }
                    super.endElement(PAGINATE_URI, "item", "page:item");
                }
                super.endPrefixMapping(PAGINATE_PREFIX);
            }
            super.endElement(uri, loc, raw);
        }
        this.pagesheet.processEndElement(uri, loc);
    }

    public static void addPaginateTags(Integer[] rangeLinks, int unitLinks, int currentPage, int totalPages, String requestURI, AbstractTransformer saxTransformer) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(null, "current", "current", "CDATA", String.valueOf(currentPage));
        atts.addAttribute(null, "total", "total", "CDATA", String.valueOf(totalPages));
        atts.addAttribute(null, "current-uri", "current-uri", "CDATA", requestURI);
        atts.addAttribute(null, "clean-uri", "clean-uri", "CDATA", Paginator.cleanURI(requestURI, currentPage));
        saxTransformer.startElement(PAGINATE_URI, PAGINATE_PREFIX, "page:page", atts);
        int i = rangeLinks.length - 1;
        while (i > -1) {
            int rangeLink = rangeLinks[i];
            if (rangeLink > 0 && currentPage - rangeLink >= 1) {
                atts.clear();
                atts.addAttribute(null, "type", "type", "CDATA", "prev");
                atts.addAttribute(null, "range", "range", "CDATA", rangeLinks[i].toString());
                atts.addAttribute(null, "uri", "uri", "CDATA", Paginator.encodeURI(requestURI, currentPage, currentPage - rangeLink));
                atts.addAttribute(null, PAGINATE_PREFIX, PAGINATE_PREFIX, "CDATA", String.valueOf(currentPage - rangeLink));
                saxTransformer.startElement(PAGINATE_URI, "range-link", "page:range-link", atts);
                saxTransformer.endElement(PAGINATE_URI, "range-link", "page:range-link");
            }
            --i;
        }
        int i2 = currentPage - unitLinks;
        while (i2 < currentPage) {
            if (i2 > 0) {
                atts.clear();
                atts.addAttribute(null, "type", "type", "CDATA", "prev");
                atts.addAttribute(null, "uri", "uri", "CDATA", Paginator.encodeURI(requestURI, currentPage, i2));
                atts.addAttribute(null, PAGINATE_PREFIX, PAGINATE_PREFIX, "CDATA", String.valueOf(i2));
                saxTransformer.startElement(PAGINATE_URI, "link", "page:link", atts);
                saxTransformer.endElement(PAGINATE_URI, "link", "page:link");
            }
            ++i2;
        }
        int i3 = currentPage + 1;
        while (i3 <= currentPage + unitLinks) {
            if (i3 <= totalPages) {
                atts.clear();
                atts.addAttribute(null, "type", "type", "CDATA", "next");
                atts.addAttribute(null, "uri", "uri", "CDATA", Paginator.encodeURI(requestURI, currentPage, i3));
                atts.addAttribute(null, PAGINATE_PREFIX, PAGINATE_PREFIX, "CDATA", String.valueOf(i3));
                saxTransformer.startElement(PAGINATE_URI, "link", "page:link", atts);
                saxTransformer.endElement(PAGINATE_URI, "link", "page:link");
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < rangeLinks.length) {
            int rangeLink = rangeLinks[i4];
            if (rangeLink > 0 && currentPage + rangeLink <= totalPages) {
                atts.clear();
                atts.addAttribute(null, "type", "type", "CDATA", "next");
                atts.addAttribute(null, "range", "range", "CDATA", rangeLinks[i4].toString());
                atts.addAttribute(null, "uri", "uri", "CDATA", Paginator.encodeURI(requestURI, currentPage, currentPage + rangeLink));
                atts.addAttribute(null, PAGINATE_PREFIX, PAGINATE_PREFIX, "CDATA", String.valueOf(currentPage + rangeLink));
                saxTransformer.startElement(PAGINATE_URI, "range-link", "page:range-link", atts);
                saxTransformer.endElement(PAGINATE_URI, "range-link", "page:range-link");
            }
            ++i4;
        }
        saxTransformer.endElement(PAGINATE_URI, PAGINATE_PREFIX, "page:page");
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        this.pagesheet.processCharacters(c, start, len);
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.characters(c, start, len);
        }
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.ignorableWhitespace(c, start, len);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.skippedEntity(name);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (!this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            throw new SAXException("Recieved startDTD not in page.");
        }
        super.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        if (!this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            throw new SAXException("Recieved endDTD not in page.");
        }
        super.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.comment(ch, start, len);
        }
    }

    public static String cleanURI(String uri, int current) {
        String currentS = String.valueOf(current);
        int index = uri.lastIndexOf(currentS);
        if (index == -1) {
            return uri;
        }
        return uri.substring(0, index - 1) + uri.substring(index + currentS.length() + 1);
    }

    public static String encodeURI(String uri, int current, int next) {
        String currentS = String.valueOf(current);
        String nextS = String.valueOf(next);
        int index = uri.lastIndexOf(currentS);
        if (index == -1) {
            index = uri.lastIndexOf(46);
            if (index == -1) {
                return uri + "(" + nextS + ")";
            }
            return uri.substring(0, index) + "(" + nextS + ")." + uri.substring(index + 1);
        }
        return uri.substring(0, index) + nextS + uri.substring(index + currentS.length());
    }
}

