/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.cocoon.xml.AbstractXMLProducer;
import org.apache.cocoon.xml.EmbeddedXMLPipe;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DOMStreamer
implements XMLProducer {
    private final boolean DEFAULT_NORMALIZE_NAMESPACES = true;
    protected boolean normalizeNamespaces = true;
    protected NamespaceNormalizingDOMStreamer namespaceNormalizingDOMStreamer = new NamespaceNormalizingDOMStreamer();
    protected DefaultDOMStreamer defaultDOMStreamer = new DefaultDOMStreamer();
    protected static TransformerFactory factory = TransformerFactory.newInstance();

    public DOMStreamer() {
    }

    public DOMStreamer(XMLConsumer consumer) {
        this(consumer, consumer);
    }

    public DOMStreamer(ContentHandler content) {
        this(content, null);
        if (content instanceof LexicalHandler) {
            this.defaultDOMStreamer.setLexicalHandler((LexicalHandler)((Object)content));
            this.namespaceNormalizingDOMStreamer.setLexicalHandler((LexicalHandler)((Object)content));
        }
    }

    public DOMStreamer(ContentHandler content, LexicalHandler lexical) {
        this();
        this.defaultDOMStreamer.setContentHandler(content);
        this.defaultDOMStreamer.setLexicalHandler(lexical);
        this.namespaceNormalizingDOMStreamer.setContentHandler(content);
        this.namespaceNormalizingDOMStreamer.setLexicalHandler(lexical);
    }

    public void setConsumer(XMLConsumer consumer) {
        this.defaultDOMStreamer.setContentHandler(consumer);
        this.defaultDOMStreamer.setLexicalHandler(consumer);
        this.namespaceNormalizingDOMStreamer.setContentHandler(consumer);
        this.namespaceNormalizingDOMStreamer.setLexicalHandler(consumer);
    }

    public void setContentHandler(ContentHandler handler) {
        this.defaultDOMStreamer.setContentHandler(handler);
        this.namespaceNormalizingDOMStreamer.setContentHandler(handler);
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.defaultDOMStreamer.setLexicalHandler(handler);
        this.namespaceNormalizingDOMStreamer.setLexicalHandler(handler);
    }

    public void stream(Node node) throws SAXException {
        if (this.normalizeNamespaces) {
            this.namespaceNormalizingDOMStreamer.stream(node);
        } else {
            this.defaultDOMStreamer.stream(node);
        }
    }

    public boolean isNormalizeNamespaces() {
        return this.normalizeNamespaces;
    }

    public void setNormalizeNamespaces(boolean normalizeNamespaces) {
        this.normalizeNamespaces = normalizeNamespaces;
    }

    public void recycle() {
        this.defaultDOMStreamer.recycle();
        this.namespaceNormalizingDOMStreamer.recycle();
        this.normalizeNamespaces = true;
    }

    public class DefaultDOMStreamer
    extends AbstractXMLProducer {
        protected Transformer transformer;

        public void stream(Node node) throws SAXException {
            if (this.transformer == null) {
                try {
                    this.transformer = factory.newTransformer();
                }
                catch (TransformerConfigurationException e) {
                    this.getLogger().error("DOMStreamer", (Throwable)e);
                    throw new SAXException(e);
                }
            }
            DOMSource source = new DOMSource(node);
            ContentHandler handler = node.getNodeType() == 9 ? this.contentHandler : new EmbeddedXMLPipe(this.contentHandler);
            SAXResult result = new SAXResult(handler);
            result.setLexicalHandler(this.lexicalHandler);
            try {
                this.transformer.transform(source, result);
            }
            catch (TransformerException e) {
                this.getLogger().error("DOMStreamer", (Throwable)e);
                throw new SAXException(e);
            }
        }
    }

    public class NamespaceNormalizingDOMStreamer
    extends AbstractXMLProducer {
        protected ElementInfo currentElementInfo = null;
        protected int newPrefixCounter = 0;

        public void recycle() {
            super.recycle();
            this.currentElementInfo = null;
            this.newPrefixCounter = 0;
        }

        protected void stream(Node pos) throws SAXException {
            boolean isDoc;
            boolean bl = isDoc = pos.getNodeType() == 9;
            if (isDoc) {
                this.contentHandler.startDocument();
            }
            Node top = pos;
            while (null != pos) {
                this.startNode(pos);
                Node nextNode = pos.getFirstChild();
                while (null == nextNode) {
                    this.endNode(pos);
                    if (top.equals(pos)) break;
                    nextNode = pos.getNextSibling();
                    if (null != nextNode || null != (pos = pos.getParentNode()) && !top.equals(pos)) continue;
                    if (null != pos) {
                        this.endNode(pos);
                    }
                    nextNode = null;
                    break;
                }
                pos = nextNode;
            }
            if (isDoc) {
                this.contentHandler.endDocument();
            }
        }

        private final void dispatchChars(Node node) throws SAXException {
            String data = ((Text)node).getData();
            this.contentHandler.characters(data.toCharArray(), 0, data.length());
        }

        protected void startNode(Node node) throws SAXException {
            switch (node.getNodeType()) {
                case 8: {
                    if (this.lexicalHandler == null) break;
                    String data = ((Comment)node).getData();
                    this.lexicalHandler.comment(data.toCharArray(), 0, data.length());
                    break;
                }
                case 11: {
                    break;
                }
                case 9: {
                    break;
                }
                case 1: {
                    String uri;
                    NamedNodeMap atts = node.getAttributes();
                    int nAttrs = atts.getLength();
                    this.currentElementInfo = new ElementInfo(this.currentElementInfo);
                    int i = 0;
                    while (i < nAttrs) {
                        Node attr = atts.item(i);
                        String attrName = attr.getNodeName();
                        if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) {
                            int index = attrName.indexOf(":");
                            String prefix = index < 0 ? "" : attrName.substring(index + 1);
                            this.currentElementInfo.put(prefix, attr.getNodeValue());
                        }
                        ++i;
                    }
                    String namespaceURI = node.getNamespaceURI();
                    String prefix = node.getPrefix();
                    String localName = node.getLocalName();
                    if (localName == null) {
                        String[] prefixAndLocalName = this.getPrefixAndLocalName(node.getNodeName());
                        prefix = prefixAndLocalName[0];
                        localName = prefixAndLocalName[1];
                        namespaceURI = this.getNamespaceForPrefix(prefix, (Element)node);
                    }
                    if (namespaceURI != null) {
                        if (prefix == null) {
                            prefix = "";
                        }
                        if ((uri = this.currentElementInfo.findNamespaceURI(prefix)) == null || !uri.equals(namespaceURI)) {
                            if (uri != null) {
                                this.currentElementInfo.put(prefix, namespaceURI);
                            } else {
                                this.currentElementInfo.put(prefix, namespaceURI);
                            }
                        }
                    } else {
                        uri = this.currentElementInfo.findNamespaceURI("");
                        if (uri != null && !uri.equals("")) {
                            this.currentElementInfo.put("", "");
                        }
                    }
                    if (namespaceURI == null) {
                        namespaceURI = "";
                    }
                    String qName = prefix != null && prefix.length() > 0 ? prefix + ":" + localName : localName;
                    AttributesImpl newAttrs = new AttributesImpl();
                    int i2 = 0;
                    while (i2 < nAttrs) {
                        Node attr = atts.item(i2);
                        String attrName = attr.getNodeName();
                        String assignedAttrPrefix = null;
                        if (!attrName.equals("xmlns") && !attrName.startsWith("xmlns:")) {
                            String attrNsURI;
                            String attrLocalName;
                            String attrPrefix;
                            if (attr.getLocalName() == null) {
                                String[] prefixAndLocalName = this.getPrefixAndLocalName(attrName);
                                assignedAttrPrefix = attrPrefix = prefixAndLocalName[0];
                                attrLocalName = prefixAndLocalName[1];
                                attrNsURI = attrPrefix != null ? this.getNamespaceForPrefix(attrPrefix, (Element)node) : null;
                            } else {
                                attrLocalName = attr.getLocalName();
                                attrPrefix = attr.getPrefix();
                                attrNsURI = attr.getNamespaceURI();
                            }
                            if (attrNsURI != null) {
                                String declaredUri = this.currentElementInfo.findNamespaceURI(attrPrefix);
                                if (declaredUri == null || !declaredUri.equals(attrNsURI)) {
                                    String availablePrefix = this.currentElementInfo.findPrefix(attrNsURI);
                                    if (availablePrefix != null) {
                                        assignedAttrPrefix = availablePrefix;
                                    } else if (attrPrefix != null && declaredUri == null) {
                                        assignedAttrPrefix = attrPrefix;
                                        this.currentElementInfo.put(assignedAttrPrefix, attrNsURI);
                                    } else {
                                        ++this.newPrefixCounter;
                                        assignedAttrPrefix = "NS" + this.newPrefixCounter;
                                        this.currentElementInfo.put(assignedAttrPrefix, attrNsURI);
                                    }
                                } else {
                                    assignedAttrPrefix = attrPrefix;
                                }
                            }
                            String assignedAttrNsURI = attrNsURI != null ? attrNsURI : "";
                            String attrQName = assignedAttrPrefix != null ? assignedAttrPrefix + ":" + attrLocalName : attrLocalName;
                            newAttrs.addAttribute(assignedAttrNsURI, attrLocalName, attrQName, "CDATA", attr.getNodeValue());
                        }
                        ++i2;
                    }
                    if (this.currentElementInfo.namespaceDeclarations != null && this.currentElementInfo.namespaceDeclarations.size() > 0) {
                        Iterator localNsDeclIt = this.currentElementInfo.namespaceDeclarations.entrySet().iterator();
                        while (localNsDeclIt.hasNext()) {
                            Map.Entry entry = localNsDeclIt.next();
                            String pr = (String)entry.getKey();
                            String ns = (String)entry.getValue();
                            this.contentHandler.startPrefixMapping(pr, ns);
                        }
                    }
                    this.contentHandler.startElement(namespaceURI, localName, qName, newAttrs);
                    this.currentElementInfo.localName = localName;
                    this.currentElementInfo.namespaceURI = namespaceURI;
                    this.currentElementInfo.qName = qName;
                    break;
                }
                case 7: {
                    ProcessingInstruction pi = (ProcessingInstruction)node;
                    this.contentHandler.processingInstruction(pi.getNodeName(), pi.getData());
                    break;
                }
                case 4: {
                    if (this.lexicalHandler != null) {
                        this.lexicalHandler.startCDATA();
                    }
                    this.dispatchChars(node);
                    if (this.lexicalHandler == null) break;
                    this.lexicalHandler.endCDATA();
                    break;
                }
                case 3: {
                    this.dispatchChars(node);
                    break;
                }
                case 5: {
                    EntityReference eref = (EntityReference)node;
                    if (this.lexicalHandler == null) break;
                    this.lexicalHandler.startEntity(eref.getNodeName());
                    break;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public String getNamespaceForPrefix(String prefix, Element namespaceContext) {
            Node parent = namespaceContext;
            String namespace = null;
            if (prefix == null) {
                prefix = "";
            }
            if (prefix.equals("xml")) {
                namespace = "http://www.w3.org/XML/1998/namespace";
            } else if (prefix.equals("xmlns")) {
                namespace = "http://www.w3.org/2000/xmlns/";
            } else {
                short type;
                String declname = prefix == "" ? "xmlns" : "xmlns:" + prefix;
                while (null != parent && null == namespace && ((type = parent.getNodeType()) == 1 || type == 5)) {
                    Attr attr;
                    void var3_6;
                    if (var3_6 == true && (attr = parent.getAttributeNode(declname)) != null) {
                        namespace = attr.getNodeValue();
                        break;
                    }
                    parent = parent.getParentNode();
                }
            }
            return namespace;
        }

        private String[] getPrefixAndLocalName(String nodeName) {
            String localName;
            String prefix;
            int colonPos = nodeName.indexOf(":");
            if (colonPos != -1) {
                prefix = nodeName.substring(0, colonPos);
                localName = nodeName.substring(colonPos + 1, nodeName.length());
            } else {
                prefix = null;
                localName = nodeName;
            }
            return new String[]{prefix, localName};
        }

        protected void endNode(Node node) throws SAXException {
            switch (node.getNodeType()) {
                case 9: {
                    break;
                }
                case 1: {
                    this.contentHandler.endElement(this.currentElementInfo.namespaceURI, this.currentElementInfo.localName, this.currentElementInfo.qName);
                    if (this.currentElementInfo.namespaceDeclarations != null && this.currentElementInfo.namespaceDeclarations.size() > 0) {
                        Iterator namespaceIt = this.currentElementInfo.namespaceDeclarations.entrySet().iterator();
                        while (namespaceIt.hasNext()) {
                            Map.Entry entry = namespaceIt.next();
                            this.contentHandler.endPrefixMapping((String)entry.getKey());
                        }
                    }
                    this.currentElementInfo = this.currentElementInfo.parent;
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    EntityReference eref = (EntityReference)node;
                    if (this.lexicalHandler == null) break;
                    this.lexicalHandler.endEntity(eref.getNodeName());
                    break;
                }
            }
        }

        public class ElementInfo {
            public String localName;
            public String namespaceURI;
            public String qName;
            public Map namespaceDeclarations = null;
            public ElementInfo parent;

            public ElementInfo(ElementInfo parent) {
                this.parent = parent;
            }

            public void put(String prefix, String namespaceURI) {
                if (this.namespaceDeclarations == null) {
                    this.namespaceDeclarations = new HashMap();
                }
                this.namespaceDeclarations.put(prefix, namespaceURI);
            }

            public String getPrefix(String namespaceURI) {
                if (this.namespaceDeclarations == null || this.namespaceDeclarations.size() == 0) {
                    return null;
                }
                Iterator it = this.namespaceDeclarations.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (!entry.getValue().equals(namespaceURI)) continue;
                    return (String)entry.getKey();
                }
                return null;
            }

            public String getNamespaceURI(String prefix) {
                if (this.namespaceDeclarations == null || this.namespaceDeclarations.size() == 0) {
                    return null;
                }
                return (String)this.namespaceDeclarations.get(prefix);
            }

            public String findPrefix(String namespaceURI) {
                String prefix;
                if (this.namespaceDeclarations != null && this.namespaceDeclarations.size() != 0 && (prefix = this.getPrefix(namespaceURI)) != null) {
                    return prefix;
                }
                if (this.parent != null) {
                    return this.parent.findPrefix(namespaceURI);
                }
                return null;
            }

            public String findNamespaceURI(String prefix) {
                String uri;
                if (this.namespaceDeclarations != null && this.namespaceDeclarations.size() != 0 && (uri = (String)this.namespaceDeclarations.get(prefix)) != null) {
                    return uri;
                }
                if (this.parent != null) {
                    return this.parent.findNamespaceURI(prefix);
                }
                return null;
            }
        }
    }
}

