/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;

public class Collector {
    public static void collect(Compiler compiler, Node.Nodes page) throws JasperException {
        CollectVisitor collectVisitor = new CollectVisitor();
        page.visit(collectVisitor);
        collectVisitor.updatePageInfo(compiler.getPageInfo());
    }

    static class CollectVisitor
    extends Node.Visitor {
        private int maxTagNesting = 0;
        private int curTagNesting = 0;
        private boolean scriptingElementSeen = false;
        private boolean usebeanSeen = false;
        private boolean includeActionSeen = false;
        private boolean setPropertySeen = false;
        private boolean hasScriptingVars = false;

        CollectVisitor() {
        }

        public void visit(Node.ParamAction n) throws JasperException {
            if (n.getValue().isExpression()) {
                this.scriptingElementSeen = true;
            }
        }

        public void visit(Node.IncludeAction n) throws JasperException {
            if (n.getPage().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.includeActionSeen = true;
            this.visitBody(n);
        }

        public void visit(Node.ForwardAction n) throws JasperException {
            if (n.getPage().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.visitBody(n);
        }

        public void visit(Node.SetProperty n) throws JasperException {
            if (n.getValue() != null && n.getValue().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.setPropertySeen = true;
        }

        public void visit(Node.UseBean n) throws JasperException {
            if (n.getBeanName() != null && n.getBeanName().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.usebeanSeen = true;
            this.visitBody(n);
        }

        public void visit(Node.PlugIn n) throws JasperException {
            if (n.getHeight() != null && n.getHeight().isExpression()) {
                this.scriptingElementSeen = true;
            }
            if (n.getWidth() != null && n.getWidth().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.visitBody(n);
        }

        public void visit(Node.CustomTag n) throws JasperException {
            ++this.curTagNesting;
            if (this.curTagNesting > this.maxTagNesting) {
                this.maxTagNesting = this.curTagNesting;
            }
            boolean scriptingElementSeenSave = this.scriptingElementSeen;
            this.scriptingElementSeen = false;
            boolean usebeanSeenSave = this.usebeanSeen;
            this.usebeanSeen = false;
            boolean includeActionSeenSave = this.includeActionSeen;
            this.includeActionSeen = false;
            boolean setPropertySeenSave = this.setPropertySeen;
            this.setPropertySeen = false;
            boolean hasScriptingVarsSave = this.hasScriptingVars;
            this.hasScriptingVars = false;
            Node.JspAttribute[] attrs = n.getJspAttributes();
            int i = 0;
            while (i < attrs.length) {
                if (attrs[i].isExpression()) {
                    this.scriptingElementSeen = true;
                    break;
                }
                ++i;
            }
            this.visitBody(n);
            if (!this.hasScriptingVars) {
                this.hasScriptingVars = n.getVariableInfos() != null || n.getTagVariableInfos() != null && n.getTagVariableInfos().length > 0;
            }
            n.setScriptless(!this.scriptingElementSeen);
            n.setHasUsebean(this.usebeanSeen);
            n.setHasIncludeAction(this.includeActionSeen);
            n.setHasSetProperty(this.setPropertySeen);
            n.setHasScriptingVars(this.hasScriptingVars);
            this.scriptingElementSeen = this.scriptingElementSeen || scriptingElementSeenSave;
            this.usebeanSeen = this.usebeanSeen || usebeanSeenSave;
            this.setPropertySeen = this.setPropertySeen || setPropertySeenSave;
            this.includeActionSeen = this.includeActionSeen || includeActionSeenSave;
            this.hasScriptingVars = this.hasScriptingVars || hasScriptingVarsSave;
            --this.curTagNesting;
        }

        public void visit(Node.Declaration n) throws JasperException {
            this.scriptingElementSeen = true;
        }

        public void visit(Node.Expression n) throws JasperException {
            this.scriptingElementSeen = true;
        }

        public void visit(Node.Scriptlet n) throws JasperException {
            this.scriptingElementSeen = true;
        }

        public void updatePageInfo(PageInfo pageInfo) {
            pageInfo.setMaxTagNesting(this.maxTagNesting);
            pageInfo.setScriptless(!this.scriptingElementSeen);
        }
    }
}

