/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mortbay.http.ajp.AJP13Packet;

public class AJP13InputStream
extends InputStream {
    private AJP13Packet _packet;
    private AJP13Packet _getBodyChunk;
    private InputStream _in;
    private OutputStream _out;
    private boolean _gotFirst = false;
    private boolean _closed;

    AJP13InputStream(InputStream in, OutputStream out, int bufferSize) {
        this._in = in;
        this._out = out;
        this._packet = new AJP13Packet(bufferSize);
        this._getBodyChunk = new AJP13Packet(8);
        this._getBodyChunk.addByte((byte)65);
        this._getBodyChunk.addByte((byte)66);
        this._getBodyChunk.addInt(3);
        this._getBodyChunk.addByte((byte)6);
        this._getBodyChunk.addInt(bufferSize);
    }

    public void resetStream() {
        this._gotFirst = false;
        this._closed = false;
        this._packet.reset();
    }

    public void destroy() {
        if (this._packet != null) {
            this._packet.destroy();
        }
        this._packet = null;
        if (this._getBodyChunk != null) {
            this._getBodyChunk.destroy();
        }
        this._getBodyChunk = null;
        this._in = null;
        this._out = null;
    }

    public int available() throws IOException {
        if (this._closed) {
            return 0;
        }
        if (this._packet.unconsumedData() == 0) {
            this.fillPacket();
        }
        return this._packet.unconsumedData();
    }

    public void close() throws IOException {
        this._closed = true;
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    public int read() throws IOException {
        if (this._closed) {
            return -1;
        }
        if (this._packet.unconsumedData() <= 0) {
            this.fillPacket();
            if (this._packet.unconsumedData() <= 0) {
                this._closed = true;
                return -1;
            }
        }
        return this._packet.getByte();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this._closed) {
            return -1;
        }
        if (this._packet.unconsumedData() == 0) {
            this.fillPacket();
            if (this._packet.unconsumedData() == 0) {
                this._closed = true;
                return -1;
            }
        }
        return this._packet.getBytes(b, off, len);
    }

    public AJP13Packet nextPacket() throws IOException {
        if (this._packet.read(this._in)) {
            return this._packet;
        }
        return null;
    }

    private void fillPacket() throws IOException {
        if (this._closed) {
            return;
        }
        if (this._gotFirst || this._in.available() == 0) {
            this._getBodyChunk.write(this._out);
        }
        this._gotFirst = true;
        if (!this._packet.read(this._in)) {
            throw new IOException("EOF");
        }
        if (this._packet.unconsumedData() <= 0) {
            this._closed = true;
        } else if (this._packet.getInt() > this._packet.getBufferSize()) {
            throw new IOException("AJP Protocol error");
        }
    }

    public long skip(long n) throws IOException {
        if (this._closed) {
            return -1L;
        }
        int i = 0;
        while ((long)i < n) {
            if (this.read() < 0) {
                return i == 0 ? -1L : (long)i;
            }
            ++i;
        }
        return n;
    }
}

