/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpTunnel;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.StringMap;
import org.mortbay.util.URI;

public class ProxyHandler
extends AbstractHttpHandler {
    protected StringMap _DontProxyHeaders = new StringMap();
    protected StringMap _ProxySchemes;
    protected HashSet _allowedConnectPorts;

    public ProxyHandler() {
        Object o = new Object();
        this._DontProxyHeaders.setIgnoreCase(true);
        this._DontProxyHeaders.put("Proxy-Connection", o);
        this._DontProxyHeaders.put("Connection", o);
        this._DontProxyHeaders.put("keep-alive", o);
        this._DontProxyHeaders.put("Transfer-Encoding", o);
        this._DontProxyHeaders.put("TE", o);
        this._DontProxyHeaders.put("Trailer", o);
        this._DontProxyHeaders.put("Proxy-Authorization", o);
        this._DontProxyHeaders.put("Proxy-Authenticate", o);
        this._DontProxyHeaders.put("Upgrade", o);
        this._ProxySchemes = new StringMap();
        o = new Object();
        this._ProxySchemes.setIgnoreCase(true);
        this._ProxySchemes.put("http", o);
        this._ProxySchemes.put("https", o);
        this._ProxySchemes.put("ftp", o);
        this._allowedConnectPorts = new HashSet();
        this._allowedConnectPorts.add(new Integer(80));
        this._allowedConnectPorts.add(new Integer(8000));
        this._allowedConnectPorts.add(new Integer(8080));
        this._allowedConnectPorts.add(new Integer(8888));
        this._allowedConnectPorts.add(new Integer(443));
        this._allowedConnectPorts.add(new Integer(8443));
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        block19: {
            URI uri = request.getURI();
            if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
                this.handleConnect(pathInContext, pathParams, request, response);
                return;
            }
            try {
                URL url = this.isProxied(uri);
                if (url == null) {
                    return;
                }
                Code.debug((Object)"PROXY URL=", (Object)url);
                URLConnection connection = url.openConnection();
                HttpURLConnection http = null;
                if (connection instanceof HttpURLConnection) {
                    http = (HttpURLConnection)connection;
                    http.setRequestMethod(request.getMethod());
                    http.setInstanceFollowRedirects(false);
                }
                connection.setRequestProperty("Via", "1.1 (jetty)");
                String connectionHdr = request.getField("Connection");
                if (connectionHdr != null && (connectionHdr.equalsIgnoreCase("keep-alive") || connectionHdr.equalsIgnoreCase("close"))) {
                    connectionHdr = null;
                }
                Enumeration enumeration = request.getFieldNames();
                while (enumeration.hasMoreElements()) {
                    String hdr = (String)enumeration.nextElement();
                    if (this._DontProxyHeaders.containsKey(hdr) || connectionHdr != null && connectionHdr.indexOf(hdr) >= 0) continue;
                    Enumeration vals = request.getFieldValues(hdr);
                    while (vals.hasMoreElements()) {
                        String val = (String)vals.nextElement();
                        if (val == null) continue;
                        response.addField(hdr, val);
                    }
                }
                String cache_control = request.getField("Cache-Control");
                if (cache_control != null && (cache_control.indexOf("no-cache") >= 0 || cache_control.indexOf("no-store") >= 0)) {
                    connection.setUseCaches(false);
                }
                this.customizeConnection(pathInContext, pathParams, request, connection);
                try {
                    connection.setDoInput(true);
                    InputStream in = request.getInputStream();
                    if (in.available() > 0) {
                        connection.setDoOutput(true);
                        IO.copy(in, connection.getOutputStream());
                    }
                    connection.connect();
                }
                catch (Exception e) {
                    Code.ignore(e);
                }
                InputStream proxy_in = null;
                if (http != null) {
                    proxy_in = http.getErrorStream();
                    int code = 500;
                    code = http.getResponseCode();
                    response.setStatus(code);
                    response.setReason(http.getResponseMessage());
                }
                if (proxy_in == null) {
                    try {
                        proxy_in = connection.getInputStream();
                    }
                    catch (Exception e) {
                        Code.ignore(e);
                        proxy_in = http.getErrorStream();
                    }
                }
                int h = 0;
                String hdr = connection.getHeaderFieldKey(h);
                while (hdr != null) {
                    String val;
                    if (!this._DontProxyHeaders.containsKey(hdr) && (val = connection.getHeaderField(h)) != null) {
                        response.addField(hdr, val);
                    }
                    hdr = connection.getHeaderFieldKey(++h);
                }
                response.setField("Via", "1.1 (jetty)");
                request.setHandled(true);
                if (proxy_in != null) {
                    IO.copy(proxy_in, response.getOutputStream());
                }
            }
            catch (Exception e) {
                Code.warning(e.toString());
                Code.ignore(e);
                if (response.isCommitted()) break block19;
                response.sendError(400);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleConnect(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        URI uri = request.getURI();
        try {
            try {
                Code.debug((Object)"CONNECT: ", (Object)uri);
                InetAddrPort addrPort = new InetAddrPort(uri.toString());
                Integer port = new Integer(addrPort.getPort());
                if (!this._allowedConnectPorts.contains(port)) {
                    response.setStatus(403);
                }
                Socket socket = new Socket(addrPort.getInetAddress(), addrPort.getPort());
                request.getHttpConnection().setHttpTunnel(new HttpTunnel(socket));
                response.setStatus(200);
            }
            catch (Exception e) {
                Code.ignore(e);
                response.setStatus(405);
                Object var10_11 = null;
                response.setContentLength(0);
                request.setHandled(true);
                return;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            response.setContentLength(0);
            request.setHandled(true);
            throw throwable;
        }
        response.setContentLength(0);
        request.setHandled(true);
    }

    protected void customizeConnection(String pathInContext, String pathParams, HttpRequest request, URLConnection connection) throws IOException {
    }

    protected URL isProxied(URI uri) throws MalformedURLException {
        String scheme = uri.getScheme();
        return scheme != null && this._ProxySchemes.containsKey(scheme) ? new URL(uri.toString()) : null;
    }
}

