/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LazyList
extends AbstractList
implements Cloneable,
Serializable {
    private static final String[] __EMTPY_STRING_ARRAY = new String[0];
    private Object _first;
    private List _list;

    private LazyList(Object first) {
        this._first = first;
    }

    private LazyList(List list) {
        this._list = list;
    }

    public static LazyList add(LazyList list, Object item) {
        if (list == null) {
            return new LazyList(item);
        }
        if (list._list != null) {
            list._list.add(item);
            return list;
        }
        list._list = new ArrayList();
        list._list.add(list._first);
        list._list.add(item);
        list._first = null;
        return list;
    }

    public static LazyList add(LazyList list, Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            list = LazyList.add(list, i.next());
        }
        return list;
    }

    public static LazyList add(LazyList list, int initialSize, Object item) {
        if (list == null) {
            return new LazyList(item);
        }
        if (list._list != null) {
            list._list.add(item);
            return list;
        }
        list._list = new ArrayList(initialSize);
        list._list.add(list._first);
        list._list.add(item);
        return list;
    }

    public static LazyList remove(LazyList list, Object o) {
        if (list == null) {
            return null;
        }
        if (list._first != null && list._first.equals(o)) {
            return null;
        }
        list._list.remove(o);
        if (list._list.size() == 1) {
            list._first = list._list.get(0);
            list._list = null;
        }
        return list;
    }

    public static List getList(LazyList list) {
        return LazyList.getList(list, false);
    }

    public static List getList(LazyList list, boolean nullForEmpty) {
        if (list == null) {
            return nullForEmpty ? null : Collections.EMPTY_LIST;
        }
        if (list._list == null) {
            return list;
        }
        return list._list;
    }

    public static String[] toStringArray(LazyList list) {
        if (list == null) {
            return __EMTPY_STRING_ARRAY;
        }
        if (list._list != null) {
            String[] a = new String[list._list.size()];
            int i = list._list.size();
            while (i-- > 0) {
                Object o = list._list.get(i);
                if (o == null) continue;
                a[i] = o.toString();
            }
            return a;
        }
        return new String[]{list._first == null ? null : list._first.toString()};
    }

    public static int size(LazyList list) {
        if (list == null) {
            return 0;
        }
        if (list._list == null) {
            return 1;
        }
        return list._list.size();
    }

    public static Object get(LazyList list, int i) {
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        if (list._list == null) {
            if (i == 0) {
                return list._first;
            }
            throw new IndexOutOfBoundsException();
        }
        return list._list.get(i);
    }

    public static LazyList clone(LazyList list) {
        if (list == null) {
            return null;
        }
        return (LazyList)list.clone();
    }

    public Object get(int i) {
        if (this._list != null) {
            return this._list.get(i);
        }
        if (i != 0) {
            throw new IndexOutOfBoundsException("index " + i);
        }
        return this._first;
    }

    public int size() {
        if (this._list != null) {
            return this._list.size();
        }
        return 1;
    }

    public ListIterator listIterator() {
        if (this._list != null) {
            return this._list.listIterator();
        }
        return new SIterator();
    }

    public ListIterator listIterator(int i) {
        if (this._list != null) {
            return this._list.listIterator(i);
        }
        return new SIterator(i);
    }

    public Iterator iterator() {
        if (this._list != null) {
            return this._list.iterator();
        }
        return new SIterator();
    }

    public Object clone() {
        if (this._list != null) {
            return new LazyList(new ArrayList(this._list));
        }
        return new LazyList(this._first);
    }

    public String toString() {
        if (this._list == null) {
            return "[" + this._first + "]";
        }
        return this._list.toString();
    }

    public static String toString(LazyList list) {
        if (list == null) {
            return "[]";
        }
        return list.toString();
    }

    private class SIterator
    implements ListIterator {
        int i;

        SIterator() {
            this.i = 0;
        }

        SIterator(int i) {
            if (i < 0 || i > 1) {
                throw new IndexOutOfBoundsException("index " + i);
            }
            this.i = i;
        }

        public void add(Object o) {
            throw new UnsupportedOperationException("LazyList.add()");
        }

        public boolean hasNext() {
            return this.i == 0;
        }

        public boolean hasPrevious() {
            return this.i == 1;
        }

        public Object next() {
            if (this.i != 0) {
                throw new NoSuchElementException();
            }
            if (LazyList.this._list != null) {
                throw new ConcurrentModificationException();
            }
            ++this.i;
            return LazyList.this._first;
        }

        public int nextIndex() {
            return this.i;
        }

        public Object previous() {
            if (this.i != 1) {
                throw new NoSuchElementException();
            }
            --this.i;
            if (LazyList.this._list != null) {
                throw new ConcurrentModificationException();
            }
            return LazyList.this._first;
        }

        public int previousIndex() {
            return this.i - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException("LazyList.remove()");
        }

        public void set(Object o) {
            throw new UnsupportedOperationException("LazyList.add()");
        }
    }
}

