#!/bin/bash
# This file is used to generate the graphs. It should reside in
# Nagios cgi-bin directory (Noramally the sbin-dir in your Nagios
# installation).
#
#
# Change this if you are not installing apan in /usr/local/nagios/apan
DEFSFILE=/usr/local/nagios/apan/apan.defs
#
# Don't change anything below...
#

# Source the configuration
. $DEFSFILE
# Get the params from the called URL
HOST=`echo $QUERY_STRING|cut -d "&" -f 1|cut -d "=" -f 2`
CHECK=`echo $QUERY_STRING|cut -d "&" -f 2|cut -d "=" -f 2`

#Get the entry for this host/service from the config-file
CONF=`egrep "^$HOST;$CHECK" $CFGFILE`
COMM=`echo $CONF|cut -d ";" -f 6`

MDATE=`date +"%a, %d %b %Y %H:%M:%S %Z"`

#Genereta a header
echo "Cache-Control: no-store"
echo "Pragma: no-cache"
echo "Refresh: 90"
echo "Last-Modified: $MDATE"
echo "Expires: Thu, 01 Jan 1970 00:00:00 GMT"
echo "Content-type: text/html"
echo ""

echo "<HTML><HEAD><TITLE>$COMM for host $HOST</TITLE>"
echo "<LINK REL='stylesheet' TYPE='text/css' HREF='/nagios/stylesheets/status.css'></head><BODY>"
if [ "$CONF" = "" ]; then
	echo "<H2>Unknown host or service: $HOST / $CHECK</H2>"
	echo "<A HREF=javascript:history.go(-1)>Back</A>"
else
	TYPES=`echo $CONF|cut -d ";" -f 5`
	#echo $TYPES
	N=0
	for TYPE in $TYPES; do
		TYPE=`echo $TYPE|cut -d ":" -f 2`
		if [ $TYPE = "AREA" ]; then
			N=`echo "$N+1"|bc`
		fi
		#echo "<BR>Antal: $N<BR>"
	done
	echo "<TABLE CLASS='infoBox' BORDER=1 CELLSPACING=0 CELLPADDING=0>"
	echo "<TR><TD CLASS='infoBox'>"
	echo "<DIV CLASS='infoBoxTitle'>Current Network Status</DIV>"
	echo "Last Updated: $MDATE<BR>"
	echo "Updated every 90 seconds<br>"
	echo "Nagios&reg; - <A HREF='http://www.nagios.org' TARGET='_new' CLASS='homepageURL'>www.nagios.org</A><BR>"
	echo "Logged in as <i>nagios</i><BR>"
	echo "</TD></TR>"
	echo "</TABLE>"
	echo "<A HREF=javascript:history.go(-1)>Back</A>"
	echo "<H2>$COMM ($CHECK) for host $HOST</H2>"

#Draw either one or two columns with graphs

	if [ $N -ne 2 ]; then
		echo "Statistics for the last 10 minutes:<BR>"
		echo "<IMG SRC=generate.cgi?$HOST&$CHECK&600><BR>"
		echo "Statistics for the last hour:<BR>"
		echo "<IMG SRC=generate.cgi?$HOST&$CHECK&3600><BR>"
		echo "Statistics for the last 24 hours:<BR>"
		echo "<IMG SRC=generate.cgi?$HOST&$CHECK&86400><BR>"
		echo "Statistics for the last week:<BR>"
		echo "<IMG SRC=generate.cgi?$HOST&$CHECK&604800><BR>"
		echo "Statistics for the last Month:<BR>"
		echo "<IMG SRC=generate.cgi?$HOST&$CHECK&2851200><BR>"
		echo "Statistics for the last Year:<BR>"
		echo "<IMG SRC=generate.cgi?$HOST&$CHECK&31557600><BR>"
	else
		echo "<TABLE COLS=2 BORDER=1>"
		echo "<TR><TD COLSPAN=2>Statistics for the last 10 minutes:</TD></TR>"
		echo "<TR><TD><IMG SRC=generate.cgi?$HOST&$CHECK&600&0></TD>"
		echo "<TD><IMG SRC=generate.cgi?$HOST&$CHECK&300&1></TD></TR>"
		echo "<TR><TD COLSPAN=2>Statistics for the last hour:</TD></TR>"
		echo "<TR><TD><IMG SRC=generate.cgi?$HOST&$CHECK&3600&0></TD>"
		echo "<TD><IMG SRC=generate.cgi?$HOST&$CHECK&3600&1></TD></TR>"
		echo "<TR><TD COLSPAN=2>Statistics for the last 24 hours:</TD></TR>"
		echo "<TR><TD><IMG SRC=generate.cgi?$HOST&$CHECK&86400&0><BR></TD>"
		echo "<TD><IMG SRC=generate.cgi?$HOST&$CHECK&86400&1></TD></TR>"
		echo "<TR><TD COLSPAN=2>Statistics for the last week:</TD></TR>"
		echo "<TR><TD><IMG SRC=generate.cgi?$HOST&$CHECK&604800&0></TD>"
		echo "<TD><IMG SRC=generate.cgi?$HOST&$CHECK&604800&1></TD></TR>"

		echo "<TR><TD COLSPAN=2>Statistics for the last month:</TD></TR>"
		echo "<TR><TD><IMG SRC=generate.cgi?$HOST&$CHECK&2851200&0></TD>"
		echo "<TD><IMG SRC=generate.cgi?$HOST&$CHECK&2851200&1></TD></TR>"
		echo "<TR><TD COLSPAN=2>Statistics for the last year:</TD></TR>"
		echo "<TR><TD><IMG SRC=generate.cgi?$HOST&$CHECK&31557600&0></TD>"
		echo "<TD><IMG SRC=generate.cgi?$HOST&$CHECK&31557600&1></TD></TR>"
		echo "</TABLE>"
	fi


fi
echo "<A HREF=javascript:history.go(-1)>Back</A>"
echo "</BODY></HTML>"
