#!/bin/bash

# Change this if you are not installing apan in /usr/local/nagios/apan
DEFSFILE=/usr/local/nagios/apan/apan.defs
#
# Don't change anything below...
#

# Source the configuration
. $DEFSFILE

#Source the plugin-functions
for file in $PLUGSDIR/*.sh; do
	. $file
done

debug "`date` Args: $*"

#Read arguments from the command-line
CHECK=$1
HOST=$2
SVCNAME=$3
TIME=$4
WARN=$5
CRIT=$6

RETVAL=0
RETSTR=""

#Get configuration for this service
CONF=`grep "${HOST};${SVCNAME};" $CFGFILE`
ARGS="`echo $CONF|cut -d ";" -f 4`"
NAMES=`echo $CONF|cut -d ";" -f 5`
RRDFILE=`echo $CONF|cut -d ";" -f 3`

if [ "$CONF" = "" ]; then
	ERR=1
	RETVAL=3
	RETSTR="No perf-definition for service."
else

N=0
ERR=0
DATA="$TIME"
TEMPL=""
# Make a array of DS-names
for DS in $NAMES; do
	NAMELIST[N]=`echo $DS|cut -d ":" -f 1`
	N=`expr $N + 1`
done
N=0


################################################################3
case $CHECK in
	disk) disk
	;;
	nt-net) nt_net
	;;
	nt-disk) nt_disk
	;;
	nt-smtp) nt_smtp
	;;
	nt-load) nt_load
	;;
	load) load
	;;
	ping) ping
	;;
	lxk_pages) lxk_pages
	;;
	snmpget) snmpget
	;;
	disk_by_snmp) disk_by_snmp
	;;
	*)
		debug "Unknown service"
		RETSTR="Unknown Perf-service: $CHECK"
		RETVAL=3
		ERR=1
	;;
esac

fi
if [ $ERR = 0 ]; then
	if [ `echo $TEMPL|cut -b 1-1` = ":" ]; then
		TEMPL=`echo $TEMPL|cut -b 2-`
	fi
	$RRDTOOL update $RRDFILE -t $TEMPL $DATA
	debug "Inserting '$TEMPL' , '$DATA' into $RRDFILE"
else
	debug "Could not insert '$TEMPL' , '$DATA' into $RRDFILE"
fi

#debug "Returning '$RETSTR' , $RETVAL"
echo $RETSTR
exit $RETVAL
