#!/bin/sh
# 
# This file is used to generate the graphs. It should reside in
# Nagios cgi-bin directory (Noramally the sbin-dir in your Nagios
# installation).
#
#
# Change this if you are not installing apan in /usr/local/nagios/apan
DEFSFILE=/usr/local/nagios/apan/apan.defs
#
# Don't change anything below...
#

# Source the configuration
. $DEFSFILE

# Source the debug-function
. $PLUGSDIR/debug.sh

# Generate a valid header
case $IMGTYPE in
	PNG) echo "Content-type: image/png"
	;;
	GIF) echo "Content-type: image/gif"
	;;
	GD ) echo "Content-type: image/gd"
	;;
esac
echo ""

# Get the params from the called URL
HOST=`echo $QUERY_STRING|cut -d "&" -f 1`
CHECK=`echo $QUERY_STRING|cut -d "&" -f 2|sed -e 's/%20/ /'`
TIME=`echo $QUERY_STRING|cut -d "&" -f 3`
STEP=`echo $QUERY_STRING|cut -d "&" -f 4`

#Get the entry for this host/service from the config-file
CONF=`grep "${HOST};${CHECK}" $CFGFILE`

cgidebug "CONF: $CONF"

# Get some params from the config-entry
RDDFILE=`echo $CONF|cut -d ";" -f 3`
UNIT=`echo $CONF|cut -d ";" -f 7`
data=`echo $CONF|cut -d ";" -f 5`
EXTRA=`echo $CONF|cut -d ";" -f 8`

if [ "$STEP" != "" ]; then
	M=0
	N=0
	IN=$data
	STR=""
	for X in $IN; do
		Y=`echo $X|cut -d ":" -f 2`
	        if [ "$Y" = "AREA" ]; then
	                if [ $N = 0 ]; then
	                        N=`echo $N+1|bc`
	                else
	                        N=`echo $N+1|bc`
				M=`echo $N-2|bc`
				UT[$M]=$STR
				STR=""
			fi
		fi
		STR="$STR $X"
	done
	M=`echo $N-1|bc`
	UT[$M]=$STR
	data=${UT[$STEP]}
fi


N=0
ARG=""
for entry in $data; do
	COL=${COLS[$N]}
	tentry=`echo $entry|cut -d ":" -f 1|tr "/" "-"`
	TYPE=`echo $entry|cut -d ":" -f 2`
	ARG="$ARG DEF:var$N=$RDDFILE:$tentry:AVERAGE $TYPE:var${N}$COL:$tentry:"
	N=`echo "$N+1"|bc`
done

# Generate the image
$RRDTOOL graph - -s -$TIME -a $IMGTYPE -v $UNIT $EXTRA $ARG
cgidebug "$RRDTOOL graph - -s -$TIME -a PNG -v $UNIT $EXTRA $ARG"
