
disk() {
	RETSTR="Disk utilization: "
	for fs in `echo $ARGS|tr "|" " "`; do
		RES=`$PLUGINSDIR/nagios-stat -w 0 -m $fs disk $HOST`
		STATUS=$?
		if [ $STATUS -gt 2 ]; then
			RETVAL=$STATUS
			RETSTR=$RES
			ERR=1
			break
		fi
		util=`echo $RES|cut -d "%" -f 1|cut -d "(" -f 2`
		fsname=${NAMELIST[$N]}
		if [ $util -ge $CRIT ]; then
			RETVAL=2
			RETSTR=`echo "$RETSTR$fs($util%), "`
		elif [ $util -ge $WARN ]; then
			if [ $RETVAL = 0 ]; then
				RETVAL=1
			fi
			RETSTR=`echo "$RETSTR$fs($util%), "`
		fi
		TEMPL=`echo "${TEMPL}:$fsname"`
		DATA=`echo "${DATA}:$util"`
		N=`expr $N + 1`
	done
	if [ $RETVAL = 0 ]; then
		RETSTR="${RETSTR}All disks OK"
	fi
}

nt_disk() {
		RETSTR="Disk utilization: "
		for fs in `echo $ARGS|tr "|" " "`; do
			WARNL=`echo $WARN*1024*1024|bc`
			CRITL=`echo $CRIT*1024*1024|bc`
			RES=`$PLUGINSDIR/check_nt -H $HOST -v USEDDISKSPACE -l $fs`
			STATUS=$?
			if [ $STATUS != 0 ]; then
				RETVAL=3
				RETSTR="$RETSTR $RES"
				ERR=1
				break
			fi
			UTIL=`echo $RES|cut -d "-" -f 3|awk '{print $2}'` 
			FREE=`echo $RES|cut -d "-" -f 4|awk '{print $2}'`
			UTIL=`echo "$UTIL*1024*1024*1024"|bc -l`
			FREE=`echo "$FREE*1024"|bc -l`
			#debug "HOST Util: $UTIL, Free: $FREE"
			RETSTR="$RETSTR ${fs}: $FREE Mb free, "
			FREE=`echo "$FREE*1024*1024"|bc -l`
			TEMPL="$TEMPL:$fs-used:$fs-free"
			DATA="$DATA:$UTIL:$FREE"
			FREE=`echo $FREE|cut -d "." -f 1`
			#debug "NT-disk: $HOST: $FREE, $WARNL, $CRITL"
			if [ $FREE -lt $CRITL ]; then
				RETVAL=2
			elif [ $FREE -lt $WARNL ] && [ $RETVAL != 2 ]; then
				RETVAL=1
			fi
		done
}

	
