nt_perf() {
	for check in `echo $ARGS|tr " " ""|tr "|" " "`; do
		VALUE=`$PLUGINSDIR/check_nt_load $HOST $check`
		RESULT=$?
		RET=`echo $VALUE|cut -d ":" -f 1`
		VAL=`echo $VALUE|cut -d ":" -f 2`
		if [ $RET -gt 0 ]; then
			RETVAL=3
			RETSTR="Socket Error"
			ERR=1
			break
		fi
		NAME=${NAMELIST[$N]}
		RETSTR="${RETSTR}${check}: $VAL%, "
		if [ $VAL -ge $CRIT ]; then
			RETVAL=2
		elif [ $VAL -ge $WARN ] && [ $RETVAL != 2 ]; then
			RETVAL=1
		fi
		TEMPL="$TEMPL:$NAME"
		DATA="$DATA:$VAL"
		N=`expr $N + 1`
	done
}
load() {
	for check in `echo $ARGS|tr " " ""|tr "|" " "`; do
		VALUE=`$PLUGINSDIR/check_unix_load ${HOST} $check`
		RESULT=$?
		RET=`echo $VALUE|cut -d ":" -f 1`
		VAL=`echo $VALUE|cut -d ":" -f 2`
		if [ $RET -gt 0 ]; then
			RETVAL=3
			RETSTR=$VALUE
			ERR=1
			break
		fi
		NAME=${NAMELIST[$N]}
		RETSTR="${RETSTR}${check}: $VAL, "
		VAL=`echo $VAL|tr -d " %"`
		#if [ $VAL -ge $CRIT ]; then
			#RETVAL=2
		#elif [ $VAL -ge $WARN ] && [ $RETVAL != 2 ]; then
			#RETVAL=1
		#fi
		TEMPL="$TEMPL:$NAME"
		DATA="$DATA:$VAL"
		N=`expr $N + 1`
	done
}
nt_load() {
	for check in `echo $ARGS|tr " " ""|tr "|" " "`; do
		if [ $check = "CPULOAD" ]; then
			VALUE=`$PLUGINSDIR/check_nt -H $HOST -v CPULOAD -l 10,100,100`
			RESULT=$?
			VAL=`echo $VALUE|grep "%"|awk '{print $NF}'|cut -d "%" -f 1|tr -d " "`
		elif [ $check = "MEMUSE" ]; then
			VALUE=`$PLUGINSDIR/check_nt -H $HOST -v MEMUSE -w 100 -c 100`
			RESULT=$?
			VAL=`echo $VALUE|grep "%"|cut -d "-" -f 2|awk '{print $NF}'|tr -d "()% "`
		else
			RETVAL=3
			ERR=1
			RETSTR="Unknown value $check"
			break
		fi
		#debug "NT_LOAD, $HOST: $VALUE"
		if [ $RESULT -gt 0 ]; then
			RETVAL=3
			RETSTR="Socket Error"
			ERR=1
			break
		fi
		NAME=${NAMELIST[$N]}
		RETSTR="${RETSTR}${check}: $VAL%, "
		if [ $VAL -ge $CRIT ]; then
			RETVAL=2
		elif [ $VAL -ge $WARN ] && [ $RETVAL != 2 ]; then
			RETVAL=1
		fi
		TEMPL="$TEMPL:$NAME"
		DATA="$DATA:$VAL"
		N=`expr $N + 1`
	done
}
