snmpget() {
	RETSTR="SNMP OK: "
	for oid in `echo $ARGS|tr "|" " "`; do
		NAME=${NAMELIST[$N]}
		N=`expr $N + 1`
		COMM=`echo $oid|cut -d ":" -f 1`
		OID=`echo $oid|cut -d ":" -f 2`
		VALUE=`$PLUGINSDIR/check_snmp -H $HOST -C $COMM -o $OID`
		STATUS=$?
		#COUNTER=`echo $VALUE|cut -d ":" -f 2|tr -d " "`
		COUNTER=`echo $VALUE|awk '{print $NF}'`
		if [ $STATUS -gt 0 ]; then
			RETVAL=3
			RETSTR=`echo "$VALUE"|head -1`
			ERR=1
			break
		fi
		TEMPL="$TEMPL:$NAME"
		DATA="$DATA:$COUNTER"
		RETVAL=0
		RETSTR="${RETSTR}${NAME}:${COUNTER}, "
		ERR=0
	done
}

disk_by_snmp() {

	RETSTR="Disk usage:"
	for DISK in `echo $ARGS|tr "|" " "`; do
		NAME=${NAMELIST[$N]}
		N=`expr $N + 1`
		COMM=`echo $DISK|cut -d ":" -f 1`
		INDEX=`echo $DISK|cut -d ":" -f 2`
		# Get the allocation units...
		UNIT=`$PLUGINSDIR/check_snmp -H $HOST -C $COMM -o .1.3.6.1.2.1.25.2.3.1.4.$INDEX`
		RES=$?
		#If all is good so far, get the total size...
		if [ $RES = 0 ]; then
			SIZE=`$PLUGINSDIR/check_snmp -H $HOST -C $COMM -o .1.3.6.1.2.1.25.2.3.1.5.$INDEX`
			RES=$?
			#Everything should be working. Get the used space...
			if [ $RES = 0 ]; then
				USED=`$PLUGINSDIR/check_snmp -H $HOST -C $COMM -o .1.3.6.1.2.1.25.2.3.1.6.$INDEX`
	        		RES=$?
			fi
		fi
	#Bail out if anything went wrong...
	if [ $RES != 0 ]; then
		RETSTR="$RETSTR SNMP problem. No data received from host."
		RETVAL=3
		ERR=1
	else

	#Else start the calculations...
	#Parse the arguments...
	UNIT=`echo $UNIT|cut -d "-" -f 2|awk '{print $1}'`
	SIZE=`echo $SIZE|awk '{print $NF}'`
	USED=`echo $USED|awk '{print $NF}'`

#Convert used and fre space to kB, MB and GB.
	FREE=`echo "$SIZE $USED - p"|dc`
	BFREE=`echo "$FREE $UNIT * p"|dc`
	KFREE=`echo "$BFREE 1024 / p"|dc`
	MFREE=`echo "$BFREE 1048576 / p"|dc`
	GFREE=`echo "$BFREE 1073741824 / p"|dc`
	BUSED=`echo "$USED $UNIT * p"|dc`
        KUSED=`echo "$BUSED 1024 / p"|dc`
        MUSED=`echo "$BUSED 1048576 / p"|dc`
        GUSED=`echo "$BUSED 1073741824 / p"|dc`

#Calculate percentage free
	PROC=`echo "100*($USED/$SIZE)"|bc -l`
	debug "DISK: $HOST/$NAME: $PROC"
	TEMPL="$TEMPL:$NAME"
	DATA="$DATA:$PROC"
	ERR=0
	PROC=`echo "$PROC+0.5"|bc -l|cut -d "." -f 1`
#Print free space in the apropriate format.
        if [ $KFREE -lt 5000 ] ; then
                RETSTR="$RETSTR $KFREE kB free,"
        elif [ $MFREE -lt 5000 ]; then
                RETSTR="$RETSTR $MFREE MB free,"
        else
                RETSTR="$RETSTR $GFREE GB free,"
        fi

#Print used space in the apropriate format.
        if [ $KUSED -lt 5000 ] ; then
                RETSTR="$RETSTR $KUSED kB (${PROC}%) used."
        elif [ $MFREE -lt 5000 ]; then
                RETSTR="$RETSTR $MUSED MB (${PROC}%) used."
        else
                RETSTR="$RETSTR $GUSED GB (${PROC}%) used."
        fi

#Check warning and critical levels
	if [ $PROC -gt $CRIT ]; then
		RETVAL=2
	elif [ $PROC -gt $WARN ] && [ $RETVAL = 0 ]; then
		RETVAL=1
	fi
fi
done

}
