include(head.html.m4)
define(SECT,config)
include(navbar.html.m4)

TITLE(Configuration)

All the normal user settings of PROGTITLE are configurable in
the menu system. Since it is quite easy to get lost, here is a
(not always up-to-date) map of all submenus (the menu items have
an auto help display below if you don't touch any keys for some seconds,
 so to let you keep the overview here, I omit the simple items):

define(MI,<li><strong>$1</strong> ($2)</li>)

SUBSUBSECTION(Main Menu)
<ul>
MI(Game,start and setup a game)
<ul>
MI(Local Game,Starts a local game)
MI(Network Game,Connects to or creates a network game)
MI(Game Setup,Sets your favourite single player game mode: number of AI opponents, game speed, arena size)
</ul>
MI(Player Setup,Player customisation: [keyboard input, camera setup, multiplayer
mode on one computer])
<ul>
MI(Player 1-4,the settings for this player)
<ul>
MI(Input Configuration,keyboard and mouse setup)
MI(Camera Input Configuration,keyboard and mouse setup for camera controls)
MI(Camera Setup,camera mode options)
MI(Instant Chat,things you can say with one keystroke)
</ul>
MI(Assign Viewports To Players,which player sees himself on which part of
the screen)
</ul>
MI(System Setup, Configure sound, graphics and preferences here])
<ul>
MI(Display Settings,screen resolution and graphic details/preferences)
<ul>
MI(Screen Mode,resolution and windowed/fullscreen selection)
MI(Preferences,things that depend more on your personal taste)
MI(Detail Settings,things that affect visual quality and depend on your
system's OpenGL power)
MI(Performance Tweaks,[settings that increase graphics speed, but
may not work on your system])
</ul>
MI(Sound Settings,sound quality)
MI(Misc Stuff,things that did not fit anywhere else: [Moviepack, console text
output, menu wrap option and global keyboard configuration])
<ul>
MI(Global Keyboard Configuration,[keyboard setup for player-independent functions (console, scores)])
MI(Language settings,[Choose the language of PROGTITLE here])
</ul>
</ul>
</ul>

define(SI,<li>$1</li>)

<a name=new>SUBSECTION(New settings)</a>
PARAGRAPH([
Some of the new and maybe less obvious game settings in "Game Setup" available since version 0.2 are explained here:
<ul>
SI([The AIs come in various intelligence grades. Select it in the "AI IQ" menu item.])
SI([Explosions can blow away walls. Select in "Blast Radius" how much destruction they bring.])
SI([Cycle walls can be of finite length ( a la snake ). Choose in "Wall Length" how long they should be.])
SI([The delay between the a cycle explosion and the disappearing of its wall can be configured in "Wall Delay".])
SI([Arena size and overall game speed can be adjusted in "Arena Size" and "Speed". Note that the setting here is logarithmic; that
means that by increasing the value by 2, you double the arena size/game speed. by increasing the value by 6, you multiply the size/speed by a factor of 8.])
</ul>
Only important for multiplayer games:
<ul>
SI([Limits on the number of teams and the number of players per team can be set in the "Min/Max teams/players per team" settings.])
SI([You can control team ballance with the "Max imbalance" and "Ballance with AIs" settings.])
</ul>
])

<a name=files>SUBSECTION(Modify internal settings)</a>

PARAGRAPH([
The game is too slow for you? Then take a look at the files
FILE(settings.cfg) and FILE(settings_dedicated.cfg) for the dedicated server
(best save all your changes to 
FILE(autoexec.cfg) if you don't want the next
release of PROGTITLE to overwrite them).
Play a bit with <CODE>CYCLE_SPEED</CODE> and all the other
nice variables and see what happens.
You can place comments preceeded by <CODE>#</CODE>.
In a network game, the game physics settings are
transferred from the server to the clients. 
Not all possible setting items are included in these files, you can add everything
you find in LINK(commands.html,this unsorted document).
])

PARAGRAPH([
The acceleration caused by the wall at distance <CODE>D</CODE> is
<pre>
acceleration=CYCLE_ACCEL / (CYCLE_ACCEL_OFFSET + D)-
             CYCLE_ACCEL / (CYCLE_ACCEL_OFFSET + CYCLE_WALL_NEAR)
</pre>
if the wall is closer than <CODE>CYCLE_WALL_NEAR</CODE>. 
the stuff in the second
line just makes sure that the acceleration is 0 if 
<CODE>D=CYCLE_WALL_NEAR</CODE>, so there are no "jumps".)
])
 
PARAGRAPH([
The <CODE>CYCLE_RUBBER</CODE> setting is a niceness thing, especially useful
in an internet game where player prediction is poor: if you
hit a wall, you are not directly deleted; you are stopped for a
short time and your supply of "rubber" is decreased. If you manage
to turn fast enough, you won't die. the rubber supply will
slowly increase again (on a timescale of 10 seconds, approximately).
<CODE>CYCLE_RUBBER</CODE> gives the maximum amount of rubber you have got.
Setting it too high (~1000000) will make all cycles (your opponents,
too!)  immortal, setting it to zero is the way it used to be until 
version 000518. One is a good value for single player games, 3 .. 10
for network games (the more ping, the higher the setting should be).
In the current version, the setting on the clients is in effect, so you
can cheat a little bit in network mode if you increase your rubber.
])

PARAGRAPH([
A special feature are the <CODE>CAMERA_FORBID_*</CODE> settings; 
if you think for
example that using the free floating camera is cheating, simply
set <CODE>CAMERA_FORBID_FREE</CODE> to 1 on your server; 
none of the clients will
then be able to use the free camera. (Of course, it is possible
for a modified client to cheat at this point, using the forbidden
camera perspectives anyway.) Try a match with all but the internal
camera disabled :-)
])

PARAGRAPH([
The settings that affect only the visual appearance (<CODE>FLOOR_*</CODE> ...)
are not transferred; It stays a matter of taste if you want the floor
red or yellow.
])

<a name=console>SUBSECTION(The Console)</a>
PARAGRAPH([
All the settings you alter permanently in the .cfg-files can be
tested temporarily if you enter them at the console. To enter a
line to the console, you have to bind a key to it 
(in "Misc Stuff/Global Keyboard Configuration") and press it, of course.
The line you enter will be interpreted just as if it was read from
a config file.
if you type in an incomplete
name, you'll get a list of settings that contain that name. Just typing
the name of a setting will print the current value.
<br>
If you run a <a href=network.html#dedicated>dedicated server</a>, 
everything you type will be considered console input.  
])

SUBSUBSECTION(Special Console Commands)
define(CC,<tr><td valign=top><CODE>$1 </CODE></td><td>$2</td></tr>)
<CODE>x</CODE> always is a real number, <CODE>n</CODE> an integral number,
<CODE>b</CODE> a boolean value (0=false,1=true) and <CODE>s</CODE> a string
(all the rest of the line will be read).
<table>
CC(START_NEW_MATCH,[reset the scores and start a new match in the next round])
CC(DEDICATED_IDLE x,[Only used by the dedicated server: after running for x hours, the server takes the next opportunity (when no one is online) to quit.])
CC(QUIT or EXIT,[shuts the server down])
CC(KICK s,[Kicks player s from the server])
CC(CENTER_MESSAGE/CONSOLE_MESSAGE s,[Prints a message for all connected clients at the
center of the screen/on the console])
CC(SAY,[Dedicated server only: let the server administrator say something])
</table>
SUBSUBSECTION(Other Console Commands)
<table>
CC(CYCLE_SPEED x, basic cycle speed (m/s))
CC(CYCLE_START_SPEED x,cycle speed at startup)
CC(CYCLE_ACCEL x,acceleration multiplicator)
CC(CYCLE_ACCEL_OFFSET x,acceleration offset (higher means lower acceleration))
CC(CYCLE_DELAY x,minimum time between turns)
CC(CYCLE_WALL_NEAR x,when is a wall near?)
CC(CYCLE_SOUND_SPEED x,sound speed divisor; the speed at which the cycle sound is played at normal speed) 
CC(CYCLE_BRAKE x,brake strength)
CC(CYCLE_RUBBER x,niceness when hitting a wall)
CC(CYCLE_PING_RUBBER x,[niceness when hitting a wall, influence of your ping])
CC(FLOOR_RED/GREEN/BLUE x,floor colour (without moviepack))
CC(FLOOR_MIRROR_INT x,floor mirror intensity(if enabled))
CC(GRID_SIZE x,distance of the grid lines)
CC(CAMERA_FORBID_SMART b,forbid smart camera)
CC(CAMERA_FORBID_IN b,forbid internal camera)
CC(CAMERA_FORBID_FREE b,forbid free camera)
CC(CAMERA_FORBID_FOLLOW b,forbid fixed external camera)
CC
CC(SCORE_WIN n,points you gain for being last one alive)
CC(SCORE_SUICIDE n,points you gain for every stupid death 
(race into the rim/your own wall); should be negative)
CC(SCORE_KILL n,points you gain for everyone racing into your wall)
CC(SCORE_DIE n,points you gain for every time you race into someone's wall (should be negative))
CC
CC(LIMIT_SCORE n,score limit (all limits for one match))
CC(LIMIT_ROUNDS n,maximum number of rounds to play)
CC(LIMIT_TIME n,maximum time (in minutes))
CC(MESSAGE_OF_DAY_1/2/3/4 s,message lines sent to the clients upon connection)
CC
CC(COLOR_STRINGS b,draw strings in colour?)
</table>

PARAGRAPH(
<a name=sphh>Settings for single player highscore hunt on this server:</a>
<table>
CC(SP_SCORE_WIN n,points you gain for being last one alive)
CC(SP_LIMIT_ROUNDS n,max number of rounds to play)
CC(SP_LIMIT_TIME n,max time (in minutes))
CC(SP_AIS n,number of opponents you will face)
</table>
)

PARAGRAPH(
Ladder league constants:
<table>
CC(LADDER_PERCENT_BET x,percentage of your score to be put in the pot)
CC(LADDER_MIN_BET x,minimum credits to be put in the pot)
CC(LADDER_TAX x,percentage the IRS takes from the pot)
CC(LADDER_LOSE_PERCENT_ON_LOAD x,you loose this percentage of your
score every time the server is restarted)
CC(LADDER_LOSE_MIN_ON_LOAD x,but minimum this value)
CC(LADDER_GAIN_EXTRA x,the winner gets his ping+ping charity
(in seconds) times this value extra)
</table>
)

SECTION(Complete List)
PARAGRAPH([
A complete list of all available commands is available LINK(commands.html,here).
])

include(sig.m4)
include(navbar.html.m4)
</body>
</html>


