include(head.html.m4)
define(SECT,install_linux)
include(navbar.html.m4)

TITLE(LINUX Installation)

SECTION(General comments)
PARAGRAPH([
All installation has to be carried out as root. Installation from a source archive is recommended,
as Armagetron will be tailored for your system and missing libraries will be identified and
pointed out to you. Only as a last resort, you should choose the binary archives. The binary RPMs
and Debian packages are a reasonable choice if your system supports them and you can get hold of
the corresponding library packages in the right versions.
])
PARAGRAPH([
The executable should not be started directly, as it will not find its data
files. Instead, call the scripts installed in FILE(PREFIX/bin).
])
PARAGRAPH([
It is very important that Armagetron and all of its dependencies are built with the same
compiler. The different versions of gcc tend to be slightly binary incompatible with each other,
and on complex projects like this one these small glitches tend to cause unexplainable problems.
The distributed binaries are compiled with gcc 2.95.3, sometimes I do tests with gcc 3.3 and 
gcc 3.2.2.
])

SECTION(Required libraries,libs)

ULIST([
ITEM([OpenGL or ELINK(mesa3d.sourceforge.net/,Mesa) for rendering])
ITEM(ELINK(www.libsdl.org,SDL) version 1.2.x (Simple Direct Media Layer) for input and sound output)
ITEM(ELINK(www.libsdl.org/projects/SDL_image/index.html, SDL_image)
version 1.2.x for the textures
which itself needs the libs)
ITEM(ELINK(www.libpng.org/pub/png/pngcode.html,pnglib and zlib)
(they should be included in your distribution))
ITEM(Optional: ELINK(www.libsdl.org/projects/SDL_mixer/,SDL_mixer))
ITEM([Binary versions only: libstdc++-libc6.2-2.so.3. Use 
ELINK([rpmfind.net/linux/rpm2html/search.php?query=libstdc%2B%2B-libc6.2-2.so.3&submit=Search+...&system=&arch=],rpmfind)
or
ELINK([www.google.com/search?q=libstdc%2B%2B-libc6.2-2.so.3&sourceid=opera&num=0&ie=utf-8&oe=utf-8],google)
to find a RPM with that library for your system. Sorry, Debian users: I don't know what you need to do; use the
source packages instead.])
])

PARAGRAPH(,[
You may take a look at the ELINK(WEBBASE/compatibility.html,compatibility table)
if you want to check how likely it is for Armagetron to work on your PC.
])

SECTION(Installation)

SUBSECTION(Source archive,source)
PARAGRAPH([
Unpack the archive and change into the unpacked directory; type 
CMDLINE(./configure
gmake install)
Everything will be copied to FILE(PREFIX/games/armagetron). Should there already be a version,
make will fail; use OPTION(gmake update). If FILE(gmake) is not found on your system, try 
FILE(make); however, only GNU make is supported.
To build the dedicated server, add the option OPTION(--disable-glout) to the configure script.
To change the installation path, use the option OPTION(--prefix=new_path).
Type CMDLINE(PROGNAME --uninstall) to uninstall.
])

PARAGRAPH([
Please ELINK(armagetron.sf.net/contact.html,report it) if this procedure gives you errors you cannot
resolve; the goal is to make it work on as many systems as possible.
])

SUBSECTION(Binary RPM,rpm)
PARAGRAPH([
Type CMDLINE(rpm -i filename.rpm) The RPM build is quite untested, so it may be
that it has registered too many dependencies and you are not allowed to install it; 
you may use the additional switch OPTION(--nodeps) to ignore these errors. However, you
may then end up with a broken installation.<br>
The documentation can then found in FILE(/usr/share/doc/packages/armagetron).
To uninstall, type CMDLINE(rpm -e armagetron)
])

ifelse(,,,
SUBSECTION(Debian)
PARAGRAPH([
TODO
])
)

SUBSECTION(Source RPM)
PARAGRAPH([
Type CMDLINE(rpm --rebuild filename.src.rpm) 
This should build binary RPMs suitable for your system in FILE(/usr/src/redhat/RPMS/i386) ( RedHat )
resp. FILE(/usr/src/packages/RPMS/i386) ( SuSE ); you may have to look into the other subdirectories
of FILE(RPMS) to find them. Proceed as described in the LINK([install_linux.html#rpm],[previous paragraph]).<br>
Alternatively, type CMDLINE(rpm -i filename.src.rpm)
This should extract a source package in FILE(/usr/src/.../SOURCES) you can handle like
described LINK([install_linux.html#source],[in the first section]). You can
surely ignore all failed dependencies with OPTION(--nodeps) since the 
dependencies were all there when you built the package. ( It is possible,
if not likely, that the automatic dependency generation of RPM produces
junk. )
])

dnl SUBSECTION(netbsd)
dnl cd /usr/pkgsrc/games/armagetron
dnl make install

SUBSECTION(Binary archive)
PARAGRAPH([
Unpack the archive and change into the unpacked directory; type CMDLINE(./install)Everything will
be copied to FILE(PREFIX/games/armagetron). Type CMDLINE(PROGNAME --uninstall) to uninstall.
])

SECTION(Dedicated Server)
PARAGRAPH([
To install the dedicated server from binaries,
follow all the procedures above with the corresponding
download files; the server will be installed in
FILE(usr/local/games/PROGNAME[_]dedicated) and can be invoked by
CMDLINE(PROGNAME[_]dedicated) If you want it to run in the background,
start it with the command line CMDLINE(PROGNAME[_]dedicated --daemon)
])
PARAGRAPH([
The dedicated server will read its configuration from 
FILE(PREFIX/games/PROGNAME[_]dedicated/config) and FILE(~/.armagetron/var).
])


SECTION(Result)
define(DOCSTYLE_RESULT,unix)
include(install_result.html.m4)

SECTION(Play)
PARAGRAPH([
Type CMDLINE(PROGNAME)
as a normal user to play.
])

PARAGRAPH([
In case you want to install a permanent server: in 
FILE(PREFIX/games/PROGNAME[_]dedicated/rc.d) is a a System V init script; putting soft link 
to it into FILE(/etc/init.d/...) will start the server as the user "armagetron" 
as a background process when your system starts. Feel free to adapt it to your needs.
])

include(sig.m4)
include(navbar.html.m4)
</body>
</html>
