include(head.html.m4)
define(SECT,network)
include(navbar.html.m4)

<a name=np>TITLE(Network Play)</a>

PARAGRAPH([
You can play PROGTITLE over a LAN or the Internet. It uses the UDP 
connectionless communication mode of the IP protocol, so make sure 
you have TCP/IP installed.
])

SECTION(Connecting)

SUBSECTION(LAN game )
PARAGRAPH([
The fastest computer in your network should
act as the server. There, go to the network menu and hit the "LAN Game"-
menu item. After a second, PROGTITLE should tell you that there are no servers
currently available, but offer a "Host Game" item. Press Return on it. In
the following menu, you can select a name for your server and the game options.
The game options here are completely independent from those in single
player mode.
After everything is to your liking, you can hit the "Host Network Game"
menu item and the game will start on the server and
run just as in single player mode.
])

PARAGRAPH([
The other computers will be the clients. On them, you activate the "LAN Game"
menu item, too. This time however, there should be the server you just started
visible in the server browser. Just hit Return on it to connect.
])

SUBSECTION(Internet game)

PARAGRAPH([
An internet game works the same way; you just have to choose "Internet Game" instead of "LAN Game"
in the menu. Note that the number of users currently online on each server is displayed
by the server browser, too.
])

SUBSUBSECTION(Current status)
PARAGRAPH([
At the time of this writing, there are about ten dedicated servers available, so you should
not need to start your own. Most of them will let you fight against a bunch of AIs
while you wait for other players to join in.
])

PARAGRAPH([
Finding an opponent to play against should not be a problem these times; nevertheless,
there still is the ELINK(WEBBASE/meeting.html, meeting
page). Check it out, be online when the countdown reaches zero and
you will certainly find another player online. I'm usually playing at these times and
specially like to be on a server that allows cockpit view only.
])

SUBSECTION(Fallback)

PARAGRAPH([
If the server browser does not work for some reason (i.e. no master server
available), you can still connect to a server if you know its network address or
hostname and the port it runs on. The "Custom Connect" menu item in the network
game menu serves that purpose.])

SUBSECTION(Version control)

PARAGRAPH([
Server and client do not need to be of the same version. If an older client connects to
a server, the server will simply disable the features not supported by the client. This may be 
undesired, since users of newer versions will experience varying gameplay depending on other
clients connected. Server admins can fine-tune the number of older client versions supported with
the variable <CODE>BACKWARD_COMPATIBILITY</CODE>; setting it to zero will prevent all older clients from
connecting. On the other hand, you can simply disable new features by setting <CODE>NEW_FEATURE_DELAY</CODE>
to some positive value. If both configuration variables are set to the same value, no feature will be enabled
or disabled just because an old client connects/disconnects.
])
PARAGRAPH([
The server browser will show you the compatibility status of the available servers; servers with
a version similar to yours will be found higher in the list. For a list of the protocol versions supported
by different PROGTITLE versions, LINK(versions.html,see here).
])

SECTION(Technical details)

PARAGRAPH([
You are not limited to one player per computer;
on each of them you can play with up to four people. In the
precompiled version, there is a limit of 16 clients.
You can set the configuration variable <CODE>MAX_CLIENTS</CODE> to limit it further.
If you compile your PROGTITLE server yourself, 
you can increase the limit in the file "network.h". Just change the line
<pre>
#define MAXCLIENTS 16
</pre>
to whatever you like.
])

PARAGRAPH([
If you are behind a masquerading firewall ( such as a DSL router or the Microsoft connection sharing ),
you cannot act as a server; your computer is then unreachable from the outside unless
you manage to forward port 4534 UDP connections from the firewall to your server.
Most software solutions and some standalone DSL routers offer this option, so you may be lucky.
])

PARAGRAPH([
The client may be behind a firewall as long as it allows outgoing UDP connections
on the PROGTITLE port.
])

<a name=dedicated>SECTION(The dedicated server)</a>

PARAGRAPH([
Following the model of Quake 1-3, there is a special binary version of
the game available for download (or compile it yourself giving the
option OPTION(--disable-glout) to configure) that has all input/output
features disabled. If you start it, it will read the normal configuration files and
set up a network game according to the settings in
the game menu (Number of AI players, game mode and finish mode).
A dedicated server takes input from the keyboard and interprets
it just the way it does with the 
<a href="config.html#files">configuration files</a>.
Additionally to the usual configuration files, the dedicated server
will read the file FILE(everytime.cfg) from the FILE(var) directory
 before each round; it may be comfortable to place quickly changing 
settings there. You can join the game on the dedicated server just the way
described <a href=#np>above</a>.
])

PARAGRAPH([
The advantages of this solution are:
<ul>
<li>there is no longer a "privileged" player; all players are clients
to the dedicated server.</li>

<li>
the dedicated server can use it's full computing power just to
manage the game; it does not have to bother about input or 3d rendering.
So, the game is a bit smoother for all players.
</li>

<li>
the dedicated server should run on any 32 Bit Windows and about any UNIX; 
it does not need any special library installed (OpenGL, SDL, ...) , so 
it is easy to set up public internet servers.
</li>

<li>
The dedicated server uses less CPU power than a client because
it does not have to care about graphics and sound. It can be run on an older PC.
</li>
</ul>
])

SECTION(Ping Charity)

PARAGRAPH([
Ping charity can be configured along with your network bandwidth and other settings
in the "Network Setup" submenu in the "Network Game" menu.
])

PARAGRAPH([
It is the configurable part of the "equal ping" technology. In short,
if you have low ping and your opponent has high ping (ping: the time
it takes a message to travel from your computer to the server and
back, usually measured in milliseconds), you can take over some of his 
ping to make the situation more equal.
So, if you have ping 60, your 
opponent has ping 160 and you set the ping charity to at least 50
(more does not change the situation), you  will take over 50 ms of 
his ping, giving you both ping 110. If you set your ping charity to
20,  you will end up with ping 80, your opponent with ping 140. Of
course,  you may be greedy and set ping charity to zero, but
I suggest leaving it at the default value 100.
])

PARAGRAPH([
How does that "equal ping" thing work? It is not that complicated, but
for now, I rather keep the secret buried in the source code (too lazy
to explain it right now...).
])


SECTION(Spectator Mode)

PARAGRAPH([
In the player menu, there is the "Spectator mode" toggle; If you just
want to watch an internet game, connect to the server with spectator
mode enabled. Note that you will be almost completely ignored in
spectator mode: the other players won't know you are there at all,
you can't chat and the dedicated server will not bother to start
a game if only spectators are online (all you are going to get is
a black screen). Only the server administrator will get a message 
that a client connected.
])

SECTION(Scores)

PARAGRAPH([
In a multiplayer game, every crucial action makes you gain or lose
points; after
<ul>
<li>a fixed number of rounds has been played</li>
<li>a fixed time elapsed or</li>
<li>a fixed score is reached</li>
</ul>

the team with the most points wins the match. If two or more
teams share the first place, the fight continues until there is
a unique winner. 
<br>
You can configure the score/time/rounds-limits in the file 
FILE(settings.cfg); scores and winners are logged in the file 
FILE(scorelog.txt) on the server.
])

PARAGRAPH([
If you are the only person on a dedicated server, a special
single player game is started (its parameters are determined in
the LINK([config.html#sphh],[SP_* variables])
 in FILE(settings.txt) on the server) to keep
you busy until someone else connects; the highscores in
this mode may be published by the server administrator.
<br>
The highest scores collected in a single player game are collected
in the file FILE(highscores.txt), the people with the most won multiplayer
rounds/matches are stored in FILE(won_rounds.txt) and FILE(won_matches.txt).
A ladder is stored in FILE(ladder.txt).
<br>
Note: these statistics have all not been adapted to team play and most of them
will store very odd results.
])

<a name=bb>SECTION(BIG BROTHER)</a>

PARAGRAPH([
As in any software downloaded for free, you can't be completely
sure whether PROGTITLE has secret functions that, for example,
spy on your system internals, exploit known Windows bugs to
get to your ISP's password, etc... and send this information
to the author. Of course, PROGTITLE does not do such a thing,
and you can check that in the source code.
<br>
But PROGTITLE DOES send some information out: If you connect
to the master server for the first time, PROGTITLE will send
<br>
<ul>
<li>Your Operating system and PROGTITLE/SDL version</li>
<li>the information the OpenGL system offers, telling me which
graphic card you use</li>
<li>if you are running PROGTITLE fullscreen or windowed</li>
</ul>

and nothing else, especially no personal information. I hope
you understand that there is a good reason to collect this information.
If you don't want to reveal these facts, simply edit
your PROGNAME configuration file FILE(user.cfg)
and change
<br>
<CODE>BIG_BROTHER 1</CODE>
<br>
to
<br>
<CODE>BIG_BROTHER 0</CODE>
<br>
])

SECTION(Internals)
PARAGRAPH([
If you are interested in network programming yourself, you may want to
read the <a href=net/index.html>network subsystem documentation</a>.
])

include(sig.m4)
include(navbar.html.m4)
</body>
</html>

