include(head.html.m4)
DEFINE(SECT,readme_linux)
include(navbar.html.m4)

TITLE(Win9x usage)

SUBSECTION(Installation)

PARAGRAPH([
If you have the installer version, just run the executable, select a directory
to install armagetron into and enjoy.
])

PARAGRAPH([
If you have an update version, just run the executable. It should find and update the previous version automatically.
])

PARAGRAPH([
If you have the .zip-version, unpack it to the place you want PROGTITLE to be
(using WinZip, for example) and create the desktop/startmenu shortcuts 
manually by right-dragging PROGNAME.exe from the installation directory.
])

SUBSECTION(OpenGL Driver)

PARAGRAPH([
If you have two cards (a normal 3D card AND a VooDoo addon card)
choose one of the two methods below: Way 1 will use your normal card,
way two your VooDoo card.])

SUBSUBSECTION(All "normal" 3D-Cards:)
PARAGRAPH([
  Open the ArmageTron directory in an explorer window 
  and double click on the file "PROGNAME.exe".
  The program will use your normal OPENGL32.DLL from your windows
  system folder. (Make sure it supports hardware acceleration!)
  You may drag the icon "PROGNAME.exe" to your desktop or start menu to
  create a shortcut. 
  If you have problems with OpenGL, install GLSetup from 
  <a href="http://www.glsetup.com/">www.glsetup.com</a>.
])
PARAGRAPH([
  On some cards, there are a number of display problems when PROGTITLE
  runs in fullscreen mode. If you experience slow graphics, weird textures
  or similar, try the windowed mode. See the <a href=faq.html>FAQ</a> to
  see how you can activate windowed mode even if PROGTITLE crashes
  before you can get to the menu.
])

SUBSUBSECTION(VooDoo addon cards (i.e. VooDoo 1,VooDoo 2):)
PARAGRAPH([
  A small problem here: the standard OPENGL32.DLL has no hardware
  accelleration. Instead, 3DFX supplies you with a file called 
  3dfxVGL.DLL [or 3dfxOGL.DLL] (found in your windows\system folder).
  Simply copy   (drag it with the right mousebutton and select "copy" from the
   pop-up-menu) it into the folder "PROGNAME.exe" is in and rename it 
  there to "OPENGL32.DLL". Then, "PROGNAME.exe" will use this file 
  instead of Microsoft's standard OPENGL32.DLL. If you cannot find 
  3dfxVGL.DLL or 3dfxOGL.DLL, you should first check whether you can
  find ANY .DLL files in the folder; if not, you'll have to enable
  the item "show all files" (or similar) in the folder options. If
  it's still not there, 
  install  GLSetup from <a href="http://www.glsetup.com/">www.glsetup.com</a>.
  <br>
  If you have problems with that procedure or get crashes in glide3x.*, 
<a href="http://WEBBASE/download/opengl32.zip">download this working version</a> for VooDoo 2 (maybe 1) 
  and unpack it into your PROGTITLE directory. According to the driver, you
  need at least Glide 2.56 installed; it really should work if you use
  the driver version 3.02.02 (or higher?).
])

You need to be in 16 bit color depth mode to run PROGTITLE on some cards
(Riva 128, some VooDoos).

SUBSECTION(Uninstall)

PARAGRAPH([
If you installed PROGTITLE via the installer or updater, you can remove it by
executing the uninstaller from the start menu. Your personal configuration
files and a registry entry telling future installations where to find them will
remain on your system.
])

PARAGRAPH([
If you installed from a
.zip-file, delete the directory you unpacked PROGTITLE into manually.
])


SUBSECTION(Special Win9x-related issues)

PARAGRAPH([
First of all, I write this game under Linux and for Linux, but with
portability in mind (that's why I use SDL). Right now, there may only
one OS specific problem: the Windows version assumes your keyboard has
US layout, a phenomenon you are surely used to ;-)  
])

PARAGRAPH([
<strong>BUT</strong>: there are OpenGL-implementation specific problems. 
I write all the OpenGL code with the official OpenGL specification
from SGI on my desk and in my mind. Most of the testing is done with
the OpenGL-"surrogate" Mesa, and so far, everything that should work
in theory has worked using Mesa. Testing the Win9x version of ArmageTron on
my (Voodo2) and my brother's (Riva TNT) system however showed that the
the OpenGL-implementations for them were far less strict: the VooDoo2
refuses to do trilinear filtering, and both versions have problems
with infinite points and z-buffer accuracy. If you experience other
or similar problems, mail me about them; I will try to build workarounds
(of course, you are free to mess with the sourcecode and fix the
problem for yourself; this is free software). However, my main goal is
to keep the code coherent and I will not flood it with 
"if (GraphicSystem==VooDoo5) ...."-directives.
])

include(sig.m4)
include(navbar.html.m4)
</body>
</html>

