/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "tDirectories.h"
#include "nNetwork.h"
#include "nServerInfo.h"
#include "tSysTime.h"
#include "tLocale.h"

REAL save_interval = 300.0f;
REAL query_interval = 10.0f;

int main(int argc, char** argv)
{
    tCommandLineData commandLine;
    commandLine.programVersion_ = &sn_programVersion;
    commandLine.Analyse(argc, argv);
    tLocale::Load("languages.txt");

    nServerInfo::Load( tDirectories::Var(), "master_list.srv" );

    nServerInfo::StartQueryAll();

    //  st_LoadConfig();

    sn_serverPort = 4533;
    sn_SetNetState(nSERVER);

    nTimeAbsolute savetimeout  = tSysTimeFloat();
    nTimeAbsolute querytimeout = tSysTimeFloat();
    nTimeAbsolute quitTimeout  = tSysTimeFloat() + 7200;

    bool goon = true;
    while ( goon )
    {
        nServerInfo::RunMaster();

        usleep(10000);
        nTimeAbsolute time = tSysTimeFloat();

        sn_Receive();

        static bool queryGoesOn = true;
        if (queryGoesOn && time > querytimeout)
        {
            queryGoesOn = nServerInfo::DoQueryAll(1);
            querytimeout = time + query_interval;
        }

        if (time > savetimeout)
        {
            nServerInfo::Save( tDirectories::Var(), "master_list.srv" );
            if (!queryGoesOn)
            {
                nServerInfo::StartQueryAll();
                queryGoesOn = true;
            }
            savetimeout = time + save_interval;

            goon = time < quitTimeout;
        }
    }

    return(0);
}

