/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_FONT_H
#define ArmageTron_FONT_H

#include "defs.h"
#include "rTexture.h"
#include "tString.h"

class rFont:public rTexture{
    int offset;
    REAL cwidth;
    REAL cheight;
    REAL onepixel;
    rFont *lowerPart;
public:
    rFont(const char *fileName,int Offset=0,REAL CWidth=(1/16.0),
          REAL CHeight=(1/8.0),REAL onepixel=1/256.0, rFont *lower=NULL);
    rFont(const char *fileName, rFont *lower);
    virtual ~rFont();

#ifndef DEDICATED
    // displays c
    void Render(unsigned char c,REAL left,REAL top,REAL right,REAL bot);
#endif
    static rFont s_defaultFont,s_defaultFontSmall;
};


// **********************************************+

// maybe make this a child of std::ostream...
class rTextField{
    tString buffer;       // buffer where we store stuff before we print it
    int  width;          // width in characters
    int  parIndent;      // number of spaces to insert after automatic newline
    REAL left,top;       // top left corner of the console
    REAL cwidth,cheight; // character dimensions
    rFont *F;             // the font
    int  x,y,realx;      // current cursor position

    REAL r,g,b;          // current color
    bool useColor;       // use this color

    int cursor; // display mode of the cursor; 0: disabled, 1: low, 2: high
    int cursorPos; // position of the cursor (number of chars to come)

    REAL cursor_x,cursor_y; // position on the screen

    void FlushLine(int len,bool newline=true);
    void FlushLine(bool newline=true);
public:
 #define  rCWIDTH_NORMAL  (16/640.0)
 #define  rCHEIGHT_NORMAL (32/480.0)

    rTextField(REAL Left,REAL Top,
               REAL Cwidth=rCWIDTH_NORMAL,REAL Cheight=rCHEIGHT_NORMAL,
               rFont *f=&rFont::s_defaultFont);

    virtual ~rTextField(); // for future extensions (buffered console?)

    REAL GetCWidth(){ return cwidth; }
    REAL GetCHeight(){ return cheight; }

    void SetWidth(int w){
        width=w;
    }

    void SetIndent(int i){
        parIndent=i;
    }

    void SetCursor(int c,int p){
        cursor=c;
        cursorPos=p;
    }

    void ResetColor(){
        useColor=false;
        FlushLine(false);
    }

    rTextField & operator<<(unsigned char c);
    rTextField & StringOutput(const char *c);

    int Lines(){return y;}
};

tString RemoveColors(const char *c);

char *ColorString(REAL r,REAL g,REAL b);

template<class T> rTextField & operator<<(rTextField &c,const T &x){
    tString out;
    out << x;
    return c.StringOutput(out);
}



void DisplayText(REAL x,REAL y,REAL w,REAL h,const char *text,int center=0,
                 int cursor=0,int cursorPos=0);

#endif

