/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_CONFIGURATION_H
#define ArmageTron_CONFIGURATION_H

#include "tList.h"
#include "tString.h"
#include "tLinkedList.h"
#include "tLocale.h"
#include "tConsole.h"
#include "tLocale.h"
#include <iostream>
#include <ctype.h>


class tConfItemBase:public tListItem<tConfItemBase>{
    friend class tCheckedPTRBase;

    int id;
protected:
    const tString title;
    const tOutput help;
    bool changed;

    static tConfItemBase* s_ConfItemAnchor;
    //static tConfItemBase* Anchor(){return dynamic_cast<tConfItemBase *>(s_ConfItemAnchor);}
public:
    static bool printChange;

    tConfItemBase(const char *title, const tOutput& help);
    tConfItemBase(const char *title);
    virtual ~tConfItemBase();

    static int EatWhitespace(std::istream &s); // eat whitespace from stream; return: first non-whitespace char

    static void SaveAll(std::ostream &s);
    static void LoadAll(std::istream &s);
    static void DocAll(std::ostream &s);

    virtual void ReadVal(std::istream &s)=0;
    virtual void WriteVal(std::ostream &s)=0;

    virtual void WasChanged(){} // what to do if a read changed the thing

    virtual bool Writable(){return true;}

    virtual bool Save(){return true;}
};

// Arg! Msvc++ could not handle bool IO. Seems to be fine now.
#ifdef _MSC_VER_XXX
inline std::istream & operator >> (std::istream &s,bool &b){
    int x;
    s >> x;
    b=(x!=0);
    return s;
}

inline std::ostream & operator << (std::ostream &s,bool b){
    if (b)
        return s << 1;
    else
        return s << 0;
}
#endif

template<class T> class tConfItem:virtual public tConfItemBase{
protected:
    T    *target;

    tConfItem(T &t):tConfItemBase(""),target(&t){};
public:
    tConfItem(const char *title,const tOutput& help,T& t)
            :tConfItemBase(title,help),target(&t){}

    tConfItem(const char *title,T& t)
            :tConfItemBase(title),target(&t){}

    virtual ~tConfItem(){}

    virtual void ReadVal(std::istream &s){
        // eat whitepsace
        int c= EatWhitespace(s);


        T dummy=0;
        if (c!='\n' && s && !s.eof() && s.good()){
            s >> dummy;
            if (!s)
            {
                tOutput o;
                o.SetTemplateParameter(1, title);
                o << "$config_error_read";
                con << o;
            }
            else
                if (dummy!=*target){
                    if (!Writable())
                    {
                        tOutput o;
                        o.SetTemplateParameter(1, title);
                        o << "nconfig_errror_protected";
                        con << "";
                    }
                    else{
                        if (printChange)
                        {
                            tOutput o;
                            o.SetTemplateParameter(1, title);
                            o.SetTemplateParameter(2, *target);
                            o.SetTemplateParameter(3, dummy);
                            o << "$config_value_changed";
                            con << o;
                        }

                        *target=dummy;
                        changed=true;
                    }
                }
        }
        else
        {
            tOutput o;
            o.SetTemplateParameter(1, title);
            o.SetTemplateParameter(2, *target);
            o << "$config_message_info";
            con << o;
        }

        // read the rest of the line
        c=' ';
        while(c!='\n' && s.good() && !s.eof()) c=s.get();
    }

    virtual void WriteVal(std::ostream &s){
        s << *target;
    }
};

template<class T> class tSettingItem:public tConfItem<T>{
public:
    //  tSettingItem(const char *title,const tOutput& help,T& t)
    //    :tConfItemBase(title,help),tConfItem<T>(t){}

    tSettingItem(const char *title,T& t)
            :tConfItemBase(title),tConfItem<T>(title, t){}

    virtual ~tSettingItem(){}

    virtual bool Save(){return false;}
};


class tConfItemLine:public tConfItem<tString>, virtual public tConfItemBase{
public:
    tConfItemLine(const char *title,const char *help,tString &s)
            :tConfItemBase(title,help),tConfItem<tString>(title,help,s){};

    virtual ~tConfItemLine(){}

    tConfItemLine(const char *title, tString &s)
            :tConfItemBase(title),tConfItem<tString>(title,s){};

    virtual void ReadVal(std::istream &s);
    virtual void WriteVal(std::ostream &s);
};

typedef void CONF_FUNC(std::istream &s);

class tConfItemFunc:public tConfItemBase{
    CONF_FUNC *f;
public:
    tConfItemFunc(const char *title, CONF_FUNC *func);
    virtual ~tConfItemFunc();

    virtual void ReadVal(std::istream &s);
    virtual void WriteVal(std::ostream &s);

    virtual bool Save();
};

void st_LoadConfig();
void st_SaveConfig();

extern bool st_FirstUse;

#endif

