/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "config.h"

#include "tSysTime.h"

// Both implementations are stolen from Q1.

#ifdef WIN32
#include <windows.h>
#include <sys/timeb.h> 
#ifndef DEDICATED
#include "rSDL.h"
#endif

static double	blocktime;
double tSysTimeFloat (bool force)
{
    double t;
    struct _timeb tstruct;
    static int      startTime;
    static double last_t = 0;

    _ftime( &tstruct );

    if (!startTime)
        startTime = tstruct.time;
    t = (tstruct.time-startTime) + tstruct.millitm*0.001;

    if (!force)
    {
        if (t<last_t)
            t = last_t;

        if (t > last_t + 5)
            t = last_t + 5;
    }

    last_t = t;
    return t;
}

static unsigned int sleep_rest;
void usleep(int x)
{
    sleep_rest+=x;
    unsigned int r=sleep_rest/1000;
#ifndef DEDICATED
    SDL_Delay(r);
#else

#ifdef DEBUG
    double tb = tSysTimeFloat();
#endif

    SleepEx(r,false);

#ifdef DEBUG
    double ta = tSysTimeFloat();
    if ((tb-ta) > r*.01)
    {
        int x;
        x = 1;
    }
#endif

#endif
    sleep_rest-=r*1000;
}

#else

#include <sys/time.h>

double tSysTimeFloat (bool force)
{
    struct timeval tp;
    struct timezone tzp;
    static int      secbase;

    gettimeofday(&tp, &tzp);

    if (!secbase)
    {
        secbase = tp.tv_sec;
        return tp.tv_usec/1000000.0;
    }
    // make the timer granual with 20 ticks per second
    // (simulate windows behaviour)
    //tp.tv_usec=(tp.tv_usec/50000)*50000;

    double t = (tp.tv_sec - secbase) + tp.tv_usec/1000000.0;;
    static double last_t = 0;

    if (!force)
    {
        if (t<last_t)
            t = last_t;

        if (t > last_t + 5)
            t = last_t + 5;
    }

    last_t = t;

    return t;
}


#endif

