/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "tMemManager.h"

#include "nConfig.h"

#include "eGrid.h"
#include "gArena.h"
#include "gSpawn.h"
#include "gWall.h"

static float sizeMultiplier = .5f;
static nSettingItem<float> conf_mult ("REAL_ARENA_SIZE_FACTOR", sizeMultiplier);

gArena::gArena():spawnPoints()
{
    NewSpawnPoint(eCoord(255,50),eCoord(0,1));
    NewSpawnPoint(eCoord(245,450),eCoord(0,-1));
    NewSpawnPoint(eCoord(50,245),eCoord(1,0));
    NewSpawnPoint(eCoord(450,255),eCoord(-1,0));

    NewSpawnPoint(eCoord(305,100),eCoord(0,1));
    NewSpawnPoint(eCoord(195,400),eCoord(0,-1));
    NewSpawnPoint(eCoord(100,195),eCoord(1,0));
    NewSpawnPoint(eCoord(400,305),eCoord(-1,0));

    NewSpawnPoint(eCoord(205,100),eCoord(0,1));
    NewSpawnPoint(eCoord(295,400),eCoord(0,-1));
    NewSpawnPoint(eCoord(100,295),eCoord(1,0));
    NewSpawnPoint(eCoord(400,205),eCoord(-1,0));

    /*
    NewSpawnPoint(eCoord(305,100),eCoord(0,1));
    NewSpawnPoint(eCoord(195,400),eCoord(0,-1));
    NewSpawnPoint(eCoord(100,295),eCoord(1,0));
    NewSpawnPoint(eCoord(400,305),eCoord(-1,0));

    NewSpawnPoint(eCoord(205,100),eCoord(0,1));
    NewSpawnPoint(eCoord(295,400),eCoord(0,-1));
    NewSpawnPoint(eCoord(100,195),eCoord(1,0));
    NewSpawnPoint(eCoord(400,295),eCoord(-1,0));
    */
}

void gArena::NewSpawnPoint(const eCoord &loc,const eCoord &dir){
    gSpawnPoint *s=tNEW(gSpawnPoint) (loc,dir);
    spawnPoints.Add(s,s->id);
}


gArena::~gArena(){
    while (spawnPoints.Len()){
        gSpawnPoint *s=spawnPoints(0);
        spawnPoints.Remove(s,s->id);
        delete s;
    }
}

bool init_grid_in_process;

// from gGame.cpp
void exit_game_objects(eGrid *grid);

eCoord gArena::GetRandomPos(REAL factor) const
{
    REAL x = REAL(rand())/RAND_MAX;
    REAL y = REAL(rand())/RAND_MAX;

    return eCoord( sizeMultiplier * 500.0 * ( x * factor + .5f * ( 1 - factor ) ), sizeMultiplier * 500.0 * ( y * factor + .5f * ( 1 - factor ) ) );
}

void gArena::PrepareGrid(eGrid *grid)
{
    exit_game_objects(grid);

    grid->Create();



    init_grid_in_process=true;

    ePoint *R=grid->Insert(eCoord(0,0));
    R=grid->DrawLine(R, eCoord(500,0)  * sizeMultiplier,  tNEW(gWallRim) (grid),0);
    R=grid->DrawLine(R, eCoord(500,500) * sizeMultiplier,tNEW(gWallRim) (grid),0);
    R=grid->DrawLine(R, eCoord(0,500)   * sizeMultiplier,  tNEW(gWallRim) (grid),0);
    R=grid->DrawLine(R, eCoord(0,0)     * sizeMultiplier,    tNEW(gWallRim) (grid),0);

    //  R=R->DrawLineTo(eCoord(600,0),tNEW() gWallRim(),0);

    init_grid_in_process=false;

    /*
    REAL x,y;
    for(x=20;x<600;x+=140){
      ePoint *R=ePoint::InsertIntoGrid(eCoord(x,.1));
      R=R->DrawLineTo(eCoord(x,11),tNEW() gWallRim(false,.1),0);
    }

    for(x=20;x<600;x+=140){
      ePoint *R=ePoint::InsertIntoGrid(eCoord(x,459.9));
      R=R->DrawLineTo(eCoord(x,449),tNEW() gWallRim(false,.1),0);
    }

    for(y=20;y<460;y+=140){
      ePoint *R=ePoint::InsertIntoGrid(eCoord(.1,y));
      R=R->DrawLineTo(eCoord(11,y),tNEW() gWallRim(false,.1),0);
    }

    for(y=20;y<460;y+=140){
      ePoint *R=ePoint::InsertIntoGrid(eCoord(599.9,y));
      R=R->DrawLineTo(eCoord(589,y),tNEW() gWallRim(false,.1),0);
    }
    */

    for(int i=0;i<spawnPoints.Len();i++)
        spawnPoints(i)->Clear();
}

// find the best gSpawnPoint
gSpawnPoint * gArena::LeastDangerousSpawnPoint()
{
    REAL mindanger=100;
    gSpawnPoint *ret=NULL;

    for(int i=0;i<spawnPoints.Len();i++)
        if (spawnPoints(i)->Danger()<mindanger){
            ret=spawnPoints(i);
            mindanger=ret->Danger();
        }

    if (!ret)
        tERR_ERROR("No spawnpoint available!");

    return ret;
}

float gArena::SizeMultiplier()
{
    return sizeMultiplier;
}

void gArena::SetSizeMultiplier(float mult)
{
    conf_mult.Set( mult );
}
