/*
 * Decompiled with CFR 0.152.
 */
package jacorb.imr;

import jacorb.imr.HostInfo;
import jacorb.imr.HostInfoHelper;
import jacorb.imr.HostNameHelper;
import jacorb.imr.ImRInfo;
import jacorb.imr.ImRInfoHelper;
import jacorb.imr.LogicalServerNameHelper;
import jacorb.imr.POANameHelper;
import jacorb.imr.Registration;
import jacorb.imr.RegistrationHelper;
import jacorb.imr.RegistrationOperations;
import jacorb.imr.RegistrationPackage.DuplicatePOAName;
import jacorb.imr.RegistrationPackage.DuplicatePOANameHelper;
import jacorb.imr.RegistrationPackage.IllegalHostName;
import jacorb.imr.RegistrationPackage.IllegalHostNameHelper;
import jacorb.imr.RegistrationPackage.IllegalPOAName;
import jacorb.imr.RegistrationPackage.IllegalPOANameHelper;
import jacorb.imr.RegistrationPackage.InvalidSSDRef;
import jacorb.imr.RegistrationPackage.InvalidSSDRefHelper;
import jacorb.imr.UnknownServerName;
import jacorb.imr.UnknownServerNameHelper;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class RegistrationPOA
extends Servant
implements InvokeHandler,
RegistrationOperations {
    private static final Hashtable m_opsHash = new Hashtable();
    private String[] ids = new String[]{"IDL:jacorb/imr/Registration:1.0"};

    static {
        m_opsHash.put("register_host", new Integer(0));
        m_opsHash.put("set_server_down", new Integer(1));
        m_opsHash.put("register_poa", new Integer(2));
        m_opsHash.put("get_imr_info", new Integer(3));
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return this.ids;
    }

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        Integer n = (Integer)m_opsHash.get(string);
        if (n == null) {
            throw new BAD_OPERATION(String.valueOf(string) + " not found");
        }
        switch (n) {
            case 0: {
                try {
                    HostInfo hostInfo = HostInfoHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.register_host(hostInfo);
                }
                catch (IllegalHostName illegalHostName) {
                    outputStream = responseHandler.createExceptionReply();
                    IllegalHostNameHelper.write(outputStream, illegalHostName);
                }
                catch (InvalidSSDRef invalidSSDRef) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidSSDRefHelper.write(outputStream, invalidSSDRef);
                }
                break;
            }
            case 1: {
                try {
                    String string2 = LogicalServerNameHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.set_server_down(string2);
                }
                catch (UnknownServerName unknownServerName) {
                    outputStream = responseHandler.createExceptionReply();
                    UnknownServerNameHelper.write(outputStream, unknownServerName);
                }
                break;
            }
            case 2: {
                try {
                    String string3 = POANameHelper.read(inputStream);
                    String string4 = LogicalServerNameHelper.read(inputStream);
                    String string5 = HostNameHelper.read(inputStream);
                    int n2 = inputStream.read_long();
                    outputStream = responseHandler.createReply();
                    this.register_poa(string3, string4, string5, n2);
                }
                catch (IllegalPOAName illegalPOAName) {
                    outputStream = responseHandler.createExceptionReply();
                    IllegalPOANameHelper.write(outputStream, illegalPOAName);
                }
                catch (DuplicatePOAName duplicatePOAName) {
                    outputStream = responseHandler.createExceptionReply();
                    DuplicatePOANameHelper.write(outputStream, duplicatePOAName);
                }
                catch (UnknownServerName unknownServerName) {
                    outputStream = responseHandler.createExceptionReply();
                    UnknownServerNameHelper.write(outputStream, unknownServerName);
                }
                break;
            }
            case 3: {
                outputStream = responseHandler.createReply();
                ImRInfoHelper.write(outputStream, this.get_imr_info());
                break;
            }
        }
        return outputStream;
    }

    public Registration _this() {
        return RegistrationHelper.narrow(this._this_object());
    }

    public Registration _this(ORB oRB) {
        return RegistrationHelper.narrow(this._this_object(oRB));
    }

    public abstract ImRInfo get_imr_info();

    public abstract void register_host(HostInfo var1) throws IllegalHostName, InvalidSSDRef;

    public abstract void register_poa(String var1, String var2, String var3, int var4) throws IllegalPOAName, DuplicatePOAName, UnknownServerName;

    public abstract void set_server_down(String var1) throws UnknownServerName;
}

