/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.domain;

import jacorb.orb.domain.ConflictResolutionPolicyOperations;
import jacorb.orb.domain.ConflictResolutionPolicyPOATie;
import jacorb.orb.domain.Domain;
import jacorb.orb.domain.DomainImpl;
import jacorb.orb.domain.DomainOperations;
import jacorb.orb.domain.ManagementPolicyImpl;
import jacorb.util.Debug;
import java.util.Hashtable;
import org.omg.CORBA.Policy;

public class ChildRulesPolicy
extends ManagementPolicyImpl
implements ConflictResolutionPolicyOperations {
    public ChildRulesPolicy() {
        super("conflict resolve");
        String string = "This object implements the domain conflict resolving policy. The conflict resolving policy decides which domain/policy in the case of overlapping domains to use. This policy gives precedence to the domain which is the lowest domain (the highest distance to the common root domain) in the list of conflicting domains. Simplified to the case of two conflicting domains which are in a parent-child relationship this means the child domain takes precedence. If there is no such unique domain (which is possible, but should not be the case, because then all the conflictiong domains do not have anything in common and should therefore not conflict) then the first domain of the listis taken.";
        this.long_description(string);
    }

    public Policy copy() {
        return new ConflictResolutionPolicyPOATie(new ChildRulesPolicy())._this();
    }

    public int policy_type() {
        return 114;
    }

    public Policy resolveConflict(Domain[] domainArray, int n) {
        Debug.assert(1, domainArray.length > 0, "SimpleConflictResolutionPolicy: list of overlapping domain managers is empty");
        if (domainArray.length == 2) {
            if (domainArray[0].containsDomain(domainArray[1])) {
                return domainArray[1].get_domain_policy(n);
            }
            if (domainArray[1].containsDomain(domainArray[0])) {
                return domainArray[0].get_domain_policy(n);
            }
            return domainArray[0].get_domain_policy(n);
        }
        Domain domain = DomainImpl.getRootDomain(domainArray[0], new Hashtable());
        Hashtable hashtable = DomainImpl.calculateDistances(domain);
        int n2 = Integer.MIN_VALUE;
        DomainOperations domainOperations = null;
        int n3 = 0;
        int n4 = 0;
        while (n4 < domainArray.length) {
            n3 = (Integer)hashtable.get(domainArray[n4]);
            Debug.output(4, "ChildRules.resolveConflict: distance of " + domainArray[n4].name() + " to root " + domain.name() + " is " + n3);
            if (n3 > n2) {
                n2 = n3;
                domainOperations = domainArray[n4];
            }
            ++n4;
        }
        Debug.output(3, "ChildRules.resolveConflict: chosen " + domainOperations.name() + " with distance " + n2 + " to domain " + domain.name());
        return domainOperations.get_domain_policy(n);
    }

    public int[] responsibleFor() {
        int[] nArray = new int[1];
        return nArray;
    }

    public void setPolicyType(int n) {
    }

    public short strategy() {
        return 3;
    }
}

