/*
 * Decompiled with CFR 0.152.
 */
package jacorb.poa;

import jacorb.poa.AOMListener;
import jacorb.poa.EventMulticaster;
import jacorb.poa.POA;
import jacorb.poa.RequestController;
import jacorb.poa.except.POAInternalError;
import jacorb.poa.util.LogTrace;
import jacorb.poa.util.POAUtil;
import jacorb.poa.util.StringPair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;

public class AOM {
    private AOMListener aomListener;
    private boolean unique;
    private boolean singleThreaded;
    private LogTrace logTrace;
    private Hashtable objectMap = new Hashtable();
    private Hashtable servantMap;
    private Vector etherealisationList = new Vector();
    private Vector incarnationList = new Vector();

    private AOM() {
    }

    protected AOM(boolean bl, boolean bl2, LogTrace logTrace) {
        this.unique = bl;
        this.singleThreaded = bl2;
        this.logTrace = logTrace;
        if (this.unique) {
            this.servantMap = new Hashtable();
        }
    }

    protected synchronized void add(byte[] byArray, Servant servant) throws ObjectAlreadyActive, ServantAlreadyActive {
        String string = POAUtil.objectId_to_string(byArray);
        while (this.incarnationList.contains(string) || this.etherealisationList.contains(string)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.objectMap.containsKey(string)) {
            throw new ObjectAlreadyActive();
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            throw new ServantAlreadyActive();
        }
        this.objectMap.put(string, servant);
        if (this.unique) {
            this.servantMap.put(servant, string);
        }
        this.logTrace.printLog(1026, byArray, "object is activated");
        if (this.aomListener != null) {
            this.aomListener.objectActivated(byArray, servant, this.objectMap.size());
        }
    }

    protected synchronized void addAOMListener(AOMListener aOMListener) {
        this.aomListener = EventMulticaster.add(this.aomListener, aOMListener);
    }

    protected boolean contains(Servant servant) {
        if (this.unique) {
            return this.servantMap.containsKey(servant);
        }
        return this.objectMap.contains(servant);
    }

    protected boolean contains(byte[] byArray) {
        return this.objectMap.containsKey(POAUtil.objectId_to_string(byArray));
    }

    protected synchronized StringPair[] deliverContent() {
        StringPair[] stringPairArray = new StringPair[this.objectMap.size()];
        Enumeration enumeration = this.objectMap.keys();
        int n = 0;
        while (n < stringPairArray.length) {
            String string = (String)enumeration.nextElement();
            stringPairArray[n] = new StringPair(string, this.objectMap.get(string).getClass().getName());
            ++n;
        }
        return stringPairArray;
    }

    protected byte[] getObjectId(Servant servant) {
        if (!this.unique) {
            throw new POAInternalError("error: not UNIQUE_ID policy (getObjectId)");
        }
        String string = (String)this.servantMap.get(servant);
        if (string != null) {
            return POAUtil.string_to_objectId(string);
        }
        return null;
    }

    protected Servant getServant(byte[] byArray) {
        return (Servant)this.objectMap.get(POAUtil.objectId_to_string(byArray));
    }

    protected synchronized Servant incarnate(byte[] byArray, ServantActivator servantActivator, org.omg.PortableServer.POA pOA) throws ForwardRequest {
        String string = POAUtil.objectId_to_string(byArray);
        Servant servant = null;
        while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.objectMap.containsKey(string)) {
            return (Servant)this.objectMap.get(string);
        }
        this.incarnationList.addElement(string);
        try {
            servant = servantActivator.incarnate(byArray, pOA);
        }
        finally {
            Object var7_6 = null;
            this.incarnationList.removeElement(string);
            this.notifyAll();
        }
        if (servant == null) {
            this.logTrace.printLog(0, byArray, "servant is not incarnated (incarnate returns null)");
            return null;
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            this.logTrace.printLog(0, byArray, "servant is not incarnated (unique_id policy is violated)");
            return null;
        }
        this.logTrace.printLog(2, byArray, "servant is incarnated");
        if (this.aomListener != null) {
            this.aomListener.servantIncarnated(byArray, servant);
        }
        try {
            this.add(byArray, servant);
        }
        catch (ObjectAlreadyActive objectAlreadyActive) {
            throw new POAInternalError("error: object already active (AOM.incarnate)");
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            throw new POAInternalError("error: servant already active (AOM.incarnate)");
        }
        return servant;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void remove(byte[] byArray, RequestController requestController, ServantActivator servantActivator, POA pOA, boolean bl) {
        String string = POAUtil.objectId_to_string(byArray);
        Servant servant = null;
        AOM aOM = this;
        synchronized (aOM) {
            if (this.objectMap.get(string) == null) {
                return;
            }
            if (requestController != null) {
                requestController.waitForObjectCompletion(byArray);
            }
            if ((servant = (Servant)this.objectMap.get(string)) == null) {
                return;
            }
            this.objectMap.remove(string);
            if (this.unique) {
                this.servantMap.remove(servant);
            }
            this.logTrace.printLog(2, byArray, "object is deactivated");
            if (this.aomListener != null) {
                this.aomListener.objectDeactivated(byArray, servant, this.objectMap.size());
            }
            if (servantActivator == null) {
                return;
            }
            while (true) {
                if (this.incarnationList.isEmpty() && this.etherealisationList.isEmpty()) {
                    this.etherealisationList.addElement(string);
                    try {
                        try {
                            servantActivator.etherealize(byArray, pOA, servant, this.contains(servant), bl);
                            this.logTrace.printLog(2, byArray, "servant is etherealized");
                            if (this.aomListener != null) {
                                this.aomListener.servantEtherialized(byArray, servant);
                            }
                        }
                        catch (SystemException systemException) {
                            this.logTrace.printLog(1, byArray, "exception occurred during servant etherialisation: " + systemException);
                        }
                        Object var11_13 = null;
                        this.etherealisationList.removeElement(string);
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        this.etherealisationList.removeElement(string);
                        this.notifyAll();
                        throw throwable;
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.notifyAll();
            if (requestController == null) return;
            requestController.freeObject(byArray);
            return;
        }
    }

    protected synchronized void removeAOMListener(AOMListener aOMListener) {
        this.aomListener = EventMulticaster.remove(this.aomListener, aOMListener);
    }

    protected void removeAll(ServantActivator servantActivator, POA pOA, boolean bl) {
        Enumeration enumeration = this.objectMap.keys();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = POAUtil.string_to_objectId((String)enumeration.nextElement());
            this.remove(byArray, null, servantActivator, pOA, bl);
        }
    }

    protected int size() {
        return this.objectMap.size();
    }
}

