/*
 * Decompiled with CFR 0.152.
 */
package jacorb.poa;

import jacorb.orb.Connection;
import jacorb.orb.Forwarder;
import jacorb.orb.ServantDelegate;
import jacorb.orb.SystemExceptionHelper;
import jacorb.orb.dsi.ServerRequest;
import jacorb.orb.portableInterceptor.InterceptorManager;
import jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import jacorb.poa.InvocationContext;
import jacorb.poa.POA;
import jacorb.poa.RPPoolManager;
import jacorb.poa.RequestController;
import jacorb.poa.except.POAInternalError;
import java.util.Hashtable;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManager;

public class RequestProcessor
extends Thread
implements InvocationContext {
    private boolean start;
    private boolean terminate;
    private Thread[] remainingThreads;
    private RPPoolManager poolManager;
    private RequestController controller;
    private ServerRequest request;
    private Servant servant;
    private ServantManager servantManager;
    private CookieHolder cookieHolder;
    private static Hashtable specialOperations = new Hashtable(50);

    static {
        specialOperations.put("_is_a", "");
        specialOperations.put("_get_interface", "");
        specialOperations.put("_non_existent", "");
        specialOperations.put("_get_policy", "");
        specialOperations.put("_get_domain_managers", "");
        specialOperations.put("_set_policy_overrides", "");
    }

    RequestProcessor(RPPoolManager rPPoolManager) {
        this.poolManager = rPPoolManager;
    }

    synchronized void begin() {
        this.start = true;
        this.notify();
    }

    synchronized void end() {
        this.terminate = true;
        this.notify();
    }

    Connection getConnection() {
        return this.request.getConnection();
    }

    public ORB getORB() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getORB)");
        }
        return this.controller.getORB();
    }

    public byte[] getObjectId() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getObjectId)");
        }
        return this.request.objectId();
    }

    public POA getPOA() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getPOA)");
        }
        return this.controller.getPOA();
    }

    public Servant getServant() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getServant)");
        }
        return this.servant;
    }

    void init(RequestController requestController, ServerRequest serverRequest, Servant servant, ServantManager servantManager) {
        this.controller = requestController;
        this.request = serverRequest;
        this.servant = servant;
        this.servantManager = servantManager;
        this.cookieHolder = null;
    }

    private void invokeIncarnate() {
        this.controller.getLogTrace().printLog(3, this.request, "invoke incarnate on servant activator");
        try {
            this.servant = this.controller.getAOM().incarnate(this.request.objectId(), (ServantActivator)this.servantManager, this.controller.getPOA());
            if (this.servant == null) {
                this.controller.getLogTrace().printLog(0, this.request, "incarnate: returns null");
                this.request.setSystemException(new OBJ_ADAPTER());
            }
            this.controller.getORB().set_delegate(this.servant);
        }
        catch (SystemException systemException) {
            this.controller.getLogTrace().printLog(0, this.request, "incarnate: system exception was thrown (" + systemException + ")");
            this.request.setSystemException(systemException);
        }
        catch (org.omg.PortableServer.ForwardRequest forwardRequest) {
            this.controller.getLogTrace().printLog(0, this.request, "incarnate: forward exception was thrown (" + forwardRequest + ")");
            this.request.setLocationForward(forwardRequest);
        }
        catch (Throwable throwable) {
            this.controller.getLogTrace().printLog(0, this.request, "incarnate: throwable was thrown");
            this.controller.getLogTrace().printLog(0, throwable);
            this.request.setSystemException(new OBJ_ADAPTER(throwable.getMessage()));
        }
    }

    private boolean invokeInterceptors(ServerRequestInfoImpl serverRequestInfoImpl, short s) {
        ServerInterceptorIterator serverInterceptorIterator = this.controller.getORB().getInterceptorManager().getServerIterator();
        try {
            serverInterceptorIterator.iterate(serverRequestInfoImpl, s);
        }
        catch (UserException userException) {
            if (userException instanceof ForwardRequest) {
                ForwardRequest forwardRequest = (ForwardRequest)userException;
                this.request.setLocationForward(new org.omg.PortableServer.ForwardRequest(forwardRequest.forward));
            }
            return false;
        }
        catch (SystemException systemException) {
            this.request.setSystemException(systemException);
            return false;
        }
        return true;
    }

    private void invokeOperation() {
        try {
            if (this.servant instanceof InvokeHandler) {
                this.controller.getLogTrace().printLog(3, this.request, "invoke operation on servant (stream based)");
                if (specialOperations.containsKey(this.request.operation())) {
                    ((ServantDelegate)this.servant._get_delegate())._invoke(this.servant, this.request.operation(), this.request.getInputStream(), this.request);
                } else {
                    ((InvokeHandler)((Object)this.servant))._invoke(this.request.operation(), this.request.getInputStream(), this.request);
                }
            } else if (this.servant instanceof DynamicImplementation) {
                this.controller.getLogTrace().printLog(3, this.request, "invoke operation on servant (dsi based)");
                if (specialOperations.containsKey(this.request.operation()) && !(this.servant instanceof Forwarder)) {
                    ((ServantDelegate)this.servant._get_delegate())._invoke(this.servant, this.request.operation(), this.request.getInputStream(), this.request);
                } else {
                    ((DynamicImplementation)this.servant).invoke(this.request);
                }
            } else {
                this.controller.getLogTrace().printLog(0, this.request, "unknown servant type (neither stream nor dsi based)");
            }
        }
        catch (SystemException systemException) {
            this.controller.getLogTrace().printLog(1, this.request, "invocation: system exception was thrown (" + systemException + ")");
            this.request.setSystemException(systemException);
        }
        catch (Throwable throwable) {
            this.controller.getLogTrace().printLog(0, this.request, "invocation: throwable was thrown");
            this.controller.getLogTrace().printLog(0, throwable);
            this.request.setSystemException(new UNKNOWN());
        }
    }

    private void invokePostInvoke() {
        try {
            this.controller.getLogTrace().printLog(3, this.request, "invoke postinvoke on servant locator");
            ((ServantLocator)this.servantManager).postinvoke(this.request.objectId(), this.controller.getPOA(), this.request.operation(), this.cookieHolder.value, this.servant);
        }
        catch (SystemException systemException) {
            this.controller.getLogTrace().printLog(1, this.request, "postinvoke: system exception was thrown (" + systemException + ")");
            this.request.setSystemException(systemException);
        }
        catch (Throwable throwable) {
            this.controller.getLogTrace().printLog(0, this.request, "postinvoke: throwable was thrown");
            this.controller.getLogTrace().printLog(0, throwable);
            this.request.setSystemException(new OBJ_ADAPTER());
        }
    }

    private void invokePreInvoke() {
        this.controller.getLogTrace().printLog(3, this.request, "invoke preinvoke on servant locator");
        try {
            this.cookieHolder = new CookieHolder();
            this.servant = ((ServantLocator)this.servantManager).preinvoke(this.request.objectId(), this.controller.getPOA(), this.request.operation(), this.cookieHolder);
            if (this.servant == null) {
                this.controller.getLogTrace().printLog(0, this.request, "preinvoke: returns null");
                this.request.setSystemException(new OBJ_ADAPTER());
            }
            this.controller.getORB().set_delegate(this.servant);
        }
        catch (SystemException systemException) {
            this.controller.getLogTrace().printLog(1, this.request, "preinvoke: system exception was thrown (" + systemException + ")");
            this.request.setSystemException(systemException);
        }
        catch (org.omg.PortableServer.ForwardRequest forwardRequest) {
            this.controller.getLogTrace().printLog(1, this.request, "preinvoke: forward exception was thrown (" + forwardRequest + ")");
            this.request.setLocationForward(forwardRequest);
        }
        catch (Throwable throwable) {
            this.controller.getLogTrace().printLog(0, this.request, "preinvoke: throwable was thrown");
            this.controller.getLogTrace().printLog(0, throwable);
            this.request.setSystemException(new OBJ_ADAPTER(throwable.getMessage()));
        }
    }

    boolean isActive() {
        return this.start;
    }

    private void process() {
        InterceptorManager interceptorManager;
        ServerRequestInfoImpl serverRequestInfoImpl = null;
        if (this.controller.getORB().hasServerRequestInterceptors()) {
            serverRequestInfoImpl = new ServerRequestInfoImpl(this.controller.getORB(), this.request, this.servant);
            interceptorManager = this.controller.getORB().getInterceptorManager();
            serverRequestInfoImpl.current = interceptorManager.getEmptyCurrent();
            if (!this.invokeInterceptors(serverRequestInfoImpl, (short)0)) {
                this.request.getReplyOutputStream().setServiceContexts(serverRequestInfoImpl.getReplyServiceContexts());
                return;
            }
            interceptorManager.setTSCurrent(serverRequestInfoImpl.current);
        }
        if (this.servantManager != null) {
            if (this.servantManager instanceof ServantActivator) {
                this.invokeIncarnate();
            } else {
                this.invokePreInvoke();
            }
        }
        if (this.servant != null) {
            if (serverRequestInfoImpl != null) {
                serverRequestInfoImpl.setServant(this.servant);
                if (this.servant instanceof InvokeHandler) {
                    boolean bl = false;
                    bl = this.invokeInterceptors(serverRequestInfoImpl, (short)1) ^ true;
                    if (bl) {
                        if (this.cookieHolder != null) {
                            this.invokePostInvoke();
                        }
                        this.request.getReplyOutputStream().setServiceContexts(serverRequestInfoImpl.getReplyServiceContexts());
                        return;
                    }
                } else if (this.servant instanceof DynamicImplementation) {
                    this.request.setServerRequestInfo(serverRequestInfoImpl);
                }
            }
            this.invokeOperation();
        }
        if (this.cookieHolder != null) {
            this.invokePostInvoke();
        }
        if (serverRequestInfoImpl != null) {
            interceptorManager = this.controller.getORB().getInterceptorManager();
            serverRequestInfoImpl.current = interceptorManager.getCurrent();
            int n = 0;
            switch (this.request.status().value()) {
                case 0: {
                    n = 2;
                    serverRequestInfoImpl.reply_status = 0;
                    break;
                }
                case 1: {
                    serverRequestInfoImpl.reply_status = (short)2;
                    SystemExceptionHelper.insert(serverRequestInfoImpl.sending_exception, new UNKNOWN("Stream-based UserExceptions are not available!"));
                    n = 3;
                    break;
                }
                case 2: {
                    serverRequestInfoImpl.reply_status = 1;
                    SystemExceptionHelper.insert(serverRequestInfoImpl.sending_exception, this.request.getSystemException());
                    n = 3;
                    break;
                }
                case 3: {
                    serverRequestInfoImpl.reply_status = (short)3;
                    n = 4;
                    break;
                }
            }
            this.invokeInterceptors(serverRequestInfoImpl, (short)n);
            this.request.get_out().setServiceContexts(serverRequestInfoImpl.getReplyServiceContexts());
            interceptorManager.removeTSCurrent();
        }
    }

    public void run() {
        while (!this.terminate) {
            RequestProcessor requestProcessor = this;
            synchronized (requestProcessor) {
                try {
                    if (!this.start) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {}
                if (this.terminate) {
                    Object var2_2 = null;
                    return;
                }
            }
            this.controller.getLogTrace().printLog(1026, this.request, "process request");
            this.process();
            this.controller.getLogTrace().printLog(3, this.request, "ends with request processing");
            this.controller.returnResult(this.request);
            this.start = false;
            this.poolManager.releaseProcessor(this);
        }
    }
}

