/*
 * Decompiled with CFR 0.152.
 */
package jacorb.proxy;

import jacorb.orb.CDRInputStream;
import jacorb.orb.ClientSideConnection;
import jacorb.orb.Connection;
import jacorb.orb.Delegate;
import jacorb.orb.Forwarder;
import jacorb.orb.ParsedIOR;
import jacorb.orb.giop.ReplyInputStream;
import jacorb.orb.giop.RequestOutputStream;
import jacorb.proxy.ForwarderPOA;
import jacorb.proxy.ForwarderPOATie;
import jacorb.proxy.MiniStub;
import jacorb.util.Debug;
import jacorb.util.Environment;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.ServerRequest;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.CurrentHelper;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyValue;

class ForwarderImpl
extends ForwarderPOA {
    private static int counter = 0;
    private Hashtable forwardMap = new Hashtable();
    private Hashtable iorMap = new Hashtable();
    private Hashtable iorRefCnt = new Hashtable();
    private jacorb.orb.ORB orb;
    private POA rootPOA;
    private POA forwarderPOA;

    public ForwarderImpl(ORB oRB) {
        this.orb = (jacorb.orb.ORB)oRB;
        try {
            this.rootPOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            POAManager pOAManager = this.rootPOA.the_POAManager();
            Policy[] policyArray = new Policy[]{this.rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), this.rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID), this.rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN)};
            this.forwarderPOA = this.rootPOA.create_POA("FORWARDER_POA", pOAManager, policyArray);
            int n = 0;
            while (n < policyArray.length) {
                policyArray[n].destroy();
                ++n;
            }
            this.forwarderPOA.set_servant(new ProxyEntry(oRB));
            pOAManager.activate();
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
    }

    public String forward(String string, StringHolder stringHolder) {
        Debug.output(2, "Forwading for IOR: " + string);
        Object object = null;
        ParsedIOR parsedIOR = new ParsedIOR(string);
        String string2 = null;
        try {
            object = (Object)this.iorMap.get(string);
            if (object == null) {
                Debug.output(3, "Creating new proxy object");
                this.forwarderPOA = this.rootPOA.find_POA("FORWARDER_POA", false);
                object = this.forwarderPOA.create_reference(parsedIOR.getIOR().type_id);
                string2 = new String(this.forwarderPOA.reference_to_id(object));
                Delegate delegate = (Delegate)((ObjectImpl)object)._get_delegate();
                Connection connection = this.orb.getConnectionManager()._getConnection(parsedIOR.getAddress(), false);
                MiniStub miniStub = new MiniStub(connection, parsedIOR);
                this.forwardMap.put(string2, miniStub);
                this.iorMap.put(string, object);
                this.iorRefCnt.put(string, new Integer(1));
            } else {
                Debug.output(3, "Proxyobject taken from cache");
                Integer n = (Integer)this.iorRefCnt.get(string);
                int n2 = n;
                this.iorRefCnt.put(string, new Integer(++n2));
                string2 = new String(this.forwarderPOA.reference_to_id(object));
            }
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
        stringHolder.value = string2;
        return this.orb.object_to_string(object);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            Debug.output(0, "usage: appligator <port> <IOR-File>");
            System.exit(1);
        }
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("OAPort", stringArray[0]);
            ORB oRB = ORB.init(stringArray, properties);
            POA pOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            pOA.the_POAManager().activate();
            ForwarderPOATie forwarderPOATie = new ForwarderPOATie(new ForwarderImpl(oRB));
            Object object = pOA.servant_to_reference(forwarderPOATie);
            FileWriter fileWriter = new FileWriter(stringArray[1]);
            fileWriter.write(oRB.object_to_string(object));
            fileWriter.close();
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(oRB.resolve_initial_references("NameService"));
            if (namingContextExt == null) {
                Debug.output(1, "Nameserver not present. Trying without");
            } else {
                namingContextExt.bind(namingContextExt.to_name("proxyserver"), object);
            }
            oRB.run();
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
        catch (IOException iOException) {
            Debug.output(1, "Could not write IOR File:" + iOException.toString());
        }
    }

    public synchronized void release(String string) {
        Debug.output(3, "Release starts...");
        try {
            MiniStub miniStub = (MiniStub)this.forwardMap.get(string);
            String string2 = miniStub.getParsedIOR().getIORString();
            Integer n = (Integer)this.iorRefCnt.get(string2);
            int n2 = n;
            if (n2 == 1) {
                this.iorMap.remove(string2);
                this.forwardMap.remove(string);
                Connection connection = miniStub.getConnection();
                connection.releaseConnection();
                this.iorRefCnt.remove(string2);
            } else {
                this.iorRefCnt.put(string2, new Integer(--n2));
            }
        }
        catch (NullPointerException nullPointerException) {}
        Debug.output(3, "Release ends");
    }

    private class ProxyEntry
    extends DynamicImplementation
    implements Forwarder {
        private jacorb.orb.ORB orb;

        public ProxyEntry(ORB oRB) {
            this.orb = (jacorb.orb.ORB)oRB;
        }

        public void Xswap4(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
            byte by = byArray[n + n5];
            byArray[n + n5] = byArray[n4 + n5];
            byArray[n4 + n5] = by;
            by = byArray[n2 + n5];
            byArray[n3 + n5] = byArray[n2 + n5];
            byArray[n2 + n5] = by;
        }

        public String[] _all_interfaces(POA pOA, byte[] byArray) {
            String[] stringArray = new String[]{"IDL:jacorb/proxy/Forwarder:1.0"};
            return stringArray;
        }

        public void changeByteOrder(byte[] byArray) {
            boolean bl = (byArray[6] & 1) == 0;
            boolean bl2 = byArray[5] == 1;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            this.Xswap4(byArray, 8, 9, 10, 11, 0);
            this.Xswap4(byArray, 12, 13, 14, 15, 0);
            n = bl ? ((byArray[15] & 0xFF) << 24) + ((byArray[14] & 0xFF) << 16) + ((byArray[13] & 0xFF) << 8) + (byArray[12] & 0xFF) : ((byArray[12] & 0xFF) << 24) + ((byArray[13] & 0xFF) << 16) + ((byArray[14] & 0xFF) << 8) + (byArray[15] & 0xFF);
            int n4 = n;
            while (n4 > 0) {
                this.Xswap4(byArray, 16, 17, 18, 19, n3);
                this.Xswap4(byArray, 20, 21, 22, 23, n3);
                int n5 = bl ? ((byArray[23 + n3] & 0xFF) << 24) + ((byArray[22 + n3] & 0xFF) << 16) + ((byArray[21 + n3] & 0xFF) << 8) + (byArray[20 + n3] & 0xFF) : ((byArray[20 + n3] & 0xFF) << 24) + ((byArray[21 + n3] & 0xFF) << 16) + ((byArray[22 + n3] & 0xFF) << 8) + (byArray[23 + n3] & 0xFF);
                n3 = n3 + 8 + n5;
                --n4;
            }
            this.Xswap4(byArray, 16, 17, 18, 19, n3);
            if (bl2) {
                n3 += 3;
            }
            this.Xswap4(byArray, 21, 22, 23, 24, n3);
            n2 = bl ? ((byArray[24 + n3] & 0xFF) << 24) + ((byArray[23 + n3] & 0xFF) << 16) + ((byArray[22 + n3] & 0xFF) << 8) + (byArray[21 + n3] & 0xFF) : ((byArray[21 + n3] & 0xFF) << 24) + ((byArray[22 + n3] & 0xFF) << 16) + ((byArray[23 + n3] & 0xFF) << 8) + (byArray[24 + n3] & 0xFF);
            this.Xswap4(byArray, 25, 26, 27, 28, n3 += n2);
            byArray[6] = (byte)(~(byArray[6] & 0xFE));
        }

        public void invoke(ServerRequest serverRequest) {
            java.lang.Object object;
            int n = counter;
            counter = n + 1;
            int n2 = n;
            Debug.output(1, "[DynProxy]invoked:" + n2);
            byte[] byArray = null;
            Integer n3 = null;
            jacorb.orb.dsi.ServerRequest serverRequest2 = (jacorb.orb.dsi.ServerRequest)serverRequest;
            byArray = serverRequest2.objectId();
            Current current = null;
            try {
                current = CurrentHelper.narrow(this.orb.resolve_initial_references("POACurrent"));
            }
            catch (UserException userException) {
                userException.printStackTrace();
            }
            MiniStub miniStub = (MiniStub)ForwarderImpl.this.forwardMap.get(new String(byArray));
            ParsedIOR parsedIOR = miniStub.getParsedIOR();
            Debug.output(4, "[Call should go to IOR: " + parsedIOR + " ]");
            ReplyInputStream replyInputStream = null;
            Connection connection = miniStub.getConnection();
            if (!connection.connected()) {
                connection.reconnect();
            }
            RequestOutputStream requestOutputStream = null;
            try {
                requestOutputStream = new RequestOutputStream(connection, this.orb, serverRequest2.operation(), serverRequest2.get_in().req_hdr.response_expected, parsedIOR.get_object_key(), serverRequest2.getServiceContext());
                object = connection.writeLock;
                synchronized (object) {
                    byte[] byArray2 = requestOutputStream.getInternalBuffer();
                    System.out.println("[" + n2 + "]Incoming Request with size: " + (serverRequest2.get_in().msg_hdr.message_size + 12));
                    int n4 = serverRequest2.get_in().msg_hdr.message_size + 12 - serverRequest2.get_in().get_pos();
                    if (n4 > 0) {
                        System.arraycopy(serverRequest2.get_in().getBuffer(), serverRequest2.get_in().get_pos(), byArray2, requestOutputStream.size(), n4);
                    }
                    requestOutputStream.setSize(requestOutputStream.size() + n4);
                    requestOutputStream.insertMsgSize();
                    if ((serverRequest2.get_in().getBuffer()[6] & 1) != (byArray2[6] & 1)) {
                        this.changeByteOrder(byArray2);
                    }
                    if (Environment.verbosityLevel() >= 3) {
                        Debug.output(3, "[Proxy:Incoming byte-stream:]");
                        int n5 = 0;
                        while (n5 < serverRequest2.get_in().msg_hdr.message_size + 12) {
                            System.out.print(String.valueOf(serverRequest2.get_in().getBuffer()[n5]) + "  ");
                            ++n5;
                        }
                        Debug.output(3, "[Proxy:Outgoing byte-stream:]");
                        int n6 = 0;
                        while (n6 < requestOutputStream.size()) {
                            System.out.print(String.valueOf(requestOutputStream.getInternalBuffer()[n6]) + "  ");
                            ++n6;
                        }
                        System.out.println("[The real Data:]");
                        int n7 = serverRequest2.get_in().get_pos();
                        while (n7 < serverRequest2.get_in().msg_hdr.message_size + 12) {
                            System.out.print(String.valueOf(serverRequest2.get_in().getBuffer()[n7]) + "  ");
                            ++n7;
                        }
                    }
                    if (requestOutputStream.response_expected()) {
                        replyInputStream = new ReplyInputStream(connection, requestOutputStream.requestId());
                        n3 = new Integer(requestOutputStream.requestId());
                        ((ClientSideConnection)((java.lang.Object)connection)).get_replies().put(n3, replyInputStream);
                        ((ClientSideConnection)((java.lang.Object)connection)).get_objects().put(n3, current.get_POA().servant_to_reference(this));
                    }
                    System.out.println("[" + n2 + "]Outgoing Request with size: " + requestOutputStream.size());
                    ((ClientSideConnection)((java.lang.Object)connection)).writeDirectly(requestOutputStream.getInternalBuffer(), requestOutputStream.size());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (requestOutputStream.response_expected()) {
                    object = (ReplyInputStream)replyInputStream.rawResult();
                    ((ClientSideConnection)((java.lang.Object)connection)).get_replies().remove(n3);
                    ((ClientSideConnection)((java.lang.Object)connection)).get_objects().remove(n3);
                    serverRequest2.reply(((CDRInputStream)object).getBuffer(), ((ReplyInputStream)object).msg_hdr.message_size + 12);
                }
            }
            catch (Exception exception) {
                Debug.output(1, "Proxy:reply forward error");
                serverRequest2.setSystemException(new COMM_FAILURE(exception.toString()));
                serverRequest2.reply();
            }
            Debug.output(1, "[DynProxy]invoke DONE:" + n2);
        }
    }
}

