/* AppGlobal.java
 *
 * created: Fri May 19 2000
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/AppGlobal.java,v 1.7 2000/08/31 10:05:24 kmr Exp $
 */

import uk.ac.sanger.pathogens.*;

import diana.*;
import diana.components.*;

import java.io.*;
import java.awt.*;
import java.net.*;

/**
 *  This class contains static methods that are needed by all the programs
 *  based on Artemis.  Each application needs to implement these methods
 *  appropriately.
 *
 *  @author Kim Rutherford <kmr@sanger.ac.uk>
 *  @version $Id: AppGlobal.java,v 1.7 2000/08/31 10:05:24 kmr Exp $
 **/

public class AppGlobal {
  /**
   *  Returns false for applications.
   **/
  public static boolean isApplet () {
    return false;
  }

  /**
   *  This method is a hack to get around a bug in Netscape - it is
   *  implemented differently in applets.
   **/
  public static InputStream getFileFromJar (final String file_name) {
    return AppGlobal.class.getResourceAsStream (file_name);
  }

  /**
   *  Return a Logger for warnings/errors/messages.
   **/
  public static Logger getLogger () {
    return diana.components.ArtemisMain.getLogger ();
  }

  /**
   *  Returns a Vector containing the possible Entry sources for this
   *  application.
   *  @param frame The component that is creating the EntrySource objects.
   *    (Used for requesters.)
   *  @param listener InputStreamProgressEvent objects will be sent to this
   *    listener as progress on reading is made.
   **/
  public static EntrySourceVector
    getEntrySources (final Frame frame,
                     final InputStreamProgressListener listener) {

    final EntrySourceVector return_vector = new EntrySourceVector ();
    
    return_vector.add (new FileDialogEntrySource (frame, listener));

    // this doesn't work on a v1.2 system so it is taken out with perl when
    // necessary 
    // CORBA_START_MARKER

    // The location of the IOR for the corba server at EMBL.  Can be
    // overridden using the options file. 
    final String embl_ior_url =
      Options.getOptions ().getProperty ("embl_ior_url");

    if (embl_ior_url != null) {
      try {
        return_vector.add (new EMBLCorbaEntrySource (frame, embl_ior_url));
      } catch (MalformedURLException e) {
        new MessageDialog (frame, "the url given for the embl database is " +
                           "badly formatted: " + e.getMessage ());
      }
    }

    // The location of the IOR for the EnsEMBL corba server.  Can be
    // overridden using the options file.
    final String ensembl_ior_url =
      Options.getOptions ().getProperty ("ensembl_ior_url");

    // The location of the IOR for the pathogens group read-write corba
    // server. 
    final String db_ior_url =
      Options.getOptions ().getProperty ("db_ior_url");
    
    if (db_ior_url != null) {
      try {
        return_vector.add (new WritableEMBLCorbaEntrySource (frame,
                                                             db_ior_url));
      } catch (MalformedURLException e) {
        new MessageDialog (frame, "the url given for the embl database is " +
                           "badly formatted: " + e.getMessage ());
      }
    }
    // CORBA_END_MARKER

//            final String ensembl_ior_url =
//          Options.getOptions ().getProperty ("ensembl_ior_url");

//            if (ensembl_ior_url != null) {
//            }
          
    return return_vector;
  }
}
