/* FeatureChangeEvent.java
 *
 * created: Sat Oct 17 1998
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1998,1999,2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/FeatureChangeEvent.java,v 1.11 2000/01/24 17:04:16 kmr Exp $
 */

package diana;

/**
 *  This event is sent when a change occurs within a feature.  eg the location
 *  or qualifier changes.
 *
 *  @author Kim Rutherford
 *  @version $Id: FeatureChangeEvent.java,v 1.11 2000/01/24 17:04:16 kmr Exp $
  */

public class FeatureChangeEvent extends ChangeEvent {
  /**
   *  Event type - feature location changed.
   */
  public static final int LOCATION_CHANGED = 1;

  /**
   *  Event type - feature qualifier changed.
   */
  public static final int QUALIFIER_CHANGED = 2;

  /**
   *  Event type - feature key changed.
   */
  public static final int KEY_CHANGED = 3;

  /**
   *  Event type - feature has been re-read.
   */
  public static final int ALL_CHANGED = 4;

  /**
   *  Create a new FeatureChangeEvent object.
   *  @param source The object that generated the event.
   *  @param feature This Feature object that this event refers to.
   *  @param type This type of the event.
   **/
  public FeatureChangeEvent (Object source,
                             Feature feature,
                             int type)
      //     throws IllegalArgumentException
  {
    super (source);
    this.feature = feature;
    this.type = type;
  }

  /**
   *  Return the Feature of this event.
   **/
  public Feature getFeature () {
    return feature;
  }
   
  /**
   *  Return the type of this event as passed to the constructor.
   **/
  public int getType () {
    return type;
  }

  /**
   *  The feature that this event was generated for.
   **/
  private Feature feature;

  /**
   *  This is the type of this event (eg LOCATION_CHANGED, QUALIFIER_CHANGED,
   *  etc), as passed to the constructor
   **/
  private int type;
}


