/* FeatureListFrame.java
 *
 * created: Fri Sep  3 1999
 *
 * This file is part of Artemis
 *
 * Copyright (C) 1999  Genome Research Limited
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/FeatureListFrame.java,v 1.6 2000/05/23 14:08:46 kmr Exp $
 */

package diana.components;

import diana.*;

import java.awt.*;
import java.awt.event.*;

/**
 *  A Frame that contains a FeatureList component and an Close button.
 *
 *  @author Kim Rutherford
 *  @version $Id: FeatureListFrame.java,v 1.6 2000/05/23 14:08:46 kmr Exp $
 **/

public class FeatureListFrame extends Frame {
  /**
   *  Create a new FeatureListFrame component.  The constructor does not call
   *  setVisible (true).
   *  @param title The title to use for the new Frame.
   *  @param feature_list The FeatureList to show.
   *  @param selection The Selection that the commands in the menus will
   *    operate on.
   *  @param entry_group The EntryGroup object where new features/entries will
   *    be added.
   *  @param goto_event_source The object that the menu item will call
   *    makeBaseVisible () on.
   **/
  public FeatureListFrame (final String title,
                           final Selection selection,
                           final GotoEventSource goto_event_source,
                           final EntryGroup entry_group) {
    super (title);

    feature_list = new FeatureList (entry_group, selection, goto_event_source);
    
    final Font default_font = Options.getOptions ().getFont ();
    
    setFont (default_font);

    final MenuBar menu_bar = new MenuBar ();

    menu_bar.setFont (default_font);

    setMenuBar (menu_bar);

    final Menu file_menu = new Menu ("File");

    final MenuItem close = new MenuItem ("Close");
    close.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent event) {
        setVisible (false);
        FeatureListFrame.this.dispose ();
        feature_list.stopListening ();        
      }
    });

    file_menu.add (close);

    menu_bar.add (file_menu);
    
    final Menu select_menu =
      new SelectMenu (this, selection, goto_event_source, entry_group);
    menu_bar.add (select_menu);

    final Menu view_menu =
      new ViewMenu (this, selection, goto_event_source, entry_group);
    menu_bar.add (view_menu);

    final Menu goto_menu =
      new GotoMenu (this, selection, goto_event_source, entry_group);
    menu_bar.add (goto_menu);

    if (Options.isStandAlone ()) {
      final Menu edit_menu =
        new EditMenu (this, selection, goto_event_source, entry_group);
      menu_bar.add (edit_menu);

      final Menu write_menu = new WriteMenu (this, selection, entry_group);
      menu_bar.add (write_menu);

      final Menu run_menu = new RunMenu (this, selection);
      menu_bar.add (run_menu);
    }

    add (feature_list, "Center");

    final Panel panel = new Panel ();

    final Button close_button = new Button ("Close");

    panel.add (close_button);
    close_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        setVisible (false);
        FeatureListFrame.this.dispose ();
        feature_list.stopListening ();
      }
    });

    add (panel, "South");
    pack ();

    addWindowListener (new WindowAdapter () {
      public void windowClosing (WindowEvent event) {
        setVisible (false);
        FeatureListFrame.this.dispose ();
        feature_list.stopListening ();
      }
    });

    setSize (700, 400);

    final Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    setLocation (new Point ((screen.width - getSize ().width) / 2,
                            (screen.height - getSize ().height) / 2));
  }

  /**
   *  Return the FeatureList that this Frame is displaying.
   **/
  public FeatureList getFeatureList () {
    return feature_list;
  }

  /**
   *  The FeatureList that this Frame is displaying.
   **/
  final FeatureList feature_list;
}

