/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 5.72, Date: 22-Mar-2005.
 */
#include "ooasn1.h"
#include "MULTIMEDIA-SYSTEM-CONTROL.h"
#include "eventHandler.h"

/**************************************************************/
/*                                                            */
/*  NonStandardIdentifier_h221NonStandard                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245NonStandardIdentifier_h221NonStandard (OOCTXT* pctxt, H245NonStandardIdentifier_h221NonStandard* pvalue)
{
   int stat = ASN_OK;

   /* decode t35CountryCode */

   invokeStartElement (pctxt, "t35CountryCode", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->t35CountryCode, 0U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->t35CountryCode);

   invokeEndElement (pctxt, "t35CountryCode", -1);

   /* decode t35Extension */

   invokeStartElement (pctxt, "t35Extension", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->t35Extension, 0U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->t35Extension);

   invokeEndElement (pctxt, "t35Extension", -1);

   /* decode manufacturerCode */

   invokeStartElement (pctxt, "manufacturerCode", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->manufacturerCode, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->manufacturerCode);

   invokeEndElement (pctxt, "manufacturerCode", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonStandardIdentifier                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245NonStandardIdentifier (OOCTXT* pctxt, H245NonStandardIdentifier* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* object */
      case 0:
         invokeStartElement (pctxt, "object", -1);

         pvalue->u.object = ALLOC_ASN1ELEM (pctxt, ASN1OBJID);

         stat = decodeObjectIdentifier (pctxt, pvalue->u.object);
         if (stat != ASN_OK) return stat;
         invokeOidValue (pctxt, pvalue->u.object->numids, pvalue->u.object->subid);

         invokeEndElement (pctxt, "object", -1);

         break;

      /* h221NonStandard */
      case 1:
         invokeStartElement (pctxt, "h221NonStandard", -1);

         pvalue->u.h221NonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardIdentifier_h221NonStandard);

         stat = asn1PD_H245NonStandardIdentifier_h221NonStandard (pctxt, pvalue->u.h221NonStandard);
         if (stat != ASN_OK) return stat;

         invokeEndElement (pctxt, "h221NonStandard", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonStandardParameter                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245NonStandardParameter (OOCTXT* pctxt, H245NonStandardParameter* pvalue)
{
   int stat = ASN_OK;

   /* decode nonStandardIdentifier */

   invokeStartElement (pctxt, "nonStandardIdentifier", -1);

   stat = asn1PD_H245NonStandardIdentifier (pctxt, &pvalue->nonStandardIdentifier);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "nonStandardIdentifier", -1);

   /* decode data */

   invokeStartElement (pctxt, "data", -1);

   stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->data);
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->data.numocts, pvalue->data.data);

   invokeEndElement (pctxt, "data", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V42bis                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245V42bis (OOCTXT* pctxt, H245V42bis* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode numberOfCodewords */

   invokeStartElement (pctxt, "numberOfCodewords", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->numberOfCodewords, 1U, 65536U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->numberOfCodewords);

   invokeEndElement (pctxt, "numberOfCodewords", -1);

   /* decode maximumStringLength */

   invokeStartElement (pctxt, "maximumStringLength", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maximumStringLength, 1U, 256U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumStringLength);

   invokeEndElement (pctxt, "maximumStringLength", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CompressionType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CompressionType (OOCTXT* pctxt, H245CompressionType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* v42bis */
         case 0:
            invokeStartElement (pctxt, "v42bis", -1);

            pvalue->u.v42bis = ALLOC_ASN1ELEM (pctxt, H245V42bis);

            stat = asn1PD_H245V42bis (pctxt, pvalue->u.v42bis);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "v42bis", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 2;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataProtocolCapability_v76wCompression                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataProtocolCapability_v76wCompression (OOCTXT* pctxt, H245DataProtocolCapability_v76wCompression* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* transmitCompression */
         case 0:
            invokeStartElement (pctxt, "transmitCompression", -1);

            pvalue->u.transmitCompression = ALLOC_ASN1ELEM (pctxt, H245CompressionType);

            stat = asn1PD_H245CompressionType (pctxt, pvalue->u.transmitCompression);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "transmitCompression", -1);

            break;

         /* receiveCompression */
         case 1:
            invokeStartElement (pctxt, "receiveCompression", -1);

            pvalue->u.receiveCompression = ALLOC_ASN1ELEM (pctxt, H245CompressionType);

            stat = asn1PD_H245CompressionType (pctxt, pvalue->u.receiveCompression);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveCompression", -1);

            break;

         /* transmitAndReceiveCompression */
         case 2:
            invokeStartElement (pctxt, "transmitAndReceiveCompression", -1);

            pvalue->u.transmitAndReceiveCompression = ALLOC_ASN1ELEM (pctxt, H245CompressionType);

            stat = asn1PD_H245CompressionType (pctxt, pvalue->u.transmitAndReceiveCompression);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "transmitAndReceiveCompression", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataProtocolCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataProtocolCapability (OOCTXT* pctxt, H245DataProtocolCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 6);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* v14buffered */
         case 1:
            invokeStartElement (pctxt, "v14buffered", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "v14buffered", -1);

            break;

         /* v42lapm */
         case 2:
            invokeStartElement (pctxt, "v42lapm", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "v42lapm", -1);

            break;

         /* hdlcFrameTunnelling */
         case 3:
            invokeStartElement (pctxt, "hdlcFrameTunnelling", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "hdlcFrameTunnelling", -1);

            break;

         /* h310SeparateVCStack */
         case 4:
            invokeStartElement (pctxt, "h310SeparateVCStack", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "h310SeparateVCStack", -1);

            break;

         /* h310SingleVCStack */
         case 5:
            invokeStartElement (pctxt, "h310SingleVCStack", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "h310SingleVCStack", -1);

            break;

         /* transparent */
         case 6:
            invokeStartElement (pctxt, "transparent", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "transparent", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 8;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* segmentationAndReassembly */
         case 8:
            invokeStartElement (pctxt, "segmentationAndReassembly", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "segmentationAndReassembly", -1);

            break;

         /* hdlcFrameTunnelingwSAR */
         case 9:
            invokeStartElement (pctxt, "hdlcFrameTunnelingwSAR", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "hdlcFrameTunnelingwSAR", -1);

            break;

         /* v120 */
         case 10:
            invokeStartElement (pctxt, "v120", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "v120", -1);

            break;

         /* separateLANStack */
         case 11:
            invokeStartElement (pctxt, "separateLANStack", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "separateLANStack", -1);

            break;

         /* v76wCompression */
         case 12:
            invokeStartElement (pctxt, "v76wCompression", -1);

            pvalue->u.v76wCompression = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability_v76wCompression);

            stat = asn1PD_H245DataProtocolCapability_v76wCompression (pctxt, pvalue->u.v76wCompression);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "v76wCompression", -1);

            break;

         /* tcp */
         case 13:
            invokeStartElement (pctxt, "tcp", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "tcp", -1);

            break;

         /* udp */
         case 14:
            invokeStartElement (pctxt, "udp", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "udp", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T38FaxRateManagement                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245T38FaxRateManagement (OOCTXT* pctxt, H245T38FaxRateManagement* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* localTCF */
         case 0:
            invokeStartElement (pctxt, "localTCF", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "localTCF", -1);

            break;

         /* transferredTCF */
         case 1:
            invokeStartElement (pctxt, "transferredTCF", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "transferredTCF", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T38FaxUdpOptions_t38FaxUdpEC                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245T38FaxUdpOptions_t38FaxUdpEC (OOCTXT* pctxt, H245T38FaxUdpOptions_t38FaxUdpEC* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* t38UDPFEC */
         case 0:
            invokeStartElement (pctxt, "t38UDPFEC", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "t38UDPFEC", -1);

            break;

         /* t38UDPRedundancy */
         case 1:
            invokeStartElement (pctxt, "t38UDPRedundancy", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "t38UDPRedundancy", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T38FaxUdpOptions                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245T38FaxUdpOptions (OOCTXT* pctxt, H245T38FaxUdpOptions* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL optbit;

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.t38FaxMaxBufferPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.t38FaxMaxDatagramPresent = optbit;

   /* decode t38FaxMaxBuffer */

   if (pvalue->m.t38FaxMaxBufferPresent) {
      invokeStartElement (pctxt, "t38FaxMaxBuffer", -1);

      stat = decodeUnconsInteger (pctxt, &pvalue->t38FaxMaxBuffer);
      if (stat != ASN_OK) return stat;
      invokeIntValue (pctxt, pvalue->t38FaxMaxBuffer);

      invokeEndElement (pctxt, "t38FaxMaxBuffer", -1);
   }

   /* decode t38FaxMaxDatagram */

   if (pvalue->m.t38FaxMaxDatagramPresent) {
      invokeStartElement (pctxt, "t38FaxMaxDatagram", -1);

      stat = decodeUnconsInteger (pctxt, &pvalue->t38FaxMaxDatagram);
      if (stat != ASN_OK) return stat;
      invokeIntValue (pctxt, pvalue->t38FaxMaxDatagram);

      invokeEndElement (pctxt, "t38FaxMaxDatagram", -1);
   }

   /* decode t38FaxUdpEC */

   invokeStartElement (pctxt, "t38FaxUdpEC", -1);

   stat = asn1PD_H245T38FaxUdpOptions_t38FaxUdpEC (pctxt, &pvalue->t38FaxUdpEC);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "t38FaxUdpEC", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T38FaxTcpOptions                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245T38FaxTcpOptions (OOCTXT* pctxt, H245T38FaxTcpOptions* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode t38TCPBidirectionalMode */

   invokeStartElement (pctxt, "t38TCPBidirectionalMode", -1);

   stat = DECODEBIT (pctxt, &pvalue->t38TCPBidirectionalMode);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->t38TCPBidirectionalMode);

   invokeEndElement (pctxt, "t38TCPBidirectionalMode", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T38FaxProfile                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245T38FaxProfile (OOCTXT* pctxt, H245T38FaxProfile* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode fillBitRemoval */

   invokeStartElement (pctxt, "fillBitRemoval", -1);

   stat = DECODEBIT (pctxt, &pvalue->fillBitRemoval);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->fillBitRemoval);

   invokeEndElement (pctxt, "fillBitRemoval", -1);

   /* decode transcodingJBIG */

   invokeStartElement (pctxt, "transcodingJBIG", -1);

   stat = DECODEBIT (pctxt, &pvalue->transcodingJBIG);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->transcodingJBIG);

   invokeEndElement (pctxt, "transcodingJBIG", -1);

   /* decode transcodingMMR */

   invokeStartElement (pctxt, "transcodingMMR", -1);

   stat = DECODEBIT (pctxt, &pvalue->transcodingMMR);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->transcodingMMR);

   invokeEndElement (pctxt, "transcodingMMR", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 4 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.versionPresent = 1;

                     invokeStartElement (pctxt, "version", -1);

                     stat = decodeConsUInt8 (pctxt, &pvalue->version, 0U, 255U);
                     if (stat != ASN_OK) return stat;
                     invokeUIntValue (pctxt, pvalue->version);

                     invokeEndElement (pctxt, "version", -1);
                     break;

                  case 1:
                     pvalue->m.t38FaxRateManagementPresent = 1;

                     invokeStartElement (pctxt, "t38FaxRateManagement", -1);

                     stat = asn1PD_H245T38FaxRateManagement (pctxt, &pvalue->t38FaxRateManagement);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "t38FaxRateManagement", -1);
                     break;

                  case 2:
                     pvalue->m.t38FaxUdpOptionsPresent = 1;

                     invokeStartElement (pctxt, "t38FaxUdpOptions", -1);

                     stat = asn1PD_H245T38FaxUdpOptions (pctxt, &pvalue->t38FaxUdpOptions);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "t38FaxUdpOptions", -1);
                     break;

                  case 3:
                     pvalue->m.t38FaxTcpOptionsPresent = 1;

                     invokeStartElement (pctxt, "t38FaxTcpOptions", -1);

                     stat = asn1PD_H245T38FaxTcpOptions (pctxt, &pvalue->t38FaxTcpOptions);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "t38FaxTcpOptions", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonStandardMessage                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245NonStandardMessage (OOCTXT* pctxt, H245NonStandardMessage* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode nonStandardData */

   invokeStartElement (pctxt, "nonStandardData", -1);

   stat = asn1PD_H245NonStandardParameter (pctxt, &pvalue->nonStandardData);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "nonStandardData", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MasterSlaveDetermination                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MasterSlaveDetermination (OOCTXT* pctxt, H245MasterSlaveDetermination* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode terminalType */

   invokeStartElement (pctxt, "terminalType", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->terminalType, 0U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->terminalType);

   invokeEndElement (pctxt, "terminalType", -1);

   /* decode statusDeterminationNumber */

   invokeStartElement (pctxt, "statusDeterminationNumber", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->statusDeterminationNumber, 0U, 16777215U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->statusDeterminationNumber);

   invokeEndElement (pctxt, "statusDeterminationNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SequenceNumber                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245SequenceNumber (OOCTXT* pctxt, H245SequenceNumber* pvalue)
{
   int stat = ASN_OK;

   stat = decodeConsUInt8 (pctxt, pvalue, 0U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, *pvalue);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_aal1                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VCCapability_aal1 (OOCTXT* pctxt, H245VCCapability_aal1* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode nullClockRecovery */

   invokeStartElement (pctxt, "nullClockRecovery", -1);

   stat = DECODEBIT (pctxt, &pvalue->nullClockRecovery);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->nullClockRecovery);

   invokeEndElement (pctxt, "nullClockRecovery", -1);

   /* decode srtsClockRecovery */

   invokeStartElement (pctxt, "srtsClockRecovery", -1);

   stat = DECODEBIT (pctxt, &pvalue->srtsClockRecovery);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->srtsClockRecovery);

   invokeEndElement (pctxt, "srtsClockRecovery", -1);

   /* decode adaptiveClockRecovery */

   invokeStartElement (pctxt, "adaptiveClockRecovery", -1);

   stat = DECODEBIT (pctxt, &pvalue->adaptiveClockRecovery);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->adaptiveClockRecovery);

   invokeEndElement (pctxt, "adaptiveClockRecovery", -1);

   /* decode nullErrorCorrection */

   invokeStartElement (pctxt, "nullErrorCorrection", -1);

   stat = DECODEBIT (pctxt, &pvalue->nullErrorCorrection);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->nullErrorCorrection);

   invokeEndElement (pctxt, "nullErrorCorrection", -1);

   /* decode longInterleaver */

   invokeStartElement (pctxt, "longInterleaver", -1);

   stat = DECODEBIT (pctxt, &pvalue->longInterleaver);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->longInterleaver);

   invokeEndElement (pctxt, "longInterleaver", -1);

   /* decode shortInterleaver */

   invokeStartElement (pctxt, "shortInterleaver", -1);

   stat = DECODEBIT (pctxt, &pvalue->shortInterleaver);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->shortInterleaver);

   invokeEndElement (pctxt, "shortInterleaver", -1);

   /* decode errorCorrectionOnly */

   invokeStartElement (pctxt, "errorCorrectionOnly", -1);

   stat = DECODEBIT (pctxt, &pvalue->errorCorrectionOnly);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->errorCorrectionOnly);

   invokeEndElement (pctxt, "errorCorrectionOnly", -1);

   /* decode structuredDataTransfer */

   invokeStartElement (pctxt, "structuredDataTransfer", -1);

   stat = DECODEBIT (pctxt, &pvalue->structuredDataTransfer);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->structuredDataTransfer);

   invokeEndElement (pctxt, "structuredDataTransfer", -1);

   /* decode partiallyFilledCells */

   invokeStartElement (pctxt, "partiallyFilledCells", -1);

   stat = DECODEBIT (pctxt, &pvalue->partiallyFilledCells);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->partiallyFilledCells);

   invokeEndElement (pctxt, "partiallyFilledCells", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_aal5                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VCCapability_aal5 (OOCTXT* pctxt, H245VCCapability_aal5* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode forwardMaximumSDUSize */

   invokeStartElement (pctxt, "forwardMaximumSDUSize", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->forwardMaximumSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->forwardMaximumSDUSize);

   invokeEndElement (pctxt, "forwardMaximumSDUSize", -1);

   /* decode backwardMaximumSDUSize */

   invokeStartElement (pctxt, "backwardMaximumSDUSize", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->backwardMaximumSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->backwardMaximumSDUSize);

   invokeEndElement (pctxt, "backwardMaximumSDUSize", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_availableBitRates_type_rangeOfBitRates       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VCCapability_availableBitRates_type_rangeOfBitRates (OOCTXT* pctxt, H245VCCapability_availableBitRates_type_rangeOfBitRates* pvalue)
{
   int stat = ASN_OK;

   /* decode lowerBitRate */

   invokeStartElement (pctxt, "lowerBitRate", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->lowerBitRate, 1U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->lowerBitRate);

   invokeEndElement (pctxt, "lowerBitRate", -1);

   /* decode higherBitRate */

   invokeStartElement (pctxt, "higherBitRate", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->higherBitRate, 1U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->higherBitRate);

   invokeEndElement (pctxt, "higherBitRate", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_availableBitRates_type                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VCCapability_availableBitRates_type (OOCTXT* pctxt, H245VCCapability_availableBitRates_type* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* singleBitRate */
      case 0:
         invokeStartElement (pctxt, "singleBitRate", -1);

         stat = decodeConsUInt16 (pctxt, &pvalue->u.singleBitRate, 1U, 65535U);
         if (stat != ASN_OK) return stat;
         invokeUIntValue (pctxt, pvalue->u.singleBitRate);

         invokeEndElement (pctxt, "singleBitRate", -1);

         break;

      /* rangeOfBitRates */
      case 1:
         invokeStartElement (pctxt, "rangeOfBitRates", -1);

         pvalue->u.rangeOfBitRates = ALLOC_ASN1ELEM (pctxt, H245VCCapability_availableBitRates_type_rangeOfBitRates);

         stat = asn1PD_H245VCCapability_availableBitRates_type_rangeOfBitRates (pctxt, pvalue->u.rangeOfBitRates);
         if (stat != ASN_OK) return stat;

         invokeEndElement (pctxt, "rangeOfBitRates", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_availableBitRates                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VCCapability_availableBitRates (OOCTXT* pctxt, H245VCCapability_availableBitRates* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode type */

   invokeStartElement (pctxt, "type", -1);

   stat = asn1PD_H245VCCapability_availableBitRates_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "type", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Q2931Address_address_nsapAddress                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245Q2931Address_address_nsapAddress (OOCTXT* pctxt, H245Q2931Address_address_nsapAddress* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 20, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Q2931Address_address                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245Q2931Address_address (OOCTXT* pctxt, H245Q2931Address_address* pvalue)
{
   static Asn1SizeCnst internationalNumber_lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* internationalNumber */
         case 0:
            invokeStartElement (pctxt, "internationalNumber", -1);

            addSizeConstraint (pctxt, &internationalNumber_lsize1);

            stat = decodeConstrainedStringEx (pctxt, &pvalue->u.internationalNumber, NUM_CANSET, 4, 4, 4);
            if (stat != ASN_OK) return stat;
            invokeCharStrValue (pctxt, pvalue->u.internationalNumber);

            invokeEndElement (pctxt, "internationalNumber", -1);

            break;

         /* nsapAddress */
         case 1:
            invokeStartElement (pctxt, "nsapAddress", -1);

            pvalue->u.nsapAddress = ALLOC_ASN1ELEM (pctxt, H245Q2931Address_address_nsapAddress);

            stat = asn1PD_H245Q2931Address_address_nsapAddress (pctxt, pvalue->u.nsapAddress);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nsapAddress", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Q2931Address_subaddress                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245Q2931Address_subaddress (OOCTXT* pctxt, H245Q2931Address_subaddress* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 20, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Q2931Address                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245Q2931Address (OOCTXT* pctxt, H245Q2931Address* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.subaddressPresent = optbit;

   /* decode address */

   invokeStartElement (pctxt, "address", -1);

   stat = asn1PD_H245Q2931Address_address (pctxt, &pvalue->address);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "address", -1);

   /* decode subaddress */

   if (pvalue->m.subaddressPresent) {
      invokeStartElement (pctxt, "subaddress", -1);

      stat = asn1PD_H245Q2931Address_subaddress (pctxt, &pvalue->subaddress);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "subaddress", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_aal1ViaGateway_gatewayAddress                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VCCapability_aal1ViaGateway_gatewayAddress (OOCTXT* pctxt, H245VCCapability_aal1ViaGateway_gatewayAddress* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245Q2931Address* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245Q2931Address);

      stat = asn1PD_H245Q2931Address (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_aal1ViaGateway                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VCCapability_aal1ViaGateway (OOCTXT* pctxt, H245VCCapability_aal1ViaGateway* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode gatewayAddress */

   invokeStartElement (pctxt, "gatewayAddress", -1);

   stat = asn1PD_H245VCCapability_aal1ViaGateway_gatewayAddress (pctxt, &pvalue->gatewayAddress);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "gatewayAddress", -1);

   /* decode nullClockRecovery */

   invokeStartElement (pctxt, "nullClockRecovery", -1);

   stat = DECODEBIT (pctxt, &pvalue->nullClockRecovery);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->nullClockRecovery);

   invokeEndElement (pctxt, "nullClockRecovery", -1);

   /* decode srtsClockRecovery */

   invokeStartElement (pctxt, "srtsClockRecovery", -1);

   stat = DECODEBIT (pctxt, &pvalue->srtsClockRecovery);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->srtsClockRecovery);

   invokeEndElement (pctxt, "srtsClockRecovery", -1);

   /* decode adaptiveClockRecovery */

   invokeStartElement (pctxt, "adaptiveClockRecovery", -1);

   stat = DECODEBIT (pctxt, &pvalue->adaptiveClockRecovery);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->adaptiveClockRecovery);

   invokeEndElement (pctxt, "adaptiveClockRecovery", -1);

   /* decode nullErrorCorrection */

   invokeStartElement (pctxt, "nullErrorCorrection", -1);

   stat = DECODEBIT (pctxt, &pvalue->nullErrorCorrection);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->nullErrorCorrection);

   invokeEndElement (pctxt, "nullErrorCorrection", -1);

   /* decode longInterleaver */

   invokeStartElement (pctxt, "longInterleaver", -1);

   stat = DECODEBIT (pctxt, &pvalue->longInterleaver);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->longInterleaver);

   invokeEndElement (pctxt, "longInterleaver", -1);

   /* decode shortInterleaver */

   invokeStartElement (pctxt, "shortInterleaver", -1);

   stat = DECODEBIT (pctxt, &pvalue->shortInterleaver);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->shortInterleaver);

   invokeEndElement (pctxt, "shortInterleaver", -1);

   /* decode errorCorrectionOnly */

   invokeStartElement (pctxt, "errorCorrectionOnly", -1);

   stat = DECODEBIT (pctxt, &pvalue->errorCorrectionOnly);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->errorCorrectionOnly);

   invokeEndElement (pctxt, "errorCorrectionOnly", -1);

   /* decode structuredDataTransfer */

   invokeStartElement (pctxt, "structuredDataTransfer", -1);

   stat = DECODEBIT (pctxt, &pvalue->structuredDataTransfer);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->structuredDataTransfer);

   invokeEndElement (pctxt, "structuredDataTransfer", -1);

   /* decode partiallyFilledCells */

   invokeStartElement (pctxt, "partiallyFilledCells", -1);

   stat = DECODEBIT (pctxt, &pvalue->partiallyFilledCells);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->partiallyFilledCells);

   invokeEndElement (pctxt, "partiallyFilledCells", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VCCapability (OOCTXT* pctxt, H245VCCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.aal1Present = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.aal5Present = optbit;

   /* decode aal1 */

   if (pvalue->m.aal1Present) {
      invokeStartElement (pctxt, "aal1", -1);

      stat = asn1PD_H245VCCapability_aal1 (pctxt, &pvalue->aal1);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "aal1", -1);
   }

   /* decode aal5 */

   if (pvalue->m.aal5Present) {
      invokeStartElement (pctxt, "aal5", -1);

      stat = asn1PD_H245VCCapability_aal5 (pctxt, &pvalue->aal5);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "aal5", -1);
   }

   /* decode transportStream */

   invokeStartElement (pctxt, "transportStream", -1);

   stat = DECODEBIT (pctxt, &pvalue->transportStream);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->transportStream);

   invokeEndElement (pctxt, "transportStream", -1);

   /* decode programStream */

   invokeStartElement (pctxt, "programStream", -1);

   stat = DECODEBIT (pctxt, &pvalue->programStream);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->programStream);

   invokeEndElement (pctxt, "programStream", -1);

   /* decode availableBitRates */

   invokeStartElement (pctxt, "availableBitRates", -1);

   stat = asn1PD_H245VCCapability_availableBitRates (pctxt, &pvalue->availableBitRates);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "availableBitRates", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.aal1ViaGatewayPresent = 1;

                     invokeStartElement (pctxt, "aal1ViaGateway", -1);

                     stat = asn1PD_H245VCCapability_aal1ViaGateway (pctxt, &pvalue->aal1ViaGateway);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "aal1ViaGateway", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SetOfH245VCCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SetOfH245VCCapability (OOCTXT* pctxt, H245_SetOfH245VCCapability* pvalue)
{
   int stat = ASN_OK;
   H245VCCapability* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;
   int lstat;

   dListInit (pvalue);

   for (;;) {
      /* decode length determinant */

      lstat = decodeLength (pctxt, &count);
      if (lstat != ASN_OK && lstat != ASN_OK_FRAG) {
         return lstat;
      }

      /* decode elements */

      for (xx1 = 0; xx1 < count; xx1++) {
         invokeStartElement (pctxt, "elem", xx1);

         pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245VCCapability);

         stat = asn1PD_H245VCCapability (pctxt, pdata);
         if (stat != ASN_OK) return stat;
         invokeEndElement (pctxt, "elem", xx1);

         dListAppendNode (pctxt, pvalue, pdata);
      }

      if(lstat == ASN_OK) break;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H222Capability                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H222Capability (OOCTXT* pctxt, H245H222Capability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode numberOfVCs */

   invokeStartElement (pctxt, "numberOfVCs", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->numberOfVCs, 1U, 256U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->numberOfVCs);

   invokeEndElement (pctxt, "numberOfVCs", -1);

   /* decode vcCapability */

   invokeStartElement (pctxt, "vcCapability", -1);

   stat = asn1PD_H245_SetOfH245VCCapability (pctxt, &pvalue->vcCapability);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "vcCapability", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223Capability_h223MultiplexTableCapability_enhanced      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223Capability_h223MultiplexTableCapability_enhanced (OOCTXT* pctxt, H245H223Capability_h223MultiplexTableCapability_enhanced* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode maximumNestingDepth */

   invokeStartElement (pctxt, "maximumNestingDepth", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->maximumNestingDepth, 1U, 15U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumNestingDepth);

   invokeEndElement (pctxt, "maximumNestingDepth", -1);

   /* decode maximumElementListSize */

   invokeStartElement (pctxt, "maximumElementListSize", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->maximumElementListSize, 2U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumElementListSize);

   invokeEndElement (pctxt, "maximumElementListSize", -1);

   /* decode maximumSubElementListSize */

   invokeStartElement (pctxt, "maximumSubElementListSize", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->maximumSubElementListSize, 2U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumSubElementListSize);

   invokeEndElement (pctxt, "maximumSubElementListSize", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223Capability_h223MultiplexTableCapability               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223Capability_h223MultiplexTableCapability (OOCTXT* pctxt, H245H223Capability_h223MultiplexTableCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* basic */
      case 0:
         invokeStartElement (pctxt, "basic", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "basic", -1);

         break;

      /* enhanced */
      case 1:
         invokeStartElement (pctxt, "enhanced", -1);

         pvalue->u.enhanced = ALLOC_ASN1ELEM (pctxt, H245H223Capability_h223MultiplexTableCapability_enhanced);

         stat = asn1PD_H245H223Capability_h223MultiplexTableCapability_enhanced (pctxt, pvalue->u.enhanced);
         if (stat != ASN_OK) return stat;

         invokeEndElement (pctxt, "enhanced", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223Capability_mobileOperationTransmitCapability          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223Capability_mobileOperationTransmitCapability (OOCTXT* pctxt, H245H223Capability_mobileOperationTransmitCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode modeChangeCapability */

   invokeStartElement (pctxt, "modeChangeCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->modeChangeCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->modeChangeCapability);

   invokeEndElement (pctxt, "modeChangeCapability", -1);

   /* decode h223AnnexA */

   invokeStartElement (pctxt, "h223AnnexA", -1);

   stat = DECODEBIT (pctxt, &pvalue->h223AnnexA);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->h223AnnexA);

   invokeEndElement (pctxt, "h223AnnexA", -1);

   /* decode h223AnnexADoubleFlag */

   invokeStartElement (pctxt, "h223AnnexADoubleFlag", -1);

   stat = DECODEBIT (pctxt, &pvalue->h223AnnexADoubleFlag);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->h223AnnexADoubleFlag);

   invokeEndElement (pctxt, "h223AnnexADoubleFlag", -1);

   /* decode h223AnnexB */

   invokeStartElement (pctxt, "h223AnnexB", -1);

   stat = DECODEBIT (pctxt, &pvalue->h223AnnexB);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->h223AnnexB);

   invokeEndElement (pctxt, "h223AnnexB", -1);

   /* decode h223AnnexBwithHeader */

   invokeStartElement (pctxt, "h223AnnexBwithHeader", -1);

   stat = DECODEBIT (pctxt, &pvalue->h223AnnexBwithHeader);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->h223AnnexBwithHeader);

   invokeEndElement (pctxt, "h223AnnexBwithHeader", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AnnexCCapability                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AnnexCCapability (OOCTXT* pctxt, H245H223AnnexCCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode videoWithAL1M */

   invokeStartElement (pctxt, "videoWithAL1M", -1);

   stat = DECODEBIT (pctxt, &pvalue->videoWithAL1M);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->videoWithAL1M);

   invokeEndElement (pctxt, "videoWithAL1M", -1);

   /* decode videoWithAL2M */

   invokeStartElement (pctxt, "videoWithAL2M", -1);

   stat = DECODEBIT (pctxt, &pvalue->videoWithAL2M);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->videoWithAL2M);

   invokeEndElement (pctxt, "videoWithAL2M", -1);

   /* decode videoWithAL3M */

   invokeStartElement (pctxt, "videoWithAL3M", -1);

   stat = DECODEBIT (pctxt, &pvalue->videoWithAL3M);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->videoWithAL3M);

   invokeEndElement (pctxt, "videoWithAL3M", -1);

   /* decode audioWithAL1M */

   invokeStartElement (pctxt, "audioWithAL1M", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioWithAL1M);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioWithAL1M);

   invokeEndElement (pctxt, "audioWithAL1M", -1);

   /* decode audioWithAL2M */

   invokeStartElement (pctxt, "audioWithAL2M", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioWithAL2M);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioWithAL2M);

   invokeEndElement (pctxt, "audioWithAL2M", -1);

   /* decode audioWithAL3M */

   invokeStartElement (pctxt, "audioWithAL3M", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioWithAL3M);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioWithAL3M);

   invokeEndElement (pctxt, "audioWithAL3M", -1);

   /* decode dataWithAL1M */

   invokeStartElement (pctxt, "dataWithAL1M", -1);

   stat = DECODEBIT (pctxt, &pvalue->dataWithAL1M);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dataWithAL1M);

   invokeEndElement (pctxt, "dataWithAL1M", -1);

   /* decode dataWithAL2M */

   invokeStartElement (pctxt, "dataWithAL2M", -1);

   stat = DECODEBIT (pctxt, &pvalue->dataWithAL2M);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dataWithAL2M);

   invokeEndElement (pctxt, "dataWithAL2M", -1);

   /* decode dataWithAL3M */

   invokeStartElement (pctxt, "dataWithAL3M", -1);

   stat = DECODEBIT (pctxt, &pvalue->dataWithAL3M);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dataWithAL3M);

   invokeEndElement (pctxt, "dataWithAL3M", -1);

   /* decode alpduInterleaving */

   invokeStartElement (pctxt, "alpduInterleaving", -1);

   stat = DECODEBIT (pctxt, &pvalue->alpduInterleaving);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->alpduInterleaving);

   invokeEndElement (pctxt, "alpduInterleaving", -1);

   /* decode maximumAL1MPDUSize */

   invokeStartElement (pctxt, "maximumAL1MPDUSize", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maximumAL1MPDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumAL1MPDUSize);

   invokeEndElement (pctxt, "maximumAL1MPDUSize", -1);

   /* decode maximumAL2MSDUSize */

   invokeStartElement (pctxt, "maximumAL2MSDUSize", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maximumAL2MSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumAL2MSDUSize);

   invokeEndElement (pctxt, "maximumAL2MSDUSize", -1);

   /* decode maximumAL3MSDUSize */

   invokeStartElement (pctxt, "maximumAL3MSDUSize", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maximumAL3MSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumAL3MSDUSize);

   invokeEndElement (pctxt, "maximumAL3MSDUSize", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.rsCodeCapabilityPresent = 1;

                     invokeStartElement (pctxt, "rsCodeCapability", -1);

                     stat = DECODEBIT (pctxt, &pvalue->rsCodeCapability);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->rsCodeCapability);

                     invokeEndElement (pctxt, "rsCodeCapability", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223Capability_mobileMultilinkFrameCapability             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223Capability_mobileMultilinkFrameCapability (OOCTXT* pctxt, H245H223Capability_mobileMultilinkFrameCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode maximumSampleSize */

   invokeStartElement (pctxt, "maximumSampleSize", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->maximumSampleSize, 1U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumSampleSize);

   invokeEndElement (pctxt, "maximumSampleSize", -1);

   /* decode maximumPayloadLength */

   invokeStartElement (pctxt, "maximumPayloadLength", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maximumPayloadLength, 1U, 65025U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumPayloadLength);

   invokeEndElement (pctxt, "maximumPayloadLength", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223Capability                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223Capability (OOCTXT* pctxt, H245H223Capability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode transportWithI_frames */

   invokeStartElement (pctxt, "transportWithI_frames", -1);

   stat = DECODEBIT (pctxt, &pvalue->transportWithI_frames);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->transportWithI_frames);

   invokeEndElement (pctxt, "transportWithI_frames", -1);

   /* decode videoWithAL1 */

   invokeStartElement (pctxt, "videoWithAL1", -1);

   stat = DECODEBIT (pctxt, &pvalue->videoWithAL1);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->videoWithAL1);

   invokeEndElement (pctxt, "videoWithAL1", -1);

   /* decode videoWithAL2 */

   invokeStartElement (pctxt, "videoWithAL2", -1);

   stat = DECODEBIT (pctxt, &pvalue->videoWithAL2);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->videoWithAL2);

   invokeEndElement (pctxt, "videoWithAL2", -1);

   /* decode videoWithAL3 */

   invokeStartElement (pctxt, "videoWithAL3", -1);

   stat = DECODEBIT (pctxt, &pvalue->videoWithAL3);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->videoWithAL3);

   invokeEndElement (pctxt, "videoWithAL3", -1);

   /* decode audioWithAL1 */

   invokeStartElement (pctxt, "audioWithAL1", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioWithAL1);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioWithAL1);

   invokeEndElement (pctxt, "audioWithAL1", -1);

   /* decode audioWithAL2 */

   invokeStartElement (pctxt, "audioWithAL2", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioWithAL2);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioWithAL2);

   invokeEndElement (pctxt, "audioWithAL2", -1);

   /* decode audioWithAL3 */

   invokeStartElement (pctxt, "audioWithAL3", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioWithAL3);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioWithAL3);

   invokeEndElement (pctxt, "audioWithAL3", -1);

   /* decode dataWithAL1 */

   invokeStartElement (pctxt, "dataWithAL1", -1);

   stat = DECODEBIT (pctxt, &pvalue->dataWithAL1);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dataWithAL1);

   invokeEndElement (pctxt, "dataWithAL1", -1);

   /* decode dataWithAL2 */

   invokeStartElement (pctxt, "dataWithAL2", -1);

   stat = DECODEBIT (pctxt, &pvalue->dataWithAL2);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dataWithAL2);

   invokeEndElement (pctxt, "dataWithAL2", -1);

   /* decode dataWithAL3 */

   invokeStartElement (pctxt, "dataWithAL3", -1);

   stat = DECODEBIT (pctxt, &pvalue->dataWithAL3);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dataWithAL3);

   invokeEndElement (pctxt, "dataWithAL3", -1);

   /* decode maximumAl2SDUSize */

   invokeStartElement (pctxt, "maximumAl2SDUSize", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maximumAl2SDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumAl2SDUSize);

   invokeEndElement (pctxt, "maximumAl2SDUSize", -1);

   /* decode maximumAl3SDUSize */

   invokeStartElement (pctxt, "maximumAl3SDUSize", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maximumAl3SDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumAl3SDUSize);

   invokeEndElement (pctxt, "maximumAl3SDUSize", -1);

   /* decode maximumDelayJitter */

   invokeStartElement (pctxt, "maximumDelayJitter", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maximumDelayJitter, 0U, 1023U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumDelayJitter);

   invokeEndElement (pctxt, "maximumDelayJitter", -1);

   /* decode h223MultiplexTableCapability */

   invokeStartElement (pctxt, "h223MultiplexTableCapability", -1);

   stat = asn1PD_H245H223Capability_h223MultiplexTableCapability (pctxt, &pvalue->h223MultiplexTableCapability);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "h223MultiplexTableCapability", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 6 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.maxMUXPDUSizeCapabilityPresent = 1;

                     invokeStartElement (pctxt, "maxMUXPDUSizeCapability", -1);

                     stat = DECODEBIT (pctxt, &pvalue->maxMUXPDUSizeCapability);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->maxMUXPDUSizeCapability);

                     invokeEndElement (pctxt, "maxMUXPDUSizeCapability", -1);
                     break;

                  case 1:
                     pvalue->m.nsrpSupportPresent = 1;

                     invokeStartElement (pctxt, "nsrpSupport", -1);

                     stat = DECODEBIT (pctxt, &pvalue->nsrpSupport);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->nsrpSupport);

                     invokeEndElement (pctxt, "nsrpSupport", -1);
                     break;

                  case 2:
                     pvalue->m.mobileOperationTransmitCapabilityPresent = 1;

                     invokeStartElement (pctxt, "mobileOperationTransmitCapability", -1);

                     stat = asn1PD_H245H223Capability_mobileOperationTransmitCapability (pctxt, &pvalue->mobileOperationTransmitCapability);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "mobileOperationTransmitCapability", -1);
                     break;

                  case 3:
                     pvalue->m.h223AnnexCCapabilityPresent = 1;

                     invokeStartElement (pctxt, "h223AnnexCCapability", -1);

                     stat = asn1PD_H245H223AnnexCCapability (pctxt, &pvalue->h223AnnexCCapability);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "h223AnnexCCapability", -1);
                     break;

                  case 4:
                     pvalue->m.bitRatePresent = 1;

                     invokeStartElement (pctxt, "bitRate", -1);

                     stat = decodeConsUInt16 (pctxt, &pvalue->bitRate, 1U, 19200U);
                     if (stat != ASN_OK) return stat;
                     invokeUIntValue (pctxt, pvalue->bitRate);

                     invokeEndElement (pctxt, "bitRate", -1);
                     break;

                  case 5:
                     pvalue->m.mobileMultilinkFrameCapabilityPresent = 1;

                     invokeStartElement (pctxt, "mobileMultilinkFrameCapability", -1);

                     stat = asn1PD_H245H223Capability_mobileMultilinkFrameCapability (pctxt, &pvalue->mobileMultilinkFrameCapability);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "mobileMultilinkFrameCapability", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V75Capability                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245V75Capability (OOCTXT* pctxt, H245V75Capability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode audioHeader */

   invokeStartElement (pctxt, "audioHeader", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioHeader);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioHeader);

   invokeEndElement (pctxt, "audioHeader", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76Capability                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245V76Capability (OOCTXT* pctxt, H245V76Capability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode suspendResumeCapabilitywAddress */

   invokeStartElement (pctxt, "suspendResumeCapabilitywAddress", -1);

   stat = DECODEBIT (pctxt, &pvalue->suspendResumeCapabilitywAddress);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->suspendResumeCapabilitywAddress);

   invokeEndElement (pctxt, "suspendResumeCapabilitywAddress", -1);

   /* decode suspendResumeCapabilitywoAddress */

   invokeStartElement (pctxt, "suspendResumeCapabilitywoAddress", -1);

   stat = DECODEBIT (pctxt, &pvalue->suspendResumeCapabilitywoAddress);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->suspendResumeCapabilitywoAddress);

   invokeEndElement (pctxt, "suspendResumeCapabilitywoAddress", -1);

   /* decode rejCapability */

   invokeStartElement (pctxt, "rejCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->rejCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->rejCapability);

   invokeEndElement (pctxt, "rejCapability", -1);

   /* decode sREJCapability */

   invokeStartElement (pctxt, "sREJCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->sREJCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->sREJCapability);

   invokeEndElement (pctxt, "sREJCapability", -1);

   /* decode mREJCapability */

   invokeStartElement (pctxt, "mREJCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->mREJCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->mREJCapability);

   invokeEndElement (pctxt, "mREJCapability", -1);

   /* decode crc8bitCapability */

   invokeStartElement (pctxt, "crc8bitCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->crc8bitCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->crc8bitCapability);

   invokeEndElement (pctxt, "crc8bitCapability", -1);

   /* decode crc16bitCapability */

   invokeStartElement (pctxt, "crc16bitCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->crc16bitCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->crc16bitCapability);

   invokeEndElement (pctxt, "crc16bitCapability", -1);

   /* decode crc32bitCapability */

   invokeStartElement (pctxt, "crc32bitCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->crc32bitCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->crc32bitCapability);

   invokeEndElement (pctxt, "crc32bitCapability", -1);

   /* decode uihCapability */

   invokeStartElement (pctxt, "uihCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->uihCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->uihCapability);

   invokeEndElement (pctxt, "uihCapability", -1);

   /* decode numOfDLCS */

   invokeStartElement (pctxt, "numOfDLCS", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->numOfDLCS, 2U, 8191U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->numOfDLCS);

   invokeEndElement (pctxt, "numOfDLCS", -1);

   /* decode twoOctetAddressFieldCapability */

   invokeStartElement (pctxt, "twoOctetAddressFieldCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->twoOctetAddressFieldCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->twoOctetAddressFieldCapability);

   invokeEndElement (pctxt, "twoOctetAddressFieldCapability", -1);

   /* decode loopBackTestCapability */

   invokeStartElement (pctxt, "loopBackTestCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->loopBackTestCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->loopBackTestCapability);

   invokeEndElement (pctxt, "loopBackTestCapability", -1);

   /* decode n401Capability */

   invokeStartElement (pctxt, "n401Capability", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->n401Capability, 1U, 4095U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->n401Capability);

   invokeEndElement (pctxt, "n401Capability", -1);

   /* decode maxWindowSizeCapability */

   invokeStartElement (pctxt, "maxWindowSizeCapability", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->maxWindowSizeCapability, 1U, 127U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxWindowSizeCapability);

   invokeEndElement (pctxt, "maxWindowSizeCapability", -1);

   /* decode v75Capability */

   invokeStartElement (pctxt, "v75Capability", -1);

   stat = asn1PD_H245V75Capability (pctxt, &pvalue->v75Capability);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "v75Capability", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T84Profile_t84Restricted                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245T84Profile_t84Restricted (OOCTXT* pctxt, H245T84Profile_t84Restricted* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode qcif */

   invokeStartElement (pctxt, "qcif", -1);

   stat = DECODEBIT (pctxt, &pvalue->qcif);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->qcif);

   invokeEndElement (pctxt, "qcif", -1);

   /* decode cif */

   invokeStartElement (pctxt, "cif", -1);

   stat = DECODEBIT (pctxt, &pvalue->cif);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->cif);

   invokeEndElement (pctxt, "cif", -1);

   /* decode ccir601Seq */

   invokeStartElement (pctxt, "ccir601Seq", -1);

   stat = DECODEBIT (pctxt, &pvalue->ccir601Seq);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->ccir601Seq);

   invokeEndElement (pctxt, "ccir601Seq", -1);

   /* decode ccir601Prog */

   invokeStartElement (pctxt, "ccir601Prog", -1);

   stat = DECODEBIT (pctxt, &pvalue->ccir601Prog);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->ccir601Prog);

   invokeEndElement (pctxt, "ccir601Prog", -1);

   /* decode hdtvSeq */

   invokeStartElement (pctxt, "hdtvSeq", -1);

   stat = DECODEBIT (pctxt, &pvalue->hdtvSeq);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->hdtvSeq);

   invokeEndElement (pctxt, "hdtvSeq", -1);

   /* decode hdtvProg */

   invokeStartElement (pctxt, "hdtvProg", -1);

   stat = DECODEBIT (pctxt, &pvalue->hdtvProg);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->hdtvProg);

   invokeEndElement (pctxt, "hdtvProg", -1);

   /* decode g3FacsMH200x100 */

   invokeStartElement (pctxt, "g3FacsMH200x100", -1);

   stat = DECODEBIT (pctxt, &pvalue->g3FacsMH200x100);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->g3FacsMH200x100);

   invokeEndElement (pctxt, "g3FacsMH200x100", -1);

   /* decode g3FacsMH200x200 */

   invokeStartElement (pctxt, "g3FacsMH200x200", -1);

   stat = DECODEBIT (pctxt, &pvalue->g3FacsMH200x200);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->g3FacsMH200x200);

   invokeEndElement (pctxt, "g3FacsMH200x200", -1);

   /* decode g4FacsMMR200x100 */

   invokeStartElement (pctxt, "g4FacsMMR200x100", -1);

   stat = DECODEBIT (pctxt, &pvalue->g4FacsMMR200x100);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->g4FacsMMR200x100);

   invokeEndElement (pctxt, "g4FacsMMR200x100", -1);

   /* decode g4FacsMMR200x200 */

   invokeStartElement (pctxt, "g4FacsMMR200x200", -1);

   stat = DECODEBIT (pctxt, &pvalue->g4FacsMMR200x200);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->g4FacsMMR200x200);

   invokeEndElement (pctxt, "g4FacsMMR200x200", -1);

   /* decode jbig200x200Seq */

   invokeStartElement (pctxt, "jbig200x200Seq", -1);

   stat = DECODEBIT (pctxt, &pvalue->jbig200x200Seq);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->jbig200x200Seq);

   invokeEndElement (pctxt, "jbig200x200Seq", -1);

   /* decode jbig200x200Prog */

   invokeStartElement (pctxt, "jbig200x200Prog", -1);

   stat = DECODEBIT (pctxt, &pvalue->jbig200x200Prog);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->jbig200x200Prog);

   invokeEndElement (pctxt, "jbig200x200Prog", -1);

   /* decode jbig300x300Seq */

   invokeStartElement (pctxt, "jbig300x300Seq", -1);

   stat = DECODEBIT (pctxt, &pvalue->jbig300x300Seq);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->jbig300x300Seq);

   invokeEndElement (pctxt, "jbig300x300Seq", -1);

   /* decode jbig300x300Prog */

   invokeStartElement (pctxt, "jbig300x300Prog", -1);

   stat = DECODEBIT (pctxt, &pvalue->jbig300x300Prog);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->jbig300x300Prog);

   invokeEndElement (pctxt, "jbig300x300Prog", -1);

   /* decode digPhotoLow */

   invokeStartElement (pctxt, "digPhotoLow", -1);

   stat = DECODEBIT (pctxt, &pvalue->digPhotoLow);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->digPhotoLow);

   invokeEndElement (pctxt, "digPhotoLow", -1);

   /* decode digPhotoMedSeq */

   invokeStartElement (pctxt, "digPhotoMedSeq", -1);

   stat = DECODEBIT (pctxt, &pvalue->digPhotoMedSeq);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->digPhotoMedSeq);

   invokeEndElement (pctxt, "digPhotoMedSeq", -1);

   /* decode digPhotoMedProg */

   invokeStartElement (pctxt, "digPhotoMedProg", -1);

   stat = DECODEBIT (pctxt, &pvalue->digPhotoMedProg);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->digPhotoMedProg);

   invokeEndElement (pctxt, "digPhotoMedProg", -1);

   /* decode digPhotoHighSeq */

   invokeStartElement (pctxt, "digPhotoHighSeq", -1);

   stat = DECODEBIT (pctxt, &pvalue->digPhotoHighSeq);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->digPhotoHighSeq);

   invokeEndElement (pctxt, "digPhotoHighSeq", -1);

   /* decode digPhotoHighProg */

   invokeStartElement (pctxt, "digPhotoHighProg", -1);

   stat = DECODEBIT (pctxt, &pvalue->digPhotoHighProg);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->digPhotoHighProg);

   invokeEndElement (pctxt, "digPhotoHighProg", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T84Profile                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245T84Profile (OOCTXT* pctxt, H245T84Profile* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* t84Unrestricted */
      case 0:
         invokeStartElement (pctxt, "t84Unrestricted", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "t84Unrestricted", -1);

         break;

      /* t84Restricted */
      case 1:
         invokeStartElement (pctxt, "t84Restricted", -1);

         pvalue->u.t84Restricted = ALLOC_ASN1ELEM (pctxt, H245T84Profile_t84Restricted);

         stat = asn1PD_H245T84Profile_t84Restricted (pctxt, pvalue->u.t84Restricted);
         if (stat != ASN_OK) return stat;

         invokeEndElement (pctxt, "t84Restricted", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataApplicationCapability_application_t84                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataApplicationCapability_application_t84 (OOCTXT* pctxt, H245DataApplicationCapability_application_t84* pvalue)
{
   int stat = ASN_OK;

   /* decode t84Protocol */

   invokeStartElement (pctxt, "t84Protocol", -1);

   stat = asn1PD_H245DataProtocolCapability (pctxt, &pvalue->t84Protocol);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "t84Protocol", -1);

   /* decode t84Profile */

   invokeStartElement (pctxt, "t84Profile", -1);

   stat = asn1PD_H245T84Profile (pctxt, &pvalue->t84Profile);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "t84Profile", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataApplicationCapability_application_nlpid               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataApplicationCapability_application_nlpid (OOCTXT* pctxt, H245DataApplicationCapability_application_nlpid* pvalue)
{
   int stat = ASN_OK;

   /* decode nlpidProtocol */

   invokeStartElement (pctxt, "nlpidProtocol", -1);

   stat = asn1PD_H245DataProtocolCapability (pctxt, &pvalue->nlpidProtocol);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "nlpidProtocol", -1);

   /* decode nlpidData */

   invokeStartElement (pctxt, "nlpidData", -1);

   stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->nlpidData);
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->nlpidData.numocts, pvalue->nlpidData.data);

   invokeEndElement (pctxt, "nlpidData", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataApplicationCapability_application_t38fax              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataApplicationCapability_application_t38fax (OOCTXT* pctxt, H245DataApplicationCapability_application_t38fax* pvalue)
{
   int stat = ASN_OK;

   /* decode t38FaxProtocol */

   invokeStartElement (pctxt, "t38FaxProtocol", -1);

   stat = asn1PD_H245DataProtocolCapability (pctxt, &pvalue->t38FaxProtocol);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "t38FaxProtocol", -1);

   /* decode t38FaxProfile */

   invokeStartElement (pctxt, "t38FaxProfile", -1);

   stat = asn1PD_H245T38FaxProfile (pctxt, &pvalue->t38FaxProfile);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "t38FaxProfile", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityIdentifier_uuid                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CapabilityIdentifier_uuid (OOCTXT* pctxt, H245CapabilityIdentifier_uuid* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityIdentifier                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CapabilityIdentifier (OOCTXT* pctxt, H245CapabilityIdentifier* pvalue)
{
   static Asn1SizeCnst domainBased_lsize1 = { 0, 1, 64, 0 };
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* standard */
         case 0:
            invokeStartElement (pctxt, "standard", -1);

            pvalue->u.standard = ALLOC_ASN1ELEM (pctxt, ASN1OBJID);

            stat = decodeObjectIdentifier (pctxt, pvalue->u.standard);
            if (stat != ASN_OK) return stat;
            invokeOidValue (pctxt, pvalue->u.standard->numids, pvalue->u.standard->subid);

            invokeEndElement (pctxt, "standard", -1);

            break;

         /* h221NonStandard */
         case 1:
            invokeStartElement (pctxt, "h221NonStandard", -1);

            pvalue->u.h221NonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.h221NonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h221NonStandard", -1);

            break;

         /* uuid */
         case 2:
            invokeStartElement (pctxt, "uuid", -1);

            pvalue->u.uuid = ALLOC_ASN1ELEM (pctxt, H245CapabilityIdentifier_uuid);

            stat = asn1PD_H245CapabilityIdentifier_uuid (pctxt, pvalue->u.uuid);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "uuid", -1);

            break;

         /* domainBased */
         case 3:
            invokeStartElement (pctxt, "domainBased", -1);

            addSizeConstraint (pctxt, &domainBased_lsize1);

            stat = decodeConstrainedStringEx (pctxt, &pvalue->u.domainBased, 0, 8, 7, 7);
            if (stat != ASN_OK) return stat;
            invokeCharStrValue (pctxt, pvalue->u.domainBased);

            invokeEndElement (pctxt, "domainBased", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 5;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ParameterIdentifier_uuid                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ParameterIdentifier_uuid (OOCTXT* pctxt, H245ParameterIdentifier_uuid* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ParameterIdentifier                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ParameterIdentifier (OOCTXT* pctxt, H245ParameterIdentifier* pvalue)
{
   static Asn1SizeCnst domainBased_lsize1 = { 0, 1, 64, 0 };
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* standard */
         case 0:
            invokeStartElement (pctxt, "standard", -1);

            stat = decodeConsUInt8 (pctxt, &pvalue->u.standard, 0U, 127U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.standard);

            invokeEndElement (pctxt, "standard", -1);

            break;

         /* h221NonStandard */
         case 1:
            invokeStartElement (pctxt, "h221NonStandard", -1);

            pvalue->u.h221NonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.h221NonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h221NonStandard", -1);

            break;

         /* uuid */
         case 2:
            invokeStartElement (pctxt, "uuid", -1);

            pvalue->u.uuid = ALLOC_ASN1ELEM (pctxt, H245ParameterIdentifier_uuid);

            stat = asn1PD_H245ParameterIdentifier_uuid (pctxt, pvalue->u.uuid);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "uuid", -1);

            break;

         /* domainBased */
         case 3:
            invokeStartElement (pctxt, "domainBased", -1);

            addSizeConstraint (pctxt, &domainBased_lsize1);

            stat = decodeConstrainedStringEx (pctxt, &pvalue->u.domainBased, 0, 8, 7, 7);
            if (stat != ASN_OK) return stat;
            invokeCharStrValue (pctxt, pvalue->u.domainBased);

            invokeEndElement (pctxt, "domainBased", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 5;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ParameterValue                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ParameterValue (OOCTXT* pctxt, H245ParameterValue* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 7);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* logical */
         case 0:
            invokeStartElement (pctxt, "logical", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "logical", -1);

            break;

         /* booleanArray */
         case 1:
            invokeStartElement (pctxt, "booleanArray", -1);

            stat = decodeConsUInt8 (pctxt, &pvalue->u.booleanArray, 0U, 255U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.booleanArray);

            invokeEndElement (pctxt, "booleanArray", -1);

            break;

         /* unsignedMin */
         case 2:
            invokeStartElement (pctxt, "unsignedMin", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.unsignedMin, 0U, 65535U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.unsignedMin);

            invokeEndElement (pctxt, "unsignedMin", -1);

            break;

         /* unsignedMax */
         case 3:
            invokeStartElement (pctxt, "unsignedMax", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.unsignedMax, 0U, 65535U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.unsignedMax);

            invokeEndElement (pctxt, "unsignedMax", -1);

            break;

         /* unsigned32Min */
         case 4:
            invokeStartElement (pctxt, "unsigned32Min", -1);

            stat = decodeConsUnsigned (pctxt, &pvalue->u.unsigned32Min, 0U, ASN1UINT_MAX);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.unsigned32Min);

            invokeEndElement (pctxt, "unsigned32Min", -1);

            break;

         /* unsigned32Max */
         case 5:
            invokeStartElement (pctxt, "unsigned32Max", -1);

            stat = decodeConsUnsigned (pctxt, &pvalue->u.unsigned32Max, 0U, ASN1UINT_MAX);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.unsigned32Max);

            invokeEndElement (pctxt, "unsigned32Max", -1);

            break;

         /* octetString */
         case 6:
            invokeStartElement (pctxt, "octetString", -1);

            pvalue->u.octetString = ALLOC_ASN1ELEM (pctxt, ASN1DynOctStr);

            stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)pvalue->u.octetString);
            if (stat != ASN_OK) return stat;
            invokeOctStrValue (pctxt, pvalue->u.octetString->numocts, pvalue->u.octetString->data);

            invokeEndElement (pctxt, "octetString", -1);

            break;

         /* genericParameter */
         case 7:
            invokeStartElement (pctxt, "genericParameter", -1);

            pvalue->u.genericParameter = ALLOC_ASN1ELEM (pctxt, H245_SeqOfH245GenericParameter);

            stat = asn1PD_H245_SeqOfH245GenericParameter (pctxt, (H245_SeqOfH245GenericParameter*)pvalue->u.genericParameter);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "genericParameter", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 9;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245ParameterIdentifier                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SeqOfH245ParameterIdentifier (OOCTXT* pctxt, H245_SeqOfH245ParameterIdentifier* pvalue)
{
   int stat = ASN_OK;
   H245ParameterIdentifier* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;
   int lstat;

   dListInit (pvalue);

   for (;;) {
      /* decode length determinant */

      lstat = decodeLength (pctxt, &count);
      if (lstat != ASN_OK && lstat != ASN_OK_FRAG) {
         return lstat;
      }

      /* decode elements */

      for (xx1 = 0; xx1 < count; xx1++) {
         invokeStartElement (pctxt, "elem", xx1);

         pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245ParameterIdentifier);

         stat = asn1PD_H245ParameterIdentifier (pctxt, pdata);
         if (stat != ASN_OK) return stat;
         invokeEndElement (pctxt, "elem", xx1);

         dListAppendNode (pctxt, pvalue, pdata);
      }

      if(lstat == ASN_OK) break;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GenericParameter                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245GenericParameter (OOCTXT* pctxt, H245GenericParameter* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.supersedesPresent = optbit;

   /* decode parameterIdentifier */

   invokeStartElement (pctxt, "parameterIdentifier", -1);

   stat = asn1PD_H245ParameterIdentifier (pctxt, &pvalue->parameterIdentifier);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "parameterIdentifier", -1);

   /* decode parameterValue */

   invokeStartElement (pctxt, "parameterValue", -1);

   stat = asn1PD_H245ParameterValue (pctxt, &pvalue->parameterValue);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "parameterValue", -1);

   /* decode supersedes */

   if (pvalue->m.supersedesPresent) {
      invokeStartElement (pctxt, "supersedes", -1);

      stat = asn1PD_H245_SeqOfH245ParameterIdentifier (pctxt, &pvalue->supersedes);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "supersedes", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245GenericParameter                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SeqOfH245GenericParameter (OOCTXT* pctxt, H245_SeqOfH245GenericParameter* pvalue)
{
   int stat = ASN_OK;
   H245GenericParameter* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;
   int lstat;

   dListInit (pvalue);

   for (;;) {
      /* decode length determinant */

      lstat = decodeLength (pctxt, &count);
      if (lstat != ASN_OK && lstat != ASN_OK_FRAG) {
         return lstat;
      }

      /* decode elements */

      for (xx1 = 0; xx1 < count; xx1++) {
         invokeStartElement (pctxt, "elem", xx1);

         pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245GenericParameter);

         stat = asn1PD_H245GenericParameter (pctxt, pdata);
         if (stat != ASN_OK) return stat;
         invokeEndElement (pctxt, "elem", xx1);

         dListAppendNode (pctxt, pvalue, pdata);
      }

      if(lstat == ASN_OK) break;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GenericCapability                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245GenericCapability (OOCTXT* pctxt, H245GenericCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.maxBitRatePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.collapsingPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonCollapsingPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonCollapsingRawPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.transportPresent = optbit;

   /* decode capabilityIdentifier */

   invokeStartElement (pctxt, "capabilityIdentifier", -1);

   stat = asn1PD_H245CapabilityIdentifier (pctxt, &pvalue->capabilityIdentifier);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "capabilityIdentifier", -1);

   /* decode maxBitRate */

   if (pvalue->m.maxBitRatePresent) {
      invokeStartElement (pctxt, "maxBitRate", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->maxBitRate, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->maxBitRate);

      invokeEndElement (pctxt, "maxBitRate", -1);
   }

   /* decode collapsing */

   if (pvalue->m.collapsingPresent) {
      invokeStartElement (pctxt, "collapsing", -1);

      stat = asn1PD_H245_SeqOfH245GenericParameter (pctxt, &pvalue->collapsing);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "collapsing", -1);
   }

   /* decode nonCollapsing */

   if (pvalue->m.nonCollapsingPresent) {
      invokeStartElement (pctxt, "nonCollapsing", -1);

      stat = asn1PD_H245_SeqOfH245GenericParameter (pctxt, &pvalue->nonCollapsing);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "nonCollapsing", -1);
   }

   /* decode nonCollapsingRaw */

   if (pvalue->m.nonCollapsingRawPresent) {
      invokeStartElement (pctxt, "nonCollapsingRaw", -1);

      stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->nonCollapsingRaw);
      if (stat != ASN_OK) return stat;
      invokeOctStrValue (pctxt, pvalue->nonCollapsingRaw.numocts, pvalue->nonCollapsingRaw.data);

      invokeEndElement (pctxt, "nonCollapsingRaw", -1);
   }

   /* decode transport */

   if (pvalue->m.transportPresent) {
      invokeStartElement (pctxt, "transport", -1);

      stat = asn1PD_H245DataProtocolCapability (pctxt, &pvalue->transport);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "transport", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataApplicationCapability_application                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataApplicationCapability_application (OOCTXT* pctxt, H245DataApplicationCapability_application* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 9);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* t120 */
         case 1:
            invokeStartElement (pctxt, "t120", -1);

            pvalue->u.t120 = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.t120);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t120", -1);

            break;

         /* dsm_cc */
         case 2:
            invokeStartElement (pctxt, "dsm_cc", -1);

            pvalue->u.dsm_cc = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.dsm_cc);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "dsm_cc", -1);

            break;

         /* userData */
         case 3:
            invokeStartElement (pctxt, "userData", -1);

            pvalue->u.userData = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.userData);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "userData", -1);

            break;

         /* t84 */
         case 4:
            invokeStartElement (pctxt, "t84", -1);

            pvalue->u.t84 = ALLOC_ASN1ELEM (pctxt, H245DataApplicationCapability_application_t84);

            stat = asn1PD_H245DataApplicationCapability_application_t84 (pctxt, pvalue->u.t84);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t84", -1);

            break;

         /* t434 */
         case 5:
            invokeStartElement (pctxt, "t434", -1);

            pvalue->u.t434 = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.t434);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t434", -1);

            break;

         /* h224 */
         case 6:
            invokeStartElement (pctxt, "h224", -1);

            pvalue->u.h224 = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.h224);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h224", -1);

            break;

         /* nlpid */
         case 7:
            invokeStartElement (pctxt, "nlpid", -1);

            pvalue->u.nlpid = ALLOC_ASN1ELEM (pctxt, H245DataApplicationCapability_application_nlpid);

            stat = asn1PD_H245DataApplicationCapability_application_nlpid (pctxt, pvalue->u.nlpid);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nlpid", -1);

            break;

         /* dsvdControl */
         case 8:
            invokeStartElement (pctxt, "dsvdControl", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "dsvdControl", -1);

            break;

         /* h222DataPartitioning */
         case 9:
            invokeStartElement (pctxt, "h222DataPartitioning", -1);

            pvalue->u.h222DataPartitioning = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.h222DataPartitioning);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h222DataPartitioning", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 11;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* t30fax */
         case 11:
            invokeStartElement (pctxt, "t30fax", -1);

            pvalue->u.t30fax = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.t30fax);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t30fax", -1);

            break;

         /* t140 */
         case 12:
            invokeStartElement (pctxt, "t140", -1);

            pvalue->u.t140 = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.t140);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t140", -1);

            break;

         /* t38fax */
         case 13:
            invokeStartElement (pctxt, "t38fax", -1);

            pvalue->u.t38fax = ALLOC_ASN1ELEM (pctxt, H245DataApplicationCapability_application_t38fax);

            stat = asn1PD_H245DataApplicationCapability_application_t38fax (pctxt, pvalue->u.t38fax);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t38fax", -1);

            break;

         /* genericDataCapability */
         case 14:
            invokeStartElement (pctxt, "genericDataCapability", -1);

            pvalue->u.genericDataCapability = ALLOC_ASN1ELEM (pctxt, H245GenericCapability);

            stat = asn1PD_H245GenericCapability (pctxt, pvalue->u.genericDataCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "genericDataCapability", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataApplicationCapability                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataApplicationCapability (OOCTXT* pctxt, H245DataApplicationCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode application */

   invokeStartElement (pctxt, "application", -1);

   stat = asn1PD_H245DataApplicationCapability_application (pctxt, &pvalue->application);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "application", -1);

   /* decode maxBitRate */

   invokeStartElement (pctxt, "maxBitRate", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->maxBitRate, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxBitRate);

   invokeEndElement (pctxt, "maxBitRate", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245DataApplicationCapability                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SeqOfH245DataApplicationCapability (OOCTXT* pctxt, H245_SeqOfH245DataApplicationCapability* pvalue)
{
   int stat = ASN_OK;
   H245DataApplicationCapability* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;
   int lstat;

   dListInit (pvalue);

   for (;;) {
      /* decode length determinant */

      lstat = decodeLength (pctxt, &count);
      if (lstat != ASN_OK && lstat != ASN_OK_FRAG) {
         return lstat;
      }

      /* decode elements */

      for (xx1 = 0; xx1 < count; xx1++) {
         invokeStartElement (pctxt, "elem", xx1);

         pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245DataApplicationCapability);

         stat = asn1PD_H245DataApplicationCapability (pctxt, pdata);
         if (stat != ASN_OK) return stat;
         invokeEndElement (pctxt, "elem", xx1);

         dListAppendNode (pctxt, pvalue, pdata);
      }

      if(lstat == ASN_OK) break;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaDistributionCapability                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MediaDistributionCapability (OOCTXT* pctxt, H245MediaDistributionCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.centralizedDataPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.distributedDataPresent = optbit;

   /* decode centralizedControl */

   invokeStartElement (pctxt, "centralizedControl", -1);

   stat = DECODEBIT (pctxt, &pvalue->centralizedControl);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->centralizedControl);

   invokeEndElement (pctxt, "centralizedControl", -1);

   /* decode distributedControl */

   invokeStartElement (pctxt, "distributedControl", -1);

   stat = DECODEBIT (pctxt, &pvalue->distributedControl);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->distributedControl);

   invokeEndElement (pctxt, "distributedControl", -1);

   /* decode centralizedAudio */

   invokeStartElement (pctxt, "centralizedAudio", -1);

   stat = DECODEBIT (pctxt, &pvalue->centralizedAudio);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->centralizedAudio);

   invokeEndElement (pctxt, "centralizedAudio", -1);

   /* decode distributedAudio */

   invokeStartElement (pctxt, "distributedAudio", -1);

   stat = DECODEBIT (pctxt, &pvalue->distributedAudio);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->distributedAudio);

   invokeEndElement (pctxt, "distributedAudio", -1);

   /* decode centralizedVideo */

   invokeStartElement (pctxt, "centralizedVideo", -1);

   stat = DECODEBIT (pctxt, &pvalue->centralizedVideo);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->centralizedVideo);

   invokeEndElement (pctxt, "centralizedVideo", -1);

   /* decode distributedVideo */

   invokeStartElement (pctxt, "distributedVideo", -1);

   stat = DECODEBIT (pctxt, &pvalue->distributedVideo);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->distributedVideo);

   invokeEndElement (pctxt, "distributedVideo", -1);

   /* decode centralizedData */

   if (pvalue->m.centralizedDataPresent) {
      invokeStartElement (pctxt, "centralizedData", -1);

      stat = asn1PD_H245_SeqOfH245DataApplicationCapability (pctxt, &pvalue->centralizedData);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "centralizedData", -1);
   }

   /* decode distributedData */

   if (pvalue->m.distributedDataPresent) {
      invokeStartElement (pctxt, "distributedData", -1);

      stat = asn1PD_H245_SeqOfH245DataApplicationCapability (pctxt, &pvalue->distributedData);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "distributedData", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245MediaDistributionCapability                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SeqOfH245MediaDistributionCapability (OOCTXT* pctxt, H245_SeqOfH245MediaDistributionCapability* pvalue)
{
   int stat = ASN_OK;
   H245MediaDistributionCapability* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;
   int lstat;

   dListInit (pvalue);

   for (;;) {
      /* decode length determinant */

      lstat = decodeLength (pctxt, &count);
      if (lstat != ASN_OK && lstat != ASN_OK_FRAG) {
         return lstat;
      }

      /* decode elements */

      for (xx1 = 0; xx1 < count; xx1++) {
         invokeStartElement (pctxt, "elem", xx1);

         pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245MediaDistributionCapability);

         stat = asn1PD_H245MediaDistributionCapability (pctxt, pdata);
         if (stat != ASN_OK) return stat;
         invokeEndElement (pctxt, "elem", xx1);

         dListAppendNode (pctxt, pvalue, pdata);
      }

      if(lstat == ASN_OK) break;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultipointCapability                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultipointCapability (OOCTXT* pctxt, H245MultipointCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode multicastCapability */

   invokeStartElement (pctxt, "multicastCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->multicastCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->multicastCapability);

   invokeEndElement (pctxt, "multicastCapability", -1);

   /* decode multiUniCastConference */

   invokeStartElement (pctxt, "multiUniCastConference", -1);

   stat = DECODEBIT (pctxt, &pvalue->multiUniCastConference);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->multiUniCastConference);

   invokeEndElement (pctxt, "multiUniCastConference", -1);

   /* decode mediaDistributionCapability */

   invokeStartElement (pctxt, "mediaDistributionCapability", -1);

   stat = asn1PD_H245_SeqOfH245MediaDistributionCapability (pctxt, &pvalue->mediaDistributionCapability);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "mediaDistributionCapability", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250Capability_mcCapability                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H2250Capability_mcCapability (OOCTXT* pctxt, H245H2250Capability_mcCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode centralizedConferenceMC */

   invokeStartElement (pctxt, "centralizedConferenceMC", -1);

   stat = DECODEBIT (pctxt, &pvalue->centralizedConferenceMC);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->centralizedConferenceMC);

   invokeEndElement (pctxt, "centralizedConferenceMC", -1);

   /* decode decentralizedConferenceMC */

   invokeStartElement (pctxt, "decentralizedConferenceMC", -1);

   stat = DECODEBIT (pctxt, &pvalue->decentralizedConferenceMC);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->decentralizedConferenceMC);

   invokeEndElement (pctxt, "decentralizedConferenceMC", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPPayloadType_payloadDescriptor                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RTPPayloadType_payloadDescriptor (OOCTXT* pctxt, H245RTPPayloadType_payloadDescriptor* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandardIdentifier */
         case 0:
            invokeStartElement (pctxt, "nonStandardIdentifier", -1);

            pvalue->u.nonStandardIdentifier = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandardIdentifier);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandardIdentifier", -1);

            break;

         /* rfc_number */
         case 1:
            invokeStartElement (pctxt, "rfc_number", -1);

            /* extension bit */

            DECODEBIT (pctxt, &extbit);

            if (extbit == 0) {
               stat = decodeConsInteger (pctxt, &pvalue->u.rfc_number, 1, 32768);
               if (stat != ASN_OK) return stat;
            }
            else {
               stat = decodeUnconsInteger (pctxt, &pvalue->u.rfc_number);
               if (stat != ASN_OK) return stat;
            }
            invokeIntValue (pctxt, pvalue->u.rfc_number);

            invokeEndElement (pctxt, "rfc_number", -1);

            break;

         /* oid */
         case 2:
            invokeStartElement (pctxt, "oid", -1);

            pvalue->u.oid = ALLOC_ASN1ELEM (pctxt, ASN1OBJID);

            stat = decodeObjectIdentifier (pctxt, pvalue->u.oid);
            if (stat != ASN_OK) return stat;
            invokeOidValue (pctxt, pvalue->u.oid->numids, pvalue->u.oid->subid);

            invokeEndElement (pctxt, "oid", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPPayloadType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RTPPayloadType (OOCTXT* pctxt, H245RTPPayloadType* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.payloadTypePresent = optbit;

   /* decode payloadDescriptor */

   invokeStartElement (pctxt, "payloadDescriptor", -1);

   stat = asn1PD_H245RTPPayloadType_payloadDescriptor (pctxt, &pvalue->payloadDescriptor);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "payloadDescriptor", -1);

   /* decode payloadType */

   if (pvalue->m.payloadTypePresent) {
      invokeStartElement (pctxt, "payloadType", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->payloadType, 0U, 127U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->payloadType);

      invokeEndElement (pctxt, "payloadType", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaPacketizationCapability_rtpPayloadType               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MediaPacketizationCapability_rtpPayloadType (OOCTXT* pctxt, H245MediaPacketizationCapability_rtpPayloadType* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245RTPPayloadType* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245RTPPayloadType);

      stat = asn1PD_H245RTPPayloadType (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaPacketizationCapability                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MediaPacketizationCapability (OOCTXT* pctxt, H245MediaPacketizationCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode h261aVideoPacketization */

   invokeStartElement (pctxt, "h261aVideoPacketization", -1);

   stat = DECODEBIT (pctxt, &pvalue->h261aVideoPacketization);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->h261aVideoPacketization);

   invokeEndElement (pctxt, "h261aVideoPacketization", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.rtpPayloadTypePresent = 1;

                     invokeStartElement (pctxt, "rtpPayloadType", -1);

                     stat = asn1PD_H245MediaPacketizationCapability_rtpPayloadType (pctxt, &pvalue->rtpPayloadType);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "rtpPayloadType", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  QOSMode                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245QOSMode (OOCTXT* pctxt, H245QOSMode* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* guaranteedQOS */
         case 0:
            invokeStartElement (pctxt, "guaranteedQOS", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "guaranteedQOS", -1);

            break;

         /* controlledLoad */
         case 1:
            invokeStartElement (pctxt, "controlledLoad", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "controlledLoad", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RSVPParameters                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RSVPParameters (OOCTXT* pctxt, H245RSVPParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.qosModePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.tokenRatePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.bucketSizePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.peakRatePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.minPolicedPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.maxPktSizePresent = optbit;

   /* decode qosMode */

   if (pvalue->m.qosModePresent) {
      invokeStartElement (pctxt, "qosMode", -1);

      stat = asn1PD_H245QOSMode (pctxt, &pvalue->qosMode);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "qosMode", -1);
   }

   /* decode tokenRate */

   if (pvalue->m.tokenRatePresent) {
      invokeStartElement (pctxt, "tokenRate", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->tokenRate, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->tokenRate);

      invokeEndElement (pctxt, "tokenRate", -1);
   }

   /* decode bucketSize */

   if (pvalue->m.bucketSizePresent) {
      invokeStartElement (pctxt, "bucketSize", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->bucketSize, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->bucketSize);

      invokeEndElement (pctxt, "bucketSize", -1);
   }

   /* decode peakRate */

   if (pvalue->m.peakRatePresent) {
      invokeStartElement (pctxt, "peakRate", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->peakRate, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->peakRate);

      invokeEndElement (pctxt, "peakRate", -1);
   }

   /* decode minPoliced */

   if (pvalue->m.minPolicedPresent) {
      invokeStartElement (pctxt, "minPoliced", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->minPoliced, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->minPoliced);

      invokeEndElement (pctxt, "minPoliced", -1);
   }

   /* decode maxPktSize */

   if (pvalue->m.maxPktSizePresent) {
      invokeStartElement (pctxt, "maxPktSize", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->maxPktSize, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->maxPktSize);

      invokeEndElement (pctxt, "maxPktSize", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ATMParameters                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ATMParameters (OOCTXT* pctxt, H245ATMParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode maxNTUSize */

   invokeStartElement (pctxt, "maxNTUSize", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maxNTUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxNTUSize);

   invokeEndElement (pctxt, "maxNTUSize", -1);

   /* decode atmUBR */

   invokeStartElement (pctxt, "atmUBR", -1);

   stat = DECODEBIT (pctxt, &pvalue->atmUBR);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->atmUBR);

   invokeEndElement (pctxt, "atmUBR", -1);

   /* decode atmrtVBR */

   invokeStartElement (pctxt, "atmrtVBR", -1);

   stat = DECODEBIT (pctxt, &pvalue->atmrtVBR);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->atmrtVBR);

   invokeEndElement (pctxt, "atmrtVBR", -1);

   /* decode atmnrtVBR */

   invokeStartElement (pctxt, "atmnrtVBR", -1);

   stat = DECODEBIT (pctxt, &pvalue->atmnrtVBR);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->atmnrtVBR);

   invokeEndElement (pctxt, "atmnrtVBR", -1);

   /* decode atmABR */

   invokeStartElement (pctxt, "atmABR", -1);

   stat = DECODEBIT (pctxt, &pvalue->atmABR);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->atmABR);

   invokeEndElement (pctxt, "atmABR", -1);

   /* decode atmCBR */

   invokeStartElement (pctxt, "atmCBR", -1);

   stat = DECODEBIT (pctxt, &pvalue->atmCBR);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->atmCBR);

   invokeEndElement (pctxt, "atmCBR", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  QOSCapability                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245QOSCapability (OOCTXT* pctxt, H245QOSCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonStandardDataPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.rsvpParametersPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.atmParametersPresent = optbit;

   /* decode nonStandardData */

   if (pvalue->m.nonStandardDataPresent) {
      invokeStartElement (pctxt, "nonStandardData", -1);

      stat = asn1PD_H245NonStandardParameter (pctxt, &pvalue->nonStandardData);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "nonStandardData", -1);
   }

   /* decode rsvpParameters */

   if (pvalue->m.rsvpParametersPresent) {
      invokeStartElement (pctxt, "rsvpParameters", -1);

      stat = asn1PD_H245RSVPParameters (pctxt, &pvalue->rsvpParameters);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "rsvpParameters", -1);
   }

   /* decode atmParameters */

   if (pvalue->m.atmParametersPresent) {
      invokeStartElement (pctxt, "atmParameters", -1);

      stat = asn1PD_H245ATMParameters (pctxt, &pvalue->atmParameters);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "atmParameters", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransportCapability_qOSCapabilities                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TransportCapability_qOSCapabilities (OOCTXT* pctxt, H245TransportCapability_qOSCapabilities* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245QOSCapability* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245QOSCapability);

      stat = asn1PD_H245QOSCapability (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaTransportType_atm_AAL5_compressed                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MediaTransportType_atm_AAL5_compressed (OOCTXT* pctxt, H245MediaTransportType_atm_AAL5_compressed* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode variable_delta */

   invokeStartElement (pctxt, "variable_delta", -1);

   stat = DECODEBIT (pctxt, &pvalue->variable_delta);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->variable_delta);

   invokeEndElement (pctxt, "variable_delta", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaTransportType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MediaTransportType (OOCTXT* pctxt, H245MediaTransportType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* ip_UDP */
         case 0:
            invokeStartElement (pctxt, "ip_UDP", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "ip_UDP", -1);

            break;

         /* ip_TCP */
         case 1:
            invokeStartElement (pctxt, "ip_TCP", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "ip_TCP", -1);

            break;

         /* atm_AAL5_UNIDIR */
         case 2:
            invokeStartElement (pctxt, "atm_AAL5_UNIDIR", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "atm_AAL5_UNIDIR", -1);

            break;

         /* atm_AAL5_BIDIR */
         case 3:
            invokeStartElement (pctxt, "atm_AAL5_BIDIR", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "atm_AAL5_BIDIR", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 5;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* atm_AAL5_compressed */
         case 5:
            invokeStartElement (pctxt, "atm_AAL5_compressed", -1);

            pvalue->u.atm_AAL5_compressed = ALLOC_ASN1ELEM (pctxt, H245MediaTransportType_atm_AAL5_compressed);

            stat = asn1PD_H245MediaTransportType_atm_AAL5_compressed (pctxt, pvalue->u.atm_AAL5_compressed);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "atm_AAL5_compressed", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaChannelCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MediaChannelCapability (OOCTXT* pctxt, H245MediaChannelCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaTransportPresent = optbit;

   /* decode mediaTransport */

   if (pvalue->m.mediaTransportPresent) {
      invokeStartElement (pctxt, "mediaTransport", -1);

      stat = asn1PD_H245MediaTransportType (pctxt, &pvalue->mediaTransport);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "mediaTransport", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransportCapability_mediaChannelCapabilities              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TransportCapability_mediaChannelCapabilities (OOCTXT* pctxt, H245TransportCapability_mediaChannelCapabilities* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245MediaChannelCapability* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245MediaChannelCapability);

      stat = asn1PD_H245MediaChannelCapability (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransportCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TransportCapability (OOCTXT* pctxt, H245TransportCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonStandardPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.qOSCapabilitiesPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaChannelCapabilitiesPresent = optbit;

   /* decode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      invokeStartElement (pctxt, "nonStandard", -1);

      stat = asn1PD_H245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "nonStandard", -1);
   }

   /* decode qOSCapabilities */

   if (pvalue->m.qOSCapabilitiesPresent) {
      invokeStartElement (pctxt, "qOSCapabilities", -1);

      stat = asn1PD_H245TransportCapability_qOSCapabilities (pctxt, &pvalue->qOSCapabilities);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "qOSCapabilities", -1);
   }

   /* decode mediaChannelCapabilities */

   if (pvalue->m.mediaChannelCapabilitiesPresent) {
      invokeStartElement (pctxt, "mediaChannelCapabilities", -1);

      stat = asn1PD_H245TransportCapability_mediaChannelCapabilities (pctxt, &pvalue->mediaChannelCapabilities);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "mediaChannelCapabilities", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyFrameMapping_frameSequence          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RTPH263VideoRedundancyFrameMapping_frameSequence (OOCTXT* pctxt, H245RTPH263VideoRedundancyFrameMapping_frameSequence* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = decodeConsUInt8 (pctxt, &pvalue->elem[xx1], 0U, 255U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->elem[xx1]);
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyFrameMapping                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RTPH263VideoRedundancyFrameMapping (OOCTXT* pctxt, H245RTPH263VideoRedundancyFrameMapping* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode threadNumber */

   invokeStartElement (pctxt, "threadNumber", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->threadNumber, 0U, 15U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->threadNumber);

   invokeEndElement (pctxt, "threadNumber", -1);

   /* decode frameSequence */

   invokeStartElement (pctxt, "frameSequence", -1);

   stat = asn1PD_H245RTPH263VideoRedundancyFrameMapping_frameSequence (pctxt, &pvalue->frameSequence);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "frameSequence", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyEncoding_frameToThreadMapping_cust  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom (OOCTXT* pctxt, H245RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245RTPH263VideoRedundancyFrameMapping* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245RTPH263VideoRedundancyFrameMapping);

      stat = asn1PD_H245RTPH263VideoRedundancyFrameMapping (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyEncoding_frameToThreadMapping       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RTPH263VideoRedundancyEncoding_frameToThreadMapping (OOCTXT* pctxt, H245RTPH263VideoRedundancyEncoding_frameToThreadMapping* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* roundrobin */
         case 0:
            invokeStartElement (pctxt, "roundrobin", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "roundrobin", -1);

            break;

         /* custom */
         case 1:
            invokeStartElement (pctxt, "custom", -1);

            pvalue->u.custom = ALLOC_ASN1ELEM (pctxt, H245RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom);

            stat = asn1PD_H245RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom (pctxt, pvalue->u.custom);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "custom", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyEncoding_containedThreads           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RTPH263VideoRedundancyEncoding_containedThreads (OOCTXT* pctxt, H245RTPH263VideoRedundancyEncoding_containedThreads* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = decodeConsUInt8 (pctxt, &pvalue->elem[xx1], 0U, 15U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->elem[xx1]);
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyEncoding                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RTPH263VideoRedundancyEncoding (OOCTXT* pctxt, H245RTPH263VideoRedundancyEncoding* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.containedThreadsPresent = optbit;

   /* decode numberOfThreads */

   invokeStartElement (pctxt, "numberOfThreads", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->numberOfThreads, 1U, 16U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->numberOfThreads);

   invokeEndElement (pctxt, "numberOfThreads", -1);

   /* decode framesBetweenSyncPoints */

   invokeStartElement (pctxt, "framesBetweenSyncPoints", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->framesBetweenSyncPoints, 1U, 256U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->framesBetweenSyncPoints);

   invokeEndElement (pctxt, "framesBetweenSyncPoints", -1);

   /* decode frameToThreadMapping */

   invokeStartElement (pctxt, "frameToThreadMapping", -1);

   stat = asn1PD_H245RTPH263VideoRedundancyEncoding_frameToThreadMapping (pctxt, &pvalue->frameToThreadMapping);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "frameToThreadMapping", -1);

   /* decode containedThreads */

   if (pvalue->m.containedThreadsPresent) {
      invokeStartElement (pctxt, "containedThreads", -1);

      stat = asn1PD_H245RTPH263VideoRedundancyEncoding_containedThreads (pctxt, &pvalue->containedThreads);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "containedThreads", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingMethod                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RedundancyEncodingMethod (OOCTXT* pctxt, H245RedundancyEncodingMethod* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* rtpAudioRedundancyEncoding */
         case 1:
            invokeStartElement (pctxt, "rtpAudioRedundancyEncoding", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "rtpAudioRedundancyEncoding", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* rtpH263VideoRedundancyEncoding */
         case 3:
            invokeStartElement (pctxt, "rtpH263VideoRedundancyEncoding", -1);

            pvalue->u.rtpH263VideoRedundancyEncoding = ALLOC_ASN1ELEM (pctxt, H245RTPH263VideoRedundancyEncoding);

            stat = asn1PD_H245RTPH263VideoRedundancyEncoding (pctxt, pvalue->u.rtpH263VideoRedundancyEncoding);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "rtpH263VideoRedundancyEncoding", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityTableEntryNumber                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CapabilityTableEntryNumber (OOCTXT* pctxt, H245CapabilityTableEntryNumber* pvalue)
{
   int stat = ASN_OK;

   stat = decodeConsUInt16 (pctxt, pvalue, 1U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, *pvalue);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingCapability_secondaryEncoding            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RedundancyEncodingCapability_secondaryEncoding (OOCTXT* pctxt, H245RedundancyEncodingCapability_secondaryEncoding* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = asn1PD_H245CapabilityTableEntryNumber (pctxt, &pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingCapability                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RedundancyEncodingCapability (OOCTXT* pctxt, H245RedundancyEncodingCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.secondaryEncodingPresent = optbit;

   /* decode redundancyEncodingMethod */

   invokeStartElement (pctxt, "redundancyEncodingMethod", -1);

   stat = asn1PD_H245RedundancyEncodingMethod (pctxt, &pvalue->redundancyEncodingMethod);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "redundancyEncodingMethod", -1);

   /* decode primaryEncoding */

   invokeStartElement (pctxt, "primaryEncoding", -1);

   stat = asn1PD_H245CapabilityTableEntryNumber (pctxt, &pvalue->primaryEncoding);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "primaryEncoding", -1);

   /* decode secondaryEncoding */

   if (pvalue->m.secondaryEncodingPresent) {
      invokeStartElement (pctxt, "secondaryEncoding", -1);

      stat = asn1PD_H245RedundancyEncodingCapability_secondaryEncoding (pctxt, &pvalue->secondaryEncoding);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "secondaryEncoding", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250Capability_redundancyEncodingCapability              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H2250Capability_redundancyEncodingCapability (OOCTXT* pctxt, H245H2250Capability_redundancyEncodingCapability* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245RedundancyEncodingCapability* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245RedundancyEncodingCapability);

      stat = asn1PD_H245RedundancyEncodingCapability (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250Capability                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H2250Capability (OOCTXT* pctxt, H245H2250Capability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode maximumAudioDelayJitter */

   invokeStartElement (pctxt, "maximumAudioDelayJitter", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maximumAudioDelayJitter, 0U, 1023U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maximumAudioDelayJitter);

   invokeEndElement (pctxt, "maximumAudioDelayJitter", -1);

   /* decode receiveMultipointCapability */

   invokeStartElement (pctxt, "receiveMultipointCapability", -1);

   stat = asn1PD_H245MultipointCapability (pctxt, &pvalue->receiveMultipointCapability);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "receiveMultipointCapability", -1);

   /* decode transmitMultipointCapability */

   invokeStartElement (pctxt, "transmitMultipointCapability", -1);

   stat = asn1PD_H245MultipointCapability (pctxt, &pvalue->transmitMultipointCapability);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "transmitMultipointCapability", -1);

   /* decode receiveAndTransmitMultipointCapability */

   invokeStartElement (pctxt, "receiveAndTransmitMultipointCapability", -1);

   stat = asn1PD_H245MultipointCapability (pctxt, &pvalue->receiveAndTransmitMultipointCapability);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "receiveAndTransmitMultipointCapability", -1);

   /* decode mcCapability */

   invokeStartElement (pctxt, "mcCapability", -1);

   stat = asn1PD_H245H2250Capability_mcCapability (pctxt, &pvalue->mcCapability);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "mcCapability", -1);

   /* decode rtcpVideoControlCapability */

   invokeStartElement (pctxt, "rtcpVideoControlCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->rtcpVideoControlCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->rtcpVideoControlCapability);

   invokeEndElement (pctxt, "rtcpVideoControlCapability", -1);

   /* decode mediaPacketizationCapability */

   invokeStartElement (pctxt, "mediaPacketizationCapability", -1);

   stat = asn1PD_H245MediaPacketizationCapability (pctxt, &pvalue->mediaPacketizationCapability);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "mediaPacketizationCapability", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 4 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.transportCapabilityPresent = 1;

                     invokeStartElement (pctxt, "transportCapability", -1);

                     stat = asn1PD_H245TransportCapability (pctxt, &pvalue->transportCapability);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "transportCapability", -1);
                     break;

                  case 1:
                     pvalue->m.redundancyEncodingCapabilityPresent = 1;

                     invokeStartElement (pctxt, "redundancyEncodingCapability", -1);

                     stat = asn1PD_H245H2250Capability_redundancyEncodingCapability (pctxt, &pvalue->redundancyEncodingCapability);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "redundancyEncodingCapability", -1);
                     break;

                  case 2:
                     pvalue->m.logicalChannelSwitchingCapabilityPresent = 1;

                     invokeStartElement (pctxt, "logicalChannelSwitchingCapability", -1);

                     stat = DECODEBIT (pctxt, &pvalue->logicalChannelSwitchingCapability);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->logicalChannelSwitchingCapability);

                     invokeEndElement (pctxt, "logicalChannelSwitchingCapability", -1);
                     break;

                  case 3:
                     pvalue->m.t120DynamicPortCapabilityPresent = 1;

                     invokeStartElement (pctxt, "t120DynamicPortCapability", -1);

                     stat = DECODEBIT (pctxt, &pvalue->t120DynamicPortCapability);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->t120DynamicPortCapability);

                     invokeEndElement (pctxt, "t120DynamicPortCapability", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexCapability (OOCTXT* pctxt, H245MultiplexCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* h222Capability */
         case 1:
            invokeStartElement (pctxt, "h222Capability", -1);

            pvalue->u.h222Capability = ALLOC_ASN1ELEM (pctxt, H245H222Capability);

            stat = asn1PD_H245H222Capability (pctxt, pvalue->u.h222Capability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h222Capability", -1);

            break;

         /* h223Capability */
         case 2:
            invokeStartElement (pctxt, "h223Capability", -1);

            pvalue->u.h223Capability = ALLOC_ASN1ELEM (pctxt, H245H223Capability);

            stat = asn1PD_H245H223Capability (pctxt, pvalue->u.h223Capability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h223Capability", -1);

            break;

         /* v76Capability */
         case 3:
            invokeStartElement (pctxt, "v76Capability", -1);

            pvalue->u.v76Capability = ALLOC_ASN1ELEM (pctxt, H245V76Capability);

            stat = asn1PD_H245V76Capability (pctxt, pvalue->u.v76Capability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "v76Capability", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 5;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* h2250Capability */
         case 5:
            invokeStartElement (pctxt, "h2250Capability", -1);

            pvalue->u.h2250Capability = ALLOC_ASN1ELEM (pctxt, H245H2250Capability);

            stat = asn1PD_H245H2250Capability (pctxt, pvalue->u.h2250Capability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h2250Capability", -1);

            break;

         /* genericMultiplexCapability */
         case 6:
            invokeStartElement (pctxt, "genericMultiplexCapability", -1);

            pvalue->u.genericMultiplexCapability = ALLOC_ASN1ELEM (pctxt, H245GenericCapability);

            stat = asn1PD_H245GenericCapability (pctxt, pvalue->u.genericMultiplexCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "genericMultiplexCapability", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H261VideoCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H261VideoCapability (OOCTXT* pctxt, H245H261VideoCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.qcifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cifMPIPresent = optbit;

   /* decode qcifMPI */

   if (pvalue->m.qcifMPIPresent) {
      invokeStartElement (pctxt, "qcifMPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->qcifMPI, 1U, 4U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->qcifMPI);

      invokeEndElement (pctxt, "qcifMPI", -1);
   }

   /* decode cifMPI */

   if (pvalue->m.cifMPIPresent) {
      invokeStartElement (pctxt, "cifMPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->cifMPI, 1U, 4U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cifMPI);

      invokeEndElement (pctxt, "cifMPI", -1);
   }

   /* decode temporalSpatialTradeOffCapability */

   invokeStartElement (pctxt, "temporalSpatialTradeOffCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->temporalSpatialTradeOffCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->temporalSpatialTradeOffCapability);

   invokeEndElement (pctxt, "temporalSpatialTradeOffCapability", -1);

   /* decode maxBitRate */

   invokeStartElement (pctxt, "maxBitRate", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maxBitRate, 1U, 19200U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxBitRate);

   invokeEndElement (pctxt, "maxBitRate", -1);

   /* decode stillImageTransmission */

   invokeStartElement (pctxt, "stillImageTransmission", -1);

   stat = DECODEBIT (pctxt, &pvalue->stillImageTransmission);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->stillImageTransmission);

   invokeEndElement (pctxt, "stillImageTransmission", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.videoBadMBsCapPresent = 1;

                     invokeStartElement (pctxt, "videoBadMBsCap", -1);

                     stat = DECODEBIT (pctxt, &pvalue->videoBadMBsCap);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->videoBadMBsCap);

                     invokeEndElement (pctxt, "videoBadMBsCap", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H262VideoCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H262VideoCapability (OOCTXT* pctxt, H245H262VideoCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.videoBitRatePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.vbvBufferSizePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.samplesPerLinePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.linesPerFramePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.framesPerSecondPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.luminanceSampleRatePresent = optbit;

   /* decode profileAndLevel_SPatML */

   invokeStartElement (pctxt, "profileAndLevel_SPatML", -1);

   stat = DECODEBIT (pctxt, &pvalue->profileAndLevel_SPatML);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->profileAndLevel_SPatML);

   invokeEndElement (pctxt, "profileAndLevel_SPatML", -1);

   /* decode profileAndLevel_MPatLL */

   invokeStartElement (pctxt, "profileAndLevel_MPatLL", -1);

   stat = DECODEBIT (pctxt, &pvalue->profileAndLevel_MPatLL);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->profileAndLevel_MPatLL);

   invokeEndElement (pctxt, "profileAndLevel_MPatLL", -1);

   /* decode profileAndLevel_MPatML */

   invokeStartElement (pctxt, "profileAndLevel_MPatML", -1);

   stat = DECODEBIT (pctxt, &pvalue->profileAndLevel_MPatML);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->profileAndLevel_MPatML);

   invokeEndElement (pctxt, "profileAndLevel_MPatML", -1);

   /* decode profileAndLevel_MPatH_14 */

   invokeStartElement (pctxt, "profileAndLevel_MPatH_14", -1);

   stat = DECODEBIT (pctxt, &pvalue->profileAndLevel_MPatH_14);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->profileAndLevel_MPatH_14);

   invokeEndElement (pctxt, "profileAndLevel_MPatH_14", -1);

   /* decode profileAndLevel_MPatHL */

   invokeStartElement (pctxt, "profileAndLevel_MPatHL", -1);

   stat = DECODEBIT (pctxt, &pvalue->profileAndLevel_MPatHL);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->profileAndLevel_MPatHL);

   invokeEndElement (pctxt, "profileAndLevel_MPatHL", -1);

   /* decode profileAndLevel_SNRatLL */

   invokeStartElement (pctxt, "profileAndLevel_SNRatLL", -1);

   stat = DECODEBIT (pctxt, &pvalue->profileAndLevel_SNRatLL);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->profileAndLevel_SNRatLL);

   invokeEndElement (pctxt, "profileAndLevel_SNRatLL", -1);

   /* decode profileAndLevel_SNRatML */

   invokeStartElement (pctxt, "profileAndLevel_SNRatML", -1);

   stat = DECODEBIT (pctxt, &pvalue->profileAndLevel_SNRatML);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->profileAndLevel_SNRatML);

   invokeEndElement (pctxt, "profileAndLevel_SNRatML", -1);

   /* decode profileAndLevel_SpatialatH_14 */

   invokeStartElement (pctxt, "profileAndLevel_SpatialatH_14", -1);

   stat = DECODEBIT (pctxt, &pvalue->profileAndLevel_SpatialatH_14);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->profileAndLevel_SpatialatH_14);

   invokeEndElement (pctxt, "profileAndLevel_SpatialatH_14", -1);

   /* decode profileAndLevel_HPatML */

   invokeStartElement (pctxt, "profileAndLevel_HPatML", -1);

   stat = DECODEBIT (pctxt, &pvalue->profileAndLevel_HPatML);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->profileAndLevel_HPatML);

   invokeEndElement (pctxt, "profileAndLevel_HPatML", -1);

   /* decode profileAndLevel_HPatH_14 */

   invokeStartElement (pctxt, "profileAndLevel_HPatH_14", -1);

   stat = DECODEBIT (pctxt, &pvalue->profileAndLevel_HPatH_14);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->profileAndLevel_HPatH_14);

   invokeEndElement (pctxt, "profileAndLevel_HPatH_14", -1);

   /* decode profileAndLevel_HPatHL */

   invokeStartElement (pctxt, "profileAndLevel_HPatHL", -1);

   stat = DECODEBIT (pctxt, &pvalue->profileAndLevel_HPatHL);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->profileAndLevel_HPatHL);

   invokeEndElement (pctxt, "profileAndLevel_HPatHL", -1);

   /* decode videoBitRate */

   if (pvalue->m.videoBitRatePresent) {
      invokeStartElement (pctxt, "videoBitRate", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->videoBitRate, 0U, 1073741823U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->videoBitRate);

      invokeEndElement (pctxt, "videoBitRate", -1);
   }

   /* decode vbvBufferSize */

   if (pvalue->m.vbvBufferSizePresent) {
      invokeStartElement (pctxt, "vbvBufferSize", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->vbvBufferSize, 0U, 262143U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->vbvBufferSize);

      invokeEndElement (pctxt, "vbvBufferSize", -1);
   }

   /* decode samplesPerLine */

   if (pvalue->m.samplesPerLinePresent) {
      invokeStartElement (pctxt, "samplesPerLine", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->samplesPerLine, 0U, 16383U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->samplesPerLine);

      invokeEndElement (pctxt, "samplesPerLine", -1);
   }

   /* decode linesPerFrame */

   if (pvalue->m.linesPerFramePresent) {
      invokeStartElement (pctxt, "linesPerFrame", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->linesPerFrame, 0U, 16383U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->linesPerFrame);

      invokeEndElement (pctxt, "linesPerFrame", -1);
   }

   /* decode framesPerSecond */

   if (pvalue->m.framesPerSecondPresent) {
      invokeStartElement (pctxt, "framesPerSecond", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->framesPerSecond, 0U, 15U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->framesPerSecond);

      invokeEndElement (pctxt, "framesPerSecond", -1);
   }

   /* decode luminanceSampleRate */

   if (pvalue->m.luminanceSampleRatePresent) {
      invokeStartElement (pctxt, "luminanceSampleRate", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->luminanceSampleRate, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->luminanceSampleRate);

      invokeEndElement (pctxt, "luminanceSampleRate", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.videoBadMBsCapPresent = 1;

                     invokeStartElement (pctxt, "videoBadMBsCap", -1);

                     stat = DECODEBIT (pctxt, &pvalue->videoBadMBsCap);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->videoBadMBsCap);

                     invokeEndElement (pctxt, "videoBadMBsCap", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransparencyParameters                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TransparencyParameters (OOCTXT* pctxt, H245TransparencyParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode presentationOrder */

   invokeStartElement (pctxt, "presentationOrder", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->presentationOrder, 1U, 256U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->presentationOrder);

   invokeEndElement (pctxt, "presentationOrder", -1);

   /* decode offset_x */

   invokeStartElement (pctxt, "offset_x", -1);

   stat = decodeConsInteger (pctxt, &pvalue->offset_x, -262144, 262143);
   if (stat != ASN_OK) return stat;
   invokeIntValue (pctxt, pvalue->offset_x);

   invokeEndElement (pctxt, "offset_x", -1);

   /* decode offset_y */

   invokeStartElement (pctxt, "offset_y", -1);

   stat = decodeConsInteger (pctxt, &pvalue->offset_y, -262144, 262143);
   if (stat != ASN_OK) return stat;
   invokeIntValue (pctxt, pvalue->offset_y);

   invokeEndElement (pctxt, "offset_y", -1);

   /* decode scale_x */

   invokeStartElement (pctxt, "scale_x", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->scale_x, 1U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->scale_x);

   invokeEndElement (pctxt, "scale_x", -1);

   /* decode scale_y */

   invokeStartElement (pctxt, "scale_y", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->scale_y, 1U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->scale_y);

   invokeEndElement (pctxt, "scale_y", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefPictureSelection_additionalPictureMemory               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RefPictureSelection_additionalPictureMemory (OOCTXT* pctxt, H245RefPictureSelection_additionalPictureMemory* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.sqcifAdditionalPictureMemoryPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.qcifAdditionalPictureMemoryPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cifAdditionalPictureMemoryPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cif4AdditionalPictureMemoryPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cif16AdditionalPictureMemoryPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.bigCpfAdditionalPictureMemoryPresent = optbit;

   /* decode sqcifAdditionalPictureMemory */

   if (pvalue->m.sqcifAdditionalPictureMemoryPresent) {
      invokeStartElement (pctxt, "sqcifAdditionalPictureMemory", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->sqcifAdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->sqcifAdditionalPictureMemory);

      invokeEndElement (pctxt, "sqcifAdditionalPictureMemory", -1);
   }

   /* decode qcifAdditionalPictureMemory */

   if (pvalue->m.qcifAdditionalPictureMemoryPresent) {
      invokeStartElement (pctxt, "qcifAdditionalPictureMemory", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->qcifAdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->qcifAdditionalPictureMemory);

      invokeEndElement (pctxt, "qcifAdditionalPictureMemory", -1);
   }

   /* decode cifAdditionalPictureMemory */

   if (pvalue->m.cifAdditionalPictureMemoryPresent) {
      invokeStartElement (pctxt, "cifAdditionalPictureMemory", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->cifAdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cifAdditionalPictureMemory);

      invokeEndElement (pctxt, "cifAdditionalPictureMemory", -1);
   }

   /* decode cif4AdditionalPictureMemory */

   if (pvalue->m.cif4AdditionalPictureMemoryPresent) {
      invokeStartElement (pctxt, "cif4AdditionalPictureMemory", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->cif4AdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cif4AdditionalPictureMemory);

      invokeEndElement (pctxt, "cif4AdditionalPictureMemory", -1);
   }

   /* decode cif16AdditionalPictureMemory */

   if (pvalue->m.cif16AdditionalPictureMemoryPresent) {
      invokeStartElement (pctxt, "cif16AdditionalPictureMemory", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->cif16AdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cif16AdditionalPictureMemory);

      invokeEndElement (pctxt, "cif16AdditionalPictureMemory", -1);
   }

   /* decode bigCpfAdditionalPictureMemory */

   if (pvalue->m.bigCpfAdditionalPictureMemoryPresent) {
      invokeStartElement (pctxt, "bigCpfAdditionalPictureMemory", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->bigCpfAdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->bigCpfAdditionalPictureMemory);

      invokeEndElement (pctxt, "bigCpfAdditionalPictureMemory", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefPictureSelection_videoBackChannelSend                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RefPictureSelection_videoBackChannelSend (OOCTXT* pctxt, H245RefPictureSelection_videoBackChannelSend* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 4);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* none */
         case 0:
            invokeStartElement (pctxt, "none", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "none", -1);

            break;

         /* ackMessageOnly */
         case 1:
            invokeStartElement (pctxt, "ackMessageOnly", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "ackMessageOnly", -1);

            break;

         /* nackMessageOnly */
         case 2:
            invokeStartElement (pctxt, "nackMessageOnly", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "nackMessageOnly", -1);

            break;

         /* ackOrNackMessageOnly */
         case 3:
            invokeStartElement (pctxt, "ackOrNackMessageOnly", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "ackOrNackMessageOnly", -1);

            break;

         /* ackAndNackMessage */
         case 4:
            invokeStartElement (pctxt, "ackAndNackMessage", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "ackAndNackMessage", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 6;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefPictureSelection_enhancedReferencePicSelect_subPictur  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters (OOCTXT* pctxt, H245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode mpuHorizMBs */

   invokeStartElement (pctxt, "mpuHorizMBs", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->mpuHorizMBs, 1U, 128U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->mpuHorizMBs);

   invokeEndElement (pctxt, "mpuHorizMBs", -1);

   /* decode mpuVertMBs */

   invokeStartElement (pctxt, "mpuVertMBs", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->mpuVertMBs, 1U, 72U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->mpuVertMBs);

   invokeEndElement (pctxt, "mpuVertMBs", -1);

   /* decode mpuTotalNumber */

   invokeStartElement (pctxt, "mpuTotalNumber", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->mpuTotalNumber, 1U, 65536U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->mpuTotalNumber);

   invokeEndElement (pctxt, "mpuTotalNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefPictureSelection_enhancedReferencePicSelect            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RefPictureSelection_enhancedReferencePicSelect (OOCTXT* pctxt, H245RefPictureSelection_enhancedReferencePicSelect* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.subPictureRemovalParametersPresent = optbit;

   /* decode subPictureRemovalParameters */

   if (pvalue->m.subPictureRemovalParametersPresent) {
      invokeStartElement (pctxt, "subPictureRemovalParameters", -1);

      stat = asn1PD_H245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters (pctxt, &pvalue->subPictureRemovalParameters);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "subPictureRemovalParameters", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefPictureSelection                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RefPictureSelection (OOCTXT* pctxt, H245RefPictureSelection* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.additionalPictureMemoryPresent = optbit;

   /* decode additionalPictureMemory */

   if (pvalue->m.additionalPictureMemoryPresent) {
      invokeStartElement (pctxt, "additionalPictureMemory", -1);

      stat = asn1PD_H245RefPictureSelection_additionalPictureMemory (pctxt, &pvalue->additionalPictureMemory);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "additionalPictureMemory", -1);
   }

   /* decode videoMux */

   invokeStartElement (pctxt, "videoMux", -1);

   stat = DECODEBIT (pctxt, &pvalue->videoMux);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->videoMux);

   invokeEndElement (pctxt, "videoMux", -1);

   /* decode videoBackChannelSend */

   invokeStartElement (pctxt, "videoBackChannelSend", -1);

   stat = asn1PD_H245RefPictureSelection_videoBackChannelSend (pctxt, &pvalue->videoBackChannelSend);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "videoBackChannelSend", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.enhancedReferencePicSelectPresent = 1;

                     invokeStartElement (pctxt, "enhancedReferencePicSelect", -1);

                     stat = asn1PD_H245RefPictureSelection_enhancedReferencePicSelect (pctxt, &pvalue->enhancedReferencePicSelect);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "enhancedReferencePicSelect", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureClockFrequency                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CustomPictureClockFrequency (OOCTXT* pctxt, H245CustomPictureClockFrequency* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.sqcifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.qcifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cif4MPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cif16MPIPresent = optbit;

   /* decode clockConversionCode */

   invokeStartElement (pctxt, "clockConversionCode", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->clockConversionCode, 1000U, 1001U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->clockConversionCode);

   invokeEndElement (pctxt, "clockConversionCode", -1);

   /* decode clockDivisor */

   invokeStartElement (pctxt, "clockDivisor", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->clockDivisor, 1U, 127U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->clockDivisor);

   invokeEndElement (pctxt, "clockDivisor", -1);

   /* decode sqcifMPI */

   if (pvalue->m.sqcifMPIPresent) {
      invokeStartElement (pctxt, "sqcifMPI", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->sqcifMPI, 1U, 2048U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->sqcifMPI);

      invokeEndElement (pctxt, "sqcifMPI", -1);
   }

   /* decode qcifMPI */

   if (pvalue->m.qcifMPIPresent) {
      invokeStartElement (pctxt, "qcifMPI", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->qcifMPI, 1U, 2048U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->qcifMPI);

      invokeEndElement (pctxt, "qcifMPI", -1);
   }

   /* decode cifMPI */

   if (pvalue->m.cifMPIPresent) {
      invokeStartElement (pctxt, "cifMPI", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->cifMPI, 1U, 2048U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cifMPI);

      invokeEndElement (pctxt, "cifMPI", -1);
   }

   /* decode cif4MPI */

   if (pvalue->m.cif4MPIPresent) {
      invokeStartElement (pctxt, "cif4MPI", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->cif4MPI, 1U, 2048U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cif4MPI);

      invokeEndElement (pctxt, "cif4MPI", -1);
   }

   /* decode cif16MPI */

   if (pvalue->m.cif16MPIPresent) {
      invokeStartElement (pctxt, "cif16MPI", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->cif16MPI, 1U, 2048U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cif16MPI);

      invokeEndElement (pctxt, "cif16MPI", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263Options_customPictureClockFrequency                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H263Options_customPictureClockFrequency (OOCTXT* pctxt, H245H263Options_customPictureClockFrequency* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   H245CustomPictureClockFrequency* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245CustomPictureClockFrequency);

      stat = asn1PD_H245CustomPictureClockFrequency (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_mPI_customPCF_element                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CustomPictureFormat_mPI_customPCF_element (OOCTXT* pctxt, H245CustomPictureFormat_mPI_customPCF_element* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode clockConversionCode */

   invokeStartElement (pctxt, "clockConversionCode", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->clockConversionCode, 1000U, 1001U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->clockConversionCode);

   invokeEndElement (pctxt, "clockConversionCode", -1);

   /* decode clockDivisor */

   invokeStartElement (pctxt, "clockDivisor", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->clockDivisor, 1U, 127U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->clockDivisor);

   invokeEndElement (pctxt, "clockDivisor", -1);

   /* decode customMPI */

   invokeStartElement (pctxt, "customMPI", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->customMPI, 1U, 2048U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->customMPI);

   invokeEndElement (pctxt, "customMPI", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_mPI_customPCF                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CustomPictureFormat_mPI_customPCF (OOCTXT* pctxt, H245CustomPictureFormat_mPI_customPCF* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   H245CustomPictureFormat_mPI_customPCF_element* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245CustomPictureFormat_mPI_customPCF_element);

      stat = asn1PD_H245CustomPictureFormat_mPI_customPCF_element (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_mPI                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CustomPictureFormat_mPI (OOCTXT* pctxt, H245CustomPictureFormat_mPI* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.standardMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.customPCFPresent = optbit;

   /* decode standardMPI */

   if (pvalue->m.standardMPIPresent) {
      invokeStartElement (pctxt, "standardMPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->standardMPI, 1U, 31U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->standardMPI);

      invokeEndElement (pctxt, "standardMPI", -1);
   }

   /* decode customPCF */

   if (pvalue->m.customPCFPresent) {
      invokeStartElement (pctxt, "customPCF", -1);

      stat = asn1PD_H245CustomPictureFormat_mPI_customPCF (pctxt, &pvalue->customPCF);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "customPCF", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_pixelAspectInformation_pixelAspectCo  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CustomPictureFormat_pixelAspectInformation_pixelAspectCode (OOCTXT* pctxt, H245CustomPictureFormat_pixelAspectInformation_pixelAspectCode* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 14, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = decodeConsUInt8 (pctxt, &pvalue->elem[xx1], 1U, 14U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->elem[xx1]);
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_pixelAspectInformation_extendedPAR_e  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CustomPictureFormat_pixelAspectInformation_extendedPAR_element (OOCTXT* pctxt, H245CustomPictureFormat_pixelAspectInformation_extendedPAR_element* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode width */

   invokeStartElement (pctxt, "width", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->width, 1U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->width);

   invokeEndElement (pctxt, "width", -1);

   /* decode height */

   invokeStartElement (pctxt, "height", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->height, 1U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->height);

   invokeEndElement (pctxt, "height", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_pixelAspectInformation_extendedPAR    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CustomPictureFormat_pixelAspectInformation_extendedPAR (OOCTXT* pctxt, H245CustomPictureFormat_pixelAspectInformation_extendedPAR* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245CustomPictureFormat_pixelAspectInformation_extendedPAR_element* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245CustomPictureFormat_pixelAspectInformation_extendedPAR_element);

      stat = asn1PD_H245CustomPictureFormat_pixelAspectInformation_extendedPAR_element (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_pixelAspectInformation                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CustomPictureFormat_pixelAspectInformation (OOCTXT* pctxt, H245CustomPictureFormat_pixelAspectInformation* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* anyPixelAspectRatio */
         case 0:
            invokeStartElement (pctxt, "anyPixelAspectRatio", -1);

            stat = DECODEBIT (pctxt, &pvalue->u.anyPixelAspectRatio);
            if (stat != ASN_OK) return stat;
            invokeBoolValue (pctxt, pvalue->u.anyPixelAspectRatio);

            invokeEndElement (pctxt, "anyPixelAspectRatio", -1);

            break;

         /* pixelAspectCode */
         case 1:
            invokeStartElement (pctxt, "pixelAspectCode", -1);

            pvalue->u.pixelAspectCode = ALLOC_ASN1ELEM (pctxt, H245CustomPictureFormat_pixelAspectInformation_pixelAspectCode);

            stat = asn1PD_H245CustomPictureFormat_pixelAspectInformation_pixelAspectCode (pctxt, pvalue->u.pixelAspectCode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "pixelAspectCode", -1);

            break;

         /* extendedPAR */
         case 2:
            invokeStartElement (pctxt, "extendedPAR", -1);

            pvalue->u.extendedPAR = ALLOC_ASN1ELEM (pctxt, H245CustomPictureFormat_pixelAspectInformation_extendedPAR);

            stat = asn1PD_H245CustomPictureFormat_pixelAspectInformation_extendedPAR (pctxt, pvalue->u.extendedPAR);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "extendedPAR", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CustomPictureFormat (OOCTXT* pctxt, H245CustomPictureFormat* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode maxCustomPictureWidth */

   invokeStartElement (pctxt, "maxCustomPictureWidth", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maxCustomPictureWidth, 1U, 2048U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxCustomPictureWidth);

   invokeEndElement (pctxt, "maxCustomPictureWidth", -1);

   /* decode maxCustomPictureHeight */

   invokeStartElement (pctxt, "maxCustomPictureHeight", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maxCustomPictureHeight, 1U, 2048U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxCustomPictureHeight);

   invokeEndElement (pctxt, "maxCustomPictureHeight", -1);

   /* decode minCustomPictureWidth */

   invokeStartElement (pctxt, "minCustomPictureWidth", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->minCustomPictureWidth, 1U, 2048U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->minCustomPictureWidth);

   invokeEndElement (pctxt, "minCustomPictureWidth", -1);

   /* decode minCustomPictureHeight */

   invokeStartElement (pctxt, "minCustomPictureHeight", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->minCustomPictureHeight, 1U, 2048U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->minCustomPictureHeight);

   invokeEndElement (pctxt, "minCustomPictureHeight", -1);

   /* decode mPI */

   invokeStartElement (pctxt, "mPI", -1);

   stat = asn1PD_H245CustomPictureFormat_mPI (pctxt, &pvalue->mPI);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "mPI", -1);

   /* decode pixelAspectInformation */

   invokeStartElement (pctxt, "pixelAspectInformation", -1);

   stat = asn1PD_H245CustomPictureFormat_pixelAspectInformation (pctxt, &pvalue->pixelAspectInformation);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "pixelAspectInformation", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263Options_customPictureFormat                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H263Options_customPictureFormat (OOCTXT* pctxt, H245H263Options_customPictureFormat* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   H245CustomPictureFormat* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245CustomPictureFormat);

      stat = asn1PD_H245CustomPictureFormat (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263Version3Options                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H263Version3Options (OOCTXT* pctxt, H245H263Version3Options* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode dataPartitionedSlices */

   invokeStartElement (pctxt, "dataPartitionedSlices", -1);

   stat = DECODEBIT (pctxt, &pvalue->dataPartitionedSlices);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dataPartitionedSlices);

   invokeEndElement (pctxt, "dataPartitionedSlices", -1);

   /* decode fixedPointIDCT0 */

   invokeStartElement (pctxt, "fixedPointIDCT0", -1);

   stat = DECODEBIT (pctxt, &pvalue->fixedPointIDCT0);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->fixedPointIDCT0);

   invokeEndElement (pctxt, "fixedPointIDCT0", -1);

   /* decode interlacedFields */

   invokeStartElement (pctxt, "interlacedFields", -1);

   stat = DECODEBIT (pctxt, &pvalue->interlacedFields);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->interlacedFields);

   invokeEndElement (pctxt, "interlacedFields", -1);

   /* decode currentPictureHeaderRepetition */

   invokeStartElement (pctxt, "currentPictureHeaderRepetition", -1);

   stat = DECODEBIT (pctxt, &pvalue->currentPictureHeaderRepetition);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->currentPictureHeaderRepetition);

   invokeEndElement (pctxt, "currentPictureHeaderRepetition", -1);

   /* decode previousPictureHeaderRepetition */

   invokeStartElement (pctxt, "previousPictureHeaderRepetition", -1);

   stat = DECODEBIT (pctxt, &pvalue->previousPictureHeaderRepetition);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->previousPictureHeaderRepetition);

   invokeEndElement (pctxt, "previousPictureHeaderRepetition", -1);

   /* decode nextPictureHeaderRepetition */

   invokeStartElement (pctxt, "nextPictureHeaderRepetition", -1);

   stat = DECODEBIT (pctxt, &pvalue->nextPictureHeaderRepetition);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->nextPictureHeaderRepetition);

   invokeEndElement (pctxt, "nextPictureHeaderRepetition", -1);

   /* decode pictureNumber */

   invokeStartElement (pctxt, "pictureNumber", -1);

   stat = DECODEBIT (pctxt, &pvalue->pictureNumber);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->pictureNumber);

   invokeEndElement (pctxt, "pictureNumber", -1);

   /* decode spareReferencePictures */

   invokeStartElement (pctxt, "spareReferencePictures", -1);

   stat = DECODEBIT (pctxt, &pvalue->spareReferencePictures);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->spareReferencePictures);

   invokeEndElement (pctxt, "spareReferencePictures", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263ModeComboFlags                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H263ModeComboFlags (OOCTXT* pctxt, H245H263ModeComboFlags* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode unrestrictedVector */

   invokeStartElement (pctxt, "unrestrictedVector", -1);

   stat = DECODEBIT (pctxt, &pvalue->unrestrictedVector);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->unrestrictedVector);

   invokeEndElement (pctxt, "unrestrictedVector", -1);

   /* decode arithmeticCoding */

   invokeStartElement (pctxt, "arithmeticCoding", -1);

   stat = DECODEBIT (pctxt, &pvalue->arithmeticCoding);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->arithmeticCoding);

   invokeEndElement (pctxt, "arithmeticCoding", -1);

   /* decode advancedPrediction */

   invokeStartElement (pctxt, "advancedPrediction", -1);

   stat = DECODEBIT (pctxt, &pvalue->advancedPrediction);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->advancedPrediction);

   invokeEndElement (pctxt, "advancedPrediction", -1);

   /* decode pbFrames */

   invokeStartElement (pctxt, "pbFrames", -1);

   stat = DECODEBIT (pctxt, &pvalue->pbFrames);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->pbFrames);

   invokeEndElement (pctxt, "pbFrames", -1);

   /* decode advancedIntraCodingMode */

   invokeStartElement (pctxt, "advancedIntraCodingMode", -1);

   stat = DECODEBIT (pctxt, &pvalue->advancedIntraCodingMode);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->advancedIntraCodingMode);

   invokeEndElement (pctxt, "advancedIntraCodingMode", -1);

   /* decode deblockingFilterMode */

   invokeStartElement (pctxt, "deblockingFilterMode", -1);

   stat = DECODEBIT (pctxt, &pvalue->deblockingFilterMode);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->deblockingFilterMode);

   invokeEndElement (pctxt, "deblockingFilterMode", -1);

   /* decode unlimitedMotionVectors */

   invokeStartElement (pctxt, "unlimitedMotionVectors", -1);

   stat = DECODEBIT (pctxt, &pvalue->unlimitedMotionVectors);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->unlimitedMotionVectors);

   invokeEndElement (pctxt, "unlimitedMotionVectors", -1);

   /* decode slicesInOrder_NonRect */

   invokeStartElement (pctxt, "slicesInOrder_NonRect", -1);

   stat = DECODEBIT (pctxt, &pvalue->slicesInOrder_NonRect);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->slicesInOrder_NonRect);

   invokeEndElement (pctxt, "slicesInOrder_NonRect", -1);

   /* decode slicesInOrder_Rect */

   invokeStartElement (pctxt, "slicesInOrder_Rect", -1);

   stat = DECODEBIT (pctxt, &pvalue->slicesInOrder_Rect);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->slicesInOrder_Rect);

   invokeEndElement (pctxt, "slicesInOrder_Rect", -1);

   /* decode slicesNoOrder_NonRect */

   invokeStartElement (pctxt, "slicesNoOrder_NonRect", -1);

   stat = DECODEBIT (pctxt, &pvalue->slicesNoOrder_NonRect);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->slicesNoOrder_NonRect);

   invokeEndElement (pctxt, "slicesNoOrder_NonRect", -1);

   /* decode slicesNoOrder_Rect */

   invokeStartElement (pctxt, "slicesNoOrder_Rect", -1);

   stat = DECODEBIT (pctxt, &pvalue->slicesNoOrder_Rect);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->slicesNoOrder_Rect);

   invokeEndElement (pctxt, "slicesNoOrder_Rect", -1);

   /* decode improvedPBFramesMode */

   invokeStartElement (pctxt, "improvedPBFramesMode", -1);

   stat = DECODEBIT (pctxt, &pvalue->improvedPBFramesMode);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->improvedPBFramesMode);

   invokeEndElement (pctxt, "improvedPBFramesMode", -1);

   /* decode referencePicSelect */

   invokeStartElement (pctxt, "referencePicSelect", -1);

   stat = DECODEBIT (pctxt, &pvalue->referencePicSelect);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->referencePicSelect);

   invokeEndElement (pctxt, "referencePicSelect", -1);

   /* decode dynamicPictureResizingByFour */

   invokeStartElement (pctxt, "dynamicPictureResizingByFour", -1);

   stat = DECODEBIT (pctxt, &pvalue->dynamicPictureResizingByFour);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dynamicPictureResizingByFour);

   invokeEndElement (pctxt, "dynamicPictureResizingByFour", -1);

   /* decode dynamicPictureResizingSixteenthPel */

   invokeStartElement (pctxt, "dynamicPictureResizingSixteenthPel", -1);

   stat = DECODEBIT (pctxt, &pvalue->dynamicPictureResizingSixteenthPel);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dynamicPictureResizingSixteenthPel);

   invokeEndElement (pctxt, "dynamicPictureResizingSixteenthPel", -1);

   /* decode dynamicWarpingHalfPel */

   invokeStartElement (pctxt, "dynamicWarpingHalfPel", -1);

   stat = DECODEBIT (pctxt, &pvalue->dynamicWarpingHalfPel);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dynamicWarpingHalfPel);

   invokeEndElement (pctxt, "dynamicWarpingHalfPel", -1);

   /* decode dynamicWarpingSixteenthPel */

   invokeStartElement (pctxt, "dynamicWarpingSixteenthPel", -1);

   stat = DECODEBIT (pctxt, &pvalue->dynamicWarpingSixteenthPel);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dynamicWarpingSixteenthPel);

   invokeEndElement (pctxt, "dynamicWarpingSixteenthPel", -1);

   /* decode reducedResolutionUpdate */

   invokeStartElement (pctxt, "reducedResolutionUpdate", -1);

   stat = DECODEBIT (pctxt, &pvalue->reducedResolutionUpdate);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->reducedResolutionUpdate);

   invokeEndElement (pctxt, "reducedResolutionUpdate", -1);

   /* decode independentSegmentDecoding */

   invokeStartElement (pctxt, "independentSegmentDecoding", -1);

   stat = DECODEBIT (pctxt, &pvalue->independentSegmentDecoding);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->independentSegmentDecoding);

   invokeEndElement (pctxt, "independentSegmentDecoding", -1);

   /* decode alternateInterVLCMode */

   invokeStartElement (pctxt, "alternateInterVLCMode", -1);

   stat = DECODEBIT (pctxt, &pvalue->alternateInterVLCMode);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->alternateInterVLCMode);

   invokeEndElement (pctxt, "alternateInterVLCMode", -1);

   /* decode modifiedQuantizationMode */

   invokeStartElement (pctxt, "modifiedQuantizationMode", -1);

   stat = DECODEBIT (pctxt, &pvalue->modifiedQuantizationMode);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->modifiedQuantizationMode);

   invokeEndElement (pctxt, "modifiedQuantizationMode", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 2 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.enhancedReferencePicSelectPresent = 1;

                     invokeStartElement (pctxt, "enhancedReferencePicSelect", -1);

                     stat = DECODEBIT (pctxt, &pvalue->enhancedReferencePicSelect);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->enhancedReferencePicSelect);

                     invokeEndElement (pctxt, "enhancedReferencePicSelect", -1);
                     break;

                  case 1:
                     pvalue->m.h263Version3OptionsPresent = 1;

                     invokeStartElement (pctxt, "h263Version3Options", -1);

                     stat = asn1PD_H245H263Version3Options (pctxt, &pvalue->h263Version3Options);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "h263Version3Options", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263VideoModeCombos_h263VideoCoupledModes                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H263VideoModeCombos_h263VideoCoupledModes (OOCTXT* pctxt, H245H263VideoModeCombos_h263VideoCoupledModes* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   H245H263ModeComboFlags* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245H263ModeComboFlags);

      stat = asn1PD_H245H263ModeComboFlags (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263VideoModeCombos                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H263VideoModeCombos (OOCTXT* pctxt, H245H263VideoModeCombos* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode h263VideoUncoupledModes */

   invokeStartElement (pctxt, "h263VideoUncoupledModes", -1);

   stat = asn1PD_H245H263ModeComboFlags (pctxt, &pvalue->h263VideoUncoupledModes);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "h263VideoUncoupledModes", -1);

   /* decode h263VideoCoupledModes */

   invokeStartElement (pctxt, "h263VideoCoupledModes", -1);

   stat = asn1PD_H245H263VideoModeCombos_h263VideoCoupledModes (pctxt, &pvalue->h263VideoCoupledModes);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "h263VideoCoupledModes", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263Options_modeCombos                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H263Options_modeCombos (OOCTXT* pctxt, H245H263Options_modeCombos* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   H245H263VideoModeCombos* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245H263VideoModeCombos);

      stat = asn1PD_H245H263VideoModeCombos (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263Options                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H263Options (OOCTXT* pctxt, H245H263Options* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.transparencyParametersPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.refPictureSelectionPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.customPictureClockFrequencyPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.customPictureFormatPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.modeCombosPresent = optbit;

   /* decode advancedIntraCodingMode */

   invokeStartElement (pctxt, "advancedIntraCodingMode", -1);

   stat = DECODEBIT (pctxt, &pvalue->advancedIntraCodingMode);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->advancedIntraCodingMode);

   invokeEndElement (pctxt, "advancedIntraCodingMode", -1);

   /* decode deblockingFilterMode */

   invokeStartElement (pctxt, "deblockingFilterMode", -1);

   stat = DECODEBIT (pctxt, &pvalue->deblockingFilterMode);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->deblockingFilterMode);

   invokeEndElement (pctxt, "deblockingFilterMode", -1);

   /* decode improvedPBFramesMode */

   invokeStartElement (pctxt, "improvedPBFramesMode", -1);

   stat = DECODEBIT (pctxt, &pvalue->improvedPBFramesMode);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->improvedPBFramesMode);

   invokeEndElement (pctxt, "improvedPBFramesMode", -1);

   /* decode unlimitedMotionVectors */

   invokeStartElement (pctxt, "unlimitedMotionVectors", -1);

   stat = DECODEBIT (pctxt, &pvalue->unlimitedMotionVectors);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->unlimitedMotionVectors);

   invokeEndElement (pctxt, "unlimitedMotionVectors", -1);

   /* decode fullPictureFreeze */

   invokeStartElement (pctxt, "fullPictureFreeze", -1);

   stat = DECODEBIT (pctxt, &pvalue->fullPictureFreeze);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->fullPictureFreeze);

   invokeEndElement (pctxt, "fullPictureFreeze", -1);

   /* decode partialPictureFreezeAndRelease */

   invokeStartElement (pctxt, "partialPictureFreezeAndRelease", -1);

   stat = DECODEBIT (pctxt, &pvalue->partialPictureFreezeAndRelease);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->partialPictureFreezeAndRelease);

   invokeEndElement (pctxt, "partialPictureFreezeAndRelease", -1);

   /* decode resizingPartPicFreezeAndRelease */

   invokeStartElement (pctxt, "resizingPartPicFreezeAndRelease", -1);

   stat = DECODEBIT (pctxt, &pvalue->resizingPartPicFreezeAndRelease);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->resizingPartPicFreezeAndRelease);

   invokeEndElement (pctxt, "resizingPartPicFreezeAndRelease", -1);

   /* decode fullPictureSnapshot */

   invokeStartElement (pctxt, "fullPictureSnapshot", -1);

   stat = DECODEBIT (pctxt, &pvalue->fullPictureSnapshot);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->fullPictureSnapshot);

   invokeEndElement (pctxt, "fullPictureSnapshot", -1);

   /* decode partialPictureSnapshot */

   invokeStartElement (pctxt, "partialPictureSnapshot", -1);

   stat = DECODEBIT (pctxt, &pvalue->partialPictureSnapshot);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->partialPictureSnapshot);

   invokeEndElement (pctxt, "partialPictureSnapshot", -1);

   /* decode videoSegmentTagging */

   invokeStartElement (pctxt, "videoSegmentTagging", -1);

   stat = DECODEBIT (pctxt, &pvalue->videoSegmentTagging);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->videoSegmentTagging);

   invokeEndElement (pctxt, "videoSegmentTagging", -1);

   /* decode progressiveRefinement */

   invokeStartElement (pctxt, "progressiveRefinement", -1);

   stat = DECODEBIT (pctxt, &pvalue->progressiveRefinement);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->progressiveRefinement);

   invokeEndElement (pctxt, "progressiveRefinement", -1);

   /* decode dynamicPictureResizingByFour */

   invokeStartElement (pctxt, "dynamicPictureResizingByFour", -1);

   stat = DECODEBIT (pctxt, &pvalue->dynamicPictureResizingByFour);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dynamicPictureResizingByFour);

   invokeEndElement (pctxt, "dynamicPictureResizingByFour", -1);

   /* decode dynamicPictureResizingSixteenthPel */

   invokeStartElement (pctxt, "dynamicPictureResizingSixteenthPel", -1);

   stat = DECODEBIT (pctxt, &pvalue->dynamicPictureResizingSixteenthPel);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dynamicPictureResizingSixteenthPel);

   invokeEndElement (pctxt, "dynamicPictureResizingSixteenthPel", -1);

   /* decode dynamicWarpingHalfPel */

   invokeStartElement (pctxt, "dynamicWarpingHalfPel", -1);

   stat = DECODEBIT (pctxt, &pvalue->dynamicWarpingHalfPel);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dynamicWarpingHalfPel);

   invokeEndElement (pctxt, "dynamicWarpingHalfPel", -1);

   /* decode dynamicWarpingSixteenthPel */

   invokeStartElement (pctxt, "dynamicWarpingSixteenthPel", -1);

   stat = DECODEBIT (pctxt, &pvalue->dynamicWarpingSixteenthPel);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->dynamicWarpingSixteenthPel);

   invokeEndElement (pctxt, "dynamicWarpingSixteenthPel", -1);

   /* decode independentSegmentDecoding */

   invokeStartElement (pctxt, "independentSegmentDecoding", -1);

   stat = DECODEBIT (pctxt, &pvalue->independentSegmentDecoding);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->independentSegmentDecoding);

   invokeEndElement (pctxt, "independentSegmentDecoding", -1);

   /* decode slicesInOrder_NonRect */

   invokeStartElement (pctxt, "slicesInOrder_NonRect", -1);

   stat = DECODEBIT (pctxt, &pvalue->slicesInOrder_NonRect);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->slicesInOrder_NonRect);

   invokeEndElement (pctxt, "slicesInOrder_NonRect", -1);

   /* decode slicesInOrder_Rect */

   invokeStartElement (pctxt, "slicesInOrder_Rect", -1);

   stat = DECODEBIT (pctxt, &pvalue->slicesInOrder_Rect);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->slicesInOrder_Rect);

   invokeEndElement (pctxt, "slicesInOrder_Rect", -1);

   /* decode slicesNoOrder_NonRect */

   invokeStartElement (pctxt, "slicesNoOrder_NonRect", -1);

   stat = DECODEBIT (pctxt, &pvalue->slicesNoOrder_NonRect);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->slicesNoOrder_NonRect);

   invokeEndElement (pctxt, "slicesNoOrder_NonRect", -1);

   /* decode slicesNoOrder_Rect */

   invokeStartElement (pctxt, "slicesNoOrder_Rect", -1);

   stat = DECODEBIT (pctxt, &pvalue->slicesNoOrder_Rect);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->slicesNoOrder_Rect);

   invokeEndElement (pctxt, "slicesNoOrder_Rect", -1);

   /* decode alternateInterVLCMode */

   invokeStartElement (pctxt, "alternateInterVLCMode", -1);

   stat = DECODEBIT (pctxt, &pvalue->alternateInterVLCMode);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->alternateInterVLCMode);

   invokeEndElement (pctxt, "alternateInterVLCMode", -1);

   /* decode modifiedQuantizationMode */

   invokeStartElement (pctxt, "modifiedQuantizationMode", -1);

   stat = DECODEBIT (pctxt, &pvalue->modifiedQuantizationMode);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->modifiedQuantizationMode);

   invokeEndElement (pctxt, "modifiedQuantizationMode", -1);

   /* decode reducedResolutionUpdate */

   invokeStartElement (pctxt, "reducedResolutionUpdate", -1);

   stat = DECODEBIT (pctxt, &pvalue->reducedResolutionUpdate);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->reducedResolutionUpdate);

   invokeEndElement (pctxt, "reducedResolutionUpdate", -1);

   /* decode transparencyParameters */

   if (pvalue->m.transparencyParametersPresent) {
      invokeStartElement (pctxt, "transparencyParameters", -1);

      stat = asn1PD_H245TransparencyParameters (pctxt, &pvalue->transparencyParameters);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "transparencyParameters", -1);
   }

   /* decode separateVideoBackChannel */

   invokeStartElement (pctxt, "separateVideoBackChannel", -1);

   stat = DECODEBIT (pctxt, &pvalue->separateVideoBackChannel);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->separateVideoBackChannel);

   invokeEndElement (pctxt, "separateVideoBackChannel", -1);

   /* decode refPictureSelection */

   if (pvalue->m.refPictureSelectionPresent) {
      invokeStartElement (pctxt, "refPictureSelection", -1);

      stat = asn1PD_H245RefPictureSelection (pctxt, &pvalue->refPictureSelection);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "refPictureSelection", -1);
   }

   /* decode customPictureClockFrequency */

   if (pvalue->m.customPictureClockFrequencyPresent) {
      invokeStartElement (pctxt, "customPictureClockFrequency", -1);

      stat = asn1PD_H245H263Options_customPictureClockFrequency (pctxt, &pvalue->customPictureClockFrequency);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "customPictureClockFrequency", -1);
   }

   /* decode customPictureFormat */

   if (pvalue->m.customPictureFormatPresent) {
      invokeStartElement (pctxt, "customPictureFormat", -1);

      stat = asn1PD_H245H263Options_customPictureFormat (pctxt, &pvalue->customPictureFormat);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "customPictureFormat", -1);
   }

   /* decode modeCombos */

   if (pvalue->m.modeCombosPresent) {
      invokeStartElement (pctxt, "modeCombos", -1);

      stat = asn1PD_H245H263Options_modeCombos (pctxt, &pvalue->modeCombos);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "modeCombos", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 2 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.videoBadMBsCapPresent = 1;

                     invokeStartElement (pctxt, "videoBadMBsCap", -1);

                     stat = DECODEBIT (pctxt, &pvalue->videoBadMBsCap);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->videoBadMBsCap);

                     invokeEndElement (pctxt, "videoBadMBsCap", -1);
                     break;

                  case 1:
                     pvalue->m.h263Version3OptionsPresent = 1;

                     invokeStartElement (pctxt, "h263Version3Options", -1);

                     stat = asn1PD_H245H263Version3Options (pctxt, &pvalue->h263Version3Options);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "h263Version3Options", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EnhancementOptions                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EnhancementOptions (OOCTXT* pctxt, H245EnhancementOptions* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.sqcifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.qcifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cif4MPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cif16MPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.slowSqcifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.slowQcifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.slowCifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.slowCif4MPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.slowCif16MPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.h263OptionsPresent = optbit;

   /* decode sqcifMPI */

   if (pvalue->m.sqcifMPIPresent) {
      invokeStartElement (pctxt, "sqcifMPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->sqcifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->sqcifMPI);

      invokeEndElement (pctxt, "sqcifMPI", -1);
   }

   /* decode qcifMPI */

   if (pvalue->m.qcifMPIPresent) {
      invokeStartElement (pctxt, "qcifMPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->qcifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->qcifMPI);

      invokeEndElement (pctxt, "qcifMPI", -1);
   }

   /* decode cifMPI */

   if (pvalue->m.cifMPIPresent) {
      invokeStartElement (pctxt, "cifMPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->cifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cifMPI);

      invokeEndElement (pctxt, "cifMPI", -1);
   }

   /* decode cif4MPI */

   if (pvalue->m.cif4MPIPresent) {
      invokeStartElement (pctxt, "cif4MPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->cif4MPI, 1U, 32U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cif4MPI);

      invokeEndElement (pctxt, "cif4MPI", -1);
   }

   /* decode cif16MPI */

   if (pvalue->m.cif16MPIPresent) {
      invokeStartElement (pctxt, "cif16MPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->cif16MPI, 1U, 32U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cif16MPI);

      invokeEndElement (pctxt, "cif16MPI", -1);
   }

   /* decode maxBitRate */

   invokeStartElement (pctxt, "maxBitRate", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->maxBitRate, 1U, 192400U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxBitRate);

   invokeEndElement (pctxt, "maxBitRate", -1);

   /* decode unrestrictedVector */

   invokeStartElement (pctxt, "unrestrictedVector", -1);

   stat = DECODEBIT (pctxt, &pvalue->unrestrictedVector);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->unrestrictedVector);

   invokeEndElement (pctxt, "unrestrictedVector", -1);

   /* decode arithmeticCoding */

   invokeStartElement (pctxt, "arithmeticCoding", -1);

   stat = DECODEBIT (pctxt, &pvalue->arithmeticCoding);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->arithmeticCoding);

   invokeEndElement (pctxt, "arithmeticCoding", -1);

   /* decode temporalSpatialTradeOffCapability */

   invokeStartElement (pctxt, "temporalSpatialTradeOffCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->temporalSpatialTradeOffCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->temporalSpatialTradeOffCapability);

   invokeEndElement (pctxt, "temporalSpatialTradeOffCapability", -1);

   /* decode slowSqcifMPI */

   if (pvalue->m.slowSqcifMPIPresent) {
      invokeStartElement (pctxt, "slowSqcifMPI", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->slowSqcifMPI, 1U, 3600U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->slowSqcifMPI);

      invokeEndElement (pctxt, "slowSqcifMPI", -1);
   }

   /* decode slowQcifMPI */

   if (pvalue->m.slowQcifMPIPresent) {
      invokeStartElement (pctxt, "slowQcifMPI", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->slowQcifMPI, 1U, 3600U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->slowQcifMPI);

      invokeEndElement (pctxt, "slowQcifMPI", -1);
   }

   /* decode slowCifMPI */

   if (pvalue->m.slowCifMPIPresent) {
      invokeStartElement (pctxt, "slowCifMPI", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->slowCifMPI, 1U, 3600U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->slowCifMPI);

      invokeEndElement (pctxt, "slowCifMPI", -1);
   }

   /* decode slowCif4MPI */

   if (pvalue->m.slowCif4MPIPresent) {
      invokeStartElement (pctxt, "slowCif4MPI", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->slowCif4MPI, 1U, 3600U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->slowCif4MPI);

      invokeEndElement (pctxt, "slowCif4MPI", -1);
   }

   /* decode slowCif16MPI */

   if (pvalue->m.slowCif16MPIPresent) {
      invokeStartElement (pctxt, "slowCif16MPI", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->slowCif16MPI, 1U, 3600U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->slowCif16MPI);

      invokeEndElement (pctxt, "slowCif16MPI", -1);
   }

   /* decode errorCompensation */

   invokeStartElement (pctxt, "errorCompensation", -1);

   stat = DECODEBIT (pctxt, &pvalue->errorCompensation);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->errorCompensation);

   invokeEndElement (pctxt, "errorCompensation", -1);

   /* decode h263Options */

   if (pvalue->m.h263OptionsPresent) {
      invokeStartElement (pctxt, "h263Options", -1);

      stat = asn1PD_H245H263Options (pctxt, &pvalue->h263Options);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "h263Options", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EnhancementLayerInfo_snrEnhancement                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EnhancementLayerInfo_snrEnhancement (OOCTXT* pctxt, H245EnhancementLayerInfo_snrEnhancement* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 14, 0 };
   int stat = ASN_OK;
   H245EnhancementOptions* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245EnhancementOptions);

      stat = asn1PD_H245EnhancementOptions (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EnhancementLayerInfo_spatialEnhancement                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EnhancementLayerInfo_spatialEnhancement (OOCTXT* pctxt, H245EnhancementLayerInfo_spatialEnhancement* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 14, 0 };
   int stat = ASN_OK;
   H245EnhancementOptions* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245EnhancementOptions);

      stat = asn1PD_H245EnhancementOptions (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BEnhancementParameters                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245BEnhancementParameters (OOCTXT* pctxt, H245BEnhancementParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode enhancementOptions */

   invokeStartElement (pctxt, "enhancementOptions", -1);

   stat = asn1PD_H245EnhancementOptions (pctxt, &pvalue->enhancementOptions);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "enhancementOptions", -1);

   /* decode numberOfBPictures */

   invokeStartElement (pctxt, "numberOfBPictures", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->numberOfBPictures, 1U, 64U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->numberOfBPictures);

   invokeEndElement (pctxt, "numberOfBPictures", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EnhancementLayerInfo_bPictureEnhancement                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EnhancementLayerInfo_bPictureEnhancement (OOCTXT* pctxt, H245EnhancementLayerInfo_bPictureEnhancement* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 14, 0 };
   int stat = ASN_OK;
   H245BEnhancementParameters* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245BEnhancementParameters);

      stat = asn1PD_H245BEnhancementParameters (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EnhancementLayerInfo                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EnhancementLayerInfo (OOCTXT* pctxt, H245EnhancementLayerInfo* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.snrEnhancementPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.spatialEnhancementPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.bPictureEnhancementPresent = optbit;

   /* decode baseBitRateConstrained */

   invokeStartElement (pctxt, "baseBitRateConstrained", -1);

   stat = DECODEBIT (pctxt, &pvalue->baseBitRateConstrained);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->baseBitRateConstrained);

   invokeEndElement (pctxt, "baseBitRateConstrained", -1);

   /* decode snrEnhancement */

   if (pvalue->m.snrEnhancementPresent) {
      invokeStartElement (pctxt, "snrEnhancement", -1);

      stat = asn1PD_H245EnhancementLayerInfo_snrEnhancement (pctxt, &pvalue->snrEnhancement);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "snrEnhancement", -1);
   }

   /* decode spatialEnhancement */

   if (pvalue->m.spatialEnhancementPresent) {
      invokeStartElement (pctxt, "spatialEnhancement", -1);

      stat = asn1PD_H245EnhancementLayerInfo_spatialEnhancement (pctxt, &pvalue->spatialEnhancement);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "spatialEnhancement", -1);
   }

   /* decode bPictureEnhancement */

   if (pvalue->m.bPictureEnhancementPresent) {
      invokeStartElement (pctxt, "bPictureEnhancement", -1);

      stat = asn1PD_H245EnhancementLayerInfo_bPictureEnhancement (pctxt, &pvalue->bPictureEnhancement);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "bPictureEnhancement", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263VideoCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H263VideoCapability (OOCTXT* pctxt, H245H263VideoCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.sqcifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.qcifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cifMPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cif4MPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.cif16MPIPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.hrd_BPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.bppMaxKbPresent = optbit;

   /* decode sqcifMPI */

   if (pvalue->m.sqcifMPIPresent) {
      invokeStartElement (pctxt, "sqcifMPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->sqcifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->sqcifMPI);

      invokeEndElement (pctxt, "sqcifMPI", -1);
   }

   /* decode qcifMPI */

   if (pvalue->m.qcifMPIPresent) {
      invokeStartElement (pctxt, "qcifMPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->qcifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->qcifMPI);

      invokeEndElement (pctxt, "qcifMPI", -1);
   }

   /* decode cifMPI */

   if (pvalue->m.cifMPIPresent) {
      invokeStartElement (pctxt, "cifMPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->cifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cifMPI);

      invokeEndElement (pctxt, "cifMPI", -1);
   }

   /* decode cif4MPI */

   if (pvalue->m.cif4MPIPresent) {
      invokeStartElement (pctxt, "cif4MPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->cif4MPI, 1U, 32U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cif4MPI);

      invokeEndElement (pctxt, "cif4MPI", -1);
   }

   /* decode cif16MPI */

   if (pvalue->m.cif16MPIPresent) {
      invokeStartElement (pctxt, "cif16MPI", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->cif16MPI, 1U, 32U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->cif16MPI);

      invokeEndElement (pctxt, "cif16MPI", -1);
   }

   /* decode maxBitRate */

   invokeStartElement (pctxt, "maxBitRate", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->maxBitRate, 1U, 192400U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxBitRate);

   invokeEndElement (pctxt, "maxBitRate", -1);

   /* decode unrestrictedVector */

   invokeStartElement (pctxt, "unrestrictedVector", -1);

   stat = DECODEBIT (pctxt, &pvalue->unrestrictedVector);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->unrestrictedVector);

   invokeEndElement (pctxt, "unrestrictedVector", -1);

   /* decode arithmeticCoding */

   invokeStartElement (pctxt, "arithmeticCoding", -1);

   stat = DECODEBIT (pctxt, &pvalue->arithmeticCoding);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->arithmeticCoding);

   invokeEndElement (pctxt, "arithmeticCoding", -1);

   /* decode advancedPrediction */

   invokeStartElement (pctxt, "advancedPrediction", -1);

   stat = DECODEBIT (pctxt, &pvalue->advancedPrediction);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->advancedPrediction);

   invokeEndElement (pctxt, "advancedPrediction", -1);

   /* decode pbFrames */

   invokeStartElement (pctxt, "pbFrames", -1);

   stat = DECODEBIT (pctxt, &pvalue->pbFrames);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->pbFrames);

   invokeEndElement (pctxt, "pbFrames", -1);

   /* decode temporalSpatialTradeOffCapability */

   invokeStartElement (pctxt, "temporalSpatialTradeOffCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->temporalSpatialTradeOffCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->temporalSpatialTradeOffCapability);

   invokeEndElement (pctxt, "temporalSpatialTradeOffCapability", -1);

   /* decode hrd_B */

   if (pvalue->m.hrd_BPresent) {
      invokeStartElement (pctxt, "hrd_B", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->hrd_B, 0U, 524287U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->hrd_B);

      invokeEndElement (pctxt, "hrd_B", -1);
   }

   /* decode bppMaxKb */

   if (pvalue->m.bppMaxKbPresent) {
      invokeStartElement (pctxt, "bppMaxKb", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->bppMaxKb, 0U, 65535U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->bppMaxKb);

      invokeEndElement (pctxt, "bppMaxKb", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 8 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.slowSqcifMPIPresent = 1;

                     invokeStartElement (pctxt, "slowSqcifMPI", -1);

                     stat = decodeConsUInt16 (pctxt, &pvalue->slowSqcifMPI, 1U, 3600U);
                     if (stat != ASN_OK) return stat;
                     invokeUIntValue (pctxt, pvalue->slowSqcifMPI);

                     invokeEndElement (pctxt, "slowSqcifMPI", -1);
                     break;

                  case 1:
                     pvalue->m.slowQcifMPIPresent = 1;

                     invokeStartElement (pctxt, "slowQcifMPI", -1);

                     stat = decodeConsUInt16 (pctxt, &pvalue->slowQcifMPI, 1U, 3600U);
                     if (stat != ASN_OK) return stat;
                     invokeUIntValue (pctxt, pvalue->slowQcifMPI);

                     invokeEndElement (pctxt, "slowQcifMPI", -1);
                     break;

                  case 2:
                     pvalue->m.slowCifMPIPresent = 1;

                     invokeStartElement (pctxt, "slowCifMPI", -1);

                     stat = decodeConsUInt16 (pctxt, &pvalue->slowCifMPI, 1U, 3600U);
                     if (stat != ASN_OK) return stat;
                     invokeUIntValue (pctxt, pvalue->slowCifMPI);

                     invokeEndElement (pctxt, "slowCifMPI", -1);
                     break;

                  case 3:
                     pvalue->m.slowCif4MPIPresent = 1;

                     invokeStartElement (pctxt, "slowCif4MPI", -1);

                     stat = decodeConsUInt16 (pctxt, &pvalue->slowCif4MPI, 1U, 3600U);
                     if (stat != ASN_OK) return stat;
                     invokeUIntValue (pctxt, pvalue->slowCif4MPI);

                     invokeEndElement (pctxt, "slowCif4MPI", -1);
                     break;

                  case 4:
                     pvalue->m.slowCif16MPIPresent = 1;

                     invokeStartElement (pctxt, "slowCif16MPI", -1);

                     stat = decodeConsUInt16 (pctxt, &pvalue->slowCif16MPI, 1U, 3600U);
                     if (stat != ASN_OK) return stat;
                     invokeUIntValue (pctxt, pvalue->slowCif16MPI);

                     invokeEndElement (pctxt, "slowCif16MPI", -1);
                     break;

                  case 5:
                     pvalue->m.errorCompensationPresent = 1;

                     invokeStartElement (pctxt, "errorCompensation", -1);

                     stat = DECODEBIT (pctxt, &pvalue->errorCompensation);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->errorCompensation);

                     invokeEndElement (pctxt, "errorCompensation", -1);
                     break;

                  case 6:
                     pvalue->m.enhancementLayerInfoPresent = 1;

                     invokeStartElement (pctxt, "enhancementLayerInfo", -1);

                     stat = asn1PD_H245EnhancementLayerInfo (pctxt, &pvalue->enhancementLayerInfo);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "enhancementLayerInfo", -1);
                     break;

                  case 7:
                     pvalue->m.h263OptionsPresent = 1;

                     invokeStartElement (pctxt, "h263Options", -1);

                     stat = asn1PD_H245H263Options (pctxt, &pvalue->h263Options);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "h263Options", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172VideoCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS11172VideoCapability (OOCTXT* pctxt, H245IS11172VideoCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.videoBitRatePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.vbvBufferSizePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.samplesPerLinePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.linesPerFramePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.pictureRatePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.luminanceSampleRatePresent = optbit;

   /* decode constrainedBitstream */

   invokeStartElement (pctxt, "constrainedBitstream", -1);

   stat = DECODEBIT (pctxt, &pvalue->constrainedBitstream);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->constrainedBitstream);

   invokeEndElement (pctxt, "constrainedBitstream", -1);

   /* decode videoBitRate */

   if (pvalue->m.videoBitRatePresent) {
      invokeStartElement (pctxt, "videoBitRate", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->videoBitRate, 0U, 1073741823U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->videoBitRate);

      invokeEndElement (pctxt, "videoBitRate", -1);
   }

   /* decode vbvBufferSize */

   if (pvalue->m.vbvBufferSizePresent) {
      invokeStartElement (pctxt, "vbvBufferSize", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->vbvBufferSize, 0U, 262143U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->vbvBufferSize);

      invokeEndElement (pctxt, "vbvBufferSize", -1);
   }

   /* decode samplesPerLine */

   if (pvalue->m.samplesPerLinePresent) {
      invokeStartElement (pctxt, "samplesPerLine", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->samplesPerLine, 0U, 16383U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->samplesPerLine);

      invokeEndElement (pctxt, "samplesPerLine", -1);
   }

   /* decode linesPerFrame */

   if (pvalue->m.linesPerFramePresent) {
      invokeStartElement (pctxt, "linesPerFrame", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->linesPerFrame, 0U, 16383U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->linesPerFrame);

      invokeEndElement (pctxt, "linesPerFrame", -1);
   }

   /* decode pictureRate */

   if (pvalue->m.pictureRatePresent) {
      invokeStartElement (pctxt, "pictureRate", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->pictureRate, 0U, 15U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->pictureRate);

      invokeEndElement (pctxt, "pictureRate", -1);
   }

   /* decode luminanceSampleRate */

   if (pvalue->m.luminanceSampleRatePresent) {
      invokeStartElement (pctxt, "luminanceSampleRate", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->luminanceSampleRate, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->luminanceSampleRate);

      invokeEndElement (pctxt, "luminanceSampleRate", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.videoBadMBsCapPresent = 1;

                     invokeStartElement (pctxt, "videoBadMBsCap", -1);

                     stat = DECODEBIT (pctxt, &pvalue->videoBadMBsCap);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->videoBadMBsCap);

                     invokeEndElement (pctxt, "videoBadMBsCap", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VideoCapability                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VideoCapability (OOCTXT* pctxt, H245VideoCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 4);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* h261VideoCapability */
         case 1:
            invokeStartElement (pctxt, "h261VideoCapability", -1);

            pvalue->u.h261VideoCapability = ALLOC_ASN1ELEM (pctxt, H245H261VideoCapability);

            stat = asn1PD_H245H261VideoCapability (pctxt, pvalue->u.h261VideoCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h261VideoCapability", -1);

            break;

         /* h262VideoCapability */
         case 2:
            invokeStartElement (pctxt, "h262VideoCapability", -1);

            pvalue->u.h262VideoCapability = ALLOC_ASN1ELEM (pctxt, H245H262VideoCapability);

            stat = asn1PD_H245H262VideoCapability (pctxt, pvalue->u.h262VideoCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h262VideoCapability", -1);

            break;

         /* h263VideoCapability */
         case 3:
            invokeStartElement (pctxt, "h263VideoCapability", -1);

            pvalue->u.h263VideoCapability = ALLOC_ASN1ELEM (pctxt, H245H263VideoCapability);

            stat = asn1PD_H245H263VideoCapability (pctxt, pvalue->u.h263VideoCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h263VideoCapability", -1);

            break;

         /* is11172VideoCapability */
         case 4:
            invokeStartElement (pctxt, "is11172VideoCapability", -1);

            pvalue->u.is11172VideoCapability = ALLOC_ASN1ELEM (pctxt, H245IS11172VideoCapability);

            stat = asn1PD_H245IS11172VideoCapability (pctxt, pvalue->u.is11172VideoCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "is11172VideoCapability", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 6;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* genericVideoCapability */
         case 6:
            invokeStartElement (pctxt, "genericVideoCapability", -1);

            pvalue->u.genericVideoCapability = ALLOC_ASN1ELEM (pctxt, H245GenericCapability);

            stat = asn1PD_H245GenericCapability (pctxt, pvalue->u.genericVideoCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "genericVideoCapability", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioCapability_g7231                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245AudioCapability_g7231 (OOCTXT* pctxt, H245AudioCapability_g7231* pvalue)
{
   int stat = ASN_OK;

   /* decode maxAl_sduAudioFrames */

   invokeStartElement (pctxt, "maxAl_sduAudioFrames", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maxAl_sduAudioFrames, 1U, 256U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxAl_sduAudioFrames);

   invokeEndElement (pctxt, "maxAl_sduAudioFrames", -1);

   /* decode silenceSuppression */

   invokeStartElement (pctxt, "silenceSuppression", -1);

   stat = DECODEBIT (pctxt, &pvalue->silenceSuppression);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->silenceSuppression);

   invokeEndElement (pctxt, "silenceSuppression", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172AudioCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS11172AudioCapability (OOCTXT* pctxt, H245IS11172AudioCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode audioLayer1 */

   invokeStartElement (pctxt, "audioLayer1", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioLayer1);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioLayer1);

   invokeEndElement (pctxt, "audioLayer1", -1);

   /* decode audioLayer2 */

   invokeStartElement (pctxt, "audioLayer2", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioLayer2);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioLayer2);

   invokeEndElement (pctxt, "audioLayer2", -1);

   /* decode audioLayer3 */

   invokeStartElement (pctxt, "audioLayer3", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioLayer3);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioLayer3);

   invokeEndElement (pctxt, "audioLayer3", -1);

   /* decode audioSampling32k */

   invokeStartElement (pctxt, "audioSampling32k", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioSampling32k);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioSampling32k);

   invokeEndElement (pctxt, "audioSampling32k", -1);

   /* decode audioSampling44k1 */

   invokeStartElement (pctxt, "audioSampling44k1", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioSampling44k1);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioSampling44k1);

   invokeEndElement (pctxt, "audioSampling44k1", -1);

   /* decode audioSampling48k */

   invokeStartElement (pctxt, "audioSampling48k", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioSampling48k);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioSampling48k);

   invokeEndElement (pctxt, "audioSampling48k", -1);

   /* decode singleChannel */

   invokeStartElement (pctxt, "singleChannel", -1);

   stat = DECODEBIT (pctxt, &pvalue->singleChannel);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->singleChannel);

   invokeEndElement (pctxt, "singleChannel", -1);

   /* decode twoChannels */

   invokeStartElement (pctxt, "twoChannels", -1);

   stat = DECODEBIT (pctxt, &pvalue->twoChannels);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->twoChannels);

   invokeEndElement (pctxt, "twoChannels", -1);

   /* decode bitRate */

   invokeStartElement (pctxt, "bitRate", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->bitRate, 1U, 448U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->bitRate);

   invokeEndElement (pctxt, "bitRate", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS13818AudioCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS13818AudioCapability (OOCTXT* pctxt, H245IS13818AudioCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode audioLayer1 */

   invokeStartElement (pctxt, "audioLayer1", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioLayer1);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioLayer1);

   invokeEndElement (pctxt, "audioLayer1", -1);

   /* decode audioLayer2 */

   invokeStartElement (pctxt, "audioLayer2", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioLayer2);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioLayer2);

   invokeEndElement (pctxt, "audioLayer2", -1);

   /* decode audioLayer3 */

   invokeStartElement (pctxt, "audioLayer3", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioLayer3);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioLayer3);

   invokeEndElement (pctxt, "audioLayer3", -1);

   /* decode audioSampling16k */

   invokeStartElement (pctxt, "audioSampling16k", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioSampling16k);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioSampling16k);

   invokeEndElement (pctxt, "audioSampling16k", -1);

   /* decode audioSampling22k05 */

   invokeStartElement (pctxt, "audioSampling22k05", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioSampling22k05);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioSampling22k05);

   invokeEndElement (pctxt, "audioSampling22k05", -1);

   /* decode audioSampling24k */

   invokeStartElement (pctxt, "audioSampling24k", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioSampling24k);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioSampling24k);

   invokeEndElement (pctxt, "audioSampling24k", -1);

   /* decode audioSampling32k */

   invokeStartElement (pctxt, "audioSampling32k", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioSampling32k);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioSampling32k);

   invokeEndElement (pctxt, "audioSampling32k", -1);

   /* decode audioSampling44k1 */

   invokeStartElement (pctxt, "audioSampling44k1", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioSampling44k1);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioSampling44k1);

   invokeEndElement (pctxt, "audioSampling44k1", -1);

   /* decode audioSampling48k */

   invokeStartElement (pctxt, "audioSampling48k", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioSampling48k);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioSampling48k);

   invokeEndElement (pctxt, "audioSampling48k", -1);

   /* decode singleChannel */

   invokeStartElement (pctxt, "singleChannel", -1);

   stat = DECODEBIT (pctxt, &pvalue->singleChannel);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->singleChannel);

   invokeEndElement (pctxt, "singleChannel", -1);

   /* decode twoChannels */

   invokeStartElement (pctxt, "twoChannels", -1);

   stat = DECODEBIT (pctxt, &pvalue->twoChannels);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->twoChannels);

   invokeEndElement (pctxt, "twoChannels", -1);

   /* decode threeChannels2_1 */

   invokeStartElement (pctxt, "threeChannels2_1", -1);

   stat = DECODEBIT (pctxt, &pvalue->threeChannels2_1);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->threeChannels2_1);

   invokeEndElement (pctxt, "threeChannels2_1", -1);

   /* decode threeChannels3_0 */

   invokeStartElement (pctxt, "threeChannels3_0", -1);

   stat = DECODEBIT (pctxt, &pvalue->threeChannels3_0);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->threeChannels3_0);

   invokeEndElement (pctxt, "threeChannels3_0", -1);

   /* decode fourChannels2_0_2_0 */

   invokeStartElement (pctxt, "fourChannels2_0_2_0", -1);

   stat = DECODEBIT (pctxt, &pvalue->fourChannels2_0_2_0);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->fourChannels2_0_2_0);

   invokeEndElement (pctxt, "fourChannels2_0_2_0", -1);

   /* decode fourChannels2_2 */

   invokeStartElement (pctxt, "fourChannels2_2", -1);

   stat = DECODEBIT (pctxt, &pvalue->fourChannels2_2);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->fourChannels2_2);

   invokeEndElement (pctxt, "fourChannels2_2", -1);

   /* decode fourChannels3_1 */

   invokeStartElement (pctxt, "fourChannels3_1", -1);

   stat = DECODEBIT (pctxt, &pvalue->fourChannels3_1);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->fourChannels3_1);

   invokeEndElement (pctxt, "fourChannels3_1", -1);

   /* decode fiveChannels3_0_2_0 */

   invokeStartElement (pctxt, "fiveChannels3_0_2_0", -1);

   stat = DECODEBIT (pctxt, &pvalue->fiveChannels3_0_2_0);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->fiveChannels3_0_2_0);

   invokeEndElement (pctxt, "fiveChannels3_0_2_0", -1);

   /* decode fiveChannels3_2 */

   invokeStartElement (pctxt, "fiveChannels3_2", -1);

   stat = DECODEBIT (pctxt, &pvalue->fiveChannels3_2);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->fiveChannels3_2);

   invokeEndElement (pctxt, "fiveChannels3_2", -1);

   /* decode lowFrequencyEnhancement */

   invokeStartElement (pctxt, "lowFrequencyEnhancement", -1);

   stat = DECODEBIT (pctxt, &pvalue->lowFrequencyEnhancement);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->lowFrequencyEnhancement);

   invokeEndElement (pctxt, "lowFrequencyEnhancement", -1);

   /* decode multilingual */

   invokeStartElement (pctxt, "multilingual", -1);

   stat = DECODEBIT (pctxt, &pvalue->multilingual);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->multilingual);

   invokeEndElement (pctxt, "multilingual", -1);

   /* decode bitRate */

   invokeStartElement (pctxt, "bitRate", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->bitRate, 1U, 1130U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->bitRate);

   invokeEndElement (pctxt, "bitRate", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  G7231AnnexCCapability_g723AnnexCAudioMode                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245G7231AnnexCCapability_g723AnnexCAudioMode (OOCTXT* pctxt, H245G7231AnnexCCapability_g723AnnexCAudioMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode highRateMode0 */

   invokeStartElement (pctxt, "highRateMode0", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->highRateMode0, 27U, 78U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->highRateMode0);

   invokeEndElement (pctxt, "highRateMode0", -1);

   /* decode highRateMode1 */

   invokeStartElement (pctxt, "highRateMode1", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->highRateMode1, 27U, 78U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->highRateMode1);

   invokeEndElement (pctxt, "highRateMode1", -1);

   /* decode lowRateMode0 */

   invokeStartElement (pctxt, "lowRateMode0", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->lowRateMode0, 23U, 66U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->lowRateMode0);

   invokeEndElement (pctxt, "lowRateMode0", -1);

   /* decode lowRateMode1 */

   invokeStartElement (pctxt, "lowRateMode1", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->lowRateMode1, 23U, 66U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->lowRateMode1);

   invokeEndElement (pctxt, "lowRateMode1", -1);

   /* decode sidMode0 */

   invokeStartElement (pctxt, "sidMode0", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->sidMode0, 6U, 17U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->sidMode0);

   invokeEndElement (pctxt, "sidMode0", -1);

   /* decode sidMode1 */

   invokeStartElement (pctxt, "sidMode1", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->sidMode1, 6U, 17U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->sidMode1);

   invokeEndElement (pctxt, "sidMode1", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  G7231AnnexCCapability                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245G7231AnnexCCapability (OOCTXT* pctxt, H245G7231AnnexCCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.g723AnnexCAudioModePresent = optbit;

   /* decode maxAl_sduAudioFrames */

   invokeStartElement (pctxt, "maxAl_sduAudioFrames", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maxAl_sduAudioFrames, 1U, 256U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxAl_sduAudioFrames);

   invokeEndElement (pctxt, "maxAl_sduAudioFrames", -1);

   /* decode silenceSuppression */

   invokeStartElement (pctxt, "silenceSuppression", -1);

   stat = DECODEBIT (pctxt, &pvalue->silenceSuppression);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->silenceSuppression);

   invokeEndElement (pctxt, "silenceSuppression", -1);

   /* decode g723AnnexCAudioMode */

   if (pvalue->m.g723AnnexCAudioModePresent) {
      invokeStartElement (pctxt, "g723AnnexCAudioMode", -1);

      stat = asn1PD_H245G7231AnnexCCapability_g723AnnexCAudioMode (pctxt, &pvalue->g723AnnexCAudioMode);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "g723AnnexCAudioMode", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GSMAudioCapability                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245GSMAudioCapability (OOCTXT* pctxt, H245GSMAudioCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode audioUnitSize */

   invokeStartElement (pctxt, "audioUnitSize", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->audioUnitSize, 1U, 256U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->audioUnitSize);

   invokeEndElement (pctxt, "audioUnitSize", -1);

   /* decode comfortNoise */

   invokeStartElement (pctxt, "comfortNoise", -1);

   stat = DECODEBIT (pctxt, &pvalue->comfortNoise);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->comfortNoise);

   invokeEndElement (pctxt, "comfortNoise", -1);

   /* decode scrambled */

   invokeStartElement (pctxt, "scrambled", -1);

   stat = DECODEBIT (pctxt, &pvalue->scrambled);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->scrambled);

   invokeEndElement (pctxt, "scrambled", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  G729Extensions                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245G729Extensions (OOCTXT* pctxt, H245G729Extensions* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.audioUnitPresent = optbit;

   /* decode audioUnit */

   if (pvalue->m.audioUnitPresent) {
      invokeStartElement (pctxt, "audioUnit", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->audioUnit, 1U, 256U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->audioUnit);

      invokeEndElement (pctxt, "audioUnit", -1);
   }

   /* decode annexA */

   invokeStartElement (pctxt, "annexA", -1);

   stat = DECODEBIT (pctxt, &pvalue->annexA);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->annexA);

   invokeEndElement (pctxt, "annexA", -1);

   /* decode annexB */

   invokeStartElement (pctxt, "annexB", -1);

   stat = DECODEBIT (pctxt, &pvalue->annexB);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->annexB);

   invokeEndElement (pctxt, "annexB", -1);

   /* decode annexD */

   invokeStartElement (pctxt, "annexD", -1);

   stat = DECODEBIT (pctxt, &pvalue->annexD);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->annexD);

   invokeEndElement (pctxt, "annexD", -1);

   /* decode annexE */

   invokeStartElement (pctxt, "annexE", -1);

   stat = DECODEBIT (pctxt, &pvalue->annexE);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->annexE);

   invokeEndElement (pctxt, "annexE", -1);

   /* decode annexF */

   invokeStartElement (pctxt, "annexF", -1);

   stat = DECODEBIT (pctxt, &pvalue->annexF);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->annexF);

   invokeEndElement (pctxt, "annexF", -1);

   /* decode annexG */

   invokeStartElement (pctxt, "annexG", -1);

   stat = DECODEBIT (pctxt, &pvalue->annexG);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->annexG);

   invokeEndElement (pctxt, "annexG", -1);

   /* decode annexH */

   invokeStartElement (pctxt, "annexH", -1);

   stat = DECODEBIT (pctxt, &pvalue->annexH);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->annexH);

   invokeEndElement (pctxt, "annexH", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VBDCapability                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VBDCapability (OOCTXT* pctxt, H245VBDCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode type */

   invokeStartElement (pctxt, "type", -1);

   pvalue->type = ALLOC_ASN1ELEM (pctxt, H245AudioCapability);

   stat = asn1PD_H245AudioCapability (pctxt, (H245AudioCapability*)pvalue->type);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "type", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NoPTAudioTelephonyEventCapability                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245NoPTAudioTelephonyEventCapability (OOCTXT* pctxt, H245NoPTAudioTelephonyEventCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode audioTelephoneEvent */

   invokeStartElement (pctxt, "audioTelephoneEvent", -1);

   stat = decodeVarWidthCharString (pctxt, &pvalue->audioTelephoneEvent);
   if (stat != ASN_OK) return stat;
   invokeCharStrValue (pctxt, pvalue->audioTelephoneEvent);

   invokeEndElement (pctxt, "audioTelephoneEvent", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NoPTAudioToneCapability                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245NoPTAudioToneCapability (OOCTXT* pctxt, H245NoPTAudioToneCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioCapability                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245AudioCapability (OOCTXT* pctxt, H245AudioCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 13);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* g711Alaw64k */
         case 1:
            invokeStartElement (pctxt, "g711Alaw64k", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g711Alaw64k, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g711Alaw64k);

            invokeEndElement (pctxt, "g711Alaw64k", -1);

            break;

         /* g711Alaw56k */
         case 2:
            invokeStartElement (pctxt, "g711Alaw56k", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g711Alaw56k, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g711Alaw56k);

            invokeEndElement (pctxt, "g711Alaw56k", -1);

            break;

         /* g711Ulaw64k */
         case 3:
            invokeStartElement (pctxt, "g711Ulaw64k", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g711Ulaw64k, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g711Ulaw64k);

            invokeEndElement (pctxt, "g711Ulaw64k", -1);

            break;

         /* g711Ulaw56k */
         case 4:
            invokeStartElement (pctxt, "g711Ulaw56k", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g711Ulaw56k, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g711Ulaw56k);

            invokeEndElement (pctxt, "g711Ulaw56k", -1);

            break;

         /* g722_64k */
         case 5:
            invokeStartElement (pctxt, "g722_64k", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g722_64k, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g722_64k);

            invokeEndElement (pctxt, "g722_64k", -1);

            break;

         /* g722_56k */
         case 6:
            invokeStartElement (pctxt, "g722_56k", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g722_56k, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g722_56k);

            invokeEndElement (pctxt, "g722_56k", -1);

            break;

         /* g722_48k */
         case 7:
            invokeStartElement (pctxt, "g722_48k", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g722_48k, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g722_48k);

            invokeEndElement (pctxt, "g722_48k", -1);

            break;

         /* g7231 */
         case 8:
            invokeStartElement (pctxt, "g7231", -1);

            pvalue->u.g7231 = ALLOC_ASN1ELEM (pctxt, H245AudioCapability_g7231);

            stat = asn1PD_H245AudioCapability_g7231 (pctxt, pvalue->u.g7231);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "g7231", -1);

            break;

         /* g728 */
         case 9:
            invokeStartElement (pctxt, "g728", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g728, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g728);

            invokeEndElement (pctxt, "g728", -1);

            break;

         /* g729 */
         case 10:
            invokeStartElement (pctxt, "g729", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g729, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g729);

            invokeEndElement (pctxt, "g729", -1);

            break;

         /* g729AnnexA */
         case 11:
            invokeStartElement (pctxt, "g729AnnexA", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g729AnnexA, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g729AnnexA);

            invokeEndElement (pctxt, "g729AnnexA", -1);

            break;

         /* is11172AudioCapability */
         case 12:
            invokeStartElement (pctxt, "is11172AudioCapability", -1);

            pvalue->u.is11172AudioCapability = ALLOC_ASN1ELEM (pctxt, H245IS11172AudioCapability);

            stat = asn1PD_H245IS11172AudioCapability (pctxt, pvalue->u.is11172AudioCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "is11172AudioCapability", -1);

            break;

         /* is13818AudioCapability */
         case 13:
            invokeStartElement (pctxt, "is13818AudioCapability", -1);

            pvalue->u.is13818AudioCapability = ALLOC_ASN1ELEM (pctxt, H245IS13818AudioCapability);

            stat = asn1PD_H245IS13818AudioCapability (pctxt, pvalue->u.is13818AudioCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "is13818AudioCapability", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 15;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* g729wAnnexB */
         case 15:
            invokeStartElement (pctxt, "g729wAnnexB", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g729wAnnexB, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g729wAnnexB);

            invokeEndElement (pctxt, "g729wAnnexB", -1);

            break;

         /* g729AnnexAwAnnexB */
         case 16:
            invokeStartElement (pctxt, "g729AnnexAwAnnexB", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g729AnnexAwAnnexB, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g729AnnexAwAnnexB);

            invokeEndElement (pctxt, "g729AnnexAwAnnexB", -1);

            break;

         /* g7231AnnexCCapability */
         case 17:
            invokeStartElement (pctxt, "g7231AnnexCCapability", -1);

            pvalue->u.g7231AnnexCCapability = ALLOC_ASN1ELEM (pctxt, H245G7231AnnexCCapability);

            stat = asn1PD_H245G7231AnnexCCapability (pctxt, pvalue->u.g7231AnnexCCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "g7231AnnexCCapability", -1);

            break;

         /* gsmFullRate */
         case 18:
            invokeStartElement (pctxt, "gsmFullRate", -1);

            pvalue->u.gsmFullRate = ALLOC_ASN1ELEM (pctxt, H245GSMAudioCapability);

            stat = asn1PD_H245GSMAudioCapability (pctxt, pvalue->u.gsmFullRate);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "gsmFullRate", -1);

            break;

         /* gsmHalfRate */
         case 19:
            invokeStartElement (pctxt, "gsmHalfRate", -1);

            pvalue->u.gsmHalfRate = ALLOC_ASN1ELEM (pctxt, H245GSMAudioCapability);

            stat = asn1PD_H245GSMAudioCapability (pctxt, pvalue->u.gsmHalfRate);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "gsmHalfRate", -1);

            break;

         /* gsmEnhancedFullRate */
         case 20:
            invokeStartElement (pctxt, "gsmEnhancedFullRate", -1);

            pvalue->u.gsmEnhancedFullRate = ALLOC_ASN1ELEM (pctxt, H245GSMAudioCapability);

            stat = asn1PD_H245GSMAudioCapability (pctxt, pvalue->u.gsmEnhancedFullRate);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "gsmEnhancedFullRate", -1);

            break;

         /* genericAudioCapability */
         case 21:
            invokeStartElement (pctxt, "genericAudioCapability", -1);

            pvalue->u.genericAudioCapability = ALLOC_ASN1ELEM (pctxt, H245GenericCapability);

            stat = asn1PD_H245GenericCapability (pctxt, pvalue->u.genericAudioCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "genericAudioCapability", -1);

            break;

         /* g729Extensions */
         case 22:
            invokeStartElement (pctxt, "g729Extensions", -1);

            pvalue->u.g729Extensions = ALLOC_ASN1ELEM (pctxt, H245G729Extensions);

            stat = asn1PD_H245G729Extensions (pctxt, pvalue->u.g729Extensions);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "g729Extensions", -1);

            break;

         /* vbd */
         case 23:
            invokeStartElement (pctxt, "vbd", -1);

            pvalue->u.vbd = ALLOC_ASN1ELEM (pctxt, H245VBDCapability);

            stat = asn1PD_H245VBDCapability (pctxt, pvalue->u.vbd);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "vbd", -1);

            break;

         /* audioTelephonyEvent */
         case 24:
            invokeStartElement (pctxt, "audioTelephonyEvent", -1);

            pvalue->u.audioTelephonyEvent = ALLOC_ASN1ELEM (pctxt, H245NoPTAudioTelephonyEventCapability);

            stat = asn1PD_H245NoPTAudioTelephonyEventCapability (pctxt, pvalue->u.audioTelephonyEvent);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "audioTelephonyEvent", -1);

            break;

         /* audioTone */
         case 25:
            invokeStartElement (pctxt, "audioTone", -1);

            pvalue->u.audioTone = ALLOC_ASN1ELEM (pctxt, H245NoPTAudioToneCapability);

            stat = asn1PD_H245NoPTAudioToneCapability (pctxt, pvalue->u.audioTone);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "audioTone", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Capability_h233EncryptionReceiveCapability                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245Capability_h233EncryptionReceiveCapability (OOCTXT* pctxt, H245Capability_h233EncryptionReceiveCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode h233IVResponseTime */

   invokeStartElement (pctxt, "h233IVResponseTime", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->h233IVResponseTime, 0U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->h233IVResponseTime);

   invokeEndElement (pctxt, "h233IVResponseTime", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245NonStandardParameter                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SeqOfH245NonStandardParameter (OOCTXT* pctxt, H245_SeqOfH245NonStandardParameter* pvalue)
{
   int stat = ASN_OK;
   H245NonStandardParameter* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;
   int lstat;

   dListInit (pvalue);

   for (;;) {
      /* decode length determinant */

      lstat = decodeLength (pctxt, &count);
      if (lstat != ASN_OK && lstat != ASN_OK_FRAG) {
         return lstat;
      }

      /* decode elements */

      for (xx1 = 0; xx1 < count; xx1++) {
         invokeStartElement (pctxt, "elem", xx1);

         pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245NonStandardParameter);

         stat = asn1PD_H245NonStandardParameter (pctxt, pdata);
         if (stat != ASN_OK) return stat;
         invokeEndElement (pctxt, "elem", xx1);

         dListAppendNode (pctxt, pvalue, pdata);
      }

      if(lstat == ASN_OK) break;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceCapability                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceCapability (OOCTXT* pctxt, H245ConferenceCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonStandardDataPresent = optbit;

   /* decode nonStandardData */

   if (pvalue->m.nonStandardDataPresent) {
      invokeStartElement (pctxt, "nonStandardData", -1);

      stat = asn1PD_H245_SeqOfH245NonStandardParameter (pctxt, &pvalue->nonStandardData);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "nonStandardData", -1);
   }

   /* decode chairControlCapability */

   invokeStartElement (pctxt, "chairControlCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->chairControlCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->chairControlCapability);

   invokeEndElement (pctxt, "chairControlCapability", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 2 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.videoIndicateMixingCapabilityPresent = 1;

                     invokeStartElement (pctxt, "videoIndicateMixingCapability", -1);

                     stat = DECODEBIT (pctxt, &pvalue->videoIndicateMixingCapability);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->videoIndicateMixingCapability);

                     invokeEndElement (pctxt, "videoIndicateMixingCapability", -1);
                     break;

                  case 1:
                     pvalue->m.multipointVisualizationCapabilityPresent = 1;

                     invokeStartElement (pctxt, "multipointVisualizationCapability", -1);

                     stat = DECODEBIT (pctxt, &pvalue->multipointVisualizationCapability);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->multipointVisualizationCapability);

                     invokeEndElement (pctxt, "multipointVisualizationCapability", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaEncryptionAlgorithm                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MediaEncryptionAlgorithm (OOCTXT* pctxt, H245MediaEncryptionAlgorithm* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* algorithm */
         case 1:
            invokeStartElement (pctxt, "algorithm", -1);

            pvalue->u.algorithm = ALLOC_ASN1ELEM (pctxt, ASN1OBJID);

            stat = decodeObjectIdentifier (pctxt, pvalue->u.algorithm);
            if (stat != ASN_OK) return stat;
            invokeOidValue (pctxt, pvalue->u.algorithm->numids, pvalue->u.algorithm->subid);

            invokeEndElement (pctxt, "algorithm", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionCapability                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EncryptionCapability (OOCTXT* pctxt, H245EncryptionCapability* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245MediaEncryptionAlgorithm* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245MediaEncryptionAlgorithm);

      stat = asn1PD_H245MediaEncryptionAlgorithm (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AuthenticationCapability                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245AuthenticationCapability (OOCTXT* pctxt, H245AuthenticationCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonStandardPresent = optbit;

   /* decode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      invokeStartElement (pctxt, "nonStandard", -1);

      stat = asn1PD_H245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "nonStandard", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.antiSpamAlgorithmPresent = 1;

                     invokeStartElement (pctxt, "antiSpamAlgorithm", -1);

                     stat = decodeObjectIdentifier (pctxt, &pvalue->antiSpamAlgorithm);
                     if (stat != ASN_OK) return stat;
                     invokeOidValue (pctxt, pvalue->antiSpamAlgorithm.numids, pvalue->antiSpamAlgorithm.subid);

                     invokeEndElement (pctxt, "antiSpamAlgorithm", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IntegrityCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IntegrityCapability (OOCTXT* pctxt, H245IntegrityCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonStandardPresent = optbit;

   /* decode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      invokeStartElement (pctxt, "nonStandard", -1);

      stat = asn1PD_H245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "nonStandard", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionAuthenticationAndIntegrity                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EncryptionAuthenticationAndIntegrity (OOCTXT* pctxt, H245EncryptionAuthenticationAndIntegrity* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.encryptionCapabilityPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.authenticationCapabilityPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.integrityCapabilityPresent = optbit;

   /* decode encryptionCapability */

   if (pvalue->m.encryptionCapabilityPresent) {
      invokeStartElement (pctxt, "encryptionCapability", -1);

      stat = asn1PD_H245EncryptionCapability (pctxt, &pvalue->encryptionCapability);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "encryptionCapability", -1);
   }

   /* decode authenticationCapability */

   if (pvalue->m.authenticationCapabilityPresent) {
      invokeStartElement (pctxt, "authenticationCapability", -1);

      stat = asn1PD_H245AuthenticationCapability (pctxt, &pvalue->authenticationCapability);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "authenticationCapability", -1);
   }

   /* decode integrityCapability */

   if (pvalue->m.integrityCapabilityPresent) {
      invokeStartElement (pctxt, "integrityCapability", -1);

      stat = asn1PD_H245IntegrityCapability (pctxt, &pvalue->integrityCapability);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "integrityCapability", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H235SecurityCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H235SecurityCapability (OOCTXT* pctxt, H245H235SecurityCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode encryptionAuthenticationAndIntegrity */

   invokeStartElement (pctxt, "encryptionAuthenticationAndIntegrity", -1);

   stat = asn1PD_H245EncryptionAuthenticationAndIntegrity (pctxt, &pvalue->encryptionAuthenticationAndIntegrity);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "encryptionAuthenticationAndIntegrity", -1);

   /* decode mediaCapability */

   invokeStartElement (pctxt, "mediaCapability", -1);

   stat = asn1PD_H245CapabilityTableEntryNumber (pctxt, &pvalue->mediaCapability);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "mediaCapability", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UserInputCapability_nonStandard                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UserInputCapability_nonStandard (OOCTXT* pctxt, H245UserInputCapability_nonStandard* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   H245NonStandardParameter* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245NonStandardParameter);

      stat = asn1PD_H245NonStandardParameter (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UserInputCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UserInputCapability (OOCTXT* pctxt, H245UserInputCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 5);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245UserInputCapability_nonStandard);

            stat = asn1PD_H245UserInputCapability_nonStandard (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* basicString */
         case 1:
            invokeStartElement (pctxt, "basicString", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "basicString", -1);

            break;

         /* iA5String */
         case 2:
            invokeStartElement (pctxt, "iA5String", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "iA5String", -1);

            break;

         /* generalString */
         case 3:
            invokeStartElement (pctxt, "generalString", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "generalString", -1);

            break;

         /* dtmf */
         case 4:
            invokeStartElement (pctxt, "dtmf", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "dtmf", -1);

            break;

         /* hookflash */
         case 5:
            invokeStartElement (pctxt, "hookflash", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "hookflash", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 7;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* extendedAlphanumeric */
         case 7:
            invokeStartElement (pctxt, "extendedAlphanumeric", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "extendedAlphanumeric", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexFormat                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexFormat (OOCTXT* pctxt, H245MultiplexFormat* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* h222Capability */
         case 1:
            invokeStartElement (pctxt, "h222Capability", -1);

            pvalue->u.h222Capability = ALLOC_ASN1ELEM (pctxt, H245H222Capability);

            stat = asn1PD_H245H222Capability (pctxt, pvalue->u.h222Capability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h222Capability", -1);

            break;

         /* h223Capability */
         case 2:
            invokeStartElement (pctxt, "h223Capability", -1);

            pvalue->u.h223Capability = ALLOC_ASN1ELEM (pctxt, H245H223Capability);

            stat = asn1PD_H245H223Capability (pctxt, pvalue->u.h223Capability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h223Capability", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AlternativeCapabilitySet                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245AlternativeCapabilitySet (OOCTXT* pctxt, H245AlternativeCapabilitySet* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = asn1PD_H245CapabilityTableEntryNumber (pctxt, &pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexedStreamCapability_capabilityOnMuxStream         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexedStreamCapability_capabilityOnMuxStream (OOCTXT* pctxt, H245MultiplexedStreamCapability_capabilityOnMuxStream* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245AlternativeCapabilitySet* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245AlternativeCapabilitySet);

      stat = asn1PD_H245AlternativeCapabilitySet (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexedStreamCapability                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexedStreamCapability (OOCTXT* pctxt, H245MultiplexedStreamCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.capabilityOnMuxStreamPresent = optbit;

   /* decode multiplexFormat */

   invokeStartElement (pctxt, "multiplexFormat", -1);

   stat = asn1PD_H245MultiplexFormat (pctxt, &pvalue->multiplexFormat);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "multiplexFormat", -1);

   /* decode controlOnMuxStream */

   invokeStartElement (pctxt, "controlOnMuxStream", -1);

   stat = DECODEBIT (pctxt, &pvalue->controlOnMuxStream);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->controlOnMuxStream);

   invokeEndElement (pctxt, "controlOnMuxStream", -1);

   /* decode capabilityOnMuxStream */

   if (pvalue->m.capabilityOnMuxStreamPresent) {
      invokeStartElement (pctxt, "capabilityOnMuxStream", -1);

      stat = asn1PD_H245MultiplexedStreamCapability_capabilityOnMuxStream (pctxt, &pvalue->capabilityOnMuxStream);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "capabilityOnMuxStream", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioTelephonyEventCapability                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245AudioTelephonyEventCapability (OOCTXT* pctxt, H245AudioTelephonyEventCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode dynamicRTPPayloadType */

   invokeStartElement (pctxt, "dynamicRTPPayloadType", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->dynamicRTPPayloadType, 96U, 127U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->dynamicRTPPayloadType);

   invokeEndElement (pctxt, "dynamicRTPPayloadType", -1);

   /* decode audioTelephoneEvent */

   invokeStartElement (pctxt, "audioTelephoneEvent", -1);

   stat = decodeVarWidthCharString (pctxt, &pvalue->audioTelephoneEvent);
   if (stat != ASN_OK) return stat;
   invokeCharStrValue (pctxt, pvalue->audioTelephoneEvent);

   invokeEndElement (pctxt, "audioTelephoneEvent", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioToneCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245AudioToneCapability (OOCTXT* pctxt, H245AudioToneCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode dynamicRTPPayloadType */

   invokeStartElement (pctxt, "dynamicRTPPayloadType", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->dynamicRTPPayloadType, 96U, 127U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->dynamicRTPPayloadType);

   invokeEndElement (pctxt, "dynamicRTPPayloadType", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECCapability_rfc2733_separateStream                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECCapability_rfc2733_separateStream (OOCTXT* pctxt, H245FECCapability_rfc2733_separateStream* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode separatePort */

   invokeStartElement (pctxt, "separatePort", -1);

   stat = DECODEBIT (pctxt, &pvalue->separatePort);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->separatePort);

   invokeEndElement (pctxt, "separatePort", -1);

   /* decode samePort */

   invokeStartElement (pctxt, "samePort", -1);

   stat = DECODEBIT (pctxt, &pvalue->samePort);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->samePort);

   invokeEndElement (pctxt, "samePort", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECCapability_rfc2733                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECCapability_rfc2733 (OOCTXT* pctxt, H245FECCapability_rfc2733* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode redundancyEncoding */

   invokeStartElement (pctxt, "redundancyEncoding", -1);

   stat = DECODEBIT (pctxt, &pvalue->redundancyEncoding);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->redundancyEncoding);

   invokeEndElement (pctxt, "redundancyEncoding", -1);

   /* decode separateStream */

   invokeStartElement (pctxt, "separateStream", -1);

   stat = asn1PD_H245FECCapability_rfc2733_separateStream (pctxt, &pvalue->separateStream);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "separateStream", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECCapability                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECCapability (OOCTXT* pctxt, H245FECCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* rfc2733 */
         case 0:
            invokeStartElement (pctxt, "rfc2733", -1);

            pvalue->u.rfc2733 = ALLOC_ASN1ELEM (pctxt, H245FECCapability_rfc2733);

            stat = asn1PD_H245FECCapability_rfc2733 (pctxt, pvalue->u.rfc2733);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "rfc2733", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 2;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStreamCapability_capabilities              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplePayloadStreamCapability_capabilities (OOCTXT* pctxt, H245MultiplePayloadStreamCapability_capabilities* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245AlternativeCapabilitySet* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245AlternativeCapabilitySet);

      stat = asn1PD_H245AlternativeCapabilitySet (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStreamCapability                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplePayloadStreamCapability (OOCTXT* pctxt, H245MultiplePayloadStreamCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode capabilities */

   invokeStartElement (pctxt, "capabilities", -1);

   stat = asn1PD_H245MultiplePayloadStreamCapability_capabilities (pctxt, &pvalue->capabilities);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "capabilities", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Capability                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245Capability (OOCTXT* pctxt, H245Capability* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 11);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* receiveVideoCapability */
         case 1:
            invokeStartElement (pctxt, "receiveVideoCapability", -1);

            pvalue->u.receiveVideoCapability = ALLOC_ASN1ELEM (pctxt, H245VideoCapability);

            stat = asn1PD_H245VideoCapability (pctxt, pvalue->u.receiveVideoCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveVideoCapability", -1);

            break;

         /* transmitVideoCapability */
         case 2:
            invokeStartElement (pctxt, "transmitVideoCapability", -1);

            pvalue->u.transmitVideoCapability = ALLOC_ASN1ELEM (pctxt, H245VideoCapability);

            stat = asn1PD_H245VideoCapability (pctxt, pvalue->u.transmitVideoCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "transmitVideoCapability", -1);

            break;

         /* receiveAndTransmitVideoCapability */
         case 3:
            invokeStartElement (pctxt, "receiveAndTransmitVideoCapability", -1);

            pvalue->u.receiveAndTransmitVideoCapability = ALLOC_ASN1ELEM (pctxt, H245VideoCapability);

            stat = asn1PD_H245VideoCapability (pctxt, pvalue->u.receiveAndTransmitVideoCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveAndTransmitVideoCapability", -1);

            break;

         /* receiveAudioCapability */
         case 4:
            invokeStartElement (pctxt, "receiveAudioCapability", -1);

            pvalue->u.receiveAudioCapability = ALLOC_ASN1ELEM (pctxt, H245AudioCapability);

            stat = asn1PD_H245AudioCapability (pctxt, pvalue->u.receiveAudioCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveAudioCapability", -1);

            break;

         /* transmitAudioCapability */
         case 5:
            invokeStartElement (pctxt, "transmitAudioCapability", -1);

            pvalue->u.transmitAudioCapability = ALLOC_ASN1ELEM (pctxt, H245AudioCapability);

            stat = asn1PD_H245AudioCapability (pctxt, pvalue->u.transmitAudioCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "transmitAudioCapability", -1);

            break;

         /* receiveAndTransmitAudioCapability */
         case 6:
            invokeStartElement (pctxt, "receiveAndTransmitAudioCapability", -1);

            pvalue->u.receiveAndTransmitAudioCapability = ALLOC_ASN1ELEM (pctxt, H245AudioCapability);

            stat = asn1PD_H245AudioCapability (pctxt, pvalue->u.receiveAndTransmitAudioCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveAndTransmitAudioCapability", -1);

            break;

         /* receiveDataApplicationCapability */
         case 7:
            invokeStartElement (pctxt, "receiveDataApplicationCapability", -1);

            pvalue->u.receiveDataApplicationCapability = ALLOC_ASN1ELEM (pctxt, H245DataApplicationCapability);

            stat = asn1PD_H245DataApplicationCapability (pctxt, pvalue->u.receiveDataApplicationCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveDataApplicationCapability", -1);

            break;

         /* transmitDataApplicationCapability */
         case 8:
            invokeStartElement (pctxt, "transmitDataApplicationCapability", -1);

            pvalue->u.transmitDataApplicationCapability = ALLOC_ASN1ELEM (pctxt, H245DataApplicationCapability);

            stat = asn1PD_H245DataApplicationCapability (pctxt, pvalue->u.transmitDataApplicationCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "transmitDataApplicationCapability", -1);

            break;

         /* receiveAndTransmitDataApplicationCapability */
         case 9:
            invokeStartElement (pctxt, "receiveAndTransmitDataApplicationCapability", -1);

            pvalue->u.receiveAndTransmitDataApplicationCapability = ALLOC_ASN1ELEM (pctxt, H245DataApplicationCapability);

            stat = asn1PD_H245DataApplicationCapability (pctxt, pvalue->u.receiveAndTransmitDataApplicationCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveAndTransmitDataApplicationCapability", -1);

            break;

         /* h233EncryptionTransmitCapability */
         case 10:
            invokeStartElement (pctxt, "h233EncryptionTransmitCapability", -1);

            stat = DECODEBIT (pctxt, &pvalue->u.h233EncryptionTransmitCapability);
            if (stat != ASN_OK) return stat;
            invokeBoolValue (pctxt, pvalue->u.h233EncryptionTransmitCapability);

            invokeEndElement (pctxt, "h233EncryptionTransmitCapability", -1);

            break;

         /* h233EncryptionReceiveCapability */
         case 11:
            invokeStartElement (pctxt, "h233EncryptionReceiveCapability", -1);

            pvalue->u.h233EncryptionReceiveCapability = ALLOC_ASN1ELEM (pctxt, H245Capability_h233EncryptionReceiveCapability);

            stat = asn1PD_H245Capability_h233EncryptionReceiveCapability (pctxt, pvalue->u.h233EncryptionReceiveCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h233EncryptionReceiveCapability", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 13;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* conferenceCapability */
         case 13:
            invokeStartElement (pctxt, "conferenceCapability", -1);

            pvalue->u.conferenceCapability = ALLOC_ASN1ELEM (pctxt, H245ConferenceCapability);

            stat = asn1PD_H245ConferenceCapability (pctxt, pvalue->u.conferenceCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "conferenceCapability", -1);

            break;

         /* h235SecurityCapability */
         case 14:
            invokeStartElement (pctxt, "h235SecurityCapability", -1);

            pvalue->u.h235SecurityCapability = ALLOC_ASN1ELEM (pctxt, H245H235SecurityCapability);

            stat = asn1PD_H245H235SecurityCapability (pctxt, pvalue->u.h235SecurityCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h235SecurityCapability", -1);

            break;

         /* maxPendingReplacementFor */
         case 15:
            invokeStartElement (pctxt, "maxPendingReplacementFor", -1);

            stat = decodeConsUInt8 (pctxt, &pvalue->u.maxPendingReplacementFor, 0U, 255U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.maxPendingReplacementFor);

            invokeEndElement (pctxt, "maxPendingReplacementFor", -1);

            break;

         /* receiveUserInputCapability */
         case 16:
            invokeStartElement (pctxt, "receiveUserInputCapability", -1);

            pvalue->u.receiveUserInputCapability = ALLOC_ASN1ELEM (pctxt, H245UserInputCapability);

            stat = asn1PD_H245UserInputCapability (pctxt, pvalue->u.receiveUserInputCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveUserInputCapability", -1);

            break;

         /* transmitUserInputCapability */
         case 17:
            invokeStartElement (pctxt, "transmitUserInputCapability", -1);

            pvalue->u.transmitUserInputCapability = ALLOC_ASN1ELEM (pctxt, H245UserInputCapability);

            stat = asn1PD_H245UserInputCapability (pctxt, pvalue->u.transmitUserInputCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "transmitUserInputCapability", -1);

            break;

         /* receiveAndTransmitUserInputCapability */
         case 18:
            invokeStartElement (pctxt, "receiveAndTransmitUserInputCapability", -1);

            pvalue->u.receiveAndTransmitUserInputCapability = ALLOC_ASN1ELEM (pctxt, H245UserInputCapability);

            stat = asn1PD_H245UserInputCapability (pctxt, pvalue->u.receiveAndTransmitUserInputCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveAndTransmitUserInputCapability", -1);

            break;

         /* genericControlCapability */
         case 19:
            invokeStartElement (pctxt, "genericControlCapability", -1);

            pvalue->u.genericControlCapability = ALLOC_ASN1ELEM (pctxt, H245GenericCapability);

            stat = asn1PD_H245GenericCapability (pctxt, pvalue->u.genericControlCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "genericControlCapability", -1);

            break;

         /* receiveMultiplexedStreamCapability */
         case 20:
            invokeStartElement (pctxt, "receiveMultiplexedStreamCapability", -1);

            pvalue->u.receiveMultiplexedStreamCapability = ALLOC_ASN1ELEM (pctxt, H245MultiplexedStreamCapability);

            stat = asn1PD_H245MultiplexedStreamCapability (pctxt, pvalue->u.receiveMultiplexedStreamCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveMultiplexedStreamCapability", -1);

            break;

         /* transmitMultiplexedStreamCapability */
         case 21:
            invokeStartElement (pctxt, "transmitMultiplexedStreamCapability", -1);

            pvalue->u.transmitMultiplexedStreamCapability = ALLOC_ASN1ELEM (pctxt, H245MultiplexedStreamCapability);

            stat = asn1PD_H245MultiplexedStreamCapability (pctxt, pvalue->u.transmitMultiplexedStreamCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "transmitMultiplexedStreamCapability", -1);

            break;

         /* receiveAndTransmitMultiplexedStreamCapability */
         case 22:
            invokeStartElement (pctxt, "receiveAndTransmitMultiplexedStreamCapability", -1);

            pvalue->u.receiveAndTransmitMultiplexedStreamCapability = ALLOC_ASN1ELEM (pctxt, H245MultiplexedStreamCapability);

            stat = asn1PD_H245MultiplexedStreamCapability (pctxt, pvalue->u.receiveAndTransmitMultiplexedStreamCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveAndTransmitMultiplexedStreamCapability", -1);

            break;

         /* receiveRTPAudioTelephonyEventCapability */
         case 23:
            invokeStartElement (pctxt, "receiveRTPAudioTelephonyEventCapability", -1);

            pvalue->u.receiveRTPAudioTelephonyEventCapability = ALLOC_ASN1ELEM (pctxt, H245AudioTelephonyEventCapability);

            stat = asn1PD_H245AudioTelephonyEventCapability (pctxt, pvalue->u.receiveRTPAudioTelephonyEventCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveRTPAudioTelephonyEventCapability", -1);

            break;

         /* receiveRTPAudioToneCapability */
         case 24:
            invokeStartElement (pctxt, "receiveRTPAudioToneCapability", -1);

            pvalue->u.receiveRTPAudioToneCapability = ALLOC_ASN1ELEM (pctxt, H245AudioToneCapability);

            stat = asn1PD_H245AudioToneCapability (pctxt, pvalue->u.receiveRTPAudioToneCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "receiveRTPAudioToneCapability", -1);

            break;

         /* fecCapability */
         case 25:
            invokeStartElement (pctxt, "fecCapability", -1);

            pvalue->u.fecCapability = ALLOC_ASN1ELEM (pctxt, H245FECCapability);

            stat = asn1PD_H245FECCapability (pctxt, pvalue->u.fecCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "fecCapability", -1);

            break;

         /* multiplePayloadStreamCapability */
         case 26:
            invokeStartElement (pctxt, "multiplePayloadStreamCapability", -1);

            pvalue->u.multiplePayloadStreamCapability = ALLOC_ASN1ELEM (pctxt, H245MultiplePayloadStreamCapability);

            stat = asn1PD_H245MultiplePayloadStreamCapability (pctxt, pvalue->u.multiplePayloadStreamCapability);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multiplePayloadStreamCapability", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityTableEntry                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CapabilityTableEntry (OOCTXT* pctxt, H245CapabilityTableEntry* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL optbit;

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.capabilityPresent = optbit;

   /* decode capabilityTableEntryNumber */

   invokeStartElement (pctxt, "capabilityTableEntryNumber", -1);

   stat = asn1PD_H245CapabilityTableEntryNumber (pctxt, &pvalue->capabilityTableEntryNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "capabilityTableEntryNumber", -1);

   /* decode capability */

   if (pvalue->m.capabilityPresent) {
      invokeStartElement (pctxt, "capability", -1);

      stat = asn1PD_H245Capability (pctxt, &pvalue->capability);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "capability", -1);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySet_capabilityTable                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TerminalCapabilitySet_capabilityTable (OOCTXT* pctxt, H245TerminalCapabilitySet_capabilityTable* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245CapabilityTableEntry* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245CapabilityTableEntry);

      stat = asn1PD_H245CapabilityTableEntry (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityDescriptorNumber                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CapabilityDescriptorNumber (OOCTXT* pctxt, H245CapabilityDescriptorNumber* pvalue)
{
   int stat = ASN_OK;

   stat = decodeConsUInt8 (pctxt, pvalue, 0U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, *pvalue);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityDescriptor_simultaneousCapabilities             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CapabilityDescriptor_simultaneousCapabilities (OOCTXT* pctxt, H245CapabilityDescriptor_simultaneousCapabilities* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245AlternativeCapabilitySet* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245AlternativeCapabilitySet);

      stat = asn1PD_H245AlternativeCapabilitySet (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityDescriptor                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CapabilityDescriptor (OOCTXT* pctxt, H245CapabilityDescriptor* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL optbit;

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.simultaneousCapabilitiesPresent = optbit;

   /* decode capabilityDescriptorNumber */

   invokeStartElement (pctxt, "capabilityDescriptorNumber", -1);

   stat = asn1PD_H245CapabilityDescriptorNumber (pctxt, &pvalue->capabilityDescriptorNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "capabilityDescriptorNumber", -1);

   /* decode simultaneousCapabilities */

   if (pvalue->m.simultaneousCapabilitiesPresent) {
      invokeStartElement (pctxt, "simultaneousCapabilities", -1);

      stat = asn1PD_H245CapabilityDescriptor_simultaneousCapabilities (pctxt, &pvalue->simultaneousCapabilities);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "simultaneousCapabilities", -1);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySet_capabilityDescriptors               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TerminalCapabilitySet_capabilityDescriptors (OOCTXT* pctxt, H245TerminalCapabilitySet_capabilityDescriptors* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245CapabilityDescriptor* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245CapabilityDescriptor);

      stat = asn1PD_H245CapabilityDescriptor (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySet                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TerminalCapabilitySet (OOCTXT* pctxt, H245TerminalCapabilitySet* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.multiplexCapabilityPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.capabilityTablePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.capabilityDescriptorsPresent = optbit;

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode protocolIdentifier */

   invokeStartElement (pctxt, "protocolIdentifier", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->protocolIdentifier);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->protocolIdentifier.numids, pvalue->protocolIdentifier.subid);

   invokeEndElement (pctxt, "protocolIdentifier", -1);

   /* decode multiplexCapability */

   if (pvalue->m.multiplexCapabilityPresent) {
      invokeStartElement (pctxt, "multiplexCapability", -1);

      stat = asn1PD_H245MultiplexCapability (pctxt, &pvalue->multiplexCapability);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "multiplexCapability", -1);
   }

   /* decode capabilityTable */

   if (pvalue->m.capabilityTablePresent) {
      invokeStartElement (pctxt, "capabilityTable", -1);

      stat = asn1PD_H245TerminalCapabilitySet_capabilityTable (pctxt, &pvalue->capabilityTable);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "capabilityTable", -1);
   }

   /* decode capabilityDescriptors */

   if (pvalue->m.capabilityDescriptorsPresent) {
      invokeStartElement (pctxt, "capabilityDescriptors", -1);

      stat = asn1PD_H245TerminalCapabilitySet_capabilityDescriptors (pctxt, &pvalue->capabilityDescriptors);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "capabilityDescriptors", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LogicalChannelNumber                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245LogicalChannelNumber (OOCTXT* pctxt, H245LogicalChannelNumber* pvalue)
{
   int stat = ASN_OK;

   stat = decodeConsUInt16 (pctxt, pvalue, 1U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, *pvalue);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionMode                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EncryptionMode (OOCTXT* pctxt, H245EncryptionMode* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* h233Encryption */
         case 1:
            invokeStartElement (pctxt, "h233Encryption", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "h233Encryption", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingElement                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RedundancyEncodingElement (OOCTXT* pctxt, H245RedundancyEncodingElement* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.payloadTypePresent = optbit;

   /* decode dataType */

   invokeStartElement (pctxt, "dataType", -1);

   pvalue->dataType = ALLOC_ASN1ELEM (pctxt, H245DataType);

   stat = asn1PD_H245DataType (pctxt, (H245DataType*)pvalue->dataType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "dataType", -1);

   /* decode payloadType */

   if (pvalue->m.payloadTypePresent) {
      invokeStartElement (pctxt, "payloadType", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->payloadType, 0U, 127U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->payloadType);

      invokeEndElement (pctxt, "payloadType", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245RedundancyEncodingElement                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SeqOfH245RedundancyEncodingElement (OOCTXT* pctxt, H245_SeqOfH245RedundancyEncodingElement* pvalue)
{
   int stat = ASN_OK;
   H245RedundancyEncodingElement* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;
   int lstat;

   dListInit (pvalue);

   for (;;) {
      /* decode length determinant */

      lstat = decodeLength (pctxt, &count);
      if (lstat != ASN_OK && lstat != ASN_OK_FRAG) {
         return lstat;
      }

      /* decode elements */

      for (xx1 = 0; xx1 < count; xx1++) {
         invokeStartElement (pctxt, "elem", xx1);

         pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245RedundancyEncodingElement);

         stat = asn1PD_H245RedundancyEncodingElement (pctxt, pdata);
         if (stat != ASN_OK) return stat;
         invokeEndElement (pctxt, "elem", xx1);

         dListAppendNode (pctxt, pvalue, pdata);
      }

      if(lstat == ASN_OK) break;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncoding_rtpRedundancyEncoding                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RedundancyEncoding_rtpRedundancyEncoding (OOCTXT* pctxt, H245RedundancyEncoding_rtpRedundancyEncoding* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.primaryPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.secondaryPresent = optbit;

   /* decode primary */

   if (pvalue->m.primaryPresent) {
      invokeStartElement (pctxt, "primary", -1);

      stat = asn1PD_H245RedundancyEncodingElement (pctxt, &pvalue->primary);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "primary", -1);
   }

   /* decode secondary */

   if (pvalue->m.secondaryPresent) {
      invokeStartElement (pctxt, "secondary", -1);

      stat = asn1PD_H245_SeqOfH245RedundancyEncodingElement (pctxt, &pvalue->secondary);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "secondary", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncoding                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RedundancyEncoding (OOCTXT* pctxt, H245RedundancyEncoding* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.secondaryEncodingPresent = optbit;

   /* decode redundancyEncodingMethod */

   invokeStartElement (pctxt, "redundancyEncodingMethod", -1);

   stat = asn1PD_H245RedundancyEncodingMethod (pctxt, &pvalue->redundancyEncodingMethod);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "redundancyEncodingMethod", -1);

   /* decode secondaryEncoding */

   if (pvalue->m.secondaryEncodingPresent) {
      invokeStartElement (pctxt, "secondaryEncoding", -1);

      pvalue->secondaryEncoding = ALLOC_ASN1ELEM (pctxt, H245DataType);

      stat = asn1PD_H245DataType (pctxt, (H245DataType*)pvalue->secondaryEncoding);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "secondaryEncoding", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.rtpRedundancyEncodingPresent = 1;

                     invokeStartElement (pctxt, "rtpRedundancyEncoding", -1);

                     stat = asn1PD_H245RedundancyEncoding_rtpRedundancyEncoding (pctxt, &pvalue->rtpRedundancyEncoding);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "rtpRedundancyEncoding", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStreamElement                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplePayloadStreamElement (OOCTXT* pctxt, H245MultiplePayloadStreamElement* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.payloadTypePresent = optbit;

   /* decode dataType */

   invokeStartElement (pctxt, "dataType", -1);

   pvalue->dataType = ALLOC_ASN1ELEM (pctxt, H245DataType);

   stat = asn1PD_H245DataType (pctxt, (H245DataType*)pvalue->dataType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "dataType", -1);

   /* decode payloadType */

   if (pvalue->m.payloadTypePresent) {
      invokeStartElement (pctxt, "payloadType", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->payloadType, 0U, 127U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->payloadType);

      invokeEndElement (pctxt, "payloadType", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245MultiplePayloadStreamElement                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SeqOfH245MultiplePayloadStreamElement (OOCTXT* pctxt, H245_SeqOfH245MultiplePayloadStreamElement* pvalue)
{
   int stat = ASN_OK;
   H245MultiplePayloadStreamElement* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;
   int lstat;

   dListInit (pvalue);

   for (;;) {
      /* decode length determinant */

      lstat = decodeLength (pctxt, &count);
      if (lstat != ASN_OK && lstat != ASN_OK_FRAG) {
         return lstat;
      }

      /* decode elements */

      for (xx1 = 0; xx1 < count; xx1++) {
         invokeStartElement (pctxt, "elem", xx1);

         pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245MultiplePayloadStreamElement);

         stat = asn1PD_H245MultiplePayloadStreamElement (pctxt, pdata);
         if (stat != ASN_OK) return stat;
         invokeEndElement (pctxt, "elem", xx1);

         dListAppendNode (pctxt, pvalue, pdata);
      }

      if(lstat == ASN_OK) break;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStream                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplePayloadStream (OOCTXT* pctxt, H245MultiplePayloadStream* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode elements */

   invokeStartElement (pctxt, "elements", -1);

   stat = asn1PD_H245_SeqOfH245MultiplePayloadStreamElement (pctxt, &pvalue->elements);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "elements", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData_rfc2733_mode_separateStream_differentPort         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECData_rfc2733_mode_separateStream_differentPort (OOCTXT* pctxt, H245FECData_rfc2733_mode_separateStream_differentPort* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.protectedPayloadTypePresent = optbit;

   /* decode protectedSessionID */

   invokeStartElement (pctxt, "protectedSessionID", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->protectedSessionID, 1U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->protectedSessionID);

   invokeEndElement (pctxt, "protectedSessionID", -1);

   /* decode protectedPayloadType */

   if (pvalue->m.protectedPayloadTypePresent) {
      invokeStartElement (pctxt, "protectedPayloadType", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->protectedPayloadType, 0U, 127U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->protectedPayloadType);

      invokeEndElement (pctxt, "protectedPayloadType", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData_rfc2733_mode_separateStream_samePort              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECData_rfc2733_mode_separateStream_samePort (OOCTXT* pctxt, H245FECData_rfc2733_mode_separateStream_samePort* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode protectedPayloadType */

   invokeStartElement (pctxt, "protectedPayloadType", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->protectedPayloadType, 0U, 127U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->protectedPayloadType);

   invokeEndElement (pctxt, "protectedPayloadType", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData_rfc2733_mode_separateStream                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECData_rfc2733_mode_separateStream (OOCTXT* pctxt, H245FECData_rfc2733_mode_separateStream* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* differentPort */
         case 0:
            invokeStartElement (pctxt, "differentPort", -1);

            pvalue->u.differentPort = ALLOC_ASN1ELEM (pctxt, H245FECData_rfc2733_mode_separateStream_differentPort);

            stat = asn1PD_H245FECData_rfc2733_mode_separateStream_differentPort (pctxt, pvalue->u.differentPort);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "differentPort", -1);

            break;

         /* samePort */
         case 1:
            invokeStartElement (pctxt, "samePort", -1);

            pvalue->u.samePort = ALLOC_ASN1ELEM (pctxt, H245FECData_rfc2733_mode_separateStream_samePort);

            stat = asn1PD_H245FECData_rfc2733_mode_separateStream_samePort (pctxt, pvalue->u.samePort);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "samePort", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData_rfc2733_mode                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECData_rfc2733_mode (OOCTXT* pctxt, H245FECData_rfc2733_mode* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* redundancyEncoding */
         case 0:
            invokeStartElement (pctxt, "redundancyEncoding", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "redundancyEncoding", -1);

            break;

         /* separateStream */
         case 1:
            invokeStartElement (pctxt, "separateStream", -1);

            pvalue->u.separateStream = ALLOC_ASN1ELEM (pctxt, H245FECData_rfc2733_mode_separateStream);

            stat = asn1PD_H245FECData_rfc2733_mode_separateStream (pctxt, pvalue->u.separateStream);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "separateStream", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData_rfc2733                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECData_rfc2733 (OOCTXT* pctxt, H245FECData_rfc2733* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode mode */

   invokeStartElement (pctxt, "mode", -1);

   stat = asn1PD_H245FECData_rfc2733_mode (pctxt, &pvalue->mode);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "mode", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECData (OOCTXT* pctxt, H245FECData* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* rfc2733 */
      case 0:
         invokeStartElement (pctxt, "rfc2733", -1);

         pvalue->u.rfc2733 = ALLOC_ASN1ELEM (pctxt, H245FECData_rfc2733);

         stat = asn1PD_H245FECData_rfc2733 (pctxt, pvalue->u.rfc2733);
         if (stat != ASN_OK) return stat;

         invokeEndElement (pctxt, "rfc2733", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H235Media_mediaType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H235Media_mediaType (OOCTXT* pctxt, H245H235Media_mediaType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* videoData */
         case 1:
            invokeStartElement (pctxt, "videoData", -1);

            pvalue->u.videoData = ALLOC_ASN1ELEM (pctxt, H245VideoCapability);

            stat = asn1PD_H245VideoCapability (pctxt, pvalue->u.videoData);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "videoData", -1);

            break;

         /* audioData */
         case 2:
            invokeStartElement (pctxt, "audioData", -1);

            pvalue->u.audioData = ALLOC_ASN1ELEM (pctxt, H245AudioCapability);

            stat = asn1PD_H245AudioCapability (pctxt, pvalue->u.audioData);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "audioData", -1);

            break;

         /* data */
         case 3:
            invokeStartElement (pctxt, "data", -1);

            pvalue->u.data = ALLOC_ASN1ELEM (pctxt, H245DataApplicationCapability);

            stat = asn1PD_H245DataApplicationCapability (pctxt, pvalue->u.data);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "data", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 5;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* redundancyEncoding */
         case 5:
            invokeStartElement (pctxt, "redundancyEncoding", -1);

            pvalue->u.redundancyEncoding = ALLOC_ASN1ELEM (pctxt, H245RedundancyEncoding);

            stat = asn1PD_H245RedundancyEncoding (pctxt, pvalue->u.redundancyEncoding);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "redundancyEncoding", -1);

            break;

         /* multiplePayloadStream */
         case 6:
            invokeStartElement (pctxt, "multiplePayloadStream", -1);

            pvalue->u.multiplePayloadStream = ALLOC_ASN1ELEM (pctxt, H245MultiplePayloadStream);

            stat = asn1PD_H245MultiplePayloadStream (pctxt, pvalue->u.multiplePayloadStream);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multiplePayloadStream", -1);

            break;

         /* fec */
         case 7:
            invokeStartElement (pctxt, "fec", -1);

            pvalue->u.fec = ALLOC_ASN1ELEM (pctxt, H245FECData);

            stat = asn1PD_H245FECData (pctxt, pvalue->u.fec);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "fec", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H235Media                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H235Media (OOCTXT* pctxt, H245H235Media* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode encryptionAuthenticationAndIntegrity */

   invokeStartElement (pctxt, "encryptionAuthenticationAndIntegrity", -1);

   stat = asn1PD_H245EncryptionAuthenticationAndIntegrity (pctxt, &pvalue->encryptionAuthenticationAndIntegrity);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "encryptionAuthenticationAndIntegrity", -1);

   /* decode mediaType */

   invokeStartElement (pctxt, "mediaType", -1);

   stat = asn1PD_H245H235Media_mediaType (pctxt, &pvalue->mediaType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "mediaType", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexedStreamParameter                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexedStreamParameter (OOCTXT* pctxt, H245MultiplexedStreamParameter* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode multiplexFormat */

   invokeStartElement (pctxt, "multiplexFormat", -1);

   stat = asn1PD_H245MultiplexFormat (pctxt, &pvalue->multiplexFormat);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "multiplexFormat", -1);

   /* decode controlOnMuxStream */

   invokeStartElement (pctxt, "controlOnMuxStream", -1);

   stat = DECODEBIT (pctxt, &pvalue->controlOnMuxStream);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->controlOnMuxStream);

   invokeEndElement (pctxt, "controlOnMuxStream", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataType (OOCTXT* pctxt, H245DataType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 5);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* nullData */
         case 1:
            invokeStartElement (pctxt, "nullData", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "nullData", -1);

            break;

         /* videoData */
         case 2:
            invokeStartElement (pctxt, "videoData", -1);

            pvalue->u.videoData = ALLOC_ASN1ELEM (pctxt, H245VideoCapability);

            stat = asn1PD_H245VideoCapability (pctxt, pvalue->u.videoData);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "videoData", -1);

            break;

         /* audioData */
         case 3:
            invokeStartElement (pctxt, "audioData", -1);

            pvalue->u.audioData = ALLOC_ASN1ELEM (pctxt, H245AudioCapability);

            stat = asn1PD_H245AudioCapability (pctxt, pvalue->u.audioData);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "audioData", -1);

            break;

         /* data */
         case 4:
            invokeStartElement (pctxt, "data", -1);

            pvalue->u.data = ALLOC_ASN1ELEM (pctxt, H245DataApplicationCapability);

            stat = asn1PD_H245DataApplicationCapability (pctxt, pvalue->u.data);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "data", -1);

            break;

         /* encryptionData */
         case 5:
            invokeStartElement (pctxt, "encryptionData", -1);

            pvalue->u.encryptionData = ALLOC_ASN1ELEM (pctxt, H245EncryptionMode);

            stat = asn1PD_H245EncryptionMode (pctxt, pvalue->u.encryptionData);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "encryptionData", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 7;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* h235Control */
         case 7:
            invokeStartElement (pctxt, "h235Control", -1);

            pvalue->u.h235Control = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.h235Control);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h235Control", -1);

            break;

         /* h235Media */
         case 8:
            invokeStartElement (pctxt, "h235Media", -1);

            pvalue->u.h235Media = ALLOC_ASN1ELEM (pctxt, H245H235Media);

            stat = asn1PD_H245H235Media (pctxt, pvalue->u.h235Media);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h235Media", -1);

            break;

         /* multiplexedStream */
         case 9:
            invokeStartElement (pctxt, "multiplexedStream", -1);

            pvalue->u.multiplexedStream = ALLOC_ASN1ELEM (pctxt, H245MultiplexedStreamParameter);

            stat = asn1PD_H245MultiplexedStreamParameter (pctxt, pvalue->u.multiplexedStream);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multiplexedStream", -1);

            break;

         /* redundancyEncoding */
         case 10:
            invokeStartElement (pctxt, "redundancyEncoding", -1);

            pvalue->u.redundancyEncoding = ALLOC_ASN1ELEM (pctxt, H245RedundancyEncoding);

            stat = asn1PD_H245RedundancyEncoding (pctxt, pvalue->u.redundancyEncoding);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "redundancyEncoding", -1);

            break;

         /* multiplePayloadStream */
         case 11:
            invokeStartElement (pctxt, "multiplePayloadStream", -1);

            pvalue->u.multiplePayloadStream = ALLOC_ASN1ELEM (pctxt, H245MultiplePayloadStream);

            stat = asn1PD_H245MultiplePayloadStream (pctxt, pvalue->u.multiplePayloadStream);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multiplePayloadStream", -1);

            break;

         /* fec */
         case 12:
            invokeStartElement (pctxt, "fec", -1);

            pvalue->u.fec = ALLOC_ASN1ELEM (pctxt, H245FECData);

            stat = asn1PD_H245FECData (pctxt, pvalue->u.fec);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "fec", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H222LogicalChannelParameters                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H222LogicalChannelParameters (OOCTXT* pctxt, H245H222LogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.pcr_pidPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.programDescriptorsPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.streamDescriptorsPresent = optbit;

   /* decode resourceID */

   invokeStartElement (pctxt, "resourceID", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->resourceID, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->resourceID);

   invokeEndElement (pctxt, "resourceID", -1);

   /* decode subChannelID */

   invokeStartElement (pctxt, "subChannelID", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->subChannelID, 0U, 8191U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->subChannelID);

   invokeEndElement (pctxt, "subChannelID", -1);

   /* decode pcr_pid */

   if (pvalue->m.pcr_pidPresent) {
      invokeStartElement (pctxt, "pcr_pid", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->pcr_pid, 0U, 8191U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->pcr_pid);

      invokeEndElement (pctxt, "pcr_pid", -1);
   }

   /* decode programDescriptors */

   if (pvalue->m.programDescriptorsPresent) {
      invokeStartElement (pctxt, "programDescriptors", -1);

      stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->programDescriptors);
      if (stat != ASN_OK) return stat;
      invokeOctStrValue (pctxt, pvalue->programDescriptors.numocts, pvalue->programDescriptors.data);

      invokeEndElement (pctxt, "programDescriptors", -1);
   }

   /* decode streamDescriptors */

   if (pvalue->m.streamDescriptorsPresent) {
      invokeStartElement (pctxt, "streamDescriptors", -1);

      stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->streamDescriptors);
      if (stat != ASN_OK) return stat;
      invokeOctStrValue (pctxt, pvalue->streamDescriptors.numocts, pvalue->streamDescriptors.data);

      invokeEndElement (pctxt, "streamDescriptors", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223LogicalChannelParameters_adaptationLayerType_al3      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223LogicalChannelParameters_adaptationLayerType_al3 (OOCTXT* pctxt, H245H223LogicalChannelParameters_adaptationLayerType_al3* pvalue)
{
   int stat = ASN_OK;

   /* decode controlFieldOctets */

   invokeStartElement (pctxt, "controlFieldOctets", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->controlFieldOctets, 0U, 2U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->controlFieldOctets);

   invokeEndElement (pctxt, "controlFieldOctets", -1);

   /* decode sendBufferSize */

   invokeStartElement (pctxt, "sendBufferSize", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->sendBufferSize, 0U, 16777215U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->sendBufferSize);

   invokeEndElement (pctxt, "sendBufferSize", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL1MParameters_transferMode                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AL1MParameters_transferMode (OOCTXT* pctxt, H245H223AL1MParameters_transferMode* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* framed */
         case 0:
            invokeStartElement (pctxt, "framed", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "framed", -1);

            break;

         /* unframed */
         case 1:
            invokeStartElement (pctxt, "unframed", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unframed", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL1MParameters_headerFEC                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AL1MParameters_headerFEC (OOCTXT* pctxt, H245H223AL1MParameters_headerFEC* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* sebch16_7 */
         case 0:
            invokeStartElement (pctxt, "sebch16_7", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "sebch16_7", -1);

            break;

         /* golay24_12 */
         case 1:
            invokeStartElement (pctxt, "golay24_12", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "golay24_12", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL1MParameters_crcLength                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AL1MParameters_crcLength (OOCTXT* pctxt, H245H223AL1MParameters_crcLength* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* crc4bit */
         case 0:
            invokeStartElement (pctxt, "crc4bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc4bit", -1);

            break;

         /* crc12bit */
         case 1:
            invokeStartElement (pctxt, "crc12bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc12bit", -1);

            break;

         /* crc20bit */
         case 2:
            invokeStartElement (pctxt, "crc20bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc20bit", -1);

            break;

         /* crc28bit */
         case 3:
            invokeStartElement (pctxt, "crc28bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc28bit", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 5;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* crc8bit */
         case 5:
            invokeStartElement (pctxt, "crc8bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc8bit", -1);

            break;

         /* crc16bit */
         case 6:
            invokeStartElement (pctxt, "crc16bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc16bit", -1);

            break;

         /* crc32bit */
         case 7:
            invokeStartElement (pctxt, "crc32bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc32bit", -1);

            break;

         /* crcNotUsed */
         case 8:
            invokeStartElement (pctxt, "crcNotUsed", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crcNotUsed", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AnnexCArqParameters_numberOfRetransmissions           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AnnexCArqParameters_numberOfRetransmissions (OOCTXT* pctxt, H245H223AnnexCArqParameters_numberOfRetransmissions* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* finite */
         case 0:
            invokeStartElement (pctxt, "finite", -1);

            stat = decodeConsUInt8 (pctxt, &pvalue->u.finite, 0U, 16U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.finite);

            invokeEndElement (pctxt, "finite", -1);

            break;

         /* infinite */
         case 1:
            invokeStartElement (pctxt, "infinite", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "infinite", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AnnexCArqParameters                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AnnexCArqParameters (OOCTXT* pctxt, H245H223AnnexCArqParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode numberOfRetransmissions */

   invokeStartElement (pctxt, "numberOfRetransmissions", -1);

   stat = asn1PD_H245H223AnnexCArqParameters_numberOfRetransmissions (pctxt, &pvalue->numberOfRetransmissions);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "numberOfRetransmissions", -1);

   /* decode sendBufferSize */

   invokeStartElement (pctxt, "sendBufferSize", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->sendBufferSize, 0U, 16777215U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->sendBufferSize);

   invokeEndElement (pctxt, "sendBufferSize", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL1MParameters_arqType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AL1MParameters_arqType (OOCTXT* pctxt, H245H223AL1MParameters_arqType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* noArq */
         case 0:
            invokeStartElement (pctxt, "noArq", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "noArq", -1);

            break;

         /* typeIArq */
         case 1:
            invokeStartElement (pctxt, "typeIArq", -1);

            pvalue->u.typeIArq = ALLOC_ASN1ELEM (pctxt, H245H223AnnexCArqParameters);

            stat = asn1PD_H245H223AnnexCArqParameters (pctxt, pvalue->u.typeIArq);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "typeIArq", -1);

            break;

         /* typeIIArq */
         case 2:
            invokeStartElement (pctxt, "typeIIArq", -1);

            pvalue->u.typeIIArq = ALLOC_ASN1ELEM (pctxt, H245H223AnnexCArqParameters);

            stat = asn1PD_H245H223AnnexCArqParameters (pctxt, pvalue->u.typeIIArq);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "typeIIArq", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL1MParameters                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AL1MParameters (OOCTXT* pctxt, H245H223AL1MParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode transferMode */

   invokeStartElement (pctxt, "transferMode", -1);

   stat = asn1PD_H245H223AL1MParameters_transferMode (pctxt, &pvalue->transferMode);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "transferMode", -1);

   /* decode headerFEC */

   invokeStartElement (pctxt, "headerFEC", -1);

   stat = asn1PD_H245H223AL1MParameters_headerFEC (pctxt, &pvalue->headerFEC);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "headerFEC", -1);

   /* decode crcLength */

   invokeStartElement (pctxt, "crcLength", -1);

   stat = asn1PD_H245H223AL1MParameters_crcLength (pctxt, &pvalue->crcLength);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "crcLength", -1);

   /* decode rcpcCodeRate */

   invokeStartElement (pctxt, "rcpcCodeRate", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->rcpcCodeRate, 8U, 32U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->rcpcCodeRate);

   invokeEndElement (pctxt, "rcpcCodeRate", -1);

   /* decode arqType */

   invokeStartElement (pctxt, "arqType", -1);

   stat = asn1PD_H245H223AL1MParameters_arqType (pctxt, &pvalue->arqType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "arqType", -1);

   /* decode alpduInterleaving */

   invokeStartElement (pctxt, "alpduInterleaving", -1);

   stat = DECODEBIT (pctxt, &pvalue->alpduInterleaving);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->alpduInterleaving);

   invokeEndElement (pctxt, "alpduInterleaving", -1);

   /* decode alsduSplitting */

   invokeStartElement (pctxt, "alsduSplitting", -1);

   stat = DECODEBIT (pctxt, &pvalue->alsduSplitting);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->alsduSplitting);

   invokeEndElement (pctxt, "alsduSplitting", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.rsCodeCorrectionPresent = 1;

                     invokeStartElement (pctxt, "rsCodeCorrection", -1);

                     stat = decodeConsUInt8 (pctxt, &pvalue->rsCodeCorrection, 0U, 127U);
                     if (stat != ASN_OK) return stat;
                     invokeUIntValue (pctxt, pvalue->rsCodeCorrection);

                     invokeEndElement (pctxt, "rsCodeCorrection", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL2MParameters_headerFEC                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AL2MParameters_headerFEC (OOCTXT* pctxt, H245H223AL2MParameters_headerFEC* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* sebch16_5 */
         case 0:
            invokeStartElement (pctxt, "sebch16_5", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "sebch16_5", -1);

            break;

         /* golay24_12 */
         case 1:
            invokeStartElement (pctxt, "golay24_12", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "golay24_12", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL2MParameters                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AL2MParameters (OOCTXT* pctxt, H245H223AL2MParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode headerFEC */

   invokeStartElement (pctxt, "headerFEC", -1);

   stat = asn1PD_H245H223AL2MParameters_headerFEC (pctxt, &pvalue->headerFEC);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "headerFEC", -1);

   /* decode alpduInterleaving */

   invokeStartElement (pctxt, "alpduInterleaving", -1);

   stat = DECODEBIT (pctxt, &pvalue->alpduInterleaving);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->alpduInterleaving);

   invokeEndElement (pctxt, "alpduInterleaving", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL3MParameters_headerFormat                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AL3MParameters_headerFormat (OOCTXT* pctxt, H245H223AL3MParameters_headerFormat* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* sebch16_7 */
         case 0:
            invokeStartElement (pctxt, "sebch16_7", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "sebch16_7", -1);

            break;

         /* golay24_12 */
         case 1:
            invokeStartElement (pctxt, "golay24_12", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "golay24_12", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL3MParameters_crcLength                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AL3MParameters_crcLength (OOCTXT* pctxt, H245H223AL3MParameters_crcLength* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* crc4bit */
         case 0:
            invokeStartElement (pctxt, "crc4bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc4bit", -1);

            break;

         /* crc12bit */
         case 1:
            invokeStartElement (pctxt, "crc12bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc12bit", -1);

            break;

         /* crc20bit */
         case 2:
            invokeStartElement (pctxt, "crc20bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc20bit", -1);

            break;

         /* crc28bit */
         case 3:
            invokeStartElement (pctxt, "crc28bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc28bit", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 5;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* crc8bit */
         case 5:
            invokeStartElement (pctxt, "crc8bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc8bit", -1);

            break;

         /* crc16bit */
         case 6:
            invokeStartElement (pctxt, "crc16bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc16bit", -1);

            break;

         /* crc32bit */
         case 7:
            invokeStartElement (pctxt, "crc32bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc32bit", -1);

            break;

         /* crcNotUsed */
         case 8:
            invokeStartElement (pctxt, "crcNotUsed", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crcNotUsed", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL3MParameters_arqType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AL3MParameters_arqType (OOCTXT* pctxt, H245H223AL3MParameters_arqType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* noArq */
         case 0:
            invokeStartElement (pctxt, "noArq", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "noArq", -1);

            break;

         /* typeIArq */
         case 1:
            invokeStartElement (pctxt, "typeIArq", -1);

            pvalue->u.typeIArq = ALLOC_ASN1ELEM (pctxt, H245H223AnnexCArqParameters);

            stat = asn1PD_H245H223AnnexCArqParameters (pctxt, pvalue->u.typeIArq);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "typeIArq", -1);

            break;

         /* typeIIArq */
         case 2:
            invokeStartElement (pctxt, "typeIIArq", -1);

            pvalue->u.typeIIArq = ALLOC_ASN1ELEM (pctxt, H245H223AnnexCArqParameters);

            stat = asn1PD_H245H223AnnexCArqParameters (pctxt, pvalue->u.typeIIArq);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "typeIIArq", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL3MParameters                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223AL3MParameters (OOCTXT* pctxt, H245H223AL3MParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode headerFormat */

   invokeStartElement (pctxt, "headerFormat", -1);

   stat = asn1PD_H245H223AL3MParameters_headerFormat (pctxt, &pvalue->headerFormat);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "headerFormat", -1);

   /* decode crcLength */

   invokeStartElement (pctxt, "crcLength", -1);

   stat = asn1PD_H245H223AL3MParameters_crcLength (pctxt, &pvalue->crcLength);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "crcLength", -1);

   /* decode rcpcCodeRate */

   invokeStartElement (pctxt, "rcpcCodeRate", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->rcpcCodeRate, 8U, 32U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->rcpcCodeRate);

   invokeEndElement (pctxt, "rcpcCodeRate", -1);

   /* decode arqType */

   invokeStartElement (pctxt, "arqType", -1);

   stat = asn1PD_H245H223AL3MParameters_arqType (pctxt, &pvalue->arqType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "arqType", -1);

   /* decode alpduInterleaving */

   invokeStartElement (pctxt, "alpduInterleaving", -1);

   stat = DECODEBIT (pctxt, &pvalue->alpduInterleaving);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->alpduInterleaving);

   invokeEndElement (pctxt, "alpduInterleaving", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.rsCodeCorrectionPresent = 1;

                     invokeStartElement (pctxt, "rsCodeCorrection", -1);

                     stat = decodeConsUInt8 (pctxt, &pvalue->rsCodeCorrection, 0U, 127U);
                     if (stat != ASN_OK) return stat;
                     invokeUIntValue (pctxt, pvalue->rsCodeCorrection);

                     invokeEndElement (pctxt, "rsCodeCorrection", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223LogicalChannelParameters_adaptationLayerType          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223LogicalChannelParameters_adaptationLayerType (OOCTXT* pctxt, H245H223LogicalChannelParameters_adaptationLayerType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 5);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* al1Framed */
         case 1:
            invokeStartElement (pctxt, "al1Framed", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "al1Framed", -1);

            break;

         /* al1NotFramed */
         case 2:
            invokeStartElement (pctxt, "al1NotFramed", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "al1NotFramed", -1);

            break;

         /* al2WithoutSequenceNumbers */
         case 3:
            invokeStartElement (pctxt, "al2WithoutSequenceNumbers", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "al2WithoutSequenceNumbers", -1);

            break;

         /* al2WithSequenceNumbers */
         case 4:
            invokeStartElement (pctxt, "al2WithSequenceNumbers", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "al2WithSequenceNumbers", -1);

            break;

         /* al3 */
         case 5:
            invokeStartElement (pctxt, "al3", -1);

            pvalue->u.al3 = ALLOC_ASN1ELEM (pctxt, H245H223LogicalChannelParameters_adaptationLayerType_al3);

            stat = asn1PD_H245H223LogicalChannelParameters_adaptationLayerType_al3 (pctxt, pvalue->u.al3);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "al3", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 7;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* al1M */
         case 7:
            invokeStartElement (pctxt, "al1M", -1);

            pvalue->u.al1M = ALLOC_ASN1ELEM (pctxt, H245H223AL1MParameters);

            stat = asn1PD_H245H223AL1MParameters (pctxt, pvalue->u.al1M);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "al1M", -1);

            break;

         /* al2M */
         case 8:
            invokeStartElement (pctxt, "al2M", -1);

            pvalue->u.al2M = ALLOC_ASN1ELEM (pctxt, H245H223AL2MParameters);

            stat = asn1PD_H245H223AL2MParameters (pctxt, pvalue->u.al2M);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "al2M", -1);

            break;

         /* al3M */
         case 9:
            invokeStartElement (pctxt, "al3M", -1);

            pvalue->u.al3M = ALLOC_ASN1ELEM (pctxt, H245H223AL3MParameters);

            stat = asn1PD_H245H223AL3MParameters (pctxt, pvalue->u.al3M);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "al3M", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223LogicalChannelParameters                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223LogicalChannelParameters (OOCTXT* pctxt, H245H223LogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode adaptationLayerType */

   invokeStartElement (pctxt, "adaptationLayerType", -1);

   stat = asn1PD_H245H223LogicalChannelParameters_adaptationLayerType (pctxt, &pvalue->adaptationLayerType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "adaptationLayerType", -1);

   /* decode segmentableFlag */

   invokeStartElement (pctxt, "segmentableFlag", -1);

   stat = DECODEBIT (pctxt, &pvalue->segmentableFlag);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->segmentableFlag);

   invokeEndElement (pctxt, "segmentableFlag", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CRCLength                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CRCLength (OOCTXT* pctxt, H245CRCLength* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* crc8bit */
         case 0:
            invokeStartElement (pctxt, "crc8bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc8bit", -1);

            break;

         /* crc16bit */
         case 1:
            invokeStartElement (pctxt, "crc16bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc16bit", -1);

            break;

         /* crc32bit */
         case 2:
            invokeStartElement (pctxt, "crc32bit", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "crc32bit", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76HDLCParameters                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245V76HDLCParameters (OOCTXT* pctxt, H245V76HDLCParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode crcLength */

   invokeStartElement (pctxt, "crcLength", -1);

   stat = asn1PD_H245CRCLength (pctxt, &pvalue->crcLength);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "crcLength", -1);

   /* decode n401 */

   invokeStartElement (pctxt, "n401", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->n401, 1U, 4095U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->n401);

   invokeEndElement (pctxt, "n401", -1);

   /* decode loopbackTestProcedure */

   invokeStartElement (pctxt, "loopbackTestProcedure", -1);

   stat = DECODEBIT (pctxt, &pvalue->loopbackTestProcedure);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->loopbackTestProcedure);

   invokeEndElement (pctxt, "loopbackTestProcedure", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76LogicalChannelParameters_suspendResume                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245V76LogicalChannelParameters_suspendResume (OOCTXT* pctxt, H245V76LogicalChannelParameters_suspendResume* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* noSuspendResume */
         case 0:
            invokeStartElement (pctxt, "noSuspendResume", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "noSuspendResume", -1);

            break;

         /* suspendResumewAddress */
         case 1:
            invokeStartElement (pctxt, "suspendResumewAddress", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "suspendResumewAddress", -1);

            break;

         /* suspendResumewoAddress */
         case 2:
            invokeStartElement (pctxt, "suspendResumewoAddress", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "suspendResumewoAddress", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76LogicalChannelParameters_mode_eRM_recovery             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245V76LogicalChannelParameters_mode_eRM_recovery (OOCTXT* pctxt, H245V76LogicalChannelParameters_mode_eRM_recovery* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* rej */
         case 0:
            invokeStartElement (pctxt, "rej", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "rej", -1);

            break;

         /* sREJ */
         case 1:
            invokeStartElement (pctxt, "sREJ", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "sREJ", -1);

            break;

         /* mSREJ */
         case 2:
            invokeStartElement (pctxt, "mSREJ", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "mSREJ", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76LogicalChannelParameters_mode_eRM                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245V76LogicalChannelParameters_mode_eRM (OOCTXT* pctxt, H245V76LogicalChannelParameters_mode_eRM* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode windowSize */

   invokeStartElement (pctxt, "windowSize", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->windowSize, 1U, 127U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->windowSize);

   invokeEndElement (pctxt, "windowSize", -1);

   /* decode recovery */

   invokeStartElement (pctxt, "recovery", -1);

   stat = asn1PD_H245V76LogicalChannelParameters_mode_eRM_recovery (pctxt, &pvalue->recovery);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "recovery", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76LogicalChannelParameters_mode                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245V76LogicalChannelParameters_mode (OOCTXT* pctxt, H245V76LogicalChannelParameters_mode* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* eRM */
         case 0:
            invokeStartElement (pctxt, "eRM", -1);

            pvalue->u.eRM = ALLOC_ASN1ELEM (pctxt, H245V76LogicalChannelParameters_mode_eRM);

            stat = asn1PD_H245V76LogicalChannelParameters_mode_eRM (pctxt, pvalue->u.eRM);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "eRM", -1);

            break;

         /* uNERM */
         case 1:
            invokeStartElement (pctxt, "uNERM", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "uNERM", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V75Parameters                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245V75Parameters (OOCTXT* pctxt, H245V75Parameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode audioHeaderPresent */

   invokeStartElement (pctxt, "audioHeaderPresent", -1);

   stat = DECODEBIT (pctxt, &pvalue->audioHeaderPresent);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->audioHeaderPresent);

   invokeEndElement (pctxt, "audioHeaderPresent", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76LogicalChannelParameters                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245V76LogicalChannelParameters (OOCTXT* pctxt, H245V76LogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode hdlcParameters */

   invokeStartElement (pctxt, "hdlcParameters", -1);

   stat = asn1PD_H245V76HDLCParameters (pctxt, &pvalue->hdlcParameters);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "hdlcParameters", -1);

   /* decode suspendResume */

   invokeStartElement (pctxt, "suspendResume", -1);

   stat = asn1PD_H245V76LogicalChannelParameters_suspendResume (pctxt, &pvalue->suspendResume);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "suspendResume", -1);

   /* decode uIH */

   invokeStartElement (pctxt, "uIH", -1);

   stat = DECODEBIT (pctxt, &pvalue->uIH);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->uIH);

   invokeEndElement (pctxt, "uIH", -1);

   /* decode mode */

   invokeStartElement (pctxt, "mode", -1);

   stat = asn1PD_H245V76LogicalChannelParameters_mode (pctxt, &pvalue->mode);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "mode", -1);

   /* decode v75Parameters */

   invokeStartElement (pctxt, "v75Parameters", -1);

   stat = asn1PD_H245V75Parameters (pctxt, &pvalue->v75Parameters);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "v75Parameters", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPAddress_network                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iPAddress_network (OOCTXT* pctxt, H245UnicastAddress_iPAddress_network* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 4, 4, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPAddress                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iPAddress (OOCTXT* pctxt, H245UnicastAddress_iPAddress* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode network */

   invokeStartElement (pctxt, "network", -1);

   stat = asn1PD_H245UnicastAddress_iPAddress_network (pctxt, &pvalue->network);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "network", -1);

   /* decode tsapIdentifier */

   invokeStartElement (pctxt, "tsapIdentifier", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->tsapIdentifier, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->tsapIdentifier);

   invokeEndElement (pctxt, "tsapIdentifier", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPXAddress_node                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iPXAddress_node (OOCTXT* pctxt, H245UnicastAddress_iPXAddress_node* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 6, 6, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPXAddress_netnum                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iPXAddress_netnum (OOCTXT* pctxt, H245UnicastAddress_iPXAddress_netnum* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 4, 4, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPXAddress_tsapIdentifier                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iPXAddress_tsapIdentifier (OOCTXT* pctxt, H245UnicastAddress_iPXAddress_tsapIdentifier* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 2, 2, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPXAddress                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iPXAddress (OOCTXT* pctxt, H245UnicastAddress_iPXAddress* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode node */

   invokeStartElement (pctxt, "node", -1);

   stat = asn1PD_H245UnicastAddress_iPXAddress_node (pctxt, &pvalue->node);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "node", -1);

   /* decode netnum */

   invokeStartElement (pctxt, "netnum", -1);

   stat = asn1PD_H245UnicastAddress_iPXAddress_netnum (pctxt, &pvalue->netnum);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "netnum", -1);

   /* decode tsapIdentifier */

   invokeStartElement (pctxt, "tsapIdentifier", -1);

   stat = asn1PD_H245UnicastAddress_iPXAddress_tsapIdentifier (pctxt, &pvalue->tsapIdentifier);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "tsapIdentifier", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iP6Address_network                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iP6Address_network (OOCTXT* pctxt, H245UnicastAddress_iP6Address_network* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iP6Address                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iP6Address (OOCTXT* pctxt, H245UnicastAddress_iP6Address* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode network */

   invokeStartElement (pctxt, "network", -1);

   stat = asn1PD_H245UnicastAddress_iP6Address_network (pctxt, &pvalue->network);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "network", -1);

   /* decode tsapIdentifier */

   invokeStartElement (pctxt, "tsapIdentifier", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->tsapIdentifier, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->tsapIdentifier);

   invokeEndElement (pctxt, "tsapIdentifier", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_netBios                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_netBios (OOCTXT* pctxt, H245UnicastAddress_netBios* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPSourceRouteAddress_routing               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iPSourceRouteAddress_routing (OOCTXT* pctxt, H245UnicastAddress_iPSourceRouteAddress_routing* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* strict */
      case 0:
         invokeStartElement (pctxt, "strict", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "strict", -1);

         break;

      /* loose */
      case 1:
         invokeStartElement (pctxt, "loose", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "loose", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPSourceRouteAddress_network               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iPSourceRouteAddress_network (OOCTXT* pctxt, H245UnicastAddress_iPSourceRouteAddress_network* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 4, 4, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPSourceRouteAddress_route_element         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iPSourceRouteAddress_route_element (OOCTXT* pctxt, H245UnicastAddress_iPSourceRouteAddress_route_element* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 4, 4, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245UnicastAddress_iPSourceRouteAddress_route_elem  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SeqOfH245UnicastAddress_iPSourceRouteAddress_route_element (OOCTXT* pctxt, H245_SeqOfH245UnicastAddress_iPSourceRouteAddress_route_element* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   ALLOC_ASN1ARRAY (pctxt, pvalue, H245UnicastAddress_iPSourceRouteAddress_route_element);

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = asn1PD_H245UnicastAddress_iPSourceRouteAddress_route_element (pctxt, &pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPSourceRouteAddress                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_iPSourceRouteAddress (OOCTXT* pctxt, H245UnicastAddress_iPSourceRouteAddress* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode routing */

   invokeStartElement (pctxt, "routing", -1);

   stat = asn1PD_H245UnicastAddress_iPSourceRouteAddress_routing (pctxt, &pvalue->routing);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "routing", -1);

   /* decode network */

   invokeStartElement (pctxt, "network", -1);

   stat = asn1PD_H245UnicastAddress_iPSourceRouteAddress_network (pctxt, &pvalue->network);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "network", -1);

   /* decode tsapIdentifier */

   invokeStartElement (pctxt, "tsapIdentifier", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->tsapIdentifier, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->tsapIdentifier);

   invokeEndElement (pctxt, "tsapIdentifier", -1);

   /* decode route */

   invokeStartElement (pctxt, "route", -1);

   stat = asn1PD_H245_SeqOfH245UnicastAddress_iPSourceRouteAddress_route_element (pctxt, &pvalue->route);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "route", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_nsap                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress_nsap (OOCTXT* pctxt, H245UnicastAddress_nsap* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 20, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245UnicastAddress (OOCTXT* pctxt, H245UnicastAddress* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 4);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* iPAddress */
         case 0:
            invokeStartElement (pctxt, "iPAddress", -1);

            pvalue->u.iPAddress = ALLOC_ASN1ELEM (pctxt, H245UnicastAddress_iPAddress);

            stat = asn1PD_H245UnicastAddress_iPAddress (pctxt, pvalue->u.iPAddress);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "iPAddress", -1);

            break;

         /* iPXAddress */
         case 1:
            invokeStartElement (pctxt, "iPXAddress", -1);

            pvalue->u.iPXAddress = ALLOC_ASN1ELEM (pctxt, H245UnicastAddress_iPXAddress);

            stat = asn1PD_H245UnicastAddress_iPXAddress (pctxt, pvalue->u.iPXAddress);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "iPXAddress", -1);

            break;

         /* iP6Address */
         case 2:
            invokeStartElement (pctxt, "iP6Address", -1);

            pvalue->u.iP6Address = ALLOC_ASN1ELEM (pctxt, H245UnicastAddress_iP6Address);

            stat = asn1PD_H245UnicastAddress_iP6Address (pctxt, pvalue->u.iP6Address);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "iP6Address", -1);

            break;

         /* netBios */
         case 3:
            invokeStartElement (pctxt, "netBios", -1);

            pvalue->u.netBios = ALLOC_ASN1ELEM (pctxt, H245UnicastAddress_netBios);

            stat = asn1PD_H245UnicastAddress_netBios (pctxt, pvalue->u.netBios);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "netBios", -1);

            break;

         /* iPSourceRouteAddress */
         case 4:
            invokeStartElement (pctxt, "iPSourceRouteAddress", -1);

            pvalue->u.iPSourceRouteAddress = ALLOC_ASN1ELEM (pctxt, H245UnicastAddress_iPSourceRouteAddress);

            stat = asn1PD_H245UnicastAddress_iPSourceRouteAddress (pctxt, pvalue->u.iPSourceRouteAddress);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "iPSourceRouteAddress", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 6;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* nsap */
         case 6:
            invokeStartElement (pctxt, "nsap", -1);

            pvalue->u.nsap = ALLOC_ASN1ELEM (pctxt, H245UnicastAddress_nsap);

            stat = asn1PD_H245UnicastAddress_nsap (pctxt, pvalue->u.nsap);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nsap", -1);

            break;

         /* nonStandardAddress */
         case 7:
            invokeStartElement (pctxt, "nonStandardAddress", -1);

            pvalue->u.nonStandardAddress = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandardAddress);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandardAddress", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress_iPAddress_network                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MulticastAddress_iPAddress_network (OOCTXT* pctxt, H245MulticastAddress_iPAddress_network* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 4, 4, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress_iPAddress                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MulticastAddress_iPAddress (OOCTXT* pctxt, H245MulticastAddress_iPAddress* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode network */

   invokeStartElement (pctxt, "network", -1);

   stat = asn1PD_H245MulticastAddress_iPAddress_network (pctxt, &pvalue->network);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "network", -1);

   /* decode tsapIdentifier */

   invokeStartElement (pctxt, "tsapIdentifier", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->tsapIdentifier, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->tsapIdentifier);

   invokeEndElement (pctxt, "tsapIdentifier", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress_iP6Address_network                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MulticastAddress_iP6Address_network (OOCTXT* pctxt, H245MulticastAddress_iP6Address_network* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress_iP6Address                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MulticastAddress_iP6Address (OOCTXT* pctxt, H245MulticastAddress_iP6Address* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode network */

   invokeStartElement (pctxt, "network", -1);

   stat = asn1PD_H245MulticastAddress_iP6Address_network (pctxt, &pvalue->network);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "network", -1);

   /* decode tsapIdentifier */

   invokeStartElement (pctxt, "tsapIdentifier", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->tsapIdentifier, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->tsapIdentifier);

   invokeEndElement (pctxt, "tsapIdentifier", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress_nsap                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MulticastAddress_nsap (OOCTXT* pctxt, H245MulticastAddress_nsap* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 20, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MulticastAddress (OOCTXT* pctxt, H245MulticastAddress* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* iPAddress */
         case 0:
            invokeStartElement (pctxt, "iPAddress", -1);

            pvalue->u.iPAddress = ALLOC_ASN1ELEM (pctxt, H245MulticastAddress_iPAddress);

            stat = asn1PD_H245MulticastAddress_iPAddress (pctxt, pvalue->u.iPAddress);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "iPAddress", -1);

            break;

         /* iP6Address */
         case 1:
            invokeStartElement (pctxt, "iP6Address", -1);

            pvalue->u.iP6Address = ALLOC_ASN1ELEM (pctxt, H245MulticastAddress_iP6Address);

            stat = asn1PD_H245MulticastAddress_iP6Address (pctxt, pvalue->u.iP6Address);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "iP6Address", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* nsap */
         case 3:
            invokeStartElement (pctxt, "nsap", -1);

            pvalue->u.nsap = ALLOC_ASN1ELEM (pctxt, H245MulticastAddress_nsap);

            stat = asn1PD_H245MulticastAddress_nsap (pctxt, pvalue->u.nsap);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nsap", -1);

            break;

         /* nonStandardAddress */
         case 4:
            invokeStartElement (pctxt, "nonStandardAddress", -1);

            pvalue->u.nonStandardAddress = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandardAddress);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandardAddress", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransportAddress                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TransportAddress (OOCTXT* pctxt, H245TransportAddress* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* unicastAddress */
         case 0:
            invokeStartElement (pctxt, "unicastAddress", -1);

            pvalue->u.unicastAddress = ALLOC_ASN1ELEM (pctxt, H245UnicastAddress);

            stat = asn1PD_H245UnicastAddress (pctxt, pvalue->u.unicastAddress);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "unicastAddress", -1);

            break;

         /* multicastAddress */
         case 1:
            invokeStartElement (pctxt, "multicastAddress", -1);

            pvalue->u.multicastAddress = ALLOC_ASN1ELEM (pctxt, H245MulticastAddress);

            stat = asn1PD_H245MulticastAddress (pctxt, pvalue->u.multicastAddress);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multicastAddress", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  McuNumber                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245McuNumber (OOCTXT* pctxt, H245McuNumber* pvalue)
{
   int stat = ASN_OK;

   stat = decodeConsUInt8 (pctxt, pvalue, 0U, 192U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, *pvalue);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalNumber                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TerminalNumber (OOCTXT* pctxt, H245TerminalNumber* pvalue)
{
   int stat = ASN_OK;

   stat = decodeConsUInt8 (pctxt, pvalue, 0U, 192U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, *pvalue);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalLabel                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TerminalLabel (OOCTXT* pctxt, H245TerminalLabel* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode mcuNumber */

   invokeStartElement (pctxt, "mcuNumber", -1);

   stat = asn1PD_H245McuNumber (pctxt, &pvalue->mcuNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "mcuNumber", -1);

   /* decode terminalNumber */

   invokeStartElement (pctxt, "terminalNumber", -1);

   stat = asn1PD_H245TerminalNumber (pctxt, &pvalue->terminalNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250LogicalChannelParameters_mediaPacketization          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H2250LogicalChannelParameters_mediaPacketization (OOCTXT* pctxt, H245H2250LogicalChannelParameters_mediaPacketization* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* h261aVideoPacketization */
         case 0:
            invokeStartElement (pctxt, "h261aVideoPacketization", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "h261aVideoPacketization", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 2;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* rtpPayloadType */
         case 2:
            invokeStartElement (pctxt, "rtpPayloadType", -1);

            pvalue->u.rtpPayloadType = ALLOC_ASN1ELEM (pctxt, H245RTPPayloadType);

            stat = asn1PD_H245RTPPayloadType (pctxt, pvalue->u.rtpPayloadType);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "rtpPayloadType", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250LogicalChannelParameters                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H2250LogicalChannelParameters (OOCTXT* pctxt, H245H2250LogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonStandardPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.associatedSessionIDPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaChannelPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaGuaranteedDeliveryPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaControlChannelPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaControlGuaranteedDeliveryPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.silenceSuppressionPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.destinationPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.dynamicRTPPayloadTypePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaPacketizationPresent = optbit;

   /* decode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      invokeStartElement (pctxt, "nonStandard", -1);

      stat = asn1PD_H245_SeqOfH245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "nonStandard", -1);
   }

   /* decode sessionID */

   invokeStartElement (pctxt, "sessionID", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->sessionID, 0U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->sessionID);

   invokeEndElement (pctxt, "sessionID", -1);

   /* decode associatedSessionID */

   if (pvalue->m.associatedSessionIDPresent) {
      invokeStartElement (pctxt, "associatedSessionID", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->associatedSessionID, 1U, 255U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->associatedSessionID);

      invokeEndElement (pctxt, "associatedSessionID", -1);
   }

   /* decode mediaChannel */

   if (pvalue->m.mediaChannelPresent) {
      invokeStartElement (pctxt, "mediaChannel", -1);

      stat = asn1PD_H245TransportAddress (pctxt, &pvalue->mediaChannel);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "mediaChannel", -1);
   }

   /* decode mediaGuaranteedDelivery */

   if (pvalue->m.mediaGuaranteedDeliveryPresent) {
      invokeStartElement (pctxt, "mediaGuaranteedDelivery", -1);

      stat = DECODEBIT (pctxt, &pvalue->mediaGuaranteedDelivery);
      if (stat != ASN_OK) return stat;
      invokeBoolValue (pctxt, pvalue->mediaGuaranteedDelivery);

      invokeEndElement (pctxt, "mediaGuaranteedDelivery", -1);
   }

   /* decode mediaControlChannel */

   if (pvalue->m.mediaControlChannelPresent) {
      invokeStartElement (pctxt, "mediaControlChannel", -1);

      stat = asn1PD_H245TransportAddress (pctxt, &pvalue->mediaControlChannel);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "mediaControlChannel", -1);
   }

   /* decode mediaControlGuaranteedDelivery */

   if (pvalue->m.mediaControlGuaranteedDeliveryPresent) {
      invokeStartElement (pctxt, "mediaControlGuaranteedDelivery", -1);

      stat = DECODEBIT (pctxt, &pvalue->mediaControlGuaranteedDelivery);
      if (stat != ASN_OK) return stat;
      invokeBoolValue (pctxt, pvalue->mediaControlGuaranteedDelivery);

      invokeEndElement (pctxt, "mediaControlGuaranteedDelivery", -1);
   }

   /* decode silenceSuppression */

   if (pvalue->m.silenceSuppressionPresent) {
      invokeStartElement (pctxt, "silenceSuppression", -1);

      stat = DECODEBIT (pctxt, &pvalue->silenceSuppression);
      if (stat != ASN_OK) return stat;
      invokeBoolValue (pctxt, pvalue->silenceSuppression);

      invokeEndElement (pctxt, "silenceSuppression", -1);
   }

   /* decode destination */

   if (pvalue->m.destinationPresent) {
      invokeStartElement (pctxt, "destination", -1);

      stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->destination);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "destination", -1);
   }

   /* decode dynamicRTPPayloadType */

   if (pvalue->m.dynamicRTPPayloadTypePresent) {
      invokeStartElement (pctxt, "dynamicRTPPayloadType", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->dynamicRTPPayloadType, 96U, 127U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->dynamicRTPPayloadType);

      invokeEndElement (pctxt, "dynamicRTPPayloadType", -1);
   }

   /* decode mediaPacketization */

   if (pvalue->m.mediaPacketizationPresent) {
      invokeStartElement (pctxt, "mediaPacketization", -1);

      stat = asn1PD_H245H2250LogicalChannelParameters_mediaPacketization (pctxt, &pvalue->mediaPacketization);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "mediaPacketization", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 3 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.transportCapabilityPresent = 1;

                     invokeStartElement (pctxt, "transportCapability", -1);

                     stat = asn1PD_H245TransportCapability (pctxt, &pvalue->transportCapability);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "transportCapability", -1);
                     break;

                  case 1:
                     pvalue->m.redundancyEncodingPresent = 1;

                     invokeStartElement (pctxt, "redundancyEncoding", -1);

                     stat = asn1PD_H245RedundancyEncoding (pctxt, &pvalue->redundancyEncoding);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "redundancyEncoding", -1);
                     break;

                  case 2:
                     pvalue->m.sourcePresent = 1;

                     invokeStartElement (pctxt, "source", -1);

                     stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->source);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "source", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannel_forwardLogicalChannelParameters_multi  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters (OOCTXT* pctxt, H245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* h222LogicalChannelParameters */
         case 0:
            invokeStartElement (pctxt, "h222LogicalChannelParameters", -1);

            pvalue->u.h222LogicalChannelParameters = ALLOC_ASN1ELEM (pctxt, H245H222LogicalChannelParameters);

            stat = asn1PD_H245H222LogicalChannelParameters (pctxt, pvalue->u.h222LogicalChannelParameters);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h222LogicalChannelParameters", -1);

            break;

         /* h223LogicalChannelParameters */
         case 1:
            invokeStartElement (pctxt, "h223LogicalChannelParameters", -1);

            pvalue->u.h223LogicalChannelParameters = ALLOC_ASN1ELEM (pctxt, H245H223LogicalChannelParameters);

            stat = asn1PD_H245H223LogicalChannelParameters (pctxt, pvalue->u.h223LogicalChannelParameters);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h223LogicalChannelParameters", -1);

            break;

         /* v76LogicalChannelParameters */
         case 2:
            invokeStartElement (pctxt, "v76LogicalChannelParameters", -1);

            pvalue->u.v76LogicalChannelParameters = ALLOC_ASN1ELEM (pctxt, H245V76LogicalChannelParameters);

            stat = asn1PD_H245V76LogicalChannelParameters (pctxt, pvalue->u.v76LogicalChannelParameters);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "v76LogicalChannelParameters", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* h2250LogicalChannelParameters */
         case 4:
            invokeStartElement (pctxt, "h2250LogicalChannelParameters", -1);

            pvalue->u.h2250LogicalChannelParameters = ALLOC_ASN1ELEM (pctxt, H245H2250LogicalChannelParameters);

            stat = asn1PD_H245H2250LogicalChannelParameters (pctxt, pvalue->u.h2250LogicalChannelParameters);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h2250LogicalChannelParameters", -1);

            break;

         /* none */
         case 5:
            invokeStartElement (pctxt, "none", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "none", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannel_forwardLogicalChannelParameters        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245OpenLogicalChannel_forwardLogicalChannelParameters (OOCTXT* pctxt, H245OpenLogicalChannel_forwardLogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.portNumberPresent = optbit;

   /* decode portNumber */

   if (pvalue->m.portNumberPresent) {
      invokeStartElement (pctxt, "portNumber", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->portNumber, 0U, 65535U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->portNumber);

      invokeEndElement (pctxt, "portNumber", -1);
   }

   /* decode dataType */

   invokeStartElement (pctxt, "dataType", -1);

   stat = asn1PD_H245DataType (pctxt, &pvalue->dataType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "dataType", -1);

   /* decode multiplexParameters */

   invokeStartElement (pctxt, "multiplexParameters", -1);

   stat = asn1PD_H245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters (pctxt, &pvalue->multiplexParameters);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "multiplexParameters", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 2 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.forwardLogicalChannelDependencyPresent = 1;

                     invokeStartElement (pctxt, "forwardLogicalChannelDependency", -1);

                     stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->forwardLogicalChannelDependency);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "forwardLogicalChannelDependency", -1);
                     break;

                  case 1:
                     pvalue->m.replacementForPresent = 1;

                     invokeStartElement (pctxt, "replacementFor", -1);

                     stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->replacementFor);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "replacementFor", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannel_reverseLogicalChannelParameters_multi  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters (OOCTXT* pctxt, H245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* h223LogicalChannelParameters */
         case 0:
            invokeStartElement (pctxt, "h223LogicalChannelParameters", -1);

            pvalue->u.h223LogicalChannelParameters = ALLOC_ASN1ELEM (pctxt, H245H223LogicalChannelParameters);

            stat = asn1PD_H245H223LogicalChannelParameters (pctxt, pvalue->u.h223LogicalChannelParameters);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h223LogicalChannelParameters", -1);

            break;

         /* v76LogicalChannelParameters */
         case 1:
            invokeStartElement (pctxt, "v76LogicalChannelParameters", -1);

            pvalue->u.v76LogicalChannelParameters = ALLOC_ASN1ELEM (pctxt, H245V76LogicalChannelParameters);

            stat = asn1PD_H245V76LogicalChannelParameters (pctxt, pvalue->u.v76LogicalChannelParameters);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "v76LogicalChannelParameters", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* h2250LogicalChannelParameters */
         case 3:
            invokeStartElement (pctxt, "h2250LogicalChannelParameters", -1);

            pvalue->u.h2250LogicalChannelParameters = ALLOC_ASN1ELEM (pctxt, H245H2250LogicalChannelParameters);

            stat = asn1PD_H245H2250LogicalChannelParameters (pctxt, pvalue->u.h2250LogicalChannelParameters);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h2250LogicalChannelParameters", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannel_reverseLogicalChannelParameters        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245OpenLogicalChannel_reverseLogicalChannelParameters (OOCTXT* pctxt, H245OpenLogicalChannel_reverseLogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.multiplexParametersPresent = optbit;

   /* decode dataType */

   invokeStartElement (pctxt, "dataType", -1);

   stat = asn1PD_H245DataType (pctxt, &pvalue->dataType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "dataType", -1);

   /* decode multiplexParameters */

   if (pvalue->m.multiplexParametersPresent) {
      invokeStartElement (pctxt, "multiplexParameters", -1);

      stat = asn1PD_H245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters (pctxt, &pvalue->multiplexParameters);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "multiplexParameters", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 2 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.reverseLogicalChannelDependencyPresent = 1;

                     invokeStartElement (pctxt, "reverseLogicalChannelDependency", -1);

                     stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->reverseLogicalChannelDependency);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "reverseLogicalChannelDependency", -1);
                     break;

                  case 1:
                     pvalue->m.replacementForPresent = 1;

                     invokeStartElement (pctxt, "replacementFor", -1);

                     stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->replacementFor);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "replacementFor", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetworkAccessParameters_distribution                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245NetworkAccessParameters_distribution (OOCTXT* pctxt, H245NetworkAccessParameters_distribution* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* unicast */
         case 0:
            invokeStartElement (pctxt, "unicast", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unicast", -1);

            break;

         /* multicast */
         case 1:
            invokeStartElement (pctxt, "multicast", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "multicast", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetworkAccessParameters_networkAddress                    */
/*                                                            */
/**************************************************************/

extern EXTERN const char* gs_MULTIMEDIA_SYSTEM_CONTROL_NetworkAccessParameters_networkAddress_e164Address_CharSet;

EXTERN int asn1PD_H245NetworkAccessParameters_networkAddress (OOCTXT* pctxt, H245NetworkAccessParameters_networkAddress* pvalue)
{
   static Asn1SizeCnst e164Address_lsize1 = { 0, 1, 128, 0 };
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* q2931Address */
         case 0:
            invokeStartElement (pctxt, "q2931Address", -1);

            pvalue->u.q2931Address = ALLOC_ASN1ELEM (pctxt, H245Q2931Address);

            stat = asn1PD_H245Q2931Address (pctxt, pvalue->u.q2931Address);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "q2931Address", -1);

            break;

         /* e164Address */
         case 1:
            invokeStartElement (pctxt, "e164Address", -1);

            addSizeConstraint (pctxt, &e164Address_lsize1);

            stat = decodeConstrainedStringEx (pctxt, &pvalue->u.e164Address, gs_MULTIMEDIA_SYSTEM_CONTROL_NetworkAccessParameters_networkAddress_e164Address_CharSet, 4, 4, 7);
            if (stat != ASN_OK) return stat;
            invokeCharStrValue (pctxt, pvalue->u.e164Address);

            invokeEndElement (pctxt, "e164Address", -1);

            break;

         /* localAreaAddress */
         case 2:
            invokeStartElement (pctxt, "localAreaAddress", -1);

            pvalue->u.localAreaAddress = ALLOC_ASN1ELEM (pctxt, H245TransportAddress);

            stat = asn1PD_H245TransportAddress (pctxt, pvalue->u.localAreaAddress);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "localAreaAddress", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetworkAccessParameters_externalReference                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245NetworkAccessParameters_externalReference (OOCTXT* pctxt, H245NetworkAccessParameters_externalReference* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 255, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetworkAccessParameters_t120SetupProcedure                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245NetworkAccessParameters_t120SetupProcedure (OOCTXT* pctxt, H245NetworkAccessParameters_t120SetupProcedure* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* originateCall */
         case 0:
            invokeStartElement (pctxt, "originateCall", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "originateCall", -1);

            break;

         /* waitForCall */
         case 1:
            invokeStartElement (pctxt, "waitForCall", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "waitForCall", -1);

            break;

         /* issueQuery */
         case 2:
            invokeStartElement (pctxt, "issueQuery", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "issueQuery", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetworkAccessParameters                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245NetworkAccessParameters (OOCTXT* pctxt, H245NetworkAccessParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.distributionPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.externalReferencePresent = optbit;

   /* decode distribution */

   if (pvalue->m.distributionPresent) {
      invokeStartElement (pctxt, "distribution", -1);

      stat = asn1PD_H245NetworkAccessParameters_distribution (pctxt, &pvalue->distribution);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "distribution", -1);
   }

   /* decode networkAddress */

   invokeStartElement (pctxt, "networkAddress", -1);

   stat = asn1PD_H245NetworkAccessParameters_networkAddress (pctxt, &pvalue->networkAddress);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "networkAddress", -1);

   /* decode associateConference */

   invokeStartElement (pctxt, "associateConference", -1);

   stat = DECODEBIT (pctxt, &pvalue->associateConference);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->associateConference);

   invokeEndElement (pctxt, "associateConference", -1);

   /* decode externalReference */

   if (pvalue->m.externalReferencePresent) {
      invokeStartElement (pctxt, "externalReference", -1);

      stat = asn1PD_H245NetworkAccessParameters_externalReference (pctxt, &pvalue->externalReference);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "externalReference", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.t120SetupProcedurePresent = 1;

                     invokeStartElement (pctxt, "t120SetupProcedure", -1);

                     stat = asn1PD_H245NetworkAccessParameters_t120SetupProcedure (pctxt, &pvalue->t120SetupProcedure);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "t120SetupProcedure", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EscrowData_escrowValue                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EscrowData_escrowValue (OOCTXT* pctxt, H245EscrowData_escrowValue* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeBitString (pctxt,
                        &pvalue->numbits,
                        pvalue->data,
                        sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;

   invokeBitStrValue (pctxt, pvalue->numbits, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EscrowData                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EscrowData (OOCTXT* pctxt, H245EscrowData* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode escrowID */

   invokeStartElement (pctxt, "escrowID", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->escrowID);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->escrowID.numids, pvalue->escrowID.subid);

   invokeEndElement (pctxt, "escrowID", -1);

   /* decode escrowValue */

   invokeStartElement (pctxt, "escrowValue", -1);

   stat = asn1PD_H245EscrowData_escrowValue (pctxt, &pvalue->escrowValue);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "escrowValue", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionSync_escrowentry                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EncryptionSync_escrowentry (OOCTXT* pctxt, H245EncryptionSync_escrowentry* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245EscrowData* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245EscrowData);

      stat = asn1PD_H245EscrowData (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionSync                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EncryptionSync (OOCTXT* pctxt, H245EncryptionSync* pvalue)
{
   static Asn1SizeCnst h235Key_lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonStandardPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.escrowentryPresent = optbit;

   /* decode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      invokeStartElement (pctxt, "nonStandard", -1);

      stat = asn1PD_H245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "nonStandard", -1);
   }

   /* decode synchFlag */

   invokeStartElement (pctxt, "synchFlag", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->synchFlag, 0U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->synchFlag);

   invokeEndElement (pctxt, "synchFlag", -1);

   /* decode h235Key */

   invokeStartElement (pctxt, "h235Key", -1);

   addSizeConstraint (pctxt, &h235Key_lsize1);

   stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->h235Key);
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->h235Key.numocts, pvalue->h235Key.data);

   invokeEndElement (pctxt, "h235Key", -1);

   /* decode escrowentry */

   if (pvalue->m.escrowentryPresent) {
      invokeStartElement (pctxt, "escrowentry", -1);

      stat = asn1PD_H245EncryptionSync_escrowentry (pctxt, &pvalue->escrowentry);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "escrowentry", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannel                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245OpenLogicalChannel (OOCTXT* pctxt, H245OpenLogicalChannel* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.reverseLogicalChannelParametersPresent = optbit;

   /* decode forwardLogicalChannelNumber */

   invokeStartElement (pctxt, "forwardLogicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "forwardLogicalChannelNumber", -1);

   /* decode forwardLogicalChannelParameters */

   invokeStartElement (pctxt, "forwardLogicalChannelParameters", -1);

   stat = asn1PD_H245OpenLogicalChannel_forwardLogicalChannelParameters (pctxt, &pvalue->forwardLogicalChannelParameters);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "forwardLogicalChannelParameters", -1);

   /* decode reverseLogicalChannelParameters */

   if (pvalue->m.reverseLogicalChannelParametersPresent) {
      invokeStartElement (pctxt, "reverseLogicalChannelParameters", -1);

      stat = asn1PD_H245OpenLogicalChannel_reverseLogicalChannelParameters (pctxt, &pvalue->reverseLogicalChannelParameters);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "reverseLogicalChannelParameters", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 2 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.separateStackPresent = 1;

                     invokeStartElement (pctxt, "separateStack", -1);

                     stat = asn1PD_H245NetworkAccessParameters (pctxt, &pvalue->separateStack);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "separateStack", -1);
                     break;

                  case 1:
                     pvalue->m.encryptionSyncPresent = 1;

                     invokeStartElement (pctxt, "encryptionSync", -1);

                     stat = asn1PD_H245EncryptionSync (pctxt, &pvalue->encryptionSync);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "encryptionSync", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CloseLogicalChannel_source                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CloseLogicalChannel_source (OOCTXT* pctxt, H245CloseLogicalChannel_source* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* user */
      case 0:
         invokeStartElement (pctxt, "user", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "user", -1);

         break;

      /* lcse */
      case 1:
         invokeStartElement (pctxt, "lcse", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "lcse", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CloseLogicalChannel_reason                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CloseLogicalChannel_reason (OOCTXT* pctxt, H245CloseLogicalChannel_reason* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* unknown */
         case 0:
            invokeStartElement (pctxt, "unknown", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unknown", -1);

            break;

         /* reopen */
         case 1:
            invokeStartElement (pctxt, "reopen", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "reopen", -1);

            break;

         /* reservationFailure */
         case 2:
            invokeStartElement (pctxt, "reservationFailure", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "reservationFailure", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CloseLogicalChannel                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CloseLogicalChannel (OOCTXT* pctxt, H245CloseLogicalChannel* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode forwardLogicalChannelNumber */

   invokeStartElement (pctxt, "forwardLogicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "forwardLogicalChannelNumber", -1);

   /* decode source */

   invokeStartElement (pctxt, "source", -1);

   stat = asn1PD_H245CloseLogicalChannel_source (pctxt, &pvalue->source);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "source", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.reasonPresent = 1;

                     invokeStartElement (pctxt, "reason", -1);

                     stat = asn1PD_H245CloseLogicalChannel_reason (pctxt, &pvalue->reason);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "reason", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestChannelClose_reason                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestChannelClose_reason (OOCTXT* pctxt, H245RequestChannelClose_reason* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* unknown */
         case 0:
            invokeStartElement (pctxt, "unknown", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unknown", -1);

            break;

         /* normal */
         case 1:
            invokeStartElement (pctxt, "normal", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "normal", -1);

            break;

         /* reopen */
         case 2:
            invokeStartElement (pctxt, "reopen", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "reopen", -1);

            break;

         /* reservationFailure */
         case 3:
            invokeStartElement (pctxt, "reservationFailure", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "reservationFailure", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 5;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestChannelClose                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestChannelClose (OOCTXT* pctxt, H245RequestChannelClose* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode forwardLogicalChannelNumber */

   invokeStartElement (pctxt, "forwardLogicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "forwardLogicalChannelNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 2 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.qosCapabilityPresent = 1;

                     invokeStartElement (pctxt, "qosCapability", -1);

                     stat = asn1PD_H245QOSCapability (pctxt, &pvalue->qosCapability);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "qosCapability", -1);
                     break;

                  case 1:
                     pvalue->m.reasonPresent = 1;

                     invokeStartElement (pctxt, "reason", -1);

                     stat = asn1PD_H245RequestChannelClose_reason (pctxt, &pvalue->reason);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "reason", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexTableEntryNumber                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexTableEntryNumber (OOCTXT* pctxt, H245MultiplexTableEntryNumber* pvalue)
{
   int stat = ASN_OK;

   stat = decodeConsUInt8 (pctxt, pvalue, 1U, 15U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, *pvalue);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexElement_type_subElementList                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexElement_type_subElementList (OOCTXT* pctxt, H245MultiplexElement_type_subElementList* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 2, 255, 0 };
   int stat = ASN_OK;
   H245MultiplexElement* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245MultiplexElement);

      stat = asn1PD_H245MultiplexElement (pctxt, (H245MultiplexElement*)pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexElement_type                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexElement_type (OOCTXT* pctxt, H245MultiplexElement_type* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* logicalChannelNumber */
      case 0:
         invokeStartElement (pctxt, "logicalChannelNumber", -1);

         stat = decodeConsUInt16 (pctxt, &pvalue->u.logicalChannelNumber, 0U, 65535U);
         if (stat != ASN_OK) return stat;
         invokeUIntValue (pctxt, pvalue->u.logicalChannelNumber);

         invokeEndElement (pctxt, "logicalChannelNumber", -1);

         break;

      /* subElementList */
      case 1:
         invokeStartElement (pctxt, "subElementList", -1);

         pvalue->u.subElementList = ALLOC_ASN1ELEM (pctxt, H245MultiplexElement_type_subElementList);

         stat = asn1PD_H245MultiplexElement_type_subElementList (pctxt, pvalue->u.subElementList);
         if (stat != ASN_OK) return stat;

         invokeEndElement (pctxt, "subElementList", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexElement_repeatCount                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexElement_repeatCount (OOCTXT* pctxt, H245MultiplexElement_repeatCount* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* finite */
      case 0:
         invokeStartElement (pctxt, "finite", -1);

         stat = decodeConsUInt16 (pctxt, &pvalue->u.finite, 1U, 65535U);
         if (stat != ASN_OK) return stat;
         invokeUIntValue (pctxt, pvalue->u.finite);

         invokeEndElement (pctxt, "finite", -1);

         break;

      /* untilClosingFlag */
      case 1:
         invokeStartElement (pctxt, "untilClosingFlag", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "untilClosingFlag", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexElement                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexElement (OOCTXT* pctxt, H245MultiplexElement* pvalue)
{
   int stat = ASN_OK;

   /* decode type */

   invokeStartElement (pctxt, "type", -1);

   stat = asn1PD_H245MultiplexElement_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "type", -1);

   /* decode repeatCount */

   invokeStartElement (pctxt, "repeatCount", -1);

   stat = asn1PD_H245MultiplexElement_repeatCount (pctxt, &pvalue->repeatCount);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "repeatCount", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntryDescriptor_elementList                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexEntryDescriptor_elementList (OOCTXT* pctxt, H245MultiplexEntryDescriptor_elementList* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245MultiplexElement* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245MultiplexElement);

      stat = asn1PD_H245MultiplexElement (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntryDescriptor                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexEntryDescriptor (OOCTXT* pctxt, H245MultiplexEntryDescriptor* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL optbit;

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.elementListPresent = optbit;

   /* decode multiplexTableEntryNumber */

   invokeStartElement (pctxt, "multiplexTableEntryNumber", -1);

   stat = asn1PD_H245MultiplexTableEntryNumber (pctxt, &pvalue->multiplexTableEntryNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "multiplexTableEntryNumber", -1);

   /* decode elementList */

   if (pvalue->m.elementListPresent) {
      invokeStartElement (pctxt, "elementList", -1);

      stat = asn1PD_H245MultiplexEntryDescriptor_elementList (pctxt, &pvalue->elementList);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "elementList", -1);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySend_multiplexEntryDescriptors              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexEntrySend_multiplexEntryDescriptors (OOCTXT* pctxt, H245MultiplexEntrySend_multiplexEntryDescriptors* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   H245MultiplexEntryDescriptor* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245MultiplexEntryDescriptor);

      stat = asn1PD_H245MultiplexEntryDescriptor (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySend                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexEntrySend (OOCTXT* pctxt, H245MultiplexEntrySend* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode multiplexEntryDescriptors */

   invokeStartElement (pctxt, "multiplexEntryDescriptors", -1);

   stat = asn1PD_H245MultiplexEntrySend_multiplexEntryDescriptors (pctxt, &pvalue->multiplexEntryDescriptors);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "multiplexEntryDescriptors", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntry_entryNumbers                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMultiplexEntry_entryNumbers (OOCTXT* pctxt, H245RequestMultiplexEntry_entryNumbers* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = asn1PD_H245MultiplexTableEntryNumber (pctxt, &pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntry                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMultiplexEntry (OOCTXT* pctxt, H245RequestMultiplexEntry* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode entryNumbers */

   invokeStartElement (pctxt, "entryNumbers", -1);

   stat = asn1PD_H245RequestMultiplexEntry_entryNumbers (pctxt, &pvalue->entryNumbers);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "entryNumbers", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H261VideoMode_resolution                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H261VideoMode_resolution (OOCTXT* pctxt, H245H261VideoMode_resolution* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* qcif */
      case 0:
         invokeStartElement (pctxt, "qcif", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "qcif", -1);

         break;

      /* cif */
      case 1:
         invokeStartElement (pctxt, "cif", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "cif", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H261VideoMode                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H261VideoMode (OOCTXT* pctxt, H245H261VideoMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode resolution */

   invokeStartElement (pctxt, "resolution", -1);

   stat = asn1PD_H245H261VideoMode_resolution (pctxt, &pvalue->resolution);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "resolution", -1);

   /* decode bitRate */

   invokeStartElement (pctxt, "bitRate", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->bitRate, 1U, 19200U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->bitRate);

   invokeEndElement (pctxt, "bitRate", -1);

   /* decode stillImageTransmission */

   invokeStartElement (pctxt, "stillImageTransmission", -1);

   stat = DECODEBIT (pctxt, &pvalue->stillImageTransmission);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->stillImageTransmission);

   invokeEndElement (pctxt, "stillImageTransmission", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H262VideoMode_profileAndLevel                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H262VideoMode_profileAndLevel (OOCTXT* pctxt, H245H262VideoMode_profileAndLevel* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 10);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* profileAndLevel_SPatML */
         case 0:
            invokeStartElement (pctxt, "profileAndLevel_SPatML", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "profileAndLevel_SPatML", -1);

            break;

         /* profileAndLevel_MPatLL */
         case 1:
            invokeStartElement (pctxt, "profileAndLevel_MPatLL", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "profileAndLevel_MPatLL", -1);

            break;

         /* profileAndLevel_MPatML */
         case 2:
            invokeStartElement (pctxt, "profileAndLevel_MPatML", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "profileAndLevel_MPatML", -1);

            break;

         /* profileAndLevel_MPatH_14 */
         case 3:
            invokeStartElement (pctxt, "profileAndLevel_MPatH_14", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "profileAndLevel_MPatH_14", -1);

            break;

         /* profileAndLevel_MPatHL */
         case 4:
            invokeStartElement (pctxt, "profileAndLevel_MPatHL", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "profileAndLevel_MPatHL", -1);

            break;

         /* profileAndLevel_SNRatLL */
         case 5:
            invokeStartElement (pctxt, "profileAndLevel_SNRatLL", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "profileAndLevel_SNRatLL", -1);

            break;

         /* profileAndLevel_SNRatML */
         case 6:
            invokeStartElement (pctxt, "profileAndLevel_SNRatML", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "profileAndLevel_SNRatML", -1);

            break;

         /* profileAndLevel_SpatialatH_14 */
         case 7:
            invokeStartElement (pctxt, "profileAndLevel_SpatialatH_14", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "profileAndLevel_SpatialatH_14", -1);

            break;

         /* profileAndLevel_HPatML */
         case 8:
            invokeStartElement (pctxt, "profileAndLevel_HPatML", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "profileAndLevel_HPatML", -1);

            break;

         /* profileAndLevel_HPatH_14 */
         case 9:
            invokeStartElement (pctxt, "profileAndLevel_HPatH_14", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "profileAndLevel_HPatH_14", -1);

            break;

         /* profileAndLevel_HPatHL */
         case 10:
            invokeStartElement (pctxt, "profileAndLevel_HPatHL", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "profileAndLevel_HPatHL", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 12;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H262VideoMode                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H262VideoMode (OOCTXT* pctxt, H245H262VideoMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.videoBitRatePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.vbvBufferSizePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.samplesPerLinePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.linesPerFramePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.framesPerSecondPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.luminanceSampleRatePresent = optbit;

   /* decode profileAndLevel */

   invokeStartElement (pctxt, "profileAndLevel", -1);

   stat = asn1PD_H245H262VideoMode_profileAndLevel (pctxt, &pvalue->profileAndLevel);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "profileAndLevel", -1);

   /* decode videoBitRate */

   if (pvalue->m.videoBitRatePresent) {
      invokeStartElement (pctxt, "videoBitRate", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->videoBitRate, 0U, 1073741823U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->videoBitRate);

      invokeEndElement (pctxt, "videoBitRate", -1);
   }

   /* decode vbvBufferSize */

   if (pvalue->m.vbvBufferSizePresent) {
      invokeStartElement (pctxt, "vbvBufferSize", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->vbvBufferSize, 0U, 262143U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->vbvBufferSize);

      invokeEndElement (pctxt, "vbvBufferSize", -1);
   }

   /* decode samplesPerLine */

   if (pvalue->m.samplesPerLinePresent) {
      invokeStartElement (pctxt, "samplesPerLine", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->samplesPerLine, 0U, 16383U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->samplesPerLine);

      invokeEndElement (pctxt, "samplesPerLine", -1);
   }

   /* decode linesPerFrame */

   if (pvalue->m.linesPerFramePresent) {
      invokeStartElement (pctxt, "linesPerFrame", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->linesPerFrame, 0U, 16383U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->linesPerFrame);

      invokeEndElement (pctxt, "linesPerFrame", -1);
   }

   /* decode framesPerSecond */

   if (pvalue->m.framesPerSecondPresent) {
      invokeStartElement (pctxt, "framesPerSecond", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->framesPerSecond, 0U, 15U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->framesPerSecond);

      invokeEndElement (pctxt, "framesPerSecond", -1);
   }

   /* decode luminanceSampleRate */

   if (pvalue->m.luminanceSampleRatePresent) {
      invokeStartElement (pctxt, "luminanceSampleRate", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->luminanceSampleRate, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->luminanceSampleRate);

      invokeEndElement (pctxt, "luminanceSampleRate", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263VideoMode_resolution                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H263VideoMode_resolution (OOCTXT* pctxt, H245H263VideoMode_resolution* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 4);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* sqcif */
         case 0:
            invokeStartElement (pctxt, "sqcif", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "sqcif", -1);

            break;

         /* qcif */
         case 1:
            invokeStartElement (pctxt, "qcif", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "qcif", -1);

            break;

         /* cif */
         case 2:
            invokeStartElement (pctxt, "cif", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "cif", -1);

            break;

         /* cif4 */
         case 3:
            invokeStartElement (pctxt, "cif4", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "cif4", -1);

            break;

         /* cif16 */
         case 4:
            invokeStartElement (pctxt, "cif16", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "cif16", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 6;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* custom */
         case 6:
            invokeStartElement (pctxt, "custom", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "custom", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263VideoMode                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H263VideoMode (OOCTXT* pctxt, H245H263VideoMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   /* decode resolution */

   invokeStartElement (pctxt, "resolution", -1);

   stat = asn1PD_H245H263VideoMode_resolution (pctxt, &pvalue->resolution);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "resolution", -1);

   /* decode bitRate */

   invokeStartElement (pctxt, "bitRate", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->bitRate, 1U, 19200U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->bitRate);

   invokeEndElement (pctxt, "bitRate", -1);

   /* decode unrestrictedVector */

   invokeStartElement (pctxt, "unrestrictedVector", -1);

   stat = DECODEBIT (pctxt, &pvalue->unrestrictedVector);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->unrestrictedVector);

   invokeEndElement (pctxt, "unrestrictedVector", -1);

   /* decode arithmeticCoding */

   invokeStartElement (pctxt, "arithmeticCoding", -1);

   stat = DECODEBIT (pctxt, &pvalue->arithmeticCoding);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->arithmeticCoding);

   invokeEndElement (pctxt, "arithmeticCoding", -1);

   /* decode advancedPrediction */

   invokeStartElement (pctxt, "advancedPrediction", -1);

   stat = DECODEBIT (pctxt, &pvalue->advancedPrediction);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->advancedPrediction);

   invokeEndElement (pctxt, "advancedPrediction", -1);

   /* decode pbFrames */

   invokeStartElement (pctxt, "pbFrames", -1);

   stat = DECODEBIT (pctxt, &pvalue->pbFrames);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->pbFrames);

   invokeEndElement (pctxt, "pbFrames", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 3 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.errorCompensationPresent = 1;

                     invokeStartElement (pctxt, "errorCompensation", -1);

                     stat = DECODEBIT (pctxt, &pvalue->errorCompensation);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->errorCompensation);

                     invokeEndElement (pctxt, "errorCompensation", -1);
                     break;

                  case 1:
                     pvalue->m.enhancementLayerInfoPresent = 1;

                     invokeStartElement (pctxt, "enhancementLayerInfo", -1);

                     stat = asn1PD_H245EnhancementLayerInfo (pctxt, &pvalue->enhancementLayerInfo);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "enhancementLayerInfo", -1);
                     break;

                  case 2:
                     pvalue->m.h263OptionsPresent = 1;

                     invokeStartElement (pctxt, "h263Options", -1);

                     stat = asn1PD_H245H263Options (pctxt, &pvalue->h263Options);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "h263Options", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172VideoMode                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS11172VideoMode (OOCTXT* pctxt, H245IS11172VideoMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.videoBitRatePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.vbvBufferSizePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.samplesPerLinePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.linesPerFramePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.pictureRatePresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.luminanceSampleRatePresent = optbit;

   /* decode constrainedBitstream */

   invokeStartElement (pctxt, "constrainedBitstream", -1);

   stat = DECODEBIT (pctxt, &pvalue->constrainedBitstream);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->constrainedBitstream);

   invokeEndElement (pctxt, "constrainedBitstream", -1);

   /* decode videoBitRate */

   if (pvalue->m.videoBitRatePresent) {
      invokeStartElement (pctxt, "videoBitRate", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->videoBitRate, 0U, 1073741823U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->videoBitRate);

      invokeEndElement (pctxt, "videoBitRate", -1);
   }

   /* decode vbvBufferSize */

   if (pvalue->m.vbvBufferSizePresent) {
      invokeStartElement (pctxt, "vbvBufferSize", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->vbvBufferSize, 0U, 262143U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->vbvBufferSize);

      invokeEndElement (pctxt, "vbvBufferSize", -1);
   }

   /* decode samplesPerLine */

   if (pvalue->m.samplesPerLinePresent) {
      invokeStartElement (pctxt, "samplesPerLine", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->samplesPerLine, 0U, 16383U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->samplesPerLine);

      invokeEndElement (pctxt, "samplesPerLine", -1);
   }

   /* decode linesPerFrame */

   if (pvalue->m.linesPerFramePresent) {
      invokeStartElement (pctxt, "linesPerFrame", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->linesPerFrame, 0U, 16383U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->linesPerFrame);

      invokeEndElement (pctxt, "linesPerFrame", -1);
   }

   /* decode pictureRate */

   if (pvalue->m.pictureRatePresent) {
      invokeStartElement (pctxt, "pictureRate", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->pictureRate, 0U, 15U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->pictureRate);

      invokeEndElement (pctxt, "pictureRate", -1);
   }

   /* decode luminanceSampleRate */

   if (pvalue->m.luminanceSampleRatePresent) {
      invokeStartElement (pctxt, "luminanceSampleRate", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->luminanceSampleRate, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->luminanceSampleRate);

      invokeEndElement (pctxt, "luminanceSampleRate", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VideoMode                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VideoMode (OOCTXT* pctxt, H245VideoMode* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 4);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* h261VideoMode */
         case 1:
            invokeStartElement (pctxt, "h261VideoMode", -1);

            pvalue->u.h261VideoMode = ALLOC_ASN1ELEM (pctxt, H245H261VideoMode);

            stat = asn1PD_H245H261VideoMode (pctxt, pvalue->u.h261VideoMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h261VideoMode", -1);

            break;

         /* h262VideoMode */
         case 2:
            invokeStartElement (pctxt, "h262VideoMode", -1);

            pvalue->u.h262VideoMode = ALLOC_ASN1ELEM (pctxt, H245H262VideoMode);

            stat = asn1PD_H245H262VideoMode (pctxt, pvalue->u.h262VideoMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h262VideoMode", -1);

            break;

         /* h263VideoMode */
         case 3:
            invokeStartElement (pctxt, "h263VideoMode", -1);

            pvalue->u.h263VideoMode = ALLOC_ASN1ELEM (pctxt, H245H263VideoMode);

            stat = asn1PD_H245H263VideoMode (pctxt, pvalue->u.h263VideoMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h263VideoMode", -1);

            break;

         /* is11172VideoMode */
         case 4:
            invokeStartElement (pctxt, "is11172VideoMode", -1);

            pvalue->u.is11172VideoMode = ALLOC_ASN1ELEM (pctxt, H245IS11172VideoMode);

            stat = asn1PD_H245IS11172VideoMode (pctxt, pvalue->u.is11172VideoMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "is11172VideoMode", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 6;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* genericVideoMode */
         case 6:
            invokeStartElement (pctxt, "genericVideoMode", -1);

            pvalue->u.genericVideoMode = ALLOC_ASN1ELEM (pctxt, H245GenericCapability);

            stat = asn1PD_H245GenericCapability (pctxt, pvalue->u.genericVideoMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "genericVideoMode", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioMode_g7231                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245AudioMode_g7231 (OOCTXT* pctxt, H245AudioMode_g7231* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* noSilenceSuppressionLowRate */
      case 0:
         invokeStartElement (pctxt, "noSilenceSuppressionLowRate", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "noSilenceSuppressionLowRate", -1);

         break;

      /* noSilenceSuppressionHighRate */
      case 1:
         invokeStartElement (pctxt, "noSilenceSuppressionHighRate", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "noSilenceSuppressionHighRate", -1);

         break;

      /* silenceSuppressionLowRate */
      case 2:
         invokeStartElement (pctxt, "silenceSuppressionLowRate", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "silenceSuppressionLowRate", -1);

         break;

      /* silenceSuppressionHighRate */
      case 3:
         invokeStartElement (pctxt, "silenceSuppressionHighRate", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "silenceSuppressionHighRate", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172AudioMode_audioLayer                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS11172AudioMode_audioLayer (OOCTXT* pctxt, H245IS11172AudioMode_audioLayer* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* audioLayer1 */
      case 0:
         invokeStartElement (pctxt, "audioLayer1", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioLayer1", -1);

         break;

      /* audioLayer2 */
      case 1:
         invokeStartElement (pctxt, "audioLayer2", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioLayer2", -1);

         break;

      /* audioLayer3 */
      case 2:
         invokeStartElement (pctxt, "audioLayer3", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioLayer3", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172AudioMode_audioSampling                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS11172AudioMode_audioSampling (OOCTXT* pctxt, H245IS11172AudioMode_audioSampling* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* audioSampling32k */
      case 0:
         invokeStartElement (pctxt, "audioSampling32k", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioSampling32k", -1);

         break;

      /* audioSampling44k1 */
      case 1:
         invokeStartElement (pctxt, "audioSampling44k1", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioSampling44k1", -1);

         break;

      /* audioSampling48k */
      case 2:
         invokeStartElement (pctxt, "audioSampling48k", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioSampling48k", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172AudioMode_multichannelType                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS11172AudioMode_multichannelType (OOCTXT* pctxt, H245IS11172AudioMode_multichannelType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* singleChannel */
      case 0:
         invokeStartElement (pctxt, "singleChannel", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "singleChannel", -1);

         break;

      /* twoChannelStereo */
      case 1:
         invokeStartElement (pctxt, "twoChannelStereo", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "twoChannelStereo", -1);

         break;

      /* twoChannelDual */
      case 2:
         invokeStartElement (pctxt, "twoChannelDual", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "twoChannelDual", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172AudioMode                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS11172AudioMode (OOCTXT* pctxt, H245IS11172AudioMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode audioLayer */

   invokeStartElement (pctxt, "audioLayer", -1);

   stat = asn1PD_H245IS11172AudioMode_audioLayer (pctxt, &pvalue->audioLayer);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "audioLayer", -1);

   /* decode audioSampling */

   invokeStartElement (pctxt, "audioSampling", -1);

   stat = asn1PD_H245IS11172AudioMode_audioSampling (pctxt, &pvalue->audioSampling);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "audioSampling", -1);

   /* decode multichannelType */

   invokeStartElement (pctxt, "multichannelType", -1);

   stat = asn1PD_H245IS11172AudioMode_multichannelType (pctxt, &pvalue->multichannelType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "multichannelType", -1);

   /* decode bitRate */

   invokeStartElement (pctxt, "bitRate", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->bitRate, 1U, 448U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->bitRate);

   invokeEndElement (pctxt, "bitRate", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS13818AudioMode_audioLayer                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS13818AudioMode_audioLayer (OOCTXT* pctxt, H245IS13818AudioMode_audioLayer* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* audioLayer1 */
      case 0:
         invokeStartElement (pctxt, "audioLayer1", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioLayer1", -1);

         break;

      /* audioLayer2 */
      case 1:
         invokeStartElement (pctxt, "audioLayer2", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioLayer2", -1);

         break;

      /* audioLayer3 */
      case 2:
         invokeStartElement (pctxt, "audioLayer3", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioLayer3", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS13818AudioMode_audioSampling                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS13818AudioMode_audioSampling (OOCTXT* pctxt, H245IS13818AudioMode_audioSampling* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 5);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* audioSampling16k */
      case 0:
         invokeStartElement (pctxt, "audioSampling16k", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioSampling16k", -1);

         break;

      /* audioSampling22k05 */
      case 1:
         invokeStartElement (pctxt, "audioSampling22k05", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioSampling22k05", -1);

         break;

      /* audioSampling24k */
      case 2:
         invokeStartElement (pctxt, "audioSampling24k", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioSampling24k", -1);

         break;

      /* audioSampling32k */
      case 3:
         invokeStartElement (pctxt, "audioSampling32k", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioSampling32k", -1);

         break;

      /* audioSampling44k1 */
      case 4:
         invokeStartElement (pctxt, "audioSampling44k1", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioSampling44k1", -1);

         break;

      /* audioSampling48k */
      case 5:
         invokeStartElement (pctxt, "audioSampling48k", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "audioSampling48k", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS13818AudioMode_multichannelType                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS13818AudioMode_multichannelType (OOCTXT* pctxt, H245IS13818AudioMode_multichannelType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 9);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* singleChannel */
      case 0:
         invokeStartElement (pctxt, "singleChannel", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "singleChannel", -1);

         break;

      /* twoChannelStereo */
      case 1:
         invokeStartElement (pctxt, "twoChannelStereo", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "twoChannelStereo", -1);

         break;

      /* twoChannelDual */
      case 2:
         invokeStartElement (pctxt, "twoChannelDual", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "twoChannelDual", -1);

         break;

      /* threeChannels2_1 */
      case 3:
         invokeStartElement (pctxt, "threeChannels2_1", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "threeChannels2_1", -1);

         break;

      /* threeChannels3_0 */
      case 4:
         invokeStartElement (pctxt, "threeChannels3_0", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "threeChannels3_0", -1);

         break;

      /* fourChannels2_0_2_0 */
      case 5:
         invokeStartElement (pctxt, "fourChannels2_0_2_0", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "fourChannels2_0_2_0", -1);

         break;

      /* fourChannels2_2 */
      case 6:
         invokeStartElement (pctxt, "fourChannels2_2", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "fourChannels2_2", -1);

         break;

      /* fourChannels3_1 */
      case 7:
         invokeStartElement (pctxt, "fourChannels3_1", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "fourChannels3_1", -1);

         break;

      /* fiveChannels3_0_2_0 */
      case 8:
         invokeStartElement (pctxt, "fiveChannels3_0_2_0", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "fiveChannels3_0_2_0", -1);

         break;

      /* fiveChannels3_2 */
      case 9:
         invokeStartElement (pctxt, "fiveChannels3_2", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "fiveChannels3_2", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS13818AudioMode                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245IS13818AudioMode (OOCTXT* pctxt, H245IS13818AudioMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode audioLayer */

   invokeStartElement (pctxt, "audioLayer", -1);

   stat = asn1PD_H245IS13818AudioMode_audioLayer (pctxt, &pvalue->audioLayer);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "audioLayer", -1);

   /* decode audioSampling */

   invokeStartElement (pctxt, "audioSampling", -1);

   stat = asn1PD_H245IS13818AudioMode_audioSampling (pctxt, &pvalue->audioSampling);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "audioSampling", -1);

   /* decode multichannelType */

   invokeStartElement (pctxt, "multichannelType", -1);

   stat = asn1PD_H245IS13818AudioMode_multichannelType (pctxt, &pvalue->multichannelType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "multichannelType", -1);

   /* decode lowFrequencyEnhancement */

   invokeStartElement (pctxt, "lowFrequencyEnhancement", -1);

   stat = DECODEBIT (pctxt, &pvalue->lowFrequencyEnhancement);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->lowFrequencyEnhancement);

   invokeEndElement (pctxt, "lowFrequencyEnhancement", -1);

   /* decode multilingual */

   invokeStartElement (pctxt, "multilingual", -1);

   stat = DECODEBIT (pctxt, &pvalue->multilingual);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->multilingual);

   invokeEndElement (pctxt, "multilingual", -1);

   /* decode bitRate */

   invokeStartElement (pctxt, "bitRate", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->bitRate, 1U, 1130U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->bitRate);

   invokeEndElement (pctxt, "bitRate", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  G7231AnnexCMode_g723AnnexCAudioMode                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245G7231AnnexCMode_g723AnnexCAudioMode (OOCTXT* pctxt, H245G7231AnnexCMode_g723AnnexCAudioMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode highRateMode0 */

   invokeStartElement (pctxt, "highRateMode0", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->highRateMode0, 27U, 78U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->highRateMode0);

   invokeEndElement (pctxt, "highRateMode0", -1);

   /* decode highRateMode1 */

   invokeStartElement (pctxt, "highRateMode1", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->highRateMode1, 27U, 78U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->highRateMode1);

   invokeEndElement (pctxt, "highRateMode1", -1);

   /* decode lowRateMode0 */

   invokeStartElement (pctxt, "lowRateMode0", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->lowRateMode0, 23U, 66U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->lowRateMode0);

   invokeEndElement (pctxt, "lowRateMode0", -1);

   /* decode lowRateMode1 */

   invokeStartElement (pctxt, "lowRateMode1", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->lowRateMode1, 23U, 66U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->lowRateMode1);

   invokeEndElement (pctxt, "lowRateMode1", -1);

   /* decode sidMode0 */

   invokeStartElement (pctxt, "sidMode0", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->sidMode0, 6U, 17U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->sidMode0);

   invokeEndElement (pctxt, "sidMode0", -1);

   /* decode sidMode1 */

   invokeStartElement (pctxt, "sidMode1", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->sidMode1, 6U, 17U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->sidMode1);

   invokeEndElement (pctxt, "sidMode1", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  G7231AnnexCMode                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245G7231AnnexCMode (OOCTXT* pctxt, H245G7231AnnexCMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode maxAl_sduAudioFrames */

   invokeStartElement (pctxt, "maxAl_sduAudioFrames", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maxAl_sduAudioFrames, 1U, 256U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxAl_sduAudioFrames);

   invokeEndElement (pctxt, "maxAl_sduAudioFrames", -1);

   /* decode silenceSuppression */

   invokeStartElement (pctxt, "silenceSuppression", -1);

   stat = DECODEBIT (pctxt, &pvalue->silenceSuppression);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->silenceSuppression);

   invokeEndElement (pctxt, "silenceSuppression", -1);

   /* decode g723AnnexCAudioMode */

   invokeStartElement (pctxt, "g723AnnexCAudioMode", -1);

   stat = asn1PD_H245G7231AnnexCMode_g723AnnexCAudioMode (pctxt, &pvalue->g723AnnexCAudioMode);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "g723AnnexCAudioMode", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VBDMode                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245VBDMode (OOCTXT* pctxt, H245VBDMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode type */

   invokeStartElement (pctxt, "type", -1);

   pvalue->type = ALLOC_ASN1ELEM (pctxt, H245AudioMode);

   stat = asn1PD_H245AudioMode (pctxt, (H245AudioMode*)pvalue->type);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "type", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioMode                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245AudioMode (OOCTXT* pctxt, H245AudioMode* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 13);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* g711Alaw64k */
         case 1:
            invokeStartElement (pctxt, "g711Alaw64k", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "g711Alaw64k", -1);

            break;

         /* g711Alaw56k */
         case 2:
            invokeStartElement (pctxt, "g711Alaw56k", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "g711Alaw56k", -1);

            break;

         /* g711Ulaw64k */
         case 3:
            invokeStartElement (pctxt, "g711Ulaw64k", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "g711Ulaw64k", -1);

            break;

         /* g711Ulaw56k */
         case 4:
            invokeStartElement (pctxt, "g711Ulaw56k", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "g711Ulaw56k", -1);

            break;

         /* g722_64k */
         case 5:
            invokeStartElement (pctxt, "g722_64k", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "g722_64k", -1);

            break;

         /* g722_56k */
         case 6:
            invokeStartElement (pctxt, "g722_56k", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "g722_56k", -1);

            break;

         /* g722_48k */
         case 7:
            invokeStartElement (pctxt, "g722_48k", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "g722_48k", -1);

            break;

         /* g728 */
         case 8:
            invokeStartElement (pctxt, "g728", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "g728", -1);

            break;

         /* g729 */
         case 9:
            invokeStartElement (pctxt, "g729", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "g729", -1);

            break;

         /* g729AnnexA */
         case 10:
            invokeStartElement (pctxt, "g729AnnexA", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "g729AnnexA", -1);

            break;

         /* g7231 */
         case 11:
            invokeStartElement (pctxt, "g7231", -1);

            pvalue->u.g7231 = ALLOC_ASN1ELEM (pctxt, H245AudioMode_g7231);

            stat = asn1PD_H245AudioMode_g7231 (pctxt, pvalue->u.g7231);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "g7231", -1);

            break;

         /* is11172AudioMode */
         case 12:
            invokeStartElement (pctxt, "is11172AudioMode", -1);

            pvalue->u.is11172AudioMode = ALLOC_ASN1ELEM (pctxt, H245IS11172AudioMode);

            stat = asn1PD_H245IS11172AudioMode (pctxt, pvalue->u.is11172AudioMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "is11172AudioMode", -1);

            break;

         /* is13818AudioMode */
         case 13:
            invokeStartElement (pctxt, "is13818AudioMode", -1);

            pvalue->u.is13818AudioMode = ALLOC_ASN1ELEM (pctxt, H245IS13818AudioMode);

            stat = asn1PD_H245IS13818AudioMode (pctxt, pvalue->u.is13818AudioMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "is13818AudioMode", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 15;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* g729wAnnexB */
         case 15:
            invokeStartElement (pctxt, "g729wAnnexB", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g729wAnnexB, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g729wAnnexB);

            invokeEndElement (pctxt, "g729wAnnexB", -1);

            break;

         /* g729AnnexAwAnnexB */
         case 16:
            invokeStartElement (pctxt, "g729AnnexAwAnnexB", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.g729AnnexAwAnnexB, 1U, 256U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.g729AnnexAwAnnexB);

            invokeEndElement (pctxt, "g729AnnexAwAnnexB", -1);

            break;

         /* g7231AnnexCMode */
         case 17:
            invokeStartElement (pctxt, "g7231AnnexCMode", -1);

            pvalue->u.g7231AnnexCMode = ALLOC_ASN1ELEM (pctxt, H245G7231AnnexCMode);

            stat = asn1PD_H245G7231AnnexCMode (pctxt, pvalue->u.g7231AnnexCMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "g7231AnnexCMode", -1);

            break;

         /* gsmFullRate */
         case 18:
            invokeStartElement (pctxt, "gsmFullRate", -1);

            pvalue->u.gsmFullRate = ALLOC_ASN1ELEM (pctxt, H245GSMAudioCapability);

            stat = asn1PD_H245GSMAudioCapability (pctxt, pvalue->u.gsmFullRate);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "gsmFullRate", -1);

            break;

         /* gsmHalfRate */
         case 19:
            invokeStartElement (pctxt, "gsmHalfRate", -1);

            pvalue->u.gsmHalfRate = ALLOC_ASN1ELEM (pctxt, H245GSMAudioCapability);

            stat = asn1PD_H245GSMAudioCapability (pctxt, pvalue->u.gsmHalfRate);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "gsmHalfRate", -1);

            break;

         /* gsmEnhancedFullRate */
         case 20:
            invokeStartElement (pctxt, "gsmEnhancedFullRate", -1);

            pvalue->u.gsmEnhancedFullRate = ALLOC_ASN1ELEM (pctxt, H245GSMAudioCapability);

            stat = asn1PD_H245GSMAudioCapability (pctxt, pvalue->u.gsmEnhancedFullRate);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "gsmEnhancedFullRate", -1);

            break;

         /* genericAudioMode */
         case 21:
            invokeStartElement (pctxt, "genericAudioMode", -1);

            pvalue->u.genericAudioMode = ALLOC_ASN1ELEM (pctxt, H245GenericCapability);

            stat = asn1PD_H245GenericCapability (pctxt, pvalue->u.genericAudioMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "genericAudioMode", -1);

            break;

         /* g729Extensions */
         case 22:
            invokeStartElement (pctxt, "g729Extensions", -1);

            pvalue->u.g729Extensions = ALLOC_ASN1ELEM (pctxt, H245G729Extensions);

            stat = asn1PD_H245G729Extensions (pctxt, pvalue->u.g729Extensions);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "g729Extensions", -1);

            break;

         /* vbd */
         case 23:
            invokeStartElement (pctxt, "vbd", -1);

            pvalue->u.vbd = ALLOC_ASN1ELEM (pctxt, H245VBDMode);

            stat = asn1PD_H245VBDMode (pctxt, pvalue->u.vbd);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "vbd", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataMode_application_nlpid                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataMode_application_nlpid (OOCTXT* pctxt, H245DataMode_application_nlpid* pvalue)
{
   int stat = ASN_OK;

   /* decode nlpidProtocol */

   invokeStartElement (pctxt, "nlpidProtocol", -1);

   stat = asn1PD_H245DataProtocolCapability (pctxt, &pvalue->nlpidProtocol);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "nlpidProtocol", -1);

   /* decode nlpidData */

   invokeStartElement (pctxt, "nlpidData", -1);

   stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->nlpidData);
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->nlpidData.numocts, pvalue->nlpidData.data);

   invokeEndElement (pctxt, "nlpidData", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataMode_application_t38fax                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataMode_application_t38fax (OOCTXT* pctxt, H245DataMode_application_t38fax* pvalue)
{
   int stat = ASN_OK;

   /* decode t38FaxProtocol */

   invokeStartElement (pctxt, "t38FaxProtocol", -1);

   stat = asn1PD_H245DataProtocolCapability (pctxt, &pvalue->t38FaxProtocol);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "t38FaxProtocol", -1);

   /* decode t38FaxProfile */

   invokeStartElement (pctxt, "t38FaxProfile", -1);

   stat = asn1PD_H245T38FaxProfile (pctxt, &pvalue->t38FaxProfile);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "t38FaxProfile", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataMode_application                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataMode_application (OOCTXT* pctxt, H245DataMode_application* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 9);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* t120 */
         case 1:
            invokeStartElement (pctxt, "t120", -1);

            pvalue->u.t120 = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.t120);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t120", -1);

            break;

         /* dsm_cc */
         case 2:
            invokeStartElement (pctxt, "dsm_cc", -1);

            pvalue->u.dsm_cc = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.dsm_cc);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "dsm_cc", -1);

            break;

         /* userData */
         case 3:
            invokeStartElement (pctxt, "userData", -1);

            pvalue->u.userData = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.userData);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "userData", -1);

            break;

         /* t84 */
         case 4:
            invokeStartElement (pctxt, "t84", -1);

            pvalue->u.t84 = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.t84);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t84", -1);

            break;

         /* t434 */
         case 5:
            invokeStartElement (pctxt, "t434", -1);

            pvalue->u.t434 = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.t434);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t434", -1);

            break;

         /* h224 */
         case 6:
            invokeStartElement (pctxt, "h224", -1);

            pvalue->u.h224 = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.h224);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h224", -1);

            break;

         /* nlpid */
         case 7:
            invokeStartElement (pctxt, "nlpid", -1);

            pvalue->u.nlpid = ALLOC_ASN1ELEM (pctxt, H245DataMode_application_nlpid);

            stat = asn1PD_H245DataMode_application_nlpid (pctxt, pvalue->u.nlpid);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nlpid", -1);

            break;

         /* dsvdControl */
         case 8:
            invokeStartElement (pctxt, "dsvdControl", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "dsvdControl", -1);

            break;

         /* h222DataPartitioning */
         case 9:
            invokeStartElement (pctxt, "h222DataPartitioning", -1);

            pvalue->u.h222DataPartitioning = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.h222DataPartitioning);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h222DataPartitioning", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 11;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* t30fax */
         case 11:
            invokeStartElement (pctxt, "t30fax", -1);

            pvalue->u.t30fax = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.t30fax);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t30fax", -1);

            break;

         /* t140 */
         case 12:
            invokeStartElement (pctxt, "t140", -1);

            pvalue->u.t140 = ALLOC_ASN1ELEM (pctxt, H245DataProtocolCapability);

            stat = asn1PD_H245DataProtocolCapability (pctxt, pvalue->u.t140);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t140", -1);

            break;

         /* t38fax */
         case 13:
            invokeStartElement (pctxt, "t38fax", -1);

            pvalue->u.t38fax = ALLOC_ASN1ELEM (pctxt, H245DataMode_application_t38fax);

            stat = asn1PD_H245DataMode_application_t38fax (pctxt, pvalue->u.t38fax);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "t38fax", -1);

            break;

         /* genericDataMode */
         case 14:
            invokeStartElement (pctxt, "genericDataMode", -1);

            pvalue->u.genericDataMode = ALLOC_ASN1ELEM (pctxt, H245GenericCapability);

            stat = asn1PD_H245GenericCapability (pctxt, pvalue->u.genericDataMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "genericDataMode", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataMode                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DataMode (OOCTXT* pctxt, H245DataMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode application */

   invokeStartElement (pctxt, "application", -1);

   stat = asn1PD_H245DataMode_application (pctxt, &pvalue->application);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "application", -1);

   /* decode bitRate */

   invokeStartElement (pctxt, "bitRate", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->bitRate, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->bitRate);

   invokeEndElement (pctxt, "bitRate", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H235Mode_mediaMode                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H235Mode_mediaMode (OOCTXT* pctxt, H245H235Mode_mediaMode* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* videoMode */
         case 1:
            invokeStartElement (pctxt, "videoMode", -1);

            pvalue->u.videoMode = ALLOC_ASN1ELEM (pctxt, H245VideoMode);

            stat = asn1PD_H245VideoMode (pctxt, pvalue->u.videoMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "videoMode", -1);

            break;

         /* audioMode */
         case 2:
            invokeStartElement (pctxt, "audioMode", -1);

            pvalue->u.audioMode = ALLOC_ASN1ELEM (pctxt, H245AudioMode);

            stat = asn1PD_H245AudioMode (pctxt, pvalue->u.audioMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "audioMode", -1);

            break;

         /* dataMode */
         case 3:
            invokeStartElement (pctxt, "dataMode", -1);

            pvalue->u.dataMode = ALLOC_ASN1ELEM (pctxt, H245DataMode);

            stat = asn1PD_H245DataMode (pctxt, pvalue->u.dataMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "dataMode", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 5;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H235Mode                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H235Mode (OOCTXT* pctxt, H245H235Mode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode encryptionAuthenticationAndIntegrity */

   invokeStartElement (pctxt, "encryptionAuthenticationAndIntegrity", -1);

   stat = asn1PD_H245EncryptionAuthenticationAndIntegrity (pctxt, &pvalue->encryptionAuthenticationAndIntegrity);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "encryptionAuthenticationAndIntegrity", -1);

   /* decode mediaMode */

   invokeStartElement (pctxt, "mediaMode", -1);

   stat = asn1PD_H245H235Mode_mediaMode (pctxt, &pvalue->mediaMode);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "mediaMode", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingDTModeElement_type                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RedundancyEncodingDTModeElement_type (OOCTXT* pctxt, H245RedundancyEncodingDTModeElement_type* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 5);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* videoMode */
         case 1:
            invokeStartElement (pctxt, "videoMode", -1);

            pvalue->u.videoMode = ALLOC_ASN1ELEM (pctxt, H245VideoMode);

            stat = asn1PD_H245VideoMode (pctxt, pvalue->u.videoMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "videoMode", -1);

            break;

         /* audioMode */
         case 2:
            invokeStartElement (pctxt, "audioMode", -1);

            pvalue->u.audioMode = ALLOC_ASN1ELEM (pctxt, H245AudioMode);

            stat = asn1PD_H245AudioMode (pctxt, pvalue->u.audioMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "audioMode", -1);

            break;

         /* dataMode */
         case 3:
            invokeStartElement (pctxt, "dataMode", -1);

            pvalue->u.dataMode = ALLOC_ASN1ELEM (pctxt, H245DataMode);

            stat = asn1PD_H245DataMode (pctxt, pvalue->u.dataMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "dataMode", -1);

            break;

         /* encryptionMode */
         case 4:
            invokeStartElement (pctxt, "encryptionMode", -1);

            pvalue->u.encryptionMode = ALLOC_ASN1ELEM (pctxt, H245EncryptionMode);

            stat = asn1PD_H245EncryptionMode (pctxt, pvalue->u.encryptionMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "encryptionMode", -1);

            break;

         /* h235Mode */
         case 5:
            invokeStartElement (pctxt, "h235Mode", -1);

            pvalue->u.h235Mode = ALLOC_ASN1ELEM (pctxt, H245H235Mode);

            stat = asn1PD_H245H235Mode (pctxt, pvalue->u.h235Mode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h235Mode", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 7;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingDTModeElement                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RedundancyEncodingDTModeElement (OOCTXT* pctxt, H245RedundancyEncodingDTModeElement* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode type */

   invokeStartElement (pctxt, "type", -1);

   stat = asn1PD_H245RedundancyEncodingDTModeElement_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "type", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245RedundancyEncodingDTModeElement                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SeqOfH245RedundancyEncodingDTModeElement (OOCTXT* pctxt, H245_SeqOfH245RedundancyEncodingDTModeElement* pvalue)
{
   int stat = ASN_OK;
   H245RedundancyEncodingDTModeElement* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;
   int lstat;

   dListInit (pvalue);

   for (;;) {
      /* decode length determinant */

      lstat = decodeLength (pctxt, &count);
      if (lstat != ASN_OK && lstat != ASN_OK_FRAG) {
         return lstat;
      }

      /* decode elements */

      for (xx1 = 0; xx1 < count; xx1++) {
         invokeStartElement (pctxt, "elem", xx1);

         pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245RedundancyEncodingDTModeElement);

         stat = asn1PD_H245RedundancyEncodingDTModeElement (pctxt, pdata);
         if (stat != ASN_OK) return stat;
         invokeEndElement (pctxt, "elem", xx1);

         dListAppendNode (pctxt, pvalue, pdata);
      }

      if(lstat == ASN_OK) break;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingDTMode                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RedundancyEncodingDTMode (OOCTXT* pctxt, H245RedundancyEncodingDTMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode redundancyEncodingMethod */

   invokeStartElement (pctxt, "redundancyEncodingMethod", -1);

   stat = asn1PD_H245RedundancyEncodingMethod (pctxt, &pvalue->redundancyEncodingMethod);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "redundancyEncodingMethod", -1);

   /* decode primary */

   invokeStartElement (pctxt, "primary", -1);

   stat = asn1PD_H245RedundancyEncodingDTModeElement (pctxt, &pvalue->primary);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "primary", -1);

   /* decode secondary */

   invokeStartElement (pctxt, "secondary", -1);

   stat = asn1PD_H245_SeqOfH245RedundancyEncodingDTModeElement (pctxt, &pvalue->secondary);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "secondary", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStreamElementMode                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplePayloadStreamElementMode (OOCTXT* pctxt, H245MultiplePayloadStreamElementMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode type */

   invokeStartElement (pctxt, "type", -1);

   pvalue->type = ALLOC_ASN1ELEM (pctxt, H245ModeElementType);

   stat = asn1PD_H245ModeElementType (pctxt, (H245ModeElementType*)pvalue->type);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "type", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245MultiplePayloadStreamElementMode                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SeqOfH245MultiplePayloadStreamElementMode (OOCTXT* pctxt, H245_SeqOfH245MultiplePayloadStreamElementMode* pvalue)
{
   int stat = ASN_OK;
   H245MultiplePayloadStreamElementMode* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;
   int lstat;

   dListInit (pvalue);

   for (;;) {
      /* decode length determinant */

      lstat = decodeLength (pctxt, &count);
      if (lstat != ASN_OK && lstat != ASN_OK_FRAG) {
         return lstat;
      }

      /* decode elements */

      for (xx1 = 0; xx1 < count; xx1++) {
         invokeStartElement (pctxt, "elem", xx1);

         pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245MultiplePayloadStreamElementMode);

         stat = asn1PD_H245MultiplePayloadStreamElementMode (pctxt, pdata);
         if (stat != ASN_OK) return stat;
         invokeEndElement (pctxt, "elem", xx1);

         dListAppendNode (pctxt, pvalue, pdata);
      }

      if(lstat == ASN_OK) break;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStreamMode                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplePayloadStreamMode (OOCTXT* pctxt, H245MultiplePayloadStreamMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode elements */

   invokeStartElement (pctxt, "elements", -1);

   stat = asn1PD_H245_SeqOfH245MultiplePayloadStreamElementMode (pctxt, &pvalue->elements);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "elements", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode_rfc2733Mode_mode_separateStream_differentPort     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECMode_rfc2733Mode_mode_separateStream_differentPort (OOCTXT* pctxt, H245FECMode_rfc2733Mode_mode_separateStream_differentPort* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.protectedPayloadTypePresent = optbit;

   /* decode protectedSessionID */

   invokeStartElement (pctxt, "protectedSessionID", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->protectedSessionID, 1U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->protectedSessionID);

   invokeEndElement (pctxt, "protectedSessionID", -1);

   /* decode protectedPayloadType */

   if (pvalue->m.protectedPayloadTypePresent) {
      invokeStartElement (pctxt, "protectedPayloadType", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->protectedPayloadType, 0U, 127U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->protectedPayloadType);

      invokeEndElement (pctxt, "protectedPayloadType", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode_rfc2733Mode_mode_separateStream_samePort          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECMode_rfc2733Mode_mode_separateStream_samePort (OOCTXT* pctxt, H245FECMode_rfc2733Mode_mode_separateStream_samePort* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode protectedType */

   invokeStartElement (pctxt, "protectedType", -1);

   pvalue->protectedType = ALLOC_ASN1ELEM (pctxt, H245ModeElementType);

   stat = asn1PD_H245ModeElementType (pctxt, (H245ModeElementType*)pvalue->protectedType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "protectedType", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode_rfc2733Mode_mode_separateStream                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECMode_rfc2733Mode_mode_separateStream (OOCTXT* pctxt, H245FECMode_rfc2733Mode_mode_separateStream* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* differentPort */
         case 0:
            invokeStartElement (pctxt, "differentPort", -1);

            pvalue->u.differentPort = ALLOC_ASN1ELEM (pctxt, H245FECMode_rfc2733Mode_mode_separateStream_differentPort);

            stat = asn1PD_H245FECMode_rfc2733Mode_mode_separateStream_differentPort (pctxt, pvalue->u.differentPort);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "differentPort", -1);

            break;

         /* samePort */
         case 1:
            invokeStartElement (pctxt, "samePort", -1);

            pvalue->u.samePort = ALLOC_ASN1ELEM (pctxt, H245FECMode_rfc2733Mode_mode_separateStream_samePort);

            stat = asn1PD_H245FECMode_rfc2733Mode_mode_separateStream_samePort (pctxt, pvalue->u.samePort);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "samePort", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode_rfc2733Mode_mode                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECMode_rfc2733Mode_mode (OOCTXT* pctxt, H245FECMode_rfc2733Mode_mode* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* redundancyEncoding */
         case 0:
            invokeStartElement (pctxt, "redundancyEncoding", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "redundancyEncoding", -1);

            break;

         /* separateStream */
         case 1:
            invokeStartElement (pctxt, "separateStream", -1);

            pvalue->u.separateStream = ALLOC_ASN1ELEM (pctxt, H245FECMode_rfc2733Mode_mode_separateStream);

            stat = asn1PD_H245FECMode_rfc2733Mode_mode_separateStream (pctxt, pvalue->u.separateStream);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "separateStream", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode_rfc2733Mode                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECMode_rfc2733Mode (OOCTXT* pctxt, H245FECMode_rfc2733Mode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode mode */

   invokeStartElement (pctxt, "mode", -1);

   stat = asn1PD_H245FECMode_rfc2733Mode_mode (pctxt, &pvalue->mode);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "mode", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FECMode (OOCTXT* pctxt, H245FECMode* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* rfc2733Mode */
         case 0:
            invokeStartElement (pctxt, "rfc2733Mode", -1);

            pvalue->u.rfc2733Mode = ALLOC_ASN1ELEM (pctxt, H245FECMode_rfc2733Mode);

            stat = asn1PD_H245FECMode_rfc2733Mode (pctxt, pvalue->u.rfc2733Mode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "rfc2733Mode", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 2;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ModeElementType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ModeElementType (OOCTXT* pctxt, H245ModeElementType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 4);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* videoMode */
         case 1:
            invokeStartElement (pctxt, "videoMode", -1);

            pvalue->u.videoMode = ALLOC_ASN1ELEM (pctxt, H245VideoMode);

            stat = asn1PD_H245VideoMode (pctxt, pvalue->u.videoMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "videoMode", -1);

            break;

         /* audioMode */
         case 2:
            invokeStartElement (pctxt, "audioMode", -1);

            pvalue->u.audioMode = ALLOC_ASN1ELEM (pctxt, H245AudioMode);

            stat = asn1PD_H245AudioMode (pctxt, pvalue->u.audioMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "audioMode", -1);

            break;

         /* dataMode */
         case 3:
            invokeStartElement (pctxt, "dataMode", -1);

            pvalue->u.dataMode = ALLOC_ASN1ELEM (pctxt, H245DataMode);

            stat = asn1PD_H245DataMode (pctxt, pvalue->u.dataMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "dataMode", -1);

            break;

         /* encryptionMode */
         case 4:
            invokeStartElement (pctxt, "encryptionMode", -1);

            pvalue->u.encryptionMode = ALLOC_ASN1ELEM (pctxt, H245EncryptionMode);

            stat = asn1PD_H245EncryptionMode (pctxt, pvalue->u.encryptionMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "encryptionMode", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 6;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* h235Mode */
         case 6:
            invokeStartElement (pctxt, "h235Mode", -1);

            pvalue->u.h235Mode = ALLOC_ASN1ELEM (pctxt, H245H235Mode);

            stat = asn1PD_H245H235Mode (pctxt, pvalue->u.h235Mode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h235Mode", -1);

            break;

         /* multiplexedStreamMode */
         case 7:
            invokeStartElement (pctxt, "multiplexedStreamMode", -1);

            pvalue->u.multiplexedStreamMode = ALLOC_ASN1ELEM (pctxt, H245MultiplexedStreamParameter);

            stat = asn1PD_H245MultiplexedStreamParameter (pctxt, pvalue->u.multiplexedStreamMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multiplexedStreamMode", -1);

            break;

         /* redundancyEncodingDTMode */
         case 8:
            invokeStartElement (pctxt, "redundancyEncodingDTMode", -1);

            pvalue->u.redundancyEncodingDTMode = ALLOC_ASN1ELEM (pctxt, H245RedundancyEncodingDTMode);

            stat = asn1PD_H245RedundancyEncodingDTMode (pctxt, pvalue->u.redundancyEncodingDTMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "redundancyEncodingDTMode", -1);

            break;

         /* multiplePayloadStreamMode */
         case 9:
            invokeStartElement (pctxt, "multiplePayloadStreamMode", -1);

            pvalue->u.multiplePayloadStreamMode = ALLOC_ASN1ELEM (pctxt, H245MultiplePayloadStreamMode);

            stat = asn1PD_H245MultiplePayloadStreamMode (pctxt, pvalue->u.multiplePayloadStreamMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multiplePayloadStreamMode", -1);

            break;

         /* fecMode */
         case 10:
            invokeStartElement (pctxt, "fecMode", -1);

            pvalue->u.fecMode = ALLOC_ASN1ELEM (pctxt, H245FECMode);

            stat = asn1PD_H245FECMode (pctxt, pvalue->u.fecMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "fecMode", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223ModeParameters_adaptationLayerType_al3                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223ModeParameters_adaptationLayerType_al3 (OOCTXT* pctxt, H245H223ModeParameters_adaptationLayerType_al3* pvalue)
{
   int stat = ASN_OK;

   /* decode controlFieldOctets */

   invokeStartElement (pctxt, "controlFieldOctets", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->controlFieldOctets, 0U, 2U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->controlFieldOctets);

   invokeEndElement (pctxt, "controlFieldOctets", -1);

   /* decode sendBufferSize */

   invokeStartElement (pctxt, "sendBufferSize", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->sendBufferSize, 0U, 16777215U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->sendBufferSize);

   invokeEndElement (pctxt, "sendBufferSize", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223ModeParameters_adaptationLayerType                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223ModeParameters_adaptationLayerType (OOCTXT* pctxt, H245H223ModeParameters_adaptationLayerType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 5);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* al1Framed */
         case 1:
            invokeStartElement (pctxt, "al1Framed", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "al1Framed", -1);

            break;

         /* al1NotFramed */
         case 2:
            invokeStartElement (pctxt, "al1NotFramed", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "al1NotFramed", -1);

            break;

         /* al2WithoutSequenceNumbers */
         case 3:
            invokeStartElement (pctxt, "al2WithoutSequenceNumbers", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "al2WithoutSequenceNumbers", -1);

            break;

         /* al2WithSequenceNumbers */
         case 4:
            invokeStartElement (pctxt, "al2WithSequenceNumbers", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "al2WithSequenceNumbers", -1);

            break;

         /* al3 */
         case 5:
            invokeStartElement (pctxt, "al3", -1);

            pvalue->u.al3 = ALLOC_ASN1ELEM (pctxt, H245H223ModeParameters_adaptationLayerType_al3);

            stat = asn1PD_H245H223ModeParameters_adaptationLayerType_al3 (pctxt, pvalue->u.al3);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "al3", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 7;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* al1M */
         case 7:
            invokeStartElement (pctxt, "al1M", -1);

            pvalue->u.al1M = ALLOC_ASN1ELEM (pctxt, H245H223AL1MParameters);

            stat = asn1PD_H245H223AL1MParameters (pctxt, pvalue->u.al1M);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "al1M", -1);

            break;

         /* al2M */
         case 8:
            invokeStartElement (pctxt, "al2M", -1);

            pvalue->u.al2M = ALLOC_ASN1ELEM (pctxt, H245H223AL2MParameters);

            stat = asn1PD_H245H223AL2MParameters (pctxt, pvalue->u.al2M);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "al2M", -1);

            break;

         /* al3M */
         case 9:
            invokeStartElement (pctxt, "al3M", -1);

            pvalue->u.al3M = ALLOC_ASN1ELEM (pctxt, H245H223AL3MParameters);

            stat = asn1PD_H245H223AL3MParameters (pctxt, pvalue->u.al3M);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "al3M", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223ModeParameters                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H223ModeParameters (OOCTXT* pctxt, H245H223ModeParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode adaptationLayerType */

   invokeStartElement (pctxt, "adaptationLayerType", -1);

   stat = asn1PD_H245H223ModeParameters_adaptationLayerType (pctxt, &pvalue->adaptationLayerType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "adaptationLayerType", -1);

   /* decode segmentableFlag */

   invokeStartElement (pctxt, "segmentableFlag", -1);

   stat = DECODEBIT (pctxt, &pvalue->segmentableFlag);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->segmentableFlag);

   invokeEndElement (pctxt, "segmentableFlag", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76ModeParameters                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245V76ModeParameters (OOCTXT* pctxt, H245V76ModeParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* suspendResumewAddress */
         case 0:
            invokeStartElement (pctxt, "suspendResumewAddress", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "suspendResumewAddress", -1);

            break;

         /* suspendResumewoAddress */
         case 1:
            invokeStartElement (pctxt, "suspendResumewoAddress", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "suspendResumewoAddress", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingMode_secondaryEncoding                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RedundancyEncodingMode_secondaryEncoding (OOCTXT* pctxt, H245RedundancyEncodingMode_secondaryEncoding* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* audioData */
         case 1:
            invokeStartElement (pctxt, "audioData", -1);

            pvalue->u.audioData = ALLOC_ASN1ELEM (pctxt, H245AudioMode);

            stat = asn1PD_H245AudioMode (pctxt, pvalue->u.audioData);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "audioData", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingMode                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RedundancyEncodingMode (OOCTXT* pctxt, H245RedundancyEncodingMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.secondaryEncodingPresent = optbit;

   /* decode redundancyEncodingMethod */

   invokeStartElement (pctxt, "redundancyEncodingMethod", -1);

   stat = asn1PD_H245RedundancyEncodingMethod (pctxt, &pvalue->redundancyEncodingMethod);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "redundancyEncodingMethod", -1);

   /* decode secondaryEncoding */

   if (pvalue->m.secondaryEncodingPresent) {
      invokeStartElement (pctxt, "secondaryEncoding", -1);

      stat = asn1PD_H245RedundancyEncodingMode_secondaryEncoding (pctxt, &pvalue->secondaryEncoding);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "secondaryEncoding", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250ModeParameters                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H2250ModeParameters (OOCTXT* pctxt, H245H2250ModeParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.redundancyEncodingModePresent = optbit;

   /* decode redundancyEncodingMode */

   if (pvalue->m.redundancyEncodingModePresent) {
      invokeStartElement (pctxt, "redundancyEncodingMode", -1);

      stat = asn1PD_H245RedundancyEncodingMode (pctxt, &pvalue->redundancyEncodingMode);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "redundancyEncodingMode", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexedStreamModeParameters                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexedStreamModeParameters (OOCTXT* pctxt, H245MultiplexedStreamModeParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode logicalChannelNumber */

   invokeStartElement (pctxt, "logicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "logicalChannelNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ModeElement                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ModeElement (OOCTXT* pctxt, H245ModeElement* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.h223ModeParametersPresent = optbit;

   /* decode type */

   invokeStartElement (pctxt, "type", -1);

   stat = asn1PD_H245ModeElementType (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "type", -1);

   /* decode h223ModeParameters */

   if (pvalue->m.h223ModeParametersPresent) {
      invokeStartElement (pctxt, "h223ModeParameters", -1);

      stat = asn1PD_H245H223ModeParameters (pctxt, &pvalue->h223ModeParameters);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "h223ModeParameters", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 4 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.v76ModeParametersPresent = 1;

                     invokeStartElement (pctxt, "v76ModeParameters", -1);

                     stat = asn1PD_H245V76ModeParameters (pctxt, &pvalue->v76ModeParameters);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "v76ModeParameters", -1);
                     break;

                  case 1:
                     pvalue->m.h2250ModeParametersPresent = 1;

                     invokeStartElement (pctxt, "h2250ModeParameters", -1);

                     stat = asn1PD_H245H2250ModeParameters (pctxt, &pvalue->h2250ModeParameters);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "h2250ModeParameters", -1);
                     break;

                  case 2:
                     pvalue->m.genericModeParametersPresent = 1;

                     invokeStartElement (pctxt, "genericModeParameters", -1);

                     stat = asn1PD_H245GenericCapability (pctxt, &pvalue->genericModeParameters);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "genericModeParameters", -1);
                     break;

                  case 3:
                     pvalue->m.multiplexedStreamModeParametersPresent = 1;

                     invokeStartElement (pctxt, "multiplexedStreamModeParameters", -1);

                     stat = asn1PD_H245MultiplexedStreamModeParameters (pctxt, &pvalue->multiplexedStreamModeParameters);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "multiplexedStreamModeParameters", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ModeDescription                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ModeDescription (OOCTXT* pctxt, H245ModeDescription* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245ModeElement* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245ModeElement);

      stat = asn1PD_H245ModeElement (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMode_requestedModes                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMode_requestedModes (OOCTXT* pctxt, H245RequestMode_requestedModes* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245ModeDescription* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245ModeDescription);

      stat = asn1PD_H245ModeDescription (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMode                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMode (OOCTXT* pctxt, H245RequestMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode requestedModes */

   invokeStartElement (pctxt, "requestedModes", -1);

   stat = asn1PD_H245RequestMode_requestedModes (pctxt, &pvalue->requestedModes);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "requestedModes", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RoundTripDelayRequest                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RoundTripDelayRequest (OOCTXT* pctxt, H245RoundTripDelayRequest* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopRequest_type                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MaintenanceLoopRequest_type (OOCTXT* pctxt, H245MaintenanceLoopRequest_type* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* systemLoop */
         case 0:
            invokeStartElement (pctxt, "systemLoop", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "systemLoop", -1);

            break;

         /* mediaLoop */
         case 1:
            invokeStartElement (pctxt, "mediaLoop", -1);

            stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->u.mediaLoop);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "mediaLoop", -1);

            break;

         /* logicalChannelLoop */
         case 2:
            invokeStartElement (pctxt, "logicalChannelLoop", -1);

            stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->u.logicalChannelLoop);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "logicalChannelLoop", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopRequest                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MaintenanceLoopRequest (OOCTXT* pctxt, H245MaintenanceLoopRequest* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode type */

   invokeStartElement (pctxt, "type", -1);

   stat = asn1PD_H245MaintenanceLoopRequest_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "type", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeRequest                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CommunicationModeRequest (OOCTXT* pctxt, H245CommunicationModeRequest* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Criteria                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245Criteria (OOCTXT* pctxt, H245Criteria* pvalue)
{
   static Asn1SizeCnst value_lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode field */

   invokeStartElement (pctxt, "field", -1);

   stat = decodeObjectIdentifier (pctxt, &pvalue->field);
   if (stat != ASN_OK) return stat;
   invokeOidValue (pctxt, pvalue->field.numids, pvalue->field.subid);

   invokeEndElement (pctxt, "field", -1);

   /* decode value */

   invokeStartElement (pctxt, "value", -1);

   addSizeConstraint (pctxt, &value_lsize1);

   stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->value);
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->value.numocts, pvalue->value.data);

   invokeEndElement (pctxt, "value", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CertSelectionCriteria                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CertSelectionCriteria (OOCTXT* pctxt, H245CertSelectionCriteria* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   H245Criteria* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245Criteria);

      stat = asn1PD_H245Criteria (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceRequest_requestTerminalCertificate              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceRequest_requestTerminalCertificate (OOCTXT* pctxt, H245ConferenceRequest_requestTerminalCertificate* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.terminalLabelPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.certSelectionCriteriaPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.sRandomPresent = optbit;

   /* decode terminalLabel */

   if (pvalue->m.terminalLabelPresent) {
      invokeStartElement (pctxt, "terminalLabel", -1);

      stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "terminalLabel", -1);
   }

   /* decode certSelectionCriteria */

   if (pvalue->m.certSelectionCriteriaPresent) {
      invokeStartElement (pctxt, "certSelectionCriteria", -1);

      stat = asn1PD_H245CertSelectionCriteria (pctxt, &pvalue->certSelectionCriteria);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "certSelectionCriteria", -1);
   }

   /* decode sRandom */

   if (pvalue->m.sRandomPresent) {
      invokeStartElement (pctxt, "sRandom", -1);

      stat = decodeConsUnsigned (pctxt, &pvalue->sRandom, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->sRandom);

      invokeEndElement (pctxt, "sRandom", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RemoteMCRequest                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RemoteMCRequest (OOCTXT* pctxt, H245RemoteMCRequest* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* masterActivate */
         case 0:
            invokeStartElement (pctxt, "masterActivate", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "masterActivate", -1);

            break;

         /* slaveActivate */
         case 1:
            invokeStartElement (pctxt, "slaveActivate", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "slaveActivate", -1);

            break;

         /* deActivate */
         case 2:
            invokeStartElement (pctxt, "deActivate", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "deActivate", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceRequest                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceRequest (OOCTXT* pctxt, H245ConferenceRequest* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 7);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* terminalListRequest */
         case 0:
            invokeStartElement (pctxt, "terminalListRequest", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "terminalListRequest", -1);

            break;

         /* makeMeChair */
         case 1:
            invokeStartElement (pctxt, "makeMeChair", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "makeMeChair", -1);

            break;

         /* cancelMakeMeChair */
         case 2:
            invokeStartElement (pctxt, "cancelMakeMeChair", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "cancelMakeMeChair", -1);

            break;

         /* dropTerminal */
         case 3:
            invokeStartElement (pctxt, "dropTerminal", -1);

            pvalue->u.dropTerminal = ALLOC_ASN1ELEM (pctxt, H245TerminalLabel);

            stat = asn1PD_H245TerminalLabel (pctxt, pvalue->u.dropTerminal);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "dropTerminal", -1);

            break;

         /* requestTerminalID */
         case 4:
            invokeStartElement (pctxt, "requestTerminalID", -1);

            pvalue->u.requestTerminalID = ALLOC_ASN1ELEM (pctxt, H245TerminalLabel);

            stat = asn1PD_H245TerminalLabel (pctxt, pvalue->u.requestTerminalID);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestTerminalID", -1);

            break;

         /* enterH243Password */
         case 5:
            invokeStartElement (pctxt, "enterH243Password", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "enterH243Password", -1);

            break;

         /* enterH243TerminalID */
         case 6:
            invokeStartElement (pctxt, "enterH243TerminalID", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "enterH243TerminalID", -1);

            break;

         /* enterH243ConferenceID */
         case 7:
            invokeStartElement (pctxt, "enterH243ConferenceID", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "enterH243ConferenceID", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 9;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* enterExtensionAddress */
         case 9:
            invokeStartElement (pctxt, "enterExtensionAddress", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "enterExtensionAddress", -1);

            break;

         /* requestChairTokenOwner */
         case 10:
            invokeStartElement (pctxt, "requestChairTokenOwner", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "requestChairTokenOwner", -1);

            break;

         /* requestTerminalCertificate */
         case 11:
            invokeStartElement (pctxt, "requestTerminalCertificate", -1);

            pvalue->u.requestTerminalCertificate = ALLOC_ASN1ELEM (pctxt, H245ConferenceRequest_requestTerminalCertificate);

            stat = asn1PD_H245ConferenceRequest_requestTerminalCertificate (pctxt, pvalue->u.requestTerminalCertificate);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestTerminalCertificate", -1);

            break;

         /* broadcastMyLogicalChannel */
         case 12:
            invokeStartElement (pctxt, "broadcastMyLogicalChannel", -1);

            stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->u.broadcastMyLogicalChannel);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "broadcastMyLogicalChannel", -1);

            break;

         /* makeTerminalBroadcaster */
         case 13:
            invokeStartElement (pctxt, "makeTerminalBroadcaster", -1);

            pvalue->u.makeTerminalBroadcaster = ALLOC_ASN1ELEM (pctxt, H245TerminalLabel);

            stat = asn1PD_H245TerminalLabel (pctxt, pvalue->u.makeTerminalBroadcaster);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "makeTerminalBroadcaster", -1);

            break;

         /* sendThisSource */
         case 14:
            invokeStartElement (pctxt, "sendThisSource", -1);

            pvalue->u.sendThisSource = ALLOC_ASN1ELEM (pctxt, H245TerminalLabel);

            stat = asn1PD_H245TerminalLabel (pctxt, pvalue->u.sendThisSource);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "sendThisSource", -1);

            break;

         /* requestAllTerminalIDs */
         case 15:
            invokeStartElement (pctxt, "requestAllTerminalIDs", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "requestAllTerminalIDs", -1);

            break;

         /* remoteMCRequest */
         case 16:
            invokeStartElement (pctxt, "remoteMCRequest", -1);

            pvalue->u.remoteMCRequest = ALLOC_ASN1ELEM (pctxt, H245RemoteMCRequest);

            stat = asn1PD_H245RemoteMCRequest (pctxt, pvalue->u.remoteMCRequest);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "remoteMCRequest", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest_callInformation                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkRequest_callInformation (OOCTXT* pctxt, H245MultilinkRequest_callInformation* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode maxNumberOfAdditionalConnections */

   invokeStartElement (pctxt, "maxNumberOfAdditionalConnections", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->maxNumberOfAdditionalConnections, 1U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->maxNumberOfAdditionalConnections);

   invokeEndElement (pctxt, "maxNumberOfAdditionalConnections", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DialingInformationNetworkType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DialingInformationNetworkType (OOCTXT* pctxt, H245DialingInformationNetworkType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardMessage);

            stat = asn1PD_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* n_isdn */
         case 1:
            invokeStartElement (pctxt, "n_isdn", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "n_isdn", -1);

            break;

         /* gstn */
         case 2:
            invokeStartElement (pctxt, "gstn", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "gstn", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* mobile */
         case 4:
            invokeStartElement (pctxt, "mobile", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "mobile", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DialingInformationNumber_networkType                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DialingInformationNumber_networkType (OOCTXT* pctxt, H245DialingInformationNumber_networkType* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 255, 0 };
   int stat = ASN_OK;
   H245DialingInformationNetworkType* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245DialingInformationNetworkType);

      stat = asn1PD_H245DialingInformationNetworkType (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DialingInformationNumber                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DialingInformationNumber (OOCTXT* pctxt, H245DialingInformationNumber* pvalue)
{
   static Asn1SizeCnst networkAddress_lsize1 = { 0, 0, 40, 0 };
   static Asn1SizeCnst subAddress_lsize1 = { 0, 1, 40, 0 };
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.subAddressPresent = optbit;

   /* decode networkAddress */

   invokeStartElement (pctxt, "networkAddress", -1);

   addSizeConstraint (pctxt, &networkAddress_lsize1);

   stat = decodeConstrainedStringEx (pctxt, &pvalue->networkAddress, NUM_CANSET, 4, 4, 4);
   if (stat != ASN_OK) return stat;
   invokeCharStrValue (pctxt, pvalue->networkAddress);

   invokeEndElement (pctxt, "networkAddress", -1);

   /* decode subAddress */

   if (pvalue->m.subAddressPresent) {
      invokeStartElement (pctxt, "subAddress", -1);

      addSizeConstraint (pctxt, &subAddress_lsize1);

      stat = decodeConstrainedStringEx (pctxt, &pvalue->subAddress, 0, 8, 7, 7);
      if (stat != ASN_OK) return stat;
      invokeCharStrValue (pctxt, pvalue->subAddress);

      invokeEndElement (pctxt, "subAddress", -1);
   }

   /* decode networkType */

   invokeStartElement (pctxt, "networkType", -1);

   stat = asn1PD_H245DialingInformationNumber_networkType (pctxt, &pvalue->networkType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "networkType", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DialingInformation_differential                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DialingInformation_differential (OOCTXT* pctxt, H245DialingInformation_differential* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;
   H245DialingInformationNumber* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245DialingInformationNumber);

      stat = asn1PD_H245DialingInformationNumber (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DialingInformation                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245DialingInformation (OOCTXT* pctxt, H245DialingInformation* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardMessage);

            stat = asn1PD_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* differential */
         case 1:
            invokeStartElement (pctxt, "differential", -1);

            pvalue->u.differential = ALLOC_ASN1ELEM (pctxt, H245DialingInformation_differential);

            stat = asn1PD_H245DialingInformation_differential (pctxt, pvalue->u.differential);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "differential", -1);

            break;

         /* infoNotAvailable */
         case 2:
            invokeStartElement (pctxt, "infoNotAvailable", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.infoNotAvailable, 1U, 65535U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.infoNotAvailable);

            invokeEndElement (pctxt, "infoNotAvailable", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest_addConnection                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkRequest_addConnection (OOCTXT* pctxt, H245MultilinkRequest_addConnection* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode dialingInformation */

   invokeStartElement (pctxt, "dialingInformation", -1);

   stat = asn1PD_H245DialingInformation (pctxt, &pvalue->dialingInformation);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "dialingInformation", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConnectionIdentifier                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConnectionIdentifier (OOCTXT* pctxt, H245ConnectionIdentifier* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode channelTag */

   invokeStartElement (pctxt, "channelTag", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->channelTag, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->channelTag);

   invokeEndElement (pctxt, "channelTag", -1);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->sequenceNumber, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->sequenceNumber);

   invokeEndElement (pctxt, "sequenceNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest_removeConnection                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkRequest_removeConnection (OOCTXT* pctxt, H245MultilinkRequest_removeConnection* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode connectionIdentifier */

   invokeStartElement (pctxt, "connectionIdentifier", -1);

   stat = asn1PD_H245ConnectionIdentifier (pctxt, &pvalue->connectionIdentifier);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "connectionIdentifier", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest_maximumHeaderInterval_requestType        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkRequest_maximumHeaderInterval_requestType (OOCTXT* pctxt, H245MultilinkRequest_maximumHeaderInterval_requestType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* currentIntervalInformation */
         case 0:
            invokeStartElement (pctxt, "currentIntervalInformation", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "currentIntervalInformation", -1);

            break;

         /* requestedInterval */
         case 1:
            invokeStartElement (pctxt, "requestedInterval", -1);

            stat = decodeConsUInt16 (pctxt, &pvalue->u.requestedInterval, 0U, 65535U);
            if (stat != ASN_OK) return stat;
            invokeUIntValue (pctxt, pvalue->u.requestedInterval);

            invokeEndElement (pctxt, "requestedInterval", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest_maximumHeaderInterval                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkRequest_maximumHeaderInterval (OOCTXT* pctxt, H245MultilinkRequest_maximumHeaderInterval* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode requestType */

   invokeStartElement (pctxt, "requestType", -1);

   stat = asn1PD_H245MultilinkRequest_maximumHeaderInterval_requestType (pctxt, &pvalue->requestType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "requestType", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkRequest (OOCTXT* pctxt, H245MultilinkRequest* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 4);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardMessage);

            stat = asn1PD_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* callInformation */
         case 1:
            invokeStartElement (pctxt, "callInformation", -1);

            pvalue->u.callInformation = ALLOC_ASN1ELEM (pctxt, H245MultilinkRequest_callInformation);

            stat = asn1PD_H245MultilinkRequest_callInformation (pctxt, pvalue->u.callInformation);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "callInformation", -1);

            break;

         /* addConnection */
         case 2:
            invokeStartElement (pctxt, "addConnection", -1);

            pvalue->u.addConnection = ALLOC_ASN1ELEM (pctxt, H245MultilinkRequest_addConnection);

            stat = asn1PD_H245MultilinkRequest_addConnection (pctxt, pvalue->u.addConnection);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "addConnection", -1);

            break;

         /* removeConnection */
         case 3:
            invokeStartElement (pctxt, "removeConnection", -1);

            pvalue->u.removeConnection = ALLOC_ASN1ELEM (pctxt, H245MultilinkRequest_removeConnection);

            stat = asn1PD_H245MultilinkRequest_removeConnection (pctxt, pvalue->u.removeConnection);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "removeConnection", -1);

            break;

         /* maximumHeaderInterval */
         case 4:
            invokeStartElement (pctxt, "maximumHeaderInterval", -1);

            pvalue->u.maximumHeaderInterval = ALLOC_ASN1ELEM (pctxt, H245MultilinkRequest_maximumHeaderInterval);

            stat = asn1PD_H245MultilinkRequest_maximumHeaderInterval (pctxt, pvalue->u.maximumHeaderInterval);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "maximumHeaderInterval", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 6;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaximumBitRate                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MaximumBitRate (OOCTXT* pctxt, H245MaximumBitRate* pvalue)
{
   int stat = ASN_OK;

   stat = decodeConsUnsigned (pctxt, pvalue, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, *pvalue);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LogicalChannelRateRequest                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245LogicalChannelRateRequest (OOCTXT* pctxt, H245LogicalChannelRateRequest* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode logicalChannelNumber */

   invokeStartElement (pctxt, "logicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "logicalChannelNumber", -1);

   /* decode maximumBitRate */

   invokeStartElement (pctxt, "maximumBitRate", -1);

   stat = asn1PD_H245MaximumBitRate (pctxt, &pvalue->maximumBitRate);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "maximumBitRate", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMessage                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMessage (OOCTXT* pctxt, H245RequestMessage* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 10);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardMessage);

            stat = asn1PD_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* masterSlaveDetermination */
         case 1:
            invokeStartElement (pctxt, "masterSlaveDetermination", -1);

            pvalue->u.masterSlaveDetermination = ALLOC_ASN1ELEM (pctxt, H245MasterSlaveDetermination);

            stat = asn1PD_H245MasterSlaveDetermination (pctxt, pvalue->u.masterSlaveDetermination);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "masterSlaveDetermination", -1);

            break;

         /* terminalCapabilitySet */
         case 2:
            invokeStartElement (pctxt, "terminalCapabilitySet", -1);

            pvalue->u.terminalCapabilitySet = ALLOC_ASN1ELEM (pctxt, H245TerminalCapabilitySet);

            stat = asn1PD_H245TerminalCapabilitySet (pctxt, pvalue->u.terminalCapabilitySet);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "terminalCapabilitySet", -1);

            break;

         /* openLogicalChannel */
         case 3:
            invokeStartElement (pctxt, "openLogicalChannel", -1);

            pvalue->u.openLogicalChannel = ALLOC_ASN1ELEM (pctxt, H245OpenLogicalChannel);

            stat = asn1PD_H245OpenLogicalChannel (pctxt, pvalue->u.openLogicalChannel);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "openLogicalChannel", -1);

            break;

         /* closeLogicalChannel */
         case 4:
            invokeStartElement (pctxt, "closeLogicalChannel", -1);

            pvalue->u.closeLogicalChannel = ALLOC_ASN1ELEM (pctxt, H245CloseLogicalChannel);

            stat = asn1PD_H245CloseLogicalChannel (pctxt, pvalue->u.closeLogicalChannel);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "closeLogicalChannel", -1);

            break;

         /* requestChannelClose */
         case 5:
            invokeStartElement (pctxt, "requestChannelClose", -1);

            pvalue->u.requestChannelClose = ALLOC_ASN1ELEM (pctxt, H245RequestChannelClose);

            stat = asn1PD_H245RequestChannelClose (pctxt, pvalue->u.requestChannelClose);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestChannelClose", -1);

            break;

         /* multiplexEntrySend */
         case 6:
            invokeStartElement (pctxt, "multiplexEntrySend", -1);

            pvalue->u.multiplexEntrySend = ALLOC_ASN1ELEM (pctxt, H245MultiplexEntrySend);

            stat = asn1PD_H245MultiplexEntrySend (pctxt, pvalue->u.multiplexEntrySend);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multiplexEntrySend", -1);

            break;

         /* requestMultiplexEntry */
         case 7:
            invokeStartElement (pctxt, "requestMultiplexEntry", -1);

            pvalue->u.requestMultiplexEntry = ALLOC_ASN1ELEM (pctxt, H245RequestMultiplexEntry);

            stat = asn1PD_H245RequestMultiplexEntry (pctxt, pvalue->u.requestMultiplexEntry);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestMultiplexEntry", -1);

            break;

         /* requestMode */
         case 8:
            invokeStartElement (pctxt, "requestMode", -1);

            pvalue->u.requestMode = ALLOC_ASN1ELEM (pctxt, H245RequestMode);

            stat = asn1PD_H245RequestMode (pctxt, pvalue->u.requestMode);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestMode", -1);

            break;

         /* roundTripDelayRequest */
         case 9:
            invokeStartElement (pctxt, "roundTripDelayRequest", -1);

            pvalue->u.roundTripDelayRequest = ALLOC_ASN1ELEM (pctxt, H245RoundTripDelayRequest);

            stat = asn1PD_H245RoundTripDelayRequest (pctxt, pvalue->u.roundTripDelayRequest);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "roundTripDelayRequest", -1);

            break;

         /* maintenanceLoopRequest */
         case 10:
            invokeStartElement (pctxt, "maintenanceLoopRequest", -1);

            pvalue->u.maintenanceLoopRequest = ALLOC_ASN1ELEM (pctxt, H245MaintenanceLoopRequest);

            stat = asn1PD_H245MaintenanceLoopRequest (pctxt, pvalue->u.maintenanceLoopRequest);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "maintenanceLoopRequest", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 12;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* communicationModeRequest */
         case 12:
            invokeStartElement (pctxt, "communicationModeRequest", -1);

            pvalue->u.communicationModeRequest = ALLOC_ASN1ELEM (pctxt, H245CommunicationModeRequest);

            stat = asn1PD_H245CommunicationModeRequest (pctxt, pvalue->u.communicationModeRequest);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "communicationModeRequest", -1);

            break;

         /* conferenceRequest */
         case 13:
            invokeStartElement (pctxt, "conferenceRequest", -1);

            pvalue->u.conferenceRequest = ALLOC_ASN1ELEM (pctxt, H245ConferenceRequest);

            stat = asn1PD_H245ConferenceRequest (pctxt, pvalue->u.conferenceRequest);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "conferenceRequest", -1);

            break;

         /* multilinkRequest */
         case 14:
            invokeStartElement (pctxt, "multilinkRequest", -1);

            pvalue->u.multilinkRequest = ALLOC_ASN1ELEM (pctxt, H245MultilinkRequest);

            stat = asn1PD_H245MultilinkRequest (pctxt, pvalue->u.multilinkRequest);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multilinkRequest", -1);

            break;

         /* logicalChannelRateRequest */
         case 15:
            invokeStartElement (pctxt, "logicalChannelRateRequest", -1);

            pvalue->u.logicalChannelRateRequest = ALLOC_ASN1ELEM (pctxt, H245LogicalChannelRateRequest);

            stat = asn1PD_H245LogicalChannelRateRequest (pctxt, pvalue->u.logicalChannelRateRequest);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "logicalChannelRateRequest", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MasterSlaveDeterminationAck_decision                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MasterSlaveDeterminationAck_decision (OOCTXT* pctxt, H245MasterSlaveDeterminationAck_decision* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* master */
      case 0:
         invokeStartElement (pctxt, "master", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "master", -1);

         break;

      /* slave */
      case 1:
         invokeStartElement (pctxt, "slave", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "slave", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MasterSlaveDeterminationAck                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MasterSlaveDeterminationAck (OOCTXT* pctxt, H245MasterSlaveDeterminationAck* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode decision */

   invokeStartElement (pctxt, "decision", -1);

   stat = asn1PD_H245MasterSlaveDeterminationAck_decision (pctxt, &pvalue->decision);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "decision", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MasterSlaveDeterminationReject_cause                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MasterSlaveDeterminationReject_cause (OOCTXT* pctxt, H245MasterSlaveDeterminationReject_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* identicalNumbers */
         case 0:
            invokeStartElement (pctxt, "identicalNumbers", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "identicalNumbers", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 2;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MasterSlaveDeterminationReject                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MasterSlaveDeterminationReject (OOCTXT* pctxt, H245MasterSlaveDeterminationReject* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode cause */

   invokeStartElement (pctxt, "cause", -1);

   stat = asn1PD_H245MasterSlaveDeterminationReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "cause", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySetAck                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TerminalCapabilitySetAck (OOCTXT* pctxt, H245TerminalCapabilitySetAck* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySetReject_cause_tableEntryCapacityExce  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded (OOCTXT* pctxt, H245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* highestEntryNumberProcessed */
      case 0:
         invokeStartElement (pctxt, "highestEntryNumberProcessed", -1);

         stat = asn1PD_H245CapabilityTableEntryNumber (pctxt, &pvalue->u.highestEntryNumberProcessed);
         if (stat != ASN_OK) return stat;

         invokeEndElement (pctxt, "highestEntryNumberProcessed", -1);

         break;

      /* noneProcessed */
      case 1:
         invokeStartElement (pctxt, "noneProcessed", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "noneProcessed", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySetReject_cause                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TerminalCapabilitySetReject_cause (OOCTXT* pctxt, H245TerminalCapabilitySetReject_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 3);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* unspecified */
         case 0:
            invokeStartElement (pctxt, "unspecified", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unspecified", -1);

            break;

         /* undefinedTableEntryUsed */
         case 1:
            invokeStartElement (pctxt, "undefinedTableEntryUsed", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "undefinedTableEntryUsed", -1);

            break;

         /* descriptorCapacityExceeded */
         case 2:
            invokeStartElement (pctxt, "descriptorCapacityExceeded", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "descriptorCapacityExceeded", -1);

            break;

         /* tableEntryCapacityExceeded */
         case 3:
            invokeStartElement (pctxt, "tableEntryCapacityExceeded", -1);

            pvalue->u.tableEntryCapacityExceeded = ALLOC_ASN1ELEM (pctxt, H245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded);

            stat = asn1PD_H245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded (pctxt, pvalue->u.tableEntryCapacityExceeded);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "tableEntryCapacityExceeded", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 5;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySetReject                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TerminalCapabilitySetReject (OOCTXT* pctxt, H245TerminalCapabilitySetReject* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode cause */

   invokeStartElement (pctxt, "cause", -1);

   stat = asn1PD_H245TerminalCapabilitySetReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "cause", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelAck_reverseLogicalChannelParameters_mu  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters (OOCTXT* pctxt, H245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* h222LogicalChannelParameters */
         case 0:
            invokeStartElement (pctxt, "h222LogicalChannelParameters", -1);

            pvalue->u.h222LogicalChannelParameters = ALLOC_ASN1ELEM (pctxt, H245H222LogicalChannelParameters);

            stat = asn1PD_H245H222LogicalChannelParameters (pctxt, pvalue->u.h222LogicalChannelParameters);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h222LogicalChannelParameters", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 2;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* h2250LogicalChannelParameters */
         case 2:
            invokeStartElement (pctxt, "h2250LogicalChannelParameters", -1);

            pvalue->u.h2250LogicalChannelParameters = ALLOC_ASN1ELEM (pctxt, H245H2250LogicalChannelParameters);

            stat = asn1PD_H245H2250LogicalChannelParameters (pctxt, pvalue->u.h2250LogicalChannelParameters);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h2250LogicalChannelParameters", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelAck_reverseLogicalChannelParameters     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245OpenLogicalChannelAck_reverseLogicalChannelParameters (OOCTXT* pctxt, H245OpenLogicalChannelAck_reverseLogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.portNumberPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.multiplexParametersPresent = optbit;

   /* decode reverseLogicalChannelNumber */

   invokeStartElement (pctxt, "reverseLogicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->reverseLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "reverseLogicalChannelNumber", -1);

   /* decode portNumber */

   if (pvalue->m.portNumberPresent) {
      invokeStartElement (pctxt, "portNumber", -1);

      stat = decodeConsUInt16 (pctxt, &pvalue->portNumber, 0U, 65535U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->portNumber);

      invokeEndElement (pctxt, "portNumber", -1);
   }

   /* decode multiplexParameters */

   if (pvalue->m.multiplexParametersPresent) {
      invokeStartElement (pctxt, "multiplexParameters", -1);

      stat = asn1PD_H245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters (pctxt, &pvalue->multiplexParameters);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "multiplexParameters", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 1 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.replacementForPresent = 1;

                     invokeStartElement (pctxt, "replacementFor", -1);

                     stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->replacementFor);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "replacementFor", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250LogicalChannelAckParameters                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245H2250LogicalChannelAckParameters (OOCTXT* pctxt, H245H2250LogicalChannelAckParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonStandardPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.sessionIDPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaChannelPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaControlChannelPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.dynamicRTPPayloadTypePresent = optbit;

   /* decode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      invokeStartElement (pctxt, "nonStandard", -1);

      stat = asn1PD_H245_SeqOfH245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "nonStandard", -1);
   }

   /* decode sessionID */

   if (pvalue->m.sessionIDPresent) {
      invokeStartElement (pctxt, "sessionID", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->sessionID, 1U, 255U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->sessionID);

      invokeEndElement (pctxt, "sessionID", -1);
   }

   /* decode mediaChannel */

   if (pvalue->m.mediaChannelPresent) {
      invokeStartElement (pctxt, "mediaChannel", -1);

      stat = asn1PD_H245TransportAddress (pctxt, &pvalue->mediaChannel);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "mediaChannel", -1);
   }

   /* decode mediaControlChannel */

   if (pvalue->m.mediaControlChannelPresent) {
      invokeStartElement (pctxt, "mediaControlChannel", -1);

      stat = asn1PD_H245TransportAddress (pctxt, &pvalue->mediaControlChannel);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "mediaControlChannel", -1);
   }

   /* decode dynamicRTPPayloadType */

   if (pvalue->m.dynamicRTPPayloadTypePresent) {
      invokeStartElement (pctxt, "dynamicRTPPayloadType", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->dynamicRTPPayloadType, 96U, 127U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->dynamicRTPPayloadType);

      invokeEndElement (pctxt, "dynamicRTPPayloadType", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 2 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.flowControlToZeroPresent = 1;

                     invokeStartElement (pctxt, "flowControlToZero", -1);

                     stat = DECODEBIT (pctxt, &pvalue->flowControlToZero);
                     if (stat != ASN_OK) return stat;
                     invokeBoolValue (pctxt, pvalue->flowControlToZero);

                     invokeEndElement (pctxt, "flowControlToZero", -1);
                     break;

                  case 1:
                     pvalue->m.portNumberPresent = 1;

                     invokeStartElement (pctxt, "portNumber", -1);

                     stat = decodeConsUInt16 (pctxt, &pvalue->portNumber, 0U, 65535U);
                     if (stat != ASN_OK) return stat;
                     invokeUIntValue (pctxt, pvalue->portNumber);

                     invokeEndElement (pctxt, "portNumber", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelAck_forwardMultiplexAckParameters       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245OpenLogicalChannelAck_forwardMultiplexAckParameters (OOCTXT* pctxt, H245OpenLogicalChannelAck_forwardMultiplexAckParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* h2250LogicalChannelAckParameters */
         case 0:
            invokeStartElement (pctxt, "h2250LogicalChannelAckParameters", -1);

            pvalue->u.h2250LogicalChannelAckParameters = ALLOC_ASN1ELEM (pctxt, H245H2250LogicalChannelAckParameters);

            stat = asn1PD_H245H2250LogicalChannelAckParameters (pctxt, pvalue->u.h2250LogicalChannelAckParameters);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "h2250LogicalChannelAckParameters", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 2;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelAck                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245OpenLogicalChannelAck (OOCTXT* pctxt, H245OpenLogicalChannelAck* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.reverseLogicalChannelParametersPresent = optbit;

   /* decode forwardLogicalChannelNumber */

   invokeStartElement (pctxt, "forwardLogicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "forwardLogicalChannelNumber", -1);

   /* decode reverseLogicalChannelParameters */

   if (pvalue->m.reverseLogicalChannelParametersPresent) {
      invokeStartElement (pctxt, "reverseLogicalChannelParameters", -1);

      stat = asn1PD_H245OpenLogicalChannelAck_reverseLogicalChannelParameters (pctxt, &pvalue->reverseLogicalChannelParameters);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "reverseLogicalChannelParameters", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 3 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.separateStackPresent = 1;

                     invokeStartElement (pctxt, "separateStack", -1);

                     stat = asn1PD_H245NetworkAccessParameters (pctxt, &pvalue->separateStack);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "separateStack", -1);
                     break;

                  case 1:
                     pvalue->m.forwardMultiplexAckParametersPresent = 1;

                     invokeStartElement (pctxt, "forwardMultiplexAckParameters", -1);

                     stat = asn1PD_H245OpenLogicalChannelAck_forwardMultiplexAckParameters (pctxt, &pvalue->forwardMultiplexAckParameters);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "forwardMultiplexAckParameters", -1);
                     break;

                  case 2:
                     pvalue->m.encryptionSyncPresent = 1;

                     invokeStartElement (pctxt, "encryptionSync", -1);

                     stat = asn1PD_H245EncryptionSync (pctxt, &pvalue->encryptionSync);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "encryptionSync", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelReject_cause                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245OpenLogicalChannelReject_cause (OOCTXT* pctxt, H245OpenLogicalChannelReject_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 5);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* unspecified */
         case 0:
            invokeStartElement (pctxt, "unspecified", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unspecified", -1);

            break;

         /* unsuitableReverseParameters */
         case 1:
            invokeStartElement (pctxt, "unsuitableReverseParameters", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unsuitableReverseParameters", -1);

            break;

         /* dataTypeNotSupported */
         case 2:
            invokeStartElement (pctxt, "dataTypeNotSupported", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "dataTypeNotSupported", -1);

            break;

         /* dataTypeNotAvailable */
         case 3:
            invokeStartElement (pctxt, "dataTypeNotAvailable", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "dataTypeNotAvailable", -1);

            break;

         /* unknownDataType */
         case 4:
            invokeStartElement (pctxt, "unknownDataType", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unknownDataType", -1);

            break;

         /* dataTypeALCombinationNotSupported */
         case 5:
            invokeStartElement (pctxt, "dataTypeALCombinationNotSupported", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "dataTypeALCombinationNotSupported", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 7;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* multicastChannelNotAllowed */
         case 7:
            invokeStartElement (pctxt, "multicastChannelNotAllowed", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "multicastChannelNotAllowed", -1);

            break;

         /* insufficientBandwidth */
         case 8:
            invokeStartElement (pctxt, "insufficientBandwidth", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "insufficientBandwidth", -1);

            break;

         /* separateStackEstablishmentFailed */
         case 9:
            invokeStartElement (pctxt, "separateStackEstablishmentFailed", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "separateStackEstablishmentFailed", -1);

            break;

         /* invalidSessionID */
         case 10:
            invokeStartElement (pctxt, "invalidSessionID", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "invalidSessionID", -1);

            break;

         /* masterSlaveConflict */
         case 11:
            invokeStartElement (pctxt, "masterSlaveConflict", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "masterSlaveConflict", -1);

            break;

         /* waitForCommunicationMode */
         case 12:
            invokeStartElement (pctxt, "waitForCommunicationMode", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "waitForCommunicationMode", -1);

            break;

         /* invalidDependentChannel */
         case 13:
            invokeStartElement (pctxt, "invalidDependentChannel", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "invalidDependentChannel", -1);

            break;

         /* replacementForRejected */
         case 14:
            invokeStartElement (pctxt, "replacementForRejected", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "replacementForRejected", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelReject                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245OpenLogicalChannelReject (OOCTXT* pctxt, H245OpenLogicalChannelReject* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode forwardLogicalChannelNumber */

   invokeStartElement (pctxt, "forwardLogicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "forwardLogicalChannelNumber", -1);

   /* decode cause */

   invokeStartElement (pctxt, "cause", -1);

   stat = asn1PD_H245OpenLogicalChannelReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "cause", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CloseLogicalChannelAck                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CloseLogicalChannelAck (OOCTXT* pctxt, H245CloseLogicalChannelAck* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode forwardLogicalChannelNumber */

   invokeStartElement (pctxt, "forwardLogicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "forwardLogicalChannelNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestChannelCloseAck                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestChannelCloseAck (OOCTXT* pctxt, H245RequestChannelCloseAck* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode forwardLogicalChannelNumber */

   invokeStartElement (pctxt, "forwardLogicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "forwardLogicalChannelNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestChannelCloseReject_cause                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestChannelCloseReject_cause (OOCTXT* pctxt, H245RequestChannelCloseReject_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* unspecified */
         case 0:
            invokeStartElement (pctxt, "unspecified", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unspecified", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 2;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestChannelCloseReject                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestChannelCloseReject (OOCTXT* pctxt, H245RequestChannelCloseReject* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode forwardLogicalChannelNumber */

   invokeStartElement (pctxt, "forwardLogicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "forwardLogicalChannelNumber", -1);

   /* decode cause */

   invokeStartElement (pctxt, "cause", -1);

   stat = asn1PD_H245RequestChannelCloseReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "cause", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySendAck_multiplexTableEntryNumber           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexEntrySendAck_multiplexTableEntryNumber (OOCTXT* pctxt, H245MultiplexEntrySendAck_multiplexTableEntryNumber* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = asn1PD_H245MultiplexTableEntryNumber (pctxt, &pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySendAck                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexEntrySendAck (OOCTXT* pctxt, H245MultiplexEntrySendAck* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode multiplexTableEntryNumber */

   invokeStartElement (pctxt, "multiplexTableEntryNumber", -1);

   stat = asn1PD_H245MultiplexEntrySendAck_multiplexTableEntryNumber (pctxt, &pvalue->multiplexTableEntryNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "multiplexTableEntryNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntryRejectionDescriptions_cause                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexEntryRejectionDescriptions_cause (OOCTXT* pctxt, H245MultiplexEntryRejectionDescriptions_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* unspecifiedCause */
         case 0:
            invokeStartElement (pctxt, "unspecifiedCause", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unspecifiedCause", -1);

            break;

         /* descriptorTooComplex */
         case 1:
            invokeStartElement (pctxt, "descriptorTooComplex", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "descriptorTooComplex", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntryRejectionDescriptions                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexEntryRejectionDescriptions (OOCTXT* pctxt, H245MultiplexEntryRejectionDescriptions* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode multiplexTableEntryNumber */

   invokeStartElement (pctxt, "multiplexTableEntryNumber", -1);

   stat = asn1PD_H245MultiplexTableEntryNumber (pctxt, &pvalue->multiplexTableEntryNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "multiplexTableEntryNumber", -1);

   /* decode cause */

   invokeStartElement (pctxt, "cause", -1);

   stat = asn1PD_H245MultiplexEntryRejectionDescriptions_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "cause", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySendReject_rejectionDescriptions            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexEntrySendReject_rejectionDescriptions (OOCTXT* pctxt, H245MultiplexEntrySendReject_rejectionDescriptions* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   H245MultiplexEntryRejectionDescriptions* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245MultiplexEntryRejectionDescriptions);

      stat = asn1PD_H245MultiplexEntryRejectionDescriptions (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySendReject                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultiplexEntrySendReject (OOCTXT* pctxt, H245MultiplexEntrySendReject* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode rejectionDescriptions */

   invokeStartElement (pctxt, "rejectionDescriptions", -1);

   stat = asn1PD_H245MultiplexEntrySendReject_rejectionDescriptions (pctxt, &pvalue->rejectionDescriptions);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "rejectionDescriptions", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryAck_entryNumbers                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMultiplexEntryAck_entryNumbers (OOCTXT* pctxt, H245RequestMultiplexEntryAck_entryNumbers* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = asn1PD_H245MultiplexTableEntryNumber (pctxt, &pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryAck                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMultiplexEntryAck (OOCTXT* pctxt, H245RequestMultiplexEntryAck* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode entryNumbers */

   invokeStartElement (pctxt, "entryNumbers", -1);

   stat = asn1PD_H245RequestMultiplexEntryAck_entryNumbers (pctxt, &pvalue->entryNumbers);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "entryNumbers", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryReject_entryNumbers                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMultiplexEntryReject_entryNumbers (OOCTXT* pctxt, H245RequestMultiplexEntryReject_entryNumbers* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = asn1PD_H245MultiplexTableEntryNumber (pctxt, &pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryRejectionDescriptions_cause          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMultiplexEntryRejectionDescriptions_cause (OOCTXT* pctxt, H245RequestMultiplexEntryRejectionDescriptions_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* unspecifiedCause */
         case 0:
            invokeStartElement (pctxt, "unspecifiedCause", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unspecifiedCause", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 2;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryRejectionDescriptions                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMultiplexEntryRejectionDescriptions (OOCTXT* pctxt, H245RequestMultiplexEntryRejectionDescriptions* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode multiplexTableEntryNumber */

   invokeStartElement (pctxt, "multiplexTableEntryNumber", -1);

   stat = asn1PD_H245MultiplexTableEntryNumber (pctxt, &pvalue->multiplexTableEntryNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "multiplexTableEntryNumber", -1);

   /* decode cause */

   invokeStartElement (pctxt, "cause", -1);

   stat = asn1PD_H245RequestMultiplexEntryRejectionDescriptions_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "cause", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryReject_rejectionDescriptions         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMultiplexEntryReject_rejectionDescriptions (OOCTXT* pctxt, H245RequestMultiplexEntryReject_rejectionDescriptions* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   H245RequestMultiplexEntryRejectionDescriptions* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245RequestMultiplexEntryRejectionDescriptions);

      stat = asn1PD_H245RequestMultiplexEntryRejectionDescriptions (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryReject                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestMultiplexEntryReject (OOCTXT* pctxt, H245RequestMultiplexEntryReject* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode entryNumbers */

   invokeStartElement (pctxt, "entryNumbers", -1);

   stat = asn1PD_H245RequestMultiplexEntryReject_entryNumbers (pctxt, &pvalue->entryNumbers);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "entryNumbers", -1);

   /* decode rejectionDescriptions */

   invokeStartElement (pctxt, "rejectionDescriptions", -1);

   stat = asn1PD_H245RequestMultiplexEntryReject_rejectionDescriptions (pctxt, &pvalue->rejectionDescriptions);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "rejectionDescriptions", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestModeAck_response                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestModeAck_response (OOCTXT* pctxt, H245RequestModeAck_response* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* willTransmitMostPreferredMode */
         case 0:
            invokeStartElement (pctxt, "willTransmitMostPreferredMode", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "willTransmitMostPreferredMode", -1);

            break;

         /* willTransmitLessPreferredMode */
         case 1:
            invokeStartElement (pctxt, "willTransmitLessPreferredMode", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "willTransmitLessPreferredMode", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestModeAck                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestModeAck (OOCTXT* pctxt, H245RequestModeAck* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode response */

   invokeStartElement (pctxt, "response", -1);

   stat = asn1PD_H245RequestModeAck_response (pctxt, &pvalue->response);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "response", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestModeReject_cause                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestModeReject_cause (OOCTXT* pctxt, H245RequestModeReject_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* modeUnavailable */
         case 0:
            invokeStartElement (pctxt, "modeUnavailable", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "modeUnavailable", -1);

            break;

         /* multipointConstraint */
         case 1:
            invokeStartElement (pctxt, "multipointConstraint", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "multipointConstraint", -1);

            break;

         /* requestDenied */
         case 2:
            invokeStartElement (pctxt, "requestDenied", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "requestDenied", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestModeReject                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestModeReject (OOCTXT* pctxt, H245RequestModeReject* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode cause */

   invokeStartElement (pctxt, "cause", -1);

   stat = asn1PD_H245RequestModeReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "cause", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RoundTripDelayResponse                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RoundTripDelayResponse (OOCTXT* pctxt, H245RoundTripDelayResponse* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopAck_type                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MaintenanceLoopAck_type (OOCTXT* pctxt, H245MaintenanceLoopAck_type* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* systemLoop */
         case 0:
            invokeStartElement (pctxt, "systemLoop", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "systemLoop", -1);

            break;

         /* mediaLoop */
         case 1:
            invokeStartElement (pctxt, "mediaLoop", -1);

            stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->u.mediaLoop);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "mediaLoop", -1);

            break;

         /* logicalChannelLoop */
         case 2:
            invokeStartElement (pctxt, "logicalChannelLoop", -1);

            stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->u.logicalChannelLoop);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "logicalChannelLoop", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopAck                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MaintenanceLoopAck (OOCTXT* pctxt, H245MaintenanceLoopAck* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode type */

   invokeStartElement (pctxt, "type", -1);

   stat = asn1PD_H245MaintenanceLoopAck_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "type", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopReject_type                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MaintenanceLoopReject_type (OOCTXT* pctxt, H245MaintenanceLoopReject_type* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* systemLoop */
         case 0:
            invokeStartElement (pctxt, "systemLoop", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "systemLoop", -1);

            break;

         /* mediaLoop */
         case 1:
            invokeStartElement (pctxt, "mediaLoop", -1);

            stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->u.mediaLoop);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "mediaLoop", -1);

            break;

         /* logicalChannelLoop */
         case 2:
            invokeStartElement (pctxt, "logicalChannelLoop", -1);

            stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->u.logicalChannelLoop);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "logicalChannelLoop", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopReject_cause                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MaintenanceLoopReject_cause (OOCTXT* pctxt, H245MaintenanceLoopReject_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* canNotPerformLoop */
         case 0:
            invokeStartElement (pctxt, "canNotPerformLoop", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "canNotPerformLoop", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 2;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopReject                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MaintenanceLoopReject (OOCTXT* pctxt, H245MaintenanceLoopReject* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode type */

   invokeStartElement (pctxt, "type", -1);

   stat = asn1PD_H245MaintenanceLoopReject_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "type", -1);

   /* decode cause */

   invokeStartElement (pctxt, "cause", -1);

   stat = asn1PD_H245MaintenanceLoopReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "cause", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeTableEntry_dataType                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CommunicationModeTableEntry_dataType (OOCTXT* pctxt, H245CommunicationModeTableEntry_dataType* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* videoData */
         case 0:
            invokeStartElement (pctxt, "videoData", -1);

            pvalue->u.videoData = ALLOC_ASN1ELEM (pctxt, H245VideoCapability);

            stat = asn1PD_H245VideoCapability (pctxt, pvalue->u.videoData);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "videoData", -1);

            break;

         /* audioData */
         case 1:
            invokeStartElement (pctxt, "audioData", -1);

            pvalue->u.audioData = ALLOC_ASN1ELEM (pctxt, H245AudioCapability);

            stat = asn1PD_H245AudioCapability (pctxt, pvalue->u.audioData);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "audioData", -1);

            break;

         /* data */
         case 2:
            invokeStartElement (pctxt, "data", -1);

            pvalue->u.data = ALLOC_ASN1ELEM (pctxt, H245DataApplicationCapability);

            stat = asn1PD_H245DataApplicationCapability (pctxt, pvalue->u.data);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "data", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeTableEntry                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CommunicationModeTableEntry (OOCTXT* pctxt, H245CommunicationModeTableEntry* pvalue)
{
   static Asn1SizeCnst sessionDescription_lsize1 = { 0, 1, 128, 0 };
   int stat = ASN_OK;
   OOCTXT lctxt;
   OOCTXT lctxt2;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.nonStandardPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.associatedSessionIDPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.terminalLabelPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaChannelPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaGuaranteedDeliveryPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaControlChannelPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.mediaControlGuaranteedDeliveryPresent = optbit;

   /* decode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      invokeStartElement (pctxt, "nonStandard", -1);

      stat = asn1PD_H245_SeqOfH245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "nonStandard", -1);
   }

   /* decode sessionID */

   invokeStartElement (pctxt, "sessionID", -1);

   stat = decodeConsUInt8 (pctxt, &pvalue->sessionID, 1U, 255U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->sessionID);

   invokeEndElement (pctxt, "sessionID", -1);

   /* decode associatedSessionID */

   if (pvalue->m.associatedSessionIDPresent) {
      invokeStartElement (pctxt, "associatedSessionID", -1);

      stat = decodeConsUInt8 (pctxt, &pvalue->associatedSessionID, 1U, 255U);
      if (stat != ASN_OK) return stat;
      invokeUIntValue (pctxt, pvalue->associatedSessionID);

      invokeEndElement (pctxt, "associatedSessionID", -1);
   }

   /* decode terminalLabel */

   if (pvalue->m.terminalLabelPresent) {
      invokeStartElement (pctxt, "terminalLabel", -1);

      stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "terminalLabel", -1);
   }

   /* decode sessionDescription */

   invokeStartElement (pctxt, "sessionDescription", -1);

   addSizeConstraint (pctxt, &sessionDescription_lsize1);

   stat = decodeBMPString (pctxt, &pvalue->sessionDescription, 0);
   if (stat != ASN_OK) return stat;
   invokeCharStr16BitValue (pctxt, pvalue->sessionDescription.nchars, pvalue->sessionDescription.data);

   invokeEndElement (pctxt, "sessionDescription", -1);

   /* decode dataType */

   invokeStartElement (pctxt, "dataType", -1);

   stat = asn1PD_H245CommunicationModeTableEntry_dataType (pctxt, &pvalue->dataType);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "dataType", -1);

   /* decode mediaChannel */

   if (pvalue->m.mediaChannelPresent) {
      invokeStartElement (pctxt, "mediaChannel", -1);

      stat = asn1PD_H245TransportAddress (pctxt, &pvalue->mediaChannel);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "mediaChannel", -1);
   }

   /* decode mediaGuaranteedDelivery */

   if (pvalue->m.mediaGuaranteedDeliveryPresent) {
      invokeStartElement (pctxt, "mediaGuaranteedDelivery", -1);

      stat = DECODEBIT (pctxt, &pvalue->mediaGuaranteedDelivery);
      if (stat != ASN_OK) return stat;
      invokeBoolValue (pctxt, pvalue->mediaGuaranteedDelivery);

      invokeEndElement (pctxt, "mediaGuaranteedDelivery", -1);
   }

   /* decode mediaControlChannel */

   if (pvalue->m.mediaControlChannelPresent) {
      invokeStartElement (pctxt, "mediaControlChannel", -1);

      stat = asn1PD_H245TransportAddress (pctxt, &pvalue->mediaControlChannel);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "mediaControlChannel", -1);
   }

   /* decode mediaControlGuaranteedDelivery */

   if (pvalue->m.mediaControlGuaranteedDeliveryPresent) {
      invokeStartElement (pctxt, "mediaControlGuaranteedDelivery", -1);

      stat = DECODEBIT (pctxt, &pvalue->mediaControlGuaranteedDelivery);
      if (stat != ASN_OK) return stat;
      invokeBoolValue (pctxt, pvalue->mediaControlGuaranteedDelivery);

      invokeEndElement (pctxt, "mediaControlGuaranteedDelivery", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            if (i < 3 && openType.numocts > 0) {  /* known element */
               copyContext (&lctxt2, pctxt);
               initContextBuffer (pctxt, openType.data, openType.numocts);

               switch (i) {
                  case 0:
                     pvalue->m.redundancyEncodingPresent = 1;

                     invokeStartElement (pctxt, "redundancyEncoding", -1);

                     stat = asn1PD_H245RedundancyEncoding (pctxt, &pvalue->redundancyEncoding);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "redundancyEncoding", -1);
                     break;

                  case 1:
                     pvalue->m.sessionDependencyPresent = 1;

                     invokeStartElement (pctxt, "sessionDependency", -1);

                     stat = decodeConsUInt8 (pctxt, &pvalue->sessionDependency, 1U, 255U);
                     if (stat != ASN_OK) return stat;
                     invokeUIntValue (pctxt, pvalue->sessionDependency);

                     invokeEndElement (pctxt, "sessionDependency", -1);
                     break;

                  case 2:
                     pvalue->m.destinationPresent = 1;

                     invokeStartElement (pctxt, "destination", -1);

                     stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->destination);
                     if (stat != ASN_OK) return stat;

                     invokeEndElement (pctxt, "destination", -1);
                     break;

                  default:
                     pctxt->buffer.byteIndex += openType.numocts;
               }
               copyContext (pctxt, &lctxt2);
            }
            else {  /* unknown element */
               pctxt->buffer.byteIndex += openType.numocts;
            }
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeResponse_communicationModeTable          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CommunicationModeResponse_communicationModeTable (OOCTXT* pctxt, H245CommunicationModeResponse_communicationModeTable* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245CommunicationModeTableEntry* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245CommunicationModeTableEntry);

      stat = asn1PD_H245CommunicationModeTableEntry (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeResponse                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245CommunicationModeResponse (OOCTXT* pctxt, H245CommunicationModeResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 0);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* communicationModeTable */
         case 0:
            invokeStartElement (pctxt, "communicationModeTable", -1);

            pvalue->u.communicationModeTable = ALLOC_ASN1ELEM (pctxt, H245CommunicationModeResponse_communicationModeTable);

            stat = asn1PD_H245CommunicationModeResponse_communicationModeTable (pctxt, pvalue->u.communicationModeTable);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "communicationModeTable", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 2;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalID                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TerminalID (OOCTXT* pctxt, H245TerminalID* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 128, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_mCTerminalIDResponse                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_mCTerminalIDResponse (OOCTXT* pctxt, H245ConferenceResponse_mCTerminalIDResponse* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode terminalLabel */

   invokeStartElement (pctxt, "terminalLabel", -1);

   stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalLabel", -1);

   /* decode terminalID */

   invokeStartElement (pctxt, "terminalID", -1);

   stat = asn1PD_H245TerminalID (pctxt, &pvalue->terminalID);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalID", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_terminalIDResponse                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_terminalIDResponse (OOCTXT* pctxt, H245ConferenceResponse_terminalIDResponse* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode terminalLabel */

   invokeStartElement (pctxt, "terminalLabel", -1);

   stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalLabel", -1);

   /* decode terminalID */

   invokeStartElement (pctxt, "terminalID", -1);

   stat = asn1PD_H245TerminalID (pctxt, &pvalue->terminalID);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalID", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceID                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceID (OOCTXT* pctxt, H245ConferenceID* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 32, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_conferenceIDResponse                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_conferenceIDResponse (OOCTXT* pctxt, H245ConferenceResponse_conferenceIDResponse* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode terminalLabel */

   invokeStartElement (pctxt, "terminalLabel", -1);

   stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalLabel", -1);

   /* decode conferenceID */

   invokeStartElement (pctxt, "conferenceID", -1);

   stat = asn1PD_H245ConferenceID (pctxt, &pvalue->conferenceID);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "conferenceID", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Password                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245Password (OOCTXT* pctxt, H245Password* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 32, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeOctetString (pctxt,
                          &pvalue->numocts,
                          pvalue->data,
                          sizeof(pvalue->data));
   if (stat != ASN_OK) return stat;
   invokeOctStrValue (pctxt, pvalue->numocts, pvalue->data);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_passwordResponse                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_passwordResponse (OOCTXT* pctxt, H245ConferenceResponse_passwordResponse* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode terminalLabel */

   invokeStartElement (pctxt, "terminalLabel", -1);

   stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalLabel", -1);

   /* decode password */

   invokeStartElement (pctxt, "password", -1);

   stat = asn1PD_H245Password (pctxt, &pvalue->password);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "password", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_terminalListResponse                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_terminalListResponse (OOCTXT* pctxt, H245ConferenceResponse_terminalListResponse* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   H245TerminalLabel* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &count);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   dListInit (pvalue);

   for (xx1 = 0; xx1 < count; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245TerminalLabel);

      stat = asn1PD_H245TerminalLabel (pctxt, pdata);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

      dListAppendNode (pctxt, pvalue, pdata);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_makeMeChairResponse                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_makeMeChairResponse (OOCTXT* pctxt, H245ConferenceResponse_makeMeChairResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* grantedChairToken */
         case 0:
            invokeStartElement (pctxt, "grantedChairToken", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "grantedChairToken", -1);

            break;

         /* deniedChairToken */
         case 1:
            invokeStartElement (pctxt, "deniedChairToken", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "deniedChairToken", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_extensionAddressResponse               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_extensionAddressResponse (OOCTXT* pctxt, H245ConferenceResponse_extensionAddressResponse* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode extensionAddress */

   invokeStartElement (pctxt, "extensionAddress", -1);

   stat = asn1PD_H245TerminalID (pctxt, &pvalue->extensionAddress);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "extensionAddress", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_chairTokenOwnerResponse                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_chairTokenOwnerResponse (OOCTXT* pctxt, H245ConferenceResponse_chairTokenOwnerResponse* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode terminalLabel */

   invokeStartElement (pctxt, "terminalLabel", -1);

   stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalLabel", -1);

   /* decode terminalID */

   invokeStartElement (pctxt, "terminalID", -1);

   stat = asn1PD_H245TerminalID (pctxt, &pvalue->terminalID);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalID", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_terminalCertificateResponse            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_terminalCertificateResponse (OOCTXT* pctxt, H245ConferenceResponse_terminalCertificateResponse* pvalue)
{
   static Asn1SizeCnst certificateResponse_lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.terminalLabelPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.certificateResponsePresent = optbit;

   /* decode terminalLabel */

   if (pvalue->m.terminalLabelPresent) {
      invokeStartElement (pctxt, "terminalLabel", -1);

      stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "terminalLabel", -1);
   }

   /* decode certificateResponse */

   if (pvalue->m.certificateResponsePresent) {
      invokeStartElement (pctxt, "certificateResponse", -1);

      addSizeConstraint (pctxt, &certificateResponse_lsize1);

      stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)&pvalue->certificateResponse);
      if (stat != ASN_OK) return stat;
      invokeOctStrValue (pctxt, pvalue->certificateResponse.numocts, pvalue->certificateResponse.data);

      invokeEndElement (pctxt, "certificateResponse", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_broadcastMyLogicalChannelResponse      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_broadcastMyLogicalChannelResponse (OOCTXT* pctxt, H245ConferenceResponse_broadcastMyLogicalChannelResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* grantedBroadcastMyLogicalChannel */
         case 0:
            invokeStartElement (pctxt, "grantedBroadcastMyLogicalChannel", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "grantedBroadcastMyLogicalChannel", -1);

            break;

         /* deniedBroadcastMyLogicalChannel */
         case 1:
            invokeStartElement (pctxt, "deniedBroadcastMyLogicalChannel", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "deniedBroadcastMyLogicalChannel", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_makeTerminalBroadcasterResponse        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_makeTerminalBroadcasterResponse (OOCTXT* pctxt, H245ConferenceResponse_makeTerminalBroadcasterResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* grantedMakeTerminalBroadcaster */
         case 0:
            invokeStartElement (pctxt, "grantedMakeTerminalBroadcaster", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "grantedMakeTerminalBroadcaster", -1);

            break;

         /* deniedMakeTerminalBroadcaster */
         case 1:
            invokeStartElement (pctxt, "deniedMakeTerminalBroadcaster", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "deniedMakeTerminalBroadcaster", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_sendThisSourceResponse                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse_sendThisSourceResponse (OOCTXT* pctxt, H245ConferenceResponse_sendThisSourceResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* grantedSendThisSource */
         case 0:
            invokeStartElement (pctxt, "grantedSendThisSource", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "grantedSendThisSource", -1);

            break;

         /* deniedSendThisSource */
         case 1:
            invokeStartElement (pctxt, "deniedSendThisSource", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "deniedSendThisSource", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalInformation                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245TerminalInformation (OOCTXT* pctxt, H245TerminalInformation* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode terminalLabel */

   invokeStartElement (pctxt, "terminalLabel", -1);

   stat = asn1PD_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalLabel", -1);

   /* decode terminalID */

   invokeStartElement (pctxt, "terminalID", -1);

   stat = asn1PD_H245TerminalID (pctxt, &pvalue->terminalID);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalID", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245TerminalInformation                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245_SeqOfH245TerminalInformation (OOCTXT* pctxt, H245_SeqOfH245TerminalInformation* pvalue)
{
   int stat = ASN_OK;
   H245TerminalInformation* pdata;
   ASN1UINT count = 0;
   ASN1UINT xx1;
   int lstat;

   dListInit (pvalue);

   for (;;) {
      /* decode length determinant */

      lstat = decodeLength (pctxt, &count);
      if (lstat != ASN_OK && lstat != ASN_OK_FRAG) {
         return lstat;
      }

      /* decode elements */

      for (xx1 = 0; xx1 < count; xx1++) {
         invokeStartElement (pctxt, "elem", xx1);

         pdata = ALLOC_ASN1ELEMDNODE (pctxt, H245TerminalInformation);

         stat = asn1PD_H245TerminalInformation (pctxt, pdata);
         if (stat != ASN_OK) return stat;
         invokeEndElement (pctxt, "elem", xx1);

         dListAppendNode (pctxt, pvalue, pdata);
      }

      if(lstat == ASN_OK) break;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestAllTerminalIDsResponse                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RequestAllTerminalIDsResponse (OOCTXT* pctxt, H245RequestAllTerminalIDsResponse* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode terminalInformation */

   invokeStartElement (pctxt, "terminalInformation", -1);

   stat = asn1PD_H245_SeqOfH245TerminalInformation (pctxt, &pvalue->terminalInformation);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "terminalInformation", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RemoteMCResponse_reject                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RemoteMCResponse_reject (OOCTXT* pctxt, H245RemoteMCResponse_reject* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* unspecified */
         case 0:
            invokeStartElement (pctxt, "unspecified", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "unspecified", -1);

            break;

         /* functionNotSupported */
         case 1:
            invokeStartElement (pctxt, "functionNotSupported", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "functionNotSupported", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RemoteMCResponse                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245RemoteMCResponse (OOCTXT* pctxt, H245RemoteMCResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* accept */
         case 0:
            invokeStartElement (pctxt, "accept", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "accept", -1);

            break;

         /* reject */
         case 1:
            invokeStartElement (pctxt, "reject", -1);

            pvalue->u.reject = ALLOC_ASN1ELEM (pctxt, H245RemoteMCResponse_reject);

            stat = asn1PD_H245RemoteMCResponse_reject (pctxt, pvalue->u.reject);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "reject", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ConferenceResponse (OOCTXT* pctxt, H245ConferenceResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 7);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* mCTerminalIDResponse */
         case 0:
            invokeStartElement (pctxt, "mCTerminalIDResponse", -1);

            pvalue->u.mCTerminalIDResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_mCTerminalIDResponse);

            stat = asn1PD_H245ConferenceResponse_mCTerminalIDResponse (pctxt, pvalue->u.mCTerminalIDResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "mCTerminalIDResponse", -1);

            break;

         /* terminalIDResponse */
         case 1:
            invokeStartElement (pctxt, "terminalIDResponse", -1);

            pvalue->u.terminalIDResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_terminalIDResponse);

            stat = asn1PD_H245ConferenceResponse_terminalIDResponse (pctxt, pvalue->u.terminalIDResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "terminalIDResponse", -1);

            break;

         /* conferenceIDResponse */
         case 2:
            invokeStartElement (pctxt, "conferenceIDResponse", -1);

            pvalue->u.conferenceIDResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_conferenceIDResponse);

            stat = asn1PD_H245ConferenceResponse_conferenceIDResponse (pctxt, pvalue->u.conferenceIDResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "conferenceIDResponse", -1);

            break;

         /* passwordResponse */
         case 3:
            invokeStartElement (pctxt, "passwordResponse", -1);

            pvalue->u.passwordResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_passwordResponse);

            stat = asn1PD_H245ConferenceResponse_passwordResponse (pctxt, pvalue->u.passwordResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "passwordResponse", -1);

            break;

         /* terminalListResponse */
         case 4:
            invokeStartElement (pctxt, "terminalListResponse", -1);

            pvalue->u.terminalListResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_terminalListResponse);

            stat = asn1PD_H245ConferenceResponse_terminalListResponse (pctxt, pvalue->u.terminalListResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "terminalListResponse", -1);

            break;

         /* videoCommandReject */
         case 5:
            invokeStartElement (pctxt, "videoCommandReject", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "videoCommandReject", -1);

            break;

         /* terminalDropReject */
         case 6:
            invokeStartElement (pctxt, "terminalDropReject", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "terminalDropReject", -1);

            break;

         /* makeMeChairResponse */
         case 7:
            invokeStartElement (pctxt, "makeMeChairResponse", -1);

            pvalue->u.makeMeChairResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_makeMeChairResponse);

            stat = asn1PD_H245ConferenceResponse_makeMeChairResponse (pctxt, pvalue->u.makeMeChairResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "makeMeChairResponse", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 9;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* extensionAddressResponse */
         case 9:
            invokeStartElement (pctxt, "extensionAddressResponse", -1);

            pvalue->u.extensionAddressResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_extensionAddressResponse);

            stat = asn1PD_H245ConferenceResponse_extensionAddressResponse (pctxt, pvalue->u.extensionAddressResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "extensionAddressResponse", -1);

            break;

         /* chairTokenOwnerResponse */
         case 10:
            invokeStartElement (pctxt, "chairTokenOwnerResponse", -1);

            pvalue->u.chairTokenOwnerResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_chairTokenOwnerResponse);

            stat = asn1PD_H245ConferenceResponse_chairTokenOwnerResponse (pctxt, pvalue->u.chairTokenOwnerResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "chairTokenOwnerResponse", -1);

            break;

         /* terminalCertificateResponse */
         case 11:
            invokeStartElement (pctxt, "terminalCertificateResponse", -1);

            pvalue->u.terminalCertificateResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_terminalCertificateResponse);

            stat = asn1PD_H245ConferenceResponse_terminalCertificateResponse (pctxt, pvalue->u.terminalCertificateResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "terminalCertificateResponse", -1);

            break;

         /* broadcastMyLogicalChannelResponse */
         case 12:
            invokeStartElement (pctxt, "broadcastMyLogicalChannelResponse", -1);

            pvalue->u.broadcastMyLogicalChannelResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_broadcastMyLogicalChannelResponse);

            stat = asn1PD_H245ConferenceResponse_broadcastMyLogicalChannelResponse (pctxt, pvalue->u.broadcastMyLogicalChannelResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "broadcastMyLogicalChannelResponse", -1);

            break;

         /* makeTerminalBroadcasterResponse */
         case 13:
            invokeStartElement (pctxt, "makeTerminalBroadcasterResponse", -1);

            pvalue->u.makeTerminalBroadcasterResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_makeTerminalBroadcasterResponse);

            stat = asn1PD_H245ConferenceResponse_makeTerminalBroadcasterResponse (pctxt, pvalue->u.makeTerminalBroadcasterResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "makeTerminalBroadcasterResponse", -1);

            break;

         /* sendThisSourceResponse */
         case 14:
            invokeStartElement (pctxt, "sendThisSourceResponse", -1);

            pvalue->u.sendThisSourceResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse_sendThisSourceResponse);

            stat = asn1PD_H245ConferenceResponse_sendThisSourceResponse (pctxt, pvalue->u.sendThisSourceResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "sendThisSourceResponse", -1);

            break;

         /* requestAllTerminalIDsResponse */
         case 15:
            invokeStartElement (pctxt, "requestAllTerminalIDsResponse", -1);

            pvalue->u.requestAllTerminalIDsResponse = ALLOC_ASN1ELEM (pctxt, H245RequestAllTerminalIDsResponse);

            stat = asn1PD_H245RequestAllTerminalIDsResponse (pctxt, pvalue->u.requestAllTerminalIDsResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestAllTerminalIDsResponse", -1);

            break;

         /* remoteMCResponse */
         case 16:
            invokeStartElement (pctxt, "remoteMCResponse", -1);

            pvalue->u.remoteMCResponse = ALLOC_ASN1ELEM (pctxt, H245RemoteMCResponse);

            stat = asn1PD_H245RemoteMCResponse (pctxt, pvalue->u.remoteMCResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "remoteMCResponse", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_callInformation                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkResponse_callInformation (OOCTXT* pctxt, H245MultilinkResponse_callInformation* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode dialingInformation */

   invokeStartElement (pctxt, "dialingInformation", -1);

   stat = asn1PD_H245DialingInformation (pctxt, &pvalue->dialingInformation);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "dialingInformation", -1);

   /* decode callAssociationNumber */

   invokeStartElement (pctxt, "callAssociationNumber", -1);

   stat = decodeConsUnsigned (pctxt, &pvalue->callAssociationNumber, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->callAssociationNumber);

   invokeEndElement (pctxt, "callAssociationNumber", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_addConnection_responseCode_rejected     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkResponse_addConnection_responseCode_rejected (OOCTXT* pctxt, H245MultilinkResponse_addConnection_responseCode_rejected* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* connectionsNotAvailable */
         case 0:
            invokeStartElement (pctxt, "connectionsNotAvailable", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "connectionsNotAvailable", -1);

            break;

         /* userRejected */
         case 1:
            invokeStartElement (pctxt, "userRejected", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "userRejected", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_addConnection_responseCode              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkResponse_addConnection_responseCode (OOCTXT* pctxt, H245MultilinkResponse_addConnection_responseCode* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* accepted */
         case 0:
            invokeStartElement (pctxt, "accepted", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "accepted", -1);

            break;

         /* rejected */
         case 1:
            invokeStartElement (pctxt, "rejected", -1);

            pvalue->u.rejected = ALLOC_ASN1ELEM (pctxt, H245MultilinkResponse_addConnection_responseCode_rejected);

            stat = asn1PD_H245MultilinkResponse_addConnection_responseCode_rejected (pctxt, pvalue->u.rejected);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "rejected", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_addConnection                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkResponse_addConnection (OOCTXT* pctxt, H245MultilinkResponse_addConnection* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode responseCode */

   invokeStartElement (pctxt, "responseCode", -1);

   stat = asn1PD_H245MultilinkResponse_addConnection_responseCode (pctxt, &pvalue->responseCode);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "responseCode", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_removeConnection                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkResponse_removeConnection (OOCTXT* pctxt, H245MultilinkResponse_removeConnection* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode connectionIdentifier */

   invokeStartElement (pctxt, "connectionIdentifier", -1);

   stat = asn1PD_H245ConnectionIdentifier (pctxt, &pvalue->connectionIdentifier);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "connectionIdentifier", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_maximumHeaderInterval                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkResponse_maximumHeaderInterval (OOCTXT* pctxt, H245MultilinkResponse_maximumHeaderInterval* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode currentInterval */

   invokeStartElement (pctxt, "currentInterval", -1);

   stat = decodeConsUInt16 (pctxt, &pvalue->currentInterval, 0U, 65535U);
   if (stat != ASN_OK) return stat;
   invokeUIntValue (pctxt, pvalue->currentInterval);

   invokeEndElement (pctxt, "currentInterval", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MultilinkResponse (OOCTXT* pctxt, H245MultilinkResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 4);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardMessage);

            stat = asn1PD_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* callInformation */
         case 1:
            invokeStartElement (pctxt, "callInformation", -1);

            pvalue->u.callInformation = ALLOC_ASN1ELEM (pctxt, H245MultilinkResponse_callInformation);

            stat = asn1PD_H245MultilinkResponse_callInformation (pctxt, pvalue->u.callInformation);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "callInformation", -1);

            break;

         /* addConnection */
         case 2:
            invokeStartElement (pctxt, "addConnection", -1);

            pvalue->u.addConnection = ALLOC_ASN1ELEM (pctxt, H245MultilinkResponse_addConnection);

            stat = asn1PD_H245MultilinkResponse_addConnection (pctxt, pvalue->u.addConnection);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "addConnection", -1);

            break;

         /* removeConnection */
         case 3:
            invokeStartElement (pctxt, "removeConnection", -1);

            pvalue->u.removeConnection = ALLOC_ASN1ELEM (pctxt, H245MultilinkResponse_removeConnection);

            stat = asn1PD_H245MultilinkResponse_removeConnection (pctxt, pvalue->u.removeConnection);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "removeConnection", -1);

            break;

         /* maximumHeaderInterval */
         case 4:
            invokeStartElement (pctxt, "maximumHeaderInterval", -1);

            pvalue->u.maximumHeaderInterval = ALLOC_ASN1ELEM (pctxt, H245MultilinkResponse_maximumHeaderInterval);

            stat = asn1PD_H245MultilinkResponse_maximumHeaderInterval (pctxt, pvalue->u.maximumHeaderInterval);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "maximumHeaderInterval", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 6;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LogicalChannelRateAcknowledge                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245LogicalChannelRateAcknowledge (OOCTXT* pctxt, H245LogicalChannelRateAcknowledge* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode logicalChannelNumber */

   invokeStartElement (pctxt, "logicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "logicalChannelNumber", -1);

   /* decode maximumBitRate */

   invokeStartElement (pctxt, "maximumBitRate", -1);

   stat = asn1PD_H245MaximumBitRate (pctxt, &pvalue->maximumBitRate);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "maximumBitRate", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LogicalChannelRateRejectReason                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245LogicalChannelRateRejectReason (OOCTXT* pctxt, H245LogicalChannelRateRejectReason* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* undefinedReason */
         case 0:
            invokeStartElement (pctxt, "undefinedReason", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "undefinedReason", -1);

            break;

         /* insufficientResources */
         case 1:
            invokeStartElement (pctxt, "insufficientResources", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "insufficientResources", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LogicalChannelRateReject                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245LogicalChannelRateReject (OOCTXT* pctxt, H245LogicalChannelRateReject* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.currentMaximumBitRatePresent = optbit;

   /* decode sequenceNumber */

   invokeStartElement (pctxt, "sequenceNumber", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "sequenceNumber", -1);

   /* decode logicalChannelNumber */

   invokeStartElement (pctxt, "logicalChannelNumber", -1);

   stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "logicalChannelNumber", -1);

   /* decode rejectReason */

   invokeStartElement (pctxt, "rejectReason", -1);

   stat = asn1PD_H245LogicalChannelRateRejectReason (pctxt, &pvalue->rejectReason);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "rejectReason", -1);

   /* decode currentMaximumBitRate */

   if (pvalue->m.currentMaximumBitRatePresent) {
      invokeStartElement (pctxt, "currentMaximumBitRate", -1);

      stat = asn1PD_H245MaximumBitRate (pctxt, &pvalue->currentMaximumBitRate);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "currentMaximumBitRate", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ResponseMessage                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245ResponseMessage (OOCTXT* pctxt, H245ResponseMessage* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 18);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardMessage);

            stat = asn1PD_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* masterSlaveDeterminationAck */
         case 1:
            invokeStartElement (pctxt, "masterSlaveDeterminationAck", -1);

            pvalue->u.masterSlaveDeterminationAck = ALLOC_ASN1ELEM (pctxt, H245MasterSlaveDeterminationAck);

            stat = asn1PD_H245MasterSlaveDeterminationAck (pctxt, pvalue->u.masterSlaveDeterminationAck);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "masterSlaveDeterminationAck", -1);

            break;

         /* masterSlaveDeterminationReject */
         case 2:
            invokeStartElement (pctxt, "masterSlaveDeterminationReject", -1);

            pvalue->u.masterSlaveDeterminationReject = ALLOC_ASN1ELEM (pctxt, H245MasterSlaveDeterminationReject);

            stat = asn1PD_H245MasterSlaveDeterminationReject (pctxt, pvalue->u.masterSlaveDeterminationReject);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "masterSlaveDeterminationReject", -1);

            break;

         /* terminalCapabilitySetAck */
         case 3:
            invokeStartElement (pctxt, "terminalCapabilitySetAck", -1);

            pvalue->u.terminalCapabilitySetAck = ALLOC_ASN1ELEM (pctxt, H245TerminalCapabilitySetAck);

            stat = asn1PD_H245TerminalCapabilitySetAck (pctxt, pvalue->u.terminalCapabilitySetAck);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "terminalCapabilitySetAck", -1);

            break;

         /* terminalCapabilitySetReject */
         case 4:
            invokeStartElement (pctxt, "terminalCapabilitySetReject", -1);

            pvalue->u.terminalCapabilitySetReject = ALLOC_ASN1ELEM (pctxt, H245TerminalCapabilitySetReject);

            stat = asn1PD_H245TerminalCapabilitySetReject (pctxt, pvalue->u.terminalCapabilitySetReject);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "terminalCapabilitySetReject", -1);

            break;

         /* openLogicalChannelAck */
         case 5:
            invokeStartElement (pctxt, "openLogicalChannelAck", -1);

            pvalue->u.openLogicalChannelAck = ALLOC_ASN1ELEM (pctxt, H245OpenLogicalChannelAck);

            stat = asn1PD_H245OpenLogicalChannelAck (pctxt, pvalue->u.openLogicalChannelAck);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "openLogicalChannelAck", -1);

            break;

         /* openLogicalChannelReject */
         case 6:
            invokeStartElement (pctxt, "openLogicalChannelReject", -1);

            pvalue->u.openLogicalChannelReject = ALLOC_ASN1ELEM (pctxt, H245OpenLogicalChannelReject);

            stat = asn1PD_H245OpenLogicalChannelReject (pctxt, pvalue->u.openLogicalChannelReject);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "openLogicalChannelReject", -1);

            break;

         /* closeLogicalChannelAck */
         case 7:
            invokeStartElement (pctxt, "closeLogicalChannelAck", -1);

            pvalue->u.closeLogicalChannelAck = ALLOC_ASN1ELEM (pctxt, H245CloseLogicalChannelAck);

            stat = asn1PD_H245CloseLogicalChannelAck (pctxt, pvalue->u.closeLogicalChannelAck);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "closeLogicalChannelAck", -1);

            break;

         /* requestChannelCloseAck */
         case 8:
            invokeStartElement (pctxt, "requestChannelCloseAck", -1);

            pvalue->u.requestChannelCloseAck = ALLOC_ASN1ELEM (pctxt, H245RequestChannelCloseAck);

            stat = asn1PD_H245RequestChannelCloseAck (pctxt, pvalue->u.requestChannelCloseAck);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestChannelCloseAck", -1);

            break;

         /* requestChannelCloseReject */
         case 9:
            invokeStartElement (pctxt, "requestChannelCloseReject", -1);

            pvalue->u.requestChannelCloseReject = ALLOC_ASN1ELEM (pctxt, H245RequestChannelCloseReject);

            stat = asn1PD_H245RequestChannelCloseReject (pctxt, pvalue->u.requestChannelCloseReject);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestChannelCloseReject", -1);

            break;

         /* multiplexEntrySendAck */
         case 10:
            invokeStartElement (pctxt, "multiplexEntrySendAck", -1);

            pvalue->u.multiplexEntrySendAck = ALLOC_ASN1ELEM (pctxt, H245MultiplexEntrySendAck);

            stat = asn1PD_H245MultiplexEntrySendAck (pctxt, pvalue->u.multiplexEntrySendAck);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multiplexEntrySendAck", -1);

            break;

         /* multiplexEntrySendReject */
         case 11:
            invokeStartElement (pctxt, "multiplexEntrySendReject", -1);

            pvalue->u.multiplexEntrySendReject = ALLOC_ASN1ELEM (pctxt, H245MultiplexEntrySendReject);

            stat = asn1PD_H245MultiplexEntrySendReject (pctxt, pvalue->u.multiplexEntrySendReject);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multiplexEntrySendReject", -1);

            break;

         /* requestMultiplexEntryAck */
         case 12:
            invokeStartElement (pctxt, "requestMultiplexEntryAck", -1);

            pvalue->u.requestMultiplexEntryAck = ALLOC_ASN1ELEM (pctxt, H245RequestMultiplexEntryAck);

            stat = asn1PD_H245RequestMultiplexEntryAck (pctxt, pvalue->u.requestMultiplexEntryAck);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestMultiplexEntryAck", -1);

            break;

         /* requestMultiplexEntryReject */
         case 13:
            invokeStartElement (pctxt, "requestMultiplexEntryReject", -1);

            pvalue->u.requestMultiplexEntryReject = ALLOC_ASN1ELEM (pctxt, H245RequestMultiplexEntryReject);

            stat = asn1PD_H245RequestMultiplexEntryReject (pctxt, pvalue->u.requestMultiplexEntryReject);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestMultiplexEntryReject", -1);

            break;

         /* requestModeAck */
         case 14:
            invokeStartElement (pctxt, "requestModeAck", -1);

            pvalue->u.requestModeAck = ALLOC_ASN1ELEM (pctxt, H245RequestModeAck);

            stat = asn1PD_H245RequestModeAck (pctxt, pvalue->u.requestModeAck);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestModeAck", -1);

            break;

         /* requestModeReject */
         case 15:
            invokeStartElement (pctxt, "requestModeReject", -1);

            pvalue->u.requestModeReject = ALLOC_ASN1ELEM (pctxt, H245RequestModeReject);

            stat = asn1PD_H245RequestModeReject (pctxt, pvalue->u.requestModeReject);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "requestModeReject", -1);

            break;

         /* roundTripDelayResponse */
         case 16:
            invokeStartElement (pctxt, "roundTripDelayResponse", -1);

            pvalue->u.roundTripDelayResponse = ALLOC_ASN1ELEM (pctxt, H245RoundTripDelayResponse);

            stat = asn1PD_H245RoundTripDelayResponse (pctxt, pvalue->u.roundTripDelayResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "roundTripDelayResponse", -1);

            break;

         /* maintenanceLoopAck */
         case 17:
            invokeStartElement (pctxt, "maintenanceLoopAck", -1);

            pvalue->u.maintenanceLoopAck = ALLOC_ASN1ELEM (pctxt, H245MaintenanceLoopAck);

            stat = asn1PD_H245MaintenanceLoopAck (pctxt, pvalue->u.maintenanceLoopAck);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "maintenanceLoopAck", -1);

            break;

         /* maintenanceLoopReject */
         case 18:
            invokeStartElement (pctxt, "maintenanceLoopReject", -1);

            pvalue->u.maintenanceLoopReject = ALLOC_ASN1ELEM (pctxt, H245MaintenanceLoopReject);

            stat = asn1PD_H245MaintenanceLoopReject (pctxt, pvalue->u.maintenanceLoopReject);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "maintenanceLoopReject", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 20;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* communicationModeResponse */
         case 20:
            invokeStartElement (pctxt, "communicationModeResponse", -1);

            pvalue->u.communicationModeResponse = ALLOC_ASN1ELEM (pctxt, H245CommunicationModeResponse);

            stat = asn1PD_H245CommunicationModeResponse (pctxt, pvalue->u.communicationModeResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "communicationModeResponse", -1);

            break;

         /* conferenceResponse */
         case 21:
            invokeStartElement (pctxt, "conferenceResponse", -1);

            pvalue->u.conferenceResponse = ALLOC_ASN1ELEM (pctxt, H245ConferenceResponse);

            stat = asn1PD_H245ConferenceResponse (pctxt, pvalue->u.conferenceResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "conferenceResponse", -1);

            break;

         /* multilinkResponse */
         case 22:
            invokeStartElement (pctxt, "multilinkResponse", -1);

            pvalue->u.multilinkResponse = ALLOC_ASN1ELEM (pctxt, H245MultilinkResponse);

            stat = asn1PD_H245MultilinkResponse (pctxt, pvalue->u.multilinkResponse);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "multilinkResponse", -1);

            break;

         /* logicalChannelRateAcknowledge */
         case 23:
            invokeStartElement (pctxt, "logicalChannelRateAcknowledge", -1);

            pvalue->u.logicalChannelRateAcknowledge = ALLOC_ASN1ELEM (pctxt, H245LogicalChannelRateAcknowledge);

            stat = asn1PD_H245LogicalChannelRateAcknowledge (pctxt, pvalue->u.logicalChannelRateAcknowledge);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "logicalChannelRateAcknowledge", -1);

            break;

         /* logicalChannelRateReject */
         case 24:
            invokeStartElement (pctxt, "logicalChannelRateReject", -1);

            pvalue->u.logicalChannelRateReject = ALLOC_ASN1ELEM (pctxt, H245LogicalChannelRateReject);

            stat = asn1PD_H245LogicalChannelRateReject (pctxt, pvalue->u.logicalChannelRateReject);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "logicalChannelRateReject", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopOffCommand                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245MaintenanceLoopOffCommand (OOCTXT* pctxt, H245MaintenanceLoopOffCommand* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendTerminalCapabilitySet_specificRequest_capabilityTabl  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers (OOCTXT* pctxt, H245SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   ALLOC_ASN1ARRAY (pctxt, pvalue, H245CapabilityTableEntryNumber);

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = asn1PD_H245CapabilityTableEntryNumber (pctxt, &pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendTerminalCapabilitySet_specificRequest_capabilityDesc  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers (OOCTXT* pctxt, H245SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* decode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = decodeLength (pctxt, &pvalue->n);
   if (stat != ASN_OK) return stat;

   /* decode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      invokeStartElement (pctxt, "elem", xx1);

      stat = asn1PD_H245CapabilityDescriptorNumber (pctxt, &pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
      invokeEndElement (pctxt, "elem", xx1);

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendTerminalCapabilitySet_specificRequest                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245SendTerminalCapabilitySet_specificRequest (OOCTXT* pctxt, H245SendTerminalCapabilitySet_specificRequest* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* optional bits */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   DECODEBIT (pctxt, &optbit);
   pvalue->m.capabilityTableEntryNumbersPresent = optbit;

   DECODEBIT (pctxt, &optbit);
   pvalue->m.capabilityDescriptorNumbersPresent = optbit;

   /* decode multiplexCapability */

   invokeStartElement (pctxt, "multiplexCapability", -1);

   stat = DECODEBIT (pctxt, &pvalue->multiplexCapability);
   if (stat != ASN_OK) return stat;
   invokeBoolValue (pctxt, pvalue->multiplexCapability);

   invokeEndElement (pctxt, "multiplexCapability", -1);

   /* decode capabilityTableEntryNumbers */

   if (pvalue->m.capabilityTableEntryNumbersPresent) {
      invokeStartElement (pctxt, "capabilityTableEntryNumbers", -1);

      stat = asn1PD_H245SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers (pctxt, &pvalue->capabilityTableEntryNumbers);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "capabilityTableEntryNumbers", -1);
   }

   /* decode capabilityDescriptorNumbers */

   if (pvalue->m.capabilityDescriptorNumbersPresent) {
      invokeStartElement (pctxt, "capabilityDescriptorNumbers", -1);

      stat = asn1PD_H245SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers (pctxt, &pvalue->capabilityDescriptorNumbers);
      if (stat != ASN_OK) return stat;

      invokeEndElement (pctxt, "capabilityDescriptorNumbers", -1);
   }

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendTerminalCapabilitySet                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245SendTerminalCapabilitySet (OOCTXT* pctxt, H245SendTerminalCapabilitySet* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* specificRequest */
         case 0:
            invokeStartElement (pctxt, "specificRequest", -1);

            pvalue->u.specificRequest = ALLOC_ASN1ELEM (pctxt, H245SendTerminalCapabilitySet_specificRequest);

            stat = asn1PD_H245SendTerminalCapabilitySet_specificRequest (pctxt, pvalue->u.specificRequest);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "specificRequest", -1);

            break;

         /* genericRequest */
         case 1:
            invokeStartElement (pctxt, "genericRequest", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "genericRequest", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 3;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionCommand_encryptionAlgorithmID                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EncryptionCommand_encryptionAlgorithmID (OOCTXT* pctxt, H245EncryptionCommand_encryptionAlgorithmID* pvalue)
{
   int stat = ASN_OK;

   /* decode h233AlgorithmIdentifier */

   invokeStartElement (pctxt, "h233AlgorithmIdentifier", -1);

   stat = asn1PD_H245SequenceNumber (pctxt, &pvalue->h233AlgorithmIdentifier);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "h233AlgorithmIdentifier", -1);

   /* decode associatedAlgorithm */

   invokeStartElement (pctxt, "associatedAlgorithm", -1);

   stat = asn1PD_H245NonStandardParameter (pctxt, &pvalue->associatedAlgorithm);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "associatedAlgorithm", -1);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionCommand                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EncryptionCommand (OOCTXT* pctxt, H245EncryptionCommand* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* encryptionSE */
         case 0:
            invokeStartElement (pctxt, "encryptionSE", -1);

            pvalue->u.encryptionSE = ALLOC_ASN1ELEM (pctxt, ASN1DynOctStr);

            stat = decodeDynOctetString (pctxt, (ASN1DynOctStr*)pvalue->u.encryptionSE);
            if (stat != ASN_OK) return stat;
            invokeOctStrValue (pctxt, pvalue->u.encryptionSE->numocts, pvalue->u.encryptionSE->data);

            invokeEndElement (pctxt, "encryptionSE", -1);

            break;

         /* encryptionIVRequest */
         case 1:
            invokeStartElement (pctxt, "encryptionIVRequest", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "encryptionIVRequest", -1);

            break;

         /* encryptionAlgorithmID */
         case 2:
            invokeStartElement (pctxt, "encryptionAlgorithmID", -1);

            pvalue->u.encryptionAlgorithmID = ALLOC_ASN1ELEM (pctxt, H245EncryptionCommand_encryptionAlgorithmID);

            stat = asn1PD_H245EncryptionCommand_encryptionAlgorithmID (pctxt, pvalue->u.encryptionAlgorithmID);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "encryptionAlgorithmID", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FlowControlCommand_scope                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FlowControlCommand_scope (OOCTXT* pctxt, H245FlowControlCommand_scope* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* logicalChannelNumber */
      case 0:
         invokeStartElement (pctxt, "logicalChannelNumber", -1);

         stat = asn1PD_H245LogicalChannelNumber (pctxt, &pvalue->u.logicalChannelNumber);
         if (stat != ASN_OK) return stat;

         invokeEndElement (pctxt, "logicalChannelNumber", -1);

         break;

      /* resourceID */
      case 1:
         invokeStartElement (pctxt, "resourceID", -1);

         stat = decodeConsUInt16 (pctxt, &pvalue->u.resourceID, 0U, 65535U);
         if (stat != ASN_OK) return stat;
         invokeUIntValue (pctxt, pvalue->u.resourceID);

         invokeEndElement (pctxt, "resourceID", -1);

         break;

      /* wholeMultiplex */
      case 2:
         invokeStartElement (pctxt, "wholeMultiplex", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "wholeMultiplex", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FlowControlCommand_restriction                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FlowControlCommand_restriction (OOCTXT* pctxt, H245FlowControlCommand_restriction* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;

   stat = decodeConsUnsigned (pctxt, &ui, 0, 1);
   if (stat != ASN_OK) return stat;
   else pvalue->t = ui + 1;

   switch (ui) {
      /* maximumBitRate */
      case 0:
         invokeStartElement (pctxt, "maximumBitRate", -1);

         stat = decodeConsUnsigned (pctxt, &pvalue->u.maximumBitRate, 0U, 16777215U);
         if (stat != ASN_OK) return stat;
         invokeUIntValue (pctxt, pvalue->u.maximumBitRate);

         invokeEndElement (pctxt, "maximumBitRate", -1);

         break;

      /* noRestriction */
      case 1:
         invokeStartElement (pctxt, "noRestriction", -1);

         /* NULL */
         invokeNullValue (pctxt);

         invokeEndElement (pctxt, "noRestriction", -1);

         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FlowControlCommand                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245FlowControlCommand (OOCTXT* pctxt, H245FlowControlCommand* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1UINT bitcnt;
   ASN1UINT i;
   ASN1BOOL optbit;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   /* decode scope */

   invokeStartElement (pctxt, "scope", -1);

   stat = asn1PD_H245FlowControlCommand_scope (pctxt, &pvalue->scope);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "scope", -1);

   /* decode restriction */

   invokeStartElement (pctxt, "restriction", -1);

   stat = asn1PD_H245FlowControlCommand_restriction (pctxt, &pvalue->restriction);
   if (stat != ASN_OK) return stat;

   invokeEndElement (pctxt, "restriction", -1);

   if (extbit) {

      /* decode extension optional bits length */

      stat = decodeSmallNonNegWholeNumber (pctxt, &bitcnt);
      if (stat != ASN_OK) return stat;

      bitcnt += 1;

      ZEROCONTEXT (&lctxt);
      stat = setPERBufferUsingCtxt (&lctxt, pctxt);
      if (stat != ASN_OK) return stat;

      stat = moveBitCursor (pctxt, bitcnt);
      if (stat != ASN_OK) return stat;

      for (i = 0; i < bitcnt; i++) {
         DECODEBIT (&lctxt, &optbit);

         if (optbit) {
            stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
            if (stat != ASN_OK) return stat;

            pctxt->buffer.byteIndex += openType.numocts;
         }
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EndSessionCommand_gstnOptions                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EndSessionCommand_gstnOptions (OOCTXT* pctxt, H245EndSessionCommand_gstnOptions* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 4);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* telephonyMode */
         case 0:
            invokeStartElement (pctxt, "telephonyMode", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "telephonyMode", -1);

            break;

         /* v8bis */
         case 1:
            invokeStartElement (pctxt, "v8bis", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "v8bis", -1);

            break;

         /* v34DSVD */
         case 2:
            invokeStartElement (pctxt, "v34DSVD", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "v34DSVD", -1);

            break;

         /* v34DuplexFAX */
         case 3:
            invokeStartElement (pctxt, "v34DuplexFAX", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "v34DuplexFAX", -1);

            break;

         /* v34H324 */
         case 4:
            invokeStartElement (pctxt, "v34H324", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "v34H324", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 6;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EndSessionCommand_isdnOptions                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EndSessionCommand_isdnOptions (OOCTXT* pctxt, H245EndSessionCommand_isdnOptions* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* telephonyMode */
         case 0:
            invokeStartElement (pctxt, "telephonyMode", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "telephonyMode", -1);

            break;

         /* v140 */
         case 1:
            invokeStartElement (pctxt, "v140", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "v140", -1);

            break;

         /* terminalOnHold */
         case 2:
            invokeStartElement (pctxt, "terminalOnHold", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "terminalOnHold", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EndSessionCommand                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PD_H245EndSessionCommand (OOCTXT* pctxt, H245EndSessionCommand* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT ui;
   ASN1OpenType openType;
   ASN1BOOL extbit;
   OOCTXT lctxt;

   /* extension bit */

   DECODEBIT (pctxt, &extbit);

   if (!extbit) {
      stat = decodeConsUnsigned (pctxt, &ui, 0, 2);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 1;

      switch (ui) {
         /* nonStandard */
         case 0:
            invokeStartElement (pctxt, "nonStandard", -1);

            pvalue->u.nonStandard = ALLOC_ASN1ELEM (pctxt, H245NonStandardParameter);

            stat = asn1PD_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "nonStandard", -1);

            break;

         /* disconnect */
         case 1:
            invokeStartElement (pctxt, "disconnect", -1);

            /* NULL */
            invokeNullValue (pctxt);

            invokeEndElement (pctxt, "disconnect", -1);

            break;

         /* gstnOptions */
         case 2:
            invokeStartElement (pctxt, "gstnOptions", -1);

            pvalue->u.gstnOptions = ALLOC_ASN1ELEM (pctxt, H245EndSessionCommand_gstnOptions);

            stat = asn1PD_H245EndSessionCommand_gstnOptions (pctxt, pvalue->u.gstnOptions);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "gstnOptions", -1);

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      stat = decodeSmallNonNegWholeNumber (pctxt, &ui);
      if (stat != ASN_OK) return stat;
      else pvalue->t = ui + 4;

      stat = decodeByteAlign (pctxt);
      if (stat != ASN_OK) return stat;

      stat = decodeOpenType (pctxt, &openType.data, &openType.numocts);
      if (stat != ASN_OK) return stat;

      copyContext (&lctxt, pctxt);
      initContextBuffer (pctxt, openType.data, openType.numocts);

      switch (pvalue->t) {
         /* isdnOptions */
         case 4:
            invokeStartElement (pctxt, "isdnOptions", -1);

            pvalue->u.isdnOptions = ALLOC_ASN1ELEM (pctxt, H245EndSessionCommand_isdnOptions);

            stat = asn1PD_H245EndSessionCommand_isdnOptions (pctxt, pvalue->u.isdnOptions);
            if (stat != ASN_OK) return stat;

            invokeEndElement (pctxt, "isdnOptions", -1);

            break;

         default:;
      }

      copyContext (pctxt, &lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousCommand_type_videoFastUpdateGOB              */
/*                                                            */
/**************************************************************/
