/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 5.72, Date: 22-Mar-2005.
 */
#include "ooasn1.h"
#include "MULTIMEDIA-SYSTEM-CONTROL.h"

/**************************************************************/
/*                                                            */
/*  NonStandardIdentifier_h221NonStandard                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NonStandardIdentifier_h221NonStandard (OOCTXT* pctxt, H245NonStandardIdentifier_h221NonStandard* pvalue)
{
   int stat = ASN_OK;

   /* encode t35CountryCode */

   stat = encodeConsUnsigned (pctxt, pvalue->t35CountryCode, 0U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode t35Extension */

   stat = encodeConsUnsigned (pctxt, pvalue->t35Extension, 0U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode manufacturerCode */

   stat = encodeConsUnsigned (pctxt, pvalue->manufacturerCode, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonStandardIdentifier                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NonStandardIdentifier (OOCTXT* pctxt, H245NonStandardIdentifier* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* object */
      case 1:
         stat = encodeObjectIdentifier (pctxt, pvalue->u.object);
         if (stat != ASN_OK) return stat;
         break;

      /* h221NonStandard */
      case 2:
         stat = asn1PE_H245NonStandardIdentifier_h221NonStandard (pctxt, pvalue->u.h221NonStandard);
         if (stat != ASN_OK) return stat;
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonStandardParameter                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NonStandardParameter (OOCTXT* pctxt, H245NonStandardParameter* pvalue)
{
   int stat = ASN_OK;

   /* encode nonStandardIdentifier */

   stat = asn1PE_H245NonStandardIdentifier (pctxt, &pvalue->nonStandardIdentifier);
   if (stat != ASN_OK) return stat;

   /* encode data */

   stat = encodeOctetString (pctxt, pvalue->data.numocts, pvalue->data.data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V42bis                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245V42bis (OOCTXT* pctxt, H245V42bis* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode numberOfCodewords */

   stat = encodeConsUnsigned (pctxt, pvalue->numberOfCodewords, 1U, 65536U);
   if (stat != ASN_OK) return stat;

   /* encode maximumStringLength */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumStringLength, 1U, 256U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CompressionType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CompressionType (OOCTXT* pctxt, H245CompressionType* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 1);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* v42bis */
         case 1:
            stat = asn1PE_H245V42bis (pctxt, pvalue->u.v42bis);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 2);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataProtocolCapability_v76wCompression                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataProtocolCapability_v76wCompression (OOCTXT* pctxt, H245DataProtocolCapability_v76wCompression* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* transmitCompression */
         case 1:
            stat = asn1PE_H245CompressionType (pctxt, pvalue->u.transmitCompression);
            if (stat != ASN_OK) return stat;
            break;

         /* receiveCompression */
         case 2:
            stat = asn1PE_H245CompressionType (pctxt, pvalue->u.receiveCompression);
            if (stat != ASN_OK) return stat;
            break;

         /* transmitAndReceiveCompression */
         case 3:
            stat = asn1PE_H245CompressionType (pctxt, pvalue->u.transmitAndReceiveCompression);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataProtocolCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataProtocolCapability (OOCTXT* pctxt, H245DataProtocolCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 7);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 6);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* v14buffered */
         case 2:
            /* NULL */
            break;

         /* v42lapm */
         case 3:
            /* NULL */
            break;

         /* hdlcFrameTunnelling */
         case 4:
            /* NULL */
            break;

         /* h310SeparateVCStack */
         case 5:
            /* NULL */
            break;

         /* h310SingleVCStack */
         case 6:
            /* NULL */
            break;

         /* transparent */
         case 7:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 8);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* segmentationAndReassembly */
         case 8:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* hdlcFrameTunnelingwSAR */
         case 9:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* v120 */
         case 10:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* separateLANStack */
         case 11:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* v76wCompression */
         case 12:
            stat = asn1PE_H245DataProtocolCapability_v76wCompression (&lctxt, pvalue->u.v76wCompression);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* tcp */
         case 13:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* udp */
         case 14:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T38FaxRateManagement                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245T38FaxRateManagement (OOCTXT* pctxt, H245T38FaxRateManagement* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* localTCF */
         case 1:
            /* NULL */
            break;

         /* transferredTCF */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T38FaxUdpOptions_t38FaxUdpEC                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245T38FaxUdpOptions_t38FaxUdpEC (OOCTXT* pctxt, H245T38FaxUdpOptions_t38FaxUdpEC* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* t38UDPFEC */
         case 1:
            /* NULL */
            break;

         /* t38UDPRedundancy */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T38FaxUdpOptions                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245T38FaxUdpOptions (OOCTXT* pctxt, H245T38FaxUdpOptions* pvalue)
{
   int stat = ASN_OK;

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.t38FaxMaxBufferPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.t38FaxMaxDatagramPresent);

   /* encode t38FaxMaxBuffer */

   if (pvalue->m.t38FaxMaxBufferPresent) {
      stat = encodeUnconsInteger (pctxt, pvalue->t38FaxMaxBuffer);
      if (stat != ASN_OK) return stat;
   }

   /* encode t38FaxMaxDatagram */

   if (pvalue->m.t38FaxMaxDatagramPresent) {
      stat = encodeUnconsInteger (pctxt, pvalue->t38FaxMaxDatagram);
      if (stat != ASN_OK) return stat;
   }

   /* encode t38FaxUdpEC */

   stat = asn1PE_H245T38FaxUdpOptions_t38FaxUdpEC (pctxt, &pvalue->t38FaxUdpEC);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T38FaxTcpOptions                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245T38FaxTcpOptions (OOCTXT* pctxt, H245T38FaxTcpOptions* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode t38TCPBidirectionalMode */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->t38TCPBidirectionalMode);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T38FaxProfile                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245T38FaxProfile (OOCTXT* pctxt, H245T38FaxProfile* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.versionPresent ||
   pvalue->m.t38FaxRateManagementPresent ||
   pvalue->m.t38FaxUdpOptionsPresent ||
   pvalue->m.t38FaxTcpOptionsPresent);

   encodeBit (pctxt, extbit);

   /* encode fillBitRemoval */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->fillBitRemoval);
   if (stat != ASN_OK) return stat;

   /* encode transcodingJBIG */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->transcodingJBIG);
   if (stat != ASN_OK) return stat;

   /* encode transcodingMMR */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->transcodingMMR);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 3);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.versionPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.t38FaxRateManagementPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.t38FaxUdpOptionsPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.t38FaxTcpOptionsPresent);
      /* encode extension elements */

      if (pvalue->m.versionPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeConsUnsigned (&lctxt, pvalue->version, 0U, 255U);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.t38FaxRateManagementPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245T38FaxRateManagement (&lctxt, &pvalue->t38FaxRateManagement);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.t38FaxUdpOptionsPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245T38FaxUdpOptions (&lctxt, &pvalue->t38FaxUdpOptions);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.t38FaxTcpOptionsPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245T38FaxTcpOptions (&lctxt, &pvalue->t38FaxTcpOptions);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonStandardMessage                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NonStandardMessage (OOCTXT* pctxt, H245NonStandardMessage* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode nonStandardData */

   stat = asn1PE_H245NonStandardParameter (pctxt, &pvalue->nonStandardData);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MasterSlaveDetermination                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MasterSlaveDetermination (OOCTXT* pctxt, H245MasterSlaveDetermination* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode terminalType */

   stat = encodeConsUnsigned (pctxt, pvalue->terminalType, 0U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode statusDeterminationNumber */

   stat = encodeConsUnsigned (pctxt, pvalue->statusDeterminationNumber, 0U, 16777215U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SequenceNumber                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245SequenceNumber (OOCTXT* pctxt, H245SequenceNumber value)
{
   int stat = ASN_OK;

   stat = encodeConsUnsigned (pctxt, value, 0U, 255U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_aal1                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VCCapability_aal1 (OOCTXT* pctxt, H245VCCapability_aal1* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode nullClockRecovery */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->nullClockRecovery);
   if (stat != ASN_OK) return stat;

   /* encode srtsClockRecovery */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->srtsClockRecovery);
   if (stat != ASN_OK) return stat;

   /* encode adaptiveClockRecovery */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->adaptiveClockRecovery);
   if (stat != ASN_OK) return stat;

   /* encode nullErrorCorrection */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->nullErrorCorrection);
   if (stat != ASN_OK) return stat;

   /* encode longInterleaver */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->longInterleaver);
   if (stat != ASN_OK) return stat;

   /* encode shortInterleaver */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->shortInterleaver);
   if (stat != ASN_OK) return stat;

   /* encode errorCorrectionOnly */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->errorCorrectionOnly);
   if (stat != ASN_OK) return stat;

   /* encode structuredDataTransfer */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->structuredDataTransfer);
   if (stat != ASN_OK) return stat;

   /* encode partiallyFilledCells */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->partiallyFilledCells);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_aal5                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VCCapability_aal5 (OOCTXT* pctxt, H245VCCapability_aal5* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode forwardMaximumSDUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->forwardMaximumSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode backwardMaximumSDUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->backwardMaximumSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_availableBitRates_type_rangeOfBitRates       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VCCapability_availableBitRates_type_rangeOfBitRates (OOCTXT* pctxt, H245VCCapability_availableBitRates_type_rangeOfBitRates* pvalue)
{
   int stat = ASN_OK;

   /* encode lowerBitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->lowerBitRate, 1U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode higherBitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->higherBitRate, 1U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_availableBitRates_type                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VCCapability_availableBitRates_type (OOCTXT* pctxt, H245VCCapability_availableBitRates_type* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* singleBitRate */
      case 1:
         stat = encodeConsUnsigned (pctxt, pvalue->u.singleBitRate, 1U, 65535U);
         if (stat != ASN_OK) return stat;

         break;

      /* rangeOfBitRates */
      case 2:
         stat = asn1PE_H245VCCapability_availableBitRates_type_rangeOfBitRates (pctxt, pvalue->u.rangeOfBitRates);
         if (stat != ASN_OK) return stat;
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_availableBitRates                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VCCapability_availableBitRates (OOCTXT* pctxt, H245VCCapability_availableBitRates* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode type */

   stat = asn1PE_H245VCCapability_availableBitRates_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Q2931Address_address_nsapAddress                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245Q2931Address_address_nsapAddress (OOCTXT* pctxt, H245Q2931Address_address_nsapAddress* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 20, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Q2931Address_address                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245Q2931Address_address (OOCTXT* pctxt, H245Q2931Address_address* pvalue)
{
   static Asn1SizeCnst internationalNumber_lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* internationalNumber */
         case 1:
            addSizeConstraint (pctxt, &internationalNumber_lsize1);

            stat = encodeConstrainedStringEx (pctxt, pvalue->u.internationalNumber, NUM_CANSET, 4, 4, 4);
            if (stat != ASN_OK) return stat;
            break;

         /* nsapAddress */
         case 2:
            stat = asn1PE_H245Q2931Address_address_nsapAddress (pctxt, pvalue->u.nsapAddress);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Q2931Address_subaddress                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245Q2931Address_subaddress (OOCTXT* pctxt, H245Q2931Address_subaddress* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 20, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Q2931Address                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245Q2931Address (OOCTXT* pctxt, H245Q2931Address* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.subaddressPresent);

   /* encode address */

   stat = asn1PE_H245Q2931Address_address (pctxt, &pvalue->address);
   if (stat != ASN_OK) return stat;

   /* encode subaddress */

   if (pvalue->m.subaddressPresent) {
      stat = asn1PE_H245Q2931Address_subaddress (pctxt, &pvalue->subaddress);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_aal1ViaGateway_gatewayAddress                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VCCapability_aal1ViaGateway_gatewayAddress (OOCTXT* pctxt, H245VCCapability_aal1ViaGateway_gatewayAddress* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245Q2931Address (pctxt, ((H245Q2931Address*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability_aal1ViaGateway                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VCCapability_aal1ViaGateway (OOCTXT* pctxt, H245VCCapability_aal1ViaGateway* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode gatewayAddress */

   stat = asn1PE_H245VCCapability_aal1ViaGateway_gatewayAddress (pctxt, &pvalue->gatewayAddress);
   if (stat != ASN_OK) return stat;

   /* encode nullClockRecovery */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->nullClockRecovery);
   if (stat != ASN_OK) return stat;

   /* encode srtsClockRecovery */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->srtsClockRecovery);
   if (stat != ASN_OK) return stat;

   /* encode adaptiveClockRecovery */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->adaptiveClockRecovery);
   if (stat != ASN_OK) return stat;

   /* encode nullErrorCorrection */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->nullErrorCorrection);
   if (stat != ASN_OK) return stat;

   /* encode longInterleaver */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->longInterleaver);
   if (stat != ASN_OK) return stat;

   /* encode shortInterleaver */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->shortInterleaver);
   if (stat != ASN_OK) return stat;

   /* encode errorCorrectionOnly */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->errorCorrectionOnly);
   if (stat != ASN_OK) return stat;

   /* encode structuredDataTransfer */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->structuredDataTransfer);
   if (stat != ASN_OK) return stat;

   /* encode partiallyFilledCells */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->partiallyFilledCells);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VCCapability                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VCCapability (OOCTXT* pctxt, H245VCCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.aal1ViaGatewayPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.aal1Present);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.aal5Present);

   /* encode aal1 */

   if (pvalue->m.aal1Present) {
      stat = asn1PE_H245VCCapability_aal1 (pctxt, &pvalue->aal1);
      if (stat != ASN_OK) return stat;
   }

   /* encode aal5 */

   if (pvalue->m.aal5Present) {
      stat = asn1PE_H245VCCapability_aal5 (pctxt, &pvalue->aal5);
      if (stat != ASN_OK) return stat;
   }

   /* encode transportStream */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->transportStream);
   if (stat != ASN_OK) return stat;

   /* encode programStream */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->programStream);
   if (stat != ASN_OK) return stat;

   /* encode availableBitRates */

   stat = asn1PE_H245VCCapability_availableBitRates (pctxt, &pvalue->availableBitRates);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.aal1ViaGatewayPresent);
      /* encode extension elements */

      if (pvalue->m.aal1ViaGatewayPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245VCCapability_aal1ViaGateway (&lctxt, &pvalue->aal1ViaGateway);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SetOfH245VCCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SetOfH245VCCapability (OOCTXT* pctxt, H245_SetOfH245VCCapability* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245VCCapability (pctxt, ((H245VCCapability*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H222Capability                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H222Capability (OOCTXT* pctxt, H245H222Capability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode numberOfVCs */

   stat = encodeConsUnsigned (pctxt, pvalue->numberOfVCs, 1U, 256U);
   if (stat != ASN_OK) return stat;

   /* encode vcCapability */

   stat = asn1PE_H245_SetOfH245VCCapability (pctxt, &pvalue->vcCapability);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223Capability_h223MultiplexTableCapability_enhanced      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223Capability_h223MultiplexTableCapability_enhanced (OOCTXT* pctxt, H245H223Capability_h223MultiplexTableCapability_enhanced* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode maximumNestingDepth */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumNestingDepth, 1U, 15U);
   if (stat != ASN_OK) return stat;

   /* encode maximumElementListSize */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumElementListSize, 2U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode maximumSubElementListSize */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumSubElementListSize, 2U, 255U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223Capability_h223MultiplexTableCapability               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223Capability_h223MultiplexTableCapability (OOCTXT* pctxt, H245H223Capability_h223MultiplexTableCapability* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* basic */
      case 1:
         /* NULL */
         break;

      /* enhanced */
      case 2:
         stat = asn1PE_H245H223Capability_h223MultiplexTableCapability_enhanced (pctxt, pvalue->u.enhanced);
         if (stat != ASN_OK) return stat;
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223Capability_mobileOperationTransmitCapability          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223Capability_mobileOperationTransmitCapability (OOCTXT* pctxt, H245H223Capability_mobileOperationTransmitCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode modeChangeCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->modeChangeCapability);
   if (stat != ASN_OK) return stat;

   /* encode h223AnnexA */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->h223AnnexA);
   if (stat != ASN_OK) return stat;

   /* encode h223AnnexADoubleFlag */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->h223AnnexADoubleFlag);
   if (stat != ASN_OK) return stat;

   /* encode h223AnnexB */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->h223AnnexB);
   if (stat != ASN_OK) return stat;

   /* encode h223AnnexBwithHeader */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->h223AnnexBwithHeader);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AnnexCCapability                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AnnexCCapability (OOCTXT* pctxt, H245H223AnnexCCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.rsCodeCapabilityPresent);

   encodeBit (pctxt, extbit);

   /* encode videoWithAL1M */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->videoWithAL1M);
   if (stat != ASN_OK) return stat;

   /* encode videoWithAL2M */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->videoWithAL2M);
   if (stat != ASN_OK) return stat;

   /* encode videoWithAL3M */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->videoWithAL3M);
   if (stat != ASN_OK) return stat;

   /* encode audioWithAL1M */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioWithAL1M);
   if (stat != ASN_OK) return stat;

   /* encode audioWithAL2M */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioWithAL2M);
   if (stat != ASN_OK) return stat;

   /* encode audioWithAL3M */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioWithAL3M);
   if (stat != ASN_OK) return stat;

   /* encode dataWithAL1M */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dataWithAL1M);
   if (stat != ASN_OK) return stat;

   /* encode dataWithAL2M */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dataWithAL2M);
   if (stat != ASN_OK) return stat;

   /* encode dataWithAL3M */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dataWithAL3M);
   if (stat != ASN_OK) return stat;

   /* encode alpduInterleaving */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->alpduInterleaving);
   if (stat != ASN_OK) return stat;

   /* encode maximumAL1MPDUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumAL1MPDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode maximumAL2MSDUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumAL2MSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode maximumAL3MSDUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumAL3MSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.rsCodeCapabilityPresent);
      /* encode extension elements */

      if (pvalue->m.rsCodeCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->rsCodeCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223Capability_mobileMultilinkFrameCapability             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223Capability_mobileMultilinkFrameCapability (OOCTXT* pctxt, H245H223Capability_mobileMultilinkFrameCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode maximumSampleSize */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumSampleSize, 1U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode maximumPayloadLength */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumPayloadLength, 1U, 65025U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223Capability                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223Capability (OOCTXT* pctxt, H245H223Capability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.maxMUXPDUSizeCapabilityPresent ||
   pvalue->m.nsrpSupportPresent ||
   pvalue->m.mobileOperationTransmitCapabilityPresent ||
   pvalue->m.h223AnnexCCapabilityPresent ||
   pvalue->m.bitRatePresent ||
   pvalue->m.mobileMultilinkFrameCapabilityPresent);

   encodeBit (pctxt, extbit);

   /* encode transportWithI_frames */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->transportWithI_frames);
   if (stat != ASN_OK) return stat;

   /* encode videoWithAL1 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->videoWithAL1);
   if (stat != ASN_OK) return stat;

   /* encode videoWithAL2 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->videoWithAL2);
   if (stat != ASN_OK) return stat;

   /* encode videoWithAL3 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->videoWithAL3);
   if (stat != ASN_OK) return stat;

   /* encode audioWithAL1 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioWithAL1);
   if (stat != ASN_OK) return stat;

   /* encode audioWithAL2 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioWithAL2);
   if (stat != ASN_OK) return stat;

   /* encode audioWithAL3 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioWithAL3);
   if (stat != ASN_OK) return stat;

   /* encode dataWithAL1 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dataWithAL1);
   if (stat != ASN_OK) return stat;

   /* encode dataWithAL2 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dataWithAL2);
   if (stat != ASN_OK) return stat;

   /* encode dataWithAL3 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dataWithAL3);
   if (stat != ASN_OK) return stat;

   /* encode maximumAl2SDUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumAl2SDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode maximumAl3SDUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumAl3SDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode maximumDelayJitter */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumDelayJitter, 0U, 1023U);
   if (stat != ASN_OK) return stat;

   /* encode h223MultiplexTableCapability */

   stat = asn1PE_H245H223Capability_h223MultiplexTableCapability (pctxt, &pvalue->h223MultiplexTableCapability);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 5);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.maxMUXPDUSizeCapabilityPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.nsrpSupportPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.mobileOperationTransmitCapabilityPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.h223AnnexCCapabilityPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.bitRatePresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.mobileMultilinkFrameCapabilityPresent);
      /* encode extension elements */

      if (pvalue->m.maxMUXPDUSizeCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->maxMUXPDUSizeCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.nsrpSupportPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->nsrpSupport);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.mobileOperationTransmitCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245H223Capability_mobileOperationTransmitCapability (&lctxt, &pvalue->mobileOperationTransmitCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.h223AnnexCCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245H223AnnexCCapability (&lctxt, &pvalue->h223AnnexCCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.bitRatePresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeConsUnsigned (&lctxt, pvalue->bitRate, 1U, 19200U);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.mobileMultilinkFrameCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245H223Capability_mobileMultilinkFrameCapability (&lctxt, &pvalue->mobileMultilinkFrameCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V75Capability                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245V75Capability (OOCTXT* pctxt, H245V75Capability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode audioHeader */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioHeader);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76Capability                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245V76Capability (OOCTXT* pctxt, H245V76Capability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode suspendResumeCapabilitywAddress */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->suspendResumeCapabilitywAddress);
   if (stat != ASN_OK) return stat;

   /* encode suspendResumeCapabilitywoAddress */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->suspendResumeCapabilitywoAddress);
   if (stat != ASN_OK) return stat;

   /* encode rejCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->rejCapability);
   if (stat != ASN_OK) return stat;

   /* encode sREJCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->sREJCapability);
   if (stat != ASN_OK) return stat;

   /* encode mREJCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->mREJCapability);
   if (stat != ASN_OK) return stat;

   /* encode crc8bitCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->crc8bitCapability);
   if (stat != ASN_OK) return stat;

   /* encode crc16bitCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->crc16bitCapability);
   if (stat != ASN_OK) return stat;

   /* encode crc32bitCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->crc32bitCapability);
   if (stat != ASN_OK) return stat;

   /* encode uihCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->uihCapability);
   if (stat != ASN_OK) return stat;

   /* encode numOfDLCS */

   stat = encodeConsUnsigned (pctxt, pvalue->numOfDLCS, 2U, 8191U);
   if (stat != ASN_OK) return stat;

   /* encode twoOctetAddressFieldCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->twoOctetAddressFieldCapability);
   if (stat != ASN_OK) return stat;

   /* encode loopBackTestCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->loopBackTestCapability);
   if (stat != ASN_OK) return stat;

   /* encode n401Capability */

   stat = encodeConsUnsigned (pctxt, pvalue->n401Capability, 1U, 4095U);
   if (stat != ASN_OK) return stat;

   /* encode maxWindowSizeCapability */

   stat = encodeConsUnsigned (pctxt, pvalue->maxWindowSizeCapability, 1U, 127U);
   if (stat != ASN_OK) return stat;

   /* encode v75Capability */

   stat = asn1PE_H245V75Capability (pctxt, &pvalue->v75Capability);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T84Profile_t84Restricted                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245T84Profile_t84Restricted (OOCTXT* pctxt, H245T84Profile_t84Restricted* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode qcif */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->qcif);
   if (stat != ASN_OK) return stat;

   /* encode cif */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->cif);
   if (stat != ASN_OK) return stat;

   /* encode ccir601Seq */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->ccir601Seq);
   if (stat != ASN_OK) return stat;

   /* encode ccir601Prog */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->ccir601Prog);
   if (stat != ASN_OK) return stat;

   /* encode hdtvSeq */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->hdtvSeq);
   if (stat != ASN_OK) return stat;

   /* encode hdtvProg */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->hdtvProg);
   if (stat != ASN_OK) return stat;

   /* encode g3FacsMH200x100 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->g3FacsMH200x100);
   if (stat != ASN_OK) return stat;

   /* encode g3FacsMH200x200 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->g3FacsMH200x200);
   if (stat != ASN_OK) return stat;

   /* encode g4FacsMMR200x100 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->g4FacsMMR200x100);
   if (stat != ASN_OK) return stat;

   /* encode g4FacsMMR200x200 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->g4FacsMMR200x200);
   if (stat != ASN_OK) return stat;

   /* encode jbig200x200Seq */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->jbig200x200Seq);
   if (stat != ASN_OK) return stat;

   /* encode jbig200x200Prog */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->jbig200x200Prog);
   if (stat != ASN_OK) return stat;

   /* encode jbig300x300Seq */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->jbig300x300Seq);
   if (stat != ASN_OK) return stat;

   /* encode jbig300x300Prog */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->jbig300x300Prog);
   if (stat != ASN_OK) return stat;

   /* encode digPhotoLow */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->digPhotoLow);
   if (stat != ASN_OK) return stat;

   /* encode digPhotoMedSeq */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->digPhotoMedSeq);
   if (stat != ASN_OK) return stat;

   /* encode digPhotoMedProg */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->digPhotoMedProg);
   if (stat != ASN_OK) return stat;

   /* encode digPhotoHighSeq */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->digPhotoHighSeq);
   if (stat != ASN_OK) return stat;

   /* encode digPhotoHighProg */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->digPhotoHighProg);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  T84Profile                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245T84Profile (OOCTXT* pctxt, H245T84Profile* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* t84Unrestricted */
      case 1:
         /* NULL */
         break;

      /* t84Restricted */
      case 2:
         stat = asn1PE_H245T84Profile_t84Restricted (pctxt, pvalue->u.t84Restricted);
         if (stat != ASN_OK) return stat;
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataApplicationCapability_application_t84                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataApplicationCapability_application_t84 (OOCTXT* pctxt, H245DataApplicationCapability_application_t84* pvalue)
{
   int stat = ASN_OK;

   /* encode t84Protocol */

   stat = asn1PE_H245DataProtocolCapability (pctxt, &pvalue->t84Protocol);
   if (stat != ASN_OK) return stat;

   /* encode t84Profile */

   stat = asn1PE_H245T84Profile (pctxt, &pvalue->t84Profile);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataApplicationCapability_application_nlpid               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataApplicationCapability_application_nlpid (OOCTXT* pctxt, H245DataApplicationCapability_application_nlpid* pvalue)
{
   int stat = ASN_OK;

   /* encode nlpidProtocol */

   stat = asn1PE_H245DataProtocolCapability (pctxt, &pvalue->nlpidProtocol);
   if (stat != ASN_OK) return stat;

   /* encode nlpidData */

   stat = encodeOctetString (pctxt, pvalue->nlpidData.numocts, pvalue->nlpidData.data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataApplicationCapability_application_t38fax              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataApplicationCapability_application_t38fax (OOCTXT* pctxt, H245DataApplicationCapability_application_t38fax* pvalue)
{
   int stat = ASN_OK;

   /* encode t38FaxProtocol */

   stat = asn1PE_H245DataProtocolCapability (pctxt, &pvalue->t38FaxProtocol);
   if (stat != ASN_OK) return stat;

   /* encode t38FaxProfile */

   stat = asn1PE_H245T38FaxProfile (pctxt, &pvalue->t38FaxProfile);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityIdentifier_uuid                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CapabilityIdentifier_uuid (OOCTXT* pctxt, H245CapabilityIdentifier_uuid* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityIdentifier                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CapabilityIdentifier (OOCTXT* pctxt, H245CapabilityIdentifier* pvalue)
{
   static Asn1SizeCnst domainBased_lsize1 = { 0, 1, 64, 0 };
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* standard */
         case 1:
            stat = encodeObjectIdentifier (pctxt, pvalue->u.standard);
            if (stat != ASN_OK) return stat;
            break;

         /* h221NonStandard */
         case 2:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.h221NonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* uuid */
         case 3:
            stat = asn1PE_H245CapabilityIdentifier_uuid (pctxt, pvalue->u.uuid);
            if (stat != ASN_OK) return stat;
            break;

         /* domainBased */
         case 4:
            addSizeConstraint (pctxt, &domainBased_lsize1);

            stat = encodeConstrainedStringEx (pctxt, pvalue->u.domainBased, 0, 8, 7, 7);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ParameterIdentifier_uuid                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ParameterIdentifier_uuid (OOCTXT* pctxt, H245ParameterIdentifier_uuid* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ParameterIdentifier                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ParameterIdentifier (OOCTXT* pctxt, H245ParameterIdentifier* pvalue)
{
   static Asn1SizeCnst domainBased_lsize1 = { 0, 1, 64, 0 };
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* standard */
         case 1:
            stat = encodeConsUnsigned (pctxt, pvalue->u.standard, 0U, 127U);
            if (stat != ASN_OK) return stat;

            break;

         /* h221NonStandard */
         case 2:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.h221NonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* uuid */
         case 3:
            stat = asn1PE_H245ParameterIdentifier_uuid (pctxt, pvalue->u.uuid);
            if (stat != ASN_OK) return stat;
            break;

         /* domainBased */
         case 4:
            addSizeConstraint (pctxt, &domainBased_lsize1);

            stat = encodeConstrainedStringEx (pctxt, pvalue->u.domainBased, 0, 8, 7, 7);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ParameterValue                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ParameterValue (OOCTXT* pctxt, H245ParameterValue* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 8);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 7);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* logical */
         case 1:
            /* NULL */
            break;

         /* booleanArray */
         case 2:
            stat = encodeConsUnsigned (pctxt, pvalue->u.booleanArray, 0U, 255U);
            if (stat != ASN_OK) return stat;

            break;

         /* unsignedMin */
         case 3:
            stat = encodeConsUnsigned (pctxt, pvalue->u.unsignedMin, 0U, 65535U);
            if (stat != ASN_OK) return stat;

            break;

         /* unsignedMax */
         case 4:
            stat = encodeConsUnsigned (pctxt, pvalue->u.unsignedMax, 0U, 65535U);
            if (stat != ASN_OK) return stat;

            break;

         /* unsigned32Min */
         case 5:
            stat = encodeConsUnsigned (pctxt, pvalue->u.unsigned32Min, 0U, ASN1UINT_MAX);
            if (stat != ASN_OK) return stat;

            break;

         /* unsigned32Max */
         case 6:
            stat = encodeConsUnsigned (pctxt, pvalue->u.unsigned32Max, 0U, ASN1UINT_MAX);
            if (stat != ASN_OK) return stat;

            break;

         /* octetString */
         case 7:
            stat = encodeOctetString (pctxt, pvalue->u.octetString->numocts, pvalue->u.octetString->data);
            if (stat != ASN_OK) return stat;
            break;

         /* genericParameter */
         case 8:
            stat = asn1PE_H245_SeqOfH245GenericParameter (pctxt, (H245_SeqOfH245GenericParameter*)pvalue->u.genericParameter);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 9);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245ParameterIdentifier                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245ParameterIdentifier (OOCTXT* pctxt, H245_SeqOfH245ParameterIdentifier* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245ParameterIdentifier (pctxt, ((H245ParameterIdentifier*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GenericParameter                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245GenericParameter (OOCTXT* pctxt, H245GenericParameter* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.supersedesPresent);

   /* encode parameterIdentifier */

   stat = asn1PE_H245ParameterIdentifier (pctxt, &pvalue->parameterIdentifier);
   if (stat != ASN_OK) return stat;

   /* encode parameterValue */

   stat = asn1PE_H245ParameterValue (pctxt, &pvalue->parameterValue);
   if (stat != ASN_OK) return stat;

   /* encode supersedes */

   if (pvalue->m.supersedesPresent) {
      stat = asn1PE_H245_SeqOfH245ParameterIdentifier (pctxt, &pvalue->supersedes);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245GenericParameter                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245GenericParameter (OOCTXT* pctxt, H245_SeqOfH245GenericParameter* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245GenericParameter (pctxt, ((H245GenericParameter*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GenericCapability                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245GenericCapability (OOCTXT* pctxt, H245GenericCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.maxBitRatePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.collapsingPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.nonCollapsingPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.nonCollapsingRawPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.transportPresent);

   /* encode capabilityIdentifier */

   stat = asn1PE_H245CapabilityIdentifier (pctxt, &pvalue->capabilityIdentifier);
   if (stat != ASN_OK) return stat;

   /* encode maxBitRate */

   if (pvalue->m.maxBitRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->maxBitRate, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   /* encode collapsing */

   if (pvalue->m.collapsingPresent) {
      stat = asn1PE_H245_SeqOfH245GenericParameter (pctxt, &pvalue->collapsing);
      if (stat != ASN_OK) return stat;
   }

   /* encode nonCollapsing */

   if (pvalue->m.nonCollapsingPresent) {
      stat = asn1PE_H245_SeqOfH245GenericParameter (pctxt, &pvalue->nonCollapsing);
      if (stat != ASN_OK) return stat;
   }

   /* encode nonCollapsingRaw */

   if (pvalue->m.nonCollapsingRawPresent) {
      stat = encodeOctetString (pctxt, pvalue->nonCollapsingRaw.numocts, pvalue->nonCollapsingRaw.data);
      if (stat != ASN_OK) return stat;
   }

   /* encode transport */

   if (pvalue->m.transportPresent) {
      stat = asn1PE_H245DataProtocolCapability (pctxt, &pvalue->transport);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataApplicationCapability_application                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataApplicationCapability_application (OOCTXT* pctxt, H245DataApplicationCapability_application* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 10);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 9);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* t120 */
         case 2:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.t120);
            if (stat != ASN_OK) return stat;
            break;

         /* dsm_cc */
         case 3:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.dsm_cc);
            if (stat != ASN_OK) return stat;
            break;

         /* userData */
         case 4:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.userData);
            if (stat != ASN_OK) return stat;
            break;

         /* t84 */
         case 5:
            stat = asn1PE_H245DataApplicationCapability_application_t84 (pctxt, pvalue->u.t84);
            if (stat != ASN_OK) return stat;
            break;

         /* t434 */
         case 6:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.t434);
            if (stat != ASN_OK) return stat;
            break;

         /* h224 */
         case 7:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.h224);
            if (stat != ASN_OK) return stat;
            break;

         /* nlpid */
         case 8:
            stat = asn1PE_H245DataApplicationCapability_application_nlpid (pctxt, pvalue->u.nlpid);
            if (stat != ASN_OK) return stat;
            break;

         /* dsvdControl */
         case 9:
            /* NULL */
            break;

         /* h222DataPartitioning */
         case 10:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.h222DataPartitioning);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 11);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* t30fax */
         case 11:
            stat = asn1PE_H245DataProtocolCapability (&lctxt, pvalue->u.t30fax);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* t140 */
         case 12:
            stat = asn1PE_H245DataProtocolCapability (&lctxt, pvalue->u.t140);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* t38fax */
         case 13:
            stat = asn1PE_H245DataApplicationCapability_application_t38fax (&lctxt, pvalue->u.t38fax);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* genericDataCapability */
         case 14:
            stat = asn1PE_H245GenericCapability (&lctxt, pvalue->u.genericDataCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataApplicationCapability                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataApplicationCapability (OOCTXT* pctxt, H245DataApplicationCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode application */

   stat = asn1PE_H245DataApplicationCapability_application (pctxt, &pvalue->application);
   if (stat != ASN_OK) return stat;

   /* encode maxBitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->maxBitRate, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245DataApplicationCapability                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245DataApplicationCapability (OOCTXT* pctxt, H245_SeqOfH245DataApplicationCapability* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245DataApplicationCapability (pctxt, ((H245DataApplicationCapability*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaDistributionCapability                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MediaDistributionCapability (OOCTXT* pctxt, H245MediaDistributionCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.centralizedDataPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.distributedDataPresent);

   /* encode centralizedControl */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->centralizedControl);
   if (stat != ASN_OK) return stat;

   /* encode distributedControl */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->distributedControl);
   if (stat != ASN_OK) return stat;

   /* encode centralizedAudio */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->centralizedAudio);
   if (stat != ASN_OK) return stat;

   /* encode distributedAudio */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->distributedAudio);
   if (stat != ASN_OK) return stat;

   /* encode centralizedVideo */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->centralizedVideo);
   if (stat != ASN_OK) return stat;

   /* encode distributedVideo */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->distributedVideo);
   if (stat != ASN_OK) return stat;

   /* encode centralizedData */

   if (pvalue->m.centralizedDataPresent) {
      stat = asn1PE_H245_SeqOfH245DataApplicationCapability (pctxt, &pvalue->centralizedData);
      if (stat != ASN_OK) return stat;
   }

   /* encode distributedData */

   if (pvalue->m.distributedDataPresent) {
      stat = asn1PE_H245_SeqOfH245DataApplicationCapability (pctxt, &pvalue->distributedData);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245MediaDistributionCapability                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245MediaDistributionCapability (OOCTXT* pctxt, H245_SeqOfH245MediaDistributionCapability* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245MediaDistributionCapability (pctxt, ((H245MediaDistributionCapability*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultipointCapability                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultipointCapability (OOCTXT* pctxt, H245MultipointCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode multicastCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->multicastCapability);
   if (stat != ASN_OK) return stat;

   /* encode multiUniCastConference */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->multiUniCastConference);
   if (stat != ASN_OK) return stat;

   /* encode mediaDistributionCapability */

   stat = asn1PE_H245_SeqOfH245MediaDistributionCapability (pctxt, &pvalue->mediaDistributionCapability);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250Capability_mcCapability                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H2250Capability_mcCapability (OOCTXT* pctxt, H245H2250Capability_mcCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode centralizedConferenceMC */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->centralizedConferenceMC);
   if (stat != ASN_OK) return stat;

   /* encode decentralizedConferenceMC */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->decentralizedConferenceMC);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPPayloadType_payloadDescriptor                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RTPPayloadType_payloadDescriptor (OOCTXT* pctxt, H245RTPPayloadType_payloadDescriptor* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandardIdentifier */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandardIdentifier);
            if (stat != ASN_OK) return stat;
            break;

         /* rfc_number */
         case 2:
            if ( (pvalue->u.rfc_number >= 1 && pvalue->u.rfc_number <= 32768) ) {
               extbit = 0;
            }
            else extbit = 1;

            /* extension bit */

            encodeBit (pctxt, extbit);

            if (extbit) {
               stat = encodeUnconsInteger (pctxt, pvalue->u.rfc_number);
               if (stat != ASN_OK) return stat;
            }
            else {
               stat = encodeConsInteger (pctxt, pvalue->u.rfc_number, 1, 32768);
               if (stat != ASN_OK) return stat;
            }
            break;

         /* oid */
         case 3:
            stat = encodeObjectIdentifier (pctxt, pvalue->u.oid);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPPayloadType                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RTPPayloadType (OOCTXT* pctxt, H245RTPPayloadType* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.payloadTypePresent);

   /* encode payloadDescriptor */

   stat = asn1PE_H245RTPPayloadType_payloadDescriptor (pctxt, &pvalue->payloadDescriptor);
   if (stat != ASN_OK) return stat;

   /* encode payloadType */

   if (pvalue->m.payloadTypePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->payloadType, 0U, 127U);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaPacketizationCapability_rtpPayloadType               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MediaPacketizationCapability_rtpPayloadType (OOCTXT* pctxt, H245MediaPacketizationCapability_rtpPayloadType* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245RTPPayloadType (pctxt, ((H245RTPPayloadType*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaPacketizationCapability                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MediaPacketizationCapability (OOCTXT* pctxt, H245MediaPacketizationCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.rtpPayloadTypePresent);

   encodeBit (pctxt, extbit);

   /* encode h261aVideoPacketization */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->h261aVideoPacketization);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.rtpPayloadTypePresent);
      /* encode extension elements */

      if (pvalue->m.rtpPayloadTypePresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245MediaPacketizationCapability_rtpPayloadType (&lctxt, &pvalue->rtpPayloadType);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  QOSMode                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245QOSMode (OOCTXT* pctxt, H245QOSMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* guaranteedQOS */
         case 1:
            /* NULL */
            break;

         /* controlledLoad */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RSVPParameters                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RSVPParameters (OOCTXT* pctxt, H245RSVPParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.qosModePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.tokenRatePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.bucketSizePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.peakRatePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.minPolicedPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.maxPktSizePresent);

   /* encode qosMode */

   if (pvalue->m.qosModePresent) {
      stat = asn1PE_H245QOSMode (pctxt, &pvalue->qosMode);
      if (stat != ASN_OK) return stat;
   }

   /* encode tokenRate */

   if (pvalue->m.tokenRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->tokenRate, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   /* encode bucketSize */

   if (pvalue->m.bucketSizePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->bucketSize, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   /* encode peakRate */

   if (pvalue->m.peakRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->peakRate, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   /* encode minPoliced */

   if (pvalue->m.minPolicedPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->minPoliced, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   /* encode maxPktSize */

   if (pvalue->m.maxPktSizePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->maxPktSize, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ATMParameters                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ATMParameters (OOCTXT* pctxt, H245ATMParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode maxNTUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->maxNTUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode atmUBR */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->atmUBR);
   if (stat != ASN_OK) return stat;

   /* encode atmrtVBR */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->atmrtVBR);
   if (stat != ASN_OK) return stat;

   /* encode atmnrtVBR */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->atmnrtVBR);
   if (stat != ASN_OK) return stat;

   /* encode atmABR */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->atmABR);
   if (stat != ASN_OK) return stat;

   /* encode atmCBR */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->atmCBR);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  QOSCapability                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245QOSCapability (OOCTXT* pctxt, H245QOSCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.nonStandardDataPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.rsvpParametersPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.atmParametersPresent);

   /* encode nonStandardData */

   if (pvalue->m.nonStandardDataPresent) {
      stat = asn1PE_H245NonStandardParameter (pctxt, &pvalue->nonStandardData);
      if (stat != ASN_OK) return stat;
   }

   /* encode rsvpParameters */

   if (pvalue->m.rsvpParametersPresent) {
      stat = asn1PE_H245RSVPParameters (pctxt, &pvalue->rsvpParameters);
      if (stat != ASN_OK) return stat;
   }

   /* encode atmParameters */

   if (pvalue->m.atmParametersPresent) {
      stat = asn1PE_H245ATMParameters (pctxt, &pvalue->atmParameters);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransportCapability_qOSCapabilities                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TransportCapability_qOSCapabilities (OOCTXT* pctxt, H245TransportCapability_qOSCapabilities* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245QOSCapability (pctxt, ((H245QOSCapability*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaTransportType_atm_AAL5_compressed                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MediaTransportType_atm_AAL5_compressed (OOCTXT* pctxt, H245MediaTransportType_atm_AAL5_compressed* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode variable_delta */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->variable_delta);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaTransportType                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MediaTransportType (OOCTXT* pctxt, H245MediaTransportType* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* ip_UDP */
         case 1:
            /* NULL */
            break;

         /* ip_TCP */
         case 2:
            /* NULL */
            break;

         /* atm_AAL5_UNIDIR */
         case 3:
            /* NULL */
            break;

         /* atm_AAL5_BIDIR */
         case 4:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* atm_AAL5_compressed */
         case 5:
            stat = asn1PE_H245MediaTransportType_atm_AAL5_compressed (&lctxt, pvalue->u.atm_AAL5_compressed);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaChannelCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MediaChannelCapability (OOCTXT* pctxt, H245MediaChannelCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaTransportPresent);

   /* encode mediaTransport */

   if (pvalue->m.mediaTransportPresent) {
      stat = asn1PE_H245MediaTransportType (pctxt, &pvalue->mediaTransport);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransportCapability_mediaChannelCapabilities              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TransportCapability_mediaChannelCapabilities (OOCTXT* pctxt, H245TransportCapability_mediaChannelCapabilities* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245MediaChannelCapability (pctxt, ((H245MediaChannelCapability*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransportCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TransportCapability (OOCTXT* pctxt, H245TransportCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.nonStandardPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.qOSCapabilitiesPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaChannelCapabilitiesPresent);

   /* encode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      stat = asn1PE_H245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;
   }

   /* encode qOSCapabilities */

   if (pvalue->m.qOSCapabilitiesPresent) {
      stat = asn1PE_H245TransportCapability_qOSCapabilities (pctxt, &pvalue->qOSCapabilities);
      if (stat != ASN_OK) return stat;
   }

   /* encode mediaChannelCapabilities */

   if (pvalue->m.mediaChannelCapabilitiesPresent) {
      stat = asn1PE_H245TransportCapability_mediaChannelCapabilities (pctxt, &pvalue->mediaChannelCapabilities);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyFrameMapping_frameSequence          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RTPH263VideoRedundancyFrameMapping_frameSequence (OOCTXT* pctxt, H245RTPH263VideoRedundancyFrameMapping_frameSequence* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = encodeConsUnsigned (pctxt, pvalue->elem[xx1], 0U, 255U);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyFrameMapping                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RTPH263VideoRedundancyFrameMapping (OOCTXT* pctxt, H245RTPH263VideoRedundancyFrameMapping* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode threadNumber */

   stat = encodeConsUnsigned (pctxt, pvalue->threadNumber, 0U, 15U);
   if (stat != ASN_OK) return stat;

   /* encode frameSequence */

   stat = asn1PE_H245RTPH263VideoRedundancyFrameMapping_frameSequence (pctxt, &pvalue->frameSequence);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyEncoding_frameToThreadMapping_cust  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom (OOCTXT* pctxt, H245RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245RTPH263VideoRedundancyFrameMapping (pctxt, ((H245RTPH263VideoRedundancyFrameMapping*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyEncoding_frameToThreadMapping       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RTPH263VideoRedundancyEncoding_frameToThreadMapping (OOCTXT* pctxt, H245RTPH263VideoRedundancyEncoding_frameToThreadMapping* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* roundrobin */
         case 1:
            /* NULL */
            break;

         /* custom */
         case 2:
            stat = asn1PE_H245RTPH263VideoRedundancyEncoding_frameToThreadMapping_custom (pctxt, pvalue->u.custom);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyEncoding_containedThreads           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RTPH263VideoRedundancyEncoding_containedThreads (OOCTXT* pctxt, H245RTPH263VideoRedundancyEncoding_containedThreads* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = encodeConsUnsigned (pctxt, pvalue->elem[xx1], 0U, 15U);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RTPH263VideoRedundancyEncoding                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RTPH263VideoRedundancyEncoding (OOCTXT* pctxt, H245RTPH263VideoRedundancyEncoding* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.containedThreadsPresent);

   /* encode numberOfThreads */

   stat = encodeConsUnsigned (pctxt, pvalue->numberOfThreads, 1U, 16U);
   if (stat != ASN_OK) return stat;

   /* encode framesBetweenSyncPoints */

   stat = encodeConsUnsigned (pctxt, pvalue->framesBetweenSyncPoints, 1U, 256U);
   if (stat != ASN_OK) return stat;

   /* encode frameToThreadMapping */

   stat = asn1PE_H245RTPH263VideoRedundancyEncoding_frameToThreadMapping (pctxt, &pvalue->frameToThreadMapping);
   if (stat != ASN_OK) return stat;

   /* encode containedThreads */

   if (pvalue->m.containedThreadsPresent) {
      stat = asn1PE_H245RTPH263VideoRedundancyEncoding_containedThreads (pctxt, &pvalue->containedThreads);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingMethod                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RedundancyEncodingMethod (OOCTXT* pctxt, H245RedundancyEncodingMethod* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* rtpAudioRedundancyEncoding */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* rtpH263VideoRedundancyEncoding */
         case 3:
            stat = asn1PE_H245RTPH263VideoRedundancyEncoding (&lctxt, pvalue->u.rtpH263VideoRedundancyEncoding);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityTableEntryNumber                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CapabilityTableEntryNumber (OOCTXT* pctxt, H245CapabilityTableEntryNumber value)
{
   int stat = ASN_OK;

   stat = encodeConsUnsigned (pctxt, value, 1U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingCapability_secondaryEncoding            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RedundancyEncodingCapability_secondaryEncoding (OOCTXT* pctxt, H245RedundancyEncodingCapability_secondaryEncoding* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = asn1PE_H245CapabilityTableEntryNumber (pctxt, pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingCapability                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RedundancyEncodingCapability (OOCTXT* pctxt, H245RedundancyEncodingCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.secondaryEncodingPresent);

   /* encode redundancyEncodingMethod */

   stat = asn1PE_H245RedundancyEncodingMethod (pctxt, &pvalue->redundancyEncodingMethod);
   if (stat != ASN_OK) return stat;

   /* encode primaryEncoding */

   stat = asn1PE_H245CapabilityTableEntryNumber (pctxt, pvalue->primaryEncoding);
   if (stat != ASN_OK) return stat;

   /* encode secondaryEncoding */

   if (pvalue->m.secondaryEncodingPresent) {
      stat = asn1PE_H245RedundancyEncodingCapability_secondaryEncoding (pctxt, &pvalue->secondaryEncoding);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250Capability_redundancyEncodingCapability              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H2250Capability_redundancyEncodingCapability (OOCTXT* pctxt, H245H2250Capability_redundancyEncodingCapability* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245RedundancyEncodingCapability (pctxt, ((H245RedundancyEncodingCapability*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250Capability                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H2250Capability (OOCTXT* pctxt, H245H2250Capability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.transportCapabilityPresent ||
   pvalue->m.redundancyEncodingCapabilityPresent ||
   pvalue->m.logicalChannelSwitchingCapabilityPresent ||
   pvalue->m.t120DynamicPortCapabilityPresent);

   encodeBit (pctxt, extbit);

   /* encode maximumAudioDelayJitter */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumAudioDelayJitter, 0U, 1023U);
   if (stat != ASN_OK) return stat;

   /* encode receiveMultipointCapability */

   stat = asn1PE_H245MultipointCapability (pctxt, &pvalue->receiveMultipointCapability);
   if (stat != ASN_OK) return stat;

   /* encode transmitMultipointCapability */

   stat = asn1PE_H245MultipointCapability (pctxt, &pvalue->transmitMultipointCapability);
   if (stat != ASN_OK) return stat;

   /* encode receiveAndTransmitMultipointCapability */

   stat = asn1PE_H245MultipointCapability (pctxt, &pvalue->receiveAndTransmitMultipointCapability);
   if (stat != ASN_OK) return stat;

   /* encode mcCapability */

   stat = asn1PE_H245H2250Capability_mcCapability (pctxt, &pvalue->mcCapability);
   if (stat != ASN_OK) return stat;

   /* encode rtcpVideoControlCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->rtcpVideoControlCapability);
   if (stat != ASN_OK) return stat;

   /* encode mediaPacketizationCapability */

   stat = asn1PE_H245MediaPacketizationCapability (pctxt, &pvalue->mediaPacketizationCapability);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 3);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.transportCapabilityPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.redundancyEncodingCapabilityPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.logicalChannelSwitchingCapabilityPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.t120DynamicPortCapabilityPresent);
      /* encode extension elements */

      if (pvalue->m.transportCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245TransportCapability (&lctxt, &pvalue->transportCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.redundancyEncodingCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245H2250Capability_redundancyEncodingCapability (&lctxt, &pvalue->redundancyEncodingCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.logicalChannelSwitchingCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->logicalChannelSwitchingCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.t120DynamicPortCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->t120DynamicPortCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexCapability (OOCTXT* pctxt, H245MultiplexCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* h222Capability */
         case 2:
            stat = asn1PE_H245H222Capability (pctxt, pvalue->u.h222Capability);
            if (stat != ASN_OK) return stat;
            break;

         /* h223Capability */
         case 3:
            stat = asn1PE_H245H223Capability (pctxt, pvalue->u.h223Capability);
            if (stat != ASN_OK) return stat;
            break;

         /* v76Capability */
         case 4:
            stat = asn1PE_H245V76Capability (pctxt, pvalue->u.v76Capability);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* h2250Capability */
         case 5:
            stat = asn1PE_H245H2250Capability (&lctxt, pvalue->u.h2250Capability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* genericMultiplexCapability */
         case 6:
            stat = asn1PE_H245GenericCapability (&lctxt, pvalue->u.genericMultiplexCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H261VideoCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H261VideoCapability (OOCTXT* pctxt, H245H261VideoCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.videoBadMBsCapPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.qcifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cifMPIPresent);

   /* encode qcifMPI */

   if (pvalue->m.qcifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->qcifMPI, 1U, 4U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cifMPI */

   if (pvalue->m.cifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cifMPI, 1U, 4U);
      if (stat != ASN_OK) return stat;

   }

   /* encode temporalSpatialTradeOffCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->temporalSpatialTradeOffCapability);
   if (stat != ASN_OK) return stat;

   /* encode maxBitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->maxBitRate, 1U, 19200U);
   if (stat != ASN_OK) return stat;

   /* encode stillImageTransmission */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->stillImageTransmission);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.videoBadMBsCapPresent);
      /* encode extension elements */

      if (pvalue->m.videoBadMBsCapPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->videoBadMBsCap);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H262VideoCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H262VideoCapability (OOCTXT* pctxt, H245H262VideoCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.videoBadMBsCapPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.videoBitRatePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.vbvBufferSizePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.samplesPerLinePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.linesPerFramePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.framesPerSecondPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.luminanceSampleRatePresent);

   /* encode profileAndLevel_SPatML */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->profileAndLevel_SPatML);
   if (stat != ASN_OK) return stat;

   /* encode profileAndLevel_MPatLL */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->profileAndLevel_MPatLL);
   if (stat != ASN_OK) return stat;

   /* encode profileAndLevel_MPatML */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->profileAndLevel_MPatML);
   if (stat != ASN_OK) return stat;

   /* encode profileAndLevel_MPatH_14 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->profileAndLevel_MPatH_14);
   if (stat != ASN_OK) return stat;

   /* encode profileAndLevel_MPatHL */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->profileAndLevel_MPatHL);
   if (stat != ASN_OK) return stat;

   /* encode profileAndLevel_SNRatLL */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->profileAndLevel_SNRatLL);
   if (stat != ASN_OK) return stat;

   /* encode profileAndLevel_SNRatML */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->profileAndLevel_SNRatML);
   if (stat != ASN_OK) return stat;

   /* encode profileAndLevel_SpatialatH_14 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->profileAndLevel_SpatialatH_14);
   if (stat != ASN_OK) return stat;

   /* encode profileAndLevel_HPatML */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->profileAndLevel_HPatML);
   if (stat != ASN_OK) return stat;

   /* encode profileAndLevel_HPatH_14 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->profileAndLevel_HPatH_14);
   if (stat != ASN_OK) return stat;

   /* encode profileAndLevel_HPatHL */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->profileAndLevel_HPatHL);
   if (stat != ASN_OK) return stat;

   /* encode videoBitRate */

   if (pvalue->m.videoBitRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->videoBitRate, 0U, 1073741823U);
      if (stat != ASN_OK) return stat;

   }

   /* encode vbvBufferSize */

   if (pvalue->m.vbvBufferSizePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->vbvBufferSize, 0U, 262143U);
      if (stat != ASN_OK) return stat;

   }

   /* encode samplesPerLine */

   if (pvalue->m.samplesPerLinePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->samplesPerLine, 0U, 16383U);
      if (stat != ASN_OK) return stat;

   }

   /* encode linesPerFrame */

   if (pvalue->m.linesPerFramePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->linesPerFrame, 0U, 16383U);
      if (stat != ASN_OK) return stat;

   }

   /* encode framesPerSecond */

   if (pvalue->m.framesPerSecondPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->framesPerSecond, 0U, 15U);
      if (stat != ASN_OK) return stat;

   }

   /* encode luminanceSampleRate */

   if (pvalue->m.luminanceSampleRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->luminanceSampleRate, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.videoBadMBsCapPresent);
      /* encode extension elements */

      if (pvalue->m.videoBadMBsCapPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->videoBadMBsCap);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransparencyParameters                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TransparencyParameters (OOCTXT* pctxt, H245TransparencyParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode presentationOrder */

   stat = encodeConsUnsigned (pctxt, pvalue->presentationOrder, 1U, 256U);
   if (stat != ASN_OK) return stat;

   /* encode offset_x */

   stat = encodeConsInteger (pctxt, pvalue->offset_x, -262144, 262143);
   if (stat != ASN_OK) return stat;

   /* encode offset_y */

   stat = encodeConsInteger (pctxt, pvalue->offset_y, -262144, 262143);
   if (stat != ASN_OK) return stat;

   /* encode scale_x */

   stat = encodeConsUnsigned (pctxt, pvalue->scale_x, 1U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode scale_y */

   stat = encodeConsUnsigned (pctxt, pvalue->scale_y, 1U, 255U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefPictureSelection_additionalPictureMemory               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RefPictureSelection_additionalPictureMemory (OOCTXT* pctxt, H245RefPictureSelection_additionalPictureMemory* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.sqcifAdditionalPictureMemoryPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.qcifAdditionalPictureMemoryPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cifAdditionalPictureMemoryPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cif4AdditionalPictureMemoryPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cif16AdditionalPictureMemoryPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.bigCpfAdditionalPictureMemoryPresent);

   /* encode sqcifAdditionalPictureMemory */

   if (pvalue->m.sqcifAdditionalPictureMemoryPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->sqcifAdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;

   }

   /* encode qcifAdditionalPictureMemory */

   if (pvalue->m.qcifAdditionalPictureMemoryPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->qcifAdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cifAdditionalPictureMemory */

   if (pvalue->m.cifAdditionalPictureMemoryPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cifAdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cif4AdditionalPictureMemory */

   if (pvalue->m.cif4AdditionalPictureMemoryPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cif4AdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cif16AdditionalPictureMemory */

   if (pvalue->m.cif16AdditionalPictureMemoryPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cif16AdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;

   }

   /* encode bigCpfAdditionalPictureMemory */

   if (pvalue->m.bigCpfAdditionalPictureMemoryPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->bigCpfAdditionalPictureMemory, 1U, 256U);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefPictureSelection_videoBackChannelSend                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RefPictureSelection_videoBackChannelSend (OOCTXT* pctxt, H245RefPictureSelection_videoBackChannelSend* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 5);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 4);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* none */
         case 1:
            /* NULL */
            break;

         /* ackMessageOnly */
         case 2:
            /* NULL */
            break;

         /* nackMessageOnly */
         case 3:
            /* NULL */
            break;

         /* ackOrNackMessageOnly */
         case 4:
            /* NULL */
            break;

         /* ackAndNackMessage */
         case 5:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 6);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefPictureSelection_enhancedReferencePicSelect_subPictur  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters (OOCTXT* pctxt, H245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode mpuHorizMBs */

   stat = encodeConsUnsigned (pctxt, pvalue->mpuHorizMBs, 1U, 128U);
   if (stat != ASN_OK) return stat;

   /* encode mpuVertMBs */

   stat = encodeConsUnsigned (pctxt, pvalue->mpuVertMBs, 1U, 72U);
   if (stat != ASN_OK) return stat;

   /* encode mpuTotalNumber */

   stat = encodeConsUnsigned (pctxt, pvalue->mpuTotalNumber, 1U, 65536U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefPictureSelection_enhancedReferencePicSelect            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RefPictureSelection_enhancedReferencePicSelect (OOCTXT* pctxt, H245RefPictureSelection_enhancedReferencePicSelect* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.subPictureRemovalParametersPresent);

   /* encode subPictureRemovalParameters */

   if (pvalue->m.subPictureRemovalParametersPresent) {
      stat = asn1PE_H245RefPictureSelection_enhancedReferencePicSelect_subPictureRemovalParameters (pctxt, &pvalue->subPictureRemovalParameters);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RefPictureSelection                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RefPictureSelection (OOCTXT* pctxt, H245RefPictureSelection* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.enhancedReferencePicSelectPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.additionalPictureMemoryPresent);

   /* encode additionalPictureMemory */

   if (pvalue->m.additionalPictureMemoryPresent) {
      stat = asn1PE_H245RefPictureSelection_additionalPictureMemory (pctxt, &pvalue->additionalPictureMemory);
      if (stat != ASN_OK) return stat;
   }

   /* encode videoMux */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->videoMux);
   if (stat != ASN_OK) return stat;

   /* encode videoBackChannelSend */

   stat = asn1PE_H245RefPictureSelection_videoBackChannelSend (pctxt, &pvalue->videoBackChannelSend);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.enhancedReferencePicSelectPresent);
      /* encode extension elements */

      if (pvalue->m.enhancedReferencePicSelectPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245RefPictureSelection_enhancedReferencePicSelect (&lctxt, &pvalue->enhancedReferencePicSelect);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureClockFrequency                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CustomPictureClockFrequency (OOCTXT* pctxt, H245CustomPictureClockFrequency* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.sqcifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.qcifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cif4MPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cif16MPIPresent);

   /* encode clockConversionCode */

   stat = encodeConsUnsigned (pctxt, pvalue->clockConversionCode, 1000U, 1001U);
   if (stat != ASN_OK) return stat;

   /* encode clockDivisor */

   stat = encodeConsUnsigned (pctxt, pvalue->clockDivisor, 1U, 127U);
   if (stat != ASN_OK) return stat;

   /* encode sqcifMPI */

   if (pvalue->m.sqcifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->sqcifMPI, 1U, 2048U);
      if (stat != ASN_OK) return stat;

   }

   /* encode qcifMPI */

   if (pvalue->m.qcifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->qcifMPI, 1U, 2048U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cifMPI */

   if (pvalue->m.cifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cifMPI, 1U, 2048U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cif4MPI */

   if (pvalue->m.cif4MPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cif4MPI, 1U, 2048U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cif16MPI */

   if (pvalue->m.cif16MPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cif16MPI, 1U, 2048U);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263Options_customPictureClockFrequency                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H263Options_customPictureClockFrequency (OOCTXT* pctxt, H245H263Options_customPictureClockFrequency* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245CustomPictureClockFrequency (pctxt, ((H245CustomPictureClockFrequency*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_mPI_customPCF_element                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CustomPictureFormat_mPI_customPCF_element (OOCTXT* pctxt, H245CustomPictureFormat_mPI_customPCF_element* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode clockConversionCode */

   stat = encodeConsUnsigned (pctxt, pvalue->clockConversionCode, 1000U, 1001U);
   if (stat != ASN_OK) return stat;

   /* encode clockDivisor */

   stat = encodeConsUnsigned (pctxt, pvalue->clockDivisor, 1U, 127U);
   if (stat != ASN_OK) return stat;

   /* encode customMPI */

   stat = encodeConsUnsigned (pctxt, pvalue->customMPI, 1U, 2048U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_mPI_customPCF                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CustomPictureFormat_mPI_customPCF (OOCTXT* pctxt, H245CustomPictureFormat_mPI_customPCF* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245CustomPictureFormat_mPI_customPCF_element (pctxt, ((H245CustomPictureFormat_mPI_customPCF_element*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_mPI                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CustomPictureFormat_mPI (OOCTXT* pctxt, H245CustomPictureFormat_mPI* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.standardMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.customPCFPresent);

   /* encode standardMPI */

   if (pvalue->m.standardMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->standardMPI, 1U, 31U);
      if (stat != ASN_OK) return stat;

   }

   /* encode customPCF */

   if (pvalue->m.customPCFPresent) {
      stat = asn1PE_H245CustomPictureFormat_mPI_customPCF (pctxt, &pvalue->customPCF);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_pixelAspectInformation_pixelAspectCo  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CustomPictureFormat_pixelAspectInformation_pixelAspectCode (OOCTXT* pctxt, H245CustomPictureFormat_pixelAspectInformation_pixelAspectCode* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 14, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = encodeConsUnsigned (pctxt, pvalue->elem[xx1], 1U, 14U);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_pixelAspectInformation_extendedPAR_e  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CustomPictureFormat_pixelAspectInformation_extendedPAR_element (OOCTXT* pctxt, H245CustomPictureFormat_pixelAspectInformation_extendedPAR_element* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode width */

   stat = encodeConsUnsigned (pctxt, pvalue->width, 1U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode height */

   stat = encodeConsUnsigned (pctxt, pvalue->height, 1U, 255U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_pixelAspectInformation_extendedPAR    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CustomPictureFormat_pixelAspectInformation_extendedPAR (OOCTXT* pctxt, H245CustomPictureFormat_pixelAspectInformation_extendedPAR* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245CustomPictureFormat_pixelAspectInformation_extendedPAR_element (pctxt, ((H245CustomPictureFormat_pixelAspectInformation_extendedPAR_element*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat_pixelAspectInformation                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CustomPictureFormat_pixelAspectInformation (OOCTXT* pctxt, H245CustomPictureFormat_pixelAspectInformation* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* anyPixelAspectRatio */
         case 1:
            stat = encodeBit (pctxt, (ASN1BOOL)pvalue->u.anyPixelAspectRatio);
            if (stat != ASN_OK) return stat;
            break;

         /* pixelAspectCode */
         case 2:
            stat = asn1PE_H245CustomPictureFormat_pixelAspectInformation_pixelAspectCode (pctxt, pvalue->u.pixelAspectCode);
            if (stat != ASN_OK) return stat;
            break;

         /* extendedPAR */
         case 3:
            stat = asn1PE_H245CustomPictureFormat_pixelAspectInformation_extendedPAR (pctxt, pvalue->u.extendedPAR);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CustomPictureFormat                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CustomPictureFormat (OOCTXT* pctxt, H245CustomPictureFormat* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode maxCustomPictureWidth */

   stat = encodeConsUnsigned (pctxt, pvalue->maxCustomPictureWidth, 1U, 2048U);
   if (stat != ASN_OK) return stat;

   /* encode maxCustomPictureHeight */

   stat = encodeConsUnsigned (pctxt, pvalue->maxCustomPictureHeight, 1U, 2048U);
   if (stat != ASN_OK) return stat;

   /* encode minCustomPictureWidth */

   stat = encodeConsUnsigned (pctxt, pvalue->minCustomPictureWidth, 1U, 2048U);
   if (stat != ASN_OK) return stat;

   /* encode minCustomPictureHeight */

   stat = encodeConsUnsigned (pctxt, pvalue->minCustomPictureHeight, 1U, 2048U);
   if (stat != ASN_OK) return stat;

   /* encode mPI */

   stat = asn1PE_H245CustomPictureFormat_mPI (pctxt, &pvalue->mPI);
   if (stat != ASN_OK) return stat;

   /* encode pixelAspectInformation */

   stat = asn1PE_H245CustomPictureFormat_pixelAspectInformation (pctxt, &pvalue->pixelAspectInformation);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263Options_customPictureFormat                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H263Options_customPictureFormat (OOCTXT* pctxt, H245H263Options_customPictureFormat* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245CustomPictureFormat (pctxt, ((H245CustomPictureFormat*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263Version3Options                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H263Version3Options (OOCTXT* pctxt, H245H263Version3Options* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode dataPartitionedSlices */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dataPartitionedSlices);
   if (stat != ASN_OK) return stat;

   /* encode fixedPointIDCT0 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->fixedPointIDCT0);
   if (stat != ASN_OK) return stat;

   /* encode interlacedFields */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->interlacedFields);
   if (stat != ASN_OK) return stat;

   /* encode currentPictureHeaderRepetition */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->currentPictureHeaderRepetition);
   if (stat != ASN_OK) return stat;

   /* encode previousPictureHeaderRepetition */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->previousPictureHeaderRepetition);
   if (stat != ASN_OK) return stat;

   /* encode nextPictureHeaderRepetition */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->nextPictureHeaderRepetition);
   if (stat != ASN_OK) return stat;

   /* encode pictureNumber */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->pictureNumber);
   if (stat != ASN_OK) return stat;

   /* encode spareReferencePictures */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->spareReferencePictures);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263ModeComboFlags                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H263ModeComboFlags (OOCTXT* pctxt, H245H263ModeComboFlags* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.enhancedReferencePicSelectPresent ||
   pvalue->m.h263Version3OptionsPresent);

   encodeBit (pctxt, extbit);

   /* encode unrestrictedVector */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->unrestrictedVector);
   if (stat != ASN_OK) return stat;

   /* encode arithmeticCoding */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->arithmeticCoding);
   if (stat != ASN_OK) return stat;

   /* encode advancedPrediction */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->advancedPrediction);
   if (stat != ASN_OK) return stat;

   /* encode pbFrames */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->pbFrames);
   if (stat != ASN_OK) return stat;

   /* encode advancedIntraCodingMode */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->advancedIntraCodingMode);
   if (stat != ASN_OK) return stat;

   /* encode deblockingFilterMode */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->deblockingFilterMode);
   if (stat != ASN_OK) return stat;

   /* encode unlimitedMotionVectors */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->unlimitedMotionVectors);
   if (stat != ASN_OK) return stat;

   /* encode slicesInOrder_NonRect */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->slicesInOrder_NonRect);
   if (stat != ASN_OK) return stat;

   /* encode slicesInOrder_Rect */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->slicesInOrder_Rect);
   if (stat != ASN_OK) return stat;

   /* encode slicesNoOrder_NonRect */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->slicesNoOrder_NonRect);
   if (stat != ASN_OK) return stat;

   /* encode slicesNoOrder_Rect */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->slicesNoOrder_Rect);
   if (stat != ASN_OK) return stat;

   /* encode improvedPBFramesMode */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->improvedPBFramesMode);
   if (stat != ASN_OK) return stat;

   /* encode referencePicSelect */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->referencePicSelect);
   if (stat != ASN_OK) return stat;

   /* encode dynamicPictureResizingByFour */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dynamicPictureResizingByFour);
   if (stat != ASN_OK) return stat;

   /* encode dynamicPictureResizingSixteenthPel */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dynamicPictureResizingSixteenthPel);
   if (stat != ASN_OK) return stat;

   /* encode dynamicWarpingHalfPel */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dynamicWarpingHalfPel);
   if (stat != ASN_OK) return stat;

   /* encode dynamicWarpingSixteenthPel */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dynamicWarpingSixteenthPel);
   if (stat != ASN_OK) return stat;

   /* encode reducedResolutionUpdate */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->reducedResolutionUpdate);
   if (stat != ASN_OK) return stat;

   /* encode independentSegmentDecoding */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->independentSegmentDecoding);
   if (stat != ASN_OK) return stat;

   /* encode alternateInterVLCMode */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->alternateInterVLCMode);
   if (stat != ASN_OK) return stat;

   /* encode modifiedQuantizationMode */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->modifiedQuantizationMode);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 1);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.enhancedReferencePicSelectPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.h263Version3OptionsPresent);
      /* encode extension elements */

      if (pvalue->m.enhancedReferencePicSelectPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->enhancedReferencePicSelect);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.h263Version3OptionsPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245H263Version3Options (&lctxt, &pvalue->h263Version3Options);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263VideoModeCombos_h263VideoCoupledModes                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H263VideoModeCombos_h263VideoCoupledModes (OOCTXT* pctxt, H245H263VideoModeCombos_h263VideoCoupledModes* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245H263ModeComboFlags (pctxt, ((H245H263ModeComboFlags*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263VideoModeCombos                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H263VideoModeCombos (OOCTXT* pctxt, H245H263VideoModeCombos* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode h263VideoUncoupledModes */

   stat = asn1PE_H245H263ModeComboFlags (pctxt, &pvalue->h263VideoUncoupledModes);
   if (stat != ASN_OK) return stat;

   /* encode h263VideoCoupledModes */

   stat = asn1PE_H245H263VideoModeCombos_h263VideoCoupledModes (pctxt, &pvalue->h263VideoCoupledModes);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263Options_modeCombos                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H263Options_modeCombos (OOCTXT* pctxt, H245H263Options_modeCombos* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245H263VideoModeCombos (pctxt, ((H245H263VideoModeCombos*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263Options                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H263Options (OOCTXT* pctxt, H245H263Options* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.videoBadMBsCapPresent ||
   pvalue->m.h263Version3OptionsPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.transparencyParametersPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.refPictureSelectionPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.customPictureClockFrequencyPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.customPictureFormatPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.modeCombosPresent);

   /* encode advancedIntraCodingMode */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->advancedIntraCodingMode);
   if (stat != ASN_OK) return stat;

   /* encode deblockingFilterMode */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->deblockingFilterMode);
   if (stat != ASN_OK) return stat;

   /* encode improvedPBFramesMode */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->improvedPBFramesMode);
   if (stat != ASN_OK) return stat;

   /* encode unlimitedMotionVectors */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->unlimitedMotionVectors);
   if (stat != ASN_OK) return stat;

   /* encode fullPictureFreeze */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->fullPictureFreeze);
   if (stat != ASN_OK) return stat;

   /* encode partialPictureFreezeAndRelease */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->partialPictureFreezeAndRelease);
   if (stat != ASN_OK) return stat;

   /* encode resizingPartPicFreezeAndRelease */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->resizingPartPicFreezeAndRelease);
   if (stat != ASN_OK) return stat;

   /* encode fullPictureSnapshot */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->fullPictureSnapshot);
   if (stat != ASN_OK) return stat;

   /* encode partialPictureSnapshot */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->partialPictureSnapshot);
   if (stat != ASN_OK) return stat;

   /* encode videoSegmentTagging */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->videoSegmentTagging);
   if (stat != ASN_OK) return stat;

   /* encode progressiveRefinement */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->progressiveRefinement);
   if (stat != ASN_OK) return stat;

   /* encode dynamicPictureResizingByFour */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dynamicPictureResizingByFour);
   if (stat != ASN_OK) return stat;

   /* encode dynamicPictureResizingSixteenthPel */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dynamicPictureResizingSixteenthPel);
   if (stat != ASN_OK) return stat;

   /* encode dynamicWarpingHalfPel */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dynamicWarpingHalfPel);
   if (stat != ASN_OK) return stat;

   /* encode dynamicWarpingSixteenthPel */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->dynamicWarpingSixteenthPel);
   if (stat != ASN_OK) return stat;

   /* encode independentSegmentDecoding */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->independentSegmentDecoding);
   if (stat != ASN_OK) return stat;

   /* encode slicesInOrder_NonRect */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->slicesInOrder_NonRect);
   if (stat != ASN_OK) return stat;

   /* encode slicesInOrder_Rect */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->slicesInOrder_Rect);
   if (stat != ASN_OK) return stat;

   /* encode slicesNoOrder_NonRect */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->slicesNoOrder_NonRect);
   if (stat != ASN_OK) return stat;

   /* encode slicesNoOrder_Rect */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->slicesNoOrder_Rect);
   if (stat != ASN_OK) return stat;

   /* encode alternateInterVLCMode */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->alternateInterVLCMode);
   if (stat != ASN_OK) return stat;

   /* encode modifiedQuantizationMode */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->modifiedQuantizationMode);
   if (stat != ASN_OK) return stat;

   /* encode reducedResolutionUpdate */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->reducedResolutionUpdate);
   if (stat != ASN_OK) return stat;

   /* encode transparencyParameters */

   if (pvalue->m.transparencyParametersPresent) {
      stat = asn1PE_H245TransparencyParameters (pctxt, &pvalue->transparencyParameters);
      if (stat != ASN_OK) return stat;
   }

   /* encode separateVideoBackChannel */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->separateVideoBackChannel);
   if (stat != ASN_OK) return stat;

   /* encode refPictureSelection */

   if (pvalue->m.refPictureSelectionPresent) {
      stat = asn1PE_H245RefPictureSelection (pctxt, &pvalue->refPictureSelection);
      if (stat != ASN_OK) return stat;
   }

   /* encode customPictureClockFrequency */

   if (pvalue->m.customPictureClockFrequencyPresent) {
      stat = asn1PE_H245H263Options_customPictureClockFrequency (pctxt, &pvalue->customPictureClockFrequency);
      if (stat != ASN_OK) return stat;
   }

   /* encode customPictureFormat */

   if (pvalue->m.customPictureFormatPresent) {
      stat = asn1PE_H245H263Options_customPictureFormat (pctxt, &pvalue->customPictureFormat);
      if (stat != ASN_OK) return stat;
   }

   /* encode modeCombos */

   if (pvalue->m.modeCombosPresent) {
      stat = asn1PE_H245H263Options_modeCombos (pctxt, &pvalue->modeCombos);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 1);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.videoBadMBsCapPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.h263Version3OptionsPresent);
      /* encode extension elements */

      if (pvalue->m.videoBadMBsCapPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->videoBadMBsCap);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.h263Version3OptionsPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245H263Version3Options (&lctxt, &pvalue->h263Version3Options);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EnhancementOptions                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EnhancementOptions (OOCTXT* pctxt, H245EnhancementOptions* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.sqcifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.qcifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cif4MPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cif16MPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.slowSqcifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.slowQcifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.slowCifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.slowCif4MPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.slowCif16MPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.h263OptionsPresent);

   /* encode sqcifMPI */

   if (pvalue->m.sqcifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->sqcifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;

   }

   /* encode qcifMPI */

   if (pvalue->m.qcifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->qcifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cifMPI */

   if (pvalue->m.cifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cif4MPI */

   if (pvalue->m.cif4MPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cif4MPI, 1U, 32U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cif16MPI */

   if (pvalue->m.cif16MPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cif16MPI, 1U, 32U);
      if (stat != ASN_OK) return stat;

   }

   /* encode maxBitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->maxBitRate, 1U, 192400U);
   if (stat != ASN_OK) return stat;

   /* encode unrestrictedVector */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->unrestrictedVector);
   if (stat != ASN_OK) return stat;

   /* encode arithmeticCoding */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->arithmeticCoding);
   if (stat != ASN_OK) return stat;

   /* encode temporalSpatialTradeOffCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->temporalSpatialTradeOffCapability);
   if (stat != ASN_OK) return stat;

   /* encode slowSqcifMPI */

   if (pvalue->m.slowSqcifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->slowSqcifMPI, 1U, 3600U);
      if (stat != ASN_OK) return stat;

   }

   /* encode slowQcifMPI */

   if (pvalue->m.slowQcifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->slowQcifMPI, 1U, 3600U);
      if (stat != ASN_OK) return stat;

   }

   /* encode slowCifMPI */

   if (pvalue->m.slowCifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->slowCifMPI, 1U, 3600U);
      if (stat != ASN_OK) return stat;

   }

   /* encode slowCif4MPI */

   if (pvalue->m.slowCif4MPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->slowCif4MPI, 1U, 3600U);
      if (stat != ASN_OK) return stat;

   }

   /* encode slowCif16MPI */

   if (pvalue->m.slowCif16MPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->slowCif16MPI, 1U, 3600U);
      if (stat != ASN_OK) return stat;

   }

   /* encode errorCompensation */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->errorCompensation);
   if (stat != ASN_OK) return stat;

   /* encode h263Options */

   if (pvalue->m.h263OptionsPresent) {
      stat = asn1PE_H245H263Options (pctxt, &pvalue->h263Options);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EnhancementLayerInfo_snrEnhancement                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EnhancementLayerInfo_snrEnhancement (OOCTXT* pctxt, H245EnhancementLayerInfo_snrEnhancement* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 14, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245EnhancementOptions (pctxt, ((H245EnhancementOptions*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EnhancementLayerInfo_spatialEnhancement                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EnhancementLayerInfo_spatialEnhancement (OOCTXT* pctxt, H245EnhancementLayerInfo_spatialEnhancement* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 14, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245EnhancementOptions (pctxt, ((H245EnhancementOptions*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  BEnhancementParameters                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245BEnhancementParameters (OOCTXT* pctxt, H245BEnhancementParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode enhancementOptions */

   stat = asn1PE_H245EnhancementOptions (pctxt, &pvalue->enhancementOptions);
   if (stat != ASN_OK) return stat;

   /* encode numberOfBPictures */

   stat = encodeConsUnsigned (pctxt, pvalue->numberOfBPictures, 1U, 64U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EnhancementLayerInfo_bPictureEnhancement                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EnhancementLayerInfo_bPictureEnhancement (OOCTXT* pctxt, H245EnhancementLayerInfo_bPictureEnhancement* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 14, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245BEnhancementParameters (pctxt, ((H245BEnhancementParameters*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EnhancementLayerInfo                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EnhancementLayerInfo (OOCTXT* pctxt, H245EnhancementLayerInfo* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.snrEnhancementPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.spatialEnhancementPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.bPictureEnhancementPresent);

   /* encode baseBitRateConstrained */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->baseBitRateConstrained);
   if (stat != ASN_OK) return stat;

   /* encode snrEnhancement */

   if (pvalue->m.snrEnhancementPresent) {
      stat = asn1PE_H245EnhancementLayerInfo_snrEnhancement (pctxt, &pvalue->snrEnhancement);
      if (stat != ASN_OK) return stat;
   }

   /* encode spatialEnhancement */

   if (pvalue->m.spatialEnhancementPresent) {
      stat = asn1PE_H245EnhancementLayerInfo_spatialEnhancement (pctxt, &pvalue->spatialEnhancement);
      if (stat != ASN_OK) return stat;
   }

   /* encode bPictureEnhancement */

   if (pvalue->m.bPictureEnhancementPresent) {
      stat = asn1PE_H245EnhancementLayerInfo_bPictureEnhancement (pctxt, &pvalue->bPictureEnhancement);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263VideoCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H263VideoCapability (OOCTXT* pctxt, H245H263VideoCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.slowSqcifMPIPresent ||
   pvalue->m.slowQcifMPIPresent ||
   pvalue->m.slowCifMPIPresent ||
   pvalue->m.slowCif4MPIPresent ||
   pvalue->m.slowCif16MPIPresent ||
   pvalue->m.errorCompensationPresent ||
   pvalue->m.enhancementLayerInfoPresent ||
   pvalue->m.h263OptionsPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.sqcifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.qcifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cifMPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cif4MPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.cif16MPIPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.hrd_BPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.bppMaxKbPresent);

   /* encode sqcifMPI */

   if (pvalue->m.sqcifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->sqcifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;

   }

   /* encode qcifMPI */

   if (pvalue->m.qcifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->qcifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cifMPI */

   if (pvalue->m.cifMPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cifMPI, 1U, 32U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cif4MPI */

   if (pvalue->m.cif4MPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cif4MPI, 1U, 32U);
      if (stat != ASN_OK) return stat;

   }

   /* encode cif16MPI */

   if (pvalue->m.cif16MPIPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->cif16MPI, 1U, 32U);
      if (stat != ASN_OK) return stat;

   }

   /* encode maxBitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->maxBitRate, 1U, 192400U);
   if (stat != ASN_OK) return stat;

   /* encode unrestrictedVector */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->unrestrictedVector);
   if (stat != ASN_OK) return stat;

   /* encode arithmeticCoding */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->arithmeticCoding);
   if (stat != ASN_OK) return stat;

   /* encode advancedPrediction */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->advancedPrediction);
   if (stat != ASN_OK) return stat;

   /* encode pbFrames */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->pbFrames);
   if (stat != ASN_OK) return stat;

   /* encode temporalSpatialTradeOffCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->temporalSpatialTradeOffCapability);
   if (stat != ASN_OK) return stat;

   /* encode hrd_B */

   if (pvalue->m.hrd_BPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->hrd_B, 0U, 524287U);
      if (stat != ASN_OK) return stat;

   }

   /* encode bppMaxKb */

   if (pvalue->m.bppMaxKbPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->bppMaxKb, 0U, 65535U);
      if (stat != ASN_OK) return stat;

   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 7);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.slowSqcifMPIPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.slowQcifMPIPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.slowCifMPIPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.slowCif4MPIPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.slowCif16MPIPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.errorCompensationPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.enhancementLayerInfoPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.h263OptionsPresent);
      /* encode extension elements */

      if (pvalue->m.slowSqcifMPIPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeConsUnsigned (&lctxt, pvalue->slowSqcifMPI, 1U, 3600U);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.slowQcifMPIPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeConsUnsigned (&lctxt, pvalue->slowQcifMPI, 1U, 3600U);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.slowCifMPIPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeConsUnsigned (&lctxt, pvalue->slowCifMPI, 1U, 3600U);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.slowCif4MPIPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeConsUnsigned (&lctxt, pvalue->slowCif4MPI, 1U, 3600U);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.slowCif16MPIPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeConsUnsigned (&lctxt, pvalue->slowCif16MPI, 1U, 3600U);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.errorCompensationPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->errorCompensation);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.enhancementLayerInfoPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245EnhancementLayerInfo (&lctxt, &pvalue->enhancementLayerInfo);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.h263OptionsPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245H263Options (&lctxt, &pvalue->h263Options);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172VideoCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS11172VideoCapability (OOCTXT* pctxt, H245IS11172VideoCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.videoBadMBsCapPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.videoBitRatePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.vbvBufferSizePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.samplesPerLinePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.linesPerFramePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.pictureRatePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.luminanceSampleRatePresent);

   /* encode constrainedBitstream */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->constrainedBitstream);
   if (stat != ASN_OK) return stat;

   /* encode videoBitRate */

   if (pvalue->m.videoBitRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->videoBitRate, 0U, 1073741823U);
      if (stat != ASN_OK) return stat;

   }

   /* encode vbvBufferSize */

   if (pvalue->m.vbvBufferSizePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->vbvBufferSize, 0U, 262143U);
      if (stat != ASN_OK) return stat;

   }

   /* encode samplesPerLine */

   if (pvalue->m.samplesPerLinePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->samplesPerLine, 0U, 16383U);
      if (stat != ASN_OK) return stat;

   }

   /* encode linesPerFrame */

   if (pvalue->m.linesPerFramePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->linesPerFrame, 0U, 16383U);
      if (stat != ASN_OK) return stat;

   }

   /* encode pictureRate */

   if (pvalue->m.pictureRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->pictureRate, 0U, 15U);
      if (stat != ASN_OK) return stat;

   }

   /* encode luminanceSampleRate */

   if (pvalue->m.luminanceSampleRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->luminanceSampleRate, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.videoBadMBsCapPresent);
      /* encode extension elements */

      if (pvalue->m.videoBadMBsCapPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->videoBadMBsCap);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VideoCapability                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VideoCapability (OOCTXT* pctxt, H245VideoCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 5);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 4);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* h261VideoCapability */
         case 2:
            stat = asn1PE_H245H261VideoCapability (pctxt, pvalue->u.h261VideoCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* h262VideoCapability */
         case 3:
            stat = asn1PE_H245H262VideoCapability (pctxt, pvalue->u.h262VideoCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* h263VideoCapability */
         case 4:
            stat = asn1PE_H245H263VideoCapability (pctxt, pvalue->u.h263VideoCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* is11172VideoCapability */
         case 5:
            stat = asn1PE_H245IS11172VideoCapability (pctxt, pvalue->u.is11172VideoCapability);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 6);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* genericVideoCapability */
         case 6:
            stat = asn1PE_H245GenericCapability (&lctxt, pvalue->u.genericVideoCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioCapability_g7231                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245AudioCapability_g7231 (OOCTXT* pctxt, H245AudioCapability_g7231* pvalue)
{
   int stat = ASN_OK;

   /* encode maxAl_sduAudioFrames */

   stat = encodeConsUnsigned (pctxt, pvalue->maxAl_sduAudioFrames, 1U, 256U);
   if (stat != ASN_OK) return stat;

   /* encode silenceSuppression */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->silenceSuppression);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172AudioCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS11172AudioCapability (OOCTXT* pctxt, H245IS11172AudioCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode audioLayer1 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioLayer1);
   if (stat != ASN_OK) return stat;

   /* encode audioLayer2 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioLayer2);
   if (stat != ASN_OK) return stat;

   /* encode audioLayer3 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioLayer3);
   if (stat != ASN_OK) return stat;

   /* encode audioSampling32k */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioSampling32k);
   if (stat != ASN_OK) return stat;

   /* encode audioSampling44k1 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioSampling44k1);
   if (stat != ASN_OK) return stat;

   /* encode audioSampling48k */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioSampling48k);
   if (stat != ASN_OK) return stat;

   /* encode singleChannel */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->singleChannel);
   if (stat != ASN_OK) return stat;

   /* encode twoChannels */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->twoChannels);
   if (stat != ASN_OK) return stat;

   /* encode bitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->bitRate, 1U, 448U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS13818AudioCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS13818AudioCapability (OOCTXT* pctxt, H245IS13818AudioCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode audioLayer1 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioLayer1);
   if (stat != ASN_OK) return stat;

   /* encode audioLayer2 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioLayer2);
   if (stat != ASN_OK) return stat;

   /* encode audioLayer3 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioLayer3);
   if (stat != ASN_OK) return stat;

   /* encode audioSampling16k */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioSampling16k);
   if (stat != ASN_OK) return stat;

   /* encode audioSampling22k05 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioSampling22k05);
   if (stat != ASN_OK) return stat;

   /* encode audioSampling24k */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioSampling24k);
   if (stat != ASN_OK) return stat;

   /* encode audioSampling32k */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioSampling32k);
   if (stat != ASN_OK) return stat;

   /* encode audioSampling44k1 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioSampling44k1);
   if (stat != ASN_OK) return stat;

   /* encode audioSampling48k */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioSampling48k);
   if (stat != ASN_OK) return stat;

   /* encode singleChannel */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->singleChannel);
   if (stat != ASN_OK) return stat;

   /* encode twoChannels */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->twoChannels);
   if (stat != ASN_OK) return stat;

   /* encode threeChannels2_1 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->threeChannels2_1);
   if (stat != ASN_OK) return stat;

   /* encode threeChannels3_0 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->threeChannels3_0);
   if (stat != ASN_OK) return stat;

   /* encode fourChannels2_0_2_0 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->fourChannels2_0_2_0);
   if (stat != ASN_OK) return stat;

   /* encode fourChannels2_2 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->fourChannels2_2);
   if (stat != ASN_OK) return stat;

   /* encode fourChannels3_1 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->fourChannels3_1);
   if (stat != ASN_OK) return stat;

   /* encode fiveChannels3_0_2_0 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->fiveChannels3_0_2_0);
   if (stat != ASN_OK) return stat;

   /* encode fiveChannels3_2 */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->fiveChannels3_2);
   if (stat != ASN_OK) return stat;

   /* encode lowFrequencyEnhancement */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->lowFrequencyEnhancement);
   if (stat != ASN_OK) return stat;

   /* encode multilingual */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->multilingual);
   if (stat != ASN_OK) return stat;

   /* encode bitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->bitRate, 1U, 1130U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  G7231AnnexCCapability_g723AnnexCAudioMode                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245G7231AnnexCCapability_g723AnnexCAudioMode (OOCTXT* pctxt, H245G7231AnnexCCapability_g723AnnexCAudioMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode highRateMode0 */

   stat = encodeConsUnsigned (pctxt, pvalue->highRateMode0, 27U, 78U);
   if (stat != ASN_OK) return stat;

   /* encode highRateMode1 */

   stat = encodeConsUnsigned (pctxt, pvalue->highRateMode1, 27U, 78U);
   if (stat != ASN_OK) return stat;

   /* encode lowRateMode0 */

   stat = encodeConsUnsigned (pctxt, pvalue->lowRateMode0, 23U, 66U);
   if (stat != ASN_OK) return stat;

   /* encode lowRateMode1 */

   stat = encodeConsUnsigned (pctxt, pvalue->lowRateMode1, 23U, 66U);
   if (stat != ASN_OK) return stat;

   /* encode sidMode0 */

   stat = encodeConsUnsigned (pctxt, pvalue->sidMode0, 6U, 17U);
   if (stat != ASN_OK) return stat;

   /* encode sidMode1 */

   stat = encodeConsUnsigned (pctxt, pvalue->sidMode1, 6U, 17U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  G7231AnnexCCapability                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245G7231AnnexCCapability (OOCTXT* pctxt, H245G7231AnnexCCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.g723AnnexCAudioModePresent);

   /* encode maxAl_sduAudioFrames */

   stat = encodeConsUnsigned (pctxt, pvalue->maxAl_sduAudioFrames, 1U, 256U);
   if (stat != ASN_OK) return stat;

   /* encode silenceSuppression */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->silenceSuppression);
   if (stat != ASN_OK) return stat;

   /* encode g723AnnexCAudioMode */

   if (pvalue->m.g723AnnexCAudioModePresent) {
      stat = asn1PE_H245G7231AnnexCCapability_g723AnnexCAudioMode (pctxt, &pvalue->g723AnnexCAudioMode);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GSMAudioCapability                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245GSMAudioCapability (OOCTXT* pctxt, H245GSMAudioCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode audioUnitSize */

   stat = encodeConsUnsigned (pctxt, pvalue->audioUnitSize, 1U, 256U);
   if (stat != ASN_OK) return stat;

   /* encode comfortNoise */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->comfortNoise);
   if (stat != ASN_OK) return stat;

   /* encode scrambled */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->scrambled);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  G729Extensions                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245G729Extensions (OOCTXT* pctxt, H245G729Extensions* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.audioUnitPresent);

   /* encode audioUnit */

   if (pvalue->m.audioUnitPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->audioUnit, 1U, 256U);
      if (stat != ASN_OK) return stat;

   }

   /* encode annexA */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->annexA);
   if (stat != ASN_OK) return stat;

   /* encode annexB */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->annexB);
   if (stat != ASN_OK) return stat;

   /* encode annexD */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->annexD);
   if (stat != ASN_OK) return stat;

   /* encode annexE */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->annexE);
   if (stat != ASN_OK) return stat;

   /* encode annexF */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->annexF);
   if (stat != ASN_OK) return stat;

   /* encode annexG */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->annexG);
   if (stat != ASN_OK) return stat;

   /* encode annexH */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->annexH);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VBDCapability                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VBDCapability (OOCTXT* pctxt, H245VBDCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode type */

   stat = asn1PE_H245AudioCapability (pctxt, (H245AudioCapability*)pvalue->type);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NoPTAudioTelephonyEventCapability                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NoPTAudioTelephonyEventCapability (OOCTXT* pctxt, H245NoPTAudioTelephonyEventCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode audioTelephoneEvent */

   stat = encodeVarWidthCharString (pctxt, pvalue->audioTelephoneEvent);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NoPTAudioToneCapability                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NoPTAudioToneCapability (OOCTXT* pctxt, H245NoPTAudioToneCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioCapability                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245AudioCapability (OOCTXT* pctxt, H245AudioCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 14);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 13);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* g711Alaw64k */
         case 2:
            stat = encodeConsUnsigned (pctxt, pvalue->u.g711Alaw64k, 1U, 256U);
            if (stat != ASN_OK) return stat;

            break;

         /* g711Alaw56k */
         case 3:
            stat = encodeConsUnsigned (pctxt, pvalue->u.g711Alaw56k, 1U, 256U);
            if (stat != ASN_OK) return stat;

            break;

         /* g711Ulaw64k */
         case 4:
            stat = encodeConsUnsigned (pctxt, pvalue->u.g711Ulaw64k, 1U, 256U);
            if (stat != ASN_OK) return stat;

            break;

         /* g711Ulaw56k */
         case 5:
            stat = encodeConsUnsigned (pctxt, pvalue->u.g711Ulaw56k, 1U, 256U);
            if (stat != ASN_OK) return stat;

            break;

         /* g722_64k */
         case 6:
            stat = encodeConsUnsigned (pctxt, pvalue->u.g722_64k, 1U, 256U);
            if (stat != ASN_OK) return stat;

            break;

         /* g722_56k */
         case 7:
            stat = encodeConsUnsigned (pctxt, pvalue->u.g722_56k, 1U, 256U);
            if (stat != ASN_OK) return stat;

            break;

         /* g722_48k */
         case 8:
            stat = encodeConsUnsigned (pctxt, pvalue->u.g722_48k, 1U, 256U);
            if (stat != ASN_OK) return stat;

            break;

         /* g7231 */
         case 9:
            stat = asn1PE_H245AudioCapability_g7231 (pctxt, pvalue->u.g7231);
            if (stat != ASN_OK) return stat;
            break;

         /* g728 */
         case 10:
            stat = encodeConsUnsigned (pctxt, pvalue->u.g728, 1U, 256U);
            if (stat != ASN_OK) return stat;

            break;

         /* g729 */
         case 11:
            stat = encodeConsUnsigned (pctxt, pvalue->u.g729, 1U, 256U);
            if (stat != ASN_OK) return stat;

            break;

         /* g729AnnexA */
         case 12:
            stat = encodeConsUnsigned (pctxt, pvalue->u.g729AnnexA, 1U, 256U);
            if (stat != ASN_OK) return stat;

            break;

         /* is11172AudioCapability */
         case 13:
            stat = asn1PE_H245IS11172AudioCapability (pctxt, pvalue->u.is11172AudioCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* is13818AudioCapability */
         case 14:
            stat = asn1PE_H245IS13818AudioCapability (pctxt, pvalue->u.is13818AudioCapability);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 15);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* g729wAnnexB */
         case 15:
            stat = encodeConsUnsigned (&lctxt, pvalue->u.g729wAnnexB, 1U, 256U);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;

            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* g729AnnexAwAnnexB */
         case 16:
            stat = encodeConsUnsigned (&lctxt, pvalue->u.g729AnnexAwAnnexB, 1U, 256U);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;

            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* g7231AnnexCCapability */
         case 17:
            stat = asn1PE_H245G7231AnnexCCapability (&lctxt, pvalue->u.g7231AnnexCCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* gsmFullRate */
         case 18:
            stat = asn1PE_H245GSMAudioCapability (&lctxt, pvalue->u.gsmFullRate);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* gsmHalfRate */
         case 19:
            stat = asn1PE_H245GSMAudioCapability (&lctxt, pvalue->u.gsmHalfRate);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* gsmEnhancedFullRate */
         case 20:
            stat = asn1PE_H245GSMAudioCapability (&lctxt, pvalue->u.gsmEnhancedFullRate);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* genericAudioCapability */
         case 21:
            stat = asn1PE_H245GenericCapability (&lctxt, pvalue->u.genericAudioCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* g729Extensions */
         case 22:
            stat = asn1PE_H245G729Extensions (&lctxt, pvalue->u.g729Extensions);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* vbd */
         case 23:
            stat = asn1PE_H245VBDCapability (&lctxt, pvalue->u.vbd);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* audioTelephonyEvent */
         case 24:
            stat = asn1PE_H245NoPTAudioTelephonyEventCapability (&lctxt, pvalue->u.audioTelephonyEvent);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* audioTone */
         case 25:
            stat = asn1PE_H245NoPTAudioToneCapability (&lctxt, pvalue->u.audioTone);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Capability_h233EncryptionReceiveCapability                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245Capability_h233EncryptionReceiveCapability (OOCTXT* pctxt, H245Capability_h233EncryptionReceiveCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode h233IVResponseTime */

   stat = encodeConsUnsigned (pctxt, pvalue->h233IVResponseTime, 0U, 255U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245NonStandardParameter                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245NonStandardParameter (OOCTXT* pctxt, H245_SeqOfH245NonStandardParameter* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245NonStandardParameter (pctxt, ((H245NonStandardParameter*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceCapability                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceCapability (OOCTXT* pctxt, H245ConferenceCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.videoIndicateMixingCapabilityPresent ||
   pvalue->m.multipointVisualizationCapabilityPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.nonStandardDataPresent);

   /* encode nonStandardData */

   if (pvalue->m.nonStandardDataPresent) {
      stat = asn1PE_H245_SeqOfH245NonStandardParameter (pctxt, &pvalue->nonStandardData);
      if (stat != ASN_OK) return stat;
   }

   /* encode chairControlCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->chairControlCapability);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 1);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.videoIndicateMixingCapabilityPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.multipointVisualizationCapabilityPresent);
      /* encode extension elements */

      if (pvalue->m.videoIndicateMixingCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->videoIndicateMixingCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.multipointVisualizationCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->multipointVisualizationCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MediaEncryptionAlgorithm                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MediaEncryptionAlgorithm (OOCTXT* pctxt, H245MediaEncryptionAlgorithm* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* algorithm */
         case 2:
            stat = encodeObjectIdentifier (pctxt, pvalue->u.algorithm);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionCapability                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EncryptionCapability (OOCTXT* pctxt, H245EncryptionCapability* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245MediaEncryptionAlgorithm (pctxt, ((H245MediaEncryptionAlgorithm*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AuthenticationCapability                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245AuthenticationCapability (OOCTXT* pctxt, H245AuthenticationCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.antiSpamAlgorithmPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.nonStandardPresent);

   /* encode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      stat = asn1PE_H245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.antiSpamAlgorithmPresent);
      /* encode extension elements */

      if (pvalue->m.antiSpamAlgorithmPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeObjectIdentifier (&lctxt, &pvalue->antiSpamAlgorithm);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IntegrityCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IntegrityCapability (OOCTXT* pctxt, H245IntegrityCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.nonStandardPresent);

   /* encode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      stat = asn1PE_H245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionAuthenticationAndIntegrity                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EncryptionAuthenticationAndIntegrity (OOCTXT* pctxt, H245EncryptionAuthenticationAndIntegrity* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.encryptionCapabilityPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.authenticationCapabilityPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.integrityCapabilityPresent);

   /* encode encryptionCapability */

   if (pvalue->m.encryptionCapabilityPresent) {
      stat = asn1PE_H245EncryptionCapability (pctxt, &pvalue->encryptionCapability);
      if (stat != ASN_OK) return stat;
   }

   /* encode authenticationCapability */

   if (pvalue->m.authenticationCapabilityPresent) {
      stat = asn1PE_H245AuthenticationCapability (pctxt, &pvalue->authenticationCapability);
      if (stat != ASN_OK) return stat;
   }

   /* encode integrityCapability */

   if (pvalue->m.integrityCapabilityPresent) {
      stat = asn1PE_H245IntegrityCapability (pctxt, &pvalue->integrityCapability);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H235SecurityCapability                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H235SecurityCapability (OOCTXT* pctxt, H245H235SecurityCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode encryptionAuthenticationAndIntegrity */

   stat = asn1PE_H245EncryptionAuthenticationAndIntegrity (pctxt, &pvalue->encryptionAuthenticationAndIntegrity);
   if (stat != ASN_OK) return stat;

   /* encode mediaCapability */

   stat = asn1PE_H245CapabilityTableEntryNumber (pctxt, pvalue->mediaCapability);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UserInputCapability_nonStandard                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UserInputCapability_nonStandard (OOCTXT* pctxt, H245UserInputCapability_nonStandard* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245NonStandardParameter (pctxt, ((H245NonStandardParameter*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UserInputCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UserInputCapability (OOCTXT* pctxt, H245UserInputCapability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 6);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 5);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245UserInputCapability_nonStandard (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* basicString */
         case 2:
            /* NULL */
            break;

         /* iA5String */
         case 3:
            /* NULL */
            break;

         /* generalString */
         case 4:
            /* NULL */
            break;

         /* dtmf */
         case 5:
            /* NULL */
            break;

         /* hookflash */
         case 6:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 7);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* extendedAlphanumeric */
         case 7:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexFormat                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexFormat (OOCTXT* pctxt, H245MultiplexFormat* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* h222Capability */
         case 2:
            stat = asn1PE_H245H222Capability (pctxt, pvalue->u.h222Capability);
            if (stat != ASN_OK) return stat;
            break;

         /* h223Capability */
         case 3:
            stat = asn1PE_H245H223Capability (pctxt, pvalue->u.h223Capability);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AlternativeCapabilitySet                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245AlternativeCapabilitySet (OOCTXT* pctxt, H245AlternativeCapabilitySet* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = asn1PE_H245CapabilityTableEntryNumber (pctxt, pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexedStreamCapability_capabilityOnMuxStream         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexedStreamCapability_capabilityOnMuxStream (OOCTXT* pctxt, H245MultiplexedStreamCapability_capabilityOnMuxStream* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245AlternativeCapabilitySet (pctxt, ((H245AlternativeCapabilitySet*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexedStreamCapability                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexedStreamCapability (OOCTXT* pctxt, H245MultiplexedStreamCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.capabilityOnMuxStreamPresent);

   /* encode multiplexFormat */

   stat = asn1PE_H245MultiplexFormat (pctxt, &pvalue->multiplexFormat);
   if (stat != ASN_OK) return stat;

   /* encode controlOnMuxStream */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->controlOnMuxStream);
   if (stat != ASN_OK) return stat;

   /* encode capabilityOnMuxStream */

   if (pvalue->m.capabilityOnMuxStreamPresent) {
      stat = asn1PE_H245MultiplexedStreamCapability_capabilityOnMuxStream (pctxt, &pvalue->capabilityOnMuxStream);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioTelephonyEventCapability                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245AudioTelephonyEventCapability (OOCTXT* pctxt, H245AudioTelephonyEventCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode dynamicRTPPayloadType */

   stat = encodeConsUnsigned (pctxt, pvalue->dynamicRTPPayloadType, 96U, 127U);
   if (stat != ASN_OK) return stat;

   /* encode audioTelephoneEvent */

   stat = encodeVarWidthCharString (pctxt, pvalue->audioTelephoneEvent);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioToneCapability                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245AudioToneCapability (OOCTXT* pctxt, H245AudioToneCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode dynamicRTPPayloadType */

   stat = encodeConsUnsigned (pctxt, pvalue->dynamicRTPPayloadType, 96U, 127U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECCapability_rfc2733_separateStream                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECCapability_rfc2733_separateStream (OOCTXT* pctxt, H245FECCapability_rfc2733_separateStream* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode separatePort */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->separatePort);
   if (stat != ASN_OK) return stat;

   /* encode samePort */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->samePort);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECCapability_rfc2733                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECCapability_rfc2733 (OOCTXT* pctxt, H245FECCapability_rfc2733* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode redundancyEncoding */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->redundancyEncoding);
   if (stat != ASN_OK) return stat;

   /* encode separateStream */

   stat = asn1PE_H245FECCapability_rfc2733_separateStream (pctxt, &pvalue->separateStream);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECCapability                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECCapability (OOCTXT* pctxt, H245FECCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 1);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* rfc2733 */
         case 1:
            stat = asn1PE_H245FECCapability_rfc2733 (pctxt, pvalue->u.rfc2733);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 2);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStreamCapability_capabilities              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplePayloadStreamCapability_capabilities (OOCTXT* pctxt, H245MultiplePayloadStreamCapability_capabilities* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245AlternativeCapabilitySet (pctxt, ((H245AlternativeCapabilitySet*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStreamCapability                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplePayloadStreamCapability (OOCTXT* pctxt, H245MultiplePayloadStreamCapability* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode capabilities */

   stat = asn1PE_H245MultiplePayloadStreamCapability_capabilities (pctxt, &pvalue->capabilities);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Capability                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245Capability (OOCTXT* pctxt, H245Capability* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 12);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 11);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* receiveVideoCapability */
         case 2:
            stat = asn1PE_H245VideoCapability (pctxt, pvalue->u.receiveVideoCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* transmitVideoCapability */
         case 3:
            stat = asn1PE_H245VideoCapability (pctxt, pvalue->u.transmitVideoCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* receiveAndTransmitVideoCapability */
         case 4:
            stat = asn1PE_H245VideoCapability (pctxt, pvalue->u.receiveAndTransmitVideoCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* receiveAudioCapability */
         case 5:
            stat = asn1PE_H245AudioCapability (pctxt, pvalue->u.receiveAudioCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* transmitAudioCapability */
         case 6:
            stat = asn1PE_H245AudioCapability (pctxt, pvalue->u.transmitAudioCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* receiveAndTransmitAudioCapability */
         case 7:
            stat = asn1PE_H245AudioCapability (pctxt, pvalue->u.receiveAndTransmitAudioCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* receiveDataApplicationCapability */
         case 8:
            stat = asn1PE_H245DataApplicationCapability (pctxt, pvalue->u.receiveDataApplicationCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* transmitDataApplicationCapability */
         case 9:
            stat = asn1PE_H245DataApplicationCapability (pctxt, pvalue->u.transmitDataApplicationCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* receiveAndTransmitDataApplicationCapability */
         case 10:
            stat = asn1PE_H245DataApplicationCapability (pctxt, pvalue->u.receiveAndTransmitDataApplicationCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* h233EncryptionTransmitCapability */
         case 11:
            stat = encodeBit (pctxt, (ASN1BOOL)pvalue->u.h233EncryptionTransmitCapability);
            if (stat != ASN_OK) return stat;
            break;

         /* h233EncryptionReceiveCapability */
         case 12:
            stat = asn1PE_H245Capability_h233EncryptionReceiveCapability (pctxt, pvalue->u.h233EncryptionReceiveCapability);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 13);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* conferenceCapability */
         case 13:
            stat = asn1PE_H245ConferenceCapability (&lctxt, pvalue->u.conferenceCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* h235SecurityCapability */
         case 14:
            stat = asn1PE_H245H235SecurityCapability (&lctxt, pvalue->u.h235SecurityCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* maxPendingReplacementFor */
         case 15:
            stat = encodeConsUnsigned (&lctxt, pvalue->u.maxPendingReplacementFor, 0U, 255U);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;

            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* receiveUserInputCapability */
         case 16:
            stat = asn1PE_H245UserInputCapability (&lctxt, pvalue->u.receiveUserInputCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* transmitUserInputCapability */
         case 17:
            stat = asn1PE_H245UserInputCapability (&lctxt, pvalue->u.transmitUserInputCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* receiveAndTransmitUserInputCapability */
         case 18:
            stat = asn1PE_H245UserInputCapability (&lctxt, pvalue->u.receiveAndTransmitUserInputCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* genericControlCapability */
         case 19:
            stat = asn1PE_H245GenericCapability (&lctxt, pvalue->u.genericControlCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* receiveMultiplexedStreamCapability */
         case 20:
            stat = asn1PE_H245MultiplexedStreamCapability (&lctxt, pvalue->u.receiveMultiplexedStreamCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* transmitMultiplexedStreamCapability */
         case 21:
            stat = asn1PE_H245MultiplexedStreamCapability (&lctxt, pvalue->u.transmitMultiplexedStreamCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* receiveAndTransmitMultiplexedStreamCapability */
         case 22:
            stat = asn1PE_H245MultiplexedStreamCapability (&lctxt, pvalue->u.receiveAndTransmitMultiplexedStreamCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* receiveRTPAudioTelephonyEventCapability */
         case 23:
            stat = asn1PE_H245AudioTelephonyEventCapability (&lctxt, pvalue->u.receiveRTPAudioTelephonyEventCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* receiveRTPAudioToneCapability */
         case 24:
            stat = asn1PE_H245AudioToneCapability (&lctxt, pvalue->u.receiveRTPAudioToneCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* fecCapability */
         case 25:
            stat = asn1PE_H245FECCapability (&lctxt, pvalue->u.fecCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* multiplePayloadStreamCapability */
         case 26:
            stat = asn1PE_H245MultiplePayloadStreamCapability (&lctxt, pvalue->u.multiplePayloadStreamCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityTableEntry                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CapabilityTableEntry (OOCTXT* pctxt, H245CapabilityTableEntry* pvalue)
{
   int stat = ASN_OK;

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.capabilityPresent);

   /* encode capabilityTableEntryNumber */

   stat = asn1PE_H245CapabilityTableEntryNumber (pctxt, pvalue->capabilityTableEntryNumber);
   if (stat != ASN_OK) return stat;

   /* encode capability */

   if (pvalue->m.capabilityPresent) {
      stat = asn1PE_H245Capability (pctxt, &pvalue->capability);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySet_capabilityTable                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalCapabilitySet_capabilityTable (OOCTXT* pctxt, H245TerminalCapabilitySet_capabilityTable* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245CapabilityTableEntry (pctxt, ((H245CapabilityTableEntry*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityDescriptorNumber                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CapabilityDescriptorNumber (OOCTXT* pctxt, H245CapabilityDescriptorNumber value)
{
   int stat = ASN_OK;

   stat = encodeConsUnsigned (pctxt, value, 0U, 255U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityDescriptor_simultaneousCapabilities             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CapabilityDescriptor_simultaneousCapabilities (OOCTXT* pctxt, H245CapabilityDescriptor_simultaneousCapabilities* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245AlternativeCapabilitySet (pctxt, ((H245AlternativeCapabilitySet*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CapabilityDescriptor                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CapabilityDescriptor (OOCTXT* pctxt, H245CapabilityDescriptor* pvalue)
{
   int stat = ASN_OK;

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.simultaneousCapabilitiesPresent);

   /* encode capabilityDescriptorNumber */

   stat = asn1PE_H245CapabilityDescriptorNumber (pctxt, pvalue->capabilityDescriptorNumber);
   if (stat != ASN_OK) return stat;

   /* encode simultaneousCapabilities */

   if (pvalue->m.simultaneousCapabilitiesPresent) {
      stat = asn1PE_H245CapabilityDescriptor_simultaneousCapabilities (pctxt, &pvalue->simultaneousCapabilities);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySet_capabilityDescriptors               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalCapabilitySet_capabilityDescriptors (OOCTXT* pctxt, H245TerminalCapabilitySet_capabilityDescriptors* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245CapabilityDescriptor (pctxt, ((H245CapabilityDescriptor*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySet                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalCapabilitySet (OOCTXT* pctxt, H245TerminalCapabilitySet* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.multiplexCapabilityPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.capabilityTablePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.capabilityDescriptorsPresent);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode protocolIdentifier */

   stat = encodeObjectIdentifier (pctxt, &pvalue->protocolIdentifier);
   if (stat != ASN_OK) return stat;

   /* encode multiplexCapability */

   if (pvalue->m.multiplexCapabilityPresent) {
      stat = asn1PE_H245MultiplexCapability (pctxt, &pvalue->multiplexCapability);
      if (stat != ASN_OK) return stat;
   }

   /* encode capabilityTable */

   if (pvalue->m.capabilityTablePresent) {
      stat = asn1PE_H245TerminalCapabilitySet_capabilityTable (pctxt, &pvalue->capabilityTable);
      if (stat != ASN_OK) return stat;
   }

   /* encode capabilityDescriptors */

   if (pvalue->m.capabilityDescriptorsPresent) {
      stat = asn1PE_H245TerminalCapabilitySet_capabilityDescriptors (pctxt, &pvalue->capabilityDescriptors);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LogicalChannelNumber                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245LogicalChannelNumber (OOCTXT* pctxt, H245LogicalChannelNumber value)
{
   int stat = ASN_OK;

   stat = encodeConsUnsigned (pctxt, value, 1U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionMode                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EncryptionMode (OOCTXT* pctxt, H245EncryptionMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* h233Encryption */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingElement                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RedundancyEncodingElement (OOCTXT* pctxt, H245RedundancyEncodingElement* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.payloadTypePresent);

   /* encode dataType */

   stat = asn1PE_H245DataType (pctxt, (H245DataType*)pvalue->dataType);
   if (stat != ASN_OK) return stat;

   /* encode payloadType */

   if (pvalue->m.payloadTypePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->payloadType, 0U, 127U);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245RedundancyEncodingElement                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245RedundancyEncodingElement (OOCTXT* pctxt, H245_SeqOfH245RedundancyEncodingElement* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245RedundancyEncodingElement (pctxt, ((H245RedundancyEncodingElement*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncoding_rtpRedundancyEncoding                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RedundancyEncoding_rtpRedundancyEncoding (OOCTXT* pctxt, H245RedundancyEncoding_rtpRedundancyEncoding* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.primaryPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.secondaryPresent);

   /* encode primary */

   if (pvalue->m.primaryPresent) {
      stat = asn1PE_H245RedundancyEncodingElement (pctxt, &pvalue->primary);
      if (stat != ASN_OK) return stat;
   }

   /* encode secondary */

   if (pvalue->m.secondaryPresent) {
      stat = asn1PE_H245_SeqOfH245RedundancyEncodingElement (pctxt, &pvalue->secondary);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncoding                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RedundancyEncoding (OOCTXT* pctxt, H245RedundancyEncoding* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.rtpRedundancyEncodingPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.secondaryEncodingPresent);

   /* encode redundancyEncodingMethod */

   stat = asn1PE_H245RedundancyEncodingMethod (pctxt, &pvalue->redundancyEncodingMethod);
   if (stat != ASN_OK) return stat;

   /* encode secondaryEncoding */

   if (pvalue->m.secondaryEncodingPresent) {
      stat = asn1PE_H245DataType (pctxt, (H245DataType*)pvalue->secondaryEncoding);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.rtpRedundancyEncodingPresent);
      /* encode extension elements */

      if (pvalue->m.rtpRedundancyEncodingPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245RedundancyEncoding_rtpRedundancyEncoding (&lctxt, &pvalue->rtpRedundancyEncoding);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStreamElement                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplePayloadStreamElement (OOCTXT* pctxt, H245MultiplePayloadStreamElement* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.payloadTypePresent);

   /* encode dataType */

   stat = asn1PE_H245DataType (pctxt, (H245DataType*)pvalue->dataType);
   if (stat != ASN_OK) return stat;

   /* encode payloadType */

   if (pvalue->m.payloadTypePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->payloadType, 0U, 127U);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245MultiplePayloadStreamElement                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245MultiplePayloadStreamElement (OOCTXT* pctxt, H245_SeqOfH245MultiplePayloadStreamElement* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245MultiplePayloadStreamElement (pctxt, ((H245MultiplePayloadStreamElement*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStream                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplePayloadStream (OOCTXT* pctxt, H245MultiplePayloadStream* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode elements */

   stat = asn1PE_H245_SeqOfH245MultiplePayloadStreamElement (pctxt, &pvalue->elements);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData_rfc2733_mode_separateStream_differentPort         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECData_rfc2733_mode_separateStream_differentPort (OOCTXT* pctxt, H245FECData_rfc2733_mode_separateStream_differentPort* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.protectedPayloadTypePresent);

   /* encode protectedSessionID */

   stat = encodeConsUnsigned (pctxt, pvalue->protectedSessionID, 1U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode protectedPayloadType */

   if (pvalue->m.protectedPayloadTypePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->protectedPayloadType, 0U, 127U);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData_rfc2733_mode_separateStream_samePort              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECData_rfc2733_mode_separateStream_samePort (OOCTXT* pctxt, H245FECData_rfc2733_mode_separateStream_samePort* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode protectedPayloadType */

   stat = encodeConsUnsigned (pctxt, pvalue->protectedPayloadType, 0U, 127U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData_rfc2733_mode_separateStream                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECData_rfc2733_mode_separateStream (OOCTXT* pctxt, H245FECData_rfc2733_mode_separateStream* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* differentPort */
         case 1:
            stat = asn1PE_H245FECData_rfc2733_mode_separateStream_differentPort (pctxt, pvalue->u.differentPort);
            if (stat != ASN_OK) return stat;
            break;

         /* samePort */
         case 2:
            stat = asn1PE_H245FECData_rfc2733_mode_separateStream_samePort (pctxt, pvalue->u.samePort);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData_rfc2733_mode                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECData_rfc2733_mode (OOCTXT* pctxt, H245FECData_rfc2733_mode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* redundancyEncoding */
         case 1:
            /* NULL */
            break;

         /* separateStream */
         case 2:
            stat = asn1PE_H245FECData_rfc2733_mode_separateStream (pctxt, pvalue->u.separateStream);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData_rfc2733                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECData_rfc2733 (OOCTXT* pctxt, H245FECData_rfc2733* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode mode */

   stat = asn1PE_H245FECData_rfc2733_mode (pctxt, &pvalue->mode);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECData                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECData (OOCTXT* pctxt, H245FECData* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* rfc2733 */
      case 1:
         stat = asn1PE_H245FECData_rfc2733 (pctxt, pvalue->u.rfc2733);
         if (stat != ASN_OK) return stat;
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H235Media_mediaType                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H235Media_mediaType (OOCTXT* pctxt, H245H235Media_mediaType* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* videoData */
         case 2:
            stat = asn1PE_H245VideoCapability (pctxt, pvalue->u.videoData);
            if (stat != ASN_OK) return stat;
            break;

         /* audioData */
         case 3:
            stat = asn1PE_H245AudioCapability (pctxt, pvalue->u.audioData);
            if (stat != ASN_OK) return stat;
            break;

         /* data */
         case 4:
            stat = asn1PE_H245DataApplicationCapability (pctxt, pvalue->u.data);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* redundancyEncoding */
         case 5:
            stat = asn1PE_H245RedundancyEncoding (&lctxt, pvalue->u.redundancyEncoding);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* multiplePayloadStream */
         case 6:
            stat = asn1PE_H245MultiplePayloadStream (&lctxt, pvalue->u.multiplePayloadStream);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* fec */
         case 7:
            stat = asn1PE_H245FECData (&lctxt, pvalue->u.fec);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H235Media                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H235Media (OOCTXT* pctxt, H245H235Media* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode encryptionAuthenticationAndIntegrity */

   stat = asn1PE_H245EncryptionAuthenticationAndIntegrity (pctxt, &pvalue->encryptionAuthenticationAndIntegrity);
   if (stat != ASN_OK) return stat;

   /* encode mediaType */

   stat = asn1PE_H245H235Media_mediaType (pctxt, &pvalue->mediaType);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexedStreamParameter                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexedStreamParameter (OOCTXT* pctxt, H245MultiplexedStreamParameter* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode multiplexFormat */

   stat = asn1PE_H245MultiplexFormat (pctxt, &pvalue->multiplexFormat);
   if (stat != ASN_OK) return stat;

   /* encode controlOnMuxStream */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->controlOnMuxStream);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataType                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataType (OOCTXT* pctxt, H245DataType* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 6);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 5);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* nullData */
         case 2:
            /* NULL */
            break;

         /* videoData */
         case 3:
            stat = asn1PE_H245VideoCapability (pctxt, pvalue->u.videoData);
            if (stat != ASN_OK) return stat;
            break;

         /* audioData */
         case 4:
            stat = asn1PE_H245AudioCapability (pctxt, pvalue->u.audioData);
            if (stat != ASN_OK) return stat;
            break;

         /* data */
         case 5:
            stat = asn1PE_H245DataApplicationCapability (pctxt, pvalue->u.data);
            if (stat != ASN_OK) return stat;
            break;

         /* encryptionData */
         case 6:
            stat = asn1PE_H245EncryptionMode (pctxt, pvalue->u.encryptionData);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 7);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* h235Control */
         case 7:
            stat = asn1PE_H245NonStandardParameter (&lctxt, pvalue->u.h235Control);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* h235Media */
         case 8:
            stat = asn1PE_H245H235Media (&lctxt, pvalue->u.h235Media);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* multiplexedStream */
         case 9:
            stat = asn1PE_H245MultiplexedStreamParameter (&lctxt, pvalue->u.multiplexedStream);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* redundancyEncoding */
         case 10:
            stat = asn1PE_H245RedundancyEncoding (&lctxt, pvalue->u.redundancyEncoding);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* multiplePayloadStream */
         case 11:
            stat = asn1PE_H245MultiplePayloadStream (&lctxt, pvalue->u.multiplePayloadStream);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* fec */
         case 12:
            stat = asn1PE_H245FECData (&lctxt, pvalue->u.fec);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H222LogicalChannelParameters                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H222LogicalChannelParameters (OOCTXT* pctxt, H245H222LogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.pcr_pidPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.programDescriptorsPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.streamDescriptorsPresent);

   /* encode resourceID */

   stat = encodeConsUnsigned (pctxt, pvalue->resourceID, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode subChannelID */

   stat = encodeConsUnsigned (pctxt, pvalue->subChannelID, 0U, 8191U);
   if (stat != ASN_OK) return stat;

   /* encode pcr_pid */

   if (pvalue->m.pcr_pidPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->pcr_pid, 0U, 8191U);
      if (stat != ASN_OK) return stat;

   }

   /* encode programDescriptors */

   if (pvalue->m.programDescriptorsPresent) {
      stat = encodeOctetString (pctxt, pvalue->programDescriptors.numocts, pvalue->programDescriptors.data);
      if (stat != ASN_OK) return stat;
   }

   /* encode streamDescriptors */

   if (pvalue->m.streamDescriptorsPresent) {
      stat = encodeOctetString (pctxt, pvalue->streamDescriptors.numocts, pvalue->streamDescriptors.data);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223LogicalChannelParameters_adaptationLayerType_al3      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223LogicalChannelParameters_adaptationLayerType_al3 (OOCTXT* pctxt, H245H223LogicalChannelParameters_adaptationLayerType_al3* pvalue)
{
   int stat = ASN_OK;

   /* encode controlFieldOctets */

   stat = encodeConsUnsigned (pctxt, pvalue->controlFieldOctets, 0U, 2U);
   if (stat != ASN_OK) return stat;

   /* encode sendBufferSize */

   stat = encodeConsUnsigned (pctxt, pvalue->sendBufferSize, 0U, 16777215U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL1MParameters_transferMode                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AL1MParameters_transferMode (OOCTXT* pctxt, H245H223AL1MParameters_transferMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* framed */
         case 1:
            /* NULL */
            break;

         /* unframed */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL1MParameters_headerFEC                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AL1MParameters_headerFEC (OOCTXT* pctxt, H245H223AL1MParameters_headerFEC* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* sebch16_7 */
         case 1:
            /* NULL */
            break;

         /* golay24_12 */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL1MParameters_crcLength                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AL1MParameters_crcLength (OOCTXT* pctxt, H245H223AL1MParameters_crcLength* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* crc4bit */
         case 1:
            /* NULL */
            break;

         /* crc12bit */
         case 2:
            /* NULL */
            break;

         /* crc20bit */
         case 3:
            /* NULL */
            break;

         /* crc28bit */
         case 4:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* crc8bit */
         case 5:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* crc16bit */
         case 6:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* crc32bit */
         case 7:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* crcNotUsed */
         case 8:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AnnexCArqParameters_numberOfRetransmissions           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AnnexCArqParameters_numberOfRetransmissions (OOCTXT* pctxt, H245H223AnnexCArqParameters_numberOfRetransmissions* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* finite */
         case 1:
            stat = encodeConsUnsigned (pctxt, pvalue->u.finite, 0U, 16U);
            if (stat != ASN_OK) return stat;

            break;

         /* infinite */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AnnexCArqParameters                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AnnexCArqParameters (OOCTXT* pctxt, H245H223AnnexCArqParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode numberOfRetransmissions */

   stat = asn1PE_H245H223AnnexCArqParameters_numberOfRetransmissions (pctxt, &pvalue->numberOfRetransmissions);
   if (stat != ASN_OK) return stat;

   /* encode sendBufferSize */

   stat = encodeConsUnsigned (pctxt, pvalue->sendBufferSize, 0U, 16777215U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL1MParameters_arqType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AL1MParameters_arqType (OOCTXT* pctxt, H245H223AL1MParameters_arqType* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* noArq */
         case 1:
            /* NULL */
            break;

         /* typeIArq */
         case 2:
            stat = asn1PE_H245H223AnnexCArqParameters (pctxt, pvalue->u.typeIArq);
            if (stat != ASN_OK) return stat;
            break;

         /* typeIIArq */
         case 3:
            stat = asn1PE_H245H223AnnexCArqParameters (pctxt, pvalue->u.typeIIArq);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL1MParameters                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AL1MParameters (OOCTXT* pctxt, H245H223AL1MParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.rsCodeCorrectionPresent);

   encodeBit (pctxt, extbit);

   /* encode transferMode */

   stat = asn1PE_H245H223AL1MParameters_transferMode (pctxt, &pvalue->transferMode);
   if (stat != ASN_OK) return stat;

   /* encode headerFEC */

   stat = asn1PE_H245H223AL1MParameters_headerFEC (pctxt, &pvalue->headerFEC);
   if (stat != ASN_OK) return stat;

   /* encode crcLength */

   stat = asn1PE_H245H223AL1MParameters_crcLength (pctxt, &pvalue->crcLength);
   if (stat != ASN_OK) return stat;

   /* encode rcpcCodeRate */

   stat = encodeConsUnsigned (pctxt, pvalue->rcpcCodeRate, 8U, 32U);
   if (stat != ASN_OK) return stat;

   /* encode arqType */

   stat = asn1PE_H245H223AL1MParameters_arqType (pctxt, &pvalue->arqType);
   if (stat != ASN_OK) return stat;

   /* encode alpduInterleaving */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->alpduInterleaving);
   if (stat != ASN_OK) return stat;

   /* encode alsduSplitting */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->alsduSplitting);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.rsCodeCorrectionPresent);
      /* encode extension elements */

      if (pvalue->m.rsCodeCorrectionPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeConsUnsigned (&lctxt, pvalue->rsCodeCorrection, 0U, 127U);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL2MParameters_headerFEC                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AL2MParameters_headerFEC (OOCTXT* pctxt, H245H223AL2MParameters_headerFEC* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* sebch16_5 */
         case 1:
            /* NULL */
            break;

         /* golay24_12 */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL2MParameters                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AL2MParameters (OOCTXT* pctxt, H245H223AL2MParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode headerFEC */

   stat = asn1PE_H245H223AL2MParameters_headerFEC (pctxt, &pvalue->headerFEC);
   if (stat != ASN_OK) return stat;

   /* encode alpduInterleaving */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->alpduInterleaving);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL3MParameters_headerFormat                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AL3MParameters_headerFormat (OOCTXT* pctxt, H245H223AL3MParameters_headerFormat* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* sebch16_7 */
         case 1:
            /* NULL */
            break;

         /* golay24_12 */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL3MParameters_crcLength                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AL3MParameters_crcLength (OOCTXT* pctxt, H245H223AL3MParameters_crcLength* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* crc4bit */
         case 1:
            /* NULL */
            break;

         /* crc12bit */
         case 2:
            /* NULL */
            break;

         /* crc20bit */
         case 3:
            /* NULL */
            break;

         /* crc28bit */
         case 4:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* crc8bit */
         case 5:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* crc16bit */
         case 6:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* crc32bit */
         case 7:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* crcNotUsed */
         case 8:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL3MParameters_arqType                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AL3MParameters_arqType (OOCTXT* pctxt, H245H223AL3MParameters_arqType* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* noArq */
         case 1:
            /* NULL */
            break;

         /* typeIArq */
         case 2:
            stat = asn1PE_H245H223AnnexCArqParameters (pctxt, pvalue->u.typeIArq);
            if (stat != ASN_OK) return stat;
            break;

         /* typeIIArq */
         case 3:
            stat = asn1PE_H245H223AnnexCArqParameters (pctxt, pvalue->u.typeIIArq);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223AL3MParameters                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223AL3MParameters (OOCTXT* pctxt, H245H223AL3MParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.rsCodeCorrectionPresent);

   encodeBit (pctxt, extbit);

   /* encode headerFormat */

   stat = asn1PE_H245H223AL3MParameters_headerFormat (pctxt, &pvalue->headerFormat);
   if (stat != ASN_OK) return stat;

   /* encode crcLength */

   stat = asn1PE_H245H223AL3MParameters_crcLength (pctxt, &pvalue->crcLength);
   if (stat != ASN_OK) return stat;

   /* encode rcpcCodeRate */

   stat = encodeConsUnsigned (pctxt, pvalue->rcpcCodeRate, 8U, 32U);
   if (stat != ASN_OK) return stat;

   /* encode arqType */

   stat = asn1PE_H245H223AL3MParameters_arqType (pctxt, &pvalue->arqType);
   if (stat != ASN_OK) return stat;

   /* encode alpduInterleaving */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->alpduInterleaving);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.rsCodeCorrectionPresent);
      /* encode extension elements */

      if (pvalue->m.rsCodeCorrectionPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeConsUnsigned (&lctxt, pvalue->rsCodeCorrection, 0U, 127U);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223LogicalChannelParameters_adaptationLayerType          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223LogicalChannelParameters_adaptationLayerType (OOCTXT* pctxt, H245H223LogicalChannelParameters_adaptationLayerType* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 6);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 5);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* al1Framed */
         case 2:
            /* NULL */
            break;

         /* al1NotFramed */
         case 3:
            /* NULL */
            break;

         /* al2WithoutSequenceNumbers */
         case 4:
            /* NULL */
            break;

         /* al2WithSequenceNumbers */
         case 5:
            /* NULL */
            break;

         /* al3 */
         case 6:
            stat = asn1PE_H245H223LogicalChannelParameters_adaptationLayerType_al3 (pctxt, pvalue->u.al3);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 7);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* al1M */
         case 7:
            stat = asn1PE_H245H223AL1MParameters (&lctxt, pvalue->u.al1M);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* al2M */
         case 8:
            stat = asn1PE_H245H223AL2MParameters (&lctxt, pvalue->u.al2M);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* al3M */
         case 9:
            stat = asn1PE_H245H223AL3MParameters (&lctxt, pvalue->u.al3M);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223LogicalChannelParameters                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223LogicalChannelParameters (OOCTXT* pctxt, H245H223LogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode adaptationLayerType */

   stat = asn1PE_H245H223LogicalChannelParameters_adaptationLayerType (pctxt, &pvalue->adaptationLayerType);
   if (stat != ASN_OK) return stat;

   /* encode segmentableFlag */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->segmentableFlag);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CRCLength                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CRCLength (OOCTXT* pctxt, H245CRCLength* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* crc8bit */
         case 1:
            /* NULL */
            break;

         /* crc16bit */
         case 2:
            /* NULL */
            break;

         /* crc32bit */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76HDLCParameters                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245V76HDLCParameters (OOCTXT* pctxt, H245V76HDLCParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode crcLength */

   stat = asn1PE_H245CRCLength (pctxt, &pvalue->crcLength);
   if (stat != ASN_OK) return stat;

   /* encode n401 */

   stat = encodeConsUnsigned (pctxt, pvalue->n401, 1U, 4095U);
   if (stat != ASN_OK) return stat;

   /* encode loopbackTestProcedure */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->loopbackTestProcedure);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76LogicalChannelParameters_suspendResume                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245V76LogicalChannelParameters_suspendResume (OOCTXT* pctxt, H245V76LogicalChannelParameters_suspendResume* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* noSuspendResume */
         case 1:
            /* NULL */
            break;

         /* suspendResumewAddress */
         case 2:
            /* NULL */
            break;

         /* suspendResumewoAddress */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76LogicalChannelParameters_mode_eRM_recovery             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245V76LogicalChannelParameters_mode_eRM_recovery (OOCTXT* pctxt, H245V76LogicalChannelParameters_mode_eRM_recovery* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* rej */
         case 1:
            /* NULL */
            break;

         /* sREJ */
         case 2:
            /* NULL */
            break;

         /* mSREJ */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76LogicalChannelParameters_mode_eRM                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245V76LogicalChannelParameters_mode_eRM (OOCTXT* pctxt, H245V76LogicalChannelParameters_mode_eRM* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode windowSize */

   stat = encodeConsUnsigned (pctxt, pvalue->windowSize, 1U, 127U);
   if (stat != ASN_OK) return stat;

   /* encode recovery */

   stat = asn1PE_H245V76LogicalChannelParameters_mode_eRM_recovery (pctxt, &pvalue->recovery);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76LogicalChannelParameters_mode                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245V76LogicalChannelParameters_mode (OOCTXT* pctxt, H245V76LogicalChannelParameters_mode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* eRM */
         case 1:
            stat = asn1PE_H245V76LogicalChannelParameters_mode_eRM (pctxt, pvalue->u.eRM);
            if (stat != ASN_OK) return stat;
            break;

         /* uNERM */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V75Parameters                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245V75Parameters (OOCTXT* pctxt, H245V75Parameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode audioHeaderPresent */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->audioHeaderPresent);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76LogicalChannelParameters                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245V76LogicalChannelParameters (OOCTXT* pctxt, H245V76LogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode hdlcParameters */

   stat = asn1PE_H245V76HDLCParameters (pctxt, &pvalue->hdlcParameters);
   if (stat != ASN_OK) return stat;

   /* encode suspendResume */

   stat = asn1PE_H245V76LogicalChannelParameters_suspendResume (pctxt, &pvalue->suspendResume);
   if (stat != ASN_OK) return stat;

   /* encode uIH */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->uIH);
   if (stat != ASN_OK) return stat;

   /* encode mode */

   stat = asn1PE_H245V76LogicalChannelParameters_mode (pctxt, &pvalue->mode);
   if (stat != ASN_OK) return stat;

   /* encode v75Parameters */

   stat = asn1PE_H245V75Parameters (pctxt, &pvalue->v75Parameters);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPAddress_network                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iPAddress_network (OOCTXT* pctxt, H245UnicastAddress_iPAddress_network* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 4, 4, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPAddress                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iPAddress (OOCTXT* pctxt, H245UnicastAddress_iPAddress* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode network */

   stat = asn1PE_H245UnicastAddress_iPAddress_network (pctxt, &pvalue->network);
   if (stat != ASN_OK) return stat;

   /* encode tsapIdentifier */

   stat = encodeConsUnsigned (pctxt, pvalue->tsapIdentifier, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPXAddress_node                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iPXAddress_node (OOCTXT* pctxt, H245UnicastAddress_iPXAddress_node* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 6, 6, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPXAddress_netnum                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iPXAddress_netnum (OOCTXT* pctxt, H245UnicastAddress_iPXAddress_netnum* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 4, 4, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPXAddress_tsapIdentifier                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iPXAddress_tsapIdentifier (OOCTXT* pctxt, H245UnicastAddress_iPXAddress_tsapIdentifier* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 2, 2, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPXAddress                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iPXAddress (OOCTXT* pctxt, H245UnicastAddress_iPXAddress* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode node */

   stat = asn1PE_H245UnicastAddress_iPXAddress_node (pctxt, &pvalue->node);
   if (stat != ASN_OK) return stat;

   /* encode netnum */

   stat = asn1PE_H245UnicastAddress_iPXAddress_netnum (pctxt, &pvalue->netnum);
   if (stat != ASN_OK) return stat;

   /* encode tsapIdentifier */

   stat = asn1PE_H245UnicastAddress_iPXAddress_tsapIdentifier (pctxt, &pvalue->tsapIdentifier);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iP6Address_network                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iP6Address_network (OOCTXT* pctxt, H245UnicastAddress_iP6Address_network* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iP6Address                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iP6Address (OOCTXT* pctxt, H245UnicastAddress_iP6Address* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode network */

   stat = asn1PE_H245UnicastAddress_iP6Address_network (pctxt, &pvalue->network);
   if (stat != ASN_OK) return stat;

   /* encode tsapIdentifier */

   stat = encodeConsUnsigned (pctxt, pvalue->tsapIdentifier, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_netBios                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_netBios (OOCTXT* pctxt, H245UnicastAddress_netBios* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPSourceRouteAddress_routing               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iPSourceRouteAddress_routing (OOCTXT* pctxt, H245UnicastAddress_iPSourceRouteAddress_routing* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* strict */
      case 1:
         /* NULL */
         break;

      /* loose */
      case 2:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPSourceRouteAddress_network               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iPSourceRouteAddress_network (OOCTXT* pctxt, H245UnicastAddress_iPSourceRouteAddress_network* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 4, 4, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPSourceRouteAddress_route_element         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iPSourceRouteAddress_route_element (OOCTXT* pctxt, H245UnicastAddress_iPSourceRouteAddress_route_element* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 4, 4, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245UnicastAddress_iPSourceRouteAddress_route_elem  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245UnicastAddress_iPSourceRouteAddress_route_element (OOCTXT* pctxt, H245_SeqOfH245UnicastAddress_iPSourceRouteAddress_route_element* pvalue)
{
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = asn1PE_H245UnicastAddress_iPSourceRouteAddress_route_element (pctxt, &pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_iPSourceRouteAddress                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_iPSourceRouteAddress (OOCTXT* pctxt, H245UnicastAddress_iPSourceRouteAddress* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode routing */

   stat = asn1PE_H245UnicastAddress_iPSourceRouteAddress_routing (pctxt, &pvalue->routing);
   if (stat != ASN_OK) return stat;

   /* encode network */

   stat = asn1PE_H245UnicastAddress_iPSourceRouteAddress_network (pctxt, &pvalue->network);
   if (stat != ASN_OK) return stat;

   /* encode tsapIdentifier */

   stat = encodeConsUnsigned (pctxt, pvalue->tsapIdentifier, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode route */

   stat = asn1PE_H245_SeqOfH245UnicastAddress_iPSourceRouteAddress_route_element (pctxt, &pvalue->route);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress_nsap                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress_nsap (OOCTXT* pctxt, H245UnicastAddress_nsap* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 20, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnicastAddress                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UnicastAddress (OOCTXT* pctxt, H245UnicastAddress* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 5);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 4);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* iPAddress */
         case 1:
            stat = asn1PE_H245UnicastAddress_iPAddress (pctxt, pvalue->u.iPAddress);
            if (stat != ASN_OK) return stat;
            break;

         /* iPXAddress */
         case 2:
            stat = asn1PE_H245UnicastAddress_iPXAddress (pctxt, pvalue->u.iPXAddress);
            if (stat != ASN_OK) return stat;
            break;

         /* iP6Address */
         case 3:
            stat = asn1PE_H245UnicastAddress_iP6Address (pctxt, pvalue->u.iP6Address);
            if (stat != ASN_OK) return stat;
            break;

         /* netBios */
         case 4:
            stat = asn1PE_H245UnicastAddress_netBios (pctxt, pvalue->u.netBios);
            if (stat != ASN_OK) return stat;
            break;

         /* iPSourceRouteAddress */
         case 5:
            stat = asn1PE_H245UnicastAddress_iPSourceRouteAddress (pctxt, pvalue->u.iPSourceRouteAddress);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 6);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* nsap */
         case 6:
            stat = asn1PE_H245UnicastAddress_nsap (&lctxt, pvalue->u.nsap);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* nonStandardAddress */
         case 7:
            stat = asn1PE_H245NonStandardParameter (&lctxt, pvalue->u.nonStandardAddress);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress_iPAddress_network                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MulticastAddress_iPAddress_network (OOCTXT* pctxt, H245MulticastAddress_iPAddress_network* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 4, 4, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress_iPAddress                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MulticastAddress_iPAddress (OOCTXT* pctxt, H245MulticastAddress_iPAddress* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode network */

   stat = asn1PE_H245MulticastAddress_iPAddress_network (pctxt, &pvalue->network);
   if (stat != ASN_OK) return stat;

   /* encode tsapIdentifier */

   stat = encodeConsUnsigned (pctxt, pvalue->tsapIdentifier, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress_iP6Address_network                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MulticastAddress_iP6Address_network (OOCTXT* pctxt, H245MulticastAddress_iP6Address_network* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress_iP6Address                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MulticastAddress_iP6Address (OOCTXT* pctxt, H245MulticastAddress_iP6Address* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode network */

   stat = asn1PE_H245MulticastAddress_iP6Address_network (pctxt, &pvalue->network);
   if (stat != ASN_OK) return stat;

   /* encode tsapIdentifier */

   stat = encodeConsUnsigned (pctxt, pvalue->tsapIdentifier, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress_nsap                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MulticastAddress_nsap (OOCTXT* pctxt, H245MulticastAddress_nsap* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 20, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MulticastAddress                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MulticastAddress (OOCTXT* pctxt, H245MulticastAddress* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* iPAddress */
         case 1:
            stat = asn1PE_H245MulticastAddress_iPAddress (pctxt, pvalue->u.iPAddress);
            if (stat != ASN_OK) return stat;
            break;

         /* iP6Address */
         case 2:
            stat = asn1PE_H245MulticastAddress_iP6Address (pctxt, pvalue->u.iP6Address);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* nsap */
         case 3:
            stat = asn1PE_H245MulticastAddress_nsap (&lctxt, pvalue->u.nsap);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* nonStandardAddress */
         case 4:
            stat = asn1PE_H245NonStandardParameter (&lctxt, pvalue->u.nonStandardAddress);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TransportAddress                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TransportAddress (OOCTXT* pctxt, H245TransportAddress* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* unicastAddress */
         case 1:
            stat = asn1PE_H245UnicastAddress (pctxt, pvalue->u.unicastAddress);
            if (stat != ASN_OK) return stat;
            break;

         /* multicastAddress */
         case 2:
            stat = asn1PE_H245MulticastAddress (pctxt, pvalue->u.multicastAddress);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  McuNumber                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245McuNumber (OOCTXT* pctxt, H245McuNumber value)
{
   int stat = ASN_OK;

   stat = encodeConsUnsigned (pctxt, value, 0U, 192U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalNumber                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalNumber (OOCTXT* pctxt, H245TerminalNumber value)
{
   int stat = ASN_OK;

   stat = encodeConsUnsigned (pctxt, value, 0U, 192U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalLabel                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalLabel (OOCTXT* pctxt, H245TerminalLabel* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode mcuNumber */

   stat = asn1PE_H245McuNumber (pctxt, pvalue->mcuNumber);
   if (stat != ASN_OK) return stat;

   /* encode terminalNumber */

   stat = asn1PE_H245TerminalNumber (pctxt, pvalue->terminalNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250LogicalChannelParameters_mediaPacketization          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H2250LogicalChannelParameters_mediaPacketization (OOCTXT* pctxt, H245H2250LogicalChannelParameters_mediaPacketization* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 1);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* h261aVideoPacketization */
         case 1:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 2);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* rtpPayloadType */
         case 2:
            stat = asn1PE_H245RTPPayloadType (&lctxt, pvalue->u.rtpPayloadType);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250LogicalChannelParameters                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H2250LogicalChannelParameters (OOCTXT* pctxt, H245H2250LogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.transportCapabilityPresent ||
   pvalue->m.redundancyEncodingPresent ||
   pvalue->m.sourcePresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.nonStandardPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.associatedSessionIDPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaChannelPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaGuaranteedDeliveryPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaControlChannelPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaControlGuaranteedDeliveryPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.silenceSuppressionPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.destinationPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.dynamicRTPPayloadTypePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaPacketizationPresent);

   /* encode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      stat = asn1PE_H245_SeqOfH245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;
   }

   /* encode sessionID */

   stat = encodeConsUnsigned (pctxt, pvalue->sessionID, 0U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode associatedSessionID */

   if (pvalue->m.associatedSessionIDPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->associatedSessionID, 1U, 255U);
      if (stat != ASN_OK) return stat;

   }

   /* encode mediaChannel */

   if (pvalue->m.mediaChannelPresent) {
      stat = asn1PE_H245TransportAddress (pctxt, &pvalue->mediaChannel);
      if (stat != ASN_OK) return stat;
   }

   /* encode mediaGuaranteedDelivery */

   if (pvalue->m.mediaGuaranteedDeliveryPresent) {
      stat = encodeBit (pctxt, (ASN1BOOL)pvalue->mediaGuaranteedDelivery);
      if (stat != ASN_OK) return stat;
   }

   /* encode mediaControlChannel */

   if (pvalue->m.mediaControlChannelPresent) {
      stat = asn1PE_H245TransportAddress (pctxt, &pvalue->mediaControlChannel);
      if (stat != ASN_OK) return stat;
   }

   /* encode mediaControlGuaranteedDelivery */

   if (pvalue->m.mediaControlGuaranteedDeliveryPresent) {
      stat = encodeBit (pctxt, (ASN1BOOL)pvalue->mediaControlGuaranteedDelivery);
      if (stat != ASN_OK) return stat;
   }

   /* encode silenceSuppression */

   if (pvalue->m.silenceSuppressionPresent) {
      stat = encodeBit (pctxt, (ASN1BOOL)pvalue->silenceSuppression);
      if (stat != ASN_OK) return stat;
   }

   /* encode destination */

   if (pvalue->m.destinationPresent) {
      stat = asn1PE_H245TerminalLabel (pctxt, &pvalue->destination);
      if (stat != ASN_OK) return stat;
   }

   /* encode dynamicRTPPayloadType */

   if (pvalue->m.dynamicRTPPayloadTypePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->dynamicRTPPayloadType, 96U, 127U);
      if (stat != ASN_OK) return stat;

   }

   /* encode mediaPacketization */

   if (pvalue->m.mediaPacketizationPresent) {
      stat = asn1PE_H245H2250LogicalChannelParameters_mediaPacketization (pctxt, &pvalue->mediaPacketization);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 2);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.transportCapabilityPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.redundancyEncodingPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.sourcePresent);
      /* encode extension elements */

      if (pvalue->m.transportCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245TransportCapability (&lctxt, &pvalue->transportCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.redundancyEncodingPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245RedundancyEncoding (&lctxt, &pvalue->redundancyEncoding);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.sourcePresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245TerminalLabel (&lctxt, &pvalue->source);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannel_forwardLogicalChannelParameters_multi  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters (OOCTXT* pctxt, H245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* h222LogicalChannelParameters */
         case 1:
            stat = asn1PE_H245H222LogicalChannelParameters (pctxt, pvalue->u.h222LogicalChannelParameters);
            if (stat != ASN_OK) return stat;
            break;

         /* h223LogicalChannelParameters */
         case 2:
            stat = asn1PE_H245H223LogicalChannelParameters (pctxt, pvalue->u.h223LogicalChannelParameters);
            if (stat != ASN_OK) return stat;
            break;

         /* v76LogicalChannelParameters */
         case 3:
            stat = asn1PE_H245V76LogicalChannelParameters (pctxt, pvalue->u.v76LogicalChannelParameters);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* h2250LogicalChannelParameters */
         case 4:
            stat = asn1PE_H245H2250LogicalChannelParameters (&lctxt, pvalue->u.h2250LogicalChannelParameters);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* none */
         case 5:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannel_forwardLogicalChannelParameters        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannel_forwardLogicalChannelParameters (OOCTXT* pctxt, H245OpenLogicalChannel_forwardLogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.forwardLogicalChannelDependencyPresent ||
   pvalue->m.replacementForPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.portNumberPresent);

   /* encode portNumber */

   if (pvalue->m.portNumberPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->portNumber, 0U, 65535U);
      if (stat != ASN_OK) return stat;

   }

   /* encode dataType */

   stat = asn1PE_H245DataType (pctxt, &pvalue->dataType);
   if (stat != ASN_OK) return stat;

   /* encode multiplexParameters */

   stat = asn1PE_H245OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters (pctxt, &pvalue->multiplexParameters);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 1);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.forwardLogicalChannelDependencyPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.replacementForPresent);
      /* encode extension elements */

      if (pvalue->m.forwardLogicalChannelDependencyPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245LogicalChannelNumber (&lctxt, pvalue->forwardLogicalChannelDependency);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.replacementForPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245LogicalChannelNumber (&lctxt, pvalue->replacementFor);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannel_reverseLogicalChannelParameters_multi  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters (OOCTXT* pctxt, H245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* h223LogicalChannelParameters */
         case 1:
            stat = asn1PE_H245H223LogicalChannelParameters (pctxt, pvalue->u.h223LogicalChannelParameters);
            if (stat != ASN_OK) return stat;
            break;

         /* v76LogicalChannelParameters */
         case 2:
            stat = asn1PE_H245V76LogicalChannelParameters (pctxt, pvalue->u.v76LogicalChannelParameters);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* h2250LogicalChannelParameters */
         case 3:
            stat = asn1PE_H245H2250LogicalChannelParameters (&lctxt, pvalue->u.h2250LogicalChannelParameters);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannel_reverseLogicalChannelParameters        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannel_reverseLogicalChannelParameters (OOCTXT* pctxt, H245OpenLogicalChannel_reverseLogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.reverseLogicalChannelDependencyPresent ||
   pvalue->m.replacementForPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.multiplexParametersPresent);

   /* encode dataType */

   stat = asn1PE_H245DataType (pctxt, &pvalue->dataType);
   if (stat != ASN_OK) return stat;

   /* encode multiplexParameters */

   if (pvalue->m.multiplexParametersPresent) {
      stat = asn1PE_H245OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters (pctxt, &pvalue->multiplexParameters);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 1);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.reverseLogicalChannelDependencyPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.replacementForPresent);
      /* encode extension elements */

      if (pvalue->m.reverseLogicalChannelDependencyPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245LogicalChannelNumber (&lctxt, pvalue->reverseLogicalChannelDependency);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.replacementForPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245LogicalChannelNumber (&lctxt, pvalue->replacementFor);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetworkAccessParameters_distribution                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NetworkAccessParameters_distribution (OOCTXT* pctxt, H245NetworkAccessParameters_distribution* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* unicast */
         case 1:
            /* NULL */
            break;

         /* multicast */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetworkAccessParameters_networkAddress                    */
/*                                                            */
/**************************************************************/

extern EXTERN const char* gs_MULTIMEDIA_SYSTEM_CONTROL_NetworkAccessParameters_networkAddress_e164Address_CharSet;

EXTERN int asn1PE_H245NetworkAccessParameters_networkAddress (OOCTXT* pctxt, H245NetworkAccessParameters_networkAddress* pvalue)
{
   static Asn1SizeCnst e164Address_lsize1 = { 0, 1, 128, 0 };
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* q2931Address */
         case 1:
            stat = asn1PE_H245Q2931Address (pctxt, pvalue->u.q2931Address);
            if (stat != ASN_OK) return stat;
            break;

         /* e164Address */
         case 2:
            addSizeConstraint (pctxt, &e164Address_lsize1);

            stat = encodeConstrainedStringEx (pctxt, pvalue->u.e164Address, gs_MULTIMEDIA_SYSTEM_CONTROL_NetworkAccessParameters_networkAddress_e164Address_CharSet, 4, 4, 7);
            if (stat != ASN_OK) return stat;
            break;

         /* localAreaAddress */
         case 3:
            stat = asn1PE_H245TransportAddress (pctxt, pvalue->u.localAreaAddress);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetworkAccessParameters_externalReference                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NetworkAccessParameters_externalReference (OOCTXT* pctxt, H245NetworkAccessParameters_externalReference* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 255, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetworkAccessParameters_t120SetupProcedure                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NetworkAccessParameters_t120SetupProcedure (OOCTXT* pctxt, H245NetworkAccessParameters_t120SetupProcedure* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* originateCall */
         case 1:
            /* NULL */
            break;

         /* waitForCall */
         case 2:
            /* NULL */
            break;

         /* issueQuery */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NetworkAccessParameters                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NetworkAccessParameters (OOCTXT* pctxt, H245NetworkAccessParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.t120SetupProcedurePresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.distributionPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.externalReferencePresent);

   /* encode distribution */

   if (pvalue->m.distributionPresent) {
      stat = asn1PE_H245NetworkAccessParameters_distribution (pctxt, &pvalue->distribution);
      if (stat != ASN_OK) return stat;
   }

   /* encode networkAddress */

   stat = asn1PE_H245NetworkAccessParameters_networkAddress (pctxt, &pvalue->networkAddress);
   if (stat != ASN_OK) return stat;

   /* encode associateConference */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->associateConference);
   if (stat != ASN_OK) return stat;

   /* encode externalReference */

   if (pvalue->m.externalReferencePresent) {
      stat = asn1PE_H245NetworkAccessParameters_externalReference (pctxt, &pvalue->externalReference);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.t120SetupProcedurePresent);
      /* encode extension elements */

      if (pvalue->m.t120SetupProcedurePresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245NetworkAccessParameters_t120SetupProcedure (&lctxt, &pvalue->t120SetupProcedure);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EscrowData_escrowValue                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EscrowData_escrowValue (OOCTXT* pctxt, H245EscrowData_escrowValue* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeBitString (pctxt, pvalue->numbits, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EscrowData                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EscrowData (OOCTXT* pctxt, H245EscrowData* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode escrowID */

   stat = encodeObjectIdentifier (pctxt, &pvalue->escrowID);
   if (stat != ASN_OK) return stat;

   /* encode escrowValue */

   stat = asn1PE_H245EscrowData_escrowValue (pctxt, &pvalue->escrowValue);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionSync_escrowentry                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EncryptionSync_escrowentry (OOCTXT* pctxt, H245EncryptionSync_escrowentry* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245EscrowData (pctxt, ((H245EscrowData*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionSync                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EncryptionSync (OOCTXT* pctxt, H245EncryptionSync* pvalue)
{
   static Asn1SizeCnst h235Key_lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.nonStandardPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.escrowentryPresent);

   /* encode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      stat = asn1PE_H245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;
   }

   /* encode synchFlag */

   stat = encodeConsUnsigned (pctxt, pvalue->synchFlag, 0U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode h235Key */

   addSizeConstraint (pctxt, &h235Key_lsize1);

   stat = encodeOctetString (pctxt, pvalue->h235Key.numocts, pvalue->h235Key.data);
   if (stat != ASN_OK) return stat;

   /* encode escrowentry */

   if (pvalue->m.escrowentryPresent) {
      stat = asn1PE_H245EncryptionSync_escrowentry (pctxt, &pvalue->escrowentry);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannel                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannel (OOCTXT* pctxt, H245OpenLogicalChannel* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.separateStackPresent ||
   pvalue->m.encryptionSyncPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.reverseLogicalChannelParametersPresent);

   /* encode forwardLogicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   /* encode forwardLogicalChannelParameters */

   stat = asn1PE_H245OpenLogicalChannel_forwardLogicalChannelParameters (pctxt, &pvalue->forwardLogicalChannelParameters);
   if (stat != ASN_OK) return stat;

   /* encode reverseLogicalChannelParameters */

   if (pvalue->m.reverseLogicalChannelParametersPresent) {
      stat = asn1PE_H245OpenLogicalChannel_reverseLogicalChannelParameters (pctxt, &pvalue->reverseLogicalChannelParameters);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 1);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.separateStackPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.encryptionSyncPresent);
      /* encode extension elements */

      if (pvalue->m.separateStackPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245NetworkAccessParameters (&lctxt, &pvalue->separateStack);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.encryptionSyncPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245EncryptionSync (&lctxt, &pvalue->encryptionSync);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CloseLogicalChannel_source                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CloseLogicalChannel_source (OOCTXT* pctxt, H245CloseLogicalChannel_source* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* user */
      case 1:
         /* NULL */
         break;

      /* lcse */
      case 2:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CloseLogicalChannel_reason                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CloseLogicalChannel_reason (OOCTXT* pctxt, H245CloseLogicalChannel_reason* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* unknown */
         case 1:
            /* NULL */
            break;

         /* reopen */
         case 2:
            /* NULL */
            break;

         /* reservationFailure */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CloseLogicalChannel                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CloseLogicalChannel (OOCTXT* pctxt, H245CloseLogicalChannel* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.reasonPresent);

   encodeBit (pctxt, extbit);

   /* encode forwardLogicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   /* encode source */

   stat = asn1PE_H245CloseLogicalChannel_source (pctxt, &pvalue->source);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.reasonPresent);
      /* encode extension elements */

      if (pvalue->m.reasonPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245CloseLogicalChannel_reason (&lctxt, &pvalue->reason);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestChannelClose_reason                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestChannelClose_reason (OOCTXT* pctxt, H245RequestChannelClose_reason* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* unknown */
         case 1:
            /* NULL */
            break;

         /* normal */
         case 2:
            /* NULL */
            break;

         /* reopen */
         case 3:
            /* NULL */
            break;

         /* reservationFailure */
         case 4:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestChannelClose                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestChannelClose (OOCTXT* pctxt, H245RequestChannelClose* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.qosCapabilityPresent ||
   pvalue->m.reasonPresent);

   encodeBit (pctxt, extbit);

   /* encode forwardLogicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 1);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.qosCapabilityPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.reasonPresent);
      /* encode extension elements */

      if (pvalue->m.qosCapabilityPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245QOSCapability (&lctxt, &pvalue->qosCapability);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.reasonPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245RequestChannelClose_reason (&lctxt, &pvalue->reason);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexTableEntryNumber                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexTableEntryNumber (OOCTXT* pctxt, H245MultiplexTableEntryNumber value)
{
   int stat = ASN_OK;

   stat = encodeConsUnsigned (pctxt, value, 1U, 15U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexElement_type_subElementList                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexElement_type_subElementList (OOCTXT* pctxt, H245MultiplexElement_type_subElementList* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 2, 255, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245MultiplexElement (pctxt, (H245MultiplexElement*)((H245MultiplexElement*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexElement_type                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexElement_type (OOCTXT* pctxt, H245MultiplexElement_type* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* logicalChannelNumber */
      case 1:
         stat = encodeConsUnsigned (pctxt, pvalue->u.logicalChannelNumber, 0U, 65535U);
         if (stat != ASN_OK) return stat;

         break;

      /* subElementList */
      case 2:
         stat = asn1PE_H245MultiplexElement_type_subElementList (pctxt, pvalue->u.subElementList);
         if (stat != ASN_OK) return stat;
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexElement_repeatCount                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexElement_repeatCount (OOCTXT* pctxt, H245MultiplexElement_repeatCount* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* finite */
      case 1:
         stat = encodeConsUnsigned (pctxt, pvalue->u.finite, 1U, 65535U);
         if (stat != ASN_OK) return stat;

         break;

      /* untilClosingFlag */
      case 2:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexElement                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexElement (OOCTXT* pctxt, H245MultiplexElement* pvalue)
{
   int stat = ASN_OK;

   /* encode type */

   stat = asn1PE_H245MultiplexElement_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   /* encode repeatCount */

   stat = asn1PE_H245MultiplexElement_repeatCount (pctxt, &pvalue->repeatCount);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntryDescriptor_elementList                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntryDescriptor_elementList (OOCTXT* pctxt, H245MultiplexEntryDescriptor_elementList* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245MultiplexElement (pctxt, ((H245MultiplexElement*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntryDescriptor                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntryDescriptor (OOCTXT* pctxt, H245MultiplexEntryDescriptor* pvalue)
{
   int stat = ASN_OK;

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.elementListPresent);

   /* encode multiplexTableEntryNumber */

   stat = asn1PE_H245MultiplexTableEntryNumber (pctxt, pvalue->multiplexTableEntryNumber);
   if (stat != ASN_OK) return stat;

   /* encode elementList */

   if (pvalue->m.elementListPresent) {
      stat = asn1PE_H245MultiplexEntryDescriptor_elementList (pctxt, &pvalue->elementList);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySend_multiplexEntryDescriptors              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntrySend_multiplexEntryDescriptors (OOCTXT* pctxt, H245MultiplexEntrySend_multiplexEntryDescriptors* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245MultiplexEntryDescriptor (pctxt, ((H245MultiplexEntryDescriptor*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySend                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntrySend (OOCTXT* pctxt, H245MultiplexEntrySend* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode multiplexEntryDescriptors */

   stat = asn1PE_H245MultiplexEntrySend_multiplexEntryDescriptors (pctxt, &pvalue->multiplexEntryDescriptors);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntry_entryNumbers                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMultiplexEntry_entryNumbers (OOCTXT* pctxt, H245RequestMultiplexEntry_entryNumbers* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = asn1PE_H245MultiplexTableEntryNumber (pctxt, pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntry                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMultiplexEntry (OOCTXT* pctxt, H245RequestMultiplexEntry* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode entryNumbers */

   stat = asn1PE_H245RequestMultiplexEntry_entryNumbers (pctxt, &pvalue->entryNumbers);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H261VideoMode_resolution                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H261VideoMode_resolution (OOCTXT* pctxt, H245H261VideoMode_resolution* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* qcif */
      case 1:
         /* NULL */
         break;

      /* cif */
      case 2:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H261VideoMode                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H261VideoMode (OOCTXT* pctxt, H245H261VideoMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode resolution */

   stat = asn1PE_H245H261VideoMode_resolution (pctxt, &pvalue->resolution);
   if (stat != ASN_OK) return stat;

   /* encode bitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->bitRate, 1U, 19200U);
   if (stat != ASN_OK) return stat;

   /* encode stillImageTransmission */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->stillImageTransmission);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H262VideoMode_profileAndLevel                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H262VideoMode_profileAndLevel (OOCTXT* pctxt, H245H262VideoMode_profileAndLevel* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 11);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 10);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* profileAndLevel_SPatML */
         case 1:
            /* NULL */
            break;

         /* profileAndLevel_MPatLL */
         case 2:
            /* NULL */
            break;

         /* profileAndLevel_MPatML */
         case 3:
            /* NULL */
            break;

         /* profileAndLevel_MPatH_14 */
         case 4:
            /* NULL */
            break;

         /* profileAndLevel_MPatHL */
         case 5:
            /* NULL */
            break;

         /* profileAndLevel_SNRatLL */
         case 6:
            /* NULL */
            break;

         /* profileAndLevel_SNRatML */
         case 7:
            /* NULL */
            break;

         /* profileAndLevel_SpatialatH_14 */
         case 8:
            /* NULL */
            break;

         /* profileAndLevel_HPatML */
         case 9:
            /* NULL */
            break;

         /* profileAndLevel_HPatH_14 */
         case 10:
            /* NULL */
            break;

         /* profileAndLevel_HPatHL */
         case 11:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 12);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H262VideoMode                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H262VideoMode (OOCTXT* pctxt, H245H262VideoMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.videoBitRatePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.vbvBufferSizePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.samplesPerLinePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.linesPerFramePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.framesPerSecondPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.luminanceSampleRatePresent);

   /* encode profileAndLevel */

   stat = asn1PE_H245H262VideoMode_profileAndLevel (pctxt, &pvalue->profileAndLevel);
   if (stat != ASN_OK) return stat;

   /* encode videoBitRate */

   if (pvalue->m.videoBitRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->videoBitRate, 0U, 1073741823U);
      if (stat != ASN_OK) return stat;

   }

   /* encode vbvBufferSize */

   if (pvalue->m.vbvBufferSizePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->vbvBufferSize, 0U, 262143U);
      if (stat != ASN_OK) return stat;

   }

   /* encode samplesPerLine */

   if (pvalue->m.samplesPerLinePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->samplesPerLine, 0U, 16383U);
      if (stat != ASN_OK) return stat;

   }

   /* encode linesPerFrame */

   if (pvalue->m.linesPerFramePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->linesPerFrame, 0U, 16383U);
      if (stat != ASN_OK) return stat;

   }

   /* encode framesPerSecond */

   if (pvalue->m.framesPerSecondPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->framesPerSecond, 0U, 15U);
      if (stat != ASN_OK) return stat;

   }

   /* encode luminanceSampleRate */

   if (pvalue->m.luminanceSampleRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->luminanceSampleRate, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263VideoMode_resolution                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H263VideoMode_resolution (OOCTXT* pctxt, H245H263VideoMode_resolution* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 5);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 4);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* sqcif */
         case 1:
            /* NULL */
            break;

         /* qcif */
         case 2:
            /* NULL */
            break;

         /* cif */
         case 3:
            /* NULL */
            break;

         /* cif4 */
         case 4:
            /* NULL */
            break;

         /* cif16 */
         case 5:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 6);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* custom */
         case 6:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H263VideoMode                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H263VideoMode (OOCTXT* pctxt, H245H263VideoMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.errorCompensationPresent ||
   pvalue->m.enhancementLayerInfoPresent ||
   pvalue->m.h263OptionsPresent);

   encodeBit (pctxt, extbit);

   /* encode resolution */

   stat = asn1PE_H245H263VideoMode_resolution (pctxt, &pvalue->resolution);
   if (stat != ASN_OK) return stat;

   /* encode bitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->bitRate, 1U, 19200U);
   if (stat != ASN_OK) return stat;

   /* encode unrestrictedVector */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->unrestrictedVector);
   if (stat != ASN_OK) return stat;

   /* encode arithmeticCoding */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->arithmeticCoding);
   if (stat != ASN_OK) return stat;

   /* encode advancedPrediction */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->advancedPrediction);
   if (stat != ASN_OK) return stat;

   /* encode pbFrames */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->pbFrames);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 2);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.errorCompensationPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.enhancementLayerInfoPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.h263OptionsPresent);
      /* encode extension elements */

      if (pvalue->m.errorCompensationPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->errorCompensation);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.enhancementLayerInfoPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245EnhancementLayerInfo (&lctxt, &pvalue->enhancementLayerInfo);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.h263OptionsPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245H263Options (&lctxt, &pvalue->h263Options);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172VideoMode                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS11172VideoMode (OOCTXT* pctxt, H245IS11172VideoMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.videoBitRatePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.vbvBufferSizePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.samplesPerLinePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.linesPerFramePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.pictureRatePresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.luminanceSampleRatePresent);

   /* encode constrainedBitstream */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->constrainedBitstream);
   if (stat != ASN_OK) return stat;

   /* encode videoBitRate */

   if (pvalue->m.videoBitRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->videoBitRate, 0U, 1073741823U);
      if (stat != ASN_OK) return stat;

   }

   /* encode vbvBufferSize */

   if (pvalue->m.vbvBufferSizePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->vbvBufferSize, 0U, 262143U);
      if (stat != ASN_OK) return stat;

   }

   /* encode samplesPerLine */

   if (pvalue->m.samplesPerLinePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->samplesPerLine, 0U, 16383U);
      if (stat != ASN_OK) return stat;

   }

   /* encode linesPerFrame */

   if (pvalue->m.linesPerFramePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->linesPerFrame, 0U, 16383U);
      if (stat != ASN_OK) return stat;

   }

   /* encode pictureRate */

   if (pvalue->m.pictureRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->pictureRate, 0U, 15U);
      if (stat != ASN_OK) return stat;

   }

   /* encode luminanceSampleRate */

   if (pvalue->m.luminanceSampleRatePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->luminanceSampleRate, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VideoMode                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VideoMode (OOCTXT* pctxt, H245VideoMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 5);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 4);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* h261VideoMode */
         case 2:
            stat = asn1PE_H245H261VideoMode (pctxt, pvalue->u.h261VideoMode);
            if (stat != ASN_OK) return stat;
            break;

         /* h262VideoMode */
         case 3:
            stat = asn1PE_H245H262VideoMode (pctxt, pvalue->u.h262VideoMode);
            if (stat != ASN_OK) return stat;
            break;

         /* h263VideoMode */
         case 4:
            stat = asn1PE_H245H263VideoMode (pctxt, pvalue->u.h263VideoMode);
            if (stat != ASN_OK) return stat;
            break;

         /* is11172VideoMode */
         case 5:
            stat = asn1PE_H245IS11172VideoMode (pctxt, pvalue->u.is11172VideoMode);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 6);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* genericVideoMode */
         case 6:
            stat = asn1PE_H245GenericCapability (&lctxt, pvalue->u.genericVideoMode);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioMode_g7231                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245AudioMode_g7231 (OOCTXT* pctxt, H245AudioMode_g7231* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* noSilenceSuppressionLowRate */
      case 1:
         /* NULL */
         break;

      /* noSilenceSuppressionHighRate */
      case 2:
         /* NULL */
         break;

      /* silenceSuppressionLowRate */
      case 3:
         /* NULL */
         break;

      /* silenceSuppressionHighRate */
      case 4:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172AudioMode_audioLayer                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS11172AudioMode_audioLayer (OOCTXT* pctxt, H245IS11172AudioMode_audioLayer* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* audioLayer1 */
      case 1:
         /* NULL */
         break;

      /* audioLayer2 */
      case 2:
         /* NULL */
         break;

      /* audioLayer3 */
      case 3:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172AudioMode_audioSampling                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS11172AudioMode_audioSampling (OOCTXT* pctxt, H245IS11172AudioMode_audioSampling* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* audioSampling32k */
      case 1:
         /* NULL */
         break;

      /* audioSampling44k1 */
      case 2:
         /* NULL */
         break;

      /* audioSampling48k */
      case 3:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172AudioMode_multichannelType                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS11172AudioMode_multichannelType (OOCTXT* pctxt, H245IS11172AudioMode_multichannelType* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* singleChannel */
      case 1:
         /* NULL */
         break;

      /* twoChannelStereo */
      case 2:
         /* NULL */
         break;

      /* twoChannelDual */
      case 3:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS11172AudioMode                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS11172AudioMode (OOCTXT* pctxt, H245IS11172AudioMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode audioLayer */

   stat = asn1PE_H245IS11172AudioMode_audioLayer (pctxt, &pvalue->audioLayer);
   if (stat != ASN_OK) return stat;

   /* encode audioSampling */

   stat = asn1PE_H245IS11172AudioMode_audioSampling (pctxt, &pvalue->audioSampling);
   if (stat != ASN_OK) return stat;

   /* encode multichannelType */

   stat = asn1PE_H245IS11172AudioMode_multichannelType (pctxt, &pvalue->multichannelType);
   if (stat != ASN_OK) return stat;

   /* encode bitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->bitRate, 1U, 448U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS13818AudioMode_audioLayer                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS13818AudioMode_audioLayer (OOCTXT* pctxt, H245IS13818AudioMode_audioLayer* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* audioLayer1 */
      case 1:
         /* NULL */
         break;

      /* audioLayer2 */
      case 2:
         /* NULL */
         break;

      /* audioLayer3 */
      case 3:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS13818AudioMode_audioSampling                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS13818AudioMode_audioSampling (OOCTXT* pctxt, H245IS13818AudioMode_audioSampling* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 5);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* audioSampling16k */
      case 1:
         /* NULL */
         break;

      /* audioSampling22k05 */
      case 2:
         /* NULL */
         break;

      /* audioSampling24k */
      case 3:
         /* NULL */
         break;

      /* audioSampling32k */
      case 4:
         /* NULL */
         break;

      /* audioSampling44k1 */
      case 5:
         /* NULL */
         break;

      /* audioSampling48k */
      case 6:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS13818AudioMode_multichannelType                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS13818AudioMode_multichannelType (OOCTXT* pctxt, H245IS13818AudioMode_multichannelType* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 9);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* singleChannel */
      case 1:
         /* NULL */
         break;

      /* twoChannelStereo */
      case 2:
         /* NULL */
         break;

      /* twoChannelDual */
      case 3:
         /* NULL */
         break;

      /* threeChannels2_1 */
      case 4:
         /* NULL */
         break;

      /* threeChannels3_0 */
      case 5:
         /* NULL */
         break;

      /* fourChannels2_0_2_0 */
      case 6:
         /* NULL */
         break;

      /* fourChannels2_2 */
      case 7:
         /* NULL */
         break;

      /* fourChannels3_1 */
      case 8:
         /* NULL */
         break;

      /* fiveChannels3_0_2_0 */
      case 9:
         /* NULL */
         break;

      /* fiveChannels3_2 */
      case 10:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IS13818AudioMode                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IS13818AudioMode (OOCTXT* pctxt, H245IS13818AudioMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode audioLayer */

   stat = asn1PE_H245IS13818AudioMode_audioLayer (pctxt, &pvalue->audioLayer);
   if (stat != ASN_OK) return stat;

   /* encode audioSampling */

   stat = asn1PE_H245IS13818AudioMode_audioSampling (pctxt, &pvalue->audioSampling);
   if (stat != ASN_OK) return stat;

   /* encode multichannelType */

   stat = asn1PE_H245IS13818AudioMode_multichannelType (pctxt, &pvalue->multichannelType);
   if (stat != ASN_OK) return stat;

   /* encode lowFrequencyEnhancement */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->lowFrequencyEnhancement);
   if (stat != ASN_OK) return stat;

   /* encode multilingual */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->multilingual);
   if (stat != ASN_OK) return stat;

   /* encode bitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->bitRate, 1U, 1130U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  G7231AnnexCMode_g723AnnexCAudioMode                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245G7231AnnexCMode_g723AnnexCAudioMode (OOCTXT* pctxt, H245G7231AnnexCMode_g723AnnexCAudioMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode highRateMode0 */

   stat = encodeConsUnsigned (pctxt, pvalue->highRateMode0, 27U, 78U);
   if (stat != ASN_OK) return stat;

   /* encode highRateMode1 */

   stat = encodeConsUnsigned (pctxt, pvalue->highRateMode1, 27U, 78U);
   if (stat != ASN_OK) return stat;

   /* encode lowRateMode0 */

   stat = encodeConsUnsigned (pctxt, pvalue->lowRateMode0, 23U, 66U);
   if (stat != ASN_OK) return stat;

   /* encode lowRateMode1 */

   stat = encodeConsUnsigned (pctxt, pvalue->lowRateMode1, 23U, 66U);
   if (stat != ASN_OK) return stat;

   /* encode sidMode0 */

   stat = encodeConsUnsigned (pctxt, pvalue->sidMode0, 6U, 17U);
   if (stat != ASN_OK) return stat;

   /* encode sidMode1 */

   stat = encodeConsUnsigned (pctxt, pvalue->sidMode1, 6U, 17U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  G7231AnnexCMode                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245G7231AnnexCMode (OOCTXT* pctxt, H245G7231AnnexCMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode maxAl_sduAudioFrames */

   stat = encodeConsUnsigned (pctxt, pvalue->maxAl_sduAudioFrames, 1U, 256U);
   if (stat != ASN_OK) return stat;

   /* encode silenceSuppression */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->silenceSuppression);
   if (stat != ASN_OK) return stat;

   /* encode g723AnnexCAudioMode */

   stat = asn1PE_H245G7231AnnexCMode_g723AnnexCAudioMode (pctxt, &pvalue->g723AnnexCAudioMode);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VBDMode                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VBDMode (OOCTXT* pctxt, H245VBDMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode type */

   stat = asn1PE_H245AudioMode (pctxt, (H245AudioMode*)pvalue->type);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AudioMode                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245AudioMode (OOCTXT* pctxt, H245AudioMode* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 14);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 13);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* g711Alaw64k */
         case 2:
            /* NULL */
            break;

         /* g711Alaw56k */
         case 3:
            /* NULL */
            break;

         /* g711Ulaw64k */
         case 4:
            /* NULL */
            break;

         /* g711Ulaw56k */
         case 5:
            /* NULL */
            break;

         /* g722_64k */
         case 6:
            /* NULL */
            break;

         /* g722_56k */
         case 7:
            /* NULL */
            break;

         /* g722_48k */
         case 8:
            /* NULL */
            break;

         /* g728 */
         case 9:
            /* NULL */
            break;

         /* g729 */
         case 10:
            /* NULL */
            break;

         /* g729AnnexA */
         case 11:
            /* NULL */
            break;

         /* g7231 */
         case 12:
            stat = asn1PE_H245AudioMode_g7231 (pctxt, pvalue->u.g7231);
            if (stat != ASN_OK) return stat;
            break;

         /* is11172AudioMode */
         case 13:
            stat = asn1PE_H245IS11172AudioMode (pctxt, pvalue->u.is11172AudioMode);
            if (stat != ASN_OK) return stat;
            break;

         /* is13818AudioMode */
         case 14:
            stat = asn1PE_H245IS13818AudioMode (pctxt, pvalue->u.is13818AudioMode);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 15);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* g729wAnnexB */
         case 15:
            stat = encodeConsUnsigned (&lctxt, pvalue->u.g729wAnnexB, 1U, 256U);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;

            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* g729AnnexAwAnnexB */
         case 16:
            stat = encodeConsUnsigned (&lctxt, pvalue->u.g729AnnexAwAnnexB, 1U, 256U);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;

            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* g7231AnnexCMode */
         case 17:
            stat = asn1PE_H245G7231AnnexCMode (&lctxt, pvalue->u.g7231AnnexCMode);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* gsmFullRate */
         case 18:
            stat = asn1PE_H245GSMAudioCapability (&lctxt, pvalue->u.gsmFullRate);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* gsmHalfRate */
         case 19:
            stat = asn1PE_H245GSMAudioCapability (&lctxt, pvalue->u.gsmHalfRate);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* gsmEnhancedFullRate */
         case 20:
            stat = asn1PE_H245GSMAudioCapability (&lctxt, pvalue->u.gsmEnhancedFullRate);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* genericAudioMode */
         case 21:
            stat = asn1PE_H245GenericCapability (&lctxt, pvalue->u.genericAudioMode);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* g729Extensions */
         case 22:
            stat = asn1PE_H245G729Extensions (&lctxt, pvalue->u.g729Extensions);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* vbd */
         case 23:
            stat = asn1PE_H245VBDMode (&lctxt, pvalue->u.vbd);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataMode_application_nlpid                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataMode_application_nlpid (OOCTXT* pctxt, H245DataMode_application_nlpid* pvalue)
{
   int stat = ASN_OK;

   /* encode nlpidProtocol */

   stat = asn1PE_H245DataProtocolCapability (pctxt, &pvalue->nlpidProtocol);
   if (stat != ASN_OK) return stat;

   /* encode nlpidData */

   stat = encodeOctetString (pctxt, pvalue->nlpidData.numocts, pvalue->nlpidData.data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataMode_application_t38fax                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataMode_application_t38fax (OOCTXT* pctxt, H245DataMode_application_t38fax* pvalue)
{
   int stat = ASN_OK;

   /* encode t38FaxProtocol */

   stat = asn1PE_H245DataProtocolCapability (pctxt, &pvalue->t38FaxProtocol);
   if (stat != ASN_OK) return stat;

   /* encode t38FaxProfile */

   stat = asn1PE_H245T38FaxProfile (pctxt, &pvalue->t38FaxProfile);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataMode_application                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataMode_application (OOCTXT* pctxt, H245DataMode_application* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 10);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 9);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* t120 */
         case 2:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.t120);
            if (stat != ASN_OK) return stat;
            break;

         /* dsm_cc */
         case 3:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.dsm_cc);
            if (stat != ASN_OK) return stat;
            break;

         /* userData */
         case 4:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.userData);
            if (stat != ASN_OK) return stat;
            break;

         /* t84 */
         case 5:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.t84);
            if (stat != ASN_OK) return stat;
            break;

         /* t434 */
         case 6:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.t434);
            if (stat != ASN_OK) return stat;
            break;

         /* h224 */
         case 7:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.h224);
            if (stat != ASN_OK) return stat;
            break;

         /* nlpid */
         case 8:
            stat = asn1PE_H245DataMode_application_nlpid (pctxt, pvalue->u.nlpid);
            if (stat != ASN_OK) return stat;
            break;

         /* dsvdControl */
         case 9:
            /* NULL */
            break;

         /* h222DataPartitioning */
         case 10:
            stat = asn1PE_H245DataProtocolCapability (pctxt, pvalue->u.h222DataPartitioning);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 11);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* t30fax */
         case 11:
            stat = asn1PE_H245DataProtocolCapability (&lctxt, pvalue->u.t30fax);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* t140 */
         case 12:
            stat = asn1PE_H245DataProtocolCapability (&lctxt, pvalue->u.t140);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* t38fax */
         case 13:
            stat = asn1PE_H245DataMode_application_t38fax (&lctxt, pvalue->u.t38fax);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* genericDataMode */
         case 14:
            stat = asn1PE_H245GenericCapability (&lctxt, pvalue->u.genericDataMode);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DataMode                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DataMode (OOCTXT* pctxt, H245DataMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode application */

   stat = asn1PE_H245DataMode_application (pctxt, &pvalue->application);
   if (stat != ASN_OK) return stat;

   /* encode bitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->bitRate, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H235Mode_mediaMode                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H235Mode_mediaMode (OOCTXT* pctxt, H245H235Mode_mediaMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* videoMode */
         case 2:
            stat = asn1PE_H245VideoMode (pctxt, pvalue->u.videoMode);
            if (stat != ASN_OK) return stat;
            break;

         /* audioMode */
         case 3:
            stat = asn1PE_H245AudioMode (pctxt, pvalue->u.audioMode);
            if (stat != ASN_OK) return stat;
            break;

         /* dataMode */
         case 4:
            stat = asn1PE_H245DataMode (pctxt, pvalue->u.dataMode);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H235Mode                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H235Mode (OOCTXT* pctxt, H245H235Mode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode encryptionAuthenticationAndIntegrity */

   stat = asn1PE_H245EncryptionAuthenticationAndIntegrity (pctxt, &pvalue->encryptionAuthenticationAndIntegrity);
   if (stat != ASN_OK) return stat;

   /* encode mediaMode */

   stat = asn1PE_H245H235Mode_mediaMode (pctxt, &pvalue->mediaMode);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingDTModeElement_type                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RedundancyEncodingDTModeElement_type (OOCTXT* pctxt, H245RedundancyEncodingDTModeElement_type* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 6);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 5);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* videoMode */
         case 2:
            stat = asn1PE_H245VideoMode (pctxt, pvalue->u.videoMode);
            if (stat != ASN_OK) return stat;
            break;

         /* audioMode */
         case 3:
            stat = asn1PE_H245AudioMode (pctxt, pvalue->u.audioMode);
            if (stat != ASN_OK) return stat;
            break;

         /* dataMode */
         case 4:
            stat = asn1PE_H245DataMode (pctxt, pvalue->u.dataMode);
            if (stat != ASN_OK) return stat;
            break;

         /* encryptionMode */
         case 5:
            stat = asn1PE_H245EncryptionMode (pctxt, pvalue->u.encryptionMode);
            if (stat != ASN_OK) return stat;
            break;

         /* h235Mode */
         case 6:
            stat = asn1PE_H245H235Mode (pctxt, pvalue->u.h235Mode);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 7);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingDTModeElement                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RedundancyEncodingDTModeElement (OOCTXT* pctxt, H245RedundancyEncodingDTModeElement* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode type */

   stat = asn1PE_H245RedundancyEncodingDTModeElement_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245RedundancyEncodingDTModeElement                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245RedundancyEncodingDTModeElement (OOCTXT* pctxt, H245_SeqOfH245RedundancyEncodingDTModeElement* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245RedundancyEncodingDTModeElement (pctxt, ((H245RedundancyEncodingDTModeElement*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingDTMode                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RedundancyEncodingDTMode (OOCTXT* pctxt, H245RedundancyEncodingDTMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode redundancyEncodingMethod */

   stat = asn1PE_H245RedundancyEncodingMethod (pctxt, &pvalue->redundancyEncodingMethod);
   if (stat != ASN_OK) return stat;

   /* encode primary */

   stat = asn1PE_H245RedundancyEncodingDTModeElement (pctxt, &pvalue->primary);
   if (stat != ASN_OK) return stat;

   /* encode secondary */

   stat = asn1PE_H245_SeqOfH245RedundancyEncodingDTModeElement (pctxt, &pvalue->secondary);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStreamElementMode                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplePayloadStreamElementMode (OOCTXT* pctxt, H245MultiplePayloadStreamElementMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode type */

   stat = asn1PE_H245ModeElementType (pctxt, (H245ModeElementType*)pvalue->type);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245MultiplePayloadStreamElementMode                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245MultiplePayloadStreamElementMode (OOCTXT* pctxt, H245_SeqOfH245MultiplePayloadStreamElementMode* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245MultiplePayloadStreamElementMode (pctxt, ((H245MultiplePayloadStreamElementMode*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplePayloadStreamMode                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplePayloadStreamMode (OOCTXT* pctxt, H245MultiplePayloadStreamMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode elements */

   stat = asn1PE_H245_SeqOfH245MultiplePayloadStreamElementMode (pctxt, &pvalue->elements);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode_rfc2733Mode_mode_separateStream_differentPort     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECMode_rfc2733Mode_mode_separateStream_differentPort (OOCTXT* pctxt, H245FECMode_rfc2733Mode_mode_separateStream_differentPort* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.protectedPayloadTypePresent);

   /* encode protectedSessionID */

   stat = encodeConsUnsigned (pctxt, pvalue->protectedSessionID, 1U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode protectedPayloadType */

   if (pvalue->m.protectedPayloadTypePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->protectedPayloadType, 0U, 127U);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode_rfc2733Mode_mode_separateStream_samePort          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECMode_rfc2733Mode_mode_separateStream_samePort (OOCTXT* pctxt, H245FECMode_rfc2733Mode_mode_separateStream_samePort* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode protectedType */

   stat = asn1PE_H245ModeElementType (pctxt, (H245ModeElementType*)pvalue->protectedType);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode_rfc2733Mode_mode_separateStream                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECMode_rfc2733Mode_mode_separateStream (OOCTXT* pctxt, H245FECMode_rfc2733Mode_mode_separateStream* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* differentPort */
         case 1:
            stat = asn1PE_H245FECMode_rfc2733Mode_mode_separateStream_differentPort (pctxt, pvalue->u.differentPort);
            if (stat != ASN_OK) return stat;
            break;

         /* samePort */
         case 2:
            stat = asn1PE_H245FECMode_rfc2733Mode_mode_separateStream_samePort (pctxt, pvalue->u.samePort);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode_rfc2733Mode_mode                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECMode_rfc2733Mode_mode (OOCTXT* pctxt, H245FECMode_rfc2733Mode_mode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* redundancyEncoding */
         case 1:
            /* NULL */
            break;

         /* separateStream */
         case 2:
            stat = asn1PE_H245FECMode_rfc2733Mode_mode_separateStream (pctxt, pvalue->u.separateStream);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode_rfc2733Mode                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECMode_rfc2733Mode (OOCTXT* pctxt, H245FECMode_rfc2733Mode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode mode */

   stat = asn1PE_H245FECMode_rfc2733Mode_mode (pctxt, &pvalue->mode);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FECMode                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FECMode (OOCTXT* pctxt, H245FECMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 1);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* rfc2733Mode */
         case 1:
            stat = asn1PE_H245FECMode_rfc2733Mode (pctxt, pvalue->u.rfc2733Mode);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 2);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ModeElementType                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ModeElementType (OOCTXT* pctxt, H245ModeElementType* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 5);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 4);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* videoMode */
         case 2:
            stat = asn1PE_H245VideoMode (pctxt, pvalue->u.videoMode);
            if (stat != ASN_OK) return stat;
            break;

         /* audioMode */
         case 3:
            stat = asn1PE_H245AudioMode (pctxt, pvalue->u.audioMode);
            if (stat != ASN_OK) return stat;
            break;

         /* dataMode */
         case 4:
            stat = asn1PE_H245DataMode (pctxt, pvalue->u.dataMode);
            if (stat != ASN_OK) return stat;
            break;

         /* encryptionMode */
         case 5:
            stat = asn1PE_H245EncryptionMode (pctxt, pvalue->u.encryptionMode);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 6);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* h235Mode */
         case 6:
            stat = asn1PE_H245H235Mode (&lctxt, pvalue->u.h235Mode);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* multiplexedStreamMode */
         case 7:
            stat = asn1PE_H245MultiplexedStreamParameter (&lctxt, pvalue->u.multiplexedStreamMode);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* redundancyEncodingDTMode */
         case 8:
            stat = asn1PE_H245RedundancyEncodingDTMode (&lctxt, pvalue->u.redundancyEncodingDTMode);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* multiplePayloadStreamMode */
         case 9:
            stat = asn1PE_H245MultiplePayloadStreamMode (&lctxt, pvalue->u.multiplePayloadStreamMode);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* fecMode */
         case 10:
            stat = asn1PE_H245FECMode (&lctxt, pvalue->u.fecMode);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223ModeParameters_adaptationLayerType_al3                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223ModeParameters_adaptationLayerType_al3 (OOCTXT* pctxt, H245H223ModeParameters_adaptationLayerType_al3* pvalue)
{
   int stat = ASN_OK;

   /* encode controlFieldOctets */

   stat = encodeConsUnsigned (pctxt, pvalue->controlFieldOctets, 0U, 2U);
   if (stat != ASN_OK) return stat;

   /* encode sendBufferSize */

   stat = encodeConsUnsigned (pctxt, pvalue->sendBufferSize, 0U, 16777215U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223ModeParameters_adaptationLayerType                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223ModeParameters_adaptationLayerType (OOCTXT* pctxt, H245H223ModeParameters_adaptationLayerType* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 6);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 5);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* al1Framed */
         case 2:
            /* NULL */
            break;

         /* al1NotFramed */
         case 3:
            /* NULL */
            break;

         /* al2WithoutSequenceNumbers */
         case 4:
            /* NULL */
            break;

         /* al2WithSequenceNumbers */
         case 5:
            /* NULL */
            break;

         /* al3 */
         case 6:
            stat = asn1PE_H245H223ModeParameters_adaptationLayerType_al3 (pctxt, pvalue->u.al3);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 7);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* al1M */
         case 7:
            stat = asn1PE_H245H223AL1MParameters (&lctxt, pvalue->u.al1M);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* al2M */
         case 8:
            stat = asn1PE_H245H223AL2MParameters (&lctxt, pvalue->u.al2M);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* al3M */
         case 9:
            stat = asn1PE_H245H223AL3MParameters (&lctxt, pvalue->u.al3M);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223ModeParameters                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223ModeParameters (OOCTXT* pctxt, H245H223ModeParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode adaptationLayerType */

   stat = asn1PE_H245H223ModeParameters_adaptationLayerType (pctxt, &pvalue->adaptationLayerType);
   if (stat != ASN_OK) return stat;

   /* encode segmentableFlag */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->segmentableFlag);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  V76ModeParameters                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245V76ModeParameters (OOCTXT* pctxt, H245V76ModeParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* suspendResumewAddress */
         case 1:
            /* NULL */
            break;

         /* suspendResumewoAddress */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingMode_secondaryEncoding                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RedundancyEncodingMode_secondaryEncoding (OOCTXT* pctxt, H245RedundancyEncodingMode_secondaryEncoding* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* audioData */
         case 2:
            stat = asn1PE_H245AudioMode (pctxt, pvalue->u.audioData);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RedundancyEncodingMode                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RedundancyEncodingMode (OOCTXT* pctxt, H245RedundancyEncodingMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.secondaryEncodingPresent);

   /* encode redundancyEncodingMethod */

   stat = asn1PE_H245RedundancyEncodingMethod (pctxt, &pvalue->redundancyEncodingMethod);
   if (stat != ASN_OK) return stat;

   /* encode secondaryEncoding */

   if (pvalue->m.secondaryEncodingPresent) {
      stat = asn1PE_H245RedundancyEncodingMode_secondaryEncoding (pctxt, &pvalue->secondaryEncoding);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250ModeParameters                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H2250ModeParameters (OOCTXT* pctxt, H245H2250ModeParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.redundancyEncodingModePresent);

   /* encode redundancyEncodingMode */

   if (pvalue->m.redundancyEncodingModePresent) {
      stat = asn1PE_H245RedundancyEncodingMode (pctxt, &pvalue->redundancyEncodingMode);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexedStreamModeParameters                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexedStreamModeParameters (OOCTXT* pctxt, H245MultiplexedStreamModeParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode logicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ModeElement                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ModeElement (OOCTXT* pctxt, H245ModeElement* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.v76ModeParametersPresent ||
   pvalue->m.h2250ModeParametersPresent ||
   pvalue->m.genericModeParametersPresent ||
   pvalue->m.multiplexedStreamModeParametersPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.h223ModeParametersPresent);

   /* encode type */

   stat = asn1PE_H245ModeElementType (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   /* encode h223ModeParameters */

   if (pvalue->m.h223ModeParametersPresent) {
      stat = asn1PE_H245H223ModeParameters (pctxt, &pvalue->h223ModeParameters);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 3);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.v76ModeParametersPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.h2250ModeParametersPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.genericModeParametersPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.multiplexedStreamModeParametersPresent);
      /* encode extension elements */

      if (pvalue->m.v76ModeParametersPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245V76ModeParameters (&lctxt, &pvalue->v76ModeParameters);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.h2250ModeParametersPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245H2250ModeParameters (&lctxt, &pvalue->h2250ModeParameters);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.genericModeParametersPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245GenericCapability (&lctxt, &pvalue->genericModeParameters);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.multiplexedStreamModeParametersPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245MultiplexedStreamModeParameters (&lctxt, &pvalue->multiplexedStreamModeParameters);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ModeDescription                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ModeDescription (OOCTXT* pctxt, H245ModeDescription* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245ModeElement (pctxt, ((H245ModeElement*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMode_requestedModes                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMode_requestedModes (OOCTXT* pctxt, H245RequestMode_requestedModes* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245ModeDescription (pctxt, ((H245ModeDescription*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMode                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMode (OOCTXT* pctxt, H245RequestMode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode requestedModes */

   stat = asn1PE_H245RequestMode_requestedModes (pctxt, &pvalue->requestedModes);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RoundTripDelayRequest                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RoundTripDelayRequest (OOCTXT* pctxt, H245RoundTripDelayRequest* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopRequest_type                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MaintenanceLoopRequest_type (OOCTXT* pctxt, H245MaintenanceLoopRequest_type* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* systemLoop */
         case 1:
            /* NULL */
            break;

         /* mediaLoop */
         case 2:
            stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->u.mediaLoop);
            if (stat != ASN_OK) return stat;
            break;

         /* logicalChannelLoop */
         case 3:
            stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->u.logicalChannelLoop);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopRequest                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MaintenanceLoopRequest (OOCTXT* pctxt, H245MaintenanceLoopRequest* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode type */

   stat = asn1PE_H245MaintenanceLoopRequest_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeRequest                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CommunicationModeRequest (OOCTXT* pctxt, H245CommunicationModeRequest* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Criteria                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245Criteria (OOCTXT* pctxt, H245Criteria* pvalue)
{
   static Asn1SizeCnst value_lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode field */

   stat = encodeObjectIdentifier (pctxt, &pvalue->field);
   if (stat != ASN_OK) return stat;

   /* encode value */

   addSizeConstraint (pctxt, &value_lsize1);

   stat = encodeOctetString (pctxt, pvalue->value.numocts, pvalue->value.data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CertSelectionCriteria                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CertSelectionCriteria (OOCTXT* pctxt, H245CertSelectionCriteria* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 16, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245Criteria (pctxt, ((H245Criteria*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceRequest_requestTerminalCertificate              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceRequest_requestTerminalCertificate (OOCTXT* pctxt, H245ConferenceRequest_requestTerminalCertificate* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.terminalLabelPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.certSelectionCriteriaPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.sRandomPresent);

   /* encode terminalLabel */

   if (pvalue->m.terminalLabelPresent) {
      stat = asn1PE_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
      if (stat != ASN_OK) return stat;
   }

   /* encode certSelectionCriteria */

   if (pvalue->m.certSelectionCriteriaPresent) {
      stat = asn1PE_H245CertSelectionCriteria (pctxt, &pvalue->certSelectionCriteria);
      if (stat != ASN_OK) return stat;
   }

   /* encode sRandom */

   if (pvalue->m.sRandomPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->sRandom, 1U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RemoteMCRequest                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RemoteMCRequest (OOCTXT* pctxt, H245RemoteMCRequest* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* masterActivate */
         case 1:
            /* NULL */
            break;

         /* slaveActivate */
         case 2:
            /* NULL */
            break;

         /* deActivate */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceRequest                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceRequest (OOCTXT* pctxt, H245ConferenceRequest* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 8);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 7);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* terminalListRequest */
         case 1:
            /* NULL */
            break;

         /* makeMeChair */
         case 2:
            /* NULL */
            break;

         /* cancelMakeMeChair */
         case 3:
            /* NULL */
            break;

         /* dropTerminal */
         case 4:
            stat = asn1PE_H245TerminalLabel (pctxt, pvalue->u.dropTerminal);
            if (stat != ASN_OK) return stat;
            break;

         /* requestTerminalID */
         case 5:
            stat = asn1PE_H245TerminalLabel (pctxt, pvalue->u.requestTerminalID);
            if (stat != ASN_OK) return stat;
            break;

         /* enterH243Password */
         case 6:
            /* NULL */
            break;

         /* enterH243TerminalID */
         case 7:
            /* NULL */
            break;

         /* enterH243ConferenceID */
         case 8:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 9);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* enterExtensionAddress */
         case 9:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* requestChairTokenOwner */
         case 10:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* requestTerminalCertificate */
         case 11:
            stat = asn1PE_H245ConferenceRequest_requestTerminalCertificate (&lctxt, pvalue->u.requestTerminalCertificate);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* broadcastMyLogicalChannel */
         case 12:
            stat = asn1PE_H245LogicalChannelNumber (&lctxt, pvalue->u.broadcastMyLogicalChannel);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* makeTerminalBroadcaster */
         case 13:
            stat = asn1PE_H245TerminalLabel (&lctxt, pvalue->u.makeTerminalBroadcaster);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* sendThisSource */
         case 14:
            stat = asn1PE_H245TerminalLabel (&lctxt, pvalue->u.sendThisSource);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* requestAllTerminalIDs */
         case 15:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* remoteMCRequest */
         case 16:
            stat = asn1PE_H245RemoteMCRequest (&lctxt, pvalue->u.remoteMCRequest);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest_callInformation                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkRequest_callInformation (OOCTXT* pctxt, H245MultilinkRequest_callInformation* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode maxNumberOfAdditionalConnections */

   stat = encodeConsUnsigned (pctxt, pvalue->maxNumberOfAdditionalConnections, 1U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DialingInformationNetworkType                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DialingInformationNetworkType (OOCTXT* pctxt, H245DialingInformationNetworkType* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* n_isdn */
         case 2:
            /* NULL */
            break;

         /* gstn */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* mobile */
         case 4:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DialingInformationNumber_networkType                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DialingInformationNumber_networkType (OOCTXT* pctxt, H245DialingInformationNumber_networkType* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 255, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245DialingInformationNetworkType (pctxt, ((H245DialingInformationNetworkType*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DialingInformationNumber                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DialingInformationNumber (OOCTXT* pctxt, H245DialingInformationNumber* pvalue)
{
   static Asn1SizeCnst networkAddress_lsize1 = { 0, 0, 40, 0 };
   static Asn1SizeCnst subAddress_lsize1 = { 0, 1, 40, 0 };
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.subAddressPresent);

   /* encode networkAddress */

   addSizeConstraint (pctxt, &networkAddress_lsize1);

   stat = encodeConstrainedStringEx (pctxt, pvalue->networkAddress, NUM_CANSET, 4, 4, 4);
   if (stat != ASN_OK) return stat;

   /* encode subAddress */

   if (pvalue->m.subAddressPresent) {
      addSizeConstraint (pctxt, &subAddress_lsize1);

      stat = encodeConstrainedStringEx (pctxt, pvalue->subAddress, 0, 8, 7, 7);
      if (stat != ASN_OK) return stat;
   }

   /* encode networkType */

   stat = asn1PE_H245DialingInformationNumber_networkType (pctxt, &pvalue->networkType);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DialingInformation_differential                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DialingInformation_differential (OOCTXT* pctxt, H245DialingInformation_differential* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245DialingInformationNumber (pctxt, ((H245DialingInformationNumber*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DialingInformation                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245DialingInformation (OOCTXT* pctxt, H245DialingInformation* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* differential */
         case 2:
            stat = asn1PE_H245DialingInformation_differential (pctxt, pvalue->u.differential);
            if (stat != ASN_OK) return stat;
            break;

         /* infoNotAvailable */
         case 3:
            stat = encodeConsUnsigned (pctxt, pvalue->u.infoNotAvailable, 1U, 65535U);
            if (stat != ASN_OK) return stat;

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest_addConnection                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkRequest_addConnection (OOCTXT* pctxt, H245MultilinkRequest_addConnection* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode dialingInformation */

   stat = asn1PE_H245DialingInformation (pctxt, &pvalue->dialingInformation);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConnectionIdentifier                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConnectionIdentifier (OOCTXT* pctxt, H245ConnectionIdentifier* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode channelTag */

   stat = encodeConsUnsigned (pctxt, pvalue->channelTag, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;

   /* encode sequenceNumber */

   stat = encodeConsUnsigned (pctxt, pvalue->sequenceNumber, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest_removeConnection                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkRequest_removeConnection (OOCTXT* pctxt, H245MultilinkRequest_removeConnection* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode connectionIdentifier */

   stat = asn1PE_H245ConnectionIdentifier (pctxt, &pvalue->connectionIdentifier);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest_maximumHeaderInterval_requestType        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkRequest_maximumHeaderInterval_requestType (OOCTXT* pctxt, H245MultilinkRequest_maximumHeaderInterval_requestType* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* currentIntervalInformation */
         case 1:
            /* NULL */
            break;

         /* requestedInterval */
         case 2:
            stat = encodeConsUnsigned (pctxt, pvalue->u.requestedInterval, 0U, 65535U);
            if (stat != ASN_OK) return stat;

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest_maximumHeaderInterval                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkRequest_maximumHeaderInterval (OOCTXT* pctxt, H245MultilinkRequest_maximumHeaderInterval* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode requestType */

   stat = asn1PE_H245MultilinkRequest_maximumHeaderInterval_requestType (pctxt, &pvalue->requestType);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkRequest                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkRequest (OOCTXT* pctxt, H245MultilinkRequest* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 5);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 4);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* callInformation */
         case 2:
            stat = asn1PE_H245MultilinkRequest_callInformation (pctxt, pvalue->u.callInformation);
            if (stat != ASN_OK) return stat;
            break;

         /* addConnection */
         case 3:
            stat = asn1PE_H245MultilinkRequest_addConnection (pctxt, pvalue->u.addConnection);
            if (stat != ASN_OK) return stat;
            break;

         /* removeConnection */
         case 4:
            stat = asn1PE_H245MultilinkRequest_removeConnection (pctxt, pvalue->u.removeConnection);
            if (stat != ASN_OK) return stat;
            break;

         /* maximumHeaderInterval */
         case 5:
            stat = asn1PE_H245MultilinkRequest_maximumHeaderInterval (pctxt, pvalue->u.maximumHeaderInterval);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 6);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaximumBitRate                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MaximumBitRate (OOCTXT* pctxt, H245MaximumBitRate value)
{
   int stat = ASN_OK;

   stat = encodeConsUnsigned (pctxt, value, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LogicalChannelRateRequest                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245LogicalChannelRateRequest (OOCTXT* pctxt, H245LogicalChannelRateRequest* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode logicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   /* encode maximumBitRate */

   stat = asn1PE_H245MaximumBitRate (pctxt, pvalue->maximumBitRate);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMessage                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMessage (OOCTXT* pctxt, H245RequestMessage* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 11);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 10);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* masterSlaveDetermination */
         case 2:
            stat = asn1PE_H245MasterSlaveDetermination (pctxt, pvalue->u.masterSlaveDetermination);
            if (stat != ASN_OK) return stat;
            break;

         /* terminalCapabilitySet */
         case 3:
            stat = asn1PE_H245TerminalCapabilitySet (pctxt, pvalue->u.terminalCapabilitySet);
            if (stat != ASN_OK) return stat;
            break;

         /* openLogicalChannel */
         case 4:
            stat = asn1PE_H245OpenLogicalChannel (pctxt, pvalue->u.openLogicalChannel);
            if (stat != ASN_OK) return stat;
            break;

         /* closeLogicalChannel */
         case 5:
            stat = asn1PE_H245CloseLogicalChannel (pctxt, pvalue->u.closeLogicalChannel);
            if (stat != ASN_OK) return stat;
            break;

         /* requestChannelClose */
         case 6:
            stat = asn1PE_H245RequestChannelClose (pctxt, pvalue->u.requestChannelClose);
            if (stat != ASN_OK) return stat;
            break;

         /* multiplexEntrySend */
         case 7:
            stat = asn1PE_H245MultiplexEntrySend (pctxt, pvalue->u.multiplexEntrySend);
            if (stat != ASN_OK) return stat;
            break;

         /* requestMultiplexEntry */
         case 8:
            stat = asn1PE_H245RequestMultiplexEntry (pctxt, pvalue->u.requestMultiplexEntry);
            if (stat != ASN_OK) return stat;
            break;

         /* requestMode */
         case 9:
            stat = asn1PE_H245RequestMode (pctxt, pvalue->u.requestMode);
            if (stat != ASN_OK) return stat;
            break;

         /* roundTripDelayRequest */
         case 10:
            stat = asn1PE_H245RoundTripDelayRequest (pctxt, pvalue->u.roundTripDelayRequest);
            if (stat != ASN_OK) return stat;
            break;

         /* maintenanceLoopRequest */
         case 11:
            stat = asn1PE_H245MaintenanceLoopRequest (pctxt, pvalue->u.maintenanceLoopRequest);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 12);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* communicationModeRequest */
         case 12:
            stat = asn1PE_H245CommunicationModeRequest (&lctxt, pvalue->u.communicationModeRequest);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* conferenceRequest */
         case 13:
            stat = asn1PE_H245ConferenceRequest (&lctxt, pvalue->u.conferenceRequest);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* multilinkRequest */
         case 14:
            stat = asn1PE_H245MultilinkRequest (&lctxt, pvalue->u.multilinkRequest);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* logicalChannelRateRequest */
         case 15:
            stat = asn1PE_H245LogicalChannelRateRequest (&lctxt, pvalue->u.logicalChannelRateRequest);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MasterSlaveDeterminationAck_decision                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MasterSlaveDeterminationAck_decision (OOCTXT* pctxt, H245MasterSlaveDeterminationAck_decision* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* master */
      case 1:
         /* NULL */
         break;

      /* slave */
      case 2:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MasterSlaveDeterminationAck                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MasterSlaveDeterminationAck (OOCTXT* pctxt, H245MasterSlaveDeterminationAck* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode decision */

   stat = asn1PE_H245MasterSlaveDeterminationAck_decision (pctxt, &pvalue->decision);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MasterSlaveDeterminationReject_cause                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MasterSlaveDeterminationReject_cause (OOCTXT* pctxt, H245MasterSlaveDeterminationReject_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 1);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* identicalNumbers */
         case 1:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 2);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MasterSlaveDeterminationReject                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MasterSlaveDeterminationReject (OOCTXT* pctxt, H245MasterSlaveDeterminationReject* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode cause */

   stat = asn1PE_H245MasterSlaveDeterminationReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySetAck                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalCapabilitySetAck (OOCTXT* pctxt, H245TerminalCapabilitySetAck* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySetReject_cause_tableEntryCapacityExce  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded (OOCTXT* pctxt, H245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* highestEntryNumberProcessed */
      case 1:
         stat = asn1PE_H245CapabilityTableEntryNumber (pctxt, pvalue->u.highestEntryNumberProcessed);
         if (stat != ASN_OK) return stat;
         break;

      /* noneProcessed */
      case 2:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySetReject_cause                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalCapabilitySetReject_cause (OOCTXT* pctxt, H245TerminalCapabilitySetReject_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* unspecified */
         case 1:
            /* NULL */
            break;

         /* undefinedTableEntryUsed */
         case 2:
            /* NULL */
            break;

         /* descriptorCapacityExceeded */
         case 3:
            /* NULL */
            break;

         /* tableEntryCapacityExceeded */
         case 4:
            stat = asn1PE_H245TerminalCapabilitySetReject_cause_tableEntryCapacityExceeded (pctxt, pvalue->u.tableEntryCapacityExceeded);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySetReject                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalCapabilitySetReject (OOCTXT* pctxt, H245TerminalCapabilitySetReject* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode cause */

   stat = asn1PE_H245TerminalCapabilitySetReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelAck_reverseLogicalChannelParameters_mu  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters (OOCTXT* pctxt, H245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 1);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* h222LogicalChannelParameters */
         case 1:
            stat = asn1PE_H245H222LogicalChannelParameters (pctxt, pvalue->u.h222LogicalChannelParameters);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 2);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* h2250LogicalChannelParameters */
         case 2:
            stat = asn1PE_H245H2250LogicalChannelParameters (&lctxt, pvalue->u.h2250LogicalChannelParameters);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelAck_reverseLogicalChannelParameters     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannelAck_reverseLogicalChannelParameters (OOCTXT* pctxt, H245OpenLogicalChannelAck_reverseLogicalChannelParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.replacementForPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.portNumberPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.multiplexParametersPresent);

   /* encode reverseLogicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->reverseLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   /* encode portNumber */

   if (pvalue->m.portNumberPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->portNumber, 0U, 65535U);
      if (stat != ASN_OK) return stat;

   }

   /* encode multiplexParameters */

   if (pvalue->m.multiplexParametersPresent) {
      stat = asn1PE_H245OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters (pctxt, &pvalue->multiplexParameters);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.replacementForPresent);
      /* encode extension elements */

      if (pvalue->m.replacementForPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245LogicalChannelNumber (&lctxt, pvalue->replacementFor);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250LogicalChannelAckParameters                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H2250LogicalChannelAckParameters (OOCTXT* pctxt, H245H2250LogicalChannelAckParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.flowControlToZeroPresent ||
   pvalue->m.portNumberPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.nonStandardPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.sessionIDPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaChannelPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaControlChannelPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.dynamicRTPPayloadTypePresent);

   /* encode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      stat = asn1PE_H245_SeqOfH245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;
   }

   /* encode sessionID */

   if (pvalue->m.sessionIDPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->sessionID, 1U, 255U);
      if (stat != ASN_OK) return stat;

   }

   /* encode mediaChannel */

   if (pvalue->m.mediaChannelPresent) {
      stat = asn1PE_H245TransportAddress (pctxt, &pvalue->mediaChannel);
      if (stat != ASN_OK) return stat;
   }

   /* encode mediaControlChannel */

   if (pvalue->m.mediaControlChannelPresent) {
      stat = asn1PE_H245TransportAddress (pctxt, &pvalue->mediaControlChannel);
      if (stat != ASN_OK) return stat;
   }

   /* encode dynamicRTPPayloadType */

   if (pvalue->m.dynamicRTPPayloadTypePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->dynamicRTPPayloadType, 96U, 127U);
      if (stat != ASN_OK) return stat;

   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 1);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.flowControlToZeroPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.portNumberPresent);
      /* encode extension elements */

      if (pvalue->m.flowControlToZeroPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeBit (&lctxt, (ASN1BOOL)pvalue->flowControlToZero);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.portNumberPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeConsUnsigned (&lctxt, pvalue->portNumber, 0U, 65535U);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelAck_forwardMultiplexAckParameters       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannelAck_forwardMultiplexAckParameters (OOCTXT* pctxt, H245OpenLogicalChannelAck_forwardMultiplexAckParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 1);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* h2250LogicalChannelAckParameters */
         case 1:
            stat = asn1PE_H245H2250LogicalChannelAckParameters (pctxt, pvalue->u.h2250LogicalChannelAckParameters);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 2);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelAck                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannelAck (OOCTXT* pctxt, H245OpenLogicalChannelAck* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.separateStackPresent ||
   pvalue->m.forwardMultiplexAckParametersPresent ||
   pvalue->m.encryptionSyncPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.reverseLogicalChannelParametersPresent);

   /* encode forwardLogicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   /* encode reverseLogicalChannelParameters */

   if (pvalue->m.reverseLogicalChannelParametersPresent) {
      stat = asn1PE_H245OpenLogicalChannelAck_reverseLogicalChannelParameters (pctxt, &pvalue->reverseLogicalChannelParameters);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 2);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.separateStackPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.forwardMultiplexAckParametersPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.encryptionSyncPresent);
      /* encode extension elements */

      if (pvalue->m.separateStackPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245NetworkAccessParameters (&lctxt, &pvalue->separateStack);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.forwardMultiplexAckParametersPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245OpenLogicalChannelAck_forwardMultiplexAckParameters (&lctxt, &pvalue->forwardMultiplexAckParameters);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.encryptionSyncPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245EncryptionSync (&lctxt, &pvalue->encryptionSync);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelReject_cause                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannelReject_cause (OOCTXT* pctxt, H245OpenLogicalChannelReject_cause* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 6);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 5);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* unspecified */
         case 1:
            /* NULL */
            break;

         /* unsuitableReverseParameters */
         case 2:
            /* NULL */
            break;

         /* dataTypeNotSupported */
         case 3:
            /* NULL */
            break;

         /* dataTypeNotAvailable */
         case 4:
            /* NULL */
            break;

         /* unknownDataType */
         case 5:
            /* NULL */
            break;

         /* dataTypeALCombinationNotSupported */
         case 6:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 7);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* multicastChannelNotAllowed */
         case 7:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* insufficientBandwidth */
         case 8:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* separateStackEstablishmentFailed */
         case 9:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* invalidSessionID */
         case 10:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* masterSlaveConflict */
         case 11:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* waitForCommunicationMode */
         case 12:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* invalidDependentChannel */
         case 13:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* replacementForRejected */
         case 14:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelReject                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannelReject (OOCTXT* pctxt, H245OpenLogicalChannelReject* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode forwardLogicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   /* encode cause */

   stat = asn1PE_H245OpenLogicalChannelReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CloseLogicalChannelAck                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CloseLogicalChannelAck (OOCTXT* pctxt, H245CloseLogicalChannelAck* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode forwardLogicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestChannelCloseAck                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestChannelCloseAck (OOCTXT* pctxt, H245RequestChannelCloseAck* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode forwardLogicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestChannelCloseReject_cause                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestChannelCloseReject_cause (OOCTXT* pctxt, H245RequestChannelCloseReject_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 1);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* unspecified */
         case 1:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 2);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestChannelCloseReject                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestChannelCloseReject (OOCTXT* pctxt, H245RequestChannelCloseReject* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode forwardLogicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   /* encode cause */

   stat = asn1PE_H245RequestChannelCloseReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySendAck_multiplexTableEntryNumber           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntrySendAck_multiplexTableEntryNumber (OOCTXT* pctxt, H245MultiplexEntrySendAck_multiplexTableEntryNumber* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = asn1PE_H245MultiplexTableEntryNumber (pctxt, pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySendAck                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntrySendAck (OOCTXT* pctxt, H245MultiplexEntrySendAck* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode multiplexTableEntryNumber */

   stat = asn1PE_H245MultiplexEntrySendAck_multiplexTableEntryNumber (pctxt, &pvalue->multiplexTableEntryNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntryRejectionDescriptions_cause                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntryRejectionDescriptions_cause (OOCTXT* pctxt, H245MultiplexEntryRejectionDescriptions_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* unspecifiedCause */
         case 1:
            /* NULL */
            break;

         /* descriptorTooComplex */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntryRejectionDescriptions                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntryRejectionDescriptions (OOCTXT* pctxt, H245MultiplexEntryRejectionDescriptions* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode multiplexTableEntryNumber */

   stat = asn1PE_H245MultiplexTableEntryNumber (pctxt, pvalue->multiplexTableEntryNumber);
   if (stat != ASN_OK) return stat;

   /* encode cause */

   stat = asn1PE_H245MultiplexEntryRejectionDescriptions_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySendReject_rejectionDescriptions            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntrySendReject_rejectionDescriptions (OOCTXT* pctxt, H245MultiplexEntrySendReject_rejectionDescriptions* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245MultiplexEntryRejectionDescriptions (pctxt, ((H245MultiplexEntryRejectionDescriptions*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySendReject                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntrySendReject (OOCTXT* pctxt, H245MultiplexEntrySendReject* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode rejectionDescriptions */

   stat = asn1PE_H245MultiplexEntrySendReject_rejectionDescriptions (pctxt, &pvalue->rejectionDescriptions);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryAck_entryNumbers                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMultiplexEntryAck_entryNumbers (OOCTXT* pctxt, H245RequestMultiplexEntryAck_entryNumbers* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = asn1PE_H245MultiplexTableEntryNumber (pctxt, pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryAck                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMultiplexEntryAck (OOCTXT* pctxt, H245RequestMultiplexEntryAck* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode entryNumbers */

   stat = asn1PE_H245RequestMultiplexEntryAck_entryNumbers (pctxt, &pvalue->entryNumbers);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryReject_entryNumbers                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMultiplexEntryReject_entryNumbers (OOCTXT* pctxt, H245RequestMultiplexEntryReject_entryNumbers* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = asn1PE_H245MultiplexTableEntryNumber (pctxt, pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryRejectionDescriptions_cause          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMultiplexEntryRejectionDescriptions_cause (OOCTXT* pctxt, H245RequestMultiplexEntryRejectionDescriptions_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 1);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* unspecifiedCause */
         case 1:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 2);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryRejectionDescriptions                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMultiplexEntryRejectionDescriptions (OOCTXT* pctxt, H245RequestMultiplexEntryRejectionDescriptions* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode multiplexTableEntryNumber */

   stat = asn1PE_H245MultiplexTableEntryNumber (pctxt, pvalue->multiplexTableEntryNumber);
   if (stat != ASN_OK) return stat;

   /* encode cause */

   stat = asn1PE_H245RequestMultiplexEntryRejectionDescriptions_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryReject_rejectionDescriptions         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMultiplexEntryReject_rejectionDescriptions (OOCTXT* pctxt, H245RequestMultiplexEntryReject_rejectionDescriptions* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245RequestMultiplexEntryRejectionDescriptions (pctxt, ((H245RequestMultiplexEntryRejectionDescriptions*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryReject                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMultiplexEntryReject (OOCTXT* pctxt, H245RequestMultiplexEntryReject* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode entryNumbers */

   stat = asn1PE_H245RequestMultiplexEntryReject_entryNumbers (pctxt, &pvalue->entryNumbers);
   if (stat != ASN_OK) return stat;

   /* encode rejectionDescriptions */

   stat = asn1PE_H245RequestMultiplexEntryReject_rejectionDescriptions (pctxt, &pvalue->rejectionDescriptions);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestModeAck_response                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestModeAck_response (OOCTXT* pctxt, H245RequestModeAck_response* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* willTransmitMostPreferredMode */
         case 1:
            /* NULL */
            break;

         /* willTransmitLessPreferredMode */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestModeAck                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestModeAck (OOCTXT* pctxt, H245RequestModeAck* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode response */

   stat = asn1PE_H245RequestModeAck_response (pctxt, &pvalue->response);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestModeReject_cause                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestModeReject_cause (OOCTXT* pctxt, H245RequestModeReject_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* modeUnavailable */
         case 1:
            /* NULL */
            break;

         /* multipointConstraint */
         case 2:
            /* NULL */
            break;

         /* requestDenied */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestModeReject                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestModeReject (OOCTXT* pctxt, H245RequestModeReject* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode cause */

   stat = asn1PE_H245RequestModeReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RoundTripDelayResponse                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RoundTripDelayResponse (OOCTXT* pctxt, H245RoundTripDelayResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopAck_type                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MaintenanceLoopAck_type (OOCTXT* pctxt, H245MaintenanceLoopAck_type* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* systemLoop */
         case 1:
            /* NULL */
            break;

         /* mediaLoop */
         case 2:
            stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->u.mediaLoop);
            if (stat != ASN_OK) return stat;
            break;

         /* logicalChannelLoop */
         case 3:
            stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->u.logicalChannelLoop);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopAck                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MaintenanceLoopAck (OOCTXT* pctxt, H245MaintenanceLoopAck* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode type */

   stat = asn1PE_H245MaintenanceLoopAck_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopReject_type                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MaintenanceLoopReject_type (OOCTXT* pctxt, H245MaintenanceLoopReject_type* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* systemLoop */
         case 1:
            /* NULL */
            break;

         /* mediaLoop */
         case 2:
            stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->u.mediaLoop);
            if (stat != ASN_OK) return stat;
            break;

         /* logicalChannelLoop */
         case 3:
            stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->u.logicalChannelLoop);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopReject_cause                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MaintenanceLoopReject_cause (OOCTXT* pctxt, H245MaintenanceLoopReject_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 1);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* canNotPerformLoop */
         case 1:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 2);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopReject                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MaintenanceLoopReject (OOCTXT* pctxt, H245MaintenanceLoopReject* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode type */

   stat = asn1PE_H245MaintenanceLoopReject_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   /* encode cause */

   stat = asn1PE_H245MaintenanceLoopReject_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeTableEntry_dataType                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CommunicationModeTableEntry_dataType (OOCTXT* pctxt, H245CommunicationModeTableEntry_dataType* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* videoData */
         case 1:
            stat = asn1PE_H245VideoCapability (pctxt, pvalue->u.videoData);
            if (stat != ASN_OK) return stat;
            break;

         /* audioData */
         case 2:
            stat = asn1PE_H245AudioCapability (pctxt, pvalue->u.audioData);
            if (stat != ASN_OK) return stat;
            break;

         /* data */
         case 3:
            stat = asn1PE_H245DataApplicationCapability (pctxt, pvalue->u.data);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeTableEntry                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CommunicationModeTableEntry (OOCTXT* pctxt, H245CommunicationModeTableEntry* pvalue)
{
   static Asn1SizeCnst sessionDescription_lsize1 = { 0, 1, 128, 0 };
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.redundancyEncodingPresent ||
   pvalue->m.sessionDependencyPresent ||
   pvalue->m.destinationPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.nonStandardPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.associatedSessionIDPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.terminalLabelPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaChannelPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaGuaranteedDeliveryPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaControlChannelPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.mediaControlGuaranteedDeliveryPresent);

   /* encode nonStandard */

   if (pvalue->m.nonStandardPresent) {
      stat = asn1PE_H245_SeqOfH245NonStandardParameter (pctxt, &pvalue->nonStandard);
      if (stat != ASN_OK) return stat;
   }

   /* encode sessionID */

   stat = encodeConsUnsigned (pctxt, pvalue->sessionID, 1U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode associatedSessionID */

   if (pvalue->m.associatedSessionIDPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->associatedSessionID, 1U, 255U);
      if (stat != ASN_OK) return stat;

   }

   /* encode terminalLabel */

   if (pvalue->m.terminalLabelPresent) {
      stat = asn1PE_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
      if (stat != ASN_OK) return stat;
   }

   /* encode sessionDescription */

   addSizeConstraint (pctxt, &sessionDescription_lsize1);

   stat = encodeBMPString (pctxt, pvalue->sessionDescription, 0);
   if (stat != ASN_OK) return stat;

   /* encode dataType */

   stat = asn1PE_H245CommunicationModeTableEntry_dataType (pctxt, &pvalue->dataType);
   if (stat != ASN_OK) return stat;

   /* encode mediaChannel */

   if (pvalue->m.mediaChannelPresent) {
      stat = asn1PE_H245TransportAddress (pctxt, &pvalue->mediaChannel);
      if (stat != ASN_OK) return stat;
   }

   /* encode mediaGuaranteedDelivery */

   if (pvalue->m.mediaGuaranteedDeliveryPresent) {
      stat = encodeBit (pctxt, (ASN1BOOL)pvalue->mediaGuaranteedDelivery);
      if (stat != ASN_OK) return stat;
   }

   /* encode mediaControlChannel */

   if (pvalue->m.mediaControlChannelPresent) {
      stat = asn1PE_H245TransportAddress (pctxt, &pvalue->mediaControlChannel);
      if (stat != ASN_OK) return stat;
   }

   /* encode mediaControlGuaranteedDelivery */

   if (pvalue->m.mediaControlGuaranteedDeliveryPresent) {
      stat = encodeBit (pctxt, (ASN1BOOL)pvalue->mediaControlGuaranteedDelivery);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 2);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.redundancyEncodingPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.sessionDependencyPresent);
      encodeBit (pctxt, (ASN1BOOL)pvalue->m.destinationPresent);
      /* encode extension elements */

      if (pvalue->m.redundancyEncodingPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245RedundancyEncoding (&lctxt, &pvalue->redundancyEncoding);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.sessionDependencyPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeConsUnsigned (&lctxt, pvalue->sessionDependency, 1U, 255U);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

      if (pvalue->m.destinationPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245TerminalLabel (&lctxt, &pvalue->destination);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeResponse_communicationModeTable          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CommunicationModeResponse_communicationModeTable (OOCTXT* pctxt, H245CommunicationModeResponse_communicationModeTable* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245CommunicationModeTableEntry (pctxt, ((H245CommunicationModeTableEntry*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeResponse                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CommunicationModeResponse (OOCTXT* pctxt, H245CommunicationModeResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 1);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 0);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* communicationModeTable */
         case 1:
            stat = asn1PE_H245CommunicationModeResponse_communicationModeTable (pctxt, pvalue->u.communicationModeTable);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 2);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalID                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalID (OOCTXT* pctxt, H245TerminalID* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 128, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_mCTerminalIDResponse                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_mCTerminalIDResponse (OOCTXT* pctxt, H245ConferenceResponse_mCTerminalIDResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode terminalLabel */

   stat = asn1PE_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   /* encode terminalID */

   stat = asn1PE_H245TerminalID (pctxt, &pvalue->terminalID);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_terminalIDResponse                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_terminalIDResponse (OOCTXT* pctxt, H245ConferenceResponse_terminalIDResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode terminalLabel */

   stat = asn1PE_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   /* encode terminalID */

   stat = asn1PE_H245TerminalID (pctxt, &pvalue->terminalID);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceID                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceID (OOCTXT* pctxt, H245ConferenceID* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 32, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_conferenceIDResponse                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_conferenceIDResponse (OOCTXT* pctxt, H245ConferenceResponse_conferenceIDResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode terminalLabel */

   stat = asn1PE_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   /* encode conferenceID */

   stat = asn1PE_H245ConferenceID (pctxt, &pvalue->conferenceID);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Password                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245Password (OOCTXT* pctxt, H245Password* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 32, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_passwordResponse                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_passwordResponse (OOCTXT* pctxt, H245ConferenceResponse_passwordResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode terminalLabel */

   stat = asn1PE_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   /* encode password */

   stat = asn1PE_H245Password (pctxt, &pvalue->password);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_terminalListResponse                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_terminalListResponse (OOCTXT* pctxt, H245ConferenceResponse_terminalListResponse* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245TerminalLabel (pctxt, ((H245TerminalLabel*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_makeMeChairResponse                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_makeMeChairResponse (OOCTXT* pctxt, H245ConferenceResponse_makeMeChairResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* grantedChairToken */
         case 1:
            /* NULL */
            break;

         /* deniedChairToken */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_extensionAddressResponse               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_extensionAddressResponse (OOCTXT* pctxt, H245ConferenceResponse_extensionAddressResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode extensionAddress */

   stat = asn1PE_H245TerminalID (pctxt, &pvalue->extensionAddress);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_chairTokenOwnerResponse                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_chairTokenOwnerResponse (OOCTXT* pctxt, H245ConferenceResponse_chairTokenOwnerResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode terminalLabel */

   stat = asn1PE_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   /* encode terminalID */

   stat = asn1PE_H245TerminalID (pctxt, &pvalue->terminalID);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_terminalCertificateResponse            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_terminalCertificateResponse (OOCTXT* pctxt, H245ConferenceResponse_terminalCertificateResponse* pvalue)
{
   static Asn1SizeCnst certificateResponse_lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.terminalLabelPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.certificateResponsePresent);

   /* encode terminalLabel */

   if (pvalue->m.terminalLabelPresent) {
      stat = asn1PE_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
      if (stat != ASN_OK) return stat;
   }

   /* encode certificateResponse */

   if (pvalue->m.certificateResponsePresent) {
      addSizeConstraint (pctxt, &certificateResponse_lsize1);

      stat = encodeOctetString (pctxt, pvalue->certificateResponse.numocts, pvalue->certificateResponse.data);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_broadcastMyLogicalChannelResponse      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_broadcastMyLogicalChannelResponse (OOCTXT* pctxt, H245ConferenceResponse_broadcastMyLogicalChannelResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* grantedBroadcastMyLogicalChannel */
         case 1:
            /* NULL */
            break;

         /* deniedBroadcastMyLogicalChannel */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_makeTerminalBroadcasterResponse        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_makeTerminalBroadcasterResponse (OOCTXT* pctxt, H245ConferenceResponse_makeTerminalBroadcasterResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* grantedMakeTerminalBroadcaster */
         case 1:
            /* NULL */
            break;

         /* deniedMakeTerminalBroadcaster */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse_sendThisSourceResponse                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse_sendThisSourceResponse (OOCTXT* pctxt, H245ConferenceResponse_sendThisSourceResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* grantedSendThisSource */
         case 1:
            /* NULL */
            break;

         /* deniedSendThisSource */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalInformation                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalInformation (OOCTXT* pctxt, H245TerminalInformation* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode terminalLabel */

   stat = asn1PE_H245TerminalLabel (pctxt, &pvalue->terminalLabel);
   if (stat != ASN_OK) return stat;

   /* encode terminalID */

   stat = asn1PE_H245TerminalID (pctxt, &pvalue->terminalID);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245TerminalInformation                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245TerminalInformation (OOCTXT* pctxt, H245_SeqOfH245TerminalInformation* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245TerminalInformation (pctxt, ((H245TerminalInformation*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestAllTerminalIDsResponse                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestAllTerminalIDsResponse (OOCTXT* pctxt, H245RequestAllTerminalIDsResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode terminalInformation */

   stat = asn1PE_H245_SeqOfH245TerminalInformation (pctxt, &pvalue->terminalInformation);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RemoteMCResponse_reject                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RemoteMCResponse_reject (OOCTXT* pctxt, H245RemoteMCResponse_reject* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* unspecified */
         case 1:
            /* NULL */
            break;

         /* functionNotSupported */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RemoteMCResponse                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RemoteMCResponse (OOCTXT* pctxt, H245RemoteMCResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* accept */
         case 1:
            /* NULL */
            break;

         /* reject */
         case 2:
            stat = asn1PE_H245RemoteMCResponse_reject (pctxt, pvalue->u.reject);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceResponse                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceResponse (OOCTXT* pctxt, H245ConferenceResponse* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 8);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 7);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* mCTerminalIDResponse */
         case 1:
            stat = asn1PE_H245ConferenceResponse_mCTerminalIDResponse (pctxt, pvalue->u.mCTerminalIDResponse);
            if (stat != ASN_OK) return stat;
            break;

         /* terminalIDResponse */
         case 2:
            stat = asn1PE_H245ConferenceResponse_terminalIDResponse (pctxt, pvalue->u.terminalIDResponse);
            if (stat != ASN_OK) return stat;
            break;

         /* conferenceIDResponse */
         case 3:
            stat = asn1PE_H245ConferenceResponse_conferenceIDResponse (pctxt, pvalue->u.conferenceIDResponse);
            if (stat != ASN_OK) return stat;
            break;

         /* passwordResponse */
         case 4:
            stat = asn1PE_H245ConferenceResponse_passwordResponse (pctxt, pvalue->u.passwordResponse);
            if (stat != ASN_OK) return stat;
            break;

         /* terminalListResponse */
         case 5:
            stat = asn1PE_H245ConferenceResponse_terminalListResponse (pctxt, pvalue->u.terminalListResponse);
            if (stat != ASN_OK) return stat;
            break;

         /* videoCommandReject */
         case 6:
            /* NULL */
            break;

         /* terminalDropReject */
         case 7:
            /* NULL */
            break;

         /* makeMeChairResponse */
         case 8:
            stat = asn1PE_H245ConferenceResponse_makeMeChairResponse (pctxt, pvalue->u.makeMeChairResponse);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 9);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* extensionAddressResponse */
         case 9:
            stat = asn1PE_H245ConferenceResponse_extensionAddressResponse (&lctxt, pvalue->u.extensionAddressResponse);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* chairTokenOwnerResponse */
         case 10:
            stat = asn1PE_H245ConferenceResponse_chairTokenOwnerResponse (&lctxt, pvalue->u.chairTokenOwnerResponse);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* terminalCertificateResponse */
         case 11:
            stat = asn1PE_H245ConferenceResponse_terminalCertificateResponse (&lctxt, pvalue->u.terminalCertificateResponse);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* broadcastMyLogicalChannelResponse */
         case 12:
            stat = asn1PE_H245ConferenceResponse_broadcastMyLogicalChannelResponse (&lctxt, pvalue->u.broadcastMyLogicalChannelResponse);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* makeTerminalBroadcasterResponse */
         case 13:
            stat = asn1PE_H245ConferenceResponse_makeTerminalBroadcasterResponse (&lctxt, pvalue->u.makeTerminalBroadcasterResponse);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* sendThisSourceResponse */
         case 14:
            stat = asn1PE_H245ConferenceResponse_sendThisSourceResponse (&lctxt, pvalue->u.sendThisSourceResponse);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* requestAllTerminalIDsResponse */
         case 15:
            stat = asn1PE_H245RequestAllTerminalIDsResponse (&lctxt, pvalue->u.requestAllTerminalIDsResponse);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* remoteMCResponse */
         case 16:
            stat = asn1PE_H245RemoteMCResponse (&lctxt, pvalue->u.remoteMCResponse);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_callInformation                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkResponse_callInformation (OOCTXT* pctxt, H245MultilinkResponse_callInformation* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode dialingInformation */

   stat = asn1PE_H245DialingInformation (pctxt, &pvalue->dialingInformation);
   if (stat != ASN_OK) return stat;

   /* encode callAssociationNumber */

   stat = encodeConsUnsigned (pctxt, pvalue->callAssociationNumber, 0U, ASN1UINT_MAX);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_addConnection_responseCode_rejected     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkResponse_addConnection_responseCode_rejected (OOCTXT* pctxt, H245MultilinkResponse_addConnection_responseCode_rejected* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* connectionsNotAvailable */
         case 1:
            /* NULL */
            break;

         /* userRejected */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_addConnection_responseCode              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkResponse_addConnection_responseCode (OOCTXT* pctxt, H245MultilinkResponse_addConnection_responseCode* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* accepted */
         case 1:
            /* NULL */
            break;

         /* rejected */
         case 2:
            stat = asn1PE_H245MultilinkResponse_addConnection_responseCode_rejected (pctxt, pvalue->u.rejected);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_addConnection                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkResponse_addConnection (OOCTXT* pctxt, H245MultilinkResponse_addConnection* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode responseCode */

   stat = asn1PE_H245MultilinkResponse_addConnection_responseCode (pctxt, &pvalue->responseCode);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_removeConnection                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkResponse_removeConnection (OOCTXT* pctxt, H245MultilinkResponse_removeConnection* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode connectionIdentifier */

   stat = asn1PE_H245ConnectionIdentifier (pctxt, &pvalue->connectionIdentifier);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse_maximumHeaderInterval                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkResponse_maximumHeaderInterval (OOCTXT* pctxt, H245MultilinkResponse_maximumHeaderInterval* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode currentInterval */

   stat = encodeConsUnsigned (pctxt, pvalue->currentInterval, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkResponse                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkResponse (OOCTXT* pctxt, H245MultilinkResponse* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 5);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 4);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* callInformation */
         case 2:
            stat = asn1PE_H245MultilinkResponse_callInformation (pctxt, pvalue->u.callInformation);
            if (stat != ASN_OK) return stat;
            break;

         /* addConnection */
         case 3:
            stat = asn1PE_H245MultilinkResponse_addConnection (pctxt, pvalue->u.addConnection);
            if (stat != ASN_OK) return stat;
            break;

         /* removeConnection */
         case 4:
            stat = asn1PE_H245MultilinkResponse_removeConnection (pctxt, pvalue->u.removeConnection);
            if (stat != ASN_OK) return stat;
            break;

         /* maximumHeaderInterval */
         case 5:
            stat = asn1PE_H245MultilinkResponse_maximumHeaderInterval (pctxt, pvalue->u.maximumHeaderInterval);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 6);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LogicalChannelRateAcknowledge                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245LogicalChannelRateAcknowledge (OOCTXT* pctxt, H245LogicalChannelRateAcknowledge* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode logicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   /* encode maximumBitRate */

   stat = asn1PE_H245MaximumBitRate (pctxt, pvalue->maximumBitRate);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LogicalChannelRateRejectReason                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245LogicalChannelRateRejectReason (OOCTXT* pctxt, H245LogicalChannelRateRejectReason* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* undefinedReason */
         case 1:
            /* NULL */
            break;

         /* insufficientResources */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LogicalChannelRateReject                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245LogicalChannelRateReject (OOCTXT* pctxt, H245LogicalChannelRateReject* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.currentMaximumBitRatePresent);

   /* encode sequenceNumber */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->sequenceNumber);
   if (stat != ASN_OK) return stat;

   /* encode logicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   /* encode rejectReason */

   stat = asn1PE_H245LogicalChannelRateRejectReason (pctxt, &pvalue->rejectReason);
   if (stat != ASN_OK) return stat;

   /* encode currentMaximumBitRate */

   if (pvalue->m.currentMaximumBitRatePresent) {
      stat = asn1PE_H245MaximumBitRate (pctxt, pvalue->currentMaximumBitRate);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ResponseMessage                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ResponseMessage (OOCTXT* pctxt, H245ResponseMessage* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 19);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 18);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* masterSlaveDeterminationAck */
         case 2:
            stat = asn1PE_H245MasterSlaveDeterminationAck (pctxt, pvalue->u.masterSlaveDeterminationAck);
            if (stat != ASN_OK) return stat;
            break;

         /* masterSlaveDeterminationReject */
         case 3:
            stat = asn1PE_H245MasterSlaveDeterminationReject (pctxt, pvalue->u.masterSlaveDeterminationReject);
            if (stat != ASN_OK) return stat;
            break;

         /* terminalCapabilitySetAck */
         case 4:
            stat = asn1PE_H245TerminalCapabilitySetAck (pctxt, pvalue->u.terminalCapabilitySetAck);
            if (stat != ASN_OK) return stat;
            break;

         /* terminalCapabilitySetReject */
         case 5:
            stat = asn1PE_H245TerminalCapabilitySetReject (pctxt, pvalue->u.terminalCapabilitySetReject);
            if (stat != ASN_OK) return stat;
            break;

         /* openLogicalChannelAck */
         case 6:
            stat = asn1PE_H245OpenLogicalChannelAck (pctxt, pvalue->u.openLogicalChannelAck);
            if (stat != ASN_OK) return stat;
            break;

         /* openLogicalChannelReject */
         case 7:
            stat = asn1PE_H245OpenLogicalChannelReject (pctxt, pvalue->u.openLogicalChannelReject);
            if (stat != ASN_OK) return stat;
            break;

         /* closeLogicalChannelAck */
         case 8:
            stat = asn1PE_H245CloseLogicalChannelAck (pctxt, pvalue->u.closeLogicalChannelAck);
            if (stat != ASN_OK) return stat;
            break;

         /* requestChannelCloseAck */
         case 9:
            stat = asn1PE_H245RequestChannelCloseAck (pctxt, pvalue->u.requestChannelCloseAck);
            if (stat != ASN_OK) return stat;
            break;

         /* requestChannelCloseReject */
         case 10:
            stat = asn1PE_H245RequestChannelCloseReject (pctxt, pvalue->u.requestChannelCloseReject);
            if (stat != ASN_OK) return stat;
            break;

         /* multiplexEntrySendAck */
         case 11:
            stat = asn1PE_H245MultiplexEntrySendAck (pctxt, pvalue->u.multiplexEntrySendAck);
            if (stat != ASN_OK) return stat;
            break;

         /* multiplexEntrySendReject */
         case 12:
            stat = asn1PE_H245MultiplexEntrySendReject (pctxt, pvalue->u.multiplexEntrySendReject);
            if (stat != ASN_OK) return stat;
            break;

         /* requestMultiplexEntryAck */
         case 13:
            stat = asn1PE_H245RequestMultiplexEntryAck (pctxt, pvalue->u.requestMultiplexEntryAck);
            if (stat != ASN_OK) return stat;
            break;

         /* requestMultiplexEntryReject */
         case 14:
            stat = asn1PE_H245RequestMultiplexEntryReject (pctxt, pvalue->u.requestMultiplexEntryReject);
            if (stat != ASN_OK) return stat;
            break;

         /* requestModeAck */
         case 15:
            stat = asn1PE_H245RequestModeAck (pctxt, pvalue->u.requestModeAck);
            if (stat != ASN_OK) return stat;
            break;

         /* requestModeReject */
         case 16:
            stat = asn1PE_H245RequestModeReject (pctxt, pvalue->u.requestModeReject);
            if (stat != ASN_OK) return stat;
            break;

         /* roundTripDelayResponse */
         case 17:
            stat = asn1PE_H245RoundTripDelayResponse (pctxt, pvalue->u.roundTripDelayResponse);
            if (stat != ASN_OK) return stat;
            break;

         /* maintenanceLoopAck */
         case 18:
            stat = asn1PE_H245MaintenanceLoopAck (pctxt, pvalue->u.maintenanceLoopAck);
            if (stat != ASN_OK) return stat;
            break;

         /* maintenanceLoopReject */
         case 19:
            stat = asn1PE_H245MaintenanceLoopReject (pctxt, pvalue->u.maintenanceLoopReject);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 20);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* communicationModeResponse */
         case 20:
            stat = asn1PE_H245CommunicationModeResponse (&lctxt, pvalue->u.communicationModeResponse);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* conferenceResponse */
         case 21:
            stat = asn1PE_H245ConferenceResponse (&lctxt, pvalue->u.conferenceResponse);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* multilinkResponse */
         case 22:
            stat = asn1PE_H245MultilinkResponse (&lctxt, pvalue->u.multilinkResponse);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* logicalChannelRateAcknowledge */
         case 23:
            stat = asn1PE_H245LogicalChannelRateAcknowledge (&lctxt, pvalue->u.logicalChannelRateAcknowledge);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* logicalChannelRateReject */
         case 24:
            stat = asn1PE_H245LogicalChannelRateReject (&lctxt, pvalue->u.logicalChannelRateReject);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MaintenanceLoopOffCommand                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MaintenanceLoopOffCommand (OOCTXT* pctxt, H245MaintenanceLoopOffCommand* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendTerminalCapabilitySet_specificRequest_capabilityTabl  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers (OOCTXT* pctxt, H245SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 65535, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = asn1PE_H245CapabilityTableEntryNumber (pctxt, pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendTerminalCapabilitySet_specificRequest_capabilityDesc  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers (OOCTXT* pctxt, H245SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = asn1PE_H245CapabilityDescriptorNumber (pctxt, pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendTerminalCapabilitySet_specificRequest                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245SendTerminalCapabilitySet_specificRequest (OOCTXT* pctxt, H245SendTerminalCapabilitySet_specificRequest* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.capabilityTableEntryNumbersPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.capabilityDescriptorNumbersPresent);

   /* encode multiplexCapability */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->multiplexCapability);
   if (stat != ASN_OK) return stat;

   /* encode capabilityTableEntryNumbers */

   if (pvalue->m.capabilityTableEntryNumbersPresent) {
      stat = asn1PE_H245SendTerminalCapabilitySet_specificRequest_capabilityTableEntryNumbers (pctxt, &pvalue->capabilityTableEntryNumbers);
      if (stat != ASN_OK) return stat;
   }

   /* encode capabilityDescriptorNumbers */

   if (pvalue->m.capabilityDescriptorNumbersPresent) {
      stat = asn1PE_H245SendTerminalCapabilitySet_specificRequest_capabilityDescriptorNumbers (pctxt, &pvalue->capabilityDescriptorNumbers);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SendTerminalCapabilitySet                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245SendTerminalCapabilitySet (OOCTXT* pctxt, H245SendTerminalCapabilitySet* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* specificRequest */
         case 1:
            stat = asn1PE_H245SendTerminalCapabilitySet_specificRequest (pctxt, pvalue->u.specificRequest);
            if (stat != ASN_OK) return stat;
            break;

         /* genericRequest */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionCommand_encryptionAlgorithmID                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EncryptionCommand_encryptionAlgorithmID (OOCTXT* pctxt, H245EncryptionCommand_encryptionAlgorithmID* pvalue)
{
   int stat = ASN_OK;

   /* encode h233AlgorithmIdentifier */

   stat = asn1PE_H245SequenceNumber (pctxt, pvalue->h233AlgorithmIdentifier);
   if (stat != ASN_OK) return stat;

   /* encode associatedAlgorithm */

   stat = asn1PE_H245NonStandardParameter (pctxt, &pvalue->associatedAlgorithm);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionCommand                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EncryptionCommand (OOCTXT* pctxt, H245EncryptionCommand* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* encryptionSE */
         case 1:
            stat = encodeOctetString (pctxt, pvalue->u.encryptionSE->numocts, pvalue->u.encryptionSE->data);
            if (stat != ASN_OK) return stat;
            break;

         /* encryptionIVRequest */
         case 2:
            /* NULL */
            break;

         /* encryptionAlgorithmID */
         case 3:
            stat = asn1PE_H245EncryptionCommand_encryptionAlgorithmID (pctxt, pvalue->u.encryptionAlgorithmID);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FlowControlCommand_scope                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FlowControlCommand_scope (OOCTXT* pctxt, H245FlowControlCommand_scope* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* logicalChannelNumber */
      case 1:
         stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->u.logicalChannelNumber);
         if (stat != ASN_OK) return stat;
         break;

      /* resourceID */
      case 2:
         stat = encodeConsUnsigned (pctxt, pvalue->u.resourceID, 0U, 65535U);
         if (stat != ASN_OK) return stat;

         break;

      /* wholeMultiplex */
      case 3:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FlowControlCommand_restriction                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FlowControlCommand_restriction (OOCTXT* pctxt, H245FlowControlCommand_restriction* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* maximumBitRate */
      case 1:
         stat = encodeConsUnsigned (pctxt, pvalue->u.maximumBitRate, 0U, 16777215U);
         if (stat != ASN_OK) return stat;

         break;

      /* noRestriction */
      case 2:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FlowControlCommand                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FlowControlCommand (OOCTXT* pctxt, H245FlowControlCommand* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode scope */

   stat = asn1PE_H245FlowControlCommand_scope (pctxt, &pvalue->scope);
   if (stat != ASN_OK) return stat;

   /* encode restriction */

   stat = asn1PE_H245FlowControlCommand_restriction (pctxt, &pvalue->restriction);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EndSessionCommand_gstnOptions                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EndSessionCommand_gstnOptions (OOCTXT* pctxt, H245EndSessionCommand_gstnOptions* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 5);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 4);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* telephonyMode */
         case 1:
            /* NULL */
            break;

         /* v8bis */
         case 2:
            /* NULL */
            break;

         /* v34DSVD */
         case 3:
            /* NULL */
            break;

         /* v34DuplexFAX */
         case 4:
            /* NULL */
            break;

         /* v34H324 */
         case 5:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 6);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EndSessionCommand_isdnOptions                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EndSessionCommand_isdnOptions (OOCTXT* pctxt, H245EndSessionCommand_isdnOptions* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* telephonyMode */
         case 1:
            /* NULL */
            break;

         /* v140 */
         case 2:
            /* NULL */
            break;

         /* terminalOnHold */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EndSessionCommand                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EndSessionCommand (OOCTXT* pctxt, H245EndSessionCommand* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* disconnect */
         case 2:
            /* NULL */
            break;

         /* gstnOptions */
         case 3:
            stat = asn1PE_H245EndSessionCommand_gstnOptions (pctxt, pvalue->u.gstnOptions);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* isdnOptions */
         case 4:
            stat = asn1PE_H245EndSessionCommand_isdnOptions (&lctxt, pvalue->u.isdnOptions);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousCommand_type_videoFastUpdateGOB              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MiscellaneousCommand_type_videoFastUpdateGOB (OOCTXT* pctxt, H245MiscellaneousCommand_type_videoFastUpdateGOB* pvalue)
{
   int stat = ASN_OK;

   /* encode firstGOB */

   stat = encodeConsUnsigned (pctxt, pvalue->firstGOB, 0U, 17U);
   if (stat != ASN_OK) return stat;

   /* encode numberOfGOBs */

   stat = encodeConsUnsigned (pctxt, pvalue->numberOfGOBs, 1U, 18U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousCommand_type_videoFastUpdateMB               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MiscellaneousCommand_type_videoFastUpdateMB (OOCTXT* pctxt, H245MiscellaneousCommand_type_videoFastUpdateMB* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.firstGOBPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.firstMBPresent);

   /* encode firstGOB */

   if (pvalue->m.firstGOBPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->firstGOB, 0U, 255U);
      if (stat != ASN_OK) return stat;

   }

   /* encode firstMB */

   if (pvalue->m.firstMBPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->firstMB, 1U, 8192U);
      if (stat != ASN_OK) return stat;

   }

   /* encode numberOfMBs */

   stat = encodeConsUnsigned (pctxt, pvalue->numberOfMBs, 1U, 8192U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  KeyProtectionMethod                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245KeyProtectionMethod (OOCTXT* pctxt, H245KeyProtectionMethod* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode secureChannel */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->secureChannel);
   if (stat != ASN_OK) return stat;

   /* encode sharedSecret */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->sharedSecret);
   if (stat != ASN_OK) return stat;

   /* encode certProtectedKey */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->certProtectedKey);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  EncryptionUpdateRequest                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245EncryptionUpdateRequest (OOCTXT* pctxt, H245EncryptionUpdateRequest* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.keyProtectionMethodPresent);

   /* encode keyProtectionMethod */

   if (pvalue->m.keyProtectionMethodPresent) {
      stat = asn1PE_H245KeyProtectionMethod (pctxt, &pvalue->keyProtectionMethod);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousCommand_type_progressiveRefinementStart_rep  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount (OOCTXT* pctxt, H245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* doOneProgression */
         case 1:
            /* NULL */
            break;

         /* doContinuousProgressions */
         case 2:
            /* NULL */
            break;

         /* doOneIndependentProgression */
         case 3:
            /* NULL */
            break;

         /* doContinuousIndependentProgressions */
         case 4:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousCommand_type_progressiveRefinementStart      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MiscellaneousCommand_type_progressiveRefinementStart (OOCTXT* pctxt, H245MiscellaneousCommand_type_progressiveRefinementStart* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode repeatCount */

   stat = asn1PE_H245MiscellaneousCommand_type_progressiveRefinementStart_repeatCount (pctxt, &pvalue->repeatCount);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousCommand_type_videoBadMBs                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MiscellaneousCommand_type_videoBadMBs (OOCTXT* pctxt, H245MiscellaneousCommand_type_videoBadMBs* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode firstMB */

   stat = encodeConsUnsigned (pctxt, pvalue->firstMB, 1U, 9216U);
   if (stat != ASN_OK) return stat;

   /* encode numberOfMBs */

   stat = encodeConsUnsigned (pctxt, pvalue->numberOfMBs, 1U, 9216U);
   if (stat != ASN_OK) return stat;

   /* encode temporalReference */

   stat = encodeConsUnsigned (pctxt, pvalue->temporalReference, 0U, 1023U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PictureReference                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245PictureReference (OOCTXT* pctxt, H245PictureReference* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* pictureNumber */
         case 1:
            stat = encodeConsUnsigned (pctxt, pvalue->u.pictureNumber, 0U, 1023U);
            if (stat != ASN_OK) return stat;

            break;

         /* longTermPictureIndex */
         case 2:
            stat = encodeConsUnsigned (pctxt, pvalue->u.longTermPictureIndex, 0U, 255U);
            if (stat != ASN_OK) return stat;

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfH245PictureReference                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245_SeqOfH245PictureReference (OOCTXT* pctxt, H245_SeqOfH245PictureReference* pvalue)
{
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;
   ASN1UINT enclen, fraglen;

   enclen = fraglen = xx1 = 0;
   pnode = pvalue->head;
   for (;;) {
      /* encode length determinant */

      stat = encodeLength (pctxt, (pvalue->count - enclen));
      if (stat < 0) return stat;

      fraglen = stat;
      enclen += fraglen;
      /* encode elements */

      for (; xx1 < enclen; xx1++) {
         stat = asn1PE_H245PictureReference (pctxt, ((H245PictureReference*)pnode->data));
         if (stat != ASN_OK) return stat;
         pnode = pnode->next;
      }
      if ( pvalue->count == enclen && fraglen < 16384) {
         break;
      }
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousCommand_type_lostPartialPicture              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MiscellaneousCommand_type_lostPartialPicture (OOCTXT* pctxt, H245MiscellaneousCommand_type_lostPartialPicture* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode pictureReference */

   stat = asn1PE_H245PictureReference (pctxt, &pvalue->pictureReference);
   if (stat != ASN_OK) return stat;

   /* encode firstMB */

   stat = encodeConsUnsigned (pctxt, pvalue->firstMB, 1U, 9216U);
   if (stat != ASN_OK) return stat;

   /* encode numberOfMBs */

   stat = encodeConsUnsigned (pctxt, pvalue->numberOfMBs, 1U, 9216U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousCommand_type                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MiscellaneousCommand_type (OOCTXT* pctxt, H245MiscellaneousCommand_type* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 10);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 9);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* equaliseDelay */
         case 1:
            /* NULL */
            break;

         /* zeroDelay */
         case 2:
            /* NULL */
            break;

         /* multipointModeCommand */
         case 3:
            /* NULL */
            break;

         /* cancelMultipointModeCommand */
         case 4:
            /* NULL */
            break;

         /* videoFreezePicture */
         case 5:
            /* NULL */
            break;

         /* videoFastUpdatePicture */
         case 6:
            /* NULL */
            break;

         /* videoFastUpdateGOB */
         case 7:
            stat = asn1PE_H245MiscellaneousCommand_type_videoFastUpdateGOB (pctxt, pvalue->u.videoFastUpdateGOB);
            if (stat != ASN_OK) return stat;
            break;

         /* videoTemporalSpatialTradeOff */
         case 8:
            stat = encodeConsUnsigned (pctxt, pvalue->u.videoTemporalSpatialTradeOff, 0U, 31U);
            if (stat != ASN_OK) return stat;

            break;

         /* videoSendSyncEveryGOB */
         case 9:
            /* NULL */
            break;

         /* videoSendSyncEveryGOBCancel */
         case 10:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 11);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* videoFastUpdateMB */
         case 11:
            stat = asn1PE_H245MiscellaneousCommand_type_videoFastUpdateMB (&lctxt, pvalue->u.videoFastUpdateMB);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* maxH223MUXPDUsize */
         case 12:
            stat = encodeConsUnsigned (&lctxt, pvalue->u.maxH223MUXPDUsize, 1U, 65535U);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;

            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* encryptionUpdate */
         case 13:
            stat = asn1PE_H245EncryptionSync (&lctxt, pvalue->u.encryptionUpdate);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* encryptionUpdateRequest */
         case 14:
            stat = asn1PE_H245EncryptionUpdateRequest (&lctxt, pvalue->u.encryptionUpdateRequest);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* switchReceiveMediaOff */
         case 15:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* switchReceiveMediaOn */
         case 16:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* progressiveRefinementStart */
         case 17:
            stat = asn1PE_H245MiscellaneousCommand_type_progressiveRefinementStart (&lctxt, pvalue->u.progressiveRefinementStart);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* progressiveRefinementAbortOne */
         case 18:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* progressiveRefinementAbortContinuous */
         case 19:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* videoBadMBs */
         case 20:
            stat = asn1PE_H245MiscellaneousCommand_type_videoBadMBs (&lctxt, pvalue->u.videoBadMBs);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* lostPicture */
         case 21:
            stat = asn1PE_H245_SeqOfH245PictureReference (&lctxt, pvalue->u.lostPicture);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* lostPartialPicture */
         case 22:
            stat = asn1PE_H245MiscellaneousCommand_type_lostPartialPicture (&lctxt, pvalue->u.lostPartialPicture);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* recoveryReferencePicture */
         case 23:
            stat = asn1PE_H245_SeqOfH245PictureReference (&lctxt, pvalue->u.recoveryReferencePicture);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousCommand                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MiscellaneousCommand (OOCTXT* pctxt, H245MiscellaneousCommand* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode logicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   /* encode type */

   stat = asn1PE_H245MiscellaneousCommand_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeCommand_communicationModeTable           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CommunicationModeCommand_communicationModeTable (OOCTXT* pctxt, H245CommunicationModeCommand_communicationModeTable* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;
   DListNode* pnode;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->count);
   if (stat < 0) return stat;

   /* encode elements */
   pnode = pvalue->head;

   for (xx1 = 0; xx1 < pvalue->count; xx1++) {
      stat = asn1PE_H245CommunicationModeTableEntry (pctxt, ((H245CommunicationModeTableEntry*)pnode->data));
      if (stat != ASN_OK) return stat;
      pnode = pnode->next;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommunicationModeCommand                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CommunicationModeCommand (OOCTXT* pctxt, H245CommunicationModeCommand* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode communicationModeTable */

   stat = asn1PE_H245CommunicationModeCommand_communicationModeTable (pctxt, &pvalue->communicationModeTable);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SubstituteConferenceIDCommand_conferenceIdentifier        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245SubstituteConferenceIDCommand_conferenceIdentifier (OOCTXT* pctxt, H245SubstituteConferenceIDCommand_conferenceIdentifier* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 16, 16, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  SubstituteConferenceIDCommand                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245SubstituteConferenceIDCommand (OOCTXT* pctxt, H245SubstituteConferenceIDCommand* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode conferenceIdentifier */

   stat = asn1PE_H245SubstituteConferenceIDCommand_conferenceIdentifier (pctxt, &pvalue->conferenceIdentifier);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceCommand                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceCommand (OOCTXT* pctxt, H245ConferenceCommand* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 7);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 6);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* broadcastMyLogicalChannel */
         case 1:
            stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->u.broadcastMyLogicalChannel);
            if (stat != ASN_OK) return stat;
            break;

         /* cancelBroadcastMyLogicalChannel */
         case 2:
            stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->u.cancelBroadcastMyLogicalChannel);
            if (stat != ASN_OK) return stat;
            break;

         /* makeTerminalBroadcaster */
         case 3:
            stat = asn1PE_H245TerminalLabel (pctxt, pvalue->u.makeTerminalBroadcaster);
            if (stat != ASN_OK) return stat;
            break;

         /* cancelMakeTerminalBroadcaster */
         case 4:
            /* NULL */
            break;

         /* sendThisSource */
         case 5:
            stat = asn1PE_H245TerminalLabel (pctxt, pvalue->u.sendThisSource);
            if (stat != ASN_OK) return stat;
            break;

         /* cancelSendThisSource */
         case 6:
            /* NULL */
            break;

         /* dropConference */
         case 7:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 8);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* substituteConferenceIDCommand */
         case 8:
            stat = asn1PE_H245SubstituteConferenceIDCommand (&lctxt, pvalue->u.substituteConferenceIDCommand);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223MultiplexReconfiguration_h223ModeChange               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223MultiplexReconfiguration_h223ModeChange (OOCTXT* pctxt, H245H223MultiplexReconfiguration_h223ModeChange* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* toLevel0 */
         case 1:
            /* NULL */
            break;

         /* toLevel1 */
         case 2:
            /* NULL */
            break;

         /* toLevel2 */
         case 3:
            /* NULL */
            break;

         /* toLevel2withOptionalHeader */
         case 4:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223MultiplexReconfiguration_h223AnnexADoubleFlag         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223MultiplexReconfiguration_h223AnnexADoubleFlag (OOCTXT* pctxt, H245H223MultiplexReconfiguration_h223AnnexADoubleFlag* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* start */
         case 1:
            /* NULL */
            break;

         /* stop */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223MultiplexReconfiguration                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223MultiplexReconfiguration (OOCTXT* pctxt, H245H223MultiplexReconfiguration* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* h223ModeChange */
         case 1:
            stat = asn1PE_H245H223MultiplexReconfiguration_h223ModeChange (pctxt, pvalue->u.h223ModeChange);
            if (stat != ASN_OK) return stat;
            break;

         /* h223AnnexADoubleFlag */
         case 2:
            stat = asn1PE_H245H223MultiplexReconfiguration_h223AnnexADoubleFlag (pctxt, pvalue->u.h223AnnexADoubleFlag);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCCommand_aal_aal1_clockRecovery                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCCommand_aal_aal1_clockRecovery (OOCTXT* pctxt, H245NewATMVCCommand_aal_aal1_clockRecovery* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nullClockRecovery */
         case 1:
            /* NULL */
            break;

         /* srtsClockRecovery */
         case 2:
            /* NULL */
            break;

         /* adaptiveClockRecovery */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCCommand_aal_aal1_errorCorrection                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCCommand_aal_aal1_errorCorrection (OOCTXT* pctxt, H245NewATMVCCommand_aal_aal1_errorCorrection* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nullErrorCorrection */
         case 1:
            /* NULL */
            break;

         /* longInterleaver */
         case 2:
            /* NULL */
            break;

         /* shortInterleaver */
         case 3:
            /* NULL */
            break;

         /* errorCorrectionOnly */
         case 4:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCCommand_aal_aal1                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCCommand_aal_aal1 (OOCTXT* pctxt, H245NewATMVCCommand_aal_aal1* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode clockRecovery */

   stat = asn1PE_H245NewATMVCCommand_aal_aal1_clockRecovery (pctxt, &pvalue->clockRecovery);
   if (stat != ASN_OK) return stat;

   /* encode errorCorrection */

   stat = asn1PE_H245NewATMVCCommand_aal_aal1_errorCorrection (pctxt, &pvalue->errorCorrection);
   if (stat != ASN_OK) return stat;

   /* encode structuredDataTransfer */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->structuredDataTransfer);
   if (stat != ASN_OK) return stat;

   /* encode partiallyFilledCells */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->partiallyFilledCells);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCCommand_aal_aal5                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCCommand_aal_aal5 (OOCTXT* pctxt, H245NewATMVCCommand_aal_aal5* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode forwardMaximumSDUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->forwardMaximumSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode backwardMaximumSDUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->backwardMaximumSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCCommand_aal                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCCommand_aal (OOCTXT* pctxt, H245NewATMVCCommand_aal* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* aal1 */
         case 1:
            stat = asn1PE_H245NewATMVCCommand_aal_aal1 (pctxt, pvalue->u.aal1);
            if (stat != ASN_OK) return stat;
            break;

         /* aal5 */
         case 2:
            stat = asn1PE_H245NewATMVCCommand_aal_aal5 (pctxt, pvalue->u.aal5);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCCommand_multiplex                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCCommand_multiplex (OOCTXT* pctxt, H245NewATMVCCommand_multiplex* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* noMultiplex */
         case 1:
            /* NULL */
            break;

         /* transportStream */
         case 2:
            /* NULL */
            break;

         /* programStream */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCCommand_reverseParameters_multiplex               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCCommand_reverseParameters_multiplex (OOCTXT* pctxt, H245NewATMVCCommand_reverseParameters_multiplex* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* noMultiplex */
         case 1:
            /* NULL */
            break;

         /* transportStream */
         case 2:
            /* NULL */
            break;

         /* programStream */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCCommand_reverseParameters                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCCommand_reverseParameters (OOCTXT* pctxt, H245NewATMVCCommand_reverseParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode bitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->bitRate, 1U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode bitRateLockedToPCRClock */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->bitRateLockedToPCRClock);
   if (stat != ASN_OK) return stat;

   /* encode bitRateLockedToNetworkClock */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->bitRateLockedToNetworkClock);
   if (stat != ASN_OK) return stat;

   /* encode multiplex */

   stat = asn1PE_H245NewATMVCCommand_reverseParameters_multiplex (pctxt, &pvalue->multiplex);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCCommand                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCCommand (OOCTXT* pctxt, H245NewATMVCCommand* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode resourceID */

   stat = encodeConsUnsigned (pctxt, pvalue->resourceID, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode bitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->bitRate, 1U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode bitRateLockedToPCRClock */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->bitRateLockedToPCRClock);
   if (stat != ASN_OK) return stat;

   /* encode bitRateLockedToNetworkClock */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->bitRateLockedToNetworkClock);
   if (stat != ASN_OK) return stat;

   /* encode aal */

   stat = asn1PE_H245NewATMVCCommand_aal (pctxt, &pvalue->aal);
   if (stat != ASN_OK) return stat;

   /* encode multiplex */

   stat = asn1PE_H245NewATMVCCommand_multiplex (pctxt, &pvalue->multiplex);
   if (stat != ASN_OK) return stat;

   /* encode reverseParameters */

   stat = asn1PE_H245NewATMVCCommand_reverseParameters (pctxt, &pvalue->reverseParameters);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MobileMultilinkReconfigurationCommand_status              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MobileMultilinkReconfigurationCommand_status (OOCTXT* pctxt, H245MobileMultilinkReconfigurationCommand_status* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* synchronized_ */
         case 1:
            /* NULL */
            break;

         /* reconfiguration */
         case 2:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MobileMultilinkReconfigurationCommand                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MobileMultilinkReconfigurationCommand (OOCTXT* pctxt, H245MobileMultilinkReconfigurationCommand* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sampleSize */

   stat = encodeConsUnsigned (pctxt, pvalue->sampleSize, 1U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode samplesPerFrame */

   stat = encodeConsUnsigned (pctxt, pvalue->samplesPerFrame, 1U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode status */

   stat = asn1PE_H245MobileMultilinkReconfigurationCommand_status (pctxt, &pvalue->status);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  CommandMessage                                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245CommandMessage (OOCTXT* pctxt, H245CommandMessage* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 7);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 6);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* maintenanceLoopOffCommand */
         case 2:
            stat = asn1PE_H245MaintenanceLoopOffCommand (pctxt, pvalue->u.maintenanceLoopOffCommand);
            if (stat != ASN_OK) return stat;
            break;

         /* sendTerminalCapabilitySet */
         case 3:
            stat = asn1PE_H245SendTerminalCapabilitySet (pctxt, pvalue->u.sendTerminalCapabilitySet);
            if (stat != ASN_OK) return stat;
            break;

         /* encryptionCommand */
         case 4:
            stat = asn1PE_H245EncryptionCommand (pctxt, pvalue->u.encryptionCommand);
            if (stat != ASN_OK) return stat;
            break;

         /* flowControlCommand */
         case 5:
            stat = asn1PE_H245FlowControlCommand (pctxt, pvalue->u.flowControlCommand);
            if (stat != ASN_OK) return stat;
            break;

         /* endSessionCommand */
         case 6:
            stat = asn1PE_H245EndSessionCommand (pctxt, pvalue->u.endSessionCommand);
            if (stat != ASN_OK) return stat;
            break;

         /* miscellaneousCommand */
         case 7:
            stat = asn1PE_H245MiscellaneousCommand (pctxt, pvalue->u.miscellaneousCommand);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 8);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* communicationModeCommand */
         case 8:
            stat = asn1PE_H245CommunicationModeCommand (&lctxt, pvalue->u.communicationModeCommand);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* conferenceCommand */
         case 9:
            stat = asn1PE_H245ConferenceCommand (&lctxt, pvalue->u.conferenceCommand);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* h223MultiplexReconfiguration */
         case 10:
            stat = asn1PE_H245H223MultiplexReconfiguration (&lctxt, pvalue->u.h223MultiplexReconfiguration);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* newATMVCCommand */
         case 11:
            stat = asn1PE_H245NewATMVCCommand (&lctxt, pvalue->u.newATMVCCommand);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* mobileMultilinkReconfigurationCommand */
         case 12:
            stat = asn1PE_H245MobileMultilinkReconfigurationCommand (&lctxt, pvalue->u.mobileMultilinkReconfigurationCommand);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FunctionNotUnderstood                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FunctionNotUnderstood (OOCTXT* pctxt, H245FunctionNotUnderstood* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* request */
      case 1:
         stat = asn1PE_H245RequestMessage (pctxt, pvalue->u.request);
         if (stat != ASN_OK) return stat;
         break;

      /* response */
      case 2:
         stat = asn1PE_H245ResponseMessage (pctxt, pvalue->u.response);
         if (stat != ASN_OK) return stat;
         break;

      /* command */
      case 3:
         stat = asn1PE_H245CommandMessage (pctxt, pvalue->u.command);
         if (stat != ASN_OK) return stat;
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MasterSlaveDeterminationRelease                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MasterSlaveDeterminationRelease (OOCTXT* pctxt, H245MasterSlaveDeterminationRelease* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalCapabilitySetRelease                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalCapabilitySetRelease (OOCTXT* pctxt, H245TerminalCapabilitySetRelease* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  OpenLogicalChannelConfirm                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245OpenLogicalChannelConfirm (OOCTXT* pctxt, H245OpenLogicalChannelConfirm* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode forwardLogicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestChannelCloseRelease                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestChannelCloseRelease (OOCTXT* pctxt, H245RequestChannelCloseRelease* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode forwardLogicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->forwardLogicalChannelNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySendRelease_multiplexTableEntryNumber       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntrySendRelease_multiplexTableEntryNumber (OOCTXT* pctxt, H245MultiplexEntrySendRelease_multiplexTableEntryNumber* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = asn1PE_H245MultiplexTableEntryNumber (pctxt, pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultiplexEntrySendRelease                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultiplexEntrySendRelease (OOCTXT* pctxt, H245MultiplexEntrySendRelease* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode multiplexTableEntryNumber */

   stat = asn1PE_H245MultiplexEntrySendRelease_multiplexTableEntryNumber (pctxt, &pvalue->multiplexTableEntryNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryRelease_entryNumbers                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMultiplexEntryRelease_entryNumbers (OOCTXT* pctxt, H245RequestMultiplexEntryRelease_entryNumbers* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 15, 0 };
   int stat = ASN_OK;
   ASN1UINT xx1;

   /* encode length determinant */

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeLength (pctxt, pvalue->n);
   if (stat < 0) return stat;

   /* encode elements */

   for (xx1 = 0; xx1 < pvalue->n; xx1++) {
      stat = asn1PE_H245MultiplexTableEntryNumber (pctxt, pvalue->elem[xx1]);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestMultiplexEntryRelease                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestMultiplexEntryRelease (OOCTXT* pctxt, H245RequestMultiplexEntryRelease* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode entryNumbers */

   stat = asn1PE_H245RequestMultiplexEntryRelease_entryNumbers (pctxt, &pvalue->entryNumbers);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  RequestModeRelease                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245RequestModeRelease (OOCTXT* pctxt, H245RequestModeRelease* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousIndication_type_videoNotDecodedMBs           */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MiscellaneousIndication_type_videoNotDecodedMBs (OOCTXT* pctxt, H245MiscellaneousIndication_type_videoNotDecodedMBs* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode firstMB */

   stat = encodeConsUnsigned (pctxt, pvalue->firstMB, 1U, 8192U);
   if (stat != ASN_OK) return stat;

   /* encode numberOfMBs */

   stat = encodeConsUnsigned (pctxt, pvalue->numberOfMBs, 1U, 8192U);
   if (stat != ASN_OK) return stat;

   /* encode temporalReference */

   stat = encodeConsUnsigned (pctxt, pvalue->temporalReference, 0U, 255U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousIndication_type                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MiscellaneousIndication_type (OOCTXT* pctxt, H245MiscellaneousIndication_type* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 10);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 9);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* logicalChannelActive */
         case 1:
            /* NULL */
            break;

         /* logicalChannelInactive */
         case 2:
            /* NULL */
            break;

         /* multipointConference */
         case 3:
            /* NULL */
            break;

         /* cancelMultipointConference */
         case 4:
            /* NULL */
            break;

         /* multipointZeroComm */
         case 5:
            /* NULL */
            break;

         /* cancelMultipointZeroComm */
         case 6:
            /* NULL */
            break;

         /* multipointSecondaryStatus */
         case 7:
            /* NULL */
            break;

         /* cancelMultipointSecondaryStatus */
         case 8:
            /* NULL */
            break;

         /* videoIndicateReadyToActivate */
         case 9:
            /* NULL */
            break;

         /* videoTemporalSpatialTradeOff */
         case 10:
            stat = encodeConsUnsigned (pctxt, pvalue->u.videoTemporalSpatialTradeOff, 0U, 31U);
            if (stat != ASN_OK) return stat;

            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 11);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* videoNotDecodedMBs */
         case 11:
            stat = asn1PE_H245MiscellaneousIndication_type_videoNotDecodedMBs (&lctxt, pvalue->u.videoNotDecodedMBs);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* transportCapability */
         case 12:
            stat = asn1PE_H245TransportCapability (&lctxt, pvalue->u.transportCapability);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MiscellaneousIndication                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MiscellaneousIndication (OOCTXT* pctxt, H245MiscellaneousIndication* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode logicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   /* encode type */

   stat = asn1PE_H245MiscellaneousIndication_type (pctxt, &pvalue->type);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  JitterIndication_scope                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245JitterIndication_scope (OOCTXT* pctxt, H245JitterIndication_scope* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* logicalChannelNumber */
      case 1:
         stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->u.logicalChannelNumber);
         if (stat != ASN_OK) return stat;
         break;

      /* resourceID */
      case 2:
         stat = encodeConsUnsigned (pctxt, pvalue->u.resourceID, 0U, 65535U);
         if (stat != ASN_OK) return stat;

         break;

      /* wholeMultiplex */
      case 3:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  JitterIndication                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245JitterIndication (OOCTXT* pctxt, H245JitterIndication* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.skippedFrameCountPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.additionalDecoderBufferPresent);

   /* encode scope */

   stat = asn1PE_H245JitterIndication_scope (pctxt, &pvalue->scope);
   if (stat != ASN_OK) return stat;

   /* encode estimatedReceivedJitterMantissa */

   stat = encodeConsUnsigned (pctxt, pvalue->estimatedReceivedJitterMantissa, 0U, 3U);
   if (stat != ASN_OK) return stat;

   /* encode estimatedReceivedJitterExponent */

   stat = encodeConsUnsigned (pctxt, pvalue->estimatedReceivedJitterExponent, 0U, 7U);
   if (stat != ASN_OK) return stat;

   /* encode skippedFrameCount */

   if (pvalue->m.skippedFrameCountPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->skippedFrameCount, 0U, 15U);
      if (stat != ASN_OK) return stat;

   }

   /* encode additionalDecoderBuffer */

   if (pvalue->m.additionalDecoderBufferPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->additionalDecoderBuffer, 0U, 262143U);
      if (stat != ASN_OK) return stat;

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H223SkewIndication                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H223SkewIndication (OOCTXT* pctxt, H245H223SkewIndication* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode logicalChannelNumber1 */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber1);
   if (stat != ASN_OK) return stat;

   /* encode logicalChannelNumber2 */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber2);
   if (stat != ASN_OK) return stat;

   /* encode skew */

   stat = encodeConsUnsigned (pctxt, pvalue->skew, 0U, 4095U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCIndication_aal_aal1_clockRecovery                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCIndication_aal_aal1_clockRecovery (OOCTXT* pctxt, H245NewATMVCIndication_aal_aal1_clockRecovery* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nullClockRecovery */
         case 1:
            /* NULL */
            break;

         /* srtsClockRecovery */
         case 2:
            /* NULL */
            break;

         /* adaptiveClockRecovery */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCIndication_aal_aal1_errorCorrection               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCIndication_aal_aal1_errorCorrection (OOCTXT* pctxt, H245NewATMVCIndication_aal_aal1_errorCorrection* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nullErrorCorrection */
         case 1:
            /* NULL */
            break;

         /* longInterleaver */
         case 2:
            /* NULL */
            break;

         /* shortInterleaver */
         case 3:
            /* NULL */
            break;

         /* errorCorrectionOnly */
         case 4:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCIndication_aal_aal1                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCIndication_aal_aal1 (OOCTXT* pctxt, H245NewATMVCIndication_aal_aal1* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode clockRecovery */

   stat = asn1PE_H245NewATMVCIndication_aal_aal1_clockRecovery (pctxt, &pvalue->clockRecovery);
   if (stat != ASN_OK) return stat;

   /* encode errorCorrection */

   stat = asn1PE_H245NewATMVCIndication_aal_aal1_errorCorrection (pctxt, &pvalue->errorCorrection);
   if (stat != ASN_OK) return stat;

   /* encode structuredDataTransfer */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->structuredDataTransfer);
   if (stat != ASN_OK) return stat;

   /* encode partiallyFilledCells */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->partiallyFilledCells);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCIndication_aal_aal5                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCIndication_aal_aal5 (OOCTXT* pctxt, H245NewATMVCIndication_aal_aal5* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode forwardMaximumSDUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->forwardMaximumSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode backwardMaximumSDUSize */

   stat = encodeConsUnsigned (pctxt, pvalue->backwardMaximumSDUSize, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCIndication_aal                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCIndication_aal (OOCTXT* pctxt, H245NewATMVCIndication_aal* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* aal1 */
         case 1:
            stat = asn1PE_H245NewATMVCIndication_aal_aal1 (pctxt, pvalue->u.aal1);
            if (stat != ASN_OK) return stat;
            break;

         /* aal5 */
         case 2:
            stat = asn1PE_H245NewATMVCIndication_aal_aal5 (pctxt, pvalue->u.aal5);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCIndication_multiplex                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCIndication_multiplex (OOCTXT* pctxt, H245NewATMVCIndication_multiplex* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* noMultiplex */
         case 1:
            /* NULL */
            break;

         /* transportStream */
         case 2:
            /* NULL */
            break;

         /* programStream */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCIndication_reverseParameters_multiplex            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCIndication_reverseParameters_multiplex (OOCTXT* pctxt, H245NewATMVCIndication_reverseParameters_multiplex* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* noMultiplex */
         case 1:
            /* NULL */
            break;

         /* transportStream */
         case 2:
            /* NULL */
            break;

         /* programStream */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCIndication_reverseParameters                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCIndication_reverseParameters (OOCTXT* pctxt, H245NewATMVCIndication_reverseParameters* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode bitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->bitRate, 1U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode bitRateLockedToPCRClock */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->bitRateLockedToPCRClock);
   if (stat != ASN_OK) return stat;

   /* encode bitRateLockedToNetworkClock */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->bitRateLockedToNetworkClock);
   if (stat != ASN_OK) return stat;

   /* encode multiplex */

   stat = asn1PE_H245NewATMVCIndication_reverseParameters_multiplex (pctxt, &pvalue->multiplex);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NewATMVCIndication                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245NewATMVCIndication (OOCTXT* pctxt, H245NewATMVCIndication* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.reverseParametersPresent);

   encodeBit (pctxt, extbit);

   /* encode resourceID */

   stat = encodeConsUnsigned (pctxt, pvalue->resourceID, 0U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode bitRate */

   stat = encodeConsUnsigned (pctxt, pvalue->bitRate, 1U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode bitRateLockedToPCRClock */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->bitRateLockedToPCRClock);
   if (stat != ASN_OK) return stat;

   /* encode bitRateLockedToNetworkClock */

   stat = encodeBit (pctxt, (ASN1BOOL)pvalue->bitRateLockedToNetworkClock);
   if (stat != ASN_OK) return stat;

   /* encode aal */

   stat = asn1PE_H245NewATMVCIndication_aal (pctxt, &pvalue->aal);
   if (stat != ASN_OK) return stat;

   /* encode multiplex */

   stat = asn1PE_H245NewATMVCIndication_multiplex (pctxt, &pvalue->multiplex);
   if (stat != ASN_OK) return stat;

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.reverseParametersPresent);
      /* encode extension elements */

      if (pvalue->m.reverseParametersPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = asn1PE_H245NewATMVCIndication_reverseParameters (&lctxt, &pvalue->reverseParameters);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UserInputIndication_userInputSupportIndication            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UserInputIndication_userInputSupportIndication (OOCTXT* pctxt, H245UserInputIndication_userInputSupportIndication* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* basicString */
         case 2:
            /* NULL */
            break;

         /* iA5String */
         case 3:
            /* NULL */
            break;

         /* generalString */
         case 4:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UserInputIndication_signal_rtp                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UserInputIndication_signal_rtp (OOCTXT* pctxt, H245UserInputIndication_signal_rtp* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.timestampPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.expirationTimePresent);

   /* encode timestamp */

   if (pvalue->m.timestampPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->timestamp, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   /* encode expirationTime */

   if (pvalue->m.expirationTimePresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->expirationTime, 0U, ASN1UINT_MAX);
      if (stat != ASN_OK) return stat;

   }

   /* encode logicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UserInputIndication_signal                                */
/*                                                            */
/**************************************************************/

extern EXTERN const char* gs_MULTIMEDIA_SYSTEM_CONTROL_UserInputIndication_signal_signalType_CharSet;

EXTERN int asn1PE_H245UserInputIndication_signal (OOCTXT* pctxt, H245UserInputIndication_signal* pvalue)
{
   static Asn1SizeCnst signalType_lsize1 = { 0, 1, 1, 0 };
   int stat = ASN_OK;
   ASN1BOOL extbit;
   ASN1OpenType openType;
   OOCTXT lctxt;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->m.rtpPayloadIndicationPresent);

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.durationPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.rtpPresent);

   /* encode signalType */

   addSizeConstraint (pctxt, &signalType_lsize1);

   stat = encodeConstrainedStringEx (pctxt, pvalue->signalType, gs_MULTIMEDIA_SYSTEM_CONTROL_UserInputIndication_signal_signalType_CharSet, 8, 5, 7);
   if (stat != ASN_OK) return stat;

   /* encode duration */

   if (pvalue->m.durationPresent) {
      stat = encodeConsUnsigned (pctxt, pvalue->duration, 1U, 65535U);
      if (stat != ASN_OK) return stat;

   }

   /* encode rtp */

   if (pvalue->m.rtpPresent) {
      stat = asn1PE_H245UserInputIndication_signal_rtp (pctxt, &pvalue->rtp);
      if (stat != ASN_OK) return stat;
   }

   if (extbit) {

      /* encode extension optional bits length */

      stat = encodeSmallNonNegWholeNumber (pctxt, 0);
      if (stat != ASN_OK) return stat;

      /* encode optional bits */

      encodeBit (pctxt, (ASN1BOOL)pvalue->m.rtpPayloadIndicationPresent);
      /* encode extension elements */

      if (pvalue->m.rtpPayloadIndicationPresent) {
         initContext (&lctxt);
         stat = setPERBuffer (&lctxt, 0, 0, TRUE);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         /* NULL */

         stat = encodeByteAlign (&lctxt);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);

         stat = encodeOpenType (pctxt, openType.numocts, openType.data);
         if (stat != ASN_OK) return freeContext (&lctxt), stat;

         freeContext (&lctxt);
      }

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UserInputIndication_signalUpdate_rtp                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UserInputIndication_signalUpdate_rtp (OOCTXT* pctxt, H245UserInputIndication_signalUpdate_rtp* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode logicalChannelNumber */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UserInputIndication_signalUpdate                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UserInputIndication_signalUpdate (OOCTXT* pctxt, H245UserInputIndication_signalUpdate* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.rtpPresent);

   /* encode duration */

   stat = encodeConsUnsigned (pctxt, pvalue->duration, 1U, 65535U);
   if (stat != ASN_OK) return stat;

   /* encode rtp */

   if (pvalue->m.rtpPresent) {
      stat = asn1PE_H245UserInputIndication_signalUpdate_rtp (pctxt, &pvalue->rtp);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UserInputIndication_extendedAlphanumeric                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UserInputIndication_extendedAlphanumeric (OOCTXT* pctxt, H245UserInputIndication_extendedAlphanumeric* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.rtpPayloadIndicationPresent);

   /* encode alphanumeric */

   stat = encodeVarWidthCharString (pctxt, pvalue->alphanumeric);
   if (stat != ASN_OK) return stat;

   /* encode rtpPayloadIndication */

   if (pvalue->m.rtpPayloadIndicationPresent) {
      /* NULL */
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UserInputIndication                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245UserInputIndication (OOCTXT* pctxt, H245UserInputIndication* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 2);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardParameter (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* alphanumeric */
         case 2:
            stat = encodeVarWidthCharString (pctxt, pvalue->u.alphanumeric);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 3);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* userInputSupportIndication */
         case 3:
            stat = asn1PE_H245UserInputIndication_userInputSupportIndication (&lctxt, pvalue->u.userInputSupportIndication);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* signal */
         case 4:
            stat = asn1PE_H245UserInputIndication_signal (&lctxt, pvalue->u.signal);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* signalUpdate */
         case 5:
            stat = asn1PE_H245UserInputIndication_signalUpdate (&lctxt, pvalue->u.signalUpdate);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* extendedAlphanumeric */
         case 6:
            stat = asn1PE_H245UserInputIndication_extendedAlphanumeric (&lctxt, pvalue->u.extendedAlphanumeric);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  H2250MaximumSkewIndication                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245H2250MaximumSkewIndication (OOCTXT* pctxt, H245H2250MaximumSkewIndication* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode logicalChannelNumber1 */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber1);
   if (stat != ASN_OK) return stat;

   /* encode logicalChannelNumber2 */

   stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->logicalChannelNumber2);
   if (stat != ASN_OK) return stat;

   /* encode maximumSkew */

   stat = encodeConsUnsigned (pctxt, pvalue->maximumSkew, 0U, 4095U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MCLocationIndication                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MCLocationIndication (OOCTXT* pctxt, H245MCLocationIndication* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode signalAddress */

   stat = asn1PE_H245TransportAddress (pctxt, &pvalue->signalAddress);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TerminalYouAreSeeingInSubPictureNumber                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245TerminalYouAreSeeingInSubPictureNumber (OOCTXT* pctxt, H245TerminalYouAreSeeingInSubPictureNumber* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode terminalNumber */

   stat = asn1PE_H245TerminalNumber (pctxt, pvalue->terminalNumber);
   if (stat != ASN_OK) return stat;

   /* encode subPictureNumber */

   stat = encodeConsUnsigned (pctxt, pvalue->subPictureNumber, 0U, 255U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VideoIndicateCompose                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VideoIndicateCompose (OOCTXT* pctxt, H245VideoIndicateCompose* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode compositionNumber */

   stat = encodeConsUnsigned (pctxt, pvalue->compositionNumber, 0U, 255U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ConferenceIndication                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245ConferenceIndication (OOCTXT* pctxt, H245ConferenceIndication* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 10);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 9);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* sbeNumber */
         case 1:
            stat = encodeConsUnsigned (pctxt, pvalue->u.sbeNumber, 0U, 9U);
            if (stat != ASN_OK) return stat;

            break;

         /* terminalNumberAssign */
         case 2:
            stat = asn1PE_H245TerminalLabel (pctxt, pvalue->u.terminalNumberAssign);
            if (stat != ASN_OK) return stat;
            break;

         /* terminalJoinedConference */
         case 3:
            stat = asn1PE_H245TerminalLabel (pctxt, pvalue->u.terminalJoinedConference);
            if (stat != ASN_OK) return stat;
            break;

         /* terminalLeftConference */
         case 4:
            stat = asn1PE_H245TerminalLabel (pctxt, pvalue->u.terminalLeftConference);
            if (stat != ASN_OK) return stat;
            break;

         /* seenByAtLeastOneOther */
         case 5:
            /* NULL */
            break;

         /* cancelSeenByAtLeastOneOther */
         case 6:
            /* NULL */
            break;

         /* seenByAll */
         case 7:
            /* NULL */
            break;

         /* cancelSeenByAll */
         case 8:
            /* NULL */
            break;

         /* terminalYouAreSeeing */
         case 9:
            stat = asn1PE_H245TerminalLabel (pctxt, pvalue->u.terminalYouAreSeeing);
            if (stat != ASN_OK) return stat;
            break;

         /* requestForFloor */
         case 10:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 11);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* withdrawChairToken */
         case 11:
            /* NULL */
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* floorRequested */
         case 12:
            stat = asn1PE_H245TerminalLabel (&lctxt, pvalue->u.floorRequested);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* terminalYouAreSeeingInSubPictureNumber */
         case 13:
            stat = asn1PE_H245TerminalYouAreSeeingInSubPictureNumber (&lctxt, pvalue->u.terminalYouAreSeeingInSubPictureNumber);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* videoIndicateCompose */
         case 14:
            stat = asn1PE_H245VideoIndicateCompose (&lctxt, pvalue->u.videoIndicateCompose);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VendorIdentification_productNumber                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VendorIdentification_productNumber (OOCTXT* pctxt, H245VendorIdentification_productNumber* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VendorIdentification_versionNumber                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VendorIdentification_versionNumber (OOCTXT* pctxt, H245VendorIdentification_versionNumber* pvalue)
{
   static Asn1SizeCnst lsize1 = { 0, 1, 256, 0 };
   int stat = ASN_OK;

   addSizeConstraint (pctxt, &lsize1);

   stat = encodeOctetString (pctxt, pvalue->numocts, pvalue->data);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  VendorIdentification                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245VendorIdentification (OOCTXT* pctxt, H245VendorIdentification* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.productNumberPresent);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.versionNumberPresent);

   /* encode vendor */

   stat = asn1PE_H245NonStandardIdentifier (pctxt, &pvalue->vendor);
   if (stat != ASN_OK) return stat;

   /* encode productNumber */

   if (pvalue->m.productNumberPresent) {
      stat = asn1PE_H245VendorIdentification_productNumber (pctxt, &pvalue->productNumber);
      if (stat != ASN_OK) return stat;
   }

   /* encode versionNumber */

   if (pvalue->m.versionNumberPresent) {
      stat = asn1PE_H245VendorIdentification_versionNumber (pctxt, &pvalue->versionNumber);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FunctionNotSupported_cause                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FunctionNotSupported_cause (OOCTXT* pctxt, H245FunctionNotSupported_cause* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* syntaxError */
         case 1:
            /* NULL */
            break;

         /* semanticError */
         case 2:
            /* NULL */
            break;

         /* unknownFunction */
         case 3:
            /* NULL */
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FunctionNotSupported                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FunctionNotSupported (OOCTXT* pctxt, H245FunctionNotSupported* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   encodeBit (pctxt, (ASN1BOOL)pvalue->m.returnedFunctionPresent);

   /* encode cause */

   stat = asn1PE_H245FunctionNotSupported_cause (pctxt, &pvalue->cause);
   if (stat != ASN_OK) return stat;

   /* encode returnedFunction */

   if (pvalue->m.returnedFunctionPresent) {
      stat = encodeOctetString (pctxt, pvalue->returnedFunction.numocts, pvalue->returnedFunction.data);
      if (stat != ASN_OK) return stat;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkIndication_crcDesired                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkIndication_crcDesired (OOCTXT* pctxt, H245MultilinkIndication_crcDesired* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkIndication_excessiveError                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkIndication_excessiveError (OOCTXT* pctxt, H245MultilinkIndication_excessiveError* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode connectionIdentifier */

   stat = asn1PE_H245ConnectionIdentifier (pctxt, &pvalue->connectionIdentifier);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultilinkIndication                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultilinkIndication (OOCTXT* pctxt, H245MultilinkIndication* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 3);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* crcDesired */
         case 2:
            stat = asn1PE_H245MultilinkIndication_crcDesired (pctxt, pvalue->u.crcDesired);
            if (stat != ASN_OK) return stat;
            break;

         /* excessiveError */
         case 3:
            stat = asn1PE_H245MultilinkIndication_excessiveError (pctxt, pvalue->u.excessiveError);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 4);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  LogicalChannelRateRelease                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245LogicalChannelRateRelease (OOCTXT* pctxt, H245LogicalChannelRateRelease* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FlowControlIndication_scope                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FlowControlIndication_scope (OOCTXT* pctxt, H245FlowControlIndication_scope* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 2);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* logicalChannelNumber */
      case 1:
         stat = asn1PE_H245LogicalChannelNumber (pctxt, pvalue->u.logicalChannelNumber);
         if (stat != ASN_OK) return stat;
         break;

      /* resourceID */
      case 2:
         stat = encodeConsUnsigned (pctxt, pvalue->u.resourceID, 0U, 65535U);
         if (stat != ASN_OK) return stat;

         break;

      /* wholeMultiplex */
      case 3:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FlowControlIndication_restriction                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FlowControlIndication_restriction (OOCTXT* pctxt, H245FlowControlIndication_restriction* pvalue)
{
   int stat = ASN_OK;

   /* Encode choice index value */

   stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 1);
   if (stat != ASN_OK) return stat;

   /* Encode root element data value */

   switch (pvalue->t)
   {
      /* maximumBitRate */
      case 1:
         stat = encodeConsUnsigned (pctxt, pvalue->u.maximumBitRate, 0U, 16777215U);
         if (stat != ASN_OK) return stat;

         break;

      /* noRestriction */
      case 2:
         /* NULL */
         break;

      default:
         return ASN_E_INVOPT;
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  FlowControlIndication                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245FlowControlIndication (OOCTXT* pctxt, H245FlowControlIndication* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode scope */

   stat = asn1PE_H245FlowControlIndication_scope (pctxt, &pvalue->scope);
   if (stat != ASN_OK) return stat;

   /* encode restriction */

   stat = asn1PE_H245FlowControlIndication_restriction (pctxt, &pvalue->restriction);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MobileMultilinkReconfigurationIndication                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MobileMultilinkReconfigurationIndication (OOCTXT* pctxt, H245MobileMultilinkReconfigurationIndication* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = 0;

   encodeBit (pctxt, extbit);

   /* encode sampleSize */

   stat = encodeConsUnsigned (pctxt, pvalue->sampleSize, 1U, 255U);
   if (stat != ASN_OK) return stat;

   /* encode samplesPerFrame */

   stat = encodeConsUnsigned (pctxt, pvalue->samplesPerFrame, 1U, 255U);
   if (stat != ASN_OK) return stat;

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IndicationMessage                                         */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245IndicationMessage (OOCTXT* pctxt, H245IndicationMessage* pvalue)
{
   int stat = ASN_OK;
   OOCTXT lctxt;
   ASN1OpenType openType;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 14);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 13);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* nonStandard */
         case 1:
            stat = asn1PE_H245NonStandardMessage (pctxt, pvalue->u.nonStandard);
            if (stat != ASN_OK) return stat;
            break;

         /* functionNotUnderstood */
         case 2:
            stat = asn1PE_H245FunctionNotUnderstood (pctxt, pvalue->u.functionNotUnderstood);
            if (stat != ASN_OK) return stat;
            break;

         /* masterSlaveDeterminationRelease */
         case 3:
            stat = asn1PE_H245MasterSlaveDeterminationRelease (pctxt, pvalue->u.masterSlaveDeterminationRelease);
            if (stat != ASN_OK) return stat;
            break;

         /* terminalCapabilitySetRelease */
         case 4:
            stat = asn1PE_H245TerminalCapabilitySetRelease (pctxt, pvalue->u.terminalCapabilitySetRelease);
            if (stat != ASN_OK) return stat;
            break;

         /* openLogicalChannelConfirm */
         case 5:
            stat = asn1PE_H245OpenLogicalChannelConfirm (pctxt, pvalue->u.openLogicalChannelConfirm);
            if (stat != ASN_OK) return stat;
            break;

         /* requestChannelCloseRelease */
         case 6:
            stat = asn1PE_H245RequestChannelCloseRelease (pctxt, pvalue->u.requestChannelCloseRelease);
            if (stat != ASN_OK) return stat;
            break;

         /* multiplexEntrySendRelease */
         case 7:
            stat = asn1PE_H245MultiplexEntrySendRelease (pctxt, pvalue->u.multiplexEntrySendRelease);
            if (stat != ASN_OK) return stat;
            break;

         /* requestMultiplexEntryRelease */
         case 8:
            stat = asn1PE_H245RequestMultiplexEntryRelease (pctxt, pvalue->u.requestMultiplexEntryRelease);
            if (stat != ASN_OK) return stat;
            break;

         /* requestModeRelease */
         case 9:
            stat = asn1PE_H245RequestModeRelease (pctxt, pvalue->u.requestModeRelease);
            if (stat != ASN_OK) return stat;
            break;

         /* miscellaneousIndication */
         case 10:
            stat = asn1PE_H245MiscellaneousIndication (pctxt, pvalue->u.miscellaneousIndication);
            if (stat != ASN_OK) return stat;
            break;

         /* jitterIndication */
         case 11:
            stat = asn1PE_H245JitterIndication (pctxt, pvalue->u.jitterIndication);
            if (stat != ASN_OK) return stat;
            break;

         /* h223SkewIndication */
         case 12:
            stat = asn1PE_H245H223SkewIndication (pctxt, pvalue->u.h223SkewIndication);
            if (stat != ASN_OK) return stat;
            break;

         /* newATMVCIndication */
         case 13:
            stat = asn1PE_H245NewATMVCIndication (pctxt, pvalue->u.newATMVCIndication);
            if (stat != ASN_OK) return stat;
            break;

         /* userInput */
         case 14:
            stat = asn1PE_H245UserInputIndication (pctxt, pvalue->u.userInput);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 15);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

      initContext (&lctxt);
      stat = setPERBuffer (&lctxt, 0, 0, TRUE);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      switch (pvalue->t)
      {
         /* h2250MaximumSkewIndication */
         case 15:
            stat = asn1PE_H245H2250MaximumSkewIndication (&lctxt, pvalue->u.h2250MaximumSkewIndication);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* mcLocationIndication */
         case 16:
            stat = asn1PE_H245MCLocationIndication (&lctxt, pvalue->u.mcLocationIndication);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* conferenceIndication */
         case 17:
            stat = asn1PE_H245ConferenceIndication (&lctxt, pvalue->u.conferenceIndication);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* vendorIdentification */
         case 18:
            stat = asn1PE_H245VendorIdentification (&lctxt, pvalue->u.vendorIdentification);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* functionNotSupported */
         case 19:
            stat = asn1PE_H245FunctionNotSupported (&lctxt, pvalue->u.functionNotSupported);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* multilinkIndication */
         case 20:
            stat = asn1PE_H245MultilinkIndication (&lctxt, pvalue->u.multilinkIndication);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* logicalChannelRateRelease */
         case 21:
            stat = asn1PE_H245LogicalChannelRateRelease (&lctxt, pvalue->u.logicalChannelRateRelease);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* flowControlIndication */
         case 22:
            stat = asn1PE_H245FlowControlIndication (&lctxt, pvalue->u.flowControlIndication);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         /* mobileMultilinkReconfigurationIndication */
         case 23:
            stat = asn1PE_H245MobileMultilinkReconfigurationIndication (&lctxt, pvalue->u.mobileMultilinkReconfigurationIndication);
            if (stat != ASN_OK) return freeContext (&lctxt), stat;
            openType.data = encodeGetMsgPtr (&lctxt, (int*)&openType.numocts);
            break;

         default:
            ;
      }

      stat = encodeByteAlign (pctxt);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      stat = encodeOpenType (pctxt, openType.numocts, openType.data);
      if (stat != ASN_OK) return freeContext (&lctxt), stat;

      freeContext (&lctxt);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MultimediaSystemControlMessage                            */
/*                                                            */
/**************************************************************/

EXTERN int asn1PE_H245MultimediaSystemControlMessage (OOCTXT* pctxt, H245MultimediaSystemControlMessage* pvalue)
{
   int stat = ASN_OK;
   ASN1BOOL extbit;

   /* extension bit */

   extbit = (ASN1BOOL)(pvalue->t > 4);

   encodeBit (pctxt, extbit);

   if (!extbit) {

      /* Encode choice index value */

      stat = encodeConsUnsigned (pctxt, pvalue->t - 1, 0, 3);
      if (stat != ASN_OK) return stat;

      /* Encode root element data value */

      switch (pvalue->t)
      {
         /* request */
         case 1:
            stat = asn1PE_H245RequestMessage (pctxt, pvalue->u.request);
            if (stat != ASN_OK) return stat;
            break;

         /* response */
         case 2:
            stat = asn1PE_H245ResponseMessage (pctxt, pvalue->u.response);
            if (stat != ASN_OK) return stat;
            break;

         /* command */
         case 3:
            stat = asn1PE_H245CommandMessage (pctxt, pvalue->u.command);
            if (stat != ASN_OK) return stat;
            break;

         /* indication */
         case 4:
            stat = asn1PE_H245IndicationMessage (pctxt, pvalue->u.indication);
            if (stat != ASN_OK) return stat;
            break;

         default:
            return ASN_E_INVOPT;
      }
   }
   else {
      /* Encode extension choice index value */

      stat = encodeSmallNonNegWholeNumber (pctxt, pvalue->t - 5);
      if (stat != ASN_OK) return stat;

      /* Encode extension element data value */

   }

   return (stat);
}

