#include <unistd.h>
#include <math.h>


#include "globals.h"
#include "model.h"


void InitAsteroid(int asteroidNum)
{
  int x, y, z;
  int VertexNum;
  float color;

  AsteroidModels[asteroidNum]=(struct Model *)malloc(sizeof(struct Model));

  AsteroidModels[asteroidNum]->NumSides=8;

  AsteroidModels[asteroidNum]->Sides=(struct Triangle *)malloc(sizeof(struct Triangle)*8);

  AsteroidModels[asteroidNum]->Points=NULL;

  for (x=-1; x<2; x+=2) {
    for (y=-1; y<2; y+=2) {
      for (z=-1; z<2; z+=2) {
        VertexNum=(x*4+y*2+z+7)/2;

        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[0]=(struct Point *)malloc(sizeof(struct Point));
        AsteroidModels[asteroidNum]->Sides[VertexNum].VertexColors[0]=(struct Color *)malloc(sizeof(struct Color));
        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[0]->x=x;
        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[0]->y=0.0;
        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[0]->z=0.0;

        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[1]=(struct Point *)malloc(sizeof(struct Point));
        AsteroidModels[asteroidNum]->Sides[VertexNum].VertexColors[1]=(struct Color *)malloc(sizeof(struct Color));
        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[1]->x=0.0;
        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[1]->y=y;
        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[1]->z=0.0;

        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[2]=(struct Point *)malloc(sizeof(struct Point));
        AsteroidModels[asteroidNum]->Sides[VertexNum].VertexColors[2]=(struct Color *)malloc(sizeof(struct Color));
        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[2]->x=0.0;
        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[2]->y=0.0;
        AsteroidModels[asteroidNum]->Sides[VertexNum].Vertices[2]->z=z;
      }
    }
  }

  GenModelPoints(AsteroidModels[asteroidNum]);
  RandomizeModel(AsteroidModels[asteroidNum], 0.30);
  AddModelDetail(&AsteroidModels[asteroidNum]);
  RandomizeModel(AsteroidModels[asteroidNum], 0.60);
  RandomizeModelColors(AsteroidModels[asteroidNum]);
  AddModelDetail(&AsteroidModels[asteroidNum]);
  RandomizeModel(AsteroidModels[asteroidNum], 0.30);
  AddModelDetail(&AsteroidModels[asteroidNum]);
  ShrinkModel(AsteroidModels[asteroidNum], 1.0/FindFurthestPoint(AsteroidModels[asteroidNum]));
  ReCenterModel(AsteroidModels[asteroidNum]);
}
