#define MAX_PLAYERNAME_LENGTH 20
#define MAX_PLAYERS 32
#define MAX_FILENAME_SIZE 80
#define MAX_NAME_LENGTH 80
#define NUM_THREADS 5
#define NUM_GAME_TYPES 3
#define TRUE 1
#define FALSE 0
#define MAX_WORLD_WIDTH 65535
#define MAX_WORLD_HEIGHT 65535
#define MIN_WORLD_WIDTH 320
#define MIN_WORLD_HEIGHT 240
#define MAX_PORT_VALUE 65535
#define NUM_SHIP_PHASES 48
#define STATUS_SEND_TYPE 0
#define SHIP_SEND_TYPE 1
#define OBJ_SEND_TYPE 2
#define SOUND_SEND_TYPE 3
#define MAX_SHOTS 18
#define MAX_SHOT_SPEED 256
#define MAX_SLEEP_TIME 1000
#define MAX_OBJECTS 512
#define MAX_MODELS 255
#define SHIP_TYPE 1
#define SHOT_TYPE 2
#define ASTEROID_TYPE 3
#define EXPLOSION_TYPE 4
#define BIG_EXPLOSION_TYPE 5
#define SHIELD_POWERUP_TYPE 6
#define ARMOR_POWERUP_TYPE 7
#define NUKE_POWERUP_TYPE 8
#define HYPERWARP_POWERUP_TYPE 9
#define NUKE_TYPE 10
#define NUKE_EXPLOSION_TYPE 11
#define SINGLE_PLAYER 0
#define FREE_FOR_ALL 1
#define DEATHMATCH 2
#define MAX_PACKET_SIZE 2048
#define MAX_VOLUME 9
#define NUM_POWERUPS 4
#define MAX_TYPES 128

// Time in milliseconds between frames
#define FRAME_DELAY 20

#define NUM_STARS 500
#define MAX_MENU_ITEMS 50
#define MAX_ASTEROIDS 256

#define true 1
#define false 0


struct ControlStruct {
  char Fire;
  char Shield;
  char xForward;
  char xBackward;
  char yForward;
  char yBackward;
  char zForward;
  char zBackward;
  char xFRotate;
  char xBRotate;
  char yFRotate;
  char yBRotate;
  char zFRotate;
  char zBRotate;
  char Nuke;
  char Warp;
  char rView;
  char Score;
  char Quit;
};

struct Point {
  float x, y, z;
};

struct Color {
  float red, green, blue;
};

struct ModelPoint {
  struct Point point;
  struct Color color;
  struct ModelPoint *next;
};

struct Triangle {
  struct Point *Vertices[3];
  struct Color *VertexColors[3];
};

struct Model {
  int NumSides;
  struct Triangle *Sides;
  struct ModelPoint *Points;
};

struct Star {
  struct Point Position;
  struct Color StarColor;
};

struct ObjectDesc {
  int Type;
  int Number;
  struct Point Position;
  float Size;
  float RotationMatrix[3][3];
};

struct ShipDesc {
  int Type;
  int Number;
  int Score;
  int Lives;
  char ShieldOn;
  int Shield;
  int Armor;
  char Shaking;
  char Alive;
  char Nukes;
  char Warps;
  char Warping;
  struct Point Position;
  char PlayerName[MAX_PLAYERNAME_LENGTH];
  float Size;
  float RotationMatrix[3][3];
};

struct SoundStruct {
  char type;
  struct Point Position;
};

struct GameParametersStruct {
  char GameOn;
  short GameType;
  short MaxPlayers;
  short PlayerNum;
  float WorldWidth;
  unsigned int MaxShield;
  unsigned int MaxArmor;
};

struct PlayerActionStruct {
  bool shooting;
  bool shield;
};

struct KeyValuesStruct {
  char FireKey;
  char ShieldKey;
  char WarpKey;
  char NukeKey;
  char xForwardKey;
  char xBackwardKey;
  char yForwardKey;
  char yBackwardKey;
  char zForwardKey;
  char zBackwardKey;
  char xFRotateKey;
  char xBRotateKey;
  char yFRotateKey;
  char yBRotateKey;
  char zFRotateKey;
  char zBRotateKey;
};
