#include <math.h>

#include "globals.h"
#include "status.h"
#include "object.h"
#include "ship.h"
#include "screen.h"
#include "sizes.h"


void DrawRadarPoint(struct Point *Position, float Size,
                    struct Color *DarkColor, struct Color *LightColor, int type);


void DrawRadar()
{
  int i;

  DrawText(ScreenWidth/2-12, ScreenHeight/3, "Radar", &Green);
  DrawCircle(ScreenWidth/2, ScreenHeight/6, &Green, 64, 0.27, 0);

  for (i=0; i<MAX_PLAYERS; i++) {
    if (Ships[i] && i!=myShip && Ships[i]->Alive) {
      DrawRadarPoint(&Ships[i]->Position, Ships[i]->Size,
                     &DarkRed, &Red, 0);
    }
  }

  for (i=0; i<MAX_OBJECTS; i++) {
    if (Objects[i]) {
      if (Objects[i]->Type==ASTEROID_TYPE) {
        DrawRadarPoint(&Objects[i]->Position, Objects[i]->Size,
                       &Gray, &LightGray, 1);
      }
    }
  }

  DrawCircle(ScreenWidth/2, ScreenHeight/6, &Green, 64, 0.18, 3);
  DrawCircle(ScreenWidth/2, ScreenHeight/6, &Green, 64, 0.09, -1);
  DrawLine(ScreenWidth/2, ScreenHeight/6+5, ScreenWidth/2, ScreenHeight/6-5, &DarkRed);
  DrawLine(ScreenWidth/2+5, ScreenHeight/6, ScreenWidth/2-5, ScreenHeight/6, &DarkRed);
}


void DrawRadarPoint(struct Point *Position, float Size,
                    struct Color *DarkColor, struct Color *LightColor, int type)
{
  struct Point newPosition;
  struct Color *PointColor;
  int xpoint, ypoint;
  float Distance;

  CalcPosition(Position, &newPosition);
  CalcPointWithRotation(&newPosition);
  if (newPosition.z < 0.0) {
    PointColor=LightColor;
  } else {
    PointColor=DarkColor;
  }
  Distance=sqrt(newPosition.x*newPosition.x+newPosition.y*newPosition.y+
                newPosition.z*newPosition.z);
  xpoint=(int)(((newPosition.x/Distance)*0.26+1.0)*(float)(ScreenWidth/2));
  ypoint=(int)(((newPosition.y/Distance)*0.26+0.333)*(float)(ScreenHeight/2));
  Distance-=Size;

  if ((Distance < 6.0 && type==1) || (Distance < 10.0 && type==0)) {
    if (Distance > 2.5) {
      DrawPoint(xpoint, ypoint, PointColor);
    } else if (Distance > 1.0) {
      DrawPoint(xpoint, ypoint, PointColor);
      DrawPoint(xpoint+1, ypoint, PointColor);
      DrawPoint(xpoint, ypoint+1, PointColor);
      DrawPoint(xpoint+1, ypoint+1, PointColor);
    } else {
      DrawPoint(xpoint, ypoint, PointColor);
      DrawPoint(xpoint+1, ypoint, PointColor);
      DrawPoint(xpoint, ypoint+1, PointColor);
      DrawPoint(xpoint+1, ypoint+1, PointColor);
      DrawPoint(xpoint+2, ypoint, PointColor);
      DrawPoint(xpoint+2, ypoint+1, PointColor);
      DrawPoint(xpoint+1, ypoint+2, PointColor);
      DrawPoint(xpoint, ypoint+2, PointColor);
      DrawPoint(xpoint+1, ypoint+1, PointColor);
      DrawPoint(xpoint+2, ypoint+2, PointColor);
    }
  }
}
