#include <math.h>


#include "globals.h"
#include "sizes.h"
#include "object.h"
#include "screen.h"
#include "ship.h"


struct Star StarArray[NUM_STARS];
float ShakePos;
int ShakeTimer;


// Function to initialize star array
void InitStars()
{
  int i;
  float randfloat;
  float distance;

  ShakePos=0.15;
  ShakeTimer=0;

  for (i=0; i<NUM_STARS; i++) {
    randfloat=rand()%256+1;
    StarArray[i].StarColor.red=randfloat/256.0;
    randfloat=rand()%256+1;
    StarArray[i].StarColor.green=randfloat/256.0;
    randfloat=rand()%256+1;
    StarArray[i].StarColor.blue=randfloat/256.0;
    randfloat=rand()%256+1.0;
    StarArray[i].Position.x=randfloat/128.0-1.0;
    randfloat=rand()%256+1.0;
    StarArray[i].Position.y=randfloat/128.0-1.0;
    randfloat=rand()%256+1.0;
    StarArray[i].Position.z=randfloat/128.0-1.0;

    distance=StarArray[i].Position.x*StarArray[i].Position.x+
	     StarArray[i].Position.y*StarArray[i].Position.y+
	     StarArray[i].Position.z*StarArray[i].Position.z;
    distance=sqrt(distance);
    StarArray[i].Position.x=(StarArray[i].Position.x/distance)*15.0;
    StarArray[i].Position.y=(StarArray[i].Position.y/distance)*15.0;
    StarArray[i].Position.z=(StarArray[i].Position.z/distance)*15.0;
  }
}


void DrawStars()
{
  int i, j;
  float randfloat;
  struct Point newpoint;

  // Make stars flicker
  for (i=0; i<3; i++) {
    j=rand()%NUM_STARS;
    randfloat=rand()%256+1;
    StarArray[j].StarColor.red=randfloat/256.0;
    randfloat=rand()%256+1;
    StarArray[j].StarColor.green=randfloat/256.0;
    randfloat=rand()%256+1;
    StarArray[j].StarColor.blue=randfloat/256.0;
    randfloat=rand()%256+1.0;
  }

  if (Ships[myShip]->Shaking) {
    ShakeTimer++;
    if (ShakeTimer%2==0) {
      ShakePos*=-1.0;
    }
  }

  for (i=0; i<NUM_STARS; i++) {
    if (Ships[myShip]->Shaking) {
      DrawPoint(&StarArray[i].Position, &StarArray[i].StarColor, ShakePos, 0);
    } else {
      DrawPoint(&StarArray[i].Position, &StarArray[i].StarColor);
    }
  }
}
