#include <stdio.h>
#ifdef CYGWIN
#include <windows.h>
#else
#include <time.h>
#include <sys/time.h>
#endif

void InitTime();
unsigned long GetTimeElapsed();


#ifdef CYGWIN
double frequency;
unsigned long StartTime;
#else
struct timeval StartTime;
#endif


void InitTime()
{
#ifdef CYGWIN
  LARGE_INTEGER CpuFreq, TimeCount;

  QueryPerformanceFrequency(&CpuFreq);
  frequency = (double)CpuFreq.LowPart/1000000.0;
  QueryPerformanceCounter(&TimeCount);
  StartTime = TimeCount.LowPart;
#else
  struct timezone tz;

  gettimeofday(&StartTime, &tz);
#endif
}


// Gets the time elapsed from when the server started, in microseconds
unsigned long GetTimeElapsed()
{
#ifdef CYGWIN
  LARGE_INTEGER TimeCount;

  double TimeElapsed;

  QueryPerformanceCounter(&TimeCount);
  TimeElapsed=(double)(TimeCount.LowPart-StartTime)/frequency;
  return((unsigned long)TimeElapsed);
#else
  struct timezone tz;
  struct timeval now;

  gettimeofday(&now, &tz);

  return((now.tv_sec-StartTime.tv_sec)*1000000+
         (now.tv_usec-StartTime.tv_usec));
#endif
}
