#include "globals.h"
#include "input.h"
#include "fileutils.h"


int ScreenWidth, ScreenHeight;
char ServerIP[16];
int ServerPort;
char PlayerName[MAX_PLAYERNAME_LENGTH];
char ConfigFileName[80];


void ReadConfig();
void SetDefaults();
int GetWord(FILE *fileptr, char *Word, char EndOfWord, int MaxSize);
void AssignValue(char *VariableName, char *Value);
int IgnoreCommentsAndSpaces(FILE *fileptr, char *c);
void TerminateVariable(char *variable);
int GoToEndOfLine(FILE *fileptr);


// Function to read the configuration file
void ReadConfig()
{
  FILE *ConfigFile;

  SetDefaults();

  if (!(ConfigFile=fopen(ConfigFileName, "r"))) {
    return;
  }

  ReadVariables(ConfigFile, &AssignValue);

  fclose(ConfigFile);
}


void SetDefaults()
{
  ScreenWidth=640;
  ScreenHeight=480;
  strcpy(ServerIP, "127.0.0.1");
  ServerPort=12345;
  strcpy(PlayerName, "UnNamedPlayer");
  volume=MAX_VOLUME;
}


void AssignValue(char *VariableName, char *Value)
{
  int temp;

  if (!strcmp(VariableName, "SCREEN_WIDTH")) {
    temp=atoi(Value);
    if (temp >= 320 && temp <= 1600) {
      ScreenWidth=temp;
    }
  } else if (!strcmp(VariableName, "SCREEN_HEIGHT")) {
    temp=atoi(Value);
    if (temp >= 240 && temp <= 1200) {
      ScreenHeight=temp;
    }
  } else if (!strcmp(VariableName, "PLAYER_NAME")) {
    if (strlen(Value) < MAX_PLAYERNAME_LENGTH && strlen(Value)) {
      strcpy(PlayerName, Value);
    }
  } else if (!strcmp(VariableName, "SERVER_IP")) {
    strcpy(ServerIP, Value);
  } else if (!strcmp(VariableName, "SERVER_PORT")) {
    ServerPort=atoi(Value);
  } else if (!strcmp(VariableName, "VOLUME")) {
    volume=atoi(Value);
  } else if (!strcmp(VariableName, "SCORE_KEY")) {
    controls.Score=*Value;
  } else if (!strcmp(VariableName, "FIRE_KEY")) {
    controls.Fire=*Value;
  } else if (!strcmp(VariableName, "SHIELD_KEY")) {
    controls.Shield=*Value;
  } else if (!strcmp(VariableName, "WARP_KEY")) {
    controls.Warp=*Value;
  } else if (!strcmp(VariableName, "NUKE_KEY")) {
    controls.Nuke=*Value;
    /*
      } else if (!strcmp(VariableName, "X_FORWARD_KEY")) {
      controls.xForward=*Value;
      } else if (!strcmp(VariableName, "X_BACKWARD_KEY")) {
      controls.xBackward=*Value;
      } else if (!strcmp(VariableName, "Y_FORWARD_KEY")) {
      controls.yForward=*Value;
      } else if (!strcmp(VariableName, "Y_BACKWARD_KEY")) {
      controls.yBackward=*Value;
    */
  } else if (!strcmp(VariableName, "Z_FORWARD_KEY")) {
    controls.zForward=*Value;
  } else if (!strcmp(VariableName, "Z_BACKWARD_KEY")) {
    controls.zBackward=*Value;
  } else if (!strcmp(VariableName, "X_FORWARD_ROTATE_KEY")) {
    controls.xFRotate=*Value;
  } else if (!strcmp(VariableName, "X_BACKWARD_ROTATE_KEY")) {
    controls.xBRotate=*Value;
  } else if (!strcmp(VariableName, "Y_FORWARD_ROTATE_KEY")) {
    controls.yFRotate=*Value;
  } else if (!strcmp(VariableName, "Y_BACKWARD_ROTATE_KEY")) {
    controls.yBRotate=*Value;
  } else if (!strcmp(VariableName, "Z_FORWARD_ROTATE_KEY")) {
    controls.zFRotate=*Value;
  } else if (!strcmp(VariableName, "Z_BACKWARD_ROTATE_KEY")) {
    controls.zBRotate=*Value;
  } else if (!strcmp(VariableName, "REVERSE_VIEW_KEY")) {
    controls.rView=*Value;
  } else if (!strcmp(VariableName, "QUIT_KEY")) {
    controls.Quit=*Value;
  }
}


// Save Configuration to a file
void SaveConfig()
{
  FILE *ConfigFile;

  if (!(ConfigFile=fopen(ConfigFileName, "w"))) {
    return;
  }

  fprintf(ConfigFile, "SERVER_IP=%s\n", ServerIP);
  fprintf(ConfigFile, "SERVER_PORT=%d\n", ServerPort);
  fprintf(ConfigFile, "PLAYER_NAME=%s\n", PlayerName);
  fprintf(ConfigFile, "SCREEN_WIDTH=%d\n", ScreenWidth);
  fprintf(ConfigFile, "SCREEN_HEIGHT=%d\n", ScreenHeight);
  fprintf(ConfigFile, "VOLUME=%d\n", volume);
  fprintf(ConfigFile, "SCORE_KEY=%c\n", controls.Score);
  fprintf(ConfigFile, "FIRE_KEY=%c\n", controls.Fire);
  fprintf(ConfigFile, "SHIELD_KEY=%c\n", controls.Shield);
  fprintf(ConfigFile, "WARP_KEY=%c\n", controls.Warp);
  fprintf(ConfigFile, "NUKE_KEY=%c\n", controls.Nuke);
  fprintf(ConfigFile, "QUIT_KEY=%c\n", controls.Quit);
  /*
    fprintf(ConfigFile, "X_FORWARD_KEY=%c\n", controls.xForward);
    fprintf(ConfigFile, "X_BACKWARD_KEY=%c\n", controls.xBackward);
    fprintf(ConfigFile, "Y_FORWARD_KEY=%c\n", controls.yForward);
    fprintf(ConfigFile, "Y_BACKWARD_KEY=%c\n", controls.yBackward);
  */
  fprintf(ConfigFile, "Z_FORWARD_KEY=%c\n", controls.zForward);
  fprintf(ConfigFile, "Z_BACKWARD_KEY=%c\n", controls.zBackward);
  fprintf(ConfigFile, "X_FORWARD_ROTATE_KEY=%c\n", controls.xFRotate);
  fprintf(ConfigFile, "X_BACKWARD_ROTATE_KEY=%c\n", controls.xBRotate);
  fprintf(ConfigFile, "Y_FORWARD_ROTATE_KEY=%c\n", controls.yFRotate);
  fprintf(ConfigFile, "Y_BACKWARD_ROTATE_KEY=%c\n", controls.yBRotate);
  fprintf(ConfigFile, "Z_FORWARD_ROTATE_KEY=%c\n", controls.zFRotate);
  fprintf(ConfigFile, "Z_BACKWARD_ROTATE_KEY=%c\n", controls.zBRotate);
  fprintf(ConfigFile, "REVERSE_VIEW_KEY=%c\n", controls.rView);

  fclose(ConfigFile);
}
