#include <time.h>
#include <sys/time.h>
#include <unistd.h>


#include "globals.h"
#include "star.h"
#include "sizes.h"
#include "network.h"
#include "netvariables.h"
#include "readserverthread.h"
#include "blit.h"
#include "timevar.h"
#include "thread.h"
#include "object.h"
#include "ship.h"
#include "screen.h"


int BoomDelay;
int NextBoom;
int BoomPhase;
pthread_t readthread;
int GameStop;


void NewGame();
void RunGame();
void DoHouseKeeping();
void InitGame();


void NewGame()
{
  struct timezone tz;

  // Connect to game server
  if (ConnectServer()) {
    return;
  }

  InitGame();

  gettimeofday(&LastTime, &tz);
  gettimeofday(&UpdateTime, &tz);
}


void RunGame()
{
  ClearScreen();
  Setup3dMode();

  if (Ships[myShip]) {
    DrawStars();
  }

  RunFrame();

  UpdateScreen();
}


void InitGame()
{
  int i, rc;

  GameStop=0;
  ShowScore=0;
  ReverseView=0;

  pthread_mutex_lock(&ClientLock);

  // Create a thread to listen for data from the server and update game data
  if (rc = pthread_create(&readthread, NULL, ReadServerThread,
			  (void *)svrsock)) {
    printf("ERROR, return code from pthread_create() is %d\n", rc);
    pthread_exit(NULL);
  }

  BoomDelay = 800/FRAME_DELAY;
  NextBoom = BoomDelay;
  BoomPhase = 0;
}
