#include <time.h>

#include "globals.h"
#include "configuration.h"
#include "serverconfig.h"
#include "sizes.h"
#include "sound.h"
#include "init.h"
#include "score.h"
#include "server.h"
#include "object.h"
#include "screen.h"


void PrintUsage(char *progname)
{
  printf("\nUsage: %s -cf Configuration_Filename\n", progname);
  exit(1);
}


int main(int argc, char *argv[])
{
  int i;
  int DedicatedServer=false;

  // Seed the random number generator
  srand(time(NULL));

  // Setup Configuration Files
  SetupConfiguration();

  // Parse command line arguments
  for (i=1; i<argc; i++) {
    if (!strcmp(argv[i], "-cf")) {
      i++;
      if (argv[i]) {
	strcpy(ConfigFileName, argv[i]);
      }
    } else if (!strcmp(argv[i], "-scf")) {
      i++;
      if (argv[i]) {
	strcpy(ServerConfigFileName, argv[i]);
      }
    } else if (!strcmp(argv[i], "-ds")) {
      DedicatedServer=true;
    } else {
      PrintUsage(argv[0]);
    }
  }

  ReadServerConfig(ServerConfigFileName);
  if (DedicatedServer) {
    Server((void *)1);
  }

  ReadConfig();

  initsound(&argc, argv);

  DoInitializations();

  playsound(NewLifeSound);

  StartGame();
}
